package com.geoway.landteam.landcloud.servface.user;

import com.geoway.landteam.customtask.task.entity.NoticeTopic;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserAddInfo;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserUpdateInfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.ImportUserResultInfo;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @Author: zhenkaining
 * @Date: 2020/6/11 11:36
 * @Description:
 */
public interface MIUserManageService {
    /**
     * 通过Excel批量导入用户
     *
     * @param filePath Excel文件路径
     * @param userId   用户id
     */
    public List<ImportUserResultInfo> HomesteadImportUserBatch(String filePath, Long userId) throws IOException, InvalidFormatException;

    /**
     * 用户编辑 修改用户业务权限
     * @param userInfo
     * @param currentUserid
     */
    public void modifyUserBiz(UserUpdateInfo userInfo, Long currentUserid);

    public void updateUserBiz(UserUpdateInfo userInfo);
    /**
     * 用户新增 赋予用户业务权限
     * @param userInfo
     */
    public void addUserBiz(UserAddInfo userInfo);

    /**
     * 获取用户任务角色
     */
    public Map<String,Object> getRoleByUseridAndBizid(Long userId, String bizId);

    /**
     * 新消息通知订阅
     */
    public void saveNoticeTopicAndNoticeSub(String region, String userId, String bizs, Integer role);

    public List<String> getRegionList(String region);

    /**
     * topic设置省市县乡信息
     */
    public NoticeTopic setRegionDetail(NoticeTopic noticeTopic, String region);
}
