package com.geoway.landteam.landcloud.servface.zhdd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.model.oauth.AuthUserInfo;
import com.geoway.landteam.landcloud.model.zhdd.dto.*;
import com.geoway.landteam.landcloud.model.zhdd.entity.*;
import org.locationtech.jts.io.ParseException;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @projectName: geoway-landcloud-cq
 * @package: com.geoway.landteam.landcloud.servface.zhdd
 * @className: TbtskDispatchService
 * @author: limihao
 * @description: TODO
 * @date: 2024/6/17 17:40
 * @version: 1.0
 */
public interface TbtskDispatchService {

     void runDataAssign()  throws Exception;

    /**
     * 获取大屏业务矿山预警年份下拉框数据
     * @return
     */
    List<Object> findKsjcYear();

    /**
     * 获取市县镇三级数据
     * @return
     */
    Map findHbRegionData();

    /**
     * 按年份统计视频告警线索数据
     * @param year
     * @return
     */
    Map<String,Object> statisticsKsDataByYear(String year);

    /**
     * 根据条件查询矿山管理数据信息
     * @param dataType
     * @param nodeType
     * @param name
     * @return
     * @throws java.text.ParseException
     */
    List<Map<String,Object>> findKsManageDataByParam(String dataType,String nodeType,String name) throws java.text.ParseException;

    /**
     * 获取所有矿山管理数据
     * @return
     * @throws java.text.ParseException
     */
    List<Map<String,Object>> findAllKsManageData() throws java.text.ParseException;

    /**
     * 获取矿山管理数据详情
     * @param id
     * @return
     * @throws java.text.ParseException
     */
    Map<String,Object> getKsManageDataDetail(String id) throws java.text.ParseException;

    /**
     * 获取矿山管理数据树
     * @param name
     * @return
     */
    List<KsManageData> ksManageDataTree(String name);

    /**
     * 获取主页统计
     * @return
     */
    Map<String,Object> ktdMainstatistics();

    List<Map<String, Object>> statisticsBusinessDataByClassIdAndTaskId(String classId, String taskId) throws Exception;
    List<SumRegionTaskDispatch> sumTaskTbGroupByRegion(String taskId, String regionCode) throws Exception;
    JSONObject getTaskTbInfo(String taskId, String regionCode, String tbbh, Integer page, Integer limit,String userId) throws Exception;
    List<TbtskDispatchTbTemp> getShpList(MultipartFile multipartFile,String userId) throws Exception;

    TbtskDispatchTbTemp getDrawList(String wkt,String userId) throws Exception;

    void deleteTbTemp(String tempId);

    void deleteDispatchTb(String tbid) throws Exception;

    TbtskDispatchRecord createTask(DispatchCreateInfo createInfo) throws Exception;

    JSONObject getTaskTbList(DispatchTbSearchInfo searchInfo,Integer page,Integer limit) throws ParseException;

    DispatchResultDto curretTbDdJl(String tbid) throws Exception;

    TbtskDispatchInfo setDispatchInfo(DispatchTbInfo dispatchInfo) throws Exception;

    List<TbtskDispatchInfo> searchUnDispatchInfo(String dispathcId);

    void batchSaveDispatchInfo(String jsonStr);

    void saveTbJl(String tbid,String zyyid,String ddjl,String ddyj, MultipartFile [] files,String ddr) throws Exception;

    /**
     * 当前调度任务计划下达
     * @param userInfo
     * @param ddid
     */
    Integer planTaskAssign(AuthUserInfo userInfo, String ddid) throws IllegalStateException;

    void setDispatchInfo(MultipartFile multipartFile,String dispatchId) throws Exception;

    JSONObject getTaskList(DispatchTaskSearchInfo searchInfo, Integer page, Integer limit);

    List<Map<String,Object>> getTbDdls(String tbid) throws Exception;

    JSONObject getDispatchTbDetialInfo(String tbid) throws Exception;

    void exportDispatchExcel(HttpServletResponse response, String dispatchId) throws IOException;

    void exportDispatchShp(HttpServletResponse response, String dispatchId) throws IOException;

    void exportDispatchPackage(HttpServletResponse response, String dispatchId) throws IOException;

    JSONArray getNearByDron(Double lon, Double lat, Double distance) throws Exception;

    JSONArray getNearByCamera(Double lon, Double lat, Double distance)throws Exception;

    List<OnlineUserInfo> getNearByUser(String name,Double lon, Double lat, Double distance)throws Exception;

    JSONObject getPageNearUser(String name,Double lon, Double lat, Double distance,Integer page,Integer limit)throws Exception;

    JSONObject getAllOnlineDron(String name) throws Exception;

    JSONObject getAllOnlineCamera(String name)throws Exception;

    JSONObject getPageOnlineUser(String name,Integer page,Integer limit)throws Exception;

    JSONObject getAllOnlineUser(String name);

    OnlineUserInfo getUserInfo(Long userId);

    JSONObject getCameraVideoRealtimeUrl(String channelCode,String deviceCode) throws Exception;

    String getCameraUrl(String channelCode,String deviceCode) throws Exception;

    JSONArray getDronCapacity() throws Exception;

    JSONObject startDronLive(JSONObject param) throws Exception;

    JSONObject stopDronLive(JSONObject param) throws Exception;

    JSONArray getWaylinesCalcRange(JSONObject param) throws Exception;

    JSONObject getWaylinesJob(String jobId) throws Exception;

    JSONObject createDronWaylinesJobs(LineJobParamDetailInfo detail)throws Exception;
    JSONArray getJobLine(String jobId) throws Exception;

    void stopDronJob(String workspaceId,String jobId) throws Exception;

    void restartDronJob(String workspaceId,String jobId) throws Exception;

    void returnHomeDron(String deviceSn) throws Exception;

    void cancleReturnHomeDron(String deviceSn) throws Exception;

    TbtskDispatchUser stopDispatch(DispatchResultInfo resultInfo) throws Exception;

    List<TbtskDispatchAttach> uploadAttach(MultipartFile[] files, String tbid) throws Exception;

    JSONObject getDispatchResult(String tbid);

    void deleteAttach(String attachId);

    //设置用户调度录屏
    void setUserDispatchRecord(JSONObject json);

}
