package com.geoway.landteam.landcloud.service.attachpush;


import cn.hutool.crypto.SmUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
//import com.geoway.land.core.cloud.Enum.DefaultBusinessPrevillageEnum;
//import com.geoway.land.core.cloud.domain.SysConfig;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.service.util.HttpUtil;
import com.geoway.landteam.landcloud.service.util.MyX509TrustManager;
import com.geoway.landteam.landcloud.service.util.code.SM2SignVO;
import com.geoway.landteam.landcloud.service.util.code.SM2SignVerUtils;
import com.geoway.landteam.landcloud.service.util.code.SM3Utils;
import com.geoway.landteam.landcloud.service.util.code.Util;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.gw.base.log.GwLoger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
//import org.apache.log4j.Logger;
import com.gw.base.log.GiLoger;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.*;


/**
 * FileName: AttachPushCgkService.java
 * Author:   chenhao
 * Date:     2025/8/20 10:00
 * Description: 附件推送成果库
 */
@Service
public class AttachPushCgkService {

//    Logger logger = Logger.getLogger(AttachPushCgkService.class);
    private final GiLoger logger = GwLoger.getLoger(AttachPushCgkService.class);

    //证书Base64密文
    private static final String GTDCY_CERT_CODE = "1D5BC394E7454BB4B56D808911463460";
    // 公钥
    private static final String GTDCY_PUBLICKEY = "04D964FD6AE472FC3367C09935DEBFC9A613F6F084ED8CA5B4C2EBF0E9F9FA5146E1631B842FED8FD55B488674C37B5FE695A49EE5A52BBEEA0868C2E816E5C47C";
    // 私钥
    private static final String GTDCY_PRIVATEKEY = "93EF84E31C27016FBAF3DED662E2C5F47B7941EFA6533E1A113C9F2E8816FB19";

    //证书Base64密文
//    private static final String CERT_CODE = "D6751AE5360334DFCE0DA806421F2404";
//  邢台 证书Base64密文
    private static final String CERT_CODE = "80F4D5259AB5B1E4A948A78D403BEE49";

    // 公钥
//    private static final String PUBLIC_KEY = "04c66582dd017b40f853eeeb9d305687698b1392ee8500d7ae64b1ee7eee7f167ca68a23c7bb6c6477b242660427d8092795bade95f2572af188b47f10e5019d99";
//  邢台 公钥
    private static final String PUBLIC_KEY = "0424c41d39bdab51ae8c12139d530420ff14b4e5683d07541187abc6c912c4bf563078673e3498aa488443582cdaad0c6f433d139c13607882436d160c5db2dca5";
    // 私钥
//    private static final String PRIVATE_KEY = "d2f7d61f9e54cc73c5b0523db7e2e23ba7d1bebd2c840dddbbe7af93b75b4064";
//   邢台 私钥
    private static final String PRIVATE_KEY = "e4738d11f0fd0c2bcff9b339a73a8e72e5f670fe3cc2980093feef140789d682";

//    01	年度变更调查
//    02	日常变更调查
//    03	土地卫片执法
//    04	耕地保护监督
//    05	网络舆情监测
//    06	农村住房调查
//    07	设施农用地监测
//    08	耕地占卜平衡监管
//    09	矿产资源监测
//    10	水资源调查
//    11	城市空间监测
//    private static final String YWLX = "04"; //耕地保护监督
    private static final String YWLX = "03"; //土地卫片执法

    // 市行政区编码
//    private static final String DEFAULT_XZQDM = "130400";
    private static final String DEFAULT_XZQDM = "130500"; //河北省邢台市行政区编码

    private static final String SIGN_API = "/artifact/api/storage/v1/third/writeUrl";
    private static final String PUSH_ITEM_API = "/artifact/api/media/v1/third/item";
    private static final String PUSH_ITEMS_API = "/artifact/api/media/v1/third/items";
    private static final String PUSH_SPOT_API = "/artifact/api/spot/v1/third/item";

    private static final String JOB_KEY = "job_rateWriteCgk";

    @Autowired
    RedisTemplate redisTemplate;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    SysConfigService sysConfigService;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    public void rateWriteCgk() {
        this.rateWriteCgk(null);
    }

//    public void rateWriteCgk(String tbid) { // 图斑id
    public void rateWriteCgk(String taskId) { // 任务id

        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        logger.error("JobRunTask-rateWriteGxkSpots  成果库信息插入开始执行" + df.format(new Date()));
        JSONArray res = new JSONArray();
        try {
            Boolean aBoolean = redisTemplate.hasKey(JOB_KEY + taskId);
            if (aBoolean) {
                logger.error("JobRunTask-rateWriteGxkSpots  成果库信息插入正在执行" + df.format(new Date()));
                return;
            }
            Boolean aBoolean1 = redisTemplate.opsForValue().setIfAbsent(JOB_KEY + taskId, new Date());
            if (!aBoolean1) {
                logger.error("JobRunTask-rateWriteGxkSpots  成果库信息插入正在执行中" + df.format(new Date()));
                return;
            }


//            String sql = "SELECT DISTINCT f_galleryid,f_bizid FROM tb_app_media WHERE (f_ispush is null or f_ispush = 0)  and f_serverpath like 'http://111.62.17.206:9000%' limit 100";
//            String sql2 = "SELECT f_id AS ID,f_id as fjbsm, f_type AS fileType, f_lon AS longitude, f_lat AS latitude, f_azimuth :: NUMERIC AS azimuth, f_videorecord AS videorecord," +
//                    " f_serverpath AS serverPath, f_mediasize AS fileSize, f_username AS userName, f_device_source AS device,  case when f_time like '202_-%' then f_time else to_char( to_timestamp( to_number( f_time, '9999999999' ) ) :: DATE, 'YYYY-MM-dd HH:mm:ss' ) end AS photoTime," +
//                    " f_sm3 AS sm3, NULL AS modifyInfo,   case when f_time like '202_-%' then f_time else to_char( to_timestamp( to_number( f_time, '9999999999' ) ) :: DATE, 'YYYY-MM-dd HH:mm:ss' ) end AS createTime, 0 AS focal35mm, CASE WHEN f_psaltitude NOTNULL THEN f_psaltitude ELSE 39.0 END AS jdgd," +
//                    " CASE WHEN f_pitch NOTNULL AND TRIM ( f_pitch ) <> '' THEN f_pitch :: NUMERIC ELSE 0 END AS pitch, case when f_psgd is null then 1.7 else f_psgd end AS psgd, 0 AS roll, NULL AS verifycode, NULL AS zsdm, 2 AS viewType, '04' AS ywlx, " +
//                    " CASE WHEN f_serverpath NOTNULL THEN SUBSTRING ( f_serverpath FROM '([^/?]+)[/?]?$' ) ELSE NULL END AS fileName, 1920 AS dimHeight, 1080 AS dimWidth,f_jym as verifycode,null as modifyInfo " +
//                    " FROM tb_app_media WHERE f_galleryid = ?   and f_serverpath like 'http://111.62.17.206:9000%' ";

//            if (StringUtils.isNotEmpty(tbid)) {
//                sql += " and f_galleryid='" + tbid + "'";
//            }

            String sql = "SELECT DISTINCT f_galleryid,f_bizid FROM tb_app_media WHERE (f_ispush is null or f_ispush = 0) and f_bizid is not null ";
            if (StringUtils.isNotEmpty(taskId)) {
                sql += " and f_bizid= ?";
//              查询数据的图斑id  测试使用
//                sql += " and f_galleryid= ?";
            }
            sql += " limit 500 ";


            String sql2 = "SELECT f_id AS ID,f_id as fjbsm, f_type AS fileType, f_lon AS longitude, f_lat AS latitude, f_azimuth :: NUMERIC AS azimuth,  case when (f_videorecord notnull and f_videorecord<>'')then f_videorecord else null end as videorecord, " +
                    " f_serverpath AS serverPath, f_mediasize AS fileSize, f_username AS userName, f_device_source AS device,  case when f_time like '202_-%' then f_time else to_char( to_timestamp( to_number( f_time, '9999999999' ) ) :: DATE, 'YYYY-MM-dd HH:mm:ss' ) end AS photoTime," +
                    " f_sm3 AS sm3, NULL AS modifyInfo,   case when f_time like '202_-%' then f_time else to_char( to_timestamp( to_number( f_time, '9999999999' ) ) :: DATE, 'YYYY-MM-dd HH:mm:ss' ) end AS createTime, 0 AS focal35mm, CASE WHEN f_psaltitude NOTNULL THEN f_psaltitude ELSE 39.0 END AS jdgd," +
                    " CASE WHEN f_pitch NOTNULL AND TRIM ( f_pitch ) <> '' THEN f_pitch :: NUMERIC ELSE 0 END AS pitch, case when f_psgd is null then 1.7 else f_psgd end AS psgd, 0 AS roll, NULL AS verifycode, NULL AS zsdm, 2 AS viewType, '04' AS ywlx, " +
                    " CASE WHEN f_serverpath NOTNULL THEN SUBSTRING ( f_serverpath FROM '([^/?]+)[/?]?$' ) ELSE NULL END AS fileName, 1920 AS dimHeight, 1080 AS dimWidth,f_jym as verifycode,null as modifyInfo " +
                    " FROM tb_app_media WHERE f_bizid = ?  and f_bizid is not null ";
//                查询数据的图斑id  测试使用
//                    " FROM tb_app_media WHERE f_galleryid = ?  and f_bizid is not null ";


//            List<Map<String, Object>> results = jdbcTemplate.queryForList(sql);

            List<Map<String, Object>> results = jdbcTemplate.queryForList(sql, taskId);

            logger.error("JobRunTask-rateWriteGxkSpots  成果库信息插入result=" + results.size() + "条" + df.format(new Date()));
            System.out.println("JobRunTask-rateWriteGxkSpots  成果库信息插入result=" + results.size() + "条" + df.format(new Date()));
            Map<String, TskTaskBiz> bizsCache = new HashMap<>();
            Map<String, TbtskObjectinfo> objectCache = new HashMap<>();

            String api = PUSH_ITEMS_API;
            StringEntity stringEntity = null;

            if (ObjectUtils.isNotEmpty(results)) {

                for (Map<String, Object> result : results) {
                    String f_galleryid = MapUtils.getString(result, "f_galleryid", "");

                    try {
    //                    String f_bizid = MapUtils.getString(result, "f_bizid", DefaultBusinessPrevillageEnum.XUN_CHA_REN_WU.getId());
                        String f_bizid = MapUtils.getString(result, "f_bizid", "");

                        logger.error("JobRunTask-rateWriteGxkSpots  成果库信息插入f_galleryid=" + f_galleryid + ";f_bizid=" + f_bizid + ";time=" + df.format(new Date()));
                        System.out.println(new String(("JobRunTask-rateWriteGxkSpots  成果库信息插入f_galleryid=" + f_galleryid + ";f_bizid=" + f_bizid + ";time=" + df.format(new Date())).getBytes(StandardCharsets.UTF_8)));

                        TskTaskBiz biz = null;
                        TbtskObjectinfo objectinfo = null;
                        if (bizsCache.containsKey(f_bizid)) {
                            biz = bizsCache.get(f_bizid);
                        } else {
                            biz = tskTaskBizService.findByTaskId(f_bizid);
                            bizsCache.put(f_bizid, biz);
                        }
                        if (null != biz) {
                            if (objectCache.containsKey(f_bizid)) {
                                objectinfo = objectCache.get(f_bizid);
                            } else {
                                objectinfo = tskTaskBizService.getTableByTableId(biz.getTableId());
                                objectCache.put(f_bizid, objectinfo);
                            }

                        }

                        List<Map<String, Object>> mediaList = null;
                        if (null == biz) {//无任务情况
                            logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入查询附件1");

                            mediaList = getMediaList(jdbcTemplate.queryForList(sql2, f_galleryid), f_galleryid, "邯郸耕地保护", f_bizid);
                            logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入查询附件1，size=" + mediaList.size());

                            stringEntity = new StringEntity(JSONArray.toJSONString(mediaList), StandardCharsets.UTF_8);
                        } else if (null == objectinfo) {
                            logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入查询附件2");

                            mediaList = getMediaList(jdbcTemplate.queryForList(sql2, f_galleryid), f_galleryid, biz.getName(), f_bizid);
                            logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入查询附件2,siez=" + mediaList.size());

                            stringEntity = new StringEntity(JSONArray.toJSONString(mediaList), StandardCharsets.UTF_8);
                        } else {
                            logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入查询附件3");

                            mediaList = getMediaList(jdbcTemplate.queryForList(sql2, f_galleryid), f_galleryid, biz.getName(), f_bizid);
                            logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入查询附件3,siez=" + mediaList.size());


    //                        List<Map<String, Object>> tbItems = jdbcTemplate.queryForList("select *,st_astext(f_shape) as wkt from " + objectinfo.getfTablename() + " where f_id='" + f_galleryid + "'");

                            String selectSql = "";
                            // 是否存在子任务表
                            if (StringUtils.isNotBlank(objectinfo.getSplitTableName())) {
                                selectSql = "select *,st_astext(f_shape) as wkt from " + objectinfo.getfTablename() + " where f_id= '" + f_galleryid + "'\n" +
                                        "union all \n" +
                                        "select *,st_astext(f_shape) as wkt from tbtsk_task_znglrw_20250224140232409_child where f_id= '" + f_galleryid + "' ";
                            } else {
                                selectSql = "select *,st_astext(f_shape) as wkt from  " + objectinfo.getfTablename() + "  where f_id= '" + f_galleryid + "'";
                            }
                            List<Map<String, Object>> tbItems = jdbcTemplate.queryForList(selectSql);

                            logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入查询图斑3,siez=" + tbItems.size());

    //                        if (CollectionUtils.isEmpty(tbItems) && StringUtils.isNotEmpty(objectinfo.getSplitTableName())) {
    //                            try {
    //                                tbItems = jdbcTemplate.queryForList("select *,st_astext(f_shape) as wkt from " + objectinfo.getSplitTableName() + " where f_id='" + f_galleryid + "'");
    //                                logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入查询图斑4,siez=" + tbItems.size());
    //                            }catch (Exception e){
    //                                logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入查询图斑失败4,siez=" + tbItems.size());
    //                            }
    //
    //                        }

                            if (CollectionUtils.isNotEmpty(tbItems)) {
                                api = PUSH_SPOT_API;

                                String xzqdm = "";
                                String xzqmc = "";
                                String tbbh = "";
                                String bsm = "";
                                String tbmc = "";
                                String tbmj = "0.0";
                                String lon = "0.0";
                                String lat = "0.0";
                                String geometry = null;
                                String remark = "";
                                JSONObject extra = new JSONObject();
                                String surveyUser = "";
                                String surveyTime = "";

                                Map<String, Object> curItem = tbItems.get(0);


                                for (Object key : curItem.keySet()) {
                                    try {
                                        if (key == null || curItem.get(key) == null) continue;
                                        if (key.toString().equalsIgnoreCase("f_xzqdm") && curItem.get(key) != null) {
                                            xzqdm = curItem.get(key).toString();
                                            if (xzqdm.length() > 6) {
                                                xzqdm = xzqdm.substring(0, 6);
                                            }
                                        } else if ((key.toString().equalsIgnoreCase("f_xzqmc_n1") || key.toString().equalsIgnoreCase("f_xzqmc1")) && curItem.get(key) != null) {
                                            xzqmc = curItem.get(key).toString();
                                        } else if (key.toString().equalsIgnoreCase("f_tbbh") && curItem.get(key) != null) {
                                            tbbh = curItem.get(key).toString();
                                        } else if (key.toString().equalsIgnoreCase("f_bsm") && curItem.get(key) != null) {
                                            bsm = curItem.get(key).toString();
                                        } else if (key.toString().equalsIgnoreCase("f_tbmc") && curItem.get(key) != null) {
                                            tbmc = curItem.get(key).toString();
                                        } else if (key.toString().equalsIgnoreCase("f_tbmj") && curItem.get(key) != null) {
                                            tbmj = curItem.get(key).toString();
                                        } else if (key.toString().equalsIgnoreCase("f_lon") && curItem.get(key) != null) {
                                            lon = curItem.get(key).toString();
                                        } else if (key.toString().equalsIgnoreCase("f_lat") && curItem.get(key) != null) {
                                            lat = curItem.get(key).toString();
                                        } else if (key.toString().equalsIgnoreCase("wkt") && curItem.get(key) != null) {
                                            geometry = curItem.get(key).toString();
                                        } else if (key.toString().equalsIgnoreCase("f_remark") && curItem.get(key) != null) {
                                            remark = curItem.get(key).toString();
                                        } else if (key.toString().equalsIgnoreCase("f_submit_userid") && curItem.get(key) != null) {
                                            String userid = curItem.get(key).toString();
                                            sql = "select f_rname from tbsys_user where f_userid=" + userid;
                                            List<Map<String, Object>> userItems = jdbcTemplate.queryForList(sql);
                                            surveyUser = userItems.get(0).get("f_rname").toString();
                                        } else if (key.toString().equalsIgnoreCase("f_committime") && curItem.get(key) != null) {
                                            String commitTime = curItem.get(key).toString();
                                            Date date = new Date(Long.valueOf(commitTime));
                                            surveyTime = df.format(date);
                                        } else if (key.toString().equalsIgnoreCase("f_shape") || key.toString().equalsIgnoreCase("f_shape1") || key.toString().equalsIgnoreCase("f_shape_b") || key.toString().equalsIgnoreCase("f_lat_b")
                                                || key.toString().equalsIgnoreCase("f_lon_b") || key.toString().equalsIgnoreCase("f_shape_g") || key.toString().equalsIgnoreCase("f_lat_g")
                                                || key.toString().equalsIgnoreCase("f_lon_g") || key.toString().equalsIgnoreCase("f_wyryqm") || key.toString().equalsIgnoreCase("f_grqm")) {
                                            continue;
                                        } else {
                                            extra.put(key.toString(), curItem.get(key));
                                        }
                                    } catch (Exception lsEx) {
                                        System.out.println(lsEx.getMessage());
                                    }
                                }

                                if (StringUtils.isNotEmpty(xzqdm)) {
                                    String finalXzqdm = xzqdm;
                                    mediaList.forEach(item -> item.put("xzqdm", finalXzqdm));
                                }
                                JSONObject tbinfo = new JSONObject();
                                tbinfo.put("xzqdm", xzqdm);
                                tbinfo.put("xzqmc", xzqmc);
                                tbinfo.put("tbbh", tbbh);
                                tbinfo.put("bsm", org.apache.commons.lang.StringUtils.isNotEmpty(bsm) ? bsm : f_galleryid);
                                tbinfo.put("tbmc", tbmc);
                                tbinfo.put("tbmj", Double.parseDouble(tbmj));
                                tbinfo.put("lon", Double.parseDouble(lon));
                                tbinfo.put("lat", Double.parseDouble(lat));
                                tbinfo.put("remark", remark);
                                tbinfo.put("wkt", geometry == null ? null : geometry.toString());
                                tbinfo.put("surveyTime", surveyTime);
                                tbinfo.put("surveyUser", surveyUser);
                                tbinfo.put("extra", extra);

                                tbinfo.put("ywlx", YWLX);
                                tbinfo.put("taskid", f_bizid);
                                tbinfo.put("taskName", biz.getName());
                                tbinfo.put("origin", 2); // 数据来源 0 国家 1省 2市
                                tbinfo.put("medias", mediaList);

                                logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入图斑处理结束,siez=" + tbItems.size());

                                System.out.println(tbinfo.toJSONString());
                                stringEntity = new StringEntity(tbinfo.toJSONString(), StandardCharsets.UTF_8);
                            } else {
                                logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入图斑无" + tbItems.size());
                                stringEntity = new StringEntity(JSONArray.toJSONString(mediaList), StandardCharsets.UTF_8);
                                logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入图斑无1" + tbItems.size());

                            }
                        }
                        System.out.println(stringEntity.toString());
                        logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入图斑stringEntity=" + stringEntity.toString());
                        JSONObject jsonObject = doPost(api, stringEntity);
                        if (jsonObject.containsKey("status") && "true".equalsIgnoreCase(jsonObject.getString("status"))) {
                            System.out.println(new String(("推送图斑" + biz.getName() + "-" + f_galleryid + "附件成功，共" + mediaList.size() + "条！").getBytes(StandardCharsets.UTF_8)));
                            logger.error("推送图斑" + biz.getName() + "-" + f_galleryid + "附件成功，共" + mediaList.size() + "条！");

                            sql = "update tb_app_media set f_ispush=1 where f_galleryid='" + f_galleryid + "' and f_bizid is not null ";
                            jdbcTemplate.execute(sql);
                        } else {
                            System.out.println(new String(("推送图斑" + biz.getName() + "-" + f_galleryid + "附件失败，共" + mediaList.size() + "条！" + jsonObject.toJSONString()).getBytes(StandardCharsets.UTF_8)));
                            logger.error("推送图斑" + biz.getName() + "-" + f_galleryid + "附件失败，共" + mediaList.size() + "条！" + jsonObject.toJSONString());

                            sql = "update tb_app_media set f_ispush=2 where f_galleryid='" + f_galleryid + "' and f_bizid is not null";
                            jdbcTemplate.execute(sql);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                        logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入图斑处理失败，f_ispush=3");
                        sql = "update tb_app_media set f_ispush=3 where f_galleryid='" + f_galleryid + "' and f_bizid is not null ";
                        jdbcTemplate.execute(sql);
                    }
                }
            }
        } catch (Exception e) {
            logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入执行失败：" + e.getMessage() + "！" + df.format(new Date()));
        } finally {
            logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入完成执行" + df.format(new Date()));
            redisTemplate.delete(JOB_KEY + taskId);
        }
        logger.error("JobRunTask-rateWriteCgk  成果库信息插入执行结束" + df.format(new Date()));
    }


    private List<Map<String, Object>> getMediaList(List<Map<String, Object>> mapList, String featurebsm, String bizName, String bizid) throws Exception {
        String sql = "";

        for (Map<String, Object> map : mapList) {

            String mediaId = MapUtils.getString(map, "id");
            logger.error("JobRunTask-rateWriteCgk  成果库图斑信息开始处理附件，mediaId=" +mediaId);

            if (!map.containsKey("bizName")) {
                map.put("bizName", bizName);
            }
            if (!map.containsKey("bizId")) {
                map.put("bizId", bizid);
            }
            if (org.apache.commons.lang.StringUtils.isNotEmpty(featurebsm)) {
                map.put("featurebsm", featurebsm);
            }
            map.put("ywlx", YWLX);
            if (map.containsKey("videorecord") && StringUtils.isNotEmpty(MapUtils.getString(map, "videorecord", ""))) {
                try {
//                    map.put("videorecord", getVideoMediaMetaFromAppMedia(MapUtils.getString(map, "videorecord")).toJSONString());
                    map.put("videorecord", getVideoMediaMetaFromAppMedia(MapUtils.getString(map, "videorecord")).toString());
                } catch (Exception e) {
                    map.put("videorecord", null);
                }
            }
            if (!map.containsKey("xzqdm")) {
                map.put("xzqdm", DEFAULT_XZQDM);
            }

            String serverPath = MapUtils.getString(map, "serverPath");
//          截取url后缀文件类型名称
//            map.put("filetype",extractFileExtension(serverPath));

            if (!map.containsKey("sm3") || org.apache.commons.lang.StringUtils.isEmpty(MapUtils.getString(map, "sm3", ""))) {
                InputStream inputStream = this.getInputStream(serverPath);
                if (null != inputStream) {
                    String realFJHXZ = SmUtil.sm3(inputStream);
                    String finalFJHXZ = realFJHXZ.toUpperCase();
                    map.put("sm3", finalFJHXZ);
                    map.put("stream", inputStream);

                    sql = "update tb_app_media set f_sm3='" + finalFJHXZ + "' where f_id='" + mediaId + "'";
                    jdbcTemplate.execute(sql);
                }
            }
            map.put("fileSize", calculateSizeInKB(this.getInputStream(MapUtils.getString(map, "serverPath"))));

            map.put("zsdm", GTDCY_CERT_CODE);
            map.put("origin", 2); // 数据来源 0 国家 1省 2市

            if (!map.containsKey("verifycode") || StringUtils.isEmpty(MapUtils.getString(map, "verifycode", ""))) {
                logger.error("JobRunTask-rateWriteCgk  成果库图斑信息处理附件校验码开始，mediaId=" +mediaId);

                addJym(map);
                logger.error("JobRunTask-rateWriteCgk  成果库图斑信息处理附件校验码结束，mediaId=" +mediaId);

                sql = "update tb_app_media set f_jym='" + map.get("verifycode") + "' where f_id='" + mediaId + "'";
                jdbcTemplate.execute(sql);
            }

            map.remove("id");
            logger.error("JobRunTask-rateWriteCgk  成果库图斑信息处理附件结束，mediaId=" +mediaId);

            map.remove("createtime"); // 陈越说createtime不要传
        }

        return uploadMedia(mapList);
    }

    // 截取url后缀名称 截取url后缀文件类型名称
    private String extractFileExtension(String url) {
        if (url == null || url.isEmpty()) {
            return null;
        }
        int lastDotIndex = url.lastIndexOf('.');
        int lastSlashIndex = url.lastIndexOf('/');

        if (lastDotIndex > lastSlashIndex && lastDotIndex !=-1) {
            return url.substring(lastDotIndex + 1);
        } else {
            return null;
        }
    }

    private void addJym(Map<String, Object> map) throws Exception{


//        StringBuffer buffer = addStringBuffer(MapUtils.getString(map, "sm3"), MapUtils.getString(map, "createtime"), MapUtils.getDouble(map, "longitude"),
//                MapUtils.getDouble(map, "latitude"), MapUtils.getIntValue(map, "pitch"), MapUtils.getIntValue(map, "azimuth"),
//                MapUtils.getIntValue(map, "roll"), MapUtils.getString(map, "username"), GTDCY_CERT_CODE);

        StringBuffer buffer = addStringBuffer(MapUtils.getString(map, "sm3"), MapUtils.getString(map, "createtime"), MapUtils.getDouble(map, "longitude"),
                MapUtils.getDouble(map, "latitude"), MapUtils.getIntValue(map, "pitch"), MapUtils.getIntValue(map, "azimuth"),
                MapUtils.getIntValue(map, "roll"), MapUtils.getString(map, "username"), GTDCY_CERT_CODE);

        String hash = SM3Utils.sm3(buffer.toString());

        SM2SignVO sm2SignVO = SM2SignVerUtils.Sign2SM2(Util.hexStringToBytes(GTDCY_PRIVATEKEY), hash.getBytes(StandardCharsets.UTF_8));

        String jym = sm2SignVO.getSm2_signForHard().toUpperCase(); //校验码  要求需要转大写 ：但是验证不分大小写
        map.put("verifycode", jym);
    }

    public StringBuffer addStringBuffer(String FJHXZ, String PSSJ, Double Longitude, Double Latitude, int PSFYJ, int PSJD, int PSHGJ, String PSRY, String ZSDM) {

        StringBuffer buffer = new StringBuffer();
        buffer.append(FJHXZ).append(",");
        buffer.append(PSSJ).append(",");
        buffer.append(Longitude).append(",");
        buffer.append(Latitude).append(",");
        buffer.append(PSFYJ).append(",");
        buffer.append(PSJD).append(",");
        buffer.append(PSHGJ).append(",");
        buffer.append(PSRY).append(",");
        buffer.append(ZSDM);

        return buffer;

    }

    private List<Map<String, Object>> uploadMedia(List<Map<String, Object>> mapList) throws  Exception{

        try {
            JSONArray jsonArray = new JSONArray();
            JSONObject temp;
            for (Map<String, Object> map : mapList) {
                temp = new JSONObject() {{

                    String serverPath = MapUtils.getString(map, "serverPath");
                    put("id", MapUtils.getString(map, "fjbsm"));
                    //  put("type", MapUtils.getString(map, "filetype"));
                    //  截取url后缀文件类型名称
                    put("type", extractFileExtension(serverPath));
                    put("sm3", MapUtils.getString(map, "sm3"));
                    put("ywlx", MapUtils.getString(map, "ywlx"));
                    put("bizId", MapUtils.getString(map, "bizId"));
                    put("xzqdm", MapUtils.getString(map, "xzqdm"));
                }};
                jsonArray.add(temp);
            }
            List<Map<String, Object>> mapListNew = new ArrayList<>();
            logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入获取写入地址");
//            JSONObject jsonObject = doPost(SIGN_API, new StringEntity(jsonArray.toJSONString(), StandardCharsets.UTF_8));
            JSONObject jsonObject = doPost(SIGN_API, new StringEntity(jsonArray.toString(), StandardCharsets.UTF_8));
            logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入获取写入地址,data" + jsonObject.toJSONString() );

            JSONArray data = jsonObject.getJSONArray("data");
            InputStream inputStream;
            for (int i = 0; i < data.size(); i++) {
                JSONObject item = data.getJSONObject(i);
                String id = item.getString("id");
                Optional<Map<String, Object>> optional = mapList.stream().filter(map -> MapUtils.getString(map, "fjbsm", "").equals(id)).findAny();
                if (optional.isPresent()) {

                    Map<String, Object> map = optional.get();

                    if (map.containsKey("stream") && null != map.get("stream")) {
                        inputStream = (InputStream) map.get("stream");
                    } else {
                        inputStream = getInputStream(MapUtils.getString(map, "serverPath", ""));
                    }
                    if (null != inputStream) {
                        byte[] bytes = HttpUtil.fileConvertToByteArray(inputStream);
                        String s = HttpUtil.httpsRequestPost(item.getString("writeUrl"), "PUT", bytes,item.getString("header"));
                        map.put("serverPath", item.getString("readUrl"));
                        mapListNew.add(map);
//                        if(StringUtils.isNotBlank(s)){
//                            map.put("serverPath", item.getString("readUrl"));
//                            mapListNew.add(map);
//                        } else {
//                            throw new RuntimeException("失败");
//                        }

                    }
                }
            }
            return mapListNew;
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("JobRunTask-rateWriteCgk  成果库图斑信息插入获取写入地址失败,data" + e.getMessage() );
        }

        return mapList;
    }

    public static double calculateSizeInKB(InputStream inputStream) {
        if (inputStream == null) {
            return -1;
        }

        try {
            byte[] buffer = new byte[4096];
            int bytesRead;
            long totalBytes = 0;

            // 读取所有字节并计算总长度
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                totalBytes += bytesRead;
            }

            // 转换为KB (1KB = 1024字节)
            return totalBytes / 1024.0;

        } catch (IOException e) {
            e.printStackTrace();
            return -1;
        } finally {
            try {
                // 关闭流释放资源
                inputStream.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private InputStream getInputStream(String path) throws Exception {
        try {
            String temporaryPath = temporarySignedUrlService.getTemporarySignedUrl("", path, null);
            URL url = new URL(temporaryPath);
//            URL url = new URL(path);
            URLConnection urlConnection = null;

            urlConnection = url.openConnection();

            HttpURLConnection httpURLConnection = (HttpURLConnection) urlConnection;
            httpURLConnection.setConnectTimeout(1000 * 60 * 10);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.connect();
            return httpURLConnection.getInputStream();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static JSONArray getVideoMediaMetaFromAppMedia(String videoRecord) {

        JSONArray jsonArray = new JSONArray();
        try {
            JSONObject jsonObject = JSONObject.parseObject(videoRecord);
            if (jsonObject != null) {
                if (jsonObject.containsKey("starttime")) {
                    String startTimeStr = jsonObject.get("starttime").toString();
                    if (StringUtils.isNotBlank(startTimeStr) && jsonObject.containsKey("items")) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        Calendar calendar = Calendar.getInstance();
                        try {
                            // 视频开始时间
                            Date startTime = new Date(new Long(startTimeStr));
                            JSONArray itemsArrary = jsonObject.getJSONArray("items");
                            if (itemsArrary != null && itemsArrary.size() > 0) {
                                for (int i = 0; i < itemsArrary.size(); i++) {
                                    JSONObject itemJsonObj = itemsArrary.getJSONObject(i);
                                    if (itemJsonObj != null) {
                                        if (itemJsonObj.containsKey("position")) {
                                            int position = new Integer(itemJsonObj.get("position").toString());
                                            calendar.setTime(startTime);
                                            // 计算时间位置
                                            calendar.add(Calendar.SECOND, position);
                                            JSONObject newItem = new JSONObject();
                                            newItem.put("position", (int) (calendar.getTime().getTime() / 1000));
                                            newItem.put("x", itemJsonObj.get("lon"));
                                            newItem.put("y", itemJsonObj.get("lat"));
                                            newItem.put("angel", itemJsonObj.get("angel"));
                                            // 设置默认高度
                                            newItem.put("height", 1.7);
                                            jsonArray.add(newItem);
                                        }
                                    }
                                }
                            }
                        } catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return jsonArray;
    }


    public String generateToken() {
        long a = System.currentTimeMillis();
        String c = CERT_CODE + a;
        byte[] d = c.getBytes(StandardCharsets.UTF_8);
        byte[] e = SmUtil.sm2(PRIVATE_KEY, null).sign(d);
        String f = Base64.getEncoder().encodeToString(e);
        return CERT_CODE + "." + a + "." + f;
    }


    private JSONObject doPost(String api, StringEntity stringEntity) throws Exception {
        HttpClient httpClient = null;
        HttpPost httpPost = null;
        HttpResponse response = null;

        //发送举证查询
        httpClient = HttpClientBuilder.create().build();
        httpPost = new HttpPost();
        httpPost.setHeader("Content-Type", "application/json");
        String url = "http://121.29.50.223:8085";
        SysConfig gxkurl = sysConfigService.findOne("cgk-url");
        if (null != gxkurl) {
            url = gxkurl.getValue();
        }

        httpPost.setEntity(stringEntity);
        httpPost.setURI(URI.create(url + api));
        httpPost.setHeader("x-cgk-token", generateToken());

        response = httpClient.execute(httpPost);
        String httpEntityContent = this.getHttpEntityContent(response);
        return JSONObject.parseObject(httpEntityContent);
    }


    /**
     * 解析返回接口数据
     *
     * @param response
     * @return
     * @throws Exception
     */
    public String getHttpEntityContent(HttpResponse response) throws Exception {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream is = entity.getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = br.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line + "\n");
                line = br.readLine();
            }
            br.close();
            is.close();
            return sb.toString();
        }
        return "";
    }


}
