package com.geoway.landteam.landcloud.service.autoapprove;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.review.TbtskFlowServiceImpl;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.model.autoapprove.dto.AutoApproveConfig;
import com.geoway.landteam.landcloud.model.autoapprove.dto.AutoApproveDetailConfig;
import com.geoway.landteam.landcloud.model.autoapprove.dto.AutoApproveRule;
import com.geoway.landteam.landcloud.servface.autoapprove.MAutoApproveService;
import com.geoway.landteam.landcloud.servface.customtask.thirdData.WpzfService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Optional;

@Service
public class MAutoApproveServiceImpl implements MAutoApproveService {

    private final GiLoger logger = GwLoger.getLoger(MAutoApproveServiceImpl.class);

    final String sysConfigKey = "autoApproveConfig";
    @Autowired
    SysConfigService sysConfigService;

    @Autowired
    SysConfigRepository sysConfigRepository;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Autowired
    TbtskFlowServiceImpl tbtskFlowService;

    @Autowired
    LandUserService landUserService;

    @Autowired
    WpzfService wpzfService;

    @Override
    public AutoApproveConfig getConfig() {
        SysConfig config = this.sysConfigRepository.queryByKey(sysConfigKey);
        AutoApproveConfig autoApproveConfig = null;
        if (config != null) {
            autoApproveConfig = JSONObject.parseObject(config.getValue(), AutoApproveConfig.class);

        }
        return autoApproveConfig;
    }


    @Override
    public void autoApprove(String taskId,String tbid) throws Exception {
        AutoApproveConfig config = getConfig();
        if(config==null)
        {
            return;
        }

        TbtskObjectinfo objectinfo = tskTaskBizService.findTableByTaskId(taskId);
        if(objectinfo==null)
        {
            throw new Exception("市级自动审核失败,任务:"+taskId+"对应的TbtskObjectinfo不存在");
        }

        List<AutoApproveDetailConfig> configs = config.getDetailConfigs();
        Optional<AutoApproveDetailConfig>curConfig = configs.stream().filter(t->t.getId().equalsIgnoreCase(taskId)).findFirst();
        if(!curConfig.isPresent())
        {
            throw new Exception("市级自动审核失败,任务:"+taskId+"对应的审核规则为空");
        }
        List<AutoApproveRule>rules = curConfig.get().getRules();
        if(rules==null||rules.isEmpty())
        {
            throw new Exception("市级自动审核失败,任务:"+taskId+"对应的审核规则为空");
        }
        LandUser landUser = landUserService.queryUserById(curConfig.get().getUserId());
        if(landUser==null)
        {
            throw new Exception("市级自动审核用户:"+curConfig.get().getUserId()+"不存在");
        }
        String sql = String.format("select %s,%s,%s,util_computearea(f_shape) as area from %s where %s = '%s' ", "f_id", "f_lryj", "f_lrej",objectinfo.getfTablename(), "f_id", tbid);
        Map<String,Object> map = jdbcTemplate.queryForMap(sql);

        double area = Double.parseDouble(map.get("area").toString());
        if(area>=curConfig.get().getMinArea())
        {
            return;
        }
        boolean noPass=true;
        String id = map.get("f_id").toString();
        String lryj = map.get("f_lryj")==null?"": map.get("f_lryj").toString();
        String lrej = map.get("f_lrej")==null?"": map.get("f_lrej").toString();
        for(AutoApproveRule rule:rules) {
            if (!noPass)
            {
                break;
            }
            switch (rule.getId()) {
                case "1": {
                    Map<String, String> param = rule.getParam();
                    double greateThan = Double.parseDouble(param.get(AutoApproveConfig.Param_KEY_GREATETHAN));
                    String lryjV = param.get(AutoApproveConfig.Param_KEY_LRYJ);
                    String lrejV = param.get(AutoApproveConfig.Param_KEY_LREJ);
                    //流入一级类为【耕地占补平衡新增耕地】且流入二级类为【农村建设用地复垦】且图斑面积大于60平
                    if (lryj.equals(lryjV) && lrej.equals(lrejV) && area > greateThan) {
                        noPass=false;
                    }

                }
                break;
                case "2": {
                    Map<String, String> param = rule.getParam();
                    double intersectAreaV = Double.parseDouble(param.get(AutoApproveConfig.Param_KEY_INTERSECTAREA));
                    double intersectRateV = Double.parseDouble(param.get(AutoApproveConfig.Param_KEY_INTERSECTRATE));

                    sql = "with t1 as (select util_computearea(f_shape) as f_area,f_shape from "+objectinfo.getfTablename()+" where f_id = '"+id+"'), \n"
                            +"t2 as (select a.f_area,util_computearea(b.geom) as f_area1,util_computearea(st_intersection(a.f_shape,b.geom)) as f_area2 from t1 a, tb_yzzg b where  st_intersects  ( a.f_shape,b.geom ) = 'true') \n"
                            +"select sum(f_area1) as f_area1,sum(f_area2) as f_area2 from t2";
                    Map<String, Object> areas =  jdbcTemplate.queryForMap(sql);
                    //与原址整改图层(tb_yzzg)叠加面积大于100平且(与任务图斑)叠加面积占比例大于70%
                    if(areas!=null&&!areas.isEmpty())
                    {
                        if(areas.get("f_area2")!=null) {
                            double intersectArea = Double.parseDouble(areas.get("f_area2").toString());
                            double rate = intersectArea * 100.0 / area;
                            if (intersectArea > intersectAreaV && rate > intersectRateV) {
                                noPass = false;
                            }
                        }
                    }


                }
                break;
                case "3": {
                    Map<String, String> param = rule.getParam();
                    double intersectAreaV = Double.parseDouble(param.get(AutoApproveConfig.Param_KEY_INTERSECTAREA));
                    sql = "with t1 as (select util_computearea(f_shape) as f_area,f_shape from " + objectinfo.getfTablename() + " where f_id = '" + id + "'), \n"
                            + "t2 as (select a.f_area,util_computearea(b.geom) as f_area1,util_computearea(st_intersection(a.f_shape,b.geom)) as f_area2 from t1 a, ynyzzg b where  st_intersects  ( a.f_shape,b.geom ) = 'true') \n"
                            + "select sum(f_area1) as f_area1,sum(f_area2) as f_area2 from t2";
                    Map<String, Object> areas = jdbcTemplate.queryForMap(sql);
                    //与永农原址整改(ynyzzg)叠加面积大于100平
                    if (areas != null && !areas.isEmpty()) {
                        if(areas.get("f_area2")!=null) {
                            double intersectArea = Double.parseDouble(areas.get("f_area2").toString());
                            if (intersectArea > intersectAreaV) {
                                noPass = false;
                            }
                        }
                    }

                }
                break;
            }
        }
        if(noPass)
        {
            String result = tbtskFlowService.reject(taskId, tbid, null,curConfig.get().getUserId(), "审核意见，面积过小" +
                    "(自动审核不通过)", "审核意见，面积过小(自动审核不通过)", landUser.getName(), "市级审核", "",null);
            if (result.startsWith("打回成功")) {
                wpzfService.pushWpzfReject(tbid,taskId,landUser.getName(),"审核意见，面积过小(自动审核不通过)");
            }
        }

    }
}
