package com.geoway.landteam.landcloud.service.base.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.mq.DataDownloadProducerService;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.service.util.TbbhUtil;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.mapper.pub.DmDictValueMapper;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.enm.ReviewStageEnum;
import com.geoway.landteam.landcloud.core.model.base.enm.TbStatusEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.*;
import com.geoway.landteam.landcloud.core.model.pub.constants.BizIdConstants;
import com.geoway.landteam.landcloud.core.model.pub.dto.BasicIdInfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.DmDictValue;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization2User;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.base.*;
import com.geoway.landteam.landcloud.core.repository.pub.Organization2UserRepository;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
 import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.servface.base.AppBasicService;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDataDownloadTakeHandService;

import com.geoway.landteam.suishoupai.model.pub.entity.APicShare;
import com.geoway.landteam.suishoupai.repository.pub.APicShareRepository;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
/*import com.gw.base.data.GwValidateException;*/
import org.locationtech.jts.geom.Geometry;
import org.apache.commons.io.FileUtils;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.annotation.Resource;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.sql.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Date;
import java.util.stream.Collectors;

/**
 * Created by zhangxinxin on 2018/11/1.
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class AppBasicServiceImpl implements AppBasicService {
    private final GiLoger logger = GwLoger.getLoger(AppBasicServiceImpl.class);

    private static final String TAKE_HAND_TASK_ID = "ssp";
    private static final String TAKE_HAND = "随手拍";
  /*  @Value("#{imeSettings['obsSignatureUrlService.url']}")*/
    @Value("${obsSignatureUrlService.url:}")
    protected String obsSignUrl;
    @Value("${project.uploadDir}")
    protected String uploadDir;
    protected String innerImgUrl;
  /*  @Value("#{imeSettings['obsSignatureEnable']?:false}")*/
  @Value("${obsSignatureEnable:false}")
    protected boolean obsSignatureEnable;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;
    @Resource
    DmDictValueMapper dictValueDao;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    TaskBasicRelationRepository taskBasicRelationRepository;
    @Autowired
    SysConfigService sysConfigService;

    @Autowired
    AppBasicRepository appBasicRepository;

    @Autowired
    APicShareRepository aPicShareRepository;

    @Autowired
    AppMediaRepository appMediaRepository;

    @Autowired
    Organization2UserRepository organization2UserDao;

    @Autowired
    MDataDownloadTakeHandService MDataDownloadTakeHandService;
    @Autowired
    AppTaskBizRepository appTaskBizRepository;

    @Autowired
    TbbhUtil tbbhUtil;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
  /*  @Autowired
    ProducerService producerService;*/
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    DataDownloadProducerService dataDownloadProducerService;
    @Autowired
    private LandUserService landuserService;
    @Autowired
    private RegionService regionService;
    @Autowired
    UserNameService userNameService;
   /* @Autowired
    private SyncLogRepository syncLogRepository;*/

    public void add(HttpServletRequest request, Long userId, boolean addOrg) throws IOException, SQLException {

        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        MultipartFile multipartFile = multipartRequest.getFile("file");
        uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String filename = String.format("%s-%s.db", sdf.format(new Date()), UUID.randomUUID().toString());
        File inputFile = new File(uploadDir, filename);
        String fileFullName = inputFile.getAbsolutePath();
        FileUtils.copyInputStreamToFile(multipartFile.getInputStream(), inputFile);
        // multipartFile.transferTo(inputFile);

        Connection connection = null;
        Statement tbbhStatement = null;
        Statement statement = null;
        ResultSet tbbhRs = null;
        ResultSet rs = null;
        SqlliteConnTool connPool = new SqlliteConnTool(fileFullName);
        connection = connPool.getConnection();
        tbbhStatement = connection.createStatement();
        statement = connection.createStatement();

        String tableName = "basic";
        // 判断app基本信息表是否存在
        boolean isExists = isTableExists(statement, tableName);
        List<AppBasic> basics = new ArrayList<AppBasic>();

        if (isExists) {
            String querysql = "select * from " + tableName;
            tbbhRs = tbbhStatement.executeQuery(querysql);

            while (tbbhRs.next()) {

                Object objId = tbbhRs.getObject("f_id");
                String id = "";
                if (objId != null && !objId.equals("")) {
                    id = objId.toString(); // id
                }

                String name = ""; // 名称
                Object objName = tbbhRs.getObject("f_name");
                if (objName != null && !objName.equals("")) {
                    name = objName.toString();
                }

                String createtime = ""; // 创建时间
                Date time = new Date();
                Object objCreatetime = tbbhRs.getObject("f_createtime");
                if (objCreatetime != null && !objCreatetime.equals("")) {
                    createtime = objCreatetime.toString();
                    time = new Date(Long.parseLong(createtime));
                }

                String type = ""; // 类型
                Object objType = tbbhRs.getObject("f_type");
                if (objType != null && !objType.equals("")) {
                    type = objType.toString();
                }

                String desc = ""; // 描述
                Object objDesc = tbbhRs.getObject("f_desc");
                if (objDesc != null && !objDesc.equals("")) {
                    desc = objDesc.toString();
                }

                String shape = ""; // 空间几何
                Object objShape = tbbhRs.getObject("f_shape");
                if (objShape != null && !objShape.equals("")) {
                    shape = objShape.toString();
                }

                String cloudId = null; // 云查询id
                Object objCloudId = tbbhRs.getObject("f_cloudId");
                if (objCloudId != null && !objCloudId.equals("")) {
                    cloudId = objCloudId.toString();
                }

                String vipCloudId = null; // 高级云查询id
                Object objvCloudId = tbbhRs.getObject("f_vipCloudId");
                if (objvCloudId != null && !objvCloudId.equals("")) {
                    vipCloudId = objvCloudId.toString();
                }

                // 是否收藏
                Integer isCollect = null;
                if (isColumnExist(tbbhRs, "f_iscollect")) {
                    Object objIsCollect = tbbhRs.getObject("f_iscollect");
                    isCollect = objIsCollect == null ? null : Integer.parseInt(objIsCollect.toString());
                }

                String heading = null;
                if (isColumnExist(tbbhRs, "f_heading")) {
                    Object objvillage = tbbhRs.getObject("f_heading");
                    if (objvillage != null && !objvillage.equals("")) {
                        heading = objvillage.toString();
                    }
                }

                Double lon = null;
                if (isColumnExist(tbbhRs, "f_lon")) {
                    Object objvillage = tbbhRs.getObject("f_lon");
                    if (objvillage != null && !objvillage.equals("")) {
                        lon = Double.parseDouble(objvillage.toString());
                    }
                }

                Double lat = null;
                if (isColumnExist(tbbhRs, "f_lat")) {
                    Object objvillage = tbbhRs.getObject("f_lat");
                    if (objvillage != null && !objvillage.equals("")) {
                        lat = Double.parseDouble(objvillage.toString());
                    }
                }

                AppBasic basic = appBasicRepository.findById(id).orElse(null);
                if (basic == null) {
                    basic = new AppBasic();
                    basic.setId(id);
                }
                basic.setName(name);
                basic.setCreatetime(createtime);
                basic.setTime(new Date());
                basic.setType(type);
                basic.setDesc(desc);
                basic.setShape(shape);
                basic.setUserid(userId + "");
                basic.setUsername(landuserService.queryUserById(userId).getName());
                basic.setCloudId(cloudId);
                basic.setVipCloudId(vipCloudId);
                basic.setHeading(heading);
                basic.setIsDeleted(0);
                basic.setIsCollect(0);

                basic.setLon(lon);
                basic.setLat(lat);

                if (lon != null && lat != null) {
                    try {
                        String wkt = "POINT(" + lon + " " + lat + ")";
                        RegionDetail region = regionService.queryRegionByGeom(wkt, 4490, 3);

                        if (region == null) {
                            // 由于行政区缝隙或地级市找不到行政区代码，先查询市级行政区代码
                            region = regionService.queryRegionByGeom(wkt, 4490, 2);
                        }

                        if (region != null) {
                            String county = "";
                            String city = "";
                            String province = "";

                            if (region.getLevel() == 3) {
                                county = region.getCode();
                                city = region.getPcode();
                                province = regionService.findRegionByCode(city).getPcode();
                            } else if (region.getLevel() == 2) {
                                city = region.getCode();
                                province = region.getPcode();
                            }
                            RegionVillage village = regionService.queryVillageCotain(wkt, 0);

                            basic.setProvince(province);
                            basic.setCity(city);
                            basic.setCounty(county);
                            basic.setVilliage(village != null ? village.getCode() : "");
                        }
                    } catch (Exception e) {
                    }
                }

                basics.add(basic);
            }
            appBasicRepository.saveAll(basics);
        }

        tableName = "media";
        // 判断app媒体信息表是否存在
        isExists = isTableExists(statement, tableName);
        if (isExists) {
            String querysql = "select * from " + tableName;
            tbbhRs = tbbhStatement.executeQuery(querysql);
            List<AppMedia> medias = new ArrayList<AppMedia>();

            while (tbbhRs.next()) {
                AppMedia media = new AppMedia();
                Object objId = tbbhRs.getObject("f_id");
                String id = "";
                if (objId != null && !objId.equals("")) {
                    id = objId.toString(); // id
                }

                String galleyid = ""; // galleyid
                Object objGalleyid = tbbhRs.getObject("f_galleryid");
                if (objGalleyid != null && !objGalleyid.equals("")) {
                    galleyid = objGalleyid.toString();
                }

                String type = "0"; // 类型
                Object objType = tbbhRs.getObject("f_type");
                if (objType != null && !objType.equals("")) {
                    type = objType.toString();
                }

                String createtime = ""; // 创建时间
                Object objCreatetime = tbbhRs.getObject("f_time");
                if (objCreatetime != null && !objCreatetime.equals("")) {
                    createtime = objCreatetime.toString();
                }

                String lon = ""; // 经度
                Object objLon = tbbhRs.getObject("f_lon");
                if (objLon != null && !objLon.equals("")) {
                    lon = objLon.toString();
                }

                String lat = ""; // 纬度
                Object objLat = tbbhRs.getObject("f_lat");
                if (objLat != null && !objLat.equals("")) {
                    lat = objLat.toString();
                }

                String athmus = "";
                Object objAthmus = tbbhRs.getObject("f_azimuth");
                if (objAthmus != null && !objAthmus.equals("")) {
                    athmus = objAthmus.toString();
                }

                String pitch = "";
                Object objPitch = tbbhRs.getObject("f_pitch");
                if (objPitch != null && !objPitch.equals("")) {
                    pitch = objPitch.toString();
                }

                String shape = "";
                Object objShape = tbbhRs.getObject("f_shape");
                if (objShape != null && !objShape.equals("")) {
                    shape = objShape.toString();
                }

                String vedioRecord = "";
                Object objVedioRecord = tbbhRs.getObject("f_videorecord");
                if (objVedioRecord != null && !objVedioRecord.equals("")) {
                    vedioRecord = objVedioRecord.toString();
                }

                String serverpath = "";
                Object objServerpath = tbbhRs.getObject("f_serverpath");
                if (objServerpath != null && !objServerpath.equals("")) {
                    if (objServerpath.toString().startsWith("http")) {
                        serverpath = objServerpath.toString();
                    } else {
                        innerImgUrl = (String)ProjectConfig.getConfig(ProjectConfigEnum.OSS_INNER_IMAGEURL.getKey());
                        serverpath = innerImgUrl + objServerpath.toString();
                    }
                }

                String mediatimelength = "0";
                Object objMediatimelength = tbbhRs.getObject("f_mediatimelength");
                if (objMediatimelength != null && !objMediatimelength.equals("")) {
                    mediatimelength = objMediatimelength.toString();
                }

                String mediasize = "0";
                Object objMediasize = tbbhRs.getObject("f_mediasize");
                if (objMediasize != null && !objMediasize.equals("")) {
                    mediasize = objMediasize.toString();
                }

                media.setId(id);
                media.setGalleryid(galleyid);
                media.setType(Integer.valueOf(type));
                if (StringUtils.isNotBlank(createtime)) {
                    Long timeLong = null;
                    try {
                        timeLong = Long.valueOf(createtime);
                    } catch (NumberFormatException e) {
                        try {
                            Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(createtime);
                            timeLong = date.getTime();
                        } catch (ParseException parseException) {

                        }
                    }
                    if (timeLong != null) {
                        media.setTime(String.valueOf(timeLong));
                    }
                }
                media.setLon(Double.valueOf(lon));
                media.setLat(Double.valueOf(lat));
                media.setAzimuth(athmus);
                media.setPitch(pitch);
                media.setShape(shape);
                media.setVideorecord(vedioRecord);
                media.setServerpath(serverpath);
                media.setMediatimelength(Integer.valueOf(mediatimelength));
                media.setMediasize(Double.valueOf(mediasize));
                medias.add(media);
            }
            appMediaRepository.saveAll(medias);
        }

        // 将个人随手拍拷贝到单位云
        if (addOrg && !basics.isEmpty()) {
        }
    }

    // 上传到个人云的重构版
    public void addOfRestructure(HttpServletRequest request, Long userId, boolean addOrg) throws Exception {
        // 获取上传的数据库文件
        MultipartFile fileOfDB = ((MultipartHttpServletRequest) request).getFile("file");
        // 文件保存至临时文件目录(时间-UUID.db)
        File tempUploadFile = buildTempUploadFile();
        FileUtils.copyInputStreamToFile(fileOfDB.getInputStream(), tempUploadFile);

        // 获取DB文件数据库连接
        SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();

        boolean appBasicTableExists = isTableExists(statement, "basic");
        if (appBasicTableExists) {
            saveAppBasicData(statement, userId, "");
        }

        boolean appMediaTableExists = isTableExists(statement, "media");
        if (appMediaTableExists) {
            saveAppMediaData(statement, new ArrayList<BasicIdInfo>(), userId, false);
        }

        // 关流
        closeStream(statement, connection);

    }

    private void closeStream(Statement statement, Connection connection) throws Exception {
        if (statement != null) {
            statement.close();
            statement = null;
        }
        if (connection != null) {
            connection.close();
            connection = null;
        }

    }

    // 上传到单位云的重构版
    public List<BasicIdInfo> add2OfRestructure(HttpServletRequest request, Long userId, boolean addSelf) throws
            Exception {
        // 验证用户单位
        String organizationId = checkOrgIdOfUser(userId);

        // 获取上传的数据库文件
//		CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
//		if (multipartResolver.isMultipart(request)) {
//			MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
//			Iterator<String> iter = multiRequest.getFileNames();
//			while (iter.hasNext()) {
//				MultipartFile shapeFile = multiRequest.getFile((String) iter.next());
//			}
//		}
        MultipartFile fileOfDB = ((MultipartHttpServletRequest) request).getFile("file");


        // 文件保存至临时文件目录(时间-UUID.db)
        File tempUploadFile = buildTempUploadFile();
        FileUtils.copyInputStreamToFile(fileOfDB.getInputStream(), tempUploadFile);

        // 获取DB文件数据库连接
        SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();

        boolean appBasicTableExists = isTableExists(statement, "basic");
        List<BasicIdInfo> basicIdInfos = new ArrayList<BasicIdInfo>();
        if (appBasicTableExists) {
            basicIdInfos = saveAppBasicData2(statement, userId, organizationId);
        }

        boolean appMediaTableExists = isTableExists(statement, "media");
        if (appMediaTableExists) {
            saveAppMediaData(statement, basicIdInfos, userId, true);
        }

        // 关流
        closeStream(statement, connection);

        return basicIdInfos;
    }

    // 上传到单位云的重构版
    public List<BasicIdInfo> add2OfRestructureBySc(HttpServletRequest request, Long userId, boolean addSelf, String
            source) throws
            Exception {
        // 验证用户单位
        String organizationId = checkOrgIdOfUser(userId);

        MultipartFile fileOfDB = ((MultipartHttpServletRequest) request).getFile("file");


        // 文件保存至临时文件目录(时间-UUID.db)
        File tempUploadFile = buildTempUploadFile();
        FileUtils.copyInputStreamToFile(fileOfDB.getInputStream(), tempUploadFile);

        // 获取DB文件数据库连接
        SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();

        boolean appBasicTableExists = isTableExists(statement, "basic");
        List<BasicIdInfo> basicIdInfos = new ArrayList<BasicIdInfo>();
        if (appBasicTableExists) {
            basicIdInfos = saveAppBasicDataBySc(statement, userId, organizationId, source);
        }

        boolean appMediaTableExists = isTableExists(statement, "media");
        if (appMediaTableExists) {
            saveAppMediaData(statement, basicIdInfos, userId, true);
        }

        // 关流
        closeStream(statement, connection);

        return basicIdInfos;
    }


    private File buildTempUploadFile() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        String fileName = String.format("%s-%s.db", sdf.format(new Date()), UUID.randomUUID().toString());
        return new File(uploadDir, fileName);
    }

    private List<BasicIdInfo> saveAppBasicData(Statement statement, Long userId, String organizationId) throws Exception {
        ResultSet resultSet = statement.executeQuery("select * from basic");
        List<AppBasic> appBasics = new ArrayList<AppBasic>();
        List<BasicIdInfo> idInfos = new ArrayList<BasicIdInfo>();

        while (resultSet.next()) {
            String id = resultSet.getString("f_id");
            if (StringUtils.isBlank(id)) {
                throw new RuntimeException("上传文件已损坏");
            }
            AppBasic basic = null;
            if (StringUtils.isBlank(organizationId)) {
                basic = appBasicRepository.findById(id).orElse(null);
                if (basic == null) {
                    basic = new AppBasic();
                    basic.setId(id);
                }
            } else {
                basic = new AppBasic();
                basic.setId(UUID.randomUUID().toString());
            }

            basic.setName(resultSet.getString("f_name"));
            basic.setCreatetime(resultSet.getString("f_createtime"));
            basic.setTime(new Date());
            basic.setType(resultSet.getString("f_type"));
            basic.setDesc(resultSet.getString("f_desc"));
            basic.setShape(resultSet.getString("f_shape"));
            basic.setUsername(landuserService.queryUserById(userId).getName());
            basic.setCloudId(resultSet.getString("f_cloudId"));
            basic.setVipCloudId(resultSet.getString("f_vipCloudId"));
            basic.setHeading(resultSet.getString("f_heading"));
            basic.setIsDeleted(0);
            basic.setIsCollect(resultSet.getInt("f_iscollect"));
            basic.setLon(resultSet.getDouble("f_lon"));
            basic.setLat(resultSet.getDouble("f_lat"));
            basic.setOri(resultSet.getString("f_gallery_type"));
            basic.setMyCloudId(resultSet.getString("f_webCloudId"));
            basic.setMj(resultSet.getDouble("f_mj"));
            try {
                basic.setRequestId(resultSet.getString("f_requestid"));
            } catch (Exception ex) {

            }

            if (StringUtils.isBlank(organizationId)) {
                basic.setUserid(userId.toString());
            } else {
                basic.setUserid(organizationId);
                basic.setShareUser(userId);
                basic.setShareId(id);

                // 保存原id和生成的id信息
                BasicIdInfo basicIdInfo = new BasicIdInfo();
                basicIdInfo.setOldId(id);
                basicIdInfo.setNewId(basic.getId());
                idInfos.add(basicIdInfo);
            }
            completeBasicRegionInfo(basic);
            appBasics.add(basic);
        }
        appBasicRepository.saveAll(appBasics);

        if (resultSet != null) {
            resultSet.close();
            resultSet = null;
        }

        return idInfos;
    }

    // 个人提交到单位云，任务提交到单位云或者任务提交到工作组云盘
    private List<BasicIdInfo> saveAppBasicData2(Statement statement, Long userId, String organizationId) throws
            Exception {
        ResultSet resultSet = statement.executeQuery("select * from basic");
        List<AppBasic> appBasics = new ArrayList<AppBasic>();
        List<BasicIdInfo> idInfos = new ArrayList<BasicIdInfo>();

        // 待保存任务列表
//        List<AppTask> taskList = new ArrayList<>();

        while (resultSet.next()) {
            String id = resultSet.getString("f_id");
            if (StringUtils.isBlank(id)) {
                throw new RuntimeException("上传文件已损坏");
            }
            AppBasic basic = null;
//			if (StringUtils.isBlank(organizationId)){
//				basic = appBasicRepository.findOne(id);
//				if (basic == null){
//					basic = new AppBasic();
//					basic.setId(id);
//				}
//			} else {
//				basic = new AppBasic();
//				basic.setId(UUID.randomUUID().toString());
//			}

//			basic = appBasicRepository.findOne(id);
//			if (basic != null){
//				basic = new AppBasic();
//				basic.setId(id);
//			}
//			else{
//				basic = new AppBasic();
//				basic.setId(UUID.randomUUID().toString());
//			}

            // 提交到单位云每次都新增
            basic = new AppBasic();
            basic.setId(UUID.randomUUID().toString());

            basic.setName(resultSet.getString("f_name"));
            basic.setCreatetime(resultSet.getString("f_createtime"));
            basic.setTime(new Date());
            basic.setType(resultSet.getString("f_type"));
            basic.setDesc(resultSet.getString("f_desc"));
            basic.setShape(resultSet.getString("f_shape"));
            basic.setUsername(landuserService.queryUserById(userId).getName());
//			basic.setCloudId(resultSet.getString("f_cloudId"));
//            basic.setVipCloudId(resultSet.getString("f_vipCloudId"));
//            basic.setMyCloudId(resultSet.getString("f_webCloudId"));
            basic.setHeading(resultSet.getString("f_heading"));
            basic.setIsDeleted(0);
//			basic.setIsCollect(resultSet.getInt("f_iscollect"));
            basic.setLon(resultSet.getDouble("f_lon"));
            basic.setLat(resultSet.getDouble("f_lat"));
            basic.setOri(resultSet.getString("f_gallery_type"));
            try {
                basic.setRequestId(resultSet.getString("f_requestid"));
            } catch (Exception ex) {

            }
            basic.setMj(resultSet.getDouble("f_mj"));
            String fromId = resultSet.getString("f_fromId");
            String oriType = resultSet.getString("oriType");
            String oriId = resultSet.getString("oriId");

            // 任务相关字段
            String tbbh = resultSet.getString("f_tbbh");
            //String sdxz = resultSet.getString("f_sdxz");
            //String wyhcjl = resultSet.getString("f_wyhcjl");
            //String sign = resultSet.getString("sign");
            //String shape1 = resultSet.getString("f_shape1");
            //String bizid = resultSet.getString("f_bizid");
//            String prjid = resultSet.getString("f_prjid");
//            Double f_tbmj = resultSet.getDouble("f_tbmj");

            String type = resultSet.getString("f_gallery_type");
            if ("909".equalsIgnoreCase(type)) {
                // 个人提交到单位云
                basic.setUserid(organizationId);

                // 保存原id和生成的id信息
                BasicIdInfo basicIdInfo = new BasicIdInfo();
                basicIdInfo.setOldId(id);
                basicIdInfo.setNewId(basic.getId());
                idInfos.add(basicIdInfo);
            } else if ("908".equalsIgnoreCase(type)) {
                // 任务提交
                if ("1".equalsIgnoreCase(oriType)) {
                    // 任务来源于单位任务
                    basic.setUserid(oriId);
                } else if ("2".equalsIgnoreCase(oriType)) {
                    // 任务来源于工作组任务
                    basic.setUserid(oriId);
                }
                basic.setShareId(fromId);
                basic.setUserid(oriId);

                // 任务类型单独处理
//				if("2".equalsIgnoreCase(bizid)) {
//				    // 违建别墅业务 特殊处理
//                    AppTask appTask = appTaskRepository.findOne(oriId);
//                    if(appTask == null){
//                        appTask = new AppTask();
//                        appTask.setId(UUID.randomUUID().toString());
//                        appTask.setTbbh(tbbh);
//                        appTask.setShape(resultSet.getString("f_shape"));
//                        appTask.setTbmj(f_tbmj);
//                        appTask.setCreateTime(new Date());
//                        appTask.setState("1");
//                        appTask.setExecutor(userId.toString());
//                        appTask.setUserId(userId);
//                    }
//
//                    appTask.setTbbh(tbbh);
//                    appTask.setShape1(shape1);
//                    appTask.setSign(sign);
//                    appTask.setPrjId(prjid);
//
//                    taskList.add(appTask);
//                }

                // 保存原id和生成的id信息
                BasicIdInfo basicIdInfo = new BasicIdInfo();
                basicIdInfo.setOldId(id);
                basicIdInfo.setNewId(basic.getId());
                idInfos.add(basicIdInfo);
            } else if ("907".equalsIgnoreCase(type)) {
                // 分享的提交
                basic.setUserid(organizationId);
                basic.setShareUser(userId);
                basic.setShareId(id);

                // 保存原id和生成的id信息
                BasicIdInfo basicIdInfo = new BasicIdInfo();
                basicIdInfo.setOldId(id);
                basicIdInfo.setNewId(basic.getId());
                idInfos.add(basicIdInfo);
            }

            completeBasicRegionInfo(basic);
            appBasics.add(basic);


        }
        appBasicRepository.saveAll(appBasics);
//        appTaskRepository.save(taskList);

        if (resultSet != null) {
            resultSet.close();
            resultSet = null;
        }

        return idInfos;
    }

    // 个人提交到单位云，任务提交到单位云或者任务提交到工作组云盘
    private List<BasicIdInfo> saveAppBasicDataBySc(Statement statement, Long userId, String organizationId, String
            source) throws
            Exception {
        ResultSet resultSet = statement.executeQuery("select * from basic");
        List<AppBasic> appBasics = new ArrayList<AppBasic>();
        List<BasicIdInfo> idInfos = new ArrayList<BasicIdInfo>();

        while (resultSet.next()) {
            String id = resultSet.getString("f_id");
            if (StringUtils.isBlank(id)) {
                throw new RuntimeException("上传文件已损坏");
            }
            AppBasic basic = null;
            // 提交到单位云每次都新增
            basic = new AppBasic();
            basic.setId(id);

            basic.setName(resultSet.getString("f_name"));
            basic.setCreatetime(resultSet.getString("f_createtime"));
            basic.setTime(new Date());
            basic.setType(resultSet.getString("f_type"));
            basic.setDesc(resultSet.getString("f_desc"));
            basic.setShape(resultSet.getString("f_shape"));
            basic.setUsername(landuserService.queryUserById(userId).getName());
            basic.setCloudId(resultSet.getString("f_cloudId"));
            basic.setVipCloudId(resultSet.getString("f_vipCloudId"));
            basic.setMyCloudId(resultSet.getString("f_webCloudId"));
            basic.setHeading(resultSet.getString("f_heading"));
            basic.setIsDeleted(0);
            basic.setIsCollect(resultSet.getInt("f_iscollect"));
            basic.setLon(resultSet.getDouble("f_lon"));
            basic.setLat(resultSet.getDouble("f_lat"));
            basic.setOri(resultSet.getString("f_gallery_type"));
            try {
                basic.setRequestId(resultSet.getString("f_requestid"));
            } catch (Exception ex) {

            }
            basic.setMj(resultSet.getDouble("f_mj"));
            String fromId = resultSet.getString("f_fromId");
            String oriType = resultSet.getString("oriType");
            String oriId = resultSet.getString("oriId");

            // 任务相关字段
            String tbbh = resultSet.getString("f_tbbh");
            String type = resultSet.getString("f_gallery_type");
            if ("909".equalsIgnoreCase(type)) {
                // 个人提交到单位云
                basic.setUserid(organizationId);

                // 保存原id和生成的id信息
                BasicIdInfo basicIdInfo = new BasicIdInfo();
                basicIdInfo.setOldId(id);
                basicIdInfo.setNewId(basic.getId());
                idInfos.add(basicIdInfo);
            } else if ("908".equalsIgnoreCase(type)) {
                // 任务提交
                if ("1".equalsIgnoreCase(oriType)) {
                    // 任务来源于单位任务
                    basic.setUserid(oriId);
                } else if ("2".equalsIgnoreCase(oriType)) {
                    // 任务来源于工作组任务
                    basic.setUserid(oriId);
                }
                basic.setShareId(fromId);
                basic.setUserid(oriId);

                // 保存原id和生成的id信息
                BasicIdInfo basicIdInfo = new BasicIdInfo();
                basicIdInfo.setOldId(id);
                basicIdInfo.setNewId(basic.getId());
                idInfos.add(basicIdInfo);
            } else if ("907".equalsIgnoreCase(type)) {
                // 分享的提交
                basic.setUserid(organizationId);
                basic.setShareUser(userId);
                basic.setShareId(id);

                // 保存原id和生成的id信息
                BasicIdInfo basicIdInfo = new BasicIdInfo();
                basicIdInfo.setOldId(id);
                basicIdInfo.setNewId(basic.getId());
                idInfos.add(basicIdInfo);
            }

            completeBasicRegionInfo(basic);
            appBasics.add(basic);
        }
        //appBasicRepository.save(appBasics);
        //添加对应的任务数据
        if (source != null && source.equalsIgnoreCase("sc")) {
            addTaskBasicInfo(appBasics, userId);
        }
        if (resultSet != null) {
            resultSet.close();
            resultSet = null;
        }

        return idInfos;
    }

    /**
     * 新增四川举报任务数据和关联表数据
     *
     * @param appBasics
     */
    private void addTaskBasicInfo(List<AppBasic> appBasics, Long userId) {
        //获取四川举报线索任务Id
        SysConfig sysConfig = sysConfigService.findOne(BizIdConstants.SCGTY_BIZ_ID);
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(sysConfig.getValue()).orElse(null);
        TbtskObjectinfo tableInfo = tbtskObjectinfoRepository.findById(tskTaskBiz.getTableId()).orElse(null);
        List<TbtskFields> tbtskFieldsByTableid = tbtskFieldsRepository.getTbtskFieldsByTableid(tskTaskBiz.getTableId());
        List<String> collect = tbtskFieldsByTableid.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
        //获取违法类型字典值
        List<DmDictValue> dmDictValues = dictValueDao.queryTop(10048L);

        List<Map<String, Object>> addDataCacheList = new ArrayList<>();
        List<TaskBasicRelation> taskBasicRelations = new ArrayList<>();
        for (AppBasic appBasic : appBasics) {
            Map<String, Object> map = new HashMap<>();
            TaskBasicRelation taskBasicRelation = new TaskBasicRelation();
            map.put("f_id", UUID.randomUUID().toString());
            map.put("f_status", TbStatusEnum.WAITING_VERIFY.getCode());
            map.put("f_review_stage", ReviewStageEnum.COUNTY_VERIFY.getCode());
            map.put("f_lon", appBasic.getLon());
            map.put("f_lat", appBasic.getLat());
            map.put("f_createtime", System.currentTimeMillis() + "");
            map.put("f_committime", System.currentTimeMillis() + "");
            map.put("f_userid", userId.toString());
            map.put("f_upload_userid", userId.toString());
            map.put("f_submit_userid", userId.toString());
            map.put("f_ismy", "0");
            map.put("f_xzqdmsys", appBasic.getVilliage() != null ? appBasic.getVilliage() : appBasic.getCounty());
            map.put("f_xzqdm", appBasic.getCounty());
            map.put("f_tbmc", appBasic.getHeading());
            map.put("f_tbmj", appBasic.getMj());
            map.put("f_shape", appBasic.getShape());
            map.put("f_shape1", appBasic.getShape());
            //添加线索任务字段
            fillRequiredFieldNames(map, collect, appBasic, userId, dmDictValues);
            addDataCacheList.add(map);
            //增加关联表数据
            taskBasicRelation.setDataId(map.get("f_id").toString());
            taskBasicRelation.setUserId(userId.toString());
            taskBasicRelation.setCreateDate(new Date());
            taskBasicRelation.setBasicId(appBasic.getId());
            taskBasicRelation.setBizId(sysConfigService.findOne(BizIdConstants.SCGTY_BIZ_ID).getValue());
            taskBasicRelations.add(taskBasicRelation);
            taskBasicRelationRepository.save(taskBasicRelation);
        }
        //批量增加举报任务数据
        dataBizService.insertDatasBatchByTimeStamp(tableInfo.getfTablename(), addDataCacheList, "f_shape");
        //批量增加关联表数据
        taskBasicRelationRepository.saveAll(taskBasicRelations);
    }


    //添加线索任务字段
    private void fillRequiredFieldNames(Map<String, Object> map, List<String> collect, AppBasic appBasic, Long userId, List<DmDictValue> dmDictValues) {
        if (collect.contains("f_xsmc")) {
            map.put("f_xsmc", appBasic.getHeading());
        }
        if (collect.contains("f_xsbh")) {
            String xsbh = tbbhUtil.generateTbbh(appBasic.getVilliage() != null ? appBasic.getVilliage()
                    : appBasic.getCounty(), "TB", tbbhUtil.getUserLevelCode(userId));
            map.put("f_xsbh", xsbh);
            map.put("f_tbbh", xsbh);
        }
        if (collect.contains("f_xzqmc_n1")) {
            map.put("f_xzqmc_n1", regionService.getName(appBasic.getCounty()));
        }
        if (collect.contains("f_xsms")) {
            map.put("f_xsms", appBasic.getDesc());
        }
        if (collect.contains("f_wfdd")) {
            //map.put("f_wfdd",getXzqmcByPont(sysConfig.getValue(),appBasic.getLon(),appBasic.getLat()));
            map.put("f_wfdd", appBasic.getName());
        }
        if (collect.contains("f_jbsj")) {
            map.put("f_jbsj", new Timestamp(System.currentTimeMillis()));
        }
        if (collect.contains("f_yswflx")) {
            String type = appBasic.getType();
            for (DmDictValue dmDictValue : dmDictValues) {
                if (dmDictValue.getName().equalsIgnoreCase(appBasic.getType())) {
                    type = dmDictValue.getCode();
                }
            }
            map.put("f_yswflx", type);
        }
        if (collect.contains("f_wflx")) {
            String type = appBasic.getType();
            for (DmDictValue dmDictValue : dmDictValues) {
                if (dmDictValue.getName().equalsIgnoreCase(appBasic.getType())) {
                    type = dmDictValue.getCode();
                }
            }
            map.put("f_wflx", type);
        }
        if (collect.contains("f_jbr")) {
            map.put("f_jbr", appBasic.getUsername());
        }
    }

    /**
     * 根据行政区代码生成图斑编号
     *
     * @param xzqdm
     * @param type
     * @return
     */
    private String generateTbbh(String xzqdm, String type) {
        String result = "";
        if (StringUtils.isNotBlank(xzqdm)) {
            String sql = "select land_quality_grade_num_getnextvalue('" + xzqdm + "','1','1') ";
            Object obj = jdbcTemplate.queryForObject(sql, Object.class);
            int numInt = 0;
            if (obj != null) {
                try {
                    numInt = Integer.parseInt(obj.toString());
                } catch (Exception e) {
                }
            }
            String num = "";
            if (numInt <= 9999) {
                num = String.format("%04d", numInt);
            } else {
                num = String.valueOf(numInt);
            }
            result = xzqdm + type.toUpperCase() + num;
        }
        return result;
    }

    public String getXzqmcByPont(String taskId, double dLon, double dLat) {
      /*  double dLon = Double.parseDouble(lon);
        double dLat = Double.parseDouble(lat);*/
        String wkt = "POINT(" + dLon + " " + dLat + ")";

        JSONObject data = new JSONObject();
        String name = "";
        String code = "";
        TskTaskBiz biz = tskTaskBizRepository.findById(taskId).orElse(null);
        try {
            if (biz.getGranularity() != null && biz.getGranularity() == 5) {
                RegionVillage village = null;

                village = regionService.queryVillageCotain(wkt, 0);

                if (village != null) {
                    name = village.getName();
                    code = village.getCode();

                    String xianName = regionService.getName(code.substring(0, 6));
                    String xiangName = regionService.getName(code.substring(0, 9));

                    name = xianName + xiangName + name;
                }
            } else if (biz.getGranularity() != null && biz.getGranularity() == 4) {
                Geometry geometry = WKTUtil.wktToGeom(wkt);
                RegionTown regionTown = regionService.queryRegionTownCotain(geometry);
                if (regionTown != null) {
                    name = regionTown.getName();
                    code = regionTown.getCode();

                    String xianName = regionService.getName(code.substring(0, 6));
                    name = xianName + name;
                }
            } else if (biz.getGranularity() != null) {
                RegionDetail region = regionService.queryRegionByGeom(wkt, 4490, 3);
                if (region == null) {
                    // 由于行政区缝隙或地级市找不到行政区代码，先查询市级行政区代码
                    region = regionService.queryRegionByGeom(wkt, 4490, 2);
                }
                if (region == null) {
                    // 如果刚好处在市级缝隙，则作缓冲区查询
                    region = regionService.queryRegionByGeom(wkt, 4490, 2, 2000);
                }
                if (region != null) {
                    name = region.getName();
                    code = region.getCode();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    private void completeBasicRegionInfo(AppBasic basic) throws Exception {
        if (basic.getLon() == null || basic.getLat() == null) {
            return;
        }
        String wkt = "POINT(" + basic.getLon() + " " + basic.getLat() + ")";
        RegionDetail region = regionService.queryRegionByGeom(wkt, 4490, 3);
        if (region == null) {
            // 由于行政区缝隙或地级市找不到行政区代码，先查询市级行政区代码
            region = regionService.queryRegionByGeom(wkt, 4490, 2);
        }
        if (region == null) {
            return;
        }
        String county = "";
        String city = "";
        String province = "";

        if (region.getLevel() == 3) {
            county = region.getCode();
            city = region.getPcode();
            province = regionService.findRegionByCode(city).getPcode();
        } else if (region.getLevel() == 2) {
            city = region.getCode();
            province = region.getPcode();
        }
        RegionVillage village = regionService.queryVillageCotain(wkt, 0);
        basic.setProvince(province);
        basic.setCity(city);
        basic.setCounty(county);
        basic.setVilliage(village != null ? village.getCode() : "");
    }

    private void saveAppMediaData(Statement statement, List<BasicIdInfo> basicIdInfos, Long userId, boolean saveOfOrg) throws Exception {
        ResultSet resultSet = statement.executeQuery("select * from media");
        List<AppMedia> appMedias = new ArrayList<AppMedia>();
        while (resultSet.next()) {
            String oldId = resultSet.getString("f_id");
            if (StringUtils.isBlank(oldId)) {
                throw new RuntimeException("上传文件已损坏");
            }
            AppMedia media = appMediaRepository.findById(oldId).orElse(null);
            media = media == null ? new AppMedia() : media;

            String oldGalleryid = resultSet.getString("f_galleryid");

            if (!saveOfOrg) {
                // 个人云盘媒体文件,覆盖原有的
                media.setId(oldId);
                media.setGalleryid(oldGalleryid);
            } else {
                // 单位云盘媒体文件, 新增
                media = new AppMedia();
                media.setId(UUID.randomUUID().toString());
                for (BasicIdInfo info : basicIdInfos) {
                    if (StringUtils.isNotBlank(oldGalleryid) && oldGalleryid.equals(info.getOldId())) {
                        media.setGalleryid(info.getNewId());
                        break;
                    }
                }

                if (StringUtils.isBlank(media.getGalleryid())) {
                    throw new RuntimeException("上传文件数据有误");
                }
            }

            media.setType(resultSet.getInt("f_type"));
            String time = resultSet.getString("f_time");
            if (StringUtils.isNotBlank(time)) {
                Long timeLong = null;
                try {
                    timeLong = Long.valueOf(time);
                } catch (NumberFormatException e) {
                    try {
                        Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(time);
                        timeLong = date.getTime();
                    } catch (ParseException parseException) {

                    }
                }
                if (timeLong != null) {
                    media.setTime(String.valueOf(timeLong));
                }
            }
            media.setLon(resultSet.getDouble("f_lon"));
            media.setLat(resultSet.getDouble("f_lat"));
            media.setAzimuth(resultSet.getString("f_azimuth"));
            media.setPitch(resultSet.getString("f_pitch"));
            media.setShape(resultSet.getString("f_shape"));
            media.setVideorecord(resultSet.getString("f_videorecord"));
//            media.setFileId(resultSet.getString("f_fileid"));
            String serverPath = resultSet.getString("f_serverpath");
            if (StringUtils.isNotBlank(serverPath) && !serverPath.startsWith("http://")) {
                innerImgUrl = (String)ProjectConfig.getConfig(ProjectConfigEnum.OSS_INNER_IMAGEURL.getKey());
                serverPath = innerImgUrl + serverPath;
            }
            media.setServerpath(serverPath);
//            media.setDownloadUrl(resultSet.getString("f_downloadurl"));
            media.setMediatimelength(resultSet.getInt("f_mediatimelength"));
            media.setMediasize(resultSet.getDouble("f_mediasize"));
            media.setMark(resultSet.getObject("f_mark") == null ? 0 : resultSet.getInt("f_mark"));
            media.setTypetype(resultSet.getObject("f_typetype") == null ? 0 : resultSet.getInt("f_typetype"));
            media.setUsername(landuserService.queryUserById(userId).getName());
            appMedias.add(media);
        }
        appMediaRepository.saveAll(appMedias);

        if (resultSet != null) {
            resultSet.close();
            resultSet = null;
        }
    }


    private String checkOrgIdOfUser(Long userId) {
        List<Organization2User> organization2Users = organization2UserDao.queryByUserId(userId);
        if (organization2Users.isEmpty()) {
            throw new RuntimeException("用户信息错误，无挂接的单位");
        }
        return organization2Users.get(0).getOrganizationId();
    }

    public List<BasicIdInfo> add2(HttpServletRequest request, Long userId, boolean addSelf) throws IOException, SQLException {

        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        MultipartFile multipartFile = multipartRequest.getFile("file");
        uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String filename = String.format("%s-%s.db", sdf.format(new Date()), UUID.randomUUID().toString());
        File inputFile = new File(uploadDir, filename);
        String fileFullName = inputFile.getAbsolutePath();
        FileUtils.copyInputStreamToFile(multipartFile.getInputStream(), inputFile);
        // multipartFile.transferTo(inputFile);


        List<Organization2User> organization2Users = organization2UserDao.queryByUserId(userId);
        if (organization2Users.isEmpty()) {
            throw new RuntimeException("用户信息错误，无挂接的单位");
        }
        String organizationId = organization2Users.get(0).getOrganizationId();


        Connection connection = null;
        Statement tbbhStatement = null;
        Statement statement = null;
        ResultSet tbbhRs = null;
        ResultSet rs = null;
        SqlliteConnTool connPool = new SqlliteConnTool(fileFullName);
        connection = connPool.getConnection();
        tbbhStatement = connection.createStatement();
        statement = connection.createStatement();

        String tableName = "basic";
        // 判断app基本信息表是否存在
        boolean isExists = isTableExists(statement, tableName);
        List<AppBasic> basics = new ArrayList<AppBasic>();
        List<BasicIdInfo> idInfos = new ArrayList<BasicIdInfo>();
        if (isExists) {
            String querysql = "select * from " + tableName;
            tbbhRs = tbbhStatement.executeQuery(querysql);
            while (tbbhRs.next()) {
                BasicIdInfo basicIdInfo = new BasicIdInfo();
                Object objId = tbbhRs.getObject("f_id");
                String id = "";
                if (objId != null && !objId.equals("")) {
                    id = objId.toString(); // id
                    basicIdInfo.setOldId(id);
                }

                String name = ""; // 名称
                Object objName = tbbhRs.getObject("f_name");
                if (objName != null && !objName.equals("")) {
                    name = objName.toString();
                }

                String createtime = ""; // 创建时间
                Date time = new Date();
                Object objCreatetime = tbbhRs.getObject("f_createtime");
                if (objCreatetime != null && !objCreatetime.equals("")) {
                    createtime = objCreatetime.toString();
                    time = new Date(Long.parseLong(createtime));
                }

                String type = ""; // 类型
                Object objType = tbbhRs.getObject("f_type");
                if (objType != null && !objType.equals("")) {
                    type = objType.toString();
                }

                String desc = ""; // 描述
                Object objDesc = tbbhRs.getObject("f_desc");
                if (objDesc != null && !objDesc.equals("")) {
                    desc = objDesc.toString();
                }

                String shape = ""; // 空间几何
                Object objShape = tbbhRs.getObject("f_shape");
                if (objShape != null && !objShape.equals("")) {
                    shape = objShape.toString();
                }

                String cloudId = null; // 云查询id
                Object objCloudId = tbbhRs.getObject("f_cloudId");
                if (objCloudId != null && !objCloudId.equals("")) {
                    cloudId = objCloudId.toString();
                }

                String vipCloudId = null; // 高级云查询id
                Object objvCloudId = tbbhRs.getObject("f_vipCloudId");
                if (objvCloudId != null && !objvCloudId.equals("")) {
                    vipCloudId = objvCloudId.toString();
                }

                // 是否收藏
                Integer isCollect = null;
                if (isColumnExist(tbbhRs, "f_iscollect")) {
                    Object objIsCollect = tbbhRs.getObject("f_iscollect");
                    isCollect = objIsCollect == null ? null : Integer.parseInt(objIsCollect.toString());
                }

                String heading = null;
                if (isColumnExist(tbbhRs, "f_heading")) {
                    Object objvillage = tbbhRs.getObject("f_heading");
                    if (objvillage != null && !objvillage.equals("")) {
                        heading = objvillage.toString();
                    }
                }

                Double lon = null;
                if (isColumnExist(tbbhRs, "f_lon")) {
                    Object objvillage = tbbhRs.getObject("f_lon");
                    if (objvillage != null && !objvillage.equals("")) {
                        lon = Double.parseDouble(objvillage.toString());
                    }
                }

                Double lat = null;
                if (isColumnExist(tbbhRs, "f_lat")) {
                    Object objvillage = tbbhRs.getObject("f_lat");
                    if (objvillage != null && !objvillage.equals("")) {
                        lat = Double.parseDouble(objvillage.toString());
                    }
                }

                AppBasic basic = new AppBasic();
                String newId = UUID.randomUUID().toString();
                basicIdInfo.setNewId(newId);
                idInfos.add(basicIdInfo);
                basic.setId(newId);
                basic.setName(name);
                basic.setCreatetime(createtime);
                basic.setTime(new Date());
                basic.setType(type);
                basic.setDesc(desc);
                basic.setShape(shape);
                basic.setUsername(landuserService.queryUserById(userId).getName());
                basic.setCloudId(cloudId);
                basic.setVipCloudId(vipCloudId);
                basic.setHeading(heading);
                basic.setIsCollect(0);
                basic.setShareUser(userId);
                basic.setShareId(id);
                basic.setUserid(organizationId);
                basic.setShareType(3);
                basic.setIsDeleted(0);

                basic.setLon(lon);
                basic.setLat(lat);

                if (lon != null && lat != null) {
                    try {
                        String wkt = "POINT(" + lon + " " + lat + ")";
                        RegionDetail region = regionService.queryRegionByGeom(wkt, 4490, 3);

                        if (region == null) {
                            // 由于行政区缝隙或地级市找不到行政区代码，先查询市级行政区代码
                            region = regionService.queryRegionByGeom(wkt, 4490, 2);
                        }

                        if (region != null) {
                            String county = "";
                            String city = "";
                            String province = "";

                            if (region.getLevel() == 3) {
                                county = region.getCode();
                                city = region.getPcode();
                                province = regionService.findRegionByCode(city).getPcode();
                            } else if (region.getLevel() == 2) {
                                city = region.getCode();
                                province = region.getPcode();
                            }
                            RegionVillage village = regionService.queryVillageCotain(wkt, 0);

                            basic.setProvince(province);
                            basic.setCity(city);
                            basic.setCounty(county);
                            basic.setVilliage(village != null ? village.getCode() : "");
                        }
                    } catch (Exception e) {
                    }
                }

                basics.add(basic);
            }
            appBasicRepository.saveAll(basics);
        }

        tableName = "media";
        // 判断app媒体信息表是否存在
        isExists = isTableExists(statement, tableName);
        if (isExists) {
            String querysql = "select * from " + tableName;
            tbbhRs = tbbhStatement.executeQuery(querysql);
            List<AppMedia> medias = new ArrayList<AppMedia>();

            while (tbbhRs.next()) {
                AppMedia media = new AppMedia();
                Object objId = tbbhRs.getObject("f_id");
                String id = "";
                if (objId != null && !objId.equals("")) {
                    id = UUID.randomUUID().toString(); // id
                }

                String galleyid = ""; // galleyid
                Object objGalleyid = tbbhRs.getObject("f_galleryid");
                if (objGalleyid != null && !objGalleyid.equals("")) {
                    galleyid = objGalleyid.toString();
                }

                String type = "0"; // 类型
                Object objType = tbbhRs.getObject("f_type");
                if (objType != null && !objType.equals("")) {
                    type = objType.toString();
                }

                String createtime = ""; // 创建时间
                Object objCreatetime = tbbhRs.getObject("f_time");
                if (objCreatetime != null && !objCreatetime.equals("")) {
                    createtime = objCreatetime.toString();
                }

                String lon = ""; // 经度
                Object objLon = tbbhRs.getObject("f_lon");
                if (objLon != null && !objLon.equals("")) {
                    lon = objLon.toString();
                }

                String lat = ""; // 纬度
                Object objLat = tbbhRs.getObject("f_lat");
                if (objLat != null && !objLat.equals("")) {
                    lat = objLat.toString();
                }

                String athmus = "";
                Object objAthmus = tbbhRs.getObject("f_azimuth");
                if (objAthmus != null && !objAthmus.equals("")) {
                    athmus = objAthmus.toString();
                }

                String pitch = "";
                Object objPitch = tbbhRs.getObject("f_pitch");
                if (objPitch != null && !objPitch.equals("")) {
                    pitch = objPitch.toString();
                }

                String shape = "";
                Object objShape = tbbhRs.getObject("f_shape");
                if (objShape != null && !objShape.equals("")) {
                    shape = objShape.toString();
                }

                String vedioRecord = "";
                Object objVedioRecord = tbbhRs.getObject("f_videorecord");
                if (objVedioRecord != null && !objVedioRecord.equals("")) {
                    vedioRecord = objVedioRecord.toString();
                }

                String serverpath = "";
                Object objServerpath = tbbhRs.getObject("f_serverpath");
                if (objServerpath != null && !objServerpath.equals("")) {
                    if (objServerpath.toString().startsWith("http")) {
                        serverpath = objServerpath.toString();
                    } else {
                        innerImgUrl = (String)ProjectConfig.getConfig(ProjectConfigEnum.OSS_INNER_IMAGEURL.getKey());
                        serverpath = innerImgUrl + objServerpath.toString();
                    }
                }

                String mediatimelength = "0";
                Object objMediatimelength = tbbhRs.getObject("f_mediatimelength");
                if (objMediatimelength != null && !objMediatimelength.equals("")) {
                    mediatimelength = objMediatimelength.toString();
                }

                String mediasize = "0";
                Object objMediasize = tbbhRs.getObject("f_mediasize");
                if (objMediasize != null && !objMediasize.equals("")) {
                    mediasize = objMediasize.toString();
                }


                String newgalleyid = "";
                for (AppBasic ba : basics) {
                    if (ba.getShareId().equals(galleyid)) {
                        newgalleyid = ba.getId();
                        break;
                    }
                }

                media.setId(id);
                media.setGalleryid(newgalleyid);
                media.setType(Integer.valueOf(type));
                if (StringUtils.isNotBlank(createtime)) {
                    Long timeLong = null;
                    try {
                        timeLong = Long.valueOf(createtime);
                    } catch (NumberFormatException e) {
                        try {
                            Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(createtime);
                            timeLong = date.getTime();
                        } catch (ParseException parseException) {

                        }
                    }
                    if (timeLong != null) {
                        media.setTime(String.valueOf(timeLong));
                    }
                }
                media.setLon(Double.valueOf(lon));
                media.setLat(Double.valueOf(lat));
                media.setAzimuth(athmus);
                media.setPitch(pitch);
                media.setShape(shape);
                media.setVideorecord(vedioRecord);
                media.setServerpath(serverpath);
                media.setMediatimelength(Integer.valueOf(mediatimelength));
                media.setMediasize(Double.valueOf(mediasize));
                medias.add(media);
            }
            appMediaRepository.saveAll(medias);
        }
        return idInfos;

//		// 将个人随手拍拷贝到单位云
//		if (!basics.isEmpty()) {
//
//			
//
//			for (AppBasic appBasic : basics) {
//				AppBasic newbasic = new AppBasic();
//
//				BeanUtil.copyProperties(appBasic, newbasic);
//
//				
//
//				appBasicRepository.save(newbasic);
//
//				// 获取其原始随手拍的List<AppMedia>
//				List<AppMedia> mds = appMediaRepository.queryByGid(appBasic.getId());
//
//				List<AppMedia> newMedias = new ArrayList<AppMedia>();
//				// 修改对应关联id为分享产生的新id
//				for (AppMedia appMedia : mds) {
//					AppMedia appMediaShare = new AppMedia();
//					BeanUtil.copyProperties(appMedia, appMediaShare);
//					appMediaShare.setId(UUID.randomUUID().toString());
//					appMediaShare.setGalleryid(newbasic.getId());
//
//					newMedias.add(appMediaShare);
//				}
//				appMediaRepository.save(newMedias);
//			}
//		}
    }


    public Page<AppBasic> getPageByFilter(String filterParam, String sortParam, int start, Integer limit) {
        return appBasicRepository.findAll(new QuerySpecification<AppBasic>(filterParam),
                 PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));
    }

    public List getBasicListByExtent(String userid, Float xmin, Float xmax, Float ymin, Float ymax) {
        JSONArray jsonArray = new JSONArray();
        List list = appBasicRepository.getListByExtent(userid, xmin, xmax, ymin, ymax);
        for (int i = 0; i < list.size(); i++) {
            Object[] objarr = (Object[]) list.get(i);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("f_id", objarr[0]);
            jsonObject.put("f_lon", Float.valueOf(objarr[1].toString()));
            jsonObject.put("f_lat", Float.valueOf(objarr[2].toString()));
            jsonObject.put("f_shape", objarr[3] == null ? "" : objarr[3].toString());
            jsonObject.put("f_heading", objarr[4] == null ? "" : objarr[4].toString());
            jsonObject.put("f_type", objarr[5] == null ? "" : objarr[5].toString());
            jsonObject.put("f_name", objarr[6] == null ? "" : objarr[6].toString());
            jsonObject.put("f_time", objarr[7] == null ? "" : objarr[7].toString());
            jsonObject.put("f_username", objarr[8] == null ? "" : objarr[8].toString());
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }

    public void save(AppBasic basic) {
        appBasicRepository.save(basic);
    }

    public AppBasic findOne(String id) {
        return appBasicRepository.findById(id).orElse(null);
    }

    public boolean exist(String id) {
        return appBasicRepository.existsById(id);
    }

    public void saveAll(List<AppBasic> basics) {
        appBasicRepository.saveAll(basics);
    }

    public void deleteBasics(List<AppBasic> basics) {
        appBasicRepository.deleteAll(basics);
    }

    public AppBasic uploadMyCloudId(String id, String myCloudId, String wkt) {
        AppBasic basic = appBasicRepository.findById(id).orElse(null);
        //basic.setMyCloudId(myCloudId);
        // 修改为云查询请求id，不再记录云查询id
        basic.setRequestId(myCloudId);

        if (StringUtils.isNotBlank(wkt)) {
            basic.setShape(wkt);
        }

        basic = appBasicRepository.save(basic);
        return basic;
    }

    public AppBasic getDetailById(String id, String userId, String filterParam, String sortParam) {
        AppBasic appBasic = appBasicRepository.findById(id).orElse(null);
        Date time = appBasic.getTime();
        String timeDT = ";Q_time_D_GT=" + time.getTime();
        String timeLT = ";Q_time_D_LT=" + time.getTime();

        String prevFilterParam = filterParam + ";Q_userid_S_EQ=" + userId;
        String nextFilterParam = filterParam + ";Q_userid_S_EQ=" + userId;
        String prevSort = "";
        String nextSort = "";

        if (sortParam.indexOf("ASC") == -1) { // 降序
            prevFilterParam += timeDT;
            nextFilterParam += timeLT;
            prevSort = "SORT_time_ASC";
            nextSort = "SORT_time_DESC";
        } else { // 升序
            prevFilterParam += timeLT;
            nextFilterParam += timeDT;
            prevSort = "SORT_time_DESC";
            nextSort = "SORT_time_ASC";
        }
        Page<AppBasic> previous = this.getPageByFilter(prevFilterParam, prevSort, 0, 1);
        Page<AppBasic> next = this.getPageByFilter(nextFilterParam, nextSort, 0, 1);

        if (previous.getTotalElements() > 0) {
            appBasic.setPrevious(previous.getContent().get(0).getId());
        }
        if (next.getTotalElements() > 0) {
            appBasic.setNext(next.getContent().get(0).getId());
        }

        List<AppMedia> mds = appMediaRepository.queryByGid(id);

        appBasic.setCurMedia(this.getFirstPhont(id));
        appBasic.setList(mds);

        return appBasic;
    }

    public AppBasic getDetailById(String id, String userId) {
        AppBasic appBasic = appBasicRepository.findById(id).orElse(null);

        List<AppBasic> previousappBasic = appBasicRepository.getPreviousappBasic(appBasic.getTime(), userId,
                 PageRequest.of(0, 1));
        List<AppBasic> nextappBasic = appBasicRepository.getNextappBasic(appBasic.getTime(), userId,
                 PageRequest.of(0, 1));

        if (!previousappBasic.isEmpty()) {
            appBasic.setPrevious(previousappBasic.get(0).getId());
        }
        if (!nextappBasic.isEmpty()) {
            appBasic.setNext(nextappBasic.get(0).getId());
        }

        List<AppMedia> mds = appMediaRepository.queryByGid(id);

        appBasic.setCurMedia(this.getFirstPhont(id));
        appBasic.setList(mds);

        return appBasic;
    }

    public AppBasic getDetailById(String id) throws Exception {
        AppBasic appBasic = appBasicRepository.findById(id).orElse(null);
        if (appBasic.getIsDeleted() == 1) {
            throw new RuntimeException("该随手拍已被删除");
        }

        String regionName = "";
        String province = appBasic.getProvince();
        if (province != null && province != "") {
            regionName += regionService.getNameByCode(province);
        }
        String city = appBasic.getCity();
        if (city != null && city != "") {
            regionName += regionService.getNameByCode(city);
        }
        String county = appBasic.getCounty();
        if (county != null && county != "") {
            regionName += regionService.getNameByCode(county);
        }
        appBasic.setRegion(regionName);

        List<AppMedia> mds = appMediaRepository.queryByGid(id);

        appBasic.setCurMedia(this.getFirstPhont(id));
        appBasic.setList(mds);

        return appBasic;
    }

    public AppMedia getFirstPhont(String id) {

        List<AppMedia> mds = null;
        try {
            mds = appMediaRepository.queryOfPhoto(id,  PageRequest.of(0, 1));
        } catch (Exception e) {
            System.out.println(id);
            return null;
        }
        if (!mds.isEmpty()) {
            return mds.get(0);
        }
        return null;
    }

    public long queryOfPhotoCount(String id) {
        Long count = appMediaRepository.queryOfPhotoCount(id);
        if (count == null) {
            return 0;
        }
        return count;
    }

    public void doCollect(List ids, int isCollect) {
        appBasicRepository.updateCollect(ids, isCollect);
    }

    public List<AppBasic> getAppBasicByCollect(int isCollect, Long userId) {
        return appBasicRepository.getAppBasicByCollect(isCollect, userId + "");
    }

    public AppBasic deleteOne(String id) {
        AppBasic appBasic = appBasicRepository.findById(id).orElse(null);
        appBasic.setIsDeleted(1);
        appBasic.setDeleteTime(new Date());
        appBasicRepository.save(appBasic);
        // 判断该随手拍是否被分享过,有则删除分享记录
        List<APicShare> list = aPicShareRepository.getApicShareByOldId(id);
        if (!list.isEmpty()) {
            aPicShareRepository.deleteAll(list);
        }

        // 删除日志
       /* SyncLog syncLog = new SyncLog();
        syncLog.setId(UUID.randomUUID().toString());
        syncLog.setObjid(appBasic.getId());
        syncLog.setOpttype(3);
        syncLog.setOpttime(new Date());
        syncLog.setOptori(2);
        syncLog.setState(1);
        syncLog.setData(JSONObject.toJSONString(appBasic));
        syncLogRepository.save(syncLog);*/

        return appBasic;
    }

    public int deleteByIds(String ids) {
        String[] idArr = ids.split(",");
        int count = 0;
        for (int i = 0; i < idArr.length; i++) {
            AppBasic appBasic = appBasicRepository.findById(idArr[i]).orElse(null);
            if (appBasic != null) {
                appBasic.setIsDeleted(1);
                appBasic.setDeleteTime(new Date());
                appBasicRepository.save(appBasic);
                // 判断该随手拍是否被分享过,有则删除分享记录

                count++;
            }
            List<APicShare> list = aPicShareRepository.getApicShareByOldId(idArr[i]);
            if (!list.isEmpty()) {
                aPicShareRepository.deleteAll(list);
            }
        }


        return count;
    }

    /**
     * 同步时删除，直接删除，不放回收站
     *
     * @param ids
     */
    public void deleteByIds(List<String> ids) {
        appBasicRepository.deleteByIds(ids);
    }

    public void updateServerPath() {
        Iterable<AppBasic> list = appBasicRepository.findAll();
        for (AppBasic appBasic : list) {
            if (appBasic.getTime() == null) {
                appBasic.setTime(new Date(Long.parseLong(appBasic.getCreatetime())));
                appBasicRepository.save(appBasic);
            }

            if (appBasic.getIsDeleted() == 1) {
                appBasic.setDeleteTime(new Date());
                appBasicRepository.save(appBasic);
            }
        }

        Iterable<AppMedia> querys = appMediaRepository.findAll();
        innerImgUrl = (String)ProjectConfig.getConfig(ProjectConfigEnum.OSS_INNER_IMAGEURL.getKey());
        for (AppMedia ab : querys) {
            if (StringUtils.isNotBlank(ab.getServerpath()) && !ab.getServerpath().startsWith("http")) {
                ab.setServerpath(innerImgUrl + ab.getServerpath());
                appMediaRepository.save(ab);
            }
        }
    }

    // 判断db中表是否存在
    private boolean isTableExists(Statement statement, String tableName) throws SQLException {
        String sql = String.format("select count(1) from sqlite_master where type = 'table' and name = '%s'",
                tableName);
        ResultSet rs = statement.executeQuery(sql);
        int iResult = 0;
        while (rs.next()) {
            iResult = rs.getInt(1);
        }

        return iResult > 0;
    }

    private boolean isColumnExist(ResultSet rs, String columnName) {
        try {
            if (rs.findColumn(columnName) > 0) {
                return true;
            }
        } catch (SQLException e) {
            return false;
        }
        return false;
    }

    // 恢复删除的随手拍
    public int recoverByIds(String ids) throws Exception {
        int count = 0;
        String[] idArr = ids.split(",");
        for (int i = 0; i < idArr.length; i++) {
            AppBasic appBasic = appBasicRepository.findById(idArr[i]).orElse(null);
            appBasic.setIsDeleted(0);
            appBasicRepository.save(appBasic);
            count++;
        }
        return count;
    }

    @Override
    public void recoverAll(Long userId) throws Exception {

    }

    // 恢复所有的随手拍
   /* public void recoverAll(Long userId) throws Exception {
        List<AppBasic> list = appBasicRepository.getAllDeleted(userId + "");
        if (list != null) {
            List<SyncLog> logList = new ArrayList<>();
            for (AppBasic appBasic : list) {
                appBasic.setIsDeleted(0);

                // 增加操作日志
                List<SyncLog> syncList = syncLogRepository.getSyncLogByIdAndState(appBasic.getId(), 1);
                AppBasic detailById = appBasicRepository.findOne(appBasic.getId());
                if (syncList != null && syncList.size() > 0) {
                    // 如果存在未更新的，且状态为删除的，则将操作状态修改为更新
                    SyncLog syncLog = syncList.get(0);
                    if (syncLog.getOpttype() == 3) {
                        syncLog.setState(1);
                        syncLog.setOpttype(2);
                        syncLog.setData(JSONObject.toJSONString(detailById));
                        syncLog.setOpttime(new Date());
                        logList.add(syncLog);
                    }
                } else {
                    // 已经同步过的，需要增加操作日志，操作类型为新增
                    SyncLog syncLog = new SyncLog();
                    syncLog.setId(UUID.randomUUID().toString());
                    syncLog.setObjtype(1);
                    syncLog.setObjid(appBasic.getId());
                    syncLog.setOpttype(1);
                    syncLog.setOpttime(new Date());
                    syncLog.setOptori(2);
                    syncLog.setState(1);
                    syncLog.setData(JSONObject.toJSONString(detailById));
                    syncLog.setOptuserid(userId);
                    logList.add(syncLog);
                }
            }
            appBasicRepository.save(list);
            if (logList.size() > 0) {
                syncLogRepository.save(logList);
            }
        }
    }*/

    // 彻底删除随手拍
    public int shiftDeleteByIds(String ids) throws Exception {
        int count = 0;
        String[] idArr = ids.split(",");
        for (int i = 0; i < idArr.length; i++) {
            AppBasic appBasic = appBasicRepository.findById(idArr[i]).orElse(null);
            appBasic.setIsDeleted(2);
            appBasicRepository.save(appBasic);
            count++;
        }
        return count;
    }

    // 获取单位的随手拍列表
    public Page<AppBasic> getMyOrgList(Long userId, int start, int limit, String filterParam, String sortParam,
                                       String organizationId) {
        List<Organization2User> list = organization2UserDao.queryByUserId(userId);
        if (list.isEmpty()) {
            throw new RuntimeException("无单位");
        }
        // 单位id
        if (StringUtils.isBlank(organizationId)) {
            organizationId = list.get(0).getOrganizationId();
        }
        filterParam += ";Q_isDeleted_N_EQ=0;Q_userid_S_EQ=" + organizationId;
        Page<AppBasic> appBasics = appBasicRepository.findAll(new QuerySpecification<AppBasic>(filterParam),
                 PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));
        for (AppBasic appBasic : appBasics) {
            // List<AppMedia> mds = appMediaRepository.queryByGid(appBasic.getId());
            AppMedia appMedia = this.getFirstPhont(appBasic.getId());
            AppMedia app = new AppMedia();
            if (appMedia != null) {
                BeanUtil.copyProperties(appMedia, app);
                if (StringUtils.isNotBlank(appMedia.getServerpath())) {
                    String temporarySignedUrl = temporarySignedUrlService.getTemporarySignedUrl("", appMedia.getServerpath(), null);
                    app.setServerpath(temporarySignedUrl);
                }
            }
            appBasic.setCurMedia(app);
            // appBasic.setList(mds);
        }

        return appBasics;

    }

    public AppBasic getDetailByIdAndOwnerId(Long userId, String id, String ownerId, String filterParam,
                                            String sortParam) {
        if (StringUtils.isBlank(ownerId)) {
            List<Organization2User> list = organization2UserDao.queryByUserId(userId);
            if (list.isEmpty()) {
                throw new RuntimeException("无单位");
            }
            ownerId = list.get(0).getOrganizationId();
        }
        return getDetailById(id, ownerId, filterParam, sortParam);
    }

    public AppBasic getMyShareDetail(String shareId, Long userId, String filter) {
        APicShare share = aPicShareRepository.findById(shareId).orElse(null);
        if (share == null) {
            throw new RuntimeException("该分享不存在");
        }
        String appBasicId = share.getOldId();
        String appBasicInfo = share.getAppBasicInfo();
        AppBasic appBasic = null;
        if (StringUtils.isNotBlank(appBasicInfo)) {
            appBasic = JSON.parseObject(appBasicInfo, AppBasic.class);
            List<AppMedia> list = appBasic.getList();
            if (list != null) {
                for (AppMedia appMedia : list) {
                    if (appMedia.getType() == 1 || appMedia.getType() == 2) {
                        appBasic.setCurMedia(appMedia);
                        break;
                    }
                }
            }
        } else {
            appBasic = appBasicRepository.findById(share.getOldId()).orElse(null);
            List<AppMedia> mds = appMediaRepository.queryByGid(appBasicId);
            appBasic.setCurMedia(this.getFirstPhont(appBasicId));
            appBasic.setList(mds);
        }

        List<APicShare> previousShares = aPicShareRepository.getPreviousShare(share.getShareTime(), userId,
                "%" + filter + "%",  PageRequest.of(0, 1,  Sort.by(Sort.Direction.ASC, "f_sharetime")));
        List<APicShare> nextShares = aPicShareRepository.getNextShare(share.getShareTime(), userId,
                "%" + filter + "%",  PageRequest.of(0, 1,  Sort.by(Sort.Direction.DESC, "f_sharetime")));

        if (!previousShares.isEmpty()) {
            appBasic.setPrevious(previousShares.get(0).getId());
        }
        if (!nextShares.isEmpty()) {
            appBasic.setNext(nextShares.get(0).getId());
        }

        return appBasic;

    }

    public List<AppBasic> getBasicListByIds(List tbids, long userId) {
        return appBasicRepository.getBasicListByIds(tbids, userId + "");
    }

    // 构造成多业务表的字段参数模式
    public JSONObject buildJSONParam(String userId, String tbId) {
        JSONObject jsonObject = new JSONObject();

        AppBasic appBasic = getDetailById(tbId, userId, "", "");
        JSONArray fields = new JSONArray();
        fields.add(buildFieldsJSON("heading", "名称", "", 20L, 0L, 1L, 0L));
        fields.add(buildFieldsJSON("type", "快拍类型", "", 20L, 0L, 1L, 0L));
        fields.add(buildFieldsJSON("name", "拍摄地点", "", 20L, 0L, 1L, 0L));
        fields.add(buildFieldsJSON("time", "拍摄时间", "", 20L, 0L, 1L, 0L));
        fields.add(buildFieldsJSON("username", "拍摄人员", "", 20L, 0L, 1L, 0L));
        fields.add(buildFieldsJSON("desc", "外业描述", "", 20L, 0L, 1L, 0L));

        jsonObject.put("fields", fields);
        String userName = appBasic.getUsername();
        userName = userNameService.getUserRealNameByUserName(appBasic.getUsername());
        //LandUser landUser = landuserService.queryUserByName(appBasic.getUsername());
        //if (landUser != null) {
        //    userName = userNameService.getUserRealNameByUserName(appBasic.getUsername());
        //}

        JSONObject tbInfo = new JSONObject();
        tbInfo.put("heading", appBasic.getHeading());
        tbInfo.put("type", appBasic.getType());
        tbInfo.put("name", appBasic.getName());
        tbInfo.put("time", appBasic.getTime());
        tbInfo.put("username", userName);
        tbInfo.put("requestId", appBasic.getRequestId());
        tbInfo.put("shape", appBasic.getShape());
        tbInfo.put("desc", appBasic.getDesc());

        jsonObject.put("tbInfo", tbInfo);
        jsonObject.put("prev", appBasic.getPrevious());
        jsonObject.put("next", appBasic.getNext());

        return jsonObject;
    }

    private JSONObject buildFieldsJSON(String fieldName, String alias, String fieldType, Long length, Long order, Long
            isBase, Long isOutWork) {
        JSONObject field = new JSONObject();
        field.put("fId", "");
        field.put("fTableid", "ssp");
        field.put("fTablename", "");
        field.put("fFieldname", fieldName);
        field.put("fAlias", alias);
        field.put("fIsprimary", "");
        field.put("fFieldtype", fieldType);
        field.put("fLength", length);
        field.put("fPrecision", "");
        field.put("fNullable", "");
        field.put("fDefaultvalue", "");
        field.put("fCodetableid", "");
        field.put("fRemark", "");
        field.put("fOrder", order);
        field.put("fIsBase", isBase);
        field.put("fIsOutwork", isOutWork);
        return field;
    }

    /**
     * 更新经纬度坐标
     *
     * @param id
     * @return
     */
    public boolean updateLonLatById(String id) {
        return appBasicRepository.updateLonLatById(id) > 0;
    }


}
