package com.geoway.landteam.landcloud.service.businessapps;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.dao.businessapps.*;
import com.geoway.landteam.landcloud.model.businessapps.dto.*;
import com.geoway.landteam.landcloud.model.businessapps.entity.*;
import com.geoway.landteam.landcloud.servface.businessapps.BusAppsInfoService;
import com.geoway.landteam.landcloud.servface.businessapps.BusFunctionService;
import com.geoway.landteam.landcloud.servface.filestorage.FileStorageService;
import com.geoway.landteam.landcloud.service.util.UserAuthHttpUtils;
import com.gw.base.data.GwValidateException;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.commons.lang3.StringUtils;
import org.geolatte.geom.M;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

import java.sql.Timestamp;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.platform.businessapps.service.bus
 * @date 2023/4/14 11:03
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class BusAppsInfoServiceImpl implements BusAppsInfoService {

    @Value("${spring.security.oauth2.client.provider.gas-cqfzx.createAppInfo-uri:}")
    private  String createAppInfo_uri;
    @Value("${spring.security.oauth2.client.provider.gas-cqfzx.getAppByAppId-uri:}")
    private  String getAppByAppId_uri;
    @Value("${spring.security.oauth2.client.registration.gas-cqfzx.loginBack-uri:}")
    private  String loginBack_uri;
    @Value("${spring.security.oauth2.client.registration.gas-cqfzx.logout-uri:}")
    private  String logout_uri;
    @Value("${spring.security.oauth2.client.registration.gas-cqfzx.appslogin-uri:}")
    private  String appslogin_uri;

    @Autowired
   private BusAppsInfoDao busAppsInfoDao;
    @Autowired
   private BusAppsManagerDao busAppsManagerDao;
    @Autowired
   private BusAppsConfigDao busAppsConfigDao;
    @Autowired
   private BusAppsApproveRecordDao busAppsApproveRecordDao;

    @Autowired
   private BusFunctionService busFunctionService;

    @Autowired
   private BusAppsFunctionRelDao busAppsFunctionRelDao;

    @Autowired
   private BusFunctionDefaultDao busFunctionDefaultDao;

    @Autowired
   private BusFunctionModuleDao busFunctionModuleDao;

    @Autowired
   private BusFunctionModuleDefaultDao busFunctionModuleDefaultDao;

   /* @Autowired
    private GiFileStorageService fileStorageService;*/

  /*  @Autowired
    GwFileControlApi gwFileControlApi;*/
    @Autowired
    FileStorageService fileStorageService;

    @Autowired
    private BusFunctionDao busFunctionDao;
    @Autowired
    private BusAppsSchemaDao busAppsSchemaDao;
    
   /* @Autowired
    private AppServeService appServeService;*/




    @Override
    public BusAppsInfoPo addBusApps(String userId, MultipartFile logfile, MultipartFile loginfile, MultipartFile
            backgroundfile, BusAppsInfoPo busAppsInfoPo, List<String> busFunctionIds) {

        BusAppsInfoPo bean  = new BusAppsInfoPo(null);
        BeanUtils.copyProperties(busAppsInfoPo, bean,"id","status");

        String ossPath = "busapps/" + System.currentTimeMillis() + "/";
       /* FileInfo logfileupload = fileStorageService.of(new SpringMultipartFile(logfile)).setPath(ossPath) .upload();
        FileInfo loginfileupload = fileStorageService.of(new SpringMultipartFile(loginfile)).setPath(ossPath) .upload();
        FileInfo backgroundfileupload = fileStorageService.of(new SpringMultipartFile(backgroundfile)).setPath(ossPath) .upload();*/
       /* GSdkFileInfoApo logfileupload = gwFileControlApi.upload(new SpringSdkMultipartFile(logfile), FileSdkConfig.mPrivateBucketName, ossPath);
        GSdkFileInfoApo loginfileupload = gwFileControlApi.upload(new SpringSdkMultipartFile(loginfile), FileSdkConfig.mPrivateBucketName, ossPath);
        GSdkFileInfoApo backgroundfileupload = gwFileControlApi.upload(new SpringSdkMultipartFile(backgroundfile), FileSdkConfig.mPrivateBucketName, ossPath);*/
        String logfileupload = fileStorageService.saveFile(logfile, ossPath);
        String loginfileupload = fileStorageService.saveFile(loginfile, ossPath);
        String backgroundfileupload = fileStorageService.saveFile(backgroundfile, ossPath);
        bean.setLoginUrl(loginfileupload);
        bean.setLogUrl(logfileupload);
        bean.setBackgroundUrl(backgroundfileupload);
        bean.setStatus(0);
        bean.setStage(1);
        bean.setIsFinish(0);
        bean.setUserId(userId);
        bean.setCreateTime(new Timestamp(System.currentTimeMillis()));
        busAppsInfoDao.gwAccessSelective(bean);
        //插入应用相关功能
        if(busFunctionIds.size() > 0 ){
            for(String s : busFunctionIds){
               /* BusAppsFunctionRelPo busAppsFunctionRelPo = new BusAppsFunctionRelPo(null);
                busAppsFunctionRelPo.setAppsId(bean.getId());
                busAppsFunctionRelPo.setFunctionId(s);
                busAppsFunctionRelDao.gwAccessSelective(busAppsFunctionRelPo);*/
                //生成应用自己的业务功能和模块
                insertFunctionAndModule(s,bean.getId());
            }
        }
        String schemaName = getSchemaName(busAppsInfoPo.getAppsName());
        //创建应用对应的模式
        String sql = "CREATE SCHEMA  \""+schemaName+"\" ;COMMENT ON SCHEMA \""+schemaName+"\" IS 'standard "+schemaName+" schema';";
        busAppsSchemaDao.excuteSql(sql);
        BusAppsSchemaPo busAppsSchemaPo = new BusAppsSchemaPo(null);
        busAppsSchemaPo.setAppsId(bean.getId());
        busAppsSchemaPo.setSchema(schemaName);
        busAppsSchemaPo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        busAppsSchemaDao.gwAccessSelective(busAppsSchemaPo);
        //创建应用业务大类
         busAppsSchemaDao.insertClassTask(busAppsInfoPo.getAppsName(),101, bean.getLogUrl(), bean .getId());
        Integer classId = busAppsSchemaDao.excuteSeqCurrValue("seq_tbtsk_task_class_num_id");
        //用户业务大类授权
        String  userClassSql =  "INSERT INTO public.tbtsk_user_task_class (f_id, f_userid, f_classid,f_createdate)VALUES(uuid_generate_v4(), '"+userId+"' ,'"+classId+"', now()); " ;
/*
        String  userClassSql =  "INSERT INTO public.tbtsk_user_task_class (f_id, f_userid, f_classid,f_createdate) " +
                "select uuid_generate_v4(),f_userid ,'"+classId+"',now() from tbsys_user_subject_rel where  f_subject_userid ='"+userId+"'";
*/
        busAppsSchemaDao.excuteSql(userClassSql);
        return bean;
    }


    //生成应用自己的业务功能和模块
    public void insertFunctionAndModule(String functionId,String appsId){
        //插入对应业务功能
        BusFunctionDefaultPo busFunctionDefaultPo = busFunctionDefaultDao.gwSearchByPK(functionId);
          BusFunctionPo busFunctionPo = new BusFunctionPo(null);
          BeanUtils.copyProperties(busFunctionDefaultPo,busFunctionPo,"id");
          busFunctionPo.setAppsId(appsId);
          busFunctionPo.setDefaultFunctionId(functionId);
          busFunctionPo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        busFunctionDao.gwAccessSelective(busFunctionPo);
        //插入对应业务功能模块
        List<BusFunctionModuleDefaultDto> byFunctionId = busFunctionModuleDefaultDao.findByFunctionId(functionId);
          for(BusFunctionModuleDefaultDto b : byFunctionId){
              BusFunctionModulePo busFunctionModulePo = new BusFunctionModulePo(null);
              BeanUtils.copyProperties(b,busFunctionModulePo,"id");
              busFunctionModulePo.setFunctionId(busFunctionPo.getId());
              busFunctionModulePo.setPlatformUrl(b.getPlatformUrl() != null ? b.getPlatformUrl()+"?appsId="+busFunctionPo.getAppsId():null);
              busFunctionModulePo.setCreateTime(new Timestamp(System.currentTimeMillis()));
              busFunctionModuleDao.gwAccessSelective(busFunctionModulePo);
          }
    }

    @Override
    public BusAppsInfoPo updateBusApps(String userId, MultipartFile logfile, MultipartFile loginfile, MultipartFile backgroundfile, BusAppsInfoPo busAppsInfoPo,List<String> busFunctionIds) throws Exception {
        BusAppsInfoPo bean  = busAppsInfoDao.gwSearchByPK(busAppsInfoPo.getId());
        if(bean.getStatus() == 1 && bean.getStage() == 1){
            throw new GwValidateException("应用创建申请已审核通过不能再进行修改，请检查数据！");
        }
        BeanUtils.copyProperties(busAppsInfoPo, bean,"id","status");

        String ossPath = "busapps/" + System.currentTimeMillis() + "/";
        if(logfile != null){
           /* FileInfo logfileupload = fileStorageService.of(new SpringMultipartFile(logfile)).setPath(ossPath) .upload();*/
           /* GSdkFileInfoApo logfileupload = gwFileControlApi.upload(new SpringSdkMultipartFile(logfile), FileSdkConfig.mPrivateBucketName, ossPath);
            bean.setLogUrl(logfileupload.getUrl());*/
            String url = fileStorageService.saveFile(logfile, ossPath);
            bean.setLogUrl(url);
        }
        if(loginfile != null){
           /* FileInfo loginfileupload = fileStorageService.of(new SpringMultipartFile(loginfile)).setPath(ossPath) .upload();*/
           /* GSdkFileInfoApo loginfileupload = gwFileControlApi.upload(new SpringSdkMultipartFile(loginfile), FileSdkConfig.mPrivateBucketName, ossPath);
            bean.setLoginUrl(loginfileupload.getUrl());*/
            String url = fileStorageService.saveFile(loginfile, ossPath);
            bean.setLoginUrl(url);
        }
        if(backgroundfile != null){
           /* FileInfo backgroundfileupload = fileStorageService.of(new SpringMultipartFile(backgroundfile)).setPath(ossPath) .upload();*/
           /* GSdkFileInfoApo backgroundfileupload = gwFileControlApi.upload(new SpringSdkMultipartFile(backgroundfile), FileSdkConfig.mPrivateBucketName, ossPath);
            bean.setBackgroundUrl(backgroundfileupload.getUrl());*/
            String url = fileStorageService.saveFile(backgroundfile, ossPath);
            bean.setBackgroundUrl(url);
        }
        bean.setUserId(userId);
        bean.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        busAppsInfoDao.gwUpdateByPKSelective(bean);
        if(busFunctionIds.size() > 0 ) {
            List<BusFunctionDto> busFunctionsByappId = busFunctionDao.findBusFunctionsByappId(bean.getId());
            List<String> defaultFunctionId = busFunctionsByappId.stream().map(BusFunctionDto::getDefaultFunctionId).collect(Collectors.toList());
            List<String> collect = Stream.of(busFunctionIds, defaultFunctionId).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            for (String s : collect) {
                if (busFunctionIds.contains(s) && !defaultFunctionId.contains(s)) {  //新增
                    //生成应用自己的业务功能和模块
                    insertFunctionAndModule(s, bean.getId());
                } else if (defaultFunctionId.contains(s) && !busFunctionIds.contains(s)) { //删除
                    //删除已有业务功能和模块
                    //1. 检查是否配置完成
                    //检查配置是否全部完成
                    Integer getNoModuleConfigCount = busFunctionModuleDao.getNoModuleConfigCount(s, bean.getId());
                    //配置完成不能删除
                    if (getNoModuleConfigCount <= 0) {
                        for (BusFunctionDto busFunctionDto : busFunctionsByappId) {
                            if (s.equals(busFunctionDto.getDefaultFunctionId())) {
                                throw new GwValidateException(busFunctionDto.getFunctionName() + "已配置完成不能移除，请检查配置！");
                            }
                        }

                    } else {
                        //未配置完成可以进行删除
                        //删除功能模块
                        busFunctionModuleDao.delModuleByFunctionId(s, bean.getId());
                        //删除业务功能
                        busFunctionDao.delByFunctionId(s, busAppsInfoPo.getId());
                    }
                }
            }
        }
        return bean;
    }

    @Override
    public BusAppsInfoDto findBusAppsDetailsById(String appsId) {
        BusAppsInfoPo busAppsInfoPo = busAppsInfoDao.gwSearchByPK(appsId);
        BusAppsConfigPo busAppsConfigPo = busAppsConfigDao.gwSearchByPK(appsId);
      /*  if(busAppsConfigPo != null){
            SubjectAppApo appByAppId = appServeService.getAppByAppId(busAppsConfigPo.getDataId(), AppInfoStatusEnum.发布审核通过);
            List<SubjectAppApo> appsByNameLike = appServeService.getAppsByNameLike(busAppsInfoPo.getAppsName(), AppInfoStatusEnum.发布审核通过);
            List<SubjectAppApo> morning = appServeService.getAppsByAppIds(new HashSet<String>() {{
                add("morning");
                add(busAppsConfigPo.getDataId());
            }},AppInfoStatusEnum.发布审核通过);
        }*/
        if(busAppsConfigPo != null){
            Map<String,Object> params=new HashMap<>();
            params.put("appId",appsId);
            params.put("stateActive",1);
            JSONObject jsonObject =UserAuthHttpUtils.accessAppsInterface(getAppByAppId_uri, params);
             if(jsonObject != null){
                 String appId = jsonObject.getString("appId");
                 Integer stateActive = jsonObject.getInteger("stateActive");
             }
        }
        BusAppsInfoDto bean = new BusAppsInfoDto();
        BeanUtils.copyProperties(busAppsInfoPo, bean);
        List<BusFunctionDto> busFunctionAndModulesByappId = busFunctionService.findBusFunctionAndModulesByappId(appsId);
        bean.setBusFunctionList(busFunctionAndModulesByappId);
        List<BusAppsManagerDto> busAppsManagerDtos = busAppsManagerDao.findByAppsId(appsId);
        bean.setBusAppsManagerDtos(busAppsManagerDtos);
        //获取附件的临时访问地址
        if(bean.getLogUrl() != null && !bean.getLogUrl().contains("AccessKeyId")){
            String url = fileStorageService.generatePresignedUrlByUrl(bean.getLogUrl());
            bean.setLogUrl(url);
        }
        if(bean.getLoginUrl() != null && !bean.getLoginUrl().contains("AccessKeyId")){
            String url = fileStorageService.generatePresignedUrlByUrl(bean.getLoginUrl());
            bean.setLoginUrl(url);
        }
        if(bean.getBackgroundUrl() != null && !bean.getBackgroundUrl().contains("AccessKeyId")){
           /* String url = gwFileControlApi.generatePresignedUrlByUrl(bean.getBackgroundUrl(), 3600L, "GET");*/
            String url = fileStorageService.generatePresignedUrlByUrl(bean.getBackgroundUrl());
            bean.setBackgroundUrl(url);
        }
        return bean;
    }

    @Override
    public void delBusApps(String userId,String appsId) {
        BusAppsInfoPo busAppsInfoPo = busAppsInfoDao.gwSearchByPK(appsId);
        if(busAppsInfoPo.getStatus() == 1){
            throw new GwValidateException( "已审核通过不能移除，请检查配置！");
        }
        /*    busAppsInfoPo.setStatus(3);
            busAppsInfoPo.setUpdateTime(new Timestamp(System.currentTimeMillis()));*/
        busAppsInfoDao.gwDeleteByPK(appsId);
        //删除对应功能
        busAppsFunctionRelDao.delByAppId(appsId);
        BusAppsSchemaDto byAppsId = busAppsSchemaDao.findByAppsId(appsId);
        if(byAppsId != null){
            //删除业务大类及相关的调查任务和线索数据
            String delsql =" ------------线索配置相关数据删除---------------------\n" +
                    "--模板字段\n" +
                    "delete from jc_clue_fields jcf where f_tableid  in (select jct.f_id  from jc_clue_template jct where f_appsid  = '"+appsId+"');\n" +
                    "--模板数据\n" +
                    "delete from jc_clue_template jct where f_appsid  = '"+appsId+"';\n" +
                    "--线索配置字段\n" +
                    "delete from jc_clue_fields jcf where f_tableid  in (select jct.f_id  from jc_clue_source  jct where f_appsid  = '"+appsId+"');\n" +
                    "--线索配置group\n" +
                    "delete from jc_clue_group jcg  where f_tablename  in (select jcs.f_tablename  from jc_clue_source jcs  where jcs.f_appsid ='"+appsId+"' );\n" +
                    "-----------调查任务相关数据删除\n" +
                    "--模板tbtsk_fields\n" +
                    "delete from tbtsk_fields   where f_tableid in (select tt.f_tableid  from tbtsk_template tt where tt.f_classid  = (select f_id  from tbtsk_task_class ttc  where f_appkey ='"+appsId+"'));  \n" +
                    "--模板tbtsk_group\n" +
                    "delete from tbtsk_group  where f_tablename in (select tt.f_tableid  from tbtsk_template tt where tt.f_classid  = (select f_id  from tbtsk_task_class ttc  where f_appkey ='"+appsId+"'));\n" +
                    "--线索数据jc_clue_source\n" +
                    "delete from jc_clue_source jcs  where jcs.f_appsid  = '"+appsId+"'; "+
                    "--模板数据tbtsk_template\n" +
                    "delete from  tbtsk_template tt where tt.f_classid  = (select f_id  from tbtsk_task_class ttc  where f_appkey ='"+appsId+"');\n" +
                    "--任务tbtsk_fields\n" +
                    "delete from tbtsk_fields where f_tableid in (select tt.f_tableid  from tbtsk_task_biz  tt where tt.f_classid  = (select f_id  from tbtsk_task_class ttc  where f_appkey ='"+appsId+"')); \n" +
                    "--tbtsk_group\n" +
                    "delete from tbtsk_group where f_tablename  in(select to2.f_tablename  from tbtsk_task_biz  tt,tbtsk_objectinfo to2  where to2.f_id  =tt.f_tableid  and tt.f_classid  = (select f_id  from tbtsk_task_class ttc  where f_appkey ='"+appsId+"') );\n" +
                    "--任务tbtsk_objectinfo\n" +
                    "delete from tbtsk_objectinfo where f_id  in (select tt.f_tableid  from tbtsk_task_biz  tt where tt.f_classid  = (select f_id  from tbtsk_task_class ttc  where f_appkey ='"+appsId+"') );\n" +
                    "--任务信息tbtsk_task_biz\n" +
                    "delete from tbtsk_task_biz where f_classid in (select f_id  from tbtsk_task_class ttc  where f_appkey ='"+appsId+"');\n" +
                    "--业务大类\n" +
                    "delete from tbtsk_task_class ttc  where f_appkey ='"+appsId+"';";
            busAppsSchemaDao.excuteSql(delsql);
            //删除数据库模式
            String sql = "DROP SCHEMA  \""+byAppsId.getSchema()+"\" CASCADE;";
            busAppsSchemaDao.excuteSql(sql);
        }

    }

    @Override
    public void saveBusAppsConfig(String userId,String orgId,String appsId) throws Exception {
        BusAppsInfoPo busAppsInfoPo = busAppsInfoDao.gwSearchByPK(appsId);
        //检查配置是否全部完成
        Integer noFinishConfigCount = busFunctionModuleDao.getNoFinishConfigCount(appsId);
        if(noFinishConfigCount <= 0 ){
            busAppsInfoPo.setIsFinish(1);
            busAppsInfoPo.setStage(1);
            busAppsInfoDao.gwUpdateByPKSelective(busAppsInfoPo);
        }else{
            throw new GwValidateException("配置未完成，请检查配置！");
        }
    }

    @Override
    public void addBusAppsManagers(String appsId, List<String> userIds) {
        for(String s : userIds){
            //将用户添加到bus_apps_manager表
            BusAppsManagerPo busAppsManagerPo = new BusAppsManagerPo(null);
                busAppsManagerPo.setAppsId(appsId);
                busAppsManagerPo.setUserId(s);
                busAppsManagerPo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            busAppsManagerDao.gwAccessSelective(busAppsManagerPo);
            //获取用户政区
            Map map = busAppsSchemaDao.selectByID("tbsys_user_area ", "f_userid", "'" + s + "'");
            if(map != null){
                String f_regioncode = map.get("f_regioncode").toString();
                int level =1;
                if(f_regioncode.length() >= 6 ){
                    if(f_regioncode.endsWith("0000")){
                        level =1;
                    }else if(f_regioncode.endsWith("00")){
                        level =2;
                    }else{
                        level =3;
                    }
                }else if(f_regioncode.length() >= 9){
                    level = 4;
                }else if(f_regioncode.length() >= 12){
                    level = 5;
                }
                //增加任务管理员权限
                String biz2sql = "INSERT INTO public.tbsys_user_biz2 (f_userid, f_bizid, f_id, f_role) select '"+s+"',ttb.f_id,uuid_generate_v4(),'1' from tbtsk_task_biz ttb  inner join " +
                        "tbtsk_task_class ttc on (ttb.f_classid =ttc.f_id  )and ttc.f_appkey ='"+appsId+"' and  NOT " +
                        "exists (select 1 from tbsys_user_biz2 biz where biz.f_bizid = ttb.f_id and biz.f_userid  ='"+s+"'  and biz.f_role = '1') ;";
                busAppsSchemaDao.excuteSql(biz2sql);
                //增加管理区
                String managersql = "INSERT INTO public.tbtsk_user_manage_area ( f_taskid, f_userid, f_level,f_regioncode)  select ttb.f_id,'"+s+"','"+level+"','"+f_regioncode+"' from tbtsk_task_biz ttb  inner join " +
                        "tbtsk_task_class ttc on (ttb.f_classid =ttc.f_id  ) and ttc.f_appkey ='"+appsId+"' and not exists (select * from tbtsk_user_manage_area a where a.f_taskid = ttb.f_id and a" +
                        ".f_regioncode ='"+f_regioncode+"' and a.f_userid ='"+s+"' and a.f_level ='"+level+"');";
                busAppsSchemaDao.excuteSql(managersql);
            }
        }
    }

    @Override
    public void addOrUpdateBusAppsManagers(String appsId ,List<BusAppsManagerPo> busAppsManagerPos) {
        //不管是新增还是删除，先删除对应的数据
        busAppsManagerDao.delByAppsId(appsId);
        for(BusAppsManagerPo bean : busAppsManagerPos){
            bean.setCreateTime(new Timestamp(System.currentTimeMillis()));
            busAppsManagerDao.gwAccessSelective(bean);

            String s = bean.getUserId();
            //获取用户政区
            Map map = busAppsSchemaDao.selectByID("tbsys_user_area ", "f_userid", "'" + s + "'");
            if(map != null) {
                String f_regioncode = map.get("f_regioncode").toString();
                int level = 1;
                if (f_regioncode.length() >= 6) {
                    if (f_regioncode.endsWith("0000")) {
                        level = 1;
                    } else if (f_regioncode.endsWith("00")) {
                        level = 2;
                    } else {
                        level = 3;
                    }
                } else if (f_regioncode.length() >= 9) {
                    level = 4;
                } else if (f_regioncode.length() >= 12) {
                    level = 5;
                }
                //增加任务管理员权限
                String biz2sql = "INSERT INTO public.tbsys_user_biz2 (f_userid, f_bizid, f_id, f_role) select '" + s + "',ttb.f_id,uuid_generate_v4(),'1' from tbtsk_task_biz ttb  inner join " +
                        "tbtsk_task_class ttc on (ttb.f_classid =ttc.f_id  )and ttc.f_appkey ='" + appsId + "' and  NOT " +
                        "exists (select 1 from tbsys_user_biz2 biz where biz.f_bizid = ttb.f_id and biz.f_userid  ='" + s + "'  and biz.f_role = '1') ;";
                busAppsSchemaDao.excuteSql(biz2sql);
                //增加管理区
                String managersql = "INSERT INTO public.tbtsk_user_manage_area ( f_taskid, f_userid, f_level,f_regioncode)  select ttb.f_id,'" + s + "','" + level + "','" + f_regioncode + "' from tbtsk_task_biz ttb  inner join " +
                        "tbtsk_task_class ttc on (ttb.f_classid =ttc.f_id  ) and ttc.f_appkey ='" + appsId + "' and not exists (select * from tbtsk_user_manage_area a where a.f_taskid = ttb.f_id and a" +
                        ".f_regioncode ='" + f_regioncode + "' and a.f_userid ='" + s + "' and a.f_level ='" + level + "');";
                busAppsSchemaDao.excuteSql(managersql);
            }
        }
    }

    @Override
    public void publishBusApplication(String appsId) {
        BusAppsInfoPo busAppsInfoPo = busAppsInfoDao.gwSearchByPK(appsId);
         if(busAppsInfoPo.getIsFinish() != 1){
             throw new GwValidateException("配置未完成，请检查配置！");
         }else{
             busAppsInfoPo.setStage(1);
             busAppsInfoPo.setStatus(0);
             busAppsInfoDao.gwUpdateByPK(busAppsInfoPo);
         }
    }

    @Override
    public void cancelBusApplication(String appsId) {
        BusAppsInfoPo busAppsInfoPo = busAppsInfoDao.gwSearchByPK(appsId);
        if(busAppsInfoPo.getIsFinish() == 1 && busAppsInfoPo.getStage() == 1 && busAppsInfoPo.getStatus() == 1){
            busAppsInfoPo.setStage(2);
            busAppsInfoPo.setStatus(0);
            busAppsInfoDao.gwUpdateByPK(busAppsInfoPo);
        }else{
            throw new GwValidateException("业务任务阶段还不满足下架，请检查配置！");
        }
    }

    @Override
    public BusAppsApproveRecordPo addBusAppsApproveRecord(String userId,String orgId,BusAppsApproveRecordPo record) throws Exception {
        BusAppsInfoPo busAppsInfoPo = busAppsInfoDao.gwSearchByPK(record.getAppsId());
        record.setCreateTime(new Timestamp(System.currentTimeMillis()));
        busAppsApproveRecordDao.gwAccessSelective(record);
        //审核通过
        if(record.getApproveStatus() == 1){
            busAppsInfoPo.setStatus(1);
            //调应用中心同步业务应用数据
            /*BusAppsInfoModel param = new BusAppsInfoModel();
            BeanUtils.copyProperties(busAppsInfoPo, param);
            if(busAppsInfoPo.getLogUrl() != null && !busAppsInfoPo.getLogUrl().contains("AccessKeyId")){
                String url = gwFileControlApi.generatePresignedUrlByUrl(busAppsInfoPo.getLogUrl(), 3600L, "GET");
                param.setLogUrl(url);
            }
            if(busAppsInfoPo.getLoginUrl() != null && !busAppsInfoPo.getLoginUrl().contains("AccessKeyId")){
                String url = gwFileControlApi.generatePresignedUrlByUrl(busAppsInfoPo.getLoginUrl(), 3600L, "GET");
                param.setLoginUrl(url);
            }
            if(busAppsInfoPo.getBackgroundUrl() != null && !busAppsInfoPo.getBackgroundUrl().contains("AccessKeyId")){
                String url = gwFileControlApi.generatePresignedUrlByUrl(busAppsInfoPo.getBackgroundUrl(), 3600L, "GET");
                param.setBackgroundUrl(url);
            }
            param.setReleaseUnit(orgId);
            BusAppsInfoModel busAppsInfoModel = appServeService.createAppInfo(param);*/
            Map<String,Object> params=new HashMap<>();
            params.put("appsName",busAppsInfoPo.getAppsName());
            params.put("appsDesc",busAppsInfoPo.getAppsDesc());
            params.put("platformUrl",appslogin_uri+busAppsInfoPo.getPlatformUrl());
            params.put("bqszdw",busAppsInfoPo.getBqszdw());
            params.put("jszcdw",busAppsInfoPo.getJszcdw());
            params.put("logUrl",busAppsInfoPo.getLogUrl());
            params.put("loginUrl",busAppsInfoPo.getLoginUrl());
            params.put("backgroundUrl",busAppsInfoPo.getBackgroundUrl());
            params.put("userId",busAppsInfoPo.getUserId());
            params.put("busAppId",busAppsInfoPo.getId());
            params.put("redirectUri",loginBack_uri);
            params.put("writeoffUrl",logout_uri);
            JSONObject jsonObject =UserAuthHttpUtils.accessAppsInterface(createAppInfo_uri, params);
            if(jsonObject != null){
                String appKey = jsonObject.getString("appKey");
                String appSecret = jsonObject.getString("appSecret");
                String appId = jsonObject.getString("appId");
                //将应用中心返回的appkey和scret存到配置表
                if(StringUtils.isNotBlank(appKey)){
                    BusAppsConfigPo busAppsConfigPo = new BusAppsConfigPo();
                    busAppsConfigPo.setAppKey(appKey);
                    busAppsConfigPo.setAppSecret(appSecret);
                    busAppsConfigPo.setAppsId(busAppsInfoPo.getId());
                    busAppsConfigPo.setDesc(busAppsInfoPo.getAppsName());
                    busAppsConfigPo.setDataId(appId);
                    busAppsConfigDao.gwAccessSelective(busAppsConfigPo);
                }
            }
        }else if(record.getApproveStatus() == 2){//审核不通过
            busAppsInfoPo.setStatus(2);
        }
        busAppsInfoPo.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        busAppsInfoDao.gwUpdateByPKSelective(busAppsInfoPo);
        
        return record;
    }

    @Override
    public List<BusAppsInfoDto> loginInfo(String platformUrl) {
        List<BusAppsInfoDto> list = busAppsInfoDao.findByPlatformUrl(platformUrl);
        return list;
    }

    @Override
    public int getCount(String primaryField, String Fid) {
        return busAppsInfoDao.getCount(primaryField,Fid);
    }


    private String getSchemaName(String schemaName) {
        // 规则：默认字段名为“f_”加上字段别名的前8位中文首字母，长度最大为10个长度，
        // 如果同一张表，存在相同的字段名
        //      如“f_mj”这种长度不超过7个的，则直接在字段后补充“_n1”，1为存在相同的字段的个数，最终字段名为“f_mj_n1”
        //      如果“f_qmlmjzd”这种长度超过7个的，则截取前7位补充“_n1”，1为存在相同的字段的个数（一般来说不会超过两位数的相同字段名），最终字段名为“f_qmlmj_n1”
        String alias = schemaName;
        String pinYin = getFirstSpell(alias);
        if(pinYin.length()>8){
            pinYin = pinYin.substring(0,8);
        }
        pinYin = "business_apps_" + pinYin;
        //同名第一种情况
        Integer count = busAppsSchemaDao.excuteCountSql( pinYin+"%");
        //如果有第一种情况 才执行 同名第二种情况
        /*if (count > 0) {
            if (pinYin.length() > 7) {
                count += busAppsSchemaDao.excuteCountSql( pinYin.substring(0, pinYin.length() - 3));
            }
        }*/
        if (count > 0) {
            pinYin = pinYin + "_" + (count+1);
           /* if(pinYin.length()+3<=10) {
                pinYin = pinYin + "_n" + count;
            }else{
                pinYin = pinYin.substring(0,pinYin.length()-3) + "_n" + count;
            }*/
        }
        return pinYin;
    }


    public static String getFirstSpell(String chinese) {
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);

        for(int i = 0; i < arr.length; ++i) {
            if (arr[i] > 128) {
                try {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray(arr[i], defaultFormat);
                    if (temp != null) {
                        pybf.append(temp[0].charAt(0));
                    }
                } catch (BadHanyuPinyinOutputFormatCombination var6) {
                    var6.printStackTrace();
                }
            } else {
                pybf.append(arr[i]);
            }
        }

        return pybf.toString().replaceAll("\\W", "").trim();
    }


}
