package com.geoway.landteam.landcloud.service.businessapps;

import com.geoway.landteam.landcloud.dao.businessapps.BusFunctionDefaultDao;
import com.geoway.landteam.landcloud.model.businessapps.dto.BusFunctionDefaultDto;
import com.geoway.landteam.landcloud.model.businessapps.entity.BusFunctionDefaultPo;
import com.geoway.landteam.landcloud.model.businessapps.seo.BusFunctionDefaultSeo;
import com.geoway.landteam.landcloud.servface.businessapps.BusFunctionDefaultService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.platform.businessapps.service.bus
 * @date 2023/4/19 15:41
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class BusFunctionDefaultServiceImpl implements BusFunctionDefaultService {

    @Autowired
    private BusFunctionDefaultDao busFunctionDefaultDao;

    @Override
    public List<BusFunctionDefaultDto> findBusFunctionDefaults(BusFunctionDefaultSeo seo) {
        return busFunctionDefaultDao.searchList(seo);
    }

    @Override
    public List<BusFunctionDefaultPo> findBusFunctionDefaultsByappId(String appsId) {
        return busFunctionDefaultDao.findBusFunctionsByappId(appsId);
    }
}
