package com.geoway.landteam.landcloud.service.businessapps;

import com.geoway.landteam.landcloud.dao.businessapps.BusFunctionModuleDao;
import com.geoway.landteam.landcloud.model.businessapps.entity.BusFunctionModulePo;
import com.geoway.landteam.landcloud.servface.businessapps.BusFunctionModuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.platform.businessapps.service.bus
 * @date 2023/4/19 15:41
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class BusFunctionModuleServiceImpl implements BusFunctionModuleService {

    @Autowired
    private BusFunctionModuleDao busFunctionModuleDao;

    @Override
    public void updateModuleStatus(String moduleId, Integer moduleStatus) {
        BusFunctionModulePo functionModulePo = busFunctionModuleDao.gwSearchByPK(moduleId);
        functionModulePo.setModuleStatus(moduleStatus);
        busFunctionModuleDao.gwUpdateByPKSelective(functionModulePo);
    }
}
