package com.geoway.landteam.landcloud.service.businessapps;

import com.geoway.landteam.landcloud.dao.businessapps.BusFunctionDao;
import com.geoway.landteam.landcloud.dao.businessapps.BusFunctionModuleDao;
import com.geoway.landteam.landcloud.model.businessapps.dto.BusFunctionDto;
import com.geoway.landteam.landcloud.model.businessapps.dto.BusFunctionModuleDto;
import com.geoway.landteam.landcloud.model.businessapps.entity.BusFunctionPo;
import com.geoway.landteam.landcloud.model.businessapps.seo.BusFunctionSeo;
import com.geoway.landteam.landcloud.servface.businessapps.BusFunctionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.platform.businessapps.service.bus
 * @date 2023/4/14 11:04
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class BusFunctionServiceImpl implements BusFunctionService {

    @Autowired
    private BusFunctionDao busFunctionDao;
    @Autowired
    private BusFunctionModuleDao busFunctionModuleDao;

    @Override
    public List<BusFunctionDto> findBusFunctions(BusFunctionSeo seo) {
        return busFunctionDao.searchList(seo);
    }

    @Override
    public List<BusFunctionDto> findBusFunctionsByappId(String appsId) {
        return busFunctionDao.findBusFunctionsByappId(appsId);
    }

    @Override
    public List<BusFunctionDto> findBusFunctionAndModulesByappId(String appsId) {
        List<BusFunctionDto> busFunctionDtos = busFunctionDao.findBusFunctionsByappId(appsId);
          for (BusFunctionDto bean : busFunctionDtos){
              List<BusFunctionModuleDto> busFunctionModuleDtos = busFunctionModuleDao.findByFunctionId(bean.getId());
              bean.setBusFunctionModuleList(busFunctionModuleDtos);
          }
        return busFunctionDtos;
    }

    @Override
    public BusFunctionPo updateFunctionName(String functionId, String functionName) {
        BusFunctionPo busFunctionPo = busFunctionDao.gwSearchByPK(functionId);
         busFunctionPo.setFunctionName(functionName);
        busFunctionDao.gwUpdateByPKSelective(busFunctionPo);
        return busFunctionPo;
    }
}
