package com.geoway.landteam.landcloud.service.cffx;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.lang.Opt;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.TaskRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.multitask.TbtskDataLogService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.dto.TskUploadLogDTO;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.customtask.util.ExcelUtil;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.dao.cffx.CffxTaskDao;
import com.geoway.landteam.landcloud.dao.cffx.CffxTaskDetailDao;
import com.geoway.landteam.landcloud.model.cffx.dto.CffxConfig;
import com.geoway.landteam.landcloud.model.cffx.dto.CffxDataDto;
import com.geoway.landteam.landcloud.model.cffx.dto.CffxDetailConfig;
import com.geoway.landteam.landcloud.model.cffx.dto.CffxDetailInfo;
import com.geoway.landteam.landcloud.model.cffx.enm.CffxStateEnum;
import com.geoway.landteam.landcloud.model.cffx.entity.CffxTask;
import com.geoway.landteam.landcloud.model.cffx.entity.CffxTaskDetail;
import com.geoway.landteam.landcloud.model.cgjcyj.dto.CgjcyjConfig;
import com.geoway.landteam.landcloud.model.cgjcyj.enm.CgjcyjStateEnum;
import com.geoway.landteam.landcloud.model.cgjcyj.entity.CgjcyjNeighbourTb;
import com.geoway.landteam.landcloud.model.cgjcyj.entity.CgjcyjResult;
import com.geoway.landteam.landcloud.servface.cffx.MCffxTaskService;
import com.geoway.landteam.landcloud.service.cgjcyj.MCgjcyjTaskServiceImpl;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.util.TableUtil;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.jcajce.provider.symmetric.AES;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.IsLessThenOrEqualToImpl;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class MCffxTaskServiceImpl implements MCffxTaskService {

    private final GiLoger logger = GwLoger.getLoger(MCffxTaskServiceImpl.class);

    @Autowired
    SysConfigService sysConfigService;

    @Autowired
    SysConfigRepository sysConfigRepository;

    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    @Autowired
    DefaultOssOperatorService ossOperatorService;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;

    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;

    @Autowired
    TaskRecordService taskRecordService;

    @Autowired
    TaskRecordRepository taskRecordRepository;

    @Autowired
    LandUserRepository landUserRepository;

    @Autowired
    TbtskDataLogService tbtskDataLogService;

    @Autowired
    CffxTaskDetailDao cffxTaskDetailDao;

    @Autowired
    CffxTaskDao cffxTaskDao;

    @Autowired
    MDataBizService dataBizService;

    @Autowired
    JdbcTemplate jdbcTemplate;

    //CffxConfig cffxConfig;

    String uploadDir;

    String param;
    final String sysConfigKey = "cffxconfig";

    WKTReader wktReader = new WKTReader();
    /*
    @PostConstruct
    public void init() {
        if (cffxConfig == null) {
            SysConfig config = sysConfigService.findOne(sysConfigKey);
            if (config != null) {
                cffxConfig = JSONObject.parseObject(config.getValue(), CffxConfig.class);
            }
        }
    }
    */
    @Override
    public CffxConfig getConfig() {
        //SysConfig config = sysConfigService.findOne(sysConfigKey);
        SysConfig config = sysConfigRepository.queryByKey(sysConfigKey);
        CffxConfig cffxConfig = null;
        if (config != null) {
             cffxConfig = JSONObject.parseObject(config.getValue(), CffxConfig.class);

        }
        return cffxConfig;
    }


    @Override
    public void createCffxTask(TaskRecord record) {
        HttpURLConnection httpURLConnection = null;
        DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Map<String, TskUploadLogDTO> dataUploadLog = new HashMap();
        TskTaskBiz task =null;
        Long userId = null;
        String tempTable="";
        try {
            //解析参数，执行数据加载
            JSONObject paramsObject = JSONObject.parseObject(record.getParam());
            String uploadurl = temporarySignedUrlService.getTemporarySignedUrl("", paramsObject.getString("unzipFileDir"), null);
            userId = paramsObject.getLong("userId");
            // 统一资源
            URL url = new URL(uploadurl);
            // 连接类的父类，抽象类
            URLConnection urlConnection = url.openConnection();
            // http的连接类
            httpURLConnection = (HttpURLConnection) urlConnection;
            //设置超时
            httpURLConnection.setConnectTimeout(1000 * 60 * 10);
            //设置请求方式，默认是GET
            httpURLConnection.setRequestMethod("GET");
            // 设置字符编码
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            // 打开到此 URL引用的资源的通信链接（如果尚未建立这样的连接）。
            httpURLConnection.connect();
            // 文件大小
            int fileLength = httpURLConnection.getContentLength();
            // 控制台打印文件大小
            /*  logger.info(String.format("%s", "您要下载的文件大小为:", fileLength / (1024 *1024) + "MB"));*/
            // 建立链接从请求中获取数据
            URLConnection con = url.openConnection();
            File zipFile = null;
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
            File dir = new File(uploadDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            zipFile = File.createTempFile("tmp", ".gty", dir);
            FileUtils.copyInputStreamToFile(httpURLConnection.getInputStream(), zipFile);
            String zipName = zipFile.getAbsolutePath();
            String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            Zip4jUtils.unzip(zipName, unzipFileDir, "gtdcy2019");


            //加载数据
            tempTable="cffx_temp_"+StringUtils.replace(UUID.randomUUID().toString(),"-","");
            if(!importData(record,unzipFileDir,tempTable))
            {
                record.setState(JobConstants.JOB_STATE_FAILED);
                record.setRemark("重复分析导入数据到临时表失败");
                jdbcTemplate.execute("drop table "+tempTable);
                taskRecordRepository.gwUpdateByPK(record);

            }

            List<CffxTaskDetail>taskDetails = new ArrayList<>();
            String taskId = paramsObject.getString("taskId");
            task = tskTaskBizService.findByTaskId(taskId);

            String cffxId =UUID.randomUUID().toString();
            CffxTask cffxTask = new CffxTask();
            cffxTask.setId(cffxId);
            cffxTask.setName(task.getName()+"入库重复判断");
            cffxTask.setParam("");
            cffxTask.setState(CffxStateEnum.create.getCode());
            cffxTask.setCreateTime(new Date());
            cffxTask.setLeftName(tempTable);
            cffxTask.setProgress(0);
            cffxTask.setRecordId(record.getId());
            cffxTask.setRelId(taskId);
            cffxTask.setUserId(userId);


            CffxConfig config = getConfig();

            CffxDetailConfig detailConfig=getDetailConfig(config,taskId);

            //userId = paramsObject.getLongValue("userId");
            TbtskObjectinfo objectinfo = tskTaskBizService.getTableByTableId(task.getTableId());
            if(detailConfig.isSelf())
            {

                CffxTaskDetail detail = new CffxTaskDetail();
                detail.setId(UUID.randomUUID().toString());
                detail.setState(CffxStateEnum.create.getCode());
                detail.setTaskId(cffxId);
                detail.setCreateTime(new Date());
                detail.setName(task.getName()+"-内部重复判断");
                detail.setResultName("cffx_"+ StringUtils.replace(UUID.randomUUID().toString(),"-",""));
                detail.setRightName(objectinfo.getfTablename());
                taskDetails.add(detail);


            }
            if(detailConfig.isOther())
            {
                for(CffxDataDto dataDto:detailConfig.getOthers())
                {
                    CffxTaskDetail detail = new CffxTaskDetail();
                    detail.setId(UUID.randomUUID().toString());
                    detail.setState(CffxStateEnum.create.getCode());
                    detail.setTaskId(cffxId);
                    detail.setCreateTime(new Date());
                    detail.setName(task.getName()+"-"+dataDto.getAlias()+"-重复判断");
                    detail.setResultName("cffx_"+ StringUtils.replace(UUID.randomUUID().toString(),"-",""));
                    detail.setRightName(dataDto.getName());
                    taskDetails.add(detail);
                }
            }

            insertCffxTask(cffxTask,taskDetails);

        } catch (Exception e) {
            if(StringUtils.isNotBlank(tempTable)) {
                jdbcTemplate.execute("drop table " + tempTable);
            }
            record.setEndtime(new Date());
            record.setState(JobConstants.JOB_STATE_FAILED); //失败
            String msg = ExceptionUtils.getStackTrace(e);
            logger.error("rateJobDataCffxCreateTask error "+msg);
            if (msg.length() > 1000)
            {
                msg = msg.substring(0,1000);
            }
            record.setRemark(msg);
            taskRecordService.save(record);

        } finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            logger.info("JobRunTask-rateJobCffx 平台任务数据加载重复分析执行结束" + record.getId() + "-" + record.getState() + "-" + df
                    .format(new Date()));
        }
    }

    @Override
    public void startCffxTask(CffxTask task)
    {
        try {

             CffxConfig cffxConfig =  getConfig();

            if (task.getState().equals(CffxStateEnum.create.getCode())) {
                CffxTaskDetail search = new CffxTaskDetail();
                search.setTaskId(task.getId());
                List<CffxTaskDetail> taskDetails = cffxTaskDetailDao.gwSearch(search);
                if (taskDetails == null || taskDetails.isEmpty()) {
                    task.setState(CffxStateEnum.error.getCode());
                    task.setProgress(0);
                    cffxTaskDao.gwUpdateByPK(task);
                    return;
                }
                String db = getDB();
                for (CffxTaskDetail detail : taskDetails) {
                    if (detail.getState().equals(CffxStateEnum.create.getCode())) {
                        if(!TableUtil.hasField(detail.getRightName(),"aid",jdbcTemplate))
                        {
                            TableUtil.createSequence(detail.getRightName(),"aid",detail.getRightName()+"_seq",jdbcTemplate);
                        }


                        if (StringUtils.isBlank(param)) {
                            param = getTemplate();
                        }
                        String curParam = param;

                        Map<String,String>mapParam = new HashMap<>();
                        mapParam.put("{left}",db+"/"+task.getLeftName());
                        mapParam.put("{leftPkField}","aid");
                        mapParam.put("{leftShapeField}","f_shape");
                        mapParam.put("{leftWhere}","1=1");
                        mapParam.put("{right}",db+"/"+detail.getRightName());
                        mapParam.put("{rightPkField}","aid");
                        mapParam.put("{rightShapeField}","f_shape");
                        mapParam.put("{rightWhere}","1=1");
                        mapParam.put("{result}",detail.getResultName());
                        mapParam.put("{resultdb}",db+"/"+detail.getResultName());
                        for(Map.Entry<String,String>kv:mapParam.entrySet())
                        {
                            curParam = curParam.replace(kv.getKey(), kv.getValue());
                        }


                        logger.info("cffx service url:" + cffxConfig.getServiceUrl() + " param:" + curParam);
                        String result = HttpUtil.createPost(cffxConfig.getServiceUrl()).body(curParam).execute().body();
                        logger.info("cffx service url:" + cffxConfig.getServiceUrl() + " http result: " + result);
                        if (StringUtils.isBlank(result)) {
                            detail.setState(CffxStateEnum.error.getCode());
                            detail.setMsg("通过分析服务创建分析任务失败");
                            detail.setEndTime(new Date());
                            logger.error("重复分析子任务:" + detail.getId() + "通过分析服务创建分析任务失败");
                        }
                        else {
                            JSONObject resultJson = JSONObject.parseObject(result);
                            if (resultJson.containsKey("code") && resultJson.getString("code").equals("200")) {
                                String taskId = resultJson.getJSONObject("data").getString("taskId");
                                if (StringUtils.isNotBlank(taskId)) {
                                    detail.setAtlasId(taskId);
                                    detail.setState(CffxStateEnum.runing.getCode());
                                } else {
                                    detail.setState(CffxStateEnum.error.getCode());
                                    detail.setMsg("通过分析服务创建分析任务失败");
                                    detail.setEndTime(new Date());
                                    logger.error("重复分析子任务:" + detail.getId() + "通过分析服务创建分析任务失败," + result);
                                }
                            } else {
                                detail.setState(CffxStateEnum.error.getCode());
                                detail.setMsg("通过分析服务创建分析任务失败");
                                detail.setEndTime(new Date());
                                logger.error("重复分析子任务:" + detail.getId() + "通过分析服务创建分析任务失败," + result);
                            }
                        }
                        cffxTaskDetailDao.gwUpdateByPK(detail);
                    } else if (detail.getState().equals(CffxStateEnum.runing.getCode())) {

                    } else if (detail.getState().equals(CffxStateEnum.error.getCode())) {

                    } else if (detail.getState().equals(CffxStateEnum.success.getCode())) {

                    }

                }
                if (taskDetails.stream().allMatch(t -> t.getState().equals(CffxStateEnum.success.getCode()))) {
                    task.setState(CffxStateEnum.success.getCode());
                    task.setProgress(100);
                    cffxTaskDao.gwUpdateByPK(task);
                } else if (taskDetails.stream().anyMatch(t -> t.getState().equals(CffxStateEnum.error.getCode()))) {
                    task.setState(CffxStateEnum.error.getCode());
                    cffxTaskDao.gwUpdateByPK(task);
                }
                else
                {
                    task.setState(CffxStateEnum.runing.getCode());
                    cffxTaskDao.gwUpdateByPK(task);
                }
            }
        }
        catch (Exception ex)
        {
            String msg="重复分析任务:" + task.getId() + "启动任务异常";
            if(ex!=null&& StringUtils.isNotBlank(ex.getMessage()))
            {
                msg+=","+ex.getMessage();
            }

            logger.error(msg+"\n"+ ExceptionUtils.getStackTrace(ex), ex);
            task.setState(CffxStateEnum.error.getCode());
            cffxTaskDao.gwUpdateByPK(task);
        }
    }

    @Override
    public void progressQuery(CffxTask task) {
        try {
            CffxConfig cffxConfig =  getConfig();

            CffxTaskDetail search = new CffxTaskDetail();
            search.setTaskId(task.getId());
            List<CffxTaskDetail>taskDetails = cffxTaskDetailDao.gwSearch(search);
            if(taskDetails==null||taskDetails.isEmpty())
            {
                task.setState(CffxStateEnum.error.getCode());
                task.setProgress(0);
                cffxTaskDao.gwUpdateByPK(task);
                return;
            }
            int sucCount=0;
            int errorCount = 0;
            for(CffxTaskDetail detail:taskDetails)
            {
                String atlasUrl = cffxConfig.getAtlasUrl();
                atlasUrl = atlasUrl + "/atlas/task/get?id=" + detail.getAtlasId();
                logger.info("cffx atlas task url:"+atlasUrl);
                String result = HttpUtil.createGet(atlasUrl).execute().body();
                if (StringUtils.isBlank(result)) {
                    logger.error("重复分析任务:" + detail.getId() + "获取分析任务进度信息失败");
                    continue;
                }
                JSONObject resultJson = JSONObject.parseObject(result);
                String state = "";
                Boolean flag = false;
                if (!resultJson.containsKey("State") || !resultJson.containsKey("IsSucceed")) {
                    logger.info("重复分析任务:" + detail.getId() + "分析任务暂未完成");
                    continue;

                }
                state = resultJson.getString("State");
                flag = resultJson.getBoolean("IsSucceed");
                if (!state.equalsIgnoreCase("finished")) {
                    logger.info("重复分析任务:" + detail.getId() + "分析任务暂未完成");
                    continue;
                }
                if (!flag) {
                    detail.setState(CffxStateEnum.error.getCode());
                    errorCount++;
                }
                else {
                    detail.setState(CffxStateEnum.success.getCode());
                    sucCount++;
                }
                cffxTaskDetailDao.gwUpdateByPK(detail);
            }

            if(taskDetails.size() == sucCount)
            {
                task.setState(CffxStateEnum.success.getCode());
                task.setProgress(100);
                cffxTaskDao.gwUpdateByPK(task);
            }
            else if(errorCount>0)
            {
                task.setState(CffxStateEnum.error.getCode());
                cffxTaskDao.gwUpdateByPK(task);
            }
            else
            {
                task.setProgress(sucCount*100/taskDetails.size());
                cffxTaskDao.gwUpdateByPK(task);
            }
        } catch (Exception ex) {
            String msg="重复分析任务:" + task.getId() + "查询进度异常";
            if(ex!=null&& StringUtils.isNotBlank(ex.getMessage()))
            {
                msg+=","+ex.getMessage();
            }

            logger.error(msg+"\n"+ ExceptionUtils.getStackTrace(ex), ex);
        }
    }

    @Override
    public void writeCfLog(CffxTask task) {
        CffxConfig config = getConfig();

        CffxDetailConfig detailConfig=getDetailConfig(config,task.getRelId());

        TaskRecord taskRecord = null;
        List<CffxTaskDetail> taskDetails = null;
        try {
            CffxTaskDetail search = new CffxTaskDetail();
            search.setTaskId(task.getId());
            taskDetails = cffxTaskDetailDao.gwSearch(search);
            taskRecord = taskRecordService.findOne(task.getRecordId());
            if (task.getState().equals(CffxStateEnum.error.getCode())) {
                task.setState(CffxStateEnum.writeLogErr.getCode());
                cffxTaskDao.gwUpdateByPK(task);
                taskRecord.setState(JobConstants.JOB_STATE_FAILED);
                taskRecord.setLog("重复分析任务执行失败");
                taskRecordRepository.gwUpdateByPK(taskRecord);

            } else if (task.getState().equals(CffxStateEnum.success.getCode())) {
                task.setState(CffxStateEnum.writeLogErr.getCode());
                cffxTaskDao.gwUpdateByPK(task);


                if (taskDetails == null || taskDetails.isEmpty()) {

                    taskRecord.setState(JobConstants.JOB_STATE_FAILED);
                    taskRecord.setLog("重复输出日志分析失败，重复分析无子任务");
                    taskRecordRepository.gwUpdateByPK(taskRecord);
                    return;
                }

                JSONObject paramsObject = JSONObject.parseObject(taskRecord.getParam());
                String taskId = paramsObject.getString("taskId");
                Long userId = paramsObject.getLongValue("userId");
                String uesrName = landUserRepository.queryUserById(userId).getName();
                //String uploadTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(taskId);
                TbtskObjectinfo tableInfo =  tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
                List<TbtskFields> uniqueFields = tbtskFieldsRepository.getTbtskUniqueFieldsByTableid(tableInfo.getfId(), 1);

                String where = "";
                List<String> filters = new ArrayList<>();
                if (detailConfig.getMinIntersectArea() != null) {
                    filters.add("shapearean >= " + detailConfig.getMinIntersectArea());
                }
                if (detailConfig.getMinIntersectRateSelf() != null) {
                    filters.add("leftsparkrate >= " + detailConfig.getMinIntersectRateSelf());
                }
                if (detailConfig.getMinIntersectRateOther() != null) {
                    filters.add("rightsparkrate >= " + detailConfig.getMinIntersectRateOther());
                }
                where = StringUtils.join(filters, " and ");
                if (StringUtils.isBlank(where)) {
                    where = " 1 = 1";
                }

                List<Map<String, Object>> cftbRecords = new ArrayList<>();
                List<String> col = new ArrayList<>();
                List<String> colAlias = new ArrayList<>();
                col.add("rightname");
                colAlias.add("重复图层");

                //col.add("leftPkField" + "_1");
                //colAlias.add("入库数据图斑ID");
                String queryLeftFields ="";
                for(TbtskFields f:uniqueFields)
                {
                    col.add(f.getfFieldname() + "_1");
                    colAlias.add("入库数据"+f.getfAlias());
                    queryLeftFields+=f.getfFieldname() + "_1,";
                }
                queryLeftFields = queryLeftFields.substring(0,queryLeftFields.length()-1);
                col.add("rightPkField" + "_2");
                colAlias.add("重复图层图斑ID");

                col.add("shapearean");
                colAlias.add("重复面积");

                col.add("leftsparkrate");
                colAlias.add("重复比例1");

                col.add("rightsparkrate");
                colAlias.add("重复比例2");

                col.add("uploadUser");
                colAlias.add("上传用户");

                col.add("msg");
                colAlias.add("重复信息");
                for (CffxTaskDetail detail : taskDetails) {
                    String filter = where;
                    String resultTable = detail.getResultName();
                    String rightTable = detail.getRightName();
                    String rightAlias = "";
                    //String leftTable = task.getLeftName();
                    //String leftPkField = "object";//shp 没有这个字段
                    String rightPkField = "";

                    Optional<CffxDataDto> opRightData = detailConfig.getOthers().stream().filter(t -> t.getName().equals(rightTable)).findFirst();
                    if (opRightData.isPresent()) {
                        rightPkField = opRightData.get().getPkField();
                        rightAlias = opRightData.get().getAlias();
                    } else {
                        Optional<CffxDataDto> opSelfData = null;
                        if(detailConfig.getSelfs()!=null)
                        {
                              opSelfData = detailConfig.getSelfs().stream().filter(t -> t.getName().equals(rightTable)).findFirst();
                        }
                        if(opSelfData.isPresent())
                        {
                            rightPkField = opSelfData.get().getPkField();
                            rightAlias =  opSelfData.get().getAlias();
                        }
                        else {
                            rightPkField = "f_id";
                            rightAlias = tskTaskBiz.getName();
                        }


                        for(TbtskFields f:uniqueFields)
                        {
                             filter += " and "+f.getfFieldname()+"_1 != "+f.getfFieldname()+"_2";
                        }
                    }

                    String countSql = String.format("select count(*) as count from %s where %s", resultTable, filter);
                    Map<String, Object> mapCount = jdbcTemplate.queryForMap(countSql);
                    int count = Integer.parseInt(mapCount.get("count").toString());
                    if (count == 0) {
                        continue;
                    }

                    String sql = String.format("select %s,%s as rightPkField_2,%s,%s,%s from %s where %s", queryLeftFields, rightPkField + "_2", "shapearean", "leftsparkrate", "rightsparkrate", resultTable, filter);

                    int page = (int) Math.ceil(count * 1.0 / 1000);
                    for (int i = 0; i < page; i++) {
                        int offset = i * 1000;
                        String pageSql = sql + " order by shapearean desc limit " + 1000 + " offset " + offset;
                        List<Map<String, Object>> maps = jdbcTemplate.queryForList(pageSql);
                        for (Map map : maps) {
                            map.put("rightname", rightAlias);
                            map.put("msg", "待入库图斑重复");
                            map.put("uploadUser", uesrName);

                        /*
                        String leftTbid = map.get(leftPkField+"_1").toString();
                        String rightTbid = map.get(rightPkField+"_2").toString();
                        String shapearean = map.get("shapearean").toString();
                        String leftsparkrate = map.get("leftsparkrate").toString();
                        String rightsparkrate = map.get("rightsparkrate").toString();
                        CftbRecord tb = new CftbRecord();
                        tb.setLeftTbid(leftTbid);
                        tb.setRightTbid(rightTbid);
                        tb.setIntersectArea(shapearean);
                        tb.setIntersectLeftRate(leftsparkrate);
                        tb.setIntersectRightRate(rightsparkrate);
                        tb.setRightDataAlias(rightAlias);
                        cftbRecords.add(tb);
                        */
                        }
                        cftbRecords.addAll(maps);
                    }

                }
                if (!cftbRecords.isEmpty()) {

                    writeExcel(cftbRecords, col, colAlias, tskTaskBiz.getName(), tskTaskBiz.getId(), userId);
                    taskRecord.setState(JobConstants.JOB_STATE_FAILED);
                    taskRecord.setLog("存在重复数据,详情请查看日志文件");
                    taskRecordService.save(taskRecord);
                } else {
                    taskRecord.setState(JobConstants.JOB_STATE_CREATE);
                    taskRecordService.save(taskRecord);
                }
                task.setState(CffxStateEnum.writeLogSuc.getCode());
                cffxTaskDao.gwUpdateByPK(task);
            }
        }
        catch (Exception ex)
        {
            String msg = "重复分析写excel日志异常"+ExceptionUtils.getStackTrace(ex);
            if(msg.length()>1000)
            {
                msg = msg.substring(0,1000);
            }
            taskRecord.setState(JobConstants.JOB_STATE_FAILED);
            taskRecord.setRemark(msg);
            taskRecordService.save(taskRecord);
            task.setState(CffxStateEnum.writeLogErr.getCode());
            cffxTaskDao.gwUpdateByPK(task);
        }
        finally {
            TableUtil.dropTable(task.getLeftName(),jdbcTemplate);
            if (taskDetails != null && !taskDetails.isEmpty())
            {
                for (CffxTaskDetail detail:taskDetails)
                {
                    TableUtil.dropTable(detail.getResultName(),jdbcTemplate);
                }
            }

        }


    }

    @Transactional
    public void insertCffxTask(CffxTask cffxTask,List<CffxTaskDetail>details)
    {
        cffxTaskDetailDao.insertBatch(details);
        cffxTaskDao.gwAccess(cffxTask);
    }

    @Override
    public List<CffxTask> list(Integer state)
    {
        CffxTask search = new CffxTask();
        search.setState(state);
        return cffxTaskDao.gwSearch(search);
    }

    @Override
    public CffxDetailConfig getDetailConfig(CffxConfig config, String taskId)
    {

        CffxDetailConfig detailConfig=null;
        List<CffxDetailConfig> cffxDetailConfigs = config.getDetailConfigs();
        for (CffxDetailConfig dconfig : cffxDetailConfigs) {
            List<CffxDataDto> cffxDataDtos = dconfig.getSelfs();
            if(cffxDataDtos==null||cffxDataDtos.isEmpty())
            {
                detailConfig = dconfig;
                break;
            }
            else if(cffxDataDtos.stream().filter(t->t.getId().equalsIgnoreCase(taskId)).findFirst().isPresent())
            {
                detailConfig = dconfig;
                break;
            }

        }
        return  detailConfig;
    }

    @Override
    public CffxDetailInfo cffx(Map<String,Object>map, CffxDetailConfig detailConfig,TskTaskBiz task,String splitTableName) {
        String shape = map.get("f_shape")==null?null:map.get("f_shape").toString();

        if(StringUtils.isBlank(shape))
        {
            return null;
        }
        String sourceTableName=null;
        String pkField=null;
        if(StringUtils.isNotBlank(splitTableName))
        {
            sourceTableName = splitTableName;
        }
        else
        {
            TbtskObjectinfo tableByTableId = tbtskObjectinfoRepository.getObjectByTableId(task.getTableId());
            sourceTableName = tableByTableId.getfTablename();

        }

        if(detailConfig.getSelfs()==null||detailConfig.getSelfs().isEmpty())
        {
            pkField="f_id";

        }
        else
        {
            CffxDataDto cffxDataDto = detailConfig.getSelfs().stream().filter(t->t.getId().equals(task.getId())).findFirst().get();
            pkField = cffxDataDto.getPkField();
        }
        String id = map.get("f_id")==null?null:map.get("f_id").toString();
        if(StringUtils.isBlank(id))
        {
           return null;
        }
        String tbName=id;
        if(!pkField.equalsIgnoreCase("f_id"))
        {
            if(map.containsKey(pkField))
            {
                tbName =map.get(pkField)==null?"":map.get(pkField).toString();
            }
            else
            {
               Map<String,Object>tbNameMap =  jdbcTemplate.queryForMap(String.format("select %s from %s where f_id = '%s'",pkField,sourceTableName,id));
                if(tbNameMap!=null)
                {
                    tbName =tbNameMap.get(pkField)==null?"":tbNameMap.get(pkField).toString();
                }

            }
        }


        try {
            if(shape.toLowerCase().startsWith("srid=4490;"))
            {
                shape = StringUtils.split(shape,";")[1];
            }
            Geometry geometry = wktReader.read(shape);
            if(!geometry.isValid())
            {
                CffxDetailInfo result = new CffxDetailInfo();
                result.setTbName(tbName);
                result.setMsg("图斑:"+tbName+"存在拓扑错误");
                return result;
            }
        }
        catch (Exception ex)
        {
            logger.error("图斑重复分析异常",ex);
            CffxDetailInfo result = new CffxDetailInfo();
            result.setTbName(tbName);
            result.setMsg("图斑:"+tbName+"存在拓扑错误");
            return result;
        }
        if(detailConfig.isSelf())
        {
            String sql=String.format("select %s from %s where st_intersects(st_geometryfromtext(?,4490),f_shape)=true and f_id not in ('%s')",pkField,sourceTableName,id);
            Object[]args = new Object[1];
            args[0] = shape;
            List<String>cftb = new ArrayList<>();
            String finalPkField = pkField;
            jdbcTemplate.query(sql, new RowCallbackHandler() {
                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    cftb.add(rs.getString(finalPkField));
                }
            },args);
            if(!cftb.isEmpty())
            {
                CffxDetailInfo result = new CffxDetailInfo();
                result.setCfTaskTbName(cftb);
                result.setTbName(tbName);
                result.setCfTaskName(task.getName());
                result.setCfTaskTbName(cftb);
                result.setMsg("图斑:"+tbName+"与["+StringUtils.join(cftb,",")+"]冲突");
                return result;
            }
        }
        if(detailConfig.isOther())
        {
            for (CffxDataDto data:detailConfig.getOthers()) {
                String sql=String.format("select %s from %s where st_intersects(st_geometryfromtext(?,4490),f_shape)=true",data.getPkField(),data.getName());
                Object[]args = new Object[1];
                args[0] = shape;
                List<String>cftb = new ArrayList<>();
                String finalPkField = pkField;
                jdbcTemplate.query(sql, new RowCallbackHandler() {
                    @Override
                    public void processRow(ResultSet rs) throws SQLException {
                        cftb.add(rs.getString(finalPkField));
                    }
                },args);
                if(!cftb.isEmpty())
                {
                    CffxDetailInfo result = new CffxDetailInfo();
                    result.setCfTaskTbName(cftb);
                    result.setTbName(tbName);
                    result.setCfTaskName(data.getAlias());
                    result.setCfTaskTbName(cftb);
                    result.setMsg("图斑:"+tbName+"与任务:"+data.getAlias()+"图斑["+StringUtils.join(cftb,",")+"]冲突");
                    return result;
                }
            }
        }
        return null;


    }
    private void writeExcel(List<Map<String,Object>>cftbRecords, List<String>col, List<String>colName, String taskName, String taskId, Long userId)
    {
        String tempDir = System.getProperty("java.io.tmpdir");
        String fileName = taskName + "-数据导入日志-" + System.currentTimeMillis() + ".xls";
        String fileName1 = taskName + "-数据导入日志-" + new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date()) + ".xls";
        String filePath = null;
        try {
            filePath = ExcelUtil.CreateExcel(cftbRecords, tempDir, fileName, StringUtils.join(col,","), StringUtils.join(colName,","), "日志导出");
        } catch (Exception e) {
            e.printStackTrace();
        }
        String sendObjName = "taskManagerUploadLog/" + fileName1;
        String downloadPath = ossOperatorService.sendObject2Oss(sendObjName, filePath);

        TbtskDataLog tbtskDataLog = new TbtskDataLog();
        tbtskDataLog.setCreateTime(new Date());
        tbtskDataLog.setLogUrl(downloadPath);
        tbtskDataLog.setName(fileName1);
        tbtskDataLog.setTaskId(taskId);
        tbtskDataLog.setUserId(userId.toString());
        tbtskDataLogService.saveDataLog(tbtskDataLog);
    }
    private boolean importData(TaskRecord record,String unzipFileDir,String tempTable)  {
        File zipFile = null;
        File unzipFile=null;
        try {
            JSONObject param = JSONObject.parseObject(record.getParam());
            /*
            HttpURLConnection httpURLConnection = null;
            JSONObject paramsObject = JSONObject.parseObject(record.getParam());
            String uploadurl = temporarySignedUrlService.getTemporarySignedUrl("", paramsObject.getString("unzipFileDir"), null);
            // 统一资源
            URL url = new URL(uploadurl);
                // 连接类的父类，抽象类
                URLConnection urlConnection = url.openConnection();
                // http的连接类
                httpURLConnection = (HttpURLConnection) urlConnection;
                //设置超时
                httpURLConnection.setConnectTimeout(1000 * 60 * 10);
                //设置请求方式，默认是GET
                httpURLConnection.setRequestMethod("GET");
                // 设置字符编码
                httpURLConnection.setRequestProperty("Charset", "UTF-8");
                // 打开到此 URL引用的资源的通信链接（如果尚未建立这样的连接）。
                httpURLConnection.connect();
                // 建立链接从请求中获取数据
            URLConnection con = url.openConnection();

            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
            File dir = new File(uploadDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            zipFile = File.createTempFile("tmp", ".gty", dir);
            FileUtils.copyInputStreamToFile(httpURLConnection.getInputStream(), zipFile);
            String zipName = zipFile.getAbsolutePath();
            String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            Zip4jUtils.unzip(zipName, unzipFileDir, "gtdcy2019");
            */

            unzipFile = new File(unzipFileDir);
            List<File> content = Arrays.stream(unzipFile.listFiles()).collect(Collectors.toList());
            Optional<File> opShp = content.stream().filter(t -> t.getPath().endsWith(".shp")).findFirst();
            URL url =  opShp.get().toURI().toURL();

            int totalcount = 0;
            int importcount = 0;

            ShapefileDataStore shpDataStore = new ShapefileDataStore(url);
            FeatureSource<SimpleFeatureType, SimpleFeature> featureSource = shpDataStore.getFeatureSource(shpDataStore.getTypeNames()[0]);
            org.geotools.data.Query query = new org.geotools.data.Query();
            totalcount += featureSource.getCount(query);
            if(totalcount==0)
            {
                return false;
            }
            Map<String,String>mapFields = getShpToTableColumns(shpDataStore);

            createShpTable(mapFields,jdbcTemplate,tempTable);
            List<String>fields = mapFields.keySet().stream().collect(Collectors.toList());

            FeatureCollection<SimpleFeatureType, SimpleFeature> collection = featureSource.getFeatures();

            FeatureIterator<SimpleFeature> itertor = collection.features();
            SimpleFeature sf = null;
            List<Map<String,Object>> tbList = new ArrayList<>();
            param.put("totalCount", totalcount);
            while (itertor.hasNext()) {
                sf = itertor.next();
                Map<String,Object> tb = getFromSimpleFeature(sf,fields);
                tbList.add(tb);
                if (tbList.size() == 100) {

                    dataBizService.insertDatasBatch(tempTable,tbList,"f_shape");
                    tbList.clear();
                    importcount += 100;
                    param.put("importCountCffx", importcount);
                    record.setParam(param.toJSONString());
                    taskRecordService.save(record);

                }

            }
            if (!tbList.isEmpty()) {
                importcount += tbList.size();
                dataBizService.insertDatasBatch(tempTable,tbList,"f_shape");
                tbList.clear();
                param.put("importCountCffx", importcount);
                record.setParam(param.toJSONString());
                taskRecordService.save(record);

            }
            return true;
        }
        catch (Exception ex)
        {
            logger.error("cffx import shp error",ExceptionUtil.stacktraceToString(ex));
            return false;
        }
        finally {

            if (zipFile != null && zipFile.exists()) {
                try {
                    zipFile.delete();
                }
                catch (Exception ex)
                {
                    logger.error("删除文件:"+zipFile.getPath()+"失败");
                }
            }

            if(unzipFile!=null&&unzipFile.exists())
            {
                try {
                    File[] files =unzipFile.listFiles();
                    if(files!=null&&files.length>0)
                    {
                        for (File f:files) {
                            f.delete();
                        }
                    }
                    unzipFile.delete();
                }
                catch (Exception ex)
                {
                    logger.error("删除文件夹:"+unzipFile.getPath()+"失败");
                }
            }


        }
    }

    private Map<String,String>getShpToTableColumns(ShapefileDataStore shpDataStore) throws IOException {
        String[] typeNames = shpDataStore.getTypeNames();
        String typeName = typeNames[0];
        SimpleFeatureType featureType = shpDataStore.getSchema(typeName);
        String shapeField = featureType.getGeometryDescriptor().getLocalName();
        String idField = featureType.getGeometryDescriptor().getName().getLocalPart();
        Map<String,String>mapFields = new HashMap<>();
        List<PropertyDescriptor> propertyDescriptors = featureType.getDescriptors().stream().collect(Collectors.toList());
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            String fieldName = descriptor.getName().getLocalPart();
            String fieldType = descriptor.getType().getBinding().getSimpleName();
            int fieldLength = 250;
            if(descriptor.getType().getDescription()!=null) {
                fieldLength =descriptor.getType().getDescription().length();
            }
            //System.out.println("字段名称：" + fieldName);
            //System.out.println("字段类型：" + fieldType);
            //System.out.println("字段长度：" + fieldLength);
            if(fieldName.equals(shapeField))
            {
                mapFields.put("f_shape","public.geometry NOT NULL");
            }
            else
            {
                mapFields.put(fieldName,"varchar("+fieldLength+") NULL");
            }
        }
        /*
        List<AttributeDescriptor>ads = featureType.getAttributeDescriptors();

        for(AttributeDescriptor ad:ads)
        {
            String name = ad.getLocalName();
            if(name.equals(shapeField))
            {
                mapFields.put("f_shape","public.geometry NOT NULL");
            }
            else
            {
                int lenght=250;

                List<Filter> filters = ad.getType().getRestrictions();
                for (Filter f:filters) {
                    if(f instanceof IsLessThenOrEqualToImpl)
                    {
                        IsLessThenOrEqualToImpl filter = (IsLessThenOrEqualToImpl) f;
                        lenght =Integer.parseInt(filter.getExpression2().toString());
                    }


                }

                mapFields.put(name,"varchar("+lenght+") NULL");
            }
        }
        */
        return mapFields;
    }

    private void createShpTable(Map<String,String>mapFields, JdbcTemplate jdbcTemplate, String tableName)
    {
        jdbcTemplate.execute("CREATE SEQUENCE "+tableName+"_seq");
        String sql="create table "+ tableName+ " (";
        sql+="aid int4 NOT NULL DEFAULT nextval('"+tableName+"_seq'::regclass),";
        for(Map.Entry<String,String>kv: mapFields.entrySet())
        {
            sql+=kv.getKey()+" "+ kv.getValue()+",";
        }
        sql+="CONSTRAINT "+tableName+"_pk PRIMARY KEY (aid)";
        sql+=" );ALTER SEQUENCE "+tableName+"_seq OWNED BY "+tableName+"."+"aid;select updategeometrysrid('"+tableName+"','f_shape',4490)";
        jdbcTemplate.execute(sql);
    }

    private Map<String,Object> getFromSimpleFeature(SimpleFeature sf,List<String>fields)
    {
        Map<String,Object> map = new HashMap<>();
        Geometry geo = (Geometry) sf.getDefaultGeometry();
        for(String f:fields)
        {
            if(f.equals("f_shape"))
            {
                continue;
            }
            map.put(f,sf.getAttribute(f));

        }
        map.put("f_shape","SRID=4490;"+ WKTUtil.geomToWkt(geo));

        return map;

    }

    private String getTemplate() {
        try {
            InputStream is = FileUtil.class.getClassLoader().getResourceAsStream("static/intersect.json");
            BufferedReader reader = new BufferedReader(
                    new InputStreamReader(is,
                            StandardCharsets.UTF_8));
            String s = "";
            String result = "";
            while ((s = reader.readLine()) != null) {
                result += s;
            }
            return result;
        } catch (Exception ex) {
            logger.error("读取常规监测预警模型失败", ex);
            return null;
        }

    }


    private String getDB() {
        DataSource dataSource = jdbcTemplate.getDataSource();
        com.alibaba.druid.pool.DruidDataSource druidDataSource = (com.alibaba.druid.pool.DruidDataSource) dataSource;
        String url = druidDataSource.getUrl();
        String username = druidDataSource.getUsername();
        String password = druidDataSource.getPassword();
        String[] urls = StringUtils.split(url, "?");
        url = urls[0];// StringUtils.replace(urls[0], "jdbc:", "");
        String pre = url.substring(0, url.indexOf("/"));
        url = url.substring(url.indexOf("/") + 2);
        String result = pre + "//" + username + "/" + password + "@" + url;
        return result;//.replace("49.4.81.80","192.168.1.233");
    }

    private class CftbRecord
    {
        private String leftDataAlias;
        private String rightDataAlias;
        private String leftTbid;
        private String rightTbid;
        private String intersectArea;
        private String intersectLeftRate;
        private String intersectRightRate;

        private String msg;

        public String getIntersectArea() {
            return intersectArea;
        }

        public String getIntersectLeftRate() {
            return intersectLeftRate;
        }

        public String getIntersectRightRate() {
            return intersectRightRate;
        }

        public String getLeftDataAlias() {
            return leftDataAlias;
        }

        public String getLeftTbid() {
            return leftTbid;
        }

        public String getRightDataAlias() {
            return rightDataAlias;
        }

        public String getRightTbid() {
            return rightTbid;
        }

        public String getMsg() {
            return msg;
        }

        public void setIntersectArea(String intersectArea) {
            this.intersectArea = intersectArea;
        }

        public void setIntersectLeftRate(String intersectLeftRate) {
            this.intersectLeftRate = intersectLeftRate;
        }

        public void setIntersectRightRate(String intersectRightRate) {
            this.intersectRightRate = intersectRightRate;
        }

        public void setLeftDataAlias(String leftDataAlias) {
            this.leftDataAlias = leftDataAlias;
        }

        public void setLeftTbid(String leftTbid) {
            this.leftTbid = leftTbid;
        }

        public void setRightDataAlias(String rightDataAlias) {
            this.rightDataAlias = rightDataAlias;
        }

        public void setRightTbid(String rightTbid) {
            this.rightTbid = rightTbid;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

    }
}
