package com.geoway.landteam.landcloud.service.cgjcyj;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.model.pub.entity.EnumeratorDomain;
import com.geoway.landteam.landcloud.core.model.pub.entity.EnumeratorValue;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.core.EnumeratorDomainService;
import com.geoway.landteam.landcloud.core.service.pub.impl.EnumeratorValueServiceImpl;
import com.geoway.landteam.landcloud.dao.cgjcyj.*;
import com.geoway.landteam.landcloud.model.cgjcyj.dto.*;
import com.geoway.landteam.landcloud.model.cgjcyj.enm.CgjcyjStateEnum;
import com.geoway.landteam.landcloud.model.cgjcyj.entity.*;
import com.geoway.landteam.landcloud.servface.cgjcyj.MCgjcyjTaskService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueFieldsService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueSourceService;
import com.geoway.landteam.landcloud.service.customtask.resultshare.impl.MAnalysisTaskServiceImpl;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.Md5Utils;
import com.geoway.landteam.landcloud.service.util.RedisSessionUtils;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueImportTaskRelDao;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueImportTaskRelFieldsDao;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueTaskRelDao;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.*;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRecordService;
import com.gw.base.data.result.GiResult;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import javax.persistence.criteria.CriteriaBuilder;
import javax.sql.DataSource;
import javax.transaction.Transactional;
import java.io.*;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Transactional
public class MCgjcyjTaskServiceImpl implements MCgjcyjTaskService {

    private final GiLoger logger = GwLoger.getLoger(MAnalysisTaskServiceImpl.class);

    @Autowired
    EnumeratorDomainService enumeratorDomainService;

    @Autowired
    EnumeratorValueServiceImpl enumeratorValueService;

    @Autowired
    MJcClueSourceService jcClueSourceService;

    @Autowired
    MJcClueFieldsService jcClueFieldsService;

    @Autowired
    SysConfigService sysConfigService;

    @Autowired
    CgjcyjTaskDao cgjcyjTaskDao;

    @Autowired
    CgjcyjResultDao cgjcyjResultDao;

    @Autowired
    CgjcyjNeighbourTbDao cgjcyjNeighbourTbDao;

    @Autowired
    CgjcyjDlVersionDao cgjcyjDlVersionDao;

    @Autowired
    CgjcyjUpdateRecordDao cgjcyjUpdateRecordDao;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    DataBizService dataBizService;

    @Autowired
    JcClueTaskRelDao jcClueTaskRelDao;

    @Autowired
    JcClueImportTaskRelDao jcClueImportTaskRelDao;

    @Autowired
    JcClueImportTaskRelFieldsDao jcClueImportTaskRelFieldsDao;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Autowired
    JcClueImportRecordService jcClueImportRecordService;

    //final String mjField = "shapearea";

    final String samepreField = "samepre";

    final String isconnectField = "isconnect";
    final String sysConfigKey = "cgjcyjconfig";

    String param;

    CgjcyjConfig cgjcyjConfig;

    List<EnumeratorDomain> yjdl;

    List<EnumeratorDomain> ejdl;

    List<EnumeratorDomain> jcrw;

    @PostConstruct
    public void init() {
        if (cgjcyjConfig == null) {
            SysConfig config = sysConfigService.findOne(sysConfigKey);
            if (config != null) {
                cgjcyjConfig = JSONObject.parseObject(config.getValue(), CgjcyjConfig.class);
            }
        }
    }

    @Override
    public CgjcyjConfig getConfig()
    {
        return  cgjcyjConfig;
    }

    @Override
    public void UpdateClue(List<Map<String, Object>> updateDatas, JcClueSource clue, String taskId) {
        logger.info("常规监测预警同步线索,同步数量:"+updateDatas.size());
        if (updateDatas != null && !updateDatas.isEmpty()) {
            List<String>clueTbids = new ArrayList<>();
            List<String> ids = updateDatas.stream().map(t -> t.get(cgjcyjConfig.getFieldUniqueId()).toString()).collect(Collectors.toList());

            List<JcClueTaskRel> clueTaskRels = jcClueTaskRelDao.getClueTaskRelsByTbids(cgjcyjConfig.getRelId(), taskId, ids);
            if (clueTaskRels != null) {
                for (Map m : updateDatas) {
                    String id = m.get(cgjcyjConfig.getFieldUniqueId()).toString();
                    Optional<JcClueTaskRel> op = clueTaskRels.stream().filter(t -> t.getfTbid().equals(id)).findFirst();
                    if (op.isPresent()) {
                        clueTbids.add(op.get().getfClueid());
                        m.remove(cgjcyjConfig.getFieldUniqueId());
                        dataBizService.updateData(clue.getfTablename(), m, cgjcyjConfig.getFieldUniqueId() + " = '" + op.get().getfClueid() + "'");
                    }
                }
            }
            if(!clueTbids.isEmpty())
            {
                String where = cgjcyjConfig.getFieldUniqueId()+" in ('"+StringUtils.join(clueTbids,"','")+"')";
                String sql="select f_sjpc,count(*) as f_count from "+clue.getfTablename()+" where "+where+" group by f_sjpc";
                List<Map<String,Object>>maps = jdbcTemplate.queryForList(sql);
                if(maps==null||maps.isEmpty())
                    return;
                for(Map map:maps)
                {
                    String sjpc = map.get("f_sjpc").toString();
                    Integer count = Integer.parseInt(map.get("f_count").toString());
                    CgjcyjUpdateRecord updateRecord = cgjcyjUpdateRecordDao.gwSearchByPK(sjpc);
                    if(updateRecord==null)
                    {
                        updateRecord = new CgjcyjUpdateRecord();
                        updateRecord.setId(sjpc);
                        updateRecord.setUpdateCount(count);
                        cgjcyjUpdateRecordDao.gwAccess(updateRecord);
                    }
                    else
                    {
                        updateRecord.setUpdateCount(count);
                        cgjcyjUpdateRecordDao.gwUpdateByPK(updateRecord);
                    }
                }
            }
        }
    }

    @Override
    public Integer getUpdateCount(String batchId) {
        CgjcyjUpdateRecord updateRecord = cgjcyjUpdateRecordDao.gwSearchByPK(batchId);
        return updateRecord == null ? 0 : updateRecord.getUpdateCount();
    }


    @Override
    public CgjcyjTask createCgjcyjTask(String sourceId, String batchId, String sourceName, String userId) throws Exception {
        try {
            if (cgjcyjConfig == null) {
                SysConfig config = sysConfigService.findOne(sysConfigKey);
                if (config == null) {
                    logger.error("常规监测预警配置不存在：" + sysConfigKey);
                    throw new Exception("常规监测预警配置不存在");
                }
                if (StringUtils.isBlank(config.getValue())) {
                    throw new Exception("常规监测预警配置错误");
                }
                cgjcyjConfig = JSONObject.parseObject(config.getValue(), CgjcyjConfig.class);
            }
            if (!sourceId.equals(cgjcyjConfig.getRelId())) {
                throw new Exception("常规监测预警配置错误");
            }

            if (getUpdateCount(batchId) == 0) {
                throw new Exception("暂无数据进行预警分析");
            }

            logger.info("线索:" + sourceId + "[" + sourceName + "]启动常规监测预警分析");

            if (StringUtils.isBlank(cgjcyjConfig.getServiceUrl())) {
                logger.error("常规监测预警配置错误:未配置分析服务地址");
                throw new Exception("常规监测预警配置错误:未配置分析服务地址");

            }
            if (StringUtils.isBlank(cgjcyjConfig.getFieldYjdl())) {
                logger.error("常规监测预警配置错误:未配置一级地类字段");
                throw new Exception("常规监测预警配置错误:未配置一级地类字段");

            }
            if (StringUtils.isBlank(cgjcyjConfig.getFieldEjdl())) {
                logger.error("常规监测预警配置错误:未配置二级地类字段");
                throw new Exception("常规监测预警配置错误:未配置二级地类字段");

            }
            if (StringUtils.isBlank(cgjcyjConfig.getFieldTbbh())) {
                logger.error("常规监测预警配置错误:未配置相同编号字段");
                throw new Exception("常规监测预警配置错误:未配置相同编号字段");

            }
            if (StringUtils.isBlank(cgjcyjConfig.getSameBhSql())) {
                logger.error("常规监测预警配置错误:未配置相同编号sql");
                throw new Exception("常规监测预警配置错误:未配置相同编号sql");

            }
            if (cgjcyjConfig.getBufferMeter() == null || cgjcyjConfig.getBufferMeter() <= 0) {
                cgjcyjConfig.setBufferMeter(50.0);
            }
            if (cgjcyjConfig.getMaxArea() == null || cgjcyjConfig.getMaxArea() <= 0) {
                cgjcyjConfig.setMaxArea(20.0);
            }
            if (cgjcyjConfig.getMaxAreaLimit() == null || cgjcyjConfig.getMaxAreaLimit() <= 0) {
                cgjcyjConfig.setMaxAreaLimit(30);
            }
            CgjcyjTask cgjcyjTask = new CgjcyjTask();
            cgjcyjTask.setId(UUID.randomUUID().toString());
            cgjcyjTask.setName("常规监测预警");
            cgjcyjTask.setStatus(CgjcyjStateEnum.create.getCode().shortValue());
            cgjcyjTask.setCreateTime(new Date());
            cgjcyjTask.setClueId(sourceId);
            cgjcyjTask.setUserId(userId);
            cgjcyjTask.setBatchId(batchId);
            cgjcyjTask.setResult("cgjcyj_" + cgjcyjTask.getId());
            cgjcyjTaskDao.gwAccess(cgjcyjTask);

            CgjcyjUpdateRecord record = new CgjcyjUpdateRecord();
            record.setId(cgjcyjConfig.getRelId());
            record.setUpdateCount(0);
            cgjcyjUpdateRecordDao.gwUpdateByPK(record);

            return cgjcyjTask;
            /*
            if (ids.containsKey("ADD")) {
                List<String> add = ids.get("ADD");
                if (add != null && !add.isEmpty()) {
                    int batchCount = 100;
                    int page = add.size() / batchCount + 1;
                    for (int i = 0; i < page; i++) {
                        int startIndex = i * batchCount;
                        int endIndex = (i + 1) * batchCount;
                        if (startIndex >= add.size()) {
                            break;
                        }
                        if (endIndex >= add.size()) {
                            endIndex = add.size();
                        }
                        List<String> subs = add.subList(startIndex, endIndex);
                        List<CgjcyjTbId> tbids = new ArrayList<>();
                        for (String id : subs) {
                            CgjcyjTbId tbid = new CgjcyjTbId();
                            tbid.setId(UUID.randomUUID().toString());
                            tbid.setTbid(id);
                            tbid.setClueId(sourceId);
                            tbid.setBatchId(batchId);
                            tbid.setTaskId(cgjcyjTask.getId());
                            tbids.add(tbid);
                        }
                        cgjcyjTbIdDao.batchInsert(tbids);
                    }
                }
            }
            if (ids.containsKey("UPDATE")) {
                List<String> update = ids.get("UPDATE");
                if (update != null && !update.isEmpty()) {
                    int batchCount = 100;
                    int page = update.size() / batchCount + 1;
                    for (int i = 0; i < page; i++) {
                        int startIndex = i * batchCount;
                        int endIndex = (i + 1) * batchCount;
                        if (startIndex >= update.size()) {
                            break;
                        }
                        if (endIndex >= update.size()) {
                            endIndex = update.size();
                        }
                        List<String> subs = update.subList(startIndex, endIndex);
                        List<CgjcyjTbId> tbids = new ArrayList<>();
                        for (String id : subs) {
                            CgjcyjTbId tbid = new CgjcyjTbId();
                            tbid.setId(UUID.randomUUID().toString());
                            tbid.setTbid(id);
                            tbid.setClueId(sourceId);
                            tbid.setBatchId(batchId);
                            tbid.setTaskId(cgjcyjTask.getId());
                            tbids.add(tbid);
                        }
                        cgjcyjTbIdDao.batchInsert(tbids);
                    }
                }
            }
            */

        } catch (Exception ex) {
            logger.error("创建常规监测预警任务失败", ex);
            throw new Exception("创建常规监测预警任务失败");
        }
    }

    @Override
    public CgjcyjTask createCgjcyjTask(String userId,String batchId) {
        try {
            if (cgjcyjConfig == null) {
                SysConfig config = sysConfigService.findOne(sysConfigKey);
                if (config == null) {
                    logger.error("常规监测预警配置不存在：" + sysConfigKey);
                    throw new Exception("常规监测预警配置不存在");
                }
                if (StringUtils.isBlank(config.getValue())) {
                    throw new Exception("常规监测预警配置错误");
                }
                cgjcyjConfig = JSONObject.parseObject(config.getValue(), CgjcyjConfig.class);
            }
            if(StringUtils.isBlank(batchId))
            {
                throw new Exception("常规监测预警任务失败,未设置参数:batchId");
            }
            if (getUpdateCount(batchId) == 0) {
                throw new Exception("暂无数据进行预警分析");
            }

            logger.info("线索:" + cgjcyjConfig.getRelId()+"批次:"+batchId + " 启动常规监测预警分析");

            if (StringUtils.isBlank(cgjcyjConfig.getServiceUrl())) {
                logger.error("常规监测预警配置错误:未配置分析服务地址");
                throw new Exception("常规监测预警配置错误:未配置分析服务地址");

            }
            if (StringUtils.isBlank(cgjcyjConfig.getFieldYjdl())) {
                logger.error("常规监测预警配置错误:未配置一级地类字段");
                throw new Exception("常规监测预警配置错误:未配置一级地类字段");

            }
            if (StringUtils.isBlank(cgjcyjConfig.getFieldEjdl())) {
                logger.error("常规监测预警配置错误:未配置二级地类字段");
                throw new Exception("常规监测预警配置错误:未配置二级地类字段");

            }
            if (StringUtils.isBlank(cgjcyjConfig.getFieldTbbh())) {
                logger.error("常规监测预警配置错误:未配置相同编号字段");
                throw new Exception("常规监测预警配置错误:未配置相同编号字段");

            }
            if (StringUtils.isBlank(cgjcyjConfig.getSameBhSql())) {
                logger.error("常规监测预警配置错误:未配置相同编号sql");
                throw new Exception("常规监测预警配置错误:未配置相同编号sql");

            }

            if (cgjcyjConfig.getBufferMeter() == null || cgjcyjConfig.getBufferMeter() <= 0) {
                cgjcyjConfig.setBufferMeter(50.0);
            }
            if (cgjcyjConfig.getMaxArea() == null || cgjcyjConfig.getMaxArea() <= 0) {
                cgjcyjConfig.setMaxArea(20.0);
            }
            if (cgjcyjConfig.getMaxAreaLimit() == null || cgjcyjConfig.getMaxAreaLimit() <= 0) {
                cgjcyjConfig.setMaxAreaLimit(30);
            }
            CgjcyjTask cgjcyjTask = new CgjcyjTask();
            cgjcyjTask.setId(UUID.randomUUID().toString());
            cgjcyjTask.setName("常规监测预警");
            cgjcyjTask.setStatus(CgjcyjStateEnum.create.getCode().shortValue());
            cgjcyjTask.setCreateTime(new Date());
            cgjcyjTask.setClueId(cgjcyjConfig.getRelId());
            cgjcyjTask.setBatchId(batchId);
            cgjcyjTask.setUserId(userId);
            cgjcyjTask.setResult("cgjcyj_" + cgjcyjTask.getId().replace("-", ""));
            cgjcyjTaskDao.gwAccess(cgjcyjTask);

            CgjcyjUpdateRecord record = new CgjcyjUpdateRecord();
            record.setId(batchId);
            record.setUpdateCount(0);
            cgjcyjUpdateRecordDao.gwUpdateByPK(record);
            return cgjcyjTask;
            /*
            if (ids.containsKey("ADD")) {
                List<String> add = ids.get("ADD");
                if (add != null && !add.isEmpty()) {
                    int batchCount = 100;
                    int page = add.size() / batchCount + 1;
                    for (int i = 0; i < page; i++) {
                        int startIndex = i * batchCount;
                        int endIndex = (i + 1) * batchCount;
                        if (startIndex >= add.size()) {
                            break;
                        }
                        if (endIndex >= add.size()) {
                            endIndex = add.size();
                        }
                        List<String> subs = add.subList(startIndex, endIndex);
                        List<CgjcyjTbId> tbids = new ArrayList<>();
                        for (String id : subs) {
                            CgjcyjTbId tbid = new CgjcyjTbId();
                            tbid.setId(UUID.randomUUID().toString());
                            tbid.setTbid(id);
                            tbid.setClueId(sourceId);
                            tbid.setBatchId(batchId);
                            tbid.setTaskId(cgjcyjTask.getId());
                            tbids.add(tbid);
                        }
                        cgjcyjTbIdDao.batchInsert(tbids);
                    }
                }
            }
            if (ids.containsKey("UPDATE")) {
                List<String> update = ids.get("UPDATE");
                if (update != null && !update.isEmpty()) {
                    int batchCount = 100;
                    int page = update.size() / batchCount + 1;
                    for (int i = 0; i < page; i++) {
                        int startIndex = i * batchCount;
                        int endIndex = (i + 1) * batchCount;
                        if (startIndex >= update.size()) {
                            break;
                        }
                        if (endIndex >= update.size()) {
                            endIndex = update.size();
                        }
                        List<String> subs = update.subList(startIndex, endIndex);
                        List<CgjcyjTbId> tbids = new ArrayList<>();
                        for (String id : subs) {
                            CgjcyjTbId tbid = new CgjcyjTbId();
                            tbid.setId(UUID.randomUUID().toString());
                            tbid.setTbid(id);
                            tbid.setClueId(sourceId);
                            tbid.setBatchId(batchId);
                            tbid.setTaskId(cgjcyjTask.getId());
                            tbids.add(tbid);
                        }
                        cgjcyjTbIdDao.batchInsert(tbids);
                    }
                }
            }
            */

        } catch (Exception ex) {
            logger.error("创建常规监测预警任务失败", ex);
            return null;
        }
    }

    @Override
    public List<CgjcyjTask> getCreateByShard(int total, int index) {
        return cgjcyjTaskDao.getCreateByShard(total, index);
    }


    @Override
    public List<CgjcyjTask> getRunningByShard(int total, int index) {
        return cgjcyjTaskDao.getRunningByShard(total, index);
    }

    @Override
    public boolean startTask(CgjcyjTask task) {

        try {
            if (cgjcyjConfig == null) {
                SysConfig config = sysConfigService.findOne(sysConfigKey);
                cgjcyjConfig = JSONObject.parseObject(config.getValue(), CgjcyjConfig.class);
                if (cgjcyjConfig.getBufferMeter() == null || cgjcyjConfig.getBufferMeter() <= 0) {
                    cgjcyjConfig.setBufferMeter(50.0);
                }
                if (cgjcyjConfig.getMaxArea() == null || cgjcyjConfig.getMaxArea() <= 0) {
                    cgjcyjConfig.setMaxArea(20.0);
                }
                if (cgjcyjConfig.getMaxAreaLimit() == null || cgjcyjConfig.getMaxAreaLimit() <= 0) {
                    cgjcyjConfig.setMaxAreaLimit(30);
                }
                if (StringUtils.isBlank(cgjcyjConfig.getFieldPrimary())) {
                    cgjcyjConfig.setFieldPrimary("f_id");
                }
            }
            JcClueSource jcClueSource = jcClueSourceService.findOne(cgjcyjConfig.getRelId());
            List<JcClueFields> jcCluefields = jcClueFieldsService.findByTableId(jcClueSource.getfId());
            /*
            Optional<JcClueFields> opFieldPk = jcCluefields.stream().filter(t -> t.getfFieldname().equals(cgjcyjConfig.getFieldPrimary())).findFirst();
            if (!opFieldPk.isPresent()) {
                cgjcyjTaskDao.startTask(task.id(), CgjcyjStateEnum.error.getCode().shortValue(), "常规监测预警任务:" + task.getId() + "无主键字段:" + cgjcyjConfig.getFieldPrimary() + ",请检查常规监测预警配置");
                logger.error("常规监测预警任务:" + task.getId() + "无主键字段:" + cgjcyjConfig.getFieldPrimary() + ",请检查常规监测预警配置");
                return false;
            }
            */
            Optional<JcClueFields> opFieldDlbm1 = jcCluefields.stream().filter(t -> t.getfFieldname().equals(cgjcyjConfig.getFieldYjdl())).findFirst();
            if (!opFieldDlbm1.isPresent()) {
                cgjcyjTaskDao.startTask(task.id(), CgjcyjStateEnum.error.getCode().shortValue(), "常规监测预警任务:" + task.getId() + "无地类编码字段:" + cgjcyjConfig.getFieldYjdl() + ",请检查常规监测预警配置");
                logger.error("常规监测预警任务:" + task.getId() + "无地类编码字段:" + cgjcyjConfig.getFieldYjdl() + ",请检查常规监测预警配置");
                return false;
            }

            Optional<JcClueFields> opFieldDlbm2 = jcCluefields.stream().filter(t -> t.getfFieldname().equals(cgjcyjConfig.getFieldEjdl())).findFirst();
            if (!opFieldDlbm2.isPresent()) {
                cgjcyjTaskDao.startTask(task.id(), CgjcyjStateEnum.error.getCode().shortValue(), "常规监测预警任务:" + task.getId() + "无地类编码字段:" + cgjcyjConfig.getFieldEjdl() + ",请检查常规监测预警配置");
                logger.error("常规监测预警任务:" + task.getId() + "无地类编码字段:" + cgjcyjConfig.getFieldEjdl() + ",请检查常规监测预警配置");
                return false;
            }

            Optional<JcClueFields> opFieldBh = jcCluefields.stream().filter(t -> t.getfFieldname().equals(cgjcyjConfig.getFieldTbbh())).findFirst();
            if (!opFieldBh.isPresent()) {
                cgjcyjTaskDao.startTask(task.id(), CgjcyjStateEnum.error.getCode().shortValue(), "常规监测预警任务:" + task.getId() + "无编号字段:" + cgjcyjConfig.getFieldTbbh() + ",请检查常规监测预警配置");
                logger.error("常规监测预警任务:" + task.getId() + "无编号字段:" + cgjcyjConfig.getFieldTbbh() + ",请检查常规监测预警配置");
                return false;
            }
            String where = "";
            if (StringUtils.isBlank(task.getBatchId())) {
                where = String.format("%s is not null or %s is not null", cgjcyjConfig.getFieldYjdl(), cgjcyjConfig.getFieldEjdl());
            } else {
                where = "f_sjpc ='" + task.getBatchId() + "' and (" + String.format("%s is not null or %s is not null", cgjcyjConfig.getFieldYjdl(), cgjcyjConfig.getFieldEjdl()) + ")";
            }
            if (StringUtils.isBlank(param)) {
                param = getTemplate();
            }
            String curParam = param;
            String db = getDB();
            String outFields = String.format("%s,%s,%s,%s,%s,%s", cgjcyjConfig.getFieldPrimary(), cgjcyjConfig.getFieldUniqueId(), cgjcyjConfig.getFieldTbbh(), cgjcyjConfig.getFieldYjdl(), cgjcyjConfig.getFieldEjdl(), cgjcyjConfig.getFieldShape());

            Map<String, String> params = new HashMap<>();
            params.put("{sourcedata}", db + "/" + jcClueSource.getfTablename());
            params.put("{outfields}", outFields);
            params.put("{sourcefilter}", where);
            //params.put("{mj}", mjField);
            params.put("{samepre}", samepreField);
            params.put("{samepresql}", cgjcyjConfig.getSameBhSql());
            params.put("{buffer}", cgjcyjConfig.getBufferMeter() + "m");
            params.put("{isconnect}", isconnectField);
            params.put("{pk}", cgjcyjConfig.getFieldPrimary());
            params.put("{result}", task.getResult());
            params.put("{resultdb}", db + "/" + task.getResult());
            for (Map.Entry<String, String> p : params.entrySet()) {
                curParam = curParam.replace(p.getKey(), p.getValue());
            }
            logger.info("cgjcyj service url:"+ cgjcyjConfig.getServiceUrl()+" param:"+curParam);
            String result = HttpUtil.createPost(cgjcyjConfig.getServiceUrl()).body(curParam).execute().body();
            logger.info("cgjcyj service url:"+ cgjcyjConfig.getServiceUrl()+" http result: "+result);
            if (StringUtils.isBlank(result)) {
                cgjcyjTaskDao.startTask(task.id(), CgjcyjStateEnum.error.getCode().shortValue(), "常规监测预警任务:" + task.getId() + "通过分析服务创建分析任务失败");
                logger.error("常规监测预警任务:" + task.getId() + "通过分析服务创建分析任务失败");
                return false;
            }
            JSONObject resultJson = JSONObject.parseObject(result);
            if (resultJson.containsKey("code") && resultJson.getString("code").equals("200")) {
                String taskId = resultJson.getJSONObject("data").getString("taskId");
                if (StringUtils.isNotBlank(taskId)) {
                    task.setAnalysisId(taskId);
                    task.setStatus(CgjcyjStateEnum.runing.getCode().shortValue());
                    cgjcyjTaskDao.gwUpdateByPK(task);
                    return true;
                } else {
                    cgjcyjTaskDao.startTask(task.id(), CgjcyjStateEnum.error.getCode().shortValue(), "常规监测预警任务:" + task.getId() + "通过分析服务创建分析任务失败");
                    logger.error("常规监测预警任务:" + task.getId() + "通过分析服务创建分析任务失败," + result);
                    return false;
                }
            } else {
                cgjcyjTaskDao.startTask(task.id(), CgjcyjStateEnum.error.getCode().shortValue(), "常规监测预警任务:" + task.getId() + "通过分析服务创建分析任务失败");
                logger.error("常规监测预警任务:" + task.getId() + "通过分析服务创建分析任务失败," + result);
                return false;
            }
        } catch (Exception ex) {
            String msg="常规监测预警任务:" + task.getId() + "创建分析任务异常";
            if(ex!=null&& StringUtils.isNotBlank(ex.getMessage()))
            {
                msg+=","+ex.getMessage();
            }
            cgjcyjTaskDao.startTask(task.id(), CgjcyjStateEnum.error.getCode().shortValue(), msg);
            logger.error(msg+"\n"+getStackTraceInfo(ex), ex);
            return false;
        }

    }

    @Override
    public boolean progressQuery(CgjcyjTask task) {
        try {
            if (cgjcyjConfig == null) {
                SysConfig config = sysConfigService.findOne(sysConfigKey);
                cgjcyjConfig = JSONObject.parseObject(config.getValue(), CgjcyjConfig.class);
            }
            JcClueSource jcClueSource = jcClueSourceService.findOne(cgjcyjConfig.getRelId());
            if (jcClueSource == null) {
                logger.error("线索:" + cgjcyjConfig.getRelId() + "不存在");
                return false;
            }
            String atlasUrl = cgjcyjConfig.getAtlasUrl();

            atlasUrl = atlasUrl + "/atlas/task/get?id=" + task.getAnalysisId();
            logger.info("cgjcyj atlas task url:"+atlasUrl);
            String result = HttpUtil.createGet(atlasUrl).execute().body();
            if (StringUtils.isBlank(result)) {
                logger.error("常规监测预警任务:" + task.getId() + "获取分析任务进度信息失败");
                return false;
            }
            JSONObject resultJson = JSONObject.parseObject(result);
            String state = "";
            Boolean flag = false;
            if (!resultJson.containsKey("State") || !resultJson.containsKey("IsSucceed")) {
                logger.error("常规监测预警任务:" + task.getId() + "分析任务暂未完成");
                return false;

            }
            state = resultJson.getString("State");
            flag = resultJson.getBoolean("IsSucceed");
            if (!state.equalsIgnoreCase("finished")) {
                return false;
            }
            if (!flag) {
                cgjcyjTaskDao.updateStatus(task.getId(), CgjcyjStateEnum.error.getCode().shortValue());
                return false;
            }
            String resultTable = task.getResult();

            if (cgjcyjConfig.getBufferMeter() == null || cgjcyjConfig.getBufferMeter() <= 0) {
                cgjcyjConfig.setBufferMeter(50.0);
            }
            if (cgjcyjConfig.getMaxArea() == null || cgjcyjConfig.getMaxArea() <= 0) {
                cgjcyjConfig.setMaxArea(20.0);
            }
            if (cgjcyjConfig.getMaxAreaLimit() == null || cgjcyjConfig.getMaxAreaLimit() <= 0) {
                cgjcyjConfig.setMaxAreaLimit(30);
            }
            if (StringUtils.isBlank(cgjcyjConfig.getFieldPrimary())) {
                cgjcyjConfig.setFieldPrimary("f_id");
            }
            List<String> excluteDlbm = null;
            if (StringUtils.isNotBlank(cgjcyjConfig.getExcludeDlbm())) {
                excluteDlbm = Arrays.stream(StringUtils.split(cgjcyjConfig.getExcludeDlbm(), ",")).collect(Collectors.toList());
            }
            int totalCount = dataBizService.getCount(resultTable, "1=1");
            if (totalCount == 0)
                return true;
            int page = (int) Math.ceil(totalCount * 1.0 / 500);
            List<String> fields = ListUtil.of(cgjcyjConfig.getFieldPrimary(), cgjcyjConfig.getFieldUniqueId(), cgjcyjConfig.getFieldTbbh(), cgjcyjConfig.getFieldYjdl(), cgjcyjConfig.getFieldEjdl(), samepreField, isconnectField);//, mjField);
            List<Temp> temps = new ArrayList<>();
            for (int i = 0; i < page; i++) {
                List<Map> pageResult = dataBizService.queryPageData(resultTable, fields, 500, i + 1, "1=1");
                for (Map map : pageResult) {
                    String pk = map.get(cgjcyjConfig.getFieldPrimary()).toString();
                    String unique = map.get(cgjcyjConfig.getFieldUniqueId()).toString();
                    Object o0 = map.get(cgjcyjConfig.getFieldYjdl());
                    Object o1 = map.get(cgjcyjConfig.getFieldEjdl());
                    Object o2 = map.get(samepreField);
                    Object o3 = map.get(isconnectField);
                    Object o4 = map.get(cgjcyjConfig.getFieldTbbh());
                    String yjdl = o0 == null ? "" : o0.toString();
                    String ejdl = o1 == null ? "" : o1.toString();
                    String samepre = o2 == null ? "" : o2.toString();
                    String isconnect = o3 == null ? "" : o3.toString();
                    String tbbh = o4 == null ? "" : o4.toString();
                    if (excluteDlbm != null && excluteDlbm.contains(yjdl) || excluteDlbm.contains(ejdl)) {
                        continue;
                    }
                    List<String> connects = new ArrayList<>();
                    if (StringUtils.isNotBlank(isconnect)) {
                        connects = Arrays.stream(StringUtils.split(isconnect, ",")).collect(Collectors.toList());
                    }
                    if (!connects.contains(pk)) {
                        connects.add(pk);
                    }
                    Temp t = new Temp();
                    t.pk = pk;
                    t.unique = unique;
                    t.yjdl = yjdl;
                    t.ejdl = ejdl;
                    t.samepre = samepre;
                    t.isconnect = connects;
                    t.tbbh = tbbh;

                    temps.add(t);
                }
            }
            logger.error("常规监测预警任务:" + task.getId() + "分析结果数量:"+temps.size());
            Map<String, CgjcyjResult> mapResults = new HashMap<>();
            Map<String, CgjcyjNeighbourTb> mapNeighboutTbs = new HashMap<>();

            //相同编号地类不一致
            Map<String, List<Temp>> sameTemp = temps.stream().collect(Collectors.groupingBy(t -> t.samepre));
            for (Map.Entry<String, List<Temp>> kv : sameTemp.entrySet()) {
                String yjdl = kv.getValue().get(0).yjdl;
                String ejdl = kv.getValue().get(0).ejdl;
                boolean sameDlbm = kv.getValue().stream().allMatch(t -> t.yjdl.equals(yjdl) && t.ejdl.equals(ejdl));
                if (!sameDlbm) {
                    CgjcyjResult search = new CgjcyjResult();
                    search.setSamepre(kv.getKey());
                    List<CgjcyjResult> sames = cgjcyjResultDao.gwSearch(search);
                    boolean sameCount = false;
                    if (sames != null && sames.size() == kv.getValue().size()) {
                        sameCount = true;
                    }
                    for (Temp t : kv.getValue()) {
                        if (sameCount) {
                            Optional<CgjcyjResult> texist = sames.stream().filter(a -> a.getId().equals(t.unique)).findFirst();
                            if (texist.isPresent() && (texist.get().getSamepreun().equals(-1) || texist.get().getSamepreun().equals(1))) {
                                mapResults.put(texist.get().getId(), texist.get());
                            }
                        } else {
                            CgjcyjResult cgjcyjResult = new CgjcyjResult();
                            cgjcyjResult.setId(t.unique);
                            cgjcyjResult.setSamepre(t.samepre);
                            cgjcyjResult.setSamepreun(1);
                            cgjcyjResult.setConnectun(0);
                            cgjcyjResult.setMaxarea(0);
                            cgjcyjResult.setBatchId(task.getBatchId());
                            mapResults.put(t.unique, cgjcyjResult);
                        }
                    }

                }
            }
            //相邻图斑地类不一致
            for (Temp t : temps) {
                if (t.isconnect.size() == 1) {
                    continue;
                }
                List<Temp> connects = new ArrayList<>();

                for (String con : t.isconnect) {
                    Optional<Temp> opt = temps.stream().filter(b -> b.pk.equals(con)).findFirst();
                    if (opt.isPresent()) {
                        connects.add(opt.get());
                    }
                }
                if (connects.isEmpty() || connects.size() == 1)
                {
                    continue;
                }

                String yjdl = connects.get(0).yjdl;
                String ejdl = connects.get(0).ejdl;
                boolean sameDlbm = connects.stream().allMatch(a -> a.yjdl.equals(yjdl) && a.ejdl.equals(ejdl));
                if (!sameDlbm) {
                    CgjcyjNeighbourTb search = new CgjcyjNeighbourTb();
                    search.setTbid(t.unique);
                    List<CgjcyjNeighbourTb> sames = cgjcyjNeighbourTbDao.gwSearch(search);
                    boolean sameCount = false;
                    if (sames != null && sames.size() == connects.size()) {
                        sameCount = true;
                    }
                    for (Temp t1 : connects) {

                        if (sameCount) {

                            CgjcyjResult exist = cgjcyjResultDao.gwSearchByPK(t1.unique);

                            if (exist != null && (exist.getConnectun().equals(-1) || exist.getConnectun().equals(1))) {
                                mapResults.put(exist.getId(), exist);
                            }
                        } else {
                            if (mapResults.containsKey(t1.unique)) {
                                mapResults.get(t1.unique).setConnectun(1);
                            } else {
                                CgjcyjResult cgjcyjResult = new CgjcyjResult();
                                cgjcyjResult.setId(t1.unique);
                                cgjcyjResult.setSamepre(t.samepre);
                                cgjcyjResult.setSamepreun(0);
                                cgjcyjResult.setConnectun(1);
                                cgjcyjResult.setMaxarea(0);
                                cgjcyjResult.setBatchId(task.getBatchId());
                                mapResults.put(t1.unique, cgjcyjResult);
                            }
                            for (Temp t2 : connects) {
                                CgjcyjNeighbourTb tb = new CgjcyjNeighbourTb();
                                tb.setTbid(t1.unique);
                                tb.setTbbh(t2.tbbh);
                                tb.setBhid(t2.unique);
                                tb.setBatchId(task.getBatchId());
                                String key = t1.unique + t2.tbbh;
                                if (!mapNeighboutTbs.containsKey(key)) {
                                    mapNeighboutTbs.put(key, tb);
                                }
                            }
                        }
                    }

                }
            }
            /*
            Map<String, List<Temp>> connectTemp = temps.stream().collect(Collectors.groupingBy(t -> t.isconnect));
            for (Map.Entry<String, List<Temp>> kv : connectTemp.entrySet()) {
                String yjdl = kv.getValue().get(0).yjdl;
                String ejdl = kv.getValue().get(0).ejdl;
                boolean sameDlbm = kv.getValue().stream().allMatch(t -> t.yjdl.equals(yjdl) && t.ejdl.equals(ejdl));
                if (!sameDlbm) {
                    for (Temp t : kv.getValue()) {
                        if (mapResults.containsKey(t.pk)) {
                            mapResults.get(t.pk).setConnectun(1);
                        } else {
                            CgjcyjResult cgjcyjResult = new CgjcyjResult();
                            cgjcyjResult.setId(t.pk);
                            cgjcyjResult.setSamepre(t.samepre);
                            cgjcyjResult.setSamepreun(0);
                            cgjcyjResult.setConnectun(1);
                            cgjcyjResult.setMaxarea(0);
                            mapResults.put(t.pk, cgjcyjResult);
                        }
                        for (Temp t1 : kv.getValue()) {
                            CgjcyjNeighbourTb tb = new CgjcyjNeighbourTb();
                            tb.setTbid(t.pk);
                            tb.setTbbh(t1.tbbh);
                            neighbourTbs.add(tb);
                        }
                    }

                }
            }
            */
            // 大面积图斑　
            //List<Map> maxAreas = dataBizService.queryAllData(resultTable, fields, " 1=1 order by " + mjField + " desc limit " + cgjcyjConfig.getMaxAreaLimit());
            List<Map> maxAreas = null;
            List<String> maxAreasFields = ListUtil.of(cgjcyjConfig.getFieldPrimary(), cgjcyjConfig.getFieldUniqueId(), cgjcyjConfig.getFieldTbbh(), cgjcyjConfig.getFieldYjdl(), cgjcyjConfig.getFieldEjdl());//, mjField);
            switch (cgjcyjConfig.getFieldAreaUnit()) {
                case 1:
                    maxAreas = dataBizService.queryAllData(jcClueSource.getfTablename(), maxAreasFields, cgjcyjConfig.getFieldArea() + "/666.67 > " + cgjcyjConfig.getMaxArea() + " order by " + cgjcyjConfig.getFieldArea() + " desc limit " + cgjcyjConfig.getMaxAreaLimit());
                    break;
                case 2:
                    maxAreas = dataBizService.queryAllData(jcClueSource.getfTablename(), maxAreasFields, cgjcyjConfig.getFieldArea() + " > " + cgjcyjConfig.getMaxArea() + " order by " + cgjcyjConfig.getFieldArea() + " desc limit " + cgjcyjConfig.getMaxAreaLimit());
                    break;
            }

            for (Map map : maxAreas) {
                String unique = map.get(cgjcyjConfig.getFieldUniqueId()).toString();
                CgjcyjResult exist = cgjcyjResultDao.gwSearchByPK(unique);
                if (exist != null && exist.getMaxarea().equals(-1)) {
                    mapResults.put(exist.getId(), exist);
                } else {
                    Object o2 = map.get(cgjcyjConfig.getFieldTbbh());
                    String tbbh = o2 == null ? "" : o2.toString();
                    if (mapResults.containsKey(unique)) {
                        mapResults.get(unique).setMaxarea(1);
                    } else {
                        CgjcyjResult cgjcyjResult = new CgjcyjResult();
                        cgjcyjResult.setId(unique);
                        cgjcyjResult.setSamepre(tbbh);
                        cgjcyjResult.setSamepreun(0);
                        cgjcyjResult.setConnectun(0);
                        cgjcyjResult.setMaxarea(1);
                        cgjcyjResult.setBatchId(task.getBatchId());
                        mapResults.put(unique, cgjcyjResult);
                    }
                }

            }
            List<CgjcyjResult> cgjcyjResults = mapResults.values().stream().collect(Collectors.toList());
            int batchCount = 100;
            page = (int) Math.ceil(cgjcyjResults.size() * 1.0 / batchCount);
            for (int i = 0; i < page; i++) {
                int startIndex = i * batchCount;
                int endIndex = (i + 1) * batchCount;
                if (startIndex >= cgjcyjResults.size()) {
                    break;
                }
                if (endIndex >= cgjcyjResults.size()) {
                    endIndex = cgjcyjResults.size();
                }
                List<CgjcyjResult> subs = cgjcyjResults.subList(startIndex, endIndex);
                List<String> ids = subs.stream().map(CgjcyjResult::getId).collect(Collectors.toList());
                List<String> exists = cgjcyjResultDao.findIds(ids);
                if (exists == null || exists.isEmpty()) {
                    cgjcyjResultDao.batchInsert(subs);
                } else {
                    List<CgjcyjResult> updates = subs.stream().filter(t -> exists.contains(t.getId())).collect(Collectors.toList());
                    List<CgjcyjResult> inserts = subs.stream().filter(t -> !exists.contains(t.getId())).collect(Collectors.toList());
                    if(updates!=null&&!updates.isEmpty()) {
                        cgjcyjResultDao.batchUpdate(updates);
                    }
                    if(inserts!=null&&!inserts.isEmpty()) {
                        cgjcyjResultDao.batchInsert(inserts);
                    }
                }
            }
            List<CgjcyjNeighbourTb> neighbourTbs = mapNeighboutTbs.values().stream().collect(Collectors.toList());
            page = (int) Math.ceil(neighbourTbs.size() * 1.0 / batchCount);
            for (int i = 0; i < page; i++) {
                int startIndex = i * batchCount;
                int endIndex = (i + 1) * batchCount;
                if (startIndex >= neighbourTbs.size()) {
                    break;
                }
                if (endIndex >= neighbourTbs.size()) {
                    endIndex = neighbourTbs.size();
                }
                List<CgjcyjNeighbourTb> subs = neighbourTbs.subList(startIndex, endIndex);
                List<String> ids = subs.stream().map(CgjcyjNeighbourTb::getTbid).collect(Collectors.toList());
                List<CgjcyjNeighbourTb> exists = cgjcyjNeighbourTbDao.ListByIds(ids,task.getBatchId());
                if (exists == null || exists.isEmpty()) {
                    cgjcyjNeighbourTbDao.batchInsert(subs);
                } else {
                    List<CgjcyjNeighbourTb> inserts = subs.stream().filter(e -> {
                        return !exists.stream().filter(t -> t.getTbid().equals(e.getTbid()) && t.getTbbh().equals(e.getTbbh())).findFirst().isPresent();
                    }).collect(Collectors.toList());
                    if(inserts!=null&&!inserts.isEmpty()) {
                        cgjcyjNeighbourTbDao.batchInsert(inserts);
                    }
                }
            }

            cgjcyjTaskDao.updateStatus(task.getId(), CgjcyjStateEnum.success.getCode().shortValue());
            dataBizService.excuteSql("drop table " + task.getResult());
            return true;
        } catch (Exception ex) {
            String msg="常规监测预警任务:" + task.getId() + "查询进度异常";
            if(ex!=null&& StringUtils.isNotBlank(ex.getMessage()))
            {
                msg+=","+ex.getMessage();
            }
            cgjcyjTaskDao.finishTask(task.id(), CgjcyjStateEnum.error.getCode().shortValue(), msg);
            logger.error(msg+"\n"+getStackTraceInfo(ex), ex);
            return false;
        }
    }

    @Override
    public CgjcyjResutList list(CgjcyjSearch param) throws Exception {
        if (cgjcyjConfig == null) {
            SysConfig config = sysConfigService.findOne(sysConfigKey);
            cgjcyjConfig = JSONObject.parseObject(config.getValue(), CgjcyjConfig.class);
        }
        JcClueSource jcClueSource = jcClueSourceService.findOne(cgjcyjConfig.getRelId());
        if (jcClueSource == null) {
            logger.error("线索:" + cgjcyjConfig.getRelId() + "不存在");
            throw new Exception("线索:" + cgjcyjConfig.getRelId() + "不存在");
        }
        List<String> queryFieldNames = new ArrayList<>();
        List<CgjcyjShowField> fields = cgjcyjConfig.getFields();
        for(CgjcyjShowField ff:fields)
        {
            String nn = ff.getName();
            if(nn.equals(cgjcyjConfig.getFieldArea())&&cgjcyjConfig.getFieldAreaUnit().equals(1))
            {
                nn = nn +"/666.67 as "+nn;
            }
            queryFieldNames.add(nn);
        }
        //List<String> queryFieldNames = fields.stream().map(CgjcyjShowField::getName).collect(Collectors.toList());
        if (!queryFieldNames.stream().filter(t -> t.equals(cgjcyjConfig.getFieldUniqueId())).findFirst().isPresent()) {
            queryFieldNames.add(cgjcyjConfig.getFieldUniqueId());
        }
        if (!queryFieldNames.stream().filter(t -> t.equals(cgjcyjConfig.getFieldTbbh())).findFirst().isPresent()) {
            queryFieldNames.add(cgjcyjConfig.getFieldTbbh());
        }
        //String queryFields = String.join(",",fields.stream().map(CgjcyjShowField::getName).collect(Collectors.toList()));
        //String sql="select "+queryFields+" from "+ jcClueSource.getfTablename();
        String where = "";
        List<String> wheres = new ArrayList<>();
        if (StringUtils.isNotBlank(param.getXzqdm())) {
            wheres.add(cgjcyjConfig.getFieldXzqdm() + " = '" + param.getXzqdm() + "'");
        }
        if (StringUtils.isNotBlank(param.getJcrw())) {
            wheres.add(cgjcyjConfig.getFieldJcrw() + " = '" + param.getJcrw() + "'");
        }
        if (StringUtils.isNotBlank(param.getYjdl())) {
            wheres.add(cgjcyjConfig.getFieldYjdl() + " = '" + param.getYjdl() + "'");
        }
        if (StringUtils.isNotBlank(param.getEjdl())) {
            wheres.add(cgjcyjConfig.getFieldEjdl() + " = '" + param.getEjdl() + "'");
        }
        if (StringUtils.isNotBlank(param.getTbbh())) {
            wheres.add(cgjcyjConfig.getFieldTbbh() + " like '%" + param.getTbbh() + "%'");
        }

        String frontFilter = String.join(" and ", wheres);

        switch (param.getWarnType()) {
            case 1:
                wheres.add(cgjcyjConfig.getFieldUniqueId() + " in (select f_id from tb_cgjcyj_result where f_samepreun = 1 and f_batch_id ='"+param.getBatchId()+"')");
                break;
            case 2:
                wheres.add(cgjcyjConfig.getFieldUniqueId() + " in (select f_id from tb_cgjcyj_result where f_connectun = 1 and f_batch_id ='"+param.getBatchId()+"')");
                break;
            case 3:
                wheres.add(cgjcyjConfig.getFieldUniqueId() + " in (select f_id from tb_cgjcyj_result where f_maxarea = 1 and f_batch_id ='"+param.getBatchId()+"')");
                break;
        }
        where = String.join(" and ", wheres);
        int totalCount = 0;
        int page = param.getPage();
        int rows = param.getRows();
        CgjcyjResutList resutList = new CgjcyjResutList();
        switch (param.getWarnType()) {
            case 1: {
                String countSql = String.format("select count(distinct(f_samepre)) as count from tb_cgjcyj_result where %s in  (select %s from %s where %s) ", cgjcyjConfig.getFieldUniqueId(), cgjcyjConfig.getFieldUniqueId(), jcClueSource.getfTablename(), where);
                List<Map> countMap = dataBizService.queryDataBySql(countSql);
                totalCount = Integer.parseInt(countMap.get(0).get("count").toString());
                List<Map> resultMap = new ArrayList<>();
                Map<String, List<Map>> samepreResults = new HashMap<>();
                if(totalCount>0) {
                    int offset = (page - 1) * rows;
                    List<Map<String, Object>> samepreMap = jdbcTemplate.queryForList(String.format("select distinct(f_samepre) as f_samepre from tb_cgjcyj_result where %s in  (select %s from %s where %s)  offset %d limit %d", cgjcyjConfig.getFieldUniqueId(), cgjcyjConfig.getFieldUniqueId(), jcClueSource.getfTablename(), where, offset, rows));
                    List<String> samepres = new ArrayList<>();

                    for (Map map : samepreMap) {
                        String samepre = map.get("f_samepre").toString();
                        samepres.add(samepre);

                        Map r = new HashMap();
                        for (String f : queryFieldNames) {

                            if (f.equals(cgjcyjConfig.getFieldTbbh())) {
                                r.put(f, samepre);
                            } else {
                                r.put(f, "");
                            }
                        }
                        resultMap.add(r);
                    }
                    List<String> ids = cgjcyjResultDao.findIdsBySamepres(samepres);
                    String filter = cgjcyjConfig.getFieldUniqueId() + " in ('" + StringUtils.join(ids, "','") + "')";
                    if (StringUtils.isNotBlank(frontFilter)) {
                        filter = filter + " and " + frontFilter;
                    }
                    List<Map> maps = dataBizService.queryAllData(jcClueSource.getfTablename(), queryFieldNames, filter);

                    for (Map map : maps) {
                        String tbbh = map.get(cgjcyjConfig.getFieldTbbh()).toString();
                        Optional<String> op = samepres.stream().filter(t -> tbbh.startsWith(t)).findFirst();
                        if (samepreResults.containsKey(op.get())) {
                            samepreResults.get(op.get()).add(map);
                        } else {
                            List<Map> temp = new ArrayList<>();
                            temp.add(map);
                            samepreResults.put(op.get(), temp);
                        }
                    }
                }
                resutList.setFields(fields);
                resutList.setResults(resultMap);
                resutList.setSamepres(samepreResults);
                resutList.setTotalCount((long) totalCount);
                resutList.setRows(rows);
                resutList.setPage(page);
            }
            break;
            case 2:
            {
                totalCount = dataBizService.getCount(jcClueSource.getfTablename(), where);
                List<Map> maps = new ArrayList<>();
                if(totalCount>0) {
                    maps = dataBizService.queryPageData(jcClueSource.getfTablename(), queryFieldNames, rows, page, where);
                }
                resutList.setFields(fields);
                resutList.setResults(maps);
                resutList.setTotalCount((long) totalCount);
                resutList.setRows(rows);
                resutList.setPage(page);
            }
            case 3: {
                totalCount = dataBizService.getCount(jcClueSource.getfTablename(), where);
                List<Map> maps = new ArrayList<>();
                if(totalCount>0) {
                    String order=" order by "+cgjcyjConfig.getFieldArea()+" desc";
                     maps = dataBizService.queryPageData(jcClueSource.getfTablename(), queryFieldNames, rows, page, where+order);
                }
                resutList.setFields(fields);
                resutList.setResults(maps);
                resutList.setTotalCount((long) totalCount);
                resutList.setRows(rows);
                resutList.setPage(page);
            }
            break;
        }

        return resutList;
    }

    @Override
    public Boolean cancleWarn(String id, Integer warnType) {
        switch (warnType) {
            case 1:
                if(StringUtils.isNoneBlank(id)&&id.contains(","))
                {
                    cgjcyjResultDao.cancleWarnSamebhs(Arrays.stream(id.split(",")).collect(Collectors.toList()));
                }
                else {
                    cgjcyjResultDao.cancleWarnSamebh(id);
                }
                return true;

            case 2:
                if(StringUtils.isNoneBlank(id)&&id.contains(","))
                {
                    cgjcyjResultDao.cancleWarnConnects(Arrays.stream(id.split(",")).collect(Collectors.toList()));
                }
                else {
                    cgjcyjResultDao.cancleWarnConnect(id);
                }
                return true;

            case 3:
                if(StringUtils.isNoneBlank(id)&&id.contains(","))
                {
                    cgjcyjResultDao.cancleWarnMaxareas(Arrays.stream(id.split(",")).collect(Collectors.toList()));
                }
                else {
                    cgjcyjResultDao.cancleWarnMaxarea(id);
                }
                return true;

        }
        return false;
    }

    @Override
    public Boolean updateDl(String id, String yjdl, String ejdl,String userId)
    {
        if (cgjcyjConfig == null) {
            SysConfig config = sysConfigService.findOne(sysConfigKey);
            cgjcyjConfig = JSONObject.parseObject(config.getValue(), CgjcyjConfig.class);
        }
        JcClueSource jcClueSource = jcClueSourceService.findOne(cgjcyjConfig.getRelId());
        if (jcClueSource == null) {
            logger.error("线索:" + cgjcyjConfig.getRelId() + "不存在");
            return false;
        }
        List<String>fields = new ArrayList<>();
        fields.add(cgjcyjConfig.getFieldYjdl());
        fields.add(cgjcyjConfig.getFieldEjdl());
        String where =cgjcyjConfig.getFieldUniqueId()+" ='"+id+"'";
        List<Map> mapExist =dataBizService.queryAllData(jcClueSource.getfTablename(),fields,where);
        if(mapExist==null||mapExist.isEmpty())
        {
            logger.error("线索:" + cgjcyjConfig.getRelId() + "不存在图斑:"+id);
            return false;
        }
        Map<String,Object>map = new HashMap<>();
        map.put(cgjcyjConfig.getFieldYjdl(),yjdl);
        map.put(cgjcyjConfig.getFieldEjdl(),ejdl);

        dataBizService.updateData(jcClueSource.getfTablename(),map,where);

        /*
        List<JcClueImportTaskRel>clueImportTaskRels =  jcClueImportTaskRelDao.findClueMapperSchemesByClue(cgjcyjConfig.getRelId(), "1");
        if(clueImportTaskRels!=null&&!clueImportTaskRels.isEmpty())
        {
            for (JcClueImportTaskRel m:clueImportTaskRels) {
                List<String> ids = new ArrayList<>();
                ids.add(id);
                List<JcClueTaskRel> clueTaskRels = jcClueTaskRelDao.getClueTaskRelsByClueids(cgjcyjConfig.getRelId(), m.getfTaskid(), ids);
                if (clueTaskRels != null&&!clueTaskRels.isEmpty()) {
                    List<JcClueImportTaskRelFields> relFields = jcClueImportTaskRelFieldsDao.selectByRelId(m.getfId());
                    Optional<JcClueImportTaskRelFields> yjdlField = relFields.stream().filter(t -> t.getfOriFieldname().equals(cgjcyjConfig.getFieldYjdl())).findFirst();
                    Optional<JcClueImportTaskRelFields> ejdlField = relFields.stream().filter(t -> t.getfOriFieldname().equals(cgjcyjConfig.getFieldEjdl())).findFirst();
                    Map<String,Object>mapUpdate = new HashMap<>();
                    if (yjdlField.isPresent())
                    {
                        mapUpdate.put(cgjcyjConfig.getFieldYjdl(),yjdl);
                    }
                    if (ejdlField.isPresent())
                    {
                        mapUpdate.put(cgjcyjConfig.getFieldEjdl(),ejdl);
                    }
                    if(mapUpdate.isEmpty())
                    {
                        continue;
                    }
                    //TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(m.getfTaskid());
                    //if(tskTaskBiz==null)
                    //{
                    //    continue;
                    //}
                    TbtskObjectinfo table = tskTaskBizService.findTableByTaskId(m.getfTaskid());
                    if(table==null)
                    {
                        continue;
                    }
                    String updateWhere ="f_id ='"+clueTaskRels.get(0).getfTbid()+"'";
                    dataBizService.updateData(table.getfTablename(),mapUpdate,updateWhere);

                }
            }


        }
        */

        Map mapDl = mapExist.get(0);
        String oldYjdl=mapDl.get(cgjcyjConfig.getFieldYjdl())==null?"":mapDl.get(cgjcyjConfig.getFieldYjdl()).toString();
        String oldEjdl=mapDl.get(cgjcyjConfig.getFieldEjdl())==null?"":mapDl.get(cgjcyjConfig.getFieldEjdl()).toString();
        CgjcyjDlVersion dl = new CgjcyjDlVersion();
        dl.setId(UUID.randomUUID().toString());
        dl.setTbid(id);
        dl.setYjdl(oldYjdl);
        dl.setEjdl(oldEjdl);
        dl.setTime(new Date());
        dl.setUserId(userId);
        cgjcyjDlVersionDao.gwAccess(dl);
        return true;
    }

    @Override
    public List<CgjcyjDlVersion>getDlVersion(String id)
    {
        CgjcyjDlVersion search = new CgjcyjDlVersion();
        search.setTbid(id);
        return cgjcyjDlVersionDao.gwSearch(search);
    }

    @Override
    public  List<CgjcyjTbidbh>getSameBhTbBySameBh(String sameBh,String batchId)
    {
        if(cgjcyjConfig==null) {
            SysConfig config = sysConfigService.findOne(sysConfigKey);
            cgjcyjConfig = JSONObject.parseObject(config.getValue(), CgjcyjConfig.class);
        }
        JcClueSource jcClueSource = jcClueSourceService.findOne(cgjcyjConfig.getRelId());
        if (jcClueSource == null) {
            logger.error("线索:" + cgjcyjConfig.getRelId() + "不存在");
            return null;
        }
        List<CgjcyjTbidbh> results = new ArrayList<>();
        if(StringUtils.isNotBlank(sameBh))
        {
            List<String> nxftbs = Arrays.stream(StringUtils.split(cgjcyjConfig.getNxftbValue(),",")).collect(Collectors.toList());
            List<String> queryFieldNames = new ArrayList<>();
            queryFieldNames.add(cgjcyjConfig.getFieldUniqueId());
            queryFieldNames.add(cgjcyjConfig.getFieldYjdl());
            queryFieldNames.add(cgjcyjConfig.getFieldEjdl());
            queryFieldNames.add(cgjcyjConfig.getFieldTbbh());
            queryFieldNames.add(cgjcyjConfig.getFieldNxftb());
            queryFieldNames.add("st_astext(" + cgjcyjConfig.getFieldShape()+") as f_wkt");
            List<Map> maps = dataBizService.queryAllData(jcClueSource.getfTablename(),queryFieldNames,cgjcyjConfig.getFieldUniqueId()+" in (select f_id from tb_cgjcyj_result where f_batch_id='"+batchId+"' and f_samepreun = 1 and f_samepre ='"+sameBh+"')");
            if(maps!=null)
            {
                for (Map m:maps) {
                    CgjcyjTbidbh cs = new CgjcyjTbidbh();
                    cs.setSourceId(cgjcyjConfig.getRelId());
                    cs.setTbid(m.get(cgjcyjConfig.getFieldUniqueId()).toString());
                    cs.setTbbh(m.get(cgjcyjConfig.getFieldTbbh()).toString());
                    cs.setWkt(m.get("f_wkt").toString());
                    Object xftb = m.get(cgjcyjConfig.getFieldNxftb());

                    if(xftb!=null&&nxftbs.contains(xftb.toString()))
                    {
                        cs.setOuter(true);
                    }
                    else
                    {
                        cs.setOuter(false);
                    }
                    Object yjdl = m.get(cgjcyjConfig.getFieldYjdl());
                    Object ejdl = m.get(cgjcyjConfig.getFieldEjdl());
                    cs.setYjdl(yjdl==null?"":yjdl.toString());
                    cs.setEjdl(ejdl==null?"":ejdl.toString());
                    results.add(cs);
                }
            }
        }
        if(results!=null&&!results.isEmpty())
        {
            List<EnumeratorDomain> yjdlDomain = getYjdl();
            List<EnumeratorDomain> ejdlDomain = getEjdl();
            for (CgjcyjTbidbh item:results) {
                if(StringUtils.isNotBlank(item.getYjdl())) {
                   Optional<EnumeratorDomain>op=  yjdlDomain.stream().filter(t -> t.getCode().equals(item.getYjdl())).findFirst();
                   if(op.isPresent())
                   {
                       item.setYjdlAlias(op.get().getName());
                   }
                   else
                   {
                       item.setYjdlAlias(item.getYjdl());
                   }
                }
                if(StringUtils.isNotBlank(item.getEjdl())) {
                    Optional<EnumeratorDomain>op=  ejdlDomain.stream().filter(t -> t.getCode().equals(item.getEjdl())).findFirst();
                    if(op.isPresent())
                    {
                        item.setEjdlAlias(op.get().getName());
                    }
                    else
                    {
                        item.setEjdlAlias(item.getEjdl());
                    }
                }
            }
        }
        return  results;
    }

    @Override
    public  List<CgjcyjTbidbh>getNeighbourTbByTbid(String tbid,String batchId)
    {
        if(cgjcyjConfig==null) {
            SysConfig config = sysConfigService.findOne(sysConfigKey);
            cgjcyjConfig = JSONObject.parseObject(config.getValue(), CgjcyjConfig.class);
        }
        JcClueSource jcClueSource = jcClueSourceService.findOne(cgjcyjConfig.getRelId());
        if (jcClueSource == null) {
            logger.error("线索:" + cgjcyjConfig.getRelId() + "不存在");
            return null;
        }
        List<CgjcyjTbidbh> results = new ArrayList<>();
        if(tbid!=null)
        {
            List<String>tbids = new ArrayList<>();
            tbids.add(tbid);
            List<CgjcyjNeighbourTb>neighbourTbs = cgjcyjNeighbourTbDao.ListByIds(tbids,batchId);
            if(neighbourTbs!=null&&!neighbourTbs.isEmpty())
            {
                List<String> bhids = neighbourTbs.stream().map(CgjcyjNeighbourTb::getBhid).collect(Collectors.toList());
                List<String>cancleTbs = cgjcyjResultDao.findCancleConnectIds(bhids);
                if(cancleTbs!=null&&!cancleTbs.isEmpty())
                {
                    cancleTbs.forEach(t->neighbourTbs.removeIf(a->a.getBhid().equalsIgnoreCase(t)));
                }
            }
            if(neighbourTbs!=null&&!neighbourTbs.isEmpty())
            {
                tbids = neighbourTbs.stream().map(CgjcyjNeighbourTb::getBhid).collect(Collectors.toList());
                String where = cgjcyjConfig.getFieldUniqueId()+" in ('"+StringUtils.join(tbids,"','")+"')";
                List<String> nxftbs = Arrays.stream(StringUtils.split(cgjcyjConfig.getNxftbValue(),",")).collect(Collectors.toList());
                List<String> queryFieldNames = new ArrayList<>();
                queryFieldNames.add(cgjcyjConfig.getFieldUniqueId());
                queryFieldNames.add(cgjcyjConfig.getFieldYjdl());
                queryFieldNames.add(cgjcyjConfig.getFieldEjdl());
                queryFieldNames.add(cgjcyjConfig.getFieldTbbh());
                queryFieldNames.add(cgjcyjConfig.getFieldNxftb());
                queryFieldNames.add("st_astext(" + cgjcyjConfig.getFieldShape()+") as f_wkt");
                List<Map> maps = dataBizService.queryAllData(jcClueSource.getfTablename(),queryFieldNames,where);
                if(maps!=null)
                {
                    for (Map m:maps) {
                        CgjcyjTbidbh cs = new CgjcyjTbidbh();
                        cs.setSourceId(cgjcyjConfig.getRelId());
                        cs.setTbid(m.get(cgjcyjConfig.getFieldUniqueId()).toString());
                        cs.setTbbh(m.get(cgjcyjConfig.getFieldTbbh()).toString());
                        cs.setWkt(m.get("f_wkt").toString());
                        Object xftb = m.get(cgjcyjConfig.getFieldNxftb());

                        if(xftb!=null&&nxftbs.contains(xftb.toString()))
                        {
                            cs.setOuter(true);
                        }
                        else
                        {
                            cs.setOuter(false);
                        }
                        Object yjdl = m.get(cgjcyjConfig.getFieldYjdl());
                        Object ejdl = m.get(cgjcyjConfig.getFieldEjdl());
                        cs.setYjdl(yjdl==null?"":yjdl.toString());
                        cs.setEjdl(ejdl==null?"":ejdl.toString());
                        results.add(cs);
                    }
                }
            }
        }
        if(results!=null&&!results.isEmpty())
        {
            List<EnumeratorDomain> yjdlDomain = getYjdl();
            List<EnumeratorDomain> ejdlDomain = getEjdl();
            for (CgjcyjTbidbh item:results) {
                if(StringUtils.isNotBlank(item.getYjdl())) {
                    Optional<EnumeratorDomain>op=  yjdlDomain.stream().filter(t -> t.getCode().equals(item.getYjdl())).findFirst();
                    if(op.isPresent())
                    {
                        item.setYjdlAlias(op.get().getName());
                    }
                    else
                    {
                        item.setYjdlAlias(item.getYjdl());
                    }
                }
                if(StringUtils.isNotBlank(item.getEjdl())) {
                    Optional<EnumeratorDomain>op=  ejdlDomain.stream().filter(t -> t.getCode().equals(item.getEjdl())).findFirst();
                    if(op.isPresent())
                    {
                        item.setEjdlAlias(op.get().getName());
                    }
                    else
                    {
                        item.setEjdlAlias(item.getEjdl());
                    }
                }
            }
        }
        return  results;
    }

    @Override
    public List<CgjcyjTbidbh>getMaxAreaTbByTbid(String tbid,String batchId)
    {
        if(cgjcyjConfig==null) {
            SysConfig config = sysConfigService.findOne(sysConfigKey);
            cgjcyjConfig = JSONObject.parseObject(config.getValue(), CgjcyjConfig.class);
        }
        JcClueSource jcClueSource = jcClueSourceService.findOne(cgjcyjConfig.getRelId());
        if (jcClueSource == null) {
            logger.error("线索:" + cgjcyjConfig.getRelId() + "不存在");
            return null;
        }
        List<CgjcyjTbidbh> results = new ArrayList<>();
        if(StringUtils.isNotBlank(tbid))
        {

            List<String> nxftbs = Arrays.stream(StringUtils.split(cgjcyjConfig.getNxftbValue(),",")).collect(Collectors.toList());
            List<String> queryFieldNames = new ArrayList<>();
            queryFieldNames.add(cgjcyjConfig.getFieldUniqueId());
            queryFieldNames.add(cgjcyjConfig.getFieldYjdl());
            queryFieldNames.add(cgjcyjConfig.getFieldEjdl());
            queryFieldNames.add(cgjcyjConfig.getFieldTbbh());
            queryFieldNames.add(cgjcyjConfig.getFieldNxftb());
            queryFieldNames.add("st_astext(" + cgjcyjConfig.getFieldShape()+") as f_wkt");
            List<Map> maps = dataBizService.queryAllData(jcClueSource.getfTablename(),queryFieldNames,cgjcyjConfig.getFieldUniqueId()+" ='"+tbid+"'");
            if(maps!=null)
            {
                for (Map m:maps) {
                    CgjcyjTbidbh cs = new CgjcyjTbidbh();
                    cs.setSourceId(cgjcyjConfig.getRelId());
                    cs.setTbid(m.get(cgjcyjConfig.getFieldUniqueId()).toString());
                    cs.setTbbh(m.get(cgjcyjConfig.getFieldTbbh()).toString());
                    cs.setWkt(m.get("f_wkt").toString());
                    Object xftb = m.get(cgjcyjConfig.getFieldNxftb());
                    if(xftb!=null&&nxftbs.contains(xftb.toString()))
                    {
                        cs.setOuter(true);
                    }
                    else
                    {
                        cs.setOuter(false);
                    }

                    Object yjdl = m.get(cgjcyjConfig.getFieldYjdl());
                    Object ejdl = m.get(cgjcyjConfig.getFieldEjdl());
                    cs.setYjdl(yjdl==null?"":yjdl.toString());
                    cs.setEjdl(ejdl==null?"":ejdl.toString());
                    results.add(cs);
                }
            }
        }
        if(results!=null&&!results.isEmpty())
        {
            List<EnumeratorDomain> yjdlDomain = getYjdl();
            List<EnumeratorDomain> ejdlDomain = getEjdl();
            for (CgjcyjTbidbh item:results) {
                if(StringUtils.isNotBlank(item.getYjdl())) {
                    Optional<EnumeratorDomain>op=  yjdlDomain.stream().filter(t -> t.getCode().equals(item.getYjdl())).findFirst();
                    if(op.isPresent())
                    {
                        item.setYjdlAlias(op.get().getName());
                    }
                    else
                    {
                        item.setYjdlAlias(item.getYjdl());
                    }
                }
                if(StringUtils.isNotBlank(item.getEjdl())) {
                    Optional<EnumeratorDomain>op=  ejdlDomain.stream().filter(t -> t.getCode().equals(item.getEjdl())).findFirst();
                    if(op.isPresent())
                    {
                        item.setEjdlAlias(op.get().getName());
                    }
                    else
                    {
                        item.setEjdlAlias(item.getEjdl());
                    }
                }
            }
        }
        return  results;
    }

    @Override
    public Integer getWarnCount(String batchId)
    {
        return cgjcyjResultDao.getWarnCount(batchId);
    }

    @Override
    public CgjcyjBatchList getBatchList(int page,int pageSize,int state,String name)
    {
        CgjcyjBatchList result = new CgjcyjBatchList();
        result.setPage(page);
        result.setRows(pageSize);
        int start = (page - 1) * pageSize;
        List<JcClueImportRecord> list =  jcClueImportRecordService.findClueSources(cgjcyjConfig.getRelId(),name,state,start,pageSize);
        int count =  jcClueImportRecordService.countClueSources(cgjcyjConfig.getRelId(),name,state);
        result.setTotalCount(Long.valueOf(count));
        if(list!=null&&!list.isEmpty())
        {
            List<CgjcyjClueImportRecord>batchs = new ArrayList();
            for (JcClueImportRecord record:list)
            {
                CgjcyjClueImportRecord batch = new CgjcyjClueImportRecord();

                BeanUtil.copyProperties(record,batch);
                batch.setWarnCount(getWarnCount(batch.getfId()));
                batchs.add(batch);

            }
            result.setBatchs(batchs);
        }
        return result;
    }


    @Override
    public List<EnumeratorDomain> getYjdl()
    {
        if(yjdl==null) {
            String key = "yjdl_cgjc";

            EnumeratorValue ev = enumeratorValueService.findOneByKey(key);
            if (ev != null) {
                yjdl = enumeratorDomainService.findByDicno(ev.getDicno());
            }

        }
        return yjdl;
    }

    @Override
    public List<EnumeratorDomain> getEjdl()
    {
        if(ejdl==null) {
            String key = "ejdl_cgjc";

            EnumeratorValue ev = enumeratorValueService.findOneByKey(key);
            if (ev != null) {
                ejdl = enumeratorDomainService.findByDicno(ev.getDicno());
            }

        }
        return ejdl;
    }
    @Override
    public List<EnumeratorDomain> getJcrw()
    {
        if(jcrw==null) {
            String key = "JCLX_CGJC";

            EnumeratorValue ev = enumeratorValueService.findOneByKey(key);
            if (ev != null) {
                jcrw = enumeratorDomainService.findByDicno(ev.getDicno());
            }

        }
        return jcrw;
    }
    public String readFile(String filePath) throws Exception {
        try {
            String content = "";
            String encoding = "UTF8";
            File file = new File(filePath);
            if (file.isFile() && file.exists()) {
                InputStreamReader read = new InputStreamReader(new FileInputStream(file), encoding);
                BufferedReader bufferedReader = new BufferedReader(read);

                for (String lineTxt = null; (lineTxt = bufferedReader.readLine()) != null; content = content + lineTxt) {
                }

                read.close();
            }

            return content;
        } catch (Exception var8) {
            throw new Exception("常规监测预警模型模板文件读取失败");
        }
    }

    private String getTemplate() {
        try {
            InputStream is = FileUtil.class.getClassLoader().getResourceAsStream("static/cgjcyj.json");
            BufferedReader reader = new BufferedReader(
                    new InputStreamReader(is,
                            StandardCharsets.UTF_8));
            String s = "";
            String result = "";
            while ((s = reader.readLine()) != null) {
                result += s;
            }
            return result;
        } catch (Exception ex) {
            logger.error("读取常规监测预警模型失败", ex);
            return null;
        }

    }

    private String getDB() {
        DataSource dataSource = jdbcTemplate.getDataSource();
        com.alibaba.druid.pool.DruidDataSource druidDataSource = (com.alibaba.druid.pool.DruidDataSource) dataSource;
        String url = druidDataSource.getUrl();
        String username = druidDataSource.getUsername();
        String password = druidDataSource.getPassword();
        String[] urls = StringUtils.split(url, "?");
        url = urls[0];// StringUtils.replace(urls[0], "jdbc:", "");
        String pre = url.substring(0, url.indexOf("/"));
        url = url.substring(url.indexOf("/") + 2);
        String result = pre + "//" + username + "/" + password + "@" + url;
        return result;//.replace("49.4.81.80","192.168.1.233");
    }

    private class Temp {
        public String pk;

        public String unique;
        public String samepre;
        public String yjdl;
        public String ejdl;
        public List<String> isconnect;

        public String tbbh;
    }

    private  String getStackTraceInfo(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            e.printStackTrace(pw);
            pw.flush();
            sw.flush();
            return sw.toString();
        } finally {
            try {
                pw.close();
            } catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                sw.close();
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}
