package com.geoway.landteam.landcloud.service.cgk;

import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.cgk.dto.CgkGeoSearchDto;
import com.gw.base.Gw;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class CgkSearchService {
    final String certCode = "1D5BC394E7454BB4B56D808911463460";
    final String publicKey = "04D964FD6AE472FC3367C09935DEBFC9A613F6F084ED8CA5B4C2EBF0E9F9FA5146E1631B842FED8FD55B488674C37B5FE695A49EE5A52BBEEA0868C2E816E5C47C";
    final String privateKey = "93EF84E31C27016FBAF3DED662E2C5F47B7941EFA6533E1A113C9F2E8816FB19";
    @Autowired
    AppMediaRepository appMediaDao;

    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;

    private final GiLoger logger = GwLoger.getLoger(CgkSearchService.class);

    // 保存举证成果共享数据
    public List<AppMedia> saveSharedData(String taskId, String tbbhId, JSONArray jsonArray) throws Exception {


        List<AppMedia> returnMediaList = null;

        if(StringUtils.isEmpty(taskId) || ObjectUtils.isEmpty(jsonArray) || StringUtils.isBlank(tbbhId)){
            throw new IllegalArgumentException("参数不能为空");
        }
        List<AppMedia>appMediaList = appMediaDao.queryALLByGid(tbbhId);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String sm3 = jsonObject.getString("sm3");
            if(ObjectUtils.isEmpty(returnMediaList)){
                returnMediaList = new ArrayList<AppMedia>();
            }
            if(appMediaList!=null&&appMediaList.stream().filter(t->sm3.equals(t.getSm3())).findFirst().isPresent())
            {
                //已经挂接过了
                continue;
            }
            AppMedia media = new AppMedia();
            media.setId(UUID.randomUUID().toString());
            media.setFromSource("FROM_HB_CGK");
            media.setType(jsonObject.getInteger("fileType"));
//            关联图斑id
            media.setGalleryid(tbbhId);
//            时间
            media.setCreateTime(String.valueOf(System.currentTimeMillis()));
//           文件相对路径 附件需要抓取下载并保存到邢台的对象存储
            String serverPath = jsonObject.getString("serverPath");
            logger.error("省级复用日志=========>成果库私有仓库地址:"+serverPath);
            String downloadPath = signUrl(serverPath); //jsonObject.getString("url");
            logger.error("省级复用日志=========>可下载地址:"+downloadPath);
            String tempUrl = "";
            if (downloadPath.contains("?")) {
                tempUrl = StringUtils.split(downloadPath, "?")[0];
            } else {
                tempUrl = downloadPath;
            }
            String fileName = tempUrl.substring(tempUrl.lastIndexOf("/") + 1, tempUrl.length());
            fileName = java.net.URLDecoder.decode(fileName, "utf-8");
            if (fileName.contains("?")) {
                fileName = StringUtils.split(fileName, "?")[0];
            }

            //创建上传文件
            String uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
            String dir = uploadDir + File.separator+"gjcgk";
            String ruid = UUID.randomUUID().toString();
            String objectname  = "media/" + taskId  + "/" + tbbhId + "/" + ruid+"/"+fileName;
            String uploadUrl = uploadFile(downloadPath,dir,fileName,objectname);
            media.setServerpath(uploadUrl);

//          文件大小
            media.setMediasize(jsonObject.getDouble("fileSize"));

            // 是否固定(1表示固定，0 表示不固定)
            media.setMark(0);
            //标识媒体的类型(0无类型，101整治前，102整治后)
            media.setTypetype(0);
            media.setUsername(jsonObject.getString("userName"));
            media.setLon(jsonObject.getDouble("longitude"));
            media.setLat(jsonObject.getDouble("latitude"));
            media.setDeviceSource(jsonObject.getInteger("device"));
            media.setBizId(taskId);
            String pssj = jsonObject.getString("photoTime");
            if(StringUtils.isNotBlank(pssj)){
                //            pssj 拍摄时间
                try {
                    Date date=  df.parse(pssj);
                    media.setTime(String.valueOf(date.getTime()));
                }
                catch (Exception ex)
                {
                    media.setTime(pssj);
                }
            }
            media.setPsfyj(jsonObject.getString("pitch"));
            media.setPitch(jsonObject.getString("pitch"));
            media.setRoll(jsonObject.getInteger("roll"));

            media.setDimHeight(jsonObject.getInteger("dimHeight"));
            media.setDimWidth(jsonObject.getInteger("dimWidth"));
            media.setAzimuth(jsonObject.getString("azimuth"));
//            media.setJym(jsonObject.getString("verifycode"));
//            media.setSm3(sm3);
            media.setF35mmfocal(jsonObject.getInteger("focal35mm"));
            media.setZsdm(jsonObject.getString("zsdm"));
            media.setPsgd(jsonObject.getDouble("psgd"));
            media.setJdgd(jsonObject.getDouble("jdgd"));

            AppMedia returnMedia = appMediaDao.save(media);
            returnMediaList.add(returnMedia);

        }
        return  returnMediaList;
    }

    public String uploadFile(String fileUrl,String dir,String fileName,String objectname) throws Exception {

        String downloadUrl = dir + File.separator+fileName;
        File downdirectory = new File(dir);
        if(!downdirectory.exists()){
            downdirectory.mkdirs();
        }
        File out = new File(downloadUrl);
        URL url = new URL(fileUrl);
        logger.error("省级复用日志=========>可下载地址2:"+fileUrl);
        logger.error("省级复用日志=========>保存地址:"+downloadUrl);
        try {
            FileUtils.copyURLToFile(url, out);
            logger.error("省级复用日志=========>对象存储位置:"+objectname);
            return defaultOssOperatorService.sendObject2Oss(objectname, out);
        } catch (Exception ex){
            throw new Exception(objectname+"对象存储失败" + ex.getMessage());
        } finally {
            if(out.exists()){
                out.delete();
            }
        }
    }

    public String signUrl(String url) throws Exception {
        long a = System.currentTimeMillis();
        String c = certCode + a;
        byte[] d = c.getBytes(StandardCharsets.UTF_8);
        try {
            SM2 sm2 = SmUtil.sm2(privateKey, null);
            byte[] e = sm2.sign(d);
            String f = Base64.getEncoder().encodeToString(e);
            String token = certCode + "." + a + "." + f;

            Map<String, String> headerMap = new HashMap<>();
            headerMap.put("x-cgk-token", token);
            JSONObject j = new JSONObject();
            j.put("url", url);
            String strBody = j.toJSONString();

            HttpResponse response = HttpUtil.createPost("http://121.29.50.223:8085/artifact/api/storage/v1/third/signUrl")
                    .addHeaders(headerMap).contentType("application/json").body(strBody).execute();
            String body = response.body();
            JSONObject jsonObject = JSONObject.parseObject(body);
            if(jsonObject.getInteger("code") == 200 && jsonObject.getBoolean("status")){
                return jsonObject.getString("data");
            } else {
                throw new Exception(jsonObject.getString("msg"));
            }
        }catch (Exception ex){
            Gw.log.error(ex);
            throw ex;
        }
    }

    public JSONObject geoSearch(CgkGeoSearchDto cgkGeoSearchDto) throws Exception {

        long a = System.currentTimeMillis();
        String c = certCode + a;
        byte[] d = c.getBytes(StandardCharsets.UTF_8);
        try {
            SM2 sm2 = SmUtil.sm2(privateKey, null);
            byte[] e = sm2.sign(d);
            String f = Base64.getEncoder().encodeToString(e);
            String token = certCode + "." + a + "." + f;

            Map<String, String> headerMap = new HashMap<>();
            headerMap.put("x-cgk-token", token);
            String strBody = JSONObject.toJSONString(cgkGeoSearchDto);

            HttpResponse response = HttpUtil.createPost("http://121.29.50.223:8085/artifact/api/media/filter/geo")
                    .addHeaders(headerMap).contentType("application/json").body(strBody).execute();
            String body = response.body();
            JSONObject jsonObject = JSONObject.parseObject(body);
            if(jsonObject.getInteger("code") == 200 && jsonObject.getBoolean("status")){
                return jsonObject.getJSONObject("data");
            } else {
                throw new Exception(jsonObject.getString("msg"));
            }
        }catch (Exception ex){
            Gw.log.error(ex);
            throw ex;
        }
    }
}
