package com.geoway.landteam.landcloud.service.cloudquery;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.cloudquery.dao.pub.CloudQueryThemeDao;
import com.geoway.landteam.cloudquery.model.pub.entity.*;
import com.geoway.landteam.cloudquery.repository.pub.CloudQueryItemRepository;
import com.geoway.landteam.cloudquery.repository.pub.CloudQueryNodeRepository;
import com.geoway.landteam.cloudquery.repository.pub.CloudQueryRepository;
import com.geoway.landteam.cloudquery.servface.pub.CloudAnalysisReportService;
import com.geoway.landteam.cloudquery.servface.pub.CloudQueryService;
import com.geoway.landteam.customtask.util.ObjectReference;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.entity.EnumeratorDomain;
import com.geoway.landteam.landcloud.core.model.pub.entity.EnumeratorValue;
import com.geoway.landteam.landcloud.core.servface.core.EnumeratorDomainService;
import com.geoway.landteam.landcloud.core.servface.core.EnumeratorValueService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.datacq.analyze.*;
import com.geoway.landteam.landcloud.model.datacq.dto.CloudResult;
import com.geoway.landteam.landcloud.service.datacq.CloudAnalyzeCQBysxzService;
import com.geoway.landteam.landcloud.service.datacq.CloudAnalyzeCQService;
import com.geoway.landteam.landcloud.service.datacq.CloudAnalyzeCQXcjshxService2;
import com.geoway.landteam.landcloud.service.datacq.CloudAnalyzeService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.*;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.landcloud.service.cloudquery
 * @date 2023/2/14 9:52
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class CloudQueryCQService {
    private GiLoger logger = GwLoger.getLoger(CloudQueryCQService.class);
    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    private CloudQueryNodeRepository cloudQueryNodeRepository;
    @Autowired
    private CloudQueryService cloudQueryService;
    @Autowired
    private CloudQueryItemRepository cloudQueryItemRepository;

    @Resource
    CloudQueryRepository cloudQueryRepository;

    @Autowired
    CloudAnalyzeService cloudAnalyzeService;

    @Resource
    CloudQueryThemeDao cloudQueryThemeDao;

    @Autowired
    CloudAnalysisReportService cloudAnalysisReportService;


    @Value("${project.downloadDir}")
    String downloadDir;
    @Autowired
    EnumeratorValueService enumeratorValueService;
    @Autowired
    EnumeratorDomainService enumeratorDomainService;
    public List<CloudResult> getCloudResultUrl(String requestId, String userId, String type,boolean theme) throws Exception {

        List<CloudQuery>cloudQueryList = cloudQueryRepository.getByRequestId(requestId);
        if(cloudQueryList==null||cloudQueryList.isEmpty())
        {
            return null;
        }
        List<CloudResult> result = new ArrayList<>();
        List<String>nodeIds = cloudQueryList.stream().map(CloudQuery::getNodeId).collect(Collectors.toList());
        List<CloudQueryNode> nodes = cloudQueryNodeRepository.findAll().stream().collect(Collectors.toList());
        nodes.removeIf(t->!nodeIds.contains(t.getId()));
        Map<String,List<CloudQuery>>maps = cloudQueryList.stream().collect(Collectors.groupingBy(CloudQuery::getNodeId));
        for(Map.Entry<String,List<CloudQuery>> kv:maps.entrySet())
        {
            String nodeId = kv.getKey();
            Optional<CloudQueryNode>opNode = nodes.stream().filter(t->t.getId().equals(nodeId)).findFirst();
            if(!opNode.isPresent())
            {
                continue;
            }
            CloudQueryNode node = opNode.get();
            String cloudUrl = node.getIp();
            String resultJSON = this.getResultJSON(requestId, cloudUrl);
            String metaJSON="";
            CloudQuery cq=  kv.getValue().get(0);
            if((cq.getType()!=null&&cq.getType().equals(3))||theme)
            {
                metaJSON = this.getMetaByTheme(userId, cq.getTag(), node.getId());
            }
            else {
                 metaJSON = this.getMeta(userId, type, node.getId());
            }
            String url = this.getDetailUrl(metaJSON, resultJSON, requestId, cloudUrl);
            CloudResult obj = new CloudResult(node.getId(), node.getName(), url);
            result.add(obj);
        }

        /*
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            CloudQueryNode node = (CloudQueryNode) it.next();
            String cloudUrl = node.getIp();
            String resultJSON = this.getResultJSON(requestId, cloudUrl);
            String metaJSON = this.getMeta(userId, type, node.getId());
            String url = this.getDetailUrl(metaJSON, resultJSON, requestId, cloudUrl);
            CloudResult obj = new CloudResult(node.getId(), node.getName(), url);
            result.add(obj);
        }
        */
        return result;
    }

    private String getMeta(String userId, String type, String nodeId) {

        List<CloudQueryItem> cloudQueryItems = new ArrayList<>();
        List<CloudQueryItem> temps = cloudQueryItemRepository.getItemByUserAndNode(userId, nodeId);

        if ("1".equalsIgnoreCase(type)) {
            // 1为双tab页
            for (int i = 0; i < temps.size(); i++) {
                CloudQueryItem t = new CloudQueryItem();
                BeanUtils.copyProperties(temps.get(i),t);
                if(StringUtils.isNotBlank(t.getTag())&&!t.getTag().contains("时序"))
                {
                    if(t.getTag().contains("重庆"))
                    {
                        t.setTag("重庆高级");
                    }
                    else
                    {
                        t.setTag("高级查询");
                    }
                }
                cloudQueryItems.add(t);
            }

        } else {
            // 0或空为单tab页
            for (int i = 0; i < temps.size(); i++) {
                CloudQueryItem t = new CloudQueryItem();
                BeanUtils.copyProperties(temps.get(i),t);
                t.setTag("云查询");
                cloudQueryItems.add(t);
            }

        }


        //cloudQueryItems = cloudQueryItems.stream().sorted((a, b) -> a.getTag().equals("基础查询") ? -1 : 1).collect(Collectors.toList());

        String metaJSON = JSONObject.toJSONString(cloudQueryItems);
        JSONArray metaJSONArray = JSONArray.parseArray(metaJSON);
        for (int i = 0; i < metaJSONArray.size(); i++) {
            JSONObject item = metaJSONArray.getJSONObject(i);
            item.put("tablecontent", item.getString("tableContent"));
        }
        metaJSON = metaJSONArray.toString();
        return metaJSON;
    }
    private String getMetaByTheme(String userId, String theme, String nodeId) {

        CloudQueryTheme search = new CloudQueryTheme();
        search.setName(theme);
        search.setNodeId(nodeId);
        List<CloudQueryTheme>themes = cloudQueryThemeDao.gwSearch(search);
        List<CloudAnalysisReport>reports = cloudAnalysisReportService.listByName(theme);
        if((themes==null||themes.isEmpty())&&(reports==null||reports.isEmpty()))
        {
            return null;
        }
        List<CloudQueryItem> items = new ArrayList<>();
        if(themes!=null&&!themes.isEmpty()) {
            List<String>itemIds =  themes.stream().map(CloudQueryTheme::getItemId).collect(Collectors.toList());
            items = cloudQueryItemRepository.findByIds(itemIds);
        }
        else if(reports!=null&&!reports.isEmpty())
        {
            CloudAnalysisReport report = reports.get(0);
            items = cloudQueryItemRepository.findByTagAndNode(0,report.getTag(),report.getCloudQueryNode());
        }
        List<CloudQueryItem> newItems = new ArrayList<>();
        if(items!=null) {
            for (int i = 0; i < items.size(); i++) {
                CloudQueryItem newItem = new CloudQueryItem();
                BeanUtils.copyProperties( items.get(i),newItem);
                newItem.setTag(theme);
                newItems.add(newItem);
            }
        }
        String metaJSON = null;
        if(newItems!=null) {
            metaJSON = JSONObject.toJSONString(newItems);
            JSONArray metaJSONArray = JSONArray.parseArray(metaJSON);
            for (int i = 0; i < metaJSONArray.size(); i++) {
                JSONObject item = metaJSONArray.getJSONObject(i);
                item.put("tablecontent", item.getString("tableContent"));
            }
            metaJSON = metaJSONArray.toString();
        }

        return metaJSON;
    }
    public String getDetailUrl(String metaJSON, String resultJSON, String requestId, String cloudUrl) throws Exception {
        String token = cloudQueryService.getToken();

        HttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost();
        httpPost.setHeader("appkey", (String) ProjectConfig.getConfig(ProjectConfigEnum.CLOUD_SERVICE_APP_KEY.getKey()));
        httpPost.setHeader("token", token);
        httpPost.setURI(URI.create(cloudUrl + "/cloudQuery/result/addResult"));

        List<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add(new BasicNameValuePair("id", requestId));
        formparams.add(new BasicNameValuePair("metaJson", metaJSON));
        formparams.add(new BasicNameValuePair("detailResultJson", resultJSON));

        UrlEncodedFormEntity paramEntity = new UrlEncodedFormEntity(formparams, "UTF-8");
        httpPost.setEntity(paramEntity);
        HttpResponse response = httpClient.execute(httpPost);
        String httpEntityContent = getHttpEntityContent(response);
        JSONObject jsonObject = JSONObject.parseObject(httpEntityContent);
        if ("OK".equalsIgnoreCase(jsonObject.getString("status"))) {
            return cloudUrl + jsonObject.getString("data");
        } else {
            return "";
        }
    }

    public String getResultJSON(String requestId, String cloudUrl) {
        return getResultJSON(requestId, cloudUrl, 0);
    }
    public String getResultJSON(String requestId, String cloudUrl, int times) {
        try {
            List<CloudQuery> list = this.getQueryList(requestId, times);
            if (list.size() < 1) {
                return "";
            }

            JSONObject jsonObject = null;
            for (int i = 0; i < list.size(); i++) {
                String result = this.getResultJSONById(list.get(i).getId(), cloudUrl);
                if (StringUtils.isBlank(result)) {
                    continue;
                }

                JSONObject jsObj = JSONObject.parseObject(result);
                if (jsonObject == null) {
                    jsonObject = jsObj;
                } else {
                    for (String temp : jsObj.keySet()) {
                        if (jsonObject.containsKey(temp)) {
                            JSONObject jsonObjTmp = jsObj.getJSONObject(temp);

                            for (String key : jsonObjTmp.keySet()) {
                                jsonObject.getJSONObject(temp).put(key, jsonObjTmp.getJSONObject(key));
                            }
                            continue;
                        } else {
                            jsonObject.put(temp, jsObj.getJSONObject(temp));
                        }
                    }
                }
            }
            if (jsonObject == null) return "";
            if (list.size() > 0) {
                CloudQuery cloudQuery = list.get(0);
                Double area = cloudQuery.getArea();
                String name = cloudQuery.getName();
                Date querytime = cloudQuery.getQuerytime();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                HashMap<String, Object> data = new HashMap<>();
                data.put("area", area);
                data.put("name", name);
                data.put("queryTime", df.format(querytime));
                jsonObject.put("data", data);
            }

            return JSONObject.toJSONString(jsonObject);

        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public String getResultJSONById(String id, String cloudQueryUrl) {
        try {
            String token = cloudQueryService.getToken();

            HttpClient httpClient = HttpClientBuilder.create().build();
            HttpGet httpGet = new HttpGet();
            httpGet.setHeader("appkey", (String) ProjectConfig.getConfig(ProjectConfigEnum.CLOUD_SERVICE_APP_KEY.getKey()));
            httpGet.setHeader("token", token);

            List<NameValuePair> formparams = new ArrayList<NameValuePair>();
            formparams.add(new BasicNameValuePair("id", id));
            String param = URLEncodedUtils.format(formparams, "UTF-8");

            httpGet.setURI(URI.create(cloudQueryUrl + "/cloudQuery/v3/getDetailRecordById?" + param));

            HttpResponse response = httpClient.execute(httpGet);
            String httpEntityContent = getHttpEntityContent(response);
            JSONObject jsonObject = JSONObject.parseObject(httpEntityContent);
            if ("OK".equalsIgnoreCase(jsonObject.getString("status"))) {
                return jsonObject.getString("data");
            } else {
                return "";
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return "";
    }

    public List<CloudQuery> getQueryList(String requestId, int times) throws Exception {
        if (times > 120) {
            return new ArrayList<>();
        }

        String sql = "select * from tb_cloud_query where f_requestId ='"+requestId+"' and (f_mark=0 or f_mark is null)";
        List<Map<String, Object>> results = jdbcTemplate.queryForList(sql);
        List<CloudQuery> list = new ArrayList<>();
        list = mapToList(results);
        //List<CloudQuery> list = cloudQueryDao.findByRequestId(requestId, 0);
        boolean success = true;
        for (int i = 0; i < list.size(); i++) {
            if (list.get(i).getState() != 1 && list.get(i).getState() != 2) {
                success = false;
                break;
            }
        }
        if (success) {
            return list;
        }
        Thread.sleep(1000);

        times++;

        return getQueryList(requestId, times);
    }

    private List<CloudQuery> mapToList(List<Map<String, Object>> results) throws java.text.ParseException {
        List<CloudQuery> list = new ArrayList<>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i=0;i<results.size();i++){
            CloudQuery cloudQuery = new CloudQuery();
            Map<String,Object> map = results.get(i);
            cloudQuery.setId(map.get("f_id")==null?"":map.get("f_id").toString());
            cloudQuery.setParam(map.get("f_param")==null?"":map.get("f_param").toString());
            cloudQuery.setUserId(map.get("f_useridstr")==null?"":map.get("f_useridstr").toString());
            cloudQuery.setXzqdm(map.get("f_xzqdm")==null?"":map.get("f_xzqdm").toString());
            cloudQuery.setQuerytime(map.get("f_querytime")==null?null: format.parse(map.get("f_querytime").toString()));
            cloudQuery.setResult(map.get("f_result")==null?"":map.get("f_result").toString());
            cloudQuery.setReplyTime(map.get("f_replytime")==null?null:format.parse(map.get("f_replytime").toString()));
            cloudQuery.setState(map.get("f_state")==null?-1:Integer.valueOf(map.get("f_state").toString()));
            cloudQuery.setWeight(map.get("f_weight")==null?-1:Integer.valueOf(map.get("f_weight").toString()));
            cloudQuery.setDeviceGuid(map.get("f_device_guid")==null?"":map.get("f_device_guid").toString());
            cloudQuery.setIsDeleted(map.get("f_isdeleted")==null?-1:Integer.valueOf(map.get("f_isdeleted").toString()));
            cloudQuery.setType(map.get("f_type")==null?-1:Integer.valueOf(map.get("f_type").toString()));
            cloudQuery.setQueryType(map.get("f_querytype")==null?-1:Integer.valueOf(map.get("f_querytype").toString()));
            cloudQuery.setRelId(map.get("f_relid")==null?"":map.get("f_relid").toString());
            cloudQuery.setArea(map.get("f_area")==null?0.0:Double.valueOf(map.get("f_area").toString()));
            cloudQuery.setIsCollect(map.get("f_iscollect")==null?-1:Integer.valueOf(map.get("f_iscollect").toString()));
            cloudQuery.setName(map.get("f_name")==null?"":map.get("f_name").toString());
            cloudQuery.setShareId(map.get("f_shareid")==null?"":map.get("f_shareid").toString());
            cloudQuery.setShareUser(map.get("f_shareuser")==null?-1L:Long.valueOf(map.get("f_shareuser").toString()));
            cloudQuery.setNum(map.get("f_num")==null?"":map.get("f_num").toString());
            cloudQuery.setRequestId(map.get("f_requestid")==null?"":map.get("f_requestid").toString());
            cloudQuery.setTag(map.get("f_tag")==null?"":map.get("f_tag").toString());
            cloudQuery.setMark(map.get("f_mark")==null?-1:Integer.valueOf(map.get("f_mark").toString()));
            list.add(cloudQuery);
        }
        return list;
    }

    public String getResultJSONById(String id) {
        try {
            String token = cloudQueryService.getToken();

            HttpClient httpClient = HttpClientBuilder.create().build();
            HttpGet httpGet = new HttpGet();
            httpGet.setHeader("appkey", (String) ProjectConfig.getConfig(ProjectConfigEnum.CLOUD_SERVICE_APP_KEY.getKey()));
            httpGet.setHeader("token", token);

            List<NameValuePair> formparams = new ArrayList<NameValuePair>();
            formparams.add(new BasicNameValuePair("id", id));
            String param = URLEncodedUtils.format(formparams, "UTF-8");

            httpGet.setURI(URI.create( (String) ProjectConfig.getConfig(ProjectConfigEnum.CLOUD_SERVICE_URL.getKey()) + "/cloudQuery/v3/getDetailRecordById?" + param));

            HttpResponse response = httpClient.execute(httpGet);
            String httpEntityContent = getHttpEntityContent(response);
            JSONObject jsonObject = JSONObject.parseObject(httpEntityContent);
            if ("OK".equalsIgnoreCase(jsonObject.getString("status"))) {
                return jsonObject.getString("data");
            } else {
                return "";
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return "";
    }


    public byte[] getCloudAnalysisReportSelf(String requestId, String userName, String type, Integer narrow, String title, String tag, String nodeId, ObjectReference ref) throws Exception {

        ref.setTag("pdf");
        String filePath = String.format("%s%s%s_%d_%s.pdf", downloadDir, File.separator, title, narrow, requestId);
        switch (type)
        {
            case "1":
            {
                File file = new File(filePath);
                if (!file.exists()) {
                    ProjectInfo info = cloudAnalyzeService.Parse(requestId, "", userName, 1, tag,false);
                    if (info == null) {
                        return null;
                    }
                    info.userName = userName;
                    info.outFile = filePath;
                    info.narrow = narrow > 0;
                    cloudAnalyzeService.ExportReport(info,false);
                }
            }
                break;
            case "3":
            {
                File file = new File(filePath);
                if (!file.exists()) {
                    ProjectInfo info = cloudAnalyzeService.Parse(requestId, "", userName, 1, tag,true);
                    if (info == null) {
                        return null;
                    }
                    info.userName = userName;
                    info.outFile = filePath;
                    info.narrow = narrow > 0;
                    cloudAnalyzeService.ExportReport(info,true);
                }
            }
                break;
            case "4":
            {
                File file = new File(filePath);
                if (!file.exists()) {
                    YnbhInfo info = cloudAnalyzeService.ParseYnbh(requestId, "", userName, 1, tag);
                    if (info == null) {
                        return null;
                    }
                    info.userName = userName;
                    info.outFile = filePath;
                    info.narrow = narrow > 0;
                    cloudAnalyzeService.ExportReportYn(info);
                }
            }
            break;

        }

        File file = new File(filePath);
        if(!file.exists())
        {
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int) file.length());
        byte[] buffer = new byte[1024];
        int len;
        while ((len = fis.read(buffer)) != -1) {
            baos.write(buffer, 0, len);
        }
        fis.close();
        baos.close();
        byte [] result = baos.toByteArray();

        try {
            Files.delete(Paths.get(filePath));
        } catch (Exception ex) {
            logger.warn("删除文件" + filePath + "失败");
            logger.warn("", ex);
        }
        return result;

    }

    public  void pdfToLongJpg(File pdfFile,String outJpg) throws IOException {
        // 加载PDF文档
        try {
            PDDocument document = PDDocument.load(pdfFile);
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            /*
            int width = 0;
            int height = 0;
            for (int i = 0; i < document.getNumberOfPages(); ++i) {
                PDPage page = document.getPage(i);
                width = Math.max(width, (int) page.getBBox().getWidth());
                height += (int) page.getBBox().getHeight();
            }
            BufferedImage longImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
            */

            BufferedImage longImage = null;
            int y = 0;
            for (int i = 0; i < document.getNumberOfPages(); ++i) {
                BufferedImage image = pdfRenderer.renderImageWithDPI(i, 300, ImageType.RGB);
                if(longImage==null)
                {
                    longImage = new BufferedImage(image.getWidth(), image.getHeight()*document.getNumberOfPages(), BufferedImage.TYPE_INT_RGB);
                }
                int pageHeight = image.getHeight();
                longImage.createGraphics().drawImage(image, 0, y, null);
                y += pageHeight;

            }

            // 保存长图
            File outputFile = new File(outJpg);
            ImageIO.write(longImage, "jpg", outputFile);

            // 关闭PDF文档
            document.close();
        }
        catch (Exception ex)
        {
            logger.error("pdf to jpg error",ex);

        }
    }


    private String getHttpEntityContent(HttpResponse response) throws Exception {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream is = entity.getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = br.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line + "\n");
                line = br.readLine();
            }
            br.close();
            is.close();
            return sb.toString();
        }
        return "";
    }
}
