package com.geoway.landteam.landcloud.service.cloudstatis;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.http.HttpUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.servface.cloudstatis.MCloudStatisService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class MCloudStatisServiceImpl implements MCloudStatisService {
    //@Value("${cloudStatis.url}")
    private String cloudStatisUrl;


    @Override
    public JSONArray listAllEnableResult() throws Exception {

            cloudStatisUrl = (String) ProjectConfig.getConfig(ProjectConfigEnum.CLOUD_STATIS_URL.getKey());
            String url = cloudStatisUrl + "/cloudStatis/result/listAllGroups";
            HttpRequest post = HttpUtil.createPost(url).contentType("application/x-www-form-urlencoded");
            cn.hutool.http.HttpResponse execute = post.execute();
            if (execute.getStatus() == 200) {
                JSONObject body = JSONObject.parseObject(execute.body());
                if (body.containsKey("status") && "OK".equalsIgnoreCase(body.getString("status"))) {
                    return body.getJSONArray("data");
                } else if ("FAILURE".equalsIgnoreCase(body.getString("status"))) {
                    throw new Exception(body.getString("message"));
                } else {
                    throw new Exception("获取云统计任务组失败");
                }
            } else {
                throw new Exception("获取云统计任务组失败");
            }
    }

    @Override
    public JSONArray listStatisItem(String groupName,String dataTime) throws Exception {
        if(StringUtils.isBlank(groupName))
        {
            throw new Exception("未输入云统计任务组名称");
        }
        cloudStatisUrl = (String) ProjectConfig.getConfig(ProjectConfigEnum.CLOUD_STATIS_URL.getKey());
        String url = cloudStatisUrl + "/cloudStatis/result/listItem";
        HttpRequest post = HttpUtil.createPost(url).contentType("application/x-www-form-urlencoded");
        post.form("groupName", groupName);
        post.form("dataTime", dataTime);
        cn.hutool.http.HttpResponse execute = post.execute();
        if (execute.getStatus() == 200) {
            JSONObject body = JSONObject.parseObject(execute.body());
            if (body.containsKey("status") && "OK".equalsIgnoreCase(body.getString("status"))) {
                return body.getJSONArray("data");
            } else if ("FAILURE".equalsIgnoreCase(body.getString("status"))) {
                throw new Exception(body.getString("message"));
            } else {
                throw new Exception("获取云统计任务组统计项失败");
            }
        } else {
            throw new Exception("获取云统计任务组统计项失败");
        }
    }

    @Override
    public JSONArray listStatisResult(String groupName, String dataTime,String xzqdm,Boolean child,String itemName) throws Exception {
        if(StringUtils.isBlank(groupName))
        {
            throw new Exception("未输入云统计任务组名称");
        }
        cloudStatisUrl = (String) ProjectConfig.getConfig(ProjectConfigEnum.CLOUD_STATIS_URL.getKey());
        String url = cloudStatisUrl + "/cloudStatis/result/listResult";
        HttpRequest post = HttpUtil.createPost(url).contentType("application/x-www-form-urlencoded");
        post.form("groupName", groupName);
        post.form("dataTime", dataTime);
        post.form("xzqdm", xzqdm);
        post.form("child", child);
        post.form("itemName", itemName);
        cn.hutool.http.HttpResponse execute = post.execute();
        if (execute.getStatus() == 200) {
            JSONObject body = JSONObject.parseObject(execute.body());
            if (body.containsKey("status") && "OK".equalsIgnoreCase(body.getString("status"))) {
                return body.getJSONArray("data");
            } else if ("FAILURE".equalsIgnoreCase(body.getString("status"))) {
                throw new Exception(body.getString("message"));
            } else {
                throw new Exception("获取云统计任务组统计项失败");
            }
        } else {
            throw new Exception("获取云统计任务组统计项失败");
        }
    }

    @Override
    public JSONArray listStatisIndex() throws Exception {
        cloudStatisUrl = (String) ProjectConfig.getConfig(ProjectConfigEnum.CLOUD_STATIS_URL.getKey());
        String url = cloudStatisUrl + "/cloudStatis/result/listIndex";
        HttpRequest post = HttpUtil.createPost(url).contentType("application/x-www-form-urlencoded");
        cn.hutool.http.HttpResponse execute = post.execute();
        if (execute.getStatus() == 200) {
            JSONObject body = JSONObject.parseObject(execute.body());
            if (body.containsKey("status") && "OK".equalsIgnoreCase(body.getString("status"))) {
                return body.getJSONArray("data");
            } else if ("FAILURE".equalsIgnoreCase(body.getString("status"))) {
                throw new Exception(body.getString("message"));
            } else {
                throw new Exception("获取云统计任务组统计项失败");
            }
        } else {
            throw new Exception("获取云统计任务组统计项失败");
        }
    }
}
