package com.geoway.landteam.landcloud.service.customtask.atlas.service;

import com.geoway.landteam.landcloud.model.atlas.entity.CloudCalculationTask;
import com.geoway.landteam.landcloud.service.util.hdfs.CloudCalculationTaskVo;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * @Author Waves
 * @Date 2023/3/30
 * @Description
 **/
public interface CloudCalculationTaskService {

    //推送到内网
    void push(MultipartFile file, String bizId, String tbid, String templateId, String taskid);

    //创建任务
    String createTask(String definitionId,Long userid,String name);

    //更新状态并创建任务
    void startTask(String taskid);

    List<CloudCalculationTask> queryUnfinishedTask();

    public List<CloudCalculationTask> queryByIds(List<String> ids);

    CloudCalculationTask updateTaskResult(CloudCalculationTask task);

    void getResult(CloudCalculationTask task);

    void export(String taskid);

    List<CloudCalculationTaskVo> getUserVo(Long userid, Integer state, String name);

    String queryNewUnstartedTaskid();

    String createStatistics(String fileName,String taskId);

    void addStatusByTaskid(String taskid,int status);
}
