package com.geoway.landteam.landcloud.service.customtask.atlas.service;

public interface Datasource {

	public static final String PREFIX = "datasource_";
	public boolean testConnection(String connectionString, String user, String password);


	/**
	 * 启动数据库连接池
	 * 
	 * @param connectionString
	 * @param user
	 * @param password
	 * @return
	 */
	boolean startConnectionPool(String connectionString,String user,String password);

	/**
	 * 销毁数据库连接池
	 */
	void destroyConnectionPool();

	/**
	 * 获取实际的数据库访问对象，对于mongo是MongoTemplate对象，对于RMDS是JDBC
	 * 
	 * @param connectionString
	 * @param user
	 * @param password
	 * @return
	 */
	Object getDaoObject(String connectionString, String user, String password);

}
