package com.geoway.landteam.landcloud.service.customtask.atlas.service;

import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @Author Waves
 * @Date 2023/3/30
 * @Description
 **/
@Service
public class DatasourceFactory {

    @Resource
    Map<String,Datasource> datasource;

    public Datasource getDatasource(String type){
        String _type = Datasource.PREFIX + type;
        if(isSupported(_type)){
            return datasource.get(_type);
        }
        throw new RuntimeException("暂不支持该数据源");
    }

    public boolean isSupported(String type){
        return datasource.containsKey(type.toLowerCase());
    }
}
