package com.geoway.landteam.landcloud.service.customtask.atlas.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.model.atlas.entity.CloudCalcuationDef;
import com.geoway.landteam.landcloud.model.atlas.entity.CloudCalculationTask;
import com.geoway.landteam.landcloud.model.datatransfer.constants.IdentityType;
import com.geoway.landteam.landcloud.repository.atlas.CloudCalculationDefRepository;
import com.geoway.landteam.landcloud.repository.atlas.CloudCalculationTaskRepository;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportDataService;
import com.geoway.landteam.landcloud.servface.datatransfer.FileTransferService;
import com.geoway.landteam.landcloud.service.customtask.atlas.service.CloudCalculationTaskService;
import com.geoway.landteam.landcloud.service.customtask.atlas.service.Datasource;
import com.geoway.landteam.landcloud.service.customtask.atlas.service.DatasourceFactory;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.ExportFileUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.FileUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.ZipUtils;
import com.geoway.landteam.landcloud.service.util.hdfs.CloudCalculationTaskVo;
import com.geoway.landteam.landcloud.service.util.hdfs.DBbuilder;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Constants;
import org.apache.poi.ss.usermodel.*;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 后面建议重构：催着上线，反复改，太乱
 * @Author Waves
 * @Date 2023/4/2
 * @Description
 **/
@Service
public class CloudCalculationTaskServiceImpl implements CloudCalculationTaskService {

    GiLoger logger = GwLoger.getLoger(CloudCalculationTaskServiceImpl.class);

    @Autowired
    DataBizService dataBizService;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    ExportDataService exportDataService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    CloudCalculationDefRepository cloudCalculationDefRepository;
    @Autowired
    CloudCalculationTaskRepository cloudCalculationTaskRepository;
    @Autowired
    private FileTransferService fileTransferService;
    @Autowired
    DatasourceFactory datasourceFactory;
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Value("${project.uploadDir}")
    protected String uploadDir;

    @Value("${project.tempDir}")
    protected String tempdir;
    private static final String RESULTURL ="http://192.168.19.55:8099/atlas/task/get?thin=true";

    @Override
    public String createTask(String definitionId,Long userid,String name) {
        Assert.hasText(definitionId,"invalid definitionId");

        Optional<CloudCalcuationDef> def = Optional.of(definitionId)
                .map(cloudCalculationDefRepository::findById)
                .map(e ->  e.<RuntimeException>orElseThrow(RuntimeException::new));
        String params = def.map(CloudCalcuationDef::getParam)
                .filter(StringUtils::isNotBlank)
                .orElseThrow(()-> new RuntimeException("invalid Cloud_Calculation_Definition"));

        JSONArray inputConfig =  def.map(CloudCalcuationDef::getInputConfig)
                .map(JSONArray::parseArray)
                .orElseThrow(()-> new RuntimeException("invalid Cloud_Calculation_Definition_initparam"));

        List<CloudCalculationTask> tasks = new ArrayList<>();
        String taskid = UUID.randomUUID().toString();

        for(int i = 0; i < inputConfig.size(); i++){
            String id = UUID.randomUUID().toString();
            JSONObject inputConfigJson = inputConfig.getJSONObject(i);
            String itemParam =params;
            for(String key :inputConfigJson.keySet()){
                String regix = "#" + key + "#";
                itemParam = itemParam.replaceAll(regix,inputConfigJson.getString(key));
            }
            CloudCalculationTask task = new CloudCalculationTask();
            task.setCreateTime(new Timestamp(System.currentTimeMillis()));
            task.setDefinitionId(definitionId);
            task.setParam(itemParam);
            task.setStatus(0);
            task.setId(id);
            task.setUserid(userid);
            task.setTaskid(taskid);
            task.setName(name);
            tasks.add(task);
        }
        cloudCalculationTaskRepository.saveAll(tasks);
        return taskid;
    }

    @Transactional
    public void push(MultipartFile file, String bizId, String tbid, String templateId, String taskid){
        boolean disabelTransfer = Optional.ofNullable(sysConfigService.findOne("transfer.disable"))
                .map(SysConfig::getValue)
                .map(String::toLowerCase)
                .map("true"::equals)
                .orElse(false);
        String safeFilePath = new StringBuilder()
                .append(tempdir)
                .append("/calc/")
                .append(taskid)
                .toString();
        File zipFile = null;
        try{
            File dir = new File(safeFilePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if(file != null){
                String zipPath = safeFilePath + File.separator + taskid +  ".zip";
                File tempFile =  new File(zipPath);
                FileUtils.copyInputStreamToFile(file.getInputStream(), tempFile);
            }
            if(StringUtils.isNotBlank(bizId)){
                exportDataService.createExportData(safeFilePath,bizId,tbid);
            }

            DBbuilder dBbuilder = new DBbuilder(safeFilePath);
            dBbuilder.setJdbcTemplate(jdbcTemplate);
            dBbuilder.appendTable("tb_cloud_calculatiton_def",String.format("where f_id = '%s'",templateId));
            dBbuilder.appendTable("tb_cloud_calculation_task",String.format("where f_taskid = '%s'",taskid));
            // 压缩文件夹
            Zip4jUtils.zip(safeFilePath,null,false,null);
            // 删除临时文件夹
            ExportFileUtil.deleteFileAndDir(new File(safeFilePath));
            zipFile = new File(safeFilePath + ".zip");

            zipFile.renameTo(new File(safeFilePath + ".calc"));
            if(!disabelTransfer){
                this.fileTransferService.sendFile(safeFilePath + ".calc",IdentityType.WYDC);
            }
        }catch (Exception e){
            logger.error(e.getMessage(),e);
        }finally {
            if(StringUtils.isNotBlank(taskid)){
                cloudCalculationTaskRepository.updataStatusByTaskid(taskid,1);
            }
            if(!disabelTransfer && zipFile != null){
                zipFile.delete();
            }
        }
    }
    public void startTask(String taskid){
        //查询已导入任务
        List<CloudCalculationTask> tasks = cloudCalculationTaskRepository.queryByTaskid(taskid);
        String url = Optional.ofNullable(taskid)
                .map(cloudCalculationDefRepository::queryByTask)
                .map(CloudCalcuationDef::getServiceUrl)
                .orElseThrow(()-> new RuntimeException("查询服务定义错误"));
        //配置任务发送请求
        for (CloudCalculationTask task :tasks){
            JSONArray param = Optional.of(task)
                    .map(CloudCalculationTask::getParam)
                    .map(JSONObject::parseObject)
                    .map(json -> json.getJSONArray("param"))
                    .orElseThrow(RuntimeException::new);

            String queryStr = param.toString().replace("#taskid#",taskid);
            String itemurl = url + "?svcparams=" + queryStr;
            OkHttpClient client = new OkHttpClient().newBuilder().readTimeout(30, TimeUnit.SECONDS).build();
            client.readTimeoutMillis();
            Request _request = new Request.Builder()
                    .url(itemurl)
                    .get()
                    .build();
            String itemid = null;
            try {
                Response resp = client.newCall(_request).execute();
                String responseStr = resp.body().string();
                JSONObject jsonObject = JSONObject.parseObject(responseStr);
                if(jsonObject.getBooleanValue("flag")){
                    itemid = jsonObject.getString("taskId");
                    cloudCalculationTaskRepository.setStarted(task.getId(),itemid);
                }else{
                    logger.error("任务创建失败:" + jsonObject.toJSONString());
                    Integer status = CloudCalculationTask.STATUS_PUSH |CloudCalculationTask.STATUS_LAN_RECEIVED | CloudCalculationTask.STATUS_FINISHED;
                    cloudCalculationTaskRepository.updataStatusByTaskid(taskid,status);
                }
            }catch (Exception e){
                logger.error("任务创建失败");
                Integer status = CloudCalculationTask.STATUS_PUSH |CloudCalculationTask.STATUS_LAN_RECEIVED | CloudCalculationTask.STATUS_FINISHED;
                cloudCalculationTaskRepository.updataStatusByTaskid(taskid,status);
            }
        }
    }
    @Override
    public List<CloudCalculationTask> queryUnfinishedTask(){
        Integer status = CloudCalculationTask.STATUS_PUSH |CloudCalculationTask.STATUS_LAN_RECEIVED | CloudCalculationTask.STATUS_STARTED;
        return  cloudCalculationTaskRepository.queryByStatus(status);
    }
    @Override
    public List<CloudCalculationTask> queryByIds(List<String> ids){
        return  cloudCalculationTaskRepository.queryByIds(ids);
    }
    @Override
    public CloudCalculationTask updateTaskResult(CloudCalculationTask task){
        String item = task.getItemid();
        String url = RESULTURL +"&id=" + item;
        JSONObject result =  httpGet(url);
        int curState = task.getStatus();
        Boolean hasTask = result.getBoolean("flag");
        if(hasTask!= null && !hasTask){
            curState = curState|CloudCalculationTask.STATUS_FINISHED;
            task.setStatus(curState);
            task.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            return cloudCalculationTaskRepository.save(task);
        }
        String state = result.getString("State");
        boolean success = result.getBoolean("IsSucceed");
        String timecost = result.getString("TimeCost");
        if(success){
            try {
                getResult(task);
                curState = curState|CloudCalculationTask.STATUS_SUCCESS;
            }catch (Exception e){
                logger.error(e);
            }
        }
        if("Finished".equals(state)){
            curState = curState|CloudCalculationTask.STATUS_FINISHED;
            task.setStatus(curState);
            task.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            task.setTimecost(timecost);
            return cloudCalculationTaskRepository.save(task);
        }
        return task;
    }
    public void getResult(CloudCalculationTask task){
        Optional<CloudCalcuationDef> defOptional = Optional.of(task.getTaskid())
                .map(cloudCalculationDefRepository::queryByTask);
        JSONArray datasources =  defOptional.map(CloudCalcuationDef::getOutputDataSource)
                .map(JSONObject::parseArray)
                .orElseThrow(()-> new RuntimeException());
        JSONArray outputConfigs = defOptional.map(CloudCalcuationDef::getOutputConfig)
                .map(JSONObject::parseArray)
                .orElseThrow(()-> new RuntimeException());
        JSONObject jsonObject =  new JSONObject();
        for(int i = 0; i < datasources.size(); i++){

            JSONObject datasource = datasources.getJSONObject(i);
            JSONObject taskParamJson = Optional.of(task)
                    .map(CloudCalculationTask::getParam)
                    .map(JSONObject::parseObject)
                    .orElseGet(JSONObject::new);
            String type = datasource.getString("type");
            Datasource ds = datasourceFactory.getDatasource(type);
            String source = datasource.getString("dataSource");
            if("hdfs".equalsIgnoreCase(type)){
//                String hdfPath = datasource.getString("path");
//                Hdfs hdfs = (Hdfs)ds.getDaoObject(source,null,null);
//                String shapefie = hdfPath + File.separator + task.getTaskid();
//                String localPath = this.tempdir ;
//                hdfsHandler.downfile("LOCAL",hdfPath,th)
            }else{
                String dbuser = datasource.getString("dbuser");
                String password = datasource.getString("dbpassword");
                String tablename = datasource.getString("tablename");
                boolean shapeData = datasource.getBooleanValue("shapeData");
                ds.startConnectionPool(source,dbuser,password);
                if(!ds.testConnection(source,dbuser,password)) {
                    throw new RuntimeException("输入数据源连接失败");
                }
                JdbcTemplate outputTemplate = (JdbcTemplate)ds.getDaoObject(source,dbuser,password);
                for(int j = 0; j < outputConfigs.size(); j++){
                    JSONObject config = outputConfigs.getJSONObject(j);
                    String fxx = config.getString("fxx");
                    String shpName = config.getString("shpName");
                    String sql;
                    String countsql;
                    try{
                        countsql = String.format("select count(*) from %s where taskid ='%s' and fxx='%s'",tablename,task.getTaskid(),fxx);
                        long count = outputTemplate.queryForObject(countsql,Long.class);
                        if(shapeData && count > 0 && count < 100000){
                            sql = String.format("select taskid,fxx,xjmj,shape from %s where taskid ='%s' and fxx='%s'",tablename,task.getTaskid(),fxx);
                        }else {
                            sql = String.format("select taskid,fxx,xjmj from %s where taskid ='%s' and fxx='%s'",tablename,task.getTaskid(),fxx);
                        }
                        if(count == 0){
                            jsonObject.put(shpName,0d);
                        }else{
                            List<Map<String,Object>> result = outputTemplate.queryForList(sql);
                            if(shapeData && count< 100000){
                                String shpPath = tempdir + File.separator
                                        + "calc" + File.separator
                                        + "result" + File.separator
                                        + task.getTaskid() + File.separator
                                        + "shape" + File.separator
                                        + shpName + "压占图斑.shp";
                                List<String> fields = Arrays.asList("taskid","fxx","xjmj","shape");
                                createShp(shpPath,fields,result);
                            }
                            Double sum = result.stream().mapToDouble(e ->Double.parseDouble((String)e.get("xjmj"))).sum();
                            jsonObject.put(shpName,sum);
                        }
                    }catch (Exception e){
                        jsonObject.put(shpName,0d);
                        logger.error(e);
                    }
                }
            }
            task.setResult(jsonObject.toJSONString());
        }
        int curState = task.getStatus()|CloudCalculationTask.STATUS_SUCCESS;
        task.setStatus(curState);
        cloudCalculationTaskRepository.save(task);
    }
    @Override
    public void export(String taskid){

        boolean disabelTransfer = Optional.ofNullable(sysConfigService.findOne("transfer.disable"))
                .map(SysConfig::getValue)
                .map(String::toLowerCase)
                .map("true"::equals)
                .orElse(false);
        String safeFilePath = new StringBuilder()
                .append(tempdir).append(File.separator)
                .append("calc").append(File.separator)
                .append("result").append(File.separator)
                .append(taskid)
                .toString();
        File zipFile = null;
        try{
            File dir = new File(safeFilePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }

            DBbuilder dBbuilder = new DBbuilder(safeFilePath);
            dBbuilder.setJdbcTemplate(jdbcTemplate);
            dBbuilder.appendTable("tb_cloud_calculation_task",String.format("where f_taskid = '%s'",taskid));
            //把shape打包
            String shapePath = safeFilePath + File.separator + "shape";
            if(new File(shapePath).exists()) {
                Zip4jUtils.zip(shapePath, null, false, null);
                ExportFileUtil.deleteFileAndDir(new File(shapePath));
            }
            // 压缩文件夹
            Zip4jUtils.zip(safeFilePath,null,false,null);
            // 删除临时文件夹
            ExportFileUtil.deleteFileAndDir(new File(safeFilePath));
            zipFile = new File(safeFilePath + ".zip");
            zipFile.renameTo(new File(safeFilePath + ".calc"));
            zipFile = new File(safeFilePath + ".calc");
            if(!disabelTransfer){
                this.fileTransferService.sendFile(safeFilePath + ".calc", IdentityType.WYDC);
            }
        }catch (Exception e){
            logger.error(e.getMessage(),e);
        }finally {
            addStatusByTaskid(taskid,CloudCalculationTask.STATUS_RETURN);
             if (zipFile !=null && zipFile.exists()){
                 zipFile.delete();
             }
        }
    }

    @Override
    public List<CloudCalculationTaskVo> getUserVo(Long userid,Integer state,String name){
        List<CloudCalculationTask> tasks = cloudCalculationTaskRepository.queryByUserid(userid);
        return this.convert(tasks,state,name);
    }
    private   void createShp(String shpPath,  List<String> attrKeys, List<Map<String, Object>> data){
        if (data == null || data.size() == 0) {
            return;
        }
        String parent = FilenameUtils.getFullPath(shpPath);
        new File(parent).mkdirs();
        Map<String, Serializable> params = null;
        ShapefileDataStore ds = null;
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = null;
        SimpleFeatureTypeBuilder tb = null;
        SimpleFeature feature = null;
        Map<String, Object> row = null;
        Geometry geom = null;
        try {
            //创建shape文件对象
            File file = new File(shpPath);
            params = new HashMap<>();
            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
            ds = (ShapefileDataStore) new ShapefileDataStoreFactory().createNewDataStore(params);

            //定义图形信息和属性信息
            tb = new SimpleFeatureTypeBuilder();
            tb.setCRS(CRS.decode("EPSG:4490"));
            tb.setName("shapefile");
            for (String field : attrKeys) {
                if("shape".equals(field)){
                    tb.add(field.toUpperCase(), MultiPolygon.class);
                }else if("xjmj".equals(field)) {
                    tb.add(field.toUpperCase(), Double.class);
                }else {
                    tb.add(field.toUpperCase(), String.class);
                }
            }
            SimpleFeatureType sft = tb.buildFeatureType();
            ds.createSchema(sft);
            //设置编码
            ds.setCharset(Charset.forName("UTF-8"));

            //设置Writer
             writer = ds.getFeatureWriter(ds.getTypeNames()[0], Transaction.AUTO_COMMIT);

            GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
            WKTReader wtkreader = new WKTReader(geometryFactory);
            //写入文件信息
            for (int i = 0; i < data.size(); i++) {
                feature = writer.next();
                row = data.get(i);

                String wkt = row.get("shape").toString();
                if (wkt.toLowerCase().startsWith("srid")){
                    wkt = wkt.substring(wkt.indexOf(";") + 1);
                }
                geom = wtkreader.read(wkt);

                feature.setAttribute("the_geom", geom);
                for (String key : row.keySet()) {
                    if (!key.equals("shape")) {
                        if (row.get(key) != null && StringUtils.isNotBlank(row.get(key).toString())) {
                            if (key.length() >= 10) {
                                feature.setAttribute(key.substring(0, 10).toUpperCase(), row.get(key).toString());
                            } else {
                                feature.setAttribute(key.toUpperCase(), row.get(key).toString());
                            }
                        } else {
                            if (key.length() >= 10) {
                                feature.setAttribute(key.substring(0, 10).toUpperCase(), "");
                            } else {
                                feature.setAttribute(key.toUpperCase(), "");
                            }
                        }
                    }
                }
            }
            writer.write();
            writer.close();
            ds.dispose();

            //添加到压缩文件
//            zipShapeFile(shpPath);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (params != null) {
                params = null;
            }
            if (tb != null) {
                tb = null;
            }
            if (feature != null) {
                feature = null;
            }
            if (row != null) {
                row = null;
            }
            if (geom != null) {
                geom = null;
            }
            if (ds != null) {
                ds.dispose();
                ds = null;
            }
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
                writer = null;
            }

        }
    }
    private JSONObject httpGet(String url){
        OkHttpClient client = new OkHttpClient().newBuilder().readTimeout(30, TimeUnit.SECONDS).build();
        client.readTimeoutMillis();
        Request _request = new Request.Builder()
                .url(url)
                .get()
                .build();
        try {
            Response resp = client.newCall(_request).execute();
            String responseStr = resp.body().string();
            return JSONObject.parseObject(responseStr);
        }catch (IOException e){
            throw new RuntimeException("atlas请求失败");
        }
    }

    /**
     * 这里初版的逻辑是十一条记录任务为一组汇总为同一个vo,后面atlas升级支持并行计算这里已经没有实际意义但还是保留了
     * @param list
     * @param state
     * @param name
     * @return
     */
    private List<CloudCalculationTaskVo> convert(List<CloudCalculationTask> list, Integer state, String name){
        int _state = Optional.ofNullable(state).orElse(-1);
        Map<String,List<CloudCalculationTask>> groupedTask = list.stream()
                .collect(Collectors.groupingBy(CloudCalculationTask::getTaskid));
        List<CloudCalculationTaskVo> result = groupedTask.entrySet()
                .stream().map(Map.Entry::getValue)
                .map(this::mapToVo)
                .filter(e -> StringUtils.isBlank(name) || e.getName() == name)
                .filter(e-> _state == -1 || _state == e.getState())
                .collect(Collectors.toList());
        return result;
    }
    private CloudCalculationTaskVo mapToVo(List<CloudCalculationTask> list){
        Assert.notEmpty(list);
        List<String> taskids = list.stream().map(CloudCalculationTask::getTaskid).distinct().collect(Collectors.toList());
        Assert.isTrue(taskids.size() ==1);
        CloudCalculationTask task = list.get(0);
        String taskid = task.getTaskid();
        String name = task.getName();
        String userName = Optional.of(task)
                .map(CloudCalculationTask::getUserid)
                .map(landUserRepository::findById)
                .map(e -> e.orElse(null))
                .map(LandUser::getName)
                .orElse("");
        Date  date = new Date(task.getCreateTime().getTime());
        SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
        String createtime = sdf.format(date);
        List<Integer> status =list.stream()
                .map(CloudCalculationTask::getStatus)
                .map(i->i&(CloudCalculationTask.STATUS_SUCCESS|CloudCalculationTask.STATUS_RETURNED))
                .distinct()
                .collect(Collectors.toList());
        int state = 0;
        if(status.contains(CloudCalculationTask.STATUS_RETURNED) ){
            state = 2;
        }else if(status.contains(0)){
            state = 0;
        }else {
            state  = 1;
        }
        CloudCalculationTaskVo  vo = new CloudCalculationTaskVo();
        if((task.getStatus() & CloudCalculationTask.STATUS_RETURNED) ==CloudCalculationTask.STATUS_RETURNED){
            JSONObject statistics = new JSONObject();
            list.stream().map(this::getResultJson)
                    .forEach(statistics::putAll);
            String url =  statistics.getString("shape");
            if(StringUtils.isNotBlank(url)){
                url =  temporarySignedUrlService.getTemporarySignedUrl("",url,null);
            }
            statistics.remove("shape");
            vo.setUrl(url);
            vo.setStatistics(statistics);
            String excel =  statistics.getString("excel");
            if(StringUtils.isNotBlank(excel)){
                excel =  temporarySignedUrlService.getTemporarySignedUrl("",url,null);
            }else{
                //生成excel

//                String excelUrl = excel;
//                list.stream().forEach(e ->{
//                    JSONObject result = getResultJson(e);
//                    result.put("excel", excelUrl);
//                    e.setResult(result.toJSONString());
//                });
            }
            vo.setExcelUrl(excel);
        }
        vo.setName(name);
        vo.setTaskid(taskid);
        vo.setUsername(userName);
        vo.setCreatetime(createtime);
        vo.setState(state);
        return vo;
    }

    private JSONObject getResultJson(CloudCalculationTask task){
       return Optional.of(task)
                .map(CloudCalculationTask::getResult)
                .map(JSONObject::parseObject)
                .orElseGet(JSONObject::new);
    }

    @Override
    public String queryNewUnstartedTaskid(){
        List<CloudCalculationTask> tasks = cloudCalculationTaskRepository.queryByStatus(CloudCalculationTask.STATUS_PUSH |CloudCalculationTask.STATUS_LAN_RECEIVED);
        return tasks.stream().
                min(Comparator.comparing(CloudCalculationTask::getCreateTime))
                .map(CloudCalculationTask::getTaskid)
                .orElse(null);
    }

    public String createStatistics(String fileName,String taskId){

        String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        String pathRoot = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
        String srcFileName = new StringBuilder()
                .append(pathRoot)
                .append("excel")
                .append(File.separator)
                .append("进出平衡质检规则意见表.xls")
                .toString();
        String ouputFile = new StringBuilder()
                .append(tempdir)
                .append(File.separator)
                .append("excel")
                .append(File.separator)
                .append(fileName + System.currentTimeMillis() + ".xlsx")
                .toString();
        //将一组task中的result组合起来形成一个json
        JSONObject statistics = new JSONObject();
        Optional.ofNullable(taskId)
                .map(cloudCalculationTaskRepository::queryByTaskid)
                .orElseGet(ArrayList::new)
                .stream()
                .map(CloudCalculationTask::getResult)
                .filter(StringUtils::isNotBlank)
                .map(JSONObject::parseObject)
                .forEach(statistics::putAll);
        Workbook workbook = null;
        FileInputStream finp =null;
        FileOutputStream fos = null;
        try {
            FileUtil.copyFile(srcFileName,ouputFile);
            finp = new FileInputStream(ouputFile);
            workbook = WorkbookFactory.create(finp);
            Sheet sheet1 = workbook.getSheetAt(0);
            parseSheet(sheet1,0,statistics);

            fos = new FileOutputStream(ouputFile);
            workbook.write(fos);
            fos.close();

        }catch (Exception e){
            ouputFile = "";
            e.printStackTrace();
        }finally {
            if(finp !=null){
                try {
                    finp.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if(fos != null){
                try {
                    fos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ouputFile;
    }

    private void parseSheet(Sheet sheet, int idFieldIndex, Map<String,Object> data){
        if(data.isEmpty()) return;

        int rowCount = sheet.getPhysicalNumberOfRows();
        Row row = null;
        for (int i = 0; i < rowCount; i++) {
            row = sheet.getRow(i);
            if (row == null ) {
                continue;
            }
            try {
                //获取到包含索引列的单元格及索引内容
                Cell idCell = row.getCell(idFieldIndex);
                String key = getCellStringValue(idCell);
                //跳过统计列
                if(StringUtils.isBlank(key)) continue;
                //将统计结果填入表中
                for(String _key :data.keySet()){
                    //跳过索引字段
                    if(!_key.equals(key)) continue;
                    Double value = Double.valueOf(String.valueOf(data.get(_key)));
                    row.getCell(5).setCellValue(value);
                }
            } catch (Exception e) {
                e.printStackTrace();
                logger.error(e);
                continue;
            }
        }
        sheet.setForceFormulaRecalculation(true);
    }


    private String getCellStringValue(Cell cell) {
        String cellValue = "";
        if (cell == null) {
            return "";
        }
        try {
            CellType cellType = cell.getCellType();
            switch (cellType) {
                case STRING: //文本
                    cellValue = cell.getStringCellValue();
                    break;
                case NUMERIC: //数字、日期
                    if (DateUtil.isCellDateFormatted(cell)) {
                        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                        cellValue = fmt.format(cell.getDateCellValue()); //日期型
                    } else {
                        cellValue = String.valueOf((long) cell.getNumericCellValue()); //数字
                    }
                    break;
                case BOOLEAN: //布尔型
                    cellValue = String.valueOf(cell.getBooleanCellValue());
                    break;
                case BLANK: //空白
                    cellValue = cell.getStringCellValue();
                    break;
                case ERROR: //错误
                    cellValue = "错误";
                    break;
                case FORMULA: //公式
                    cellValue = "错误";
                    break;
                default:
                    cellValue = "错误";
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return cellValue;
    }
    public void addStatusByTaskid(String taskid,int status){
        String sql = String.format("update tb_cloud_calculation_task  set f_status = (f_status|%s) where f_taskid = '%s'",status,taskid);
        jdbcTemplate.update(sql);
    }
}
