package com.geoway.landteam.landcloud.service.customtask.atlas.service.impl;


import com.geoway.landteam.landcloud.service.customtask.atlas.service.Datasource;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.Hdfs;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.HdfsFactory;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.HdfsPool;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.HdfsPoolConfig;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

@Service("datasource_hdfs")
public class DatasourceHdfs implements Datasource {

	GiLoger logger = GwLoger.getLoger(DatasourceHdfs.class);

	
//	private ConcurrentHashMap<String, FileSystem> dbConnections = new ConcurrentHashMap<String, FileSystem>();

    @Autowired
	HdfsFactory hdfsFactory;

	@Autowired
	HdfsPoolConfig hdfsPoolConfig;

	HdfsPool hdfsPool;

	@PostConstruct
	public void initPoll() {
		hdfsPool= new HdfsPool(hdfsFactory,hdfsPoolConfig);
	}

	@Override
	public boolean testConnection(String connectionString, String user, String password) {

		Hdfs hdfs;
		try {
			hdfs= hdfsPool.borrowObject(connectionString,20000);
			boolean isOk= hdfs.isConnected();
			return isOk;
		} catch (Exception e) {
			logger.error("hdfs数据源错误", e);
			throw new RuntimeException("hdfs数据源错误" +connectionString, e);
		}finally {
			hdfsPool.clear(connectionString);
		}
	}

	@Override
	public boolean startConnectionPool(String connectionString, String user, String password) {

		String connString = connectionString;
		try {
			if(hdfsPool.borrowObject(connString)!=null){
				return true;
			}
			//如果找不到对象。则创建对象
			hdfsPool.addObject(connectionString);
			return hdfsPool.borrowObject(connString).isConnected();
		} catch (Exception e) {
			logger.error("hdfs数据源错误", e);
			throw new RuntimeException("hdfs数据源错误" + connString, e);
		}

	}

	@PreDestroy
	@Override
	public void destroyConnectionPool() {
		hdfsPool.clear();
	}

	@Override
	public Hdfs getDaoObject(String connectionString, String user, String password) {
		try {
			return hdfsPool.borrowObject(connectionString);
		}catch (Exception e){
			throw new RuntimeException("hdfs数据源获取错误");
		}
	}

	public void destroyConnectionPoolByKey(String key) {
		hdfsPool.clear(key);
	}
	public void returnDaoObject(String key,Hdfs fs){
		try {
			hdfsPool.returnObject(key,fs);
		}catch (Exception e){
			throw new RuntimeException("hdfs数据源获取错误");
		}

	}

}
