package com.geoway.landteam.landcloud.service.customtask.atlas.service.impl;


import com.geoway.landteam.landcloud.service.customtask.atlas.service.Datasource;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.PreDestroy;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.ConcurrentHashMap;

@Service("datasource_postgresql")
public class DatasourcePostgresql implements Datasource {
   
	GiLoger logger = GwLoger.getLoger(DatasourcePostgresql.class);
	
	private final String jdbcProtocol = "jdbc:postgresql://";
	private final String jdbcDriver = "org.postgresql.Driver";

	private ConcurrentHashMap<String, JdbcTemplate> dbConnections = new ConcurrentHashMap<String, JdbcTemplate>();

	@PreDestroy
	@Override
	public void destroyConnectionPool() {
		for (String ms : dbConnections.keySet()) {
			((ComboPooledDataSource) dbConnections.get(ms).getDataSource()).close();
		}
		dbConnections.clear();
	}

	@Override
	public boolean testConnection(String connectionString, String user, String password) {
		Connection conn = null;
		try {
			Class.forName(jdbcDriver);
			conn = DriverManager.getConnection(this.jdbcProtocol+connectionString, user, password);
			String sql = "select 1";

			Statement stmt = conn.createStatement();
			stmt.execute(sql);
			ResultSet rs = stmt.getResultSet();
			rs.close();
			stmt.close();
			return true;
		} catch (Exception e) {
			logger.error("postgresql数据源错误", e);
			throw new RuntimeException("postgresql数据源错误", e);
		} finally {
			try {
				if (conn != null) {
					conn.close();
				}
			} catch (Exception rse) {
			}
		}
	}

	@Override
	public boolean startConnectionPool(String connectionString,String user,String password) {

		String key = connectionString + ";" + user + ";" + password;
		if (dbConnections.containsKey(key)) {
			return true;
		}
		try {

			synchronized (dbConnections) {
				
				Class.forName(jdbcDriver);

				ComboPooledDataSource dataSource = new ComboPooledDataSource();
				dataSource.setDriverClass(jdbcDriver);
				dataSource.setJdbcUrl(this.jdbcProtocol+connectionString);
				dataSource.setUser(user);
				dataSource.setPassword(password);
				String sql = "select 1";
				dataSource.setPreferredTestQuery(sql);
				dataSource.setMaxPoolSize(50);
				dataSource.setMinPoolSize(10);
				dataSource.setMaxIdleTime(60 * 30);
				JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);

				// 执行sql语句，用户初始化连接池
				jdbcTemplate.queryForRowSet(sql);
				dbConnections.put(key, jdbcTemplate);
				return true;
			}
		} catch (Exception e) {
			logger.error("关系数据库数据源错误", e);
			throw new RuntimeException("关系数据库无法连接" + connectionString, e);
		}
	}

	@Override
	public JdbcTemplate getDaoObject(String connectionString, String user, String password) {
		startConnectionPool(connectionString,user,password);
		String key = connectionString + ";" + user + ";" + password;
		return dbConnections.get(key);
	}


}
