package com.geoway.landteam.landcloud.service.customtask.pub.impl;


import static com.geoway.landteam.landcloud.service.customtask.task.MTaskTransMediaService.get7FeaturesFromAppMedia;


import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.mq.DataDownloadProducerService;
import com.geoway.landteam.customtask.servface.mq.DownloadGeometryProducerService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.gw.base.util.GutilAssert;
import org.apache.commons.io.FileUtils;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import org.apache.logging.log4j.util.Constants;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;


import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppBasicRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.servface.base.AppBasicService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;

import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.util.Zip4jConstants;

/**
 * @author zkn
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class DataDownloadTakeHandService {
    private final GiLoger logger = GwLoger.getLoger(DataDownloadTakeHandService.class);
    private static final String TAKE_HAND_TASK_ID = "ssp";
    private static final String TAKE_HAND = "随手拍";

    protected String uploadDir;
    private String taskId;
    private String taskCode;
    private String taskName;
    private String prjNum;
    private DataDownloadRecord downloadRecord;
    @Autowired
    AppBasicService appBasicService;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    private int pictureCount = 0;
    private int videoCount = 0;
    private Double zipFileSize = 0d;
    private int voiceCount = 0;

    @Autowired
    private DefaultOssOperatorService stsService;
    private int osgbCount = 0;
    private String resultUrl = "";
    @Autowired
    DataDownloadProducerService dataDownloadProducerService;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    AppBasicRepository appBasicRepository;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    UserNameService userNameService;
    @Autowired
    DownloadGeometryProducerService downloadGeometryProducerService;
    @Autowired
    TaskRecordService taskRecordService;

    /**
     * 下载随手拍数据
     *
     * @param tbIds
     * @param tbNames
     * @param userId
     */
    public DataDownloadRecord downloadTakeHandData(String tbIds, String tbNames, Long userId) throws Exception {
        GutilAssert.state(userId > 0, "userId can not be negative number.");

        DataDownloadRecord record = dataDownloadRecordService.buildDataDownloadRecordBaseInfo(TAKE_HAND_TASK_ID, tbIds, userId);
        record.setBatchOpr(false);

        if (redisTemplate.hasKey(record.getId())) {
            redisTemplate.delete(record.getId());
        }
        redisTemplate.opsForValue().set(record.getId(),  JSONObject.toJSONString(record).toString(), 2, TimeUnit.DAYS);

        DownloadParameter attachParameter = new DownloadParameter();
        attachParameter.setTaskId(StringUtils.isNotBlank(taskId) ? taskId : "");
        attachParameter.setTbIds(StringUtils.isNotBlank(record.getTbIds()) ? record.getTbIds() : "");
        attachParameter.setTbNames(StringUtils.isNotBlank(tbNames) ? tbNames : "");
        attachParameter.setOrgIdOrGroupId("");
        attachParameter.setUserId(userId);
        attachParameter.setBizType("ssp");
        attachParameter.setRecordId(StringUtils.isNoneBlank(record.getId()) ? record.getId() : "");
        attachParameter.setDownloadType(3);
        attachParameter.setDataType("attach");

        String paramter = com.alibaba.fastjson.JSONObject.toJSONString(attachParameter);

        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(record.getId());
        taskRecord.setParam(paramter);
        taskRecord.setTasktype(JobConstants.JOB_TYPE_DATA_DOWNLOAD);
        taskRecord.setStarttime(new Date());
        taskRecord.setState(1);
        taskRecord.setUserid(userId);
        taskRecordService.save(taskRecord);

        //dataDownloadProducerService.sendDataDownloadMessageToMq(TAKE_HAND_TASK_ID, paramter);
        return record;
    }

    /**
     * 批量下载随手拍数据
     *
     * @param taskId         任务id
     * @param tbIds          图斑id集合
     * @param tbNames        图斑名称
     * @param userId         用户id
     * @param orgIdOrGroupId 组织机构id(单位云盘)或者工作组id(工作组云盘)
     * @return
     * @throws Exception
     */
    public DataDownloadRecord downloadTakeHandDataBatch(String taskId, String tbIds, String tbNames, Long userId, String orgIdOrGroupId) throws Exception {
        GutilAssert.state(userId > 0, "userId can not be negative number.");

        // 下载记录
        DataDownloadRecord record = buildDataDownloadRecord(tbIds, userId, orgIdOrGroupId);
        // 保存到数据库中
        record = dataDownloadRecordService.save(record);
        record.setBatchOpr(true);

        if (redisTemplate.hasKey(record.getId())) {
            redisTemplate.delete(record.getId());
        }
        redisTemplate.opsForValue().set(record.getId(),  JSONObject.toJSONString(record).toString(), 2, TimeUnit.DAYS);

        DownloadParameter attachParameter = new DownloadParameter();
        attachParameter.setTaskId(StringUtils.isNotBlank(taskId) ? taskId : "");
        attachParameter.setTbIds(StringUtils.isNotBlank(record.getTbIds()) ? record.getTbIds() : "");
        attachParameter.setTbNames(StringUtils.isNotBlank(tbNames) ? tbNames : "");
        attachParameter.setOrgIdOrGroupId(StringUtils.isNotBlank(orgIdOrGroupId) ? orgIdOrGroupId : "");
        attachParameter.setUserId(userId);
        attachParameter.setBizType("ssp");
        attachParameter.setRecordId(StringUtils.isNoneBlank(record.getId()) ? record.getId() : "");
        attachParameter.setDownloadType(3);
        attachParameter.setDataType("attach");

        String paramter = com.alibaba.fastjson.JSONObject.toJSONString(attachParameter);

        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(record.getId());
        taskRecord.setParam(paramter);
        taskRecord.setTasktype(JobConstants.JOB_TYPE_DATA_DOWNLOAD);
        taskRecord.setStarttime(new Date());
        taskRecord.setState(1);
        taskRecord.setUserid(userId);
        taskRecordService.save(taskRecord);

        //dataDownloadProducerService.sendDataDownloadMessageToMq(TAKE_HAND_TASK_ID, paramter);
        return record;
    }

    /**
     * 构建更新下载记录并更新任务名称和图斑数量等字段内容
     *
     * @param tbIds          图斑id集合
     * @param userId         用户id
     * @param orgIdOrGroupId 组织机构id(单位云盘)或者工作组id(工作组云盘)
     */
    private DataDownloadRecord buildDataDownloadRecord(String tbIds, Long userId, String orgIdOrGroupId) {
        DataDownloadRecord dataDownloadRecord = dataDownloadRecordService.buildDataDownloadRecordBaseInfo(TAKE_HAND_TASK_ID, tbIds, userId);

        if (StringUtils.isNotBlank(tbIds)) {
            List<String> ids = Arrays.asList(tbIds.split(","));
            int count = appBasicRepository.queryCountByIds(ids);
            dataDownloadRecord.setTbCount(count);
        } else {
            Integer tbCount = 0;
            List<String> idList = null;
            if (StringUtils.isBlank(orgIdOrGroupId)) {
                tbCount = appBasicRepository.queryCountByUserId(userId.toString());
                idList = appBasicRepository.queryTbidsByUserId(userId.toString());
            } else {
                tbCount = appBasicRepository.queryCountByUserId(orgIdOrGroupId);
                idList = appBasicRepository.queryTbidsByUserId(orgIdOrGroupId);
            }

            if (idList != null && idList.size() > 0) {
                for (String s : idList) {
                    tbIds = tbIds + "," + s;
                }
                if (tbIds.startsWith(",")) {
                    tbIds = tbIds.substring(1);
                }
            }
            dataDownloadRecord.setTbIds(tbIds);
            dataDownloadRecord.setTbCount(tbCount);
        }
        dataDownloadRecord.setName(TAKE_HAND);
        return dataDownloadRecord;
    }

    /**
     * 下载附件
     *
     * @param ids    随手拍id集合
     * @param places 地名集合
     * @param userId 用户id
     * @return 生成的zip包文件所在的obs的地址url
     * @throws IOException
     */
    public void downloadTakeHandAttach(String ids, String places, Long userId, DataDownloadRecord downloadRecord) throws Exception {
        GutilAssert.notNull(downloadRecord, "downloadRecord can not be null ");

        if (dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
            return;
        }

        try {
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
            List<String> placeList = Arrays.asList(places.split(","));
            String tempFolderPath = new StringBuilder()
                    .append(uploadDir)
                    .append(File.separator)
                    .append(UUID.randomUUID().toString())
                    .toString();
            FileUtil.creatDirectoryIfNotExist(tempFolderPath);
            String safeFileName = placeList.size() > 1 ? placeList.get(0).split("_")[0] + "等" : placeList.get(0).split("_")[0];
            safeFileName = safeFileName + "(" + UUID.randomUUID().toString() + ")";
            String fileNameNoSuffix = new StringBuilder()
                    .append(uploadDir)
                    .append(File.separator)
                    .append(safeFileName)
                    .toString();
            if (dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
                return;
            }
            initParameter(TAKE_HAND_TASK_ID, TAKE_HAND, TAKE_HAND, "", downloadRecord);
            exportData(tempFolderPath, fileNameNoSuffix, ids, userId);

            if (dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                return;
            }
            logger.info("随手拍下载 开始压缩成zip文件 ");

            ZipParameters zipParameters = new ZipParameters();
            zipParameters.setCompressionMethod(Zip4jConstants.COMP_DEFLATE);            // 压缩方式
            zipParameters.setCompressionLevel(Zip4jConstants.DEFLATE_LEVEL_NORMAL);    // 压缩级别
            ZipFile zipFile = new ZipFile(fileNameNoSuffix + ".zip");
            File folder = new File(tempFolderPath);
            if (folder.exists()) {
                if (folder.isDirectory()) {
                    File[] subFiles = folder.listFiles();
                    if (subFiles.length > 0) {
                        for (File subFile : subFiles) {
                            if (subFile.isDirectory()) {
                                zipFile.addFolder(subFile, zipParameters);
                            } else {
                                zipFile.addFile(subFile, zipParameters);
                            }
                        }
                    }
//                            ArrayList<File> temp = new ArrayList<File>();
//                            Collections.addAll(temp, subFiles);
//                            zipFile.addFiles(temp, zipParameters);
                }
            }

//                    new ZipFile(fileNameNoSuffix + ".zip").addFolder(tempFolderPath,zipParameters);
//                    // 压缩文件夹
//                    Zip4jUtils.zip(tempFolderPath, fileNameNoSuffix + ".zip", true, "");
            // 计算大小
            zipFileSize = new File(fileNameNoSuffix + ".zip").length() / 1024d;

            logger.info("随手拍下载 开始上传到obs " + safeFileName);

            // zip文件上传到obs云盘
            uploadFileToCloudDisk(userId, safeFileName);

            if (dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                return;
            }

            // 更新下载记录信息
            updateRecordToDataBase(downloadRecord);
            // 刷新redis
            refreshRedisRecord();
            // 删除临时文件夹
            FileUtils.deleteQuietly(new File(tempFolderPath));
            // 删除zip文件
            FileUtils.deleteQuietly(new File(fileNameNoSuffix + ".zip"));
        } catch (Exception e) {
            logger.info("随手拍下载 下载出现异常");
            logger.error(e);

            downloadRecord.setState(DataDownloadStateEnum.FAILED);
            downloadRecord.setErrorMsg(e.getMessage());
            if (downloadRecord.isBatchOpr()) {
                logger.info("随手拍下载 下载出现异常，更新库表记录");
                dataDownloadRecordService.update(downloadRecord);
            }
            refreshRedisRecord();
            throw e;
        }

    }

    /**
     * 初始化下载参数
     *
     * @param taskId
     * @param taskCode
     * @param taskName
     * @param prjNum
     * @param downloadRecord
     */
    public void initParameter(String taskId, String taskCode, String taskName, String prjNum, DataDownloadRecord downloadRecord) {
        GutilAssert.notNull(taskId, "taskId can not be null");
        GutilAssert.notNull(taskCode, "taskCode can not be null");
        GutilAssert.notNull(taskName, "taskName can not be null");
        GutilAssert.notNull(downloadRecord, "downloadRecord can not be null");
        logger.info("随手拍下载 初始化下载参数 taskId:" + taskId + "  taskCode:" + taskCode + "   taskName:" + taskName + "   prjNmu:" + prjNum);
        logger.info("随手拍下载 初始化下载参数 downloadRecord:" + downloadRecord.toString());

        this.taskId = taskId;
        this.taskCode = taskCode;
        this.taskName = taskName;
        this.prjNum = prjNum;
        this.downloadRecord = downloadRecord;
        pictureCount = 0;
        videoCount = 0;
        voiceCount = 0;
        osgbCount = 0;
        zipFileSize = 0d;
        resultUrl = "";
    }

    /**
     * 导出数据
     *
     * @param resultDbFileDir
     * @param fileNameNoSuffix
     * @param ids
     * @param userId
     * @return
     * @throws IOException
     */
    public void exportData(String resultDbFileDir, String fileNameNoSuffix, String ids, Long userId) throws Exception {
        if (dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
            return;
        }
        logger.info("随手拍下载 开始导出数据 ");
        SqlliteConnTool connTool = null;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String destFileName = copyDataBaseFile(resultDbFileDir);
            connTool = new SqlliteConnTool(destFileName);
            conn = connTool.getConnection();
            conn.setAutoCommit(false);
            List<String> idList = Arrays.asList(ids.split(","));
            insertAppBasicData(conn, ps, idList, userId);
            insertMediaData(conn, ps, idList, userId, resultDbFileDir);
        } catch (Exception e) {
            throw e;
        } finally {
            close(connTool, conn, ps);
        }

        return;
    }

    /**
     * 拷贝db文件
     *
     * @param destDbFileDir
     * @return
     * @throws IOException
     */
    private String copyDataBaseFile(String destDbFileDir) throws IOException {

        String destFileName = "";
        String srcFileName = "";
        try {
            FileUtil.creatDirectoryIfNotExist(destDbFileDir);
            String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
            String pathRoot = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
            srcFileName = new StringBuilder()
                    .append(pathRoot)
                    .append("data")
                    .append(File.separator)
                    .append("meta.db")
                    .toString();
            destFileName = new StringBuilder()
                    .append(destDbFileDir)
                    .append(File.separator)
                    .append("meta.db")
                    .toString();
            FileUtils.copyFile(new File(srcFileName), new File(destFileName));
        } catch (IOException e) {
            throw e;
        }
        return destFileName;
    }

    /**
     * 插入图斑记录
     *
     * @param connn
     * @param pre
     * @param idList
     * @param userId
     * @throws Exception
     */
    private void insertAppBasicData(Connection connn, PreparedStatement pre, List<String> idList, Long userId) throws Exception {
        if (dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
            return;
        }
        String sql = "insert into TaskInfo(taskId ,taskCode,taskName,prjNum,tbId,tbLocation,lon,lat,extent,regionCode,requestId,createtime,userName,type,desc) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        pre = connn.prepareStatement(sql);
        String tbId = "";
        String tbLocation = "";
        Double lon = 0D;
        Double lat = 0D;
        String extent = "";
        String regionCode = "";
        String requestId = "";
        String userName = "";
        String createtime = "";
//        taskId = taskId;
//        taskCode = taskCode;
        String taskName = "";
        for (String id : idList) {
            logger.info("随手拍下载 导出数据---插入图斑数据 图斑个数：" + idList.size());
            if (dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                return;
            }
            AppBasic appbasic = appBasicService.getDetailById(id, userId.toString());
            taskId = id;
            tbId = id;
            tbLocation = StringUtils.isNotBlank(appbasic.getName()) ? appbasic.getName() : null;
            taskName = StringUtils.isNotBlank(appbasic.getHeading()) ? appbasic.getHeading() :
                    (StringUtils.isNotBlank(appbasic.getName()) ? appbasic.getName() : "");
            lon = appbasic.getLon();
            lat = appbasic.getLat();
            extent = appbasic.getShape();
            regionCode = appbasic.getCounty();
            requestId = appbasic.getRequestId();
            createtime = appbasic.getCreatetime();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); //设置格式
            try {
                Timestamp ts = new Timestamp(Long.valueOf(createtime));
                createtime = format.format(ts);
            } catch (Exception e) {
                e.printStackTrace();
                createtime = appbasic.getCreatetime();
            }
            // 将用户名转换成用户真实姓名
            userName = userNameService.getUserRealNameByUserName(appbasic.getUsername());

            pre.setString(1, taskId);
            pre.setString(2, taskCode);
            pre.setString(3, taskName);
            pre.setString(4, prjNum);
            pre.setString(5, tbId);
            pre.setString(6, tbLocation);
            pre.setDouble(7, lon != null ? lon : 0D);
            pre.setDouble(8, lat != null ? lat : 0D);
            pre.setString(9, extent);
            pre.setString(10, StringUtils.isNoneBlank(regionCode) ? regionCode : "");
            pre.setString(11, requestId);
            pre.setString(12, createtime);
            pre.setString(13, userName);
            pre.setString(14, StringUtils.isNotBlank(appbasic.getType()) ? appbasic.getType() : "");
            pre.setString(15, StringUtils.isNotBlank(appbasic.getDesc()) ? appbasic.getDesc() : "");

            pre.addBatch();
        }
        pre.executeBatch();
        pre.clearBatch();
        connn.commit();
    }

    /**
     * 插入附件记录
     *
     * @param conn
     * @param pre
     * @param idList
     * @param userId
     * @param tempSavePath
     * @throws Exception
     */
    private void insertMediaData(Connection conn, PreparedStatement pre, List<String> idList, Long userId, String tempSavePath) throws Exception {
        if (dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
            return;
        }
        String sql = "insert into ResultInfo(attachId ,tbId,mediaSource,mediaFormat,mediaType,viewURL," +
                "mediaMeta,jym,status,otherMetaData,time,mediaTimeLength,mediaSize,filename) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        pre = conn.prepareStatement(sql);
        if (idList != null && idList.size() > 0) {
            logger.info("随手拍下载 导出数据---导出附件数据 图斑总个数：" + idList.size());
            int index = 0;
            for (String id : idList) {
                index++;
                if (dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                    return;
                }
                logger.info("随手拍下载 正在查询第" + index + "个图斑的附件数据 图斑id：" + id);
                AppBasic appbasic = appBasicService.getDetailById(id, userId.toString());
                List<AppMedia> medias = appbasic.getList();
                if (medias != null && medias.size() > 0) {
                    int mediaIndex = 0;
                    for (AppMedia media : medias) {
                        mediaIndex++;
                        if (dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                            return;
                        }
                        logger.info("随手拍下载 正在导出第" + mediaIndex + "个附件数据,共" + medias.size() + "个附件 appMedia id：" + media.getId());

                        String attachId = media.getId();
                        String tbId = media.getGalleryid();
                        Integer mediaSource = 0;
                        String azimuth = media.getAzimuth();
                        String pitch = media.getPitch();
                        String shape = media.getShape();
                        Integer type = media.getType();
                        String videorecord = media.getVideorecord();
                        Integer mediatimelength = media.getMediatimelength();

                        String time = media.getTime();
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); //设置格式
                        try {
                            Timestamp ts = new Timestamp(Long.valueOf(time));
                            time = format.format(ts);
                        } catch (Exception e) {
                            e.printStackTrace();
                            time = media.getTime();
                        }
                        Integer mediaTimeLength = media.getMediatimelength();
                        if (mediaTimeLength == null) {
                            mediaTimeLength = Integer.valueOf(0);
                        }
                        Double mediaSize = media.getMediasize();
                        if (mediaSize == null) {
                            mediaSize = Double.valueOf(0);
                        }
                        String filename = media.getFileId();


                        String mediaFormat = "";
                        if (media.getType() != null) {
                            if (media.getType() == 1) {
                                pictureCount++;
                                mediaFormat = "jpg";
                            } else if (media.getType() == 2) {
                                videoCount++;
                                mediaFormat = "mp4";
                            } else if (media.getType() == 3) {
                                voiceCount++;
                                mediaFormat = "mp3";
                            } else if (media.getType() == 4) {
                                osgbCount++;
                                mediaFormat = "osgb";
                            }
                        }
                        String mediaType = "J";
                        String viewURL = "";
                        String mediaMeta = "";
                        if (media.getType() != null) {
                            if (media.getType() == 1) {
                                mediaMeta = get7FeaturesFromAppMedia(media).toJSONString();
                            } else if (media.getType() == 2) {
                                mediaMeta = media.getVideorecord();
                            } else if (media.getType() == 3) {

                            } else if (media.getType() == 4) {
                                mediaMeta = get7FeaturesFromAppMedia(media).toJSONString();
                            }
                        }
                        String jym = "";
                        Integer status = -1;

                        if (media.getTypetype() != null) {
                            if (media.getTypetype() == 0) {
                                status = -1;
                            } else if (media.getTypetype() == 101) {
                                status = 0;
                            } else if (media.getTypetype() == 102) {
                                status = 1;
                            }
                        }
                        String mediaName = media.getId();
                        if (media.getType() != null) {
                            if (media.getType() == 1) {
                                mediaName += ".jpg";
                                mediaType = "J";
                            } else if (media.getType() == 2) {
                                mediaName += ".mp4";
                                mediaType = "V";
                            } else if (media.getType() == 3) {
                                mediaName += ".mp3";
                                mediaType = "M";
                            } else if (media.getType() == 4) {
                                mediaName += ".osgb";
                                mediaType = "O";
                            }
                        }
                        String otherMetaData = "";

                        pre.setString(1, attachId);
                        pre.setString(2, tbId);
                        pre.setInt(3, mediaSource);
                        pre.setString(4, mediaFormat);
                        pre.setString(5, mediaType);
                        pre.setString(6, viewURL);
                        pre.setString(7, mediaMeta);
                        pre.setString(8, jym);
                        pre.setInt(9, status);
                        pre.setString(10, otherMetaData);
                        pre.setString(11, time);
                        pre.setDouble(12, mediaTimeLength);
                        pre.setDouble(13, mediaSize);
                        pre.setString(14, mediaName);
                        pre.addBatch();

                        String mediaPath = new StringBuilder()
                                .append(tempSavePath)
                                .append(File.separator)
                                .append(appbasic.getHeading())
                                .append("(")
                                .append(appbasic.getId())
                                .append(")")
                                .toString();
                        String url = StringUtils.isNotBlank(media.getDownloadUrl()) ? media.getDownloadUrl() : media.getServerpath();
                        try {
                            if (StringUtils.isNotBlank(url)) {
                                if (url.startsWith("https://pan.jfunbox.com")) {
                                    FileUtils.copyURLToFile(new URL(url), new File(mediaPath, mediaName));
                                } else {
                                    // 从华为obs云盘下载附件需要先获取授权地址
                                    url = temporarySignedUrlService.getTemporarySignedUrl(defaultOssOperatorService.getServerId().toString(), url, null);
                                    FileUtils.copyURLToFile(new URL(url), new File(mediaPath, mediaName));
                                }
                            }

                        } catch (IOException e) {
                            logger.error(e);
                            downloadRecord.setErrorMsg("下载文件时出现错误I/O错误");
                        }
                    }
                } else {
                    logger.info("随手拍下载 查询第" + index + "个图斑的附件数据 图斑id：" + id + "    附件总个数：0");
                }
            }
        }
        pre.executeBatch();
        pre.clearBatch();
        conn.commit();
    }

    /**
     * 关闭数据库连接
     *
     * @param connPool
     * @param conn
     * @param ps
     */
    private void close(SqlliteConnTool connPool, Connection conn, PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (conn != null) {
            try {
                conn.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }

        if (connPool != null) {
            try {
                connPool.Dispose();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 上传到云盘
     *
     * @param userId
     * @param safeFileName
     */
    private void uploadFileToCloudDisk(Long userId, String safeFileName) {

        String sendObjName = "ssp/download/" + userId + "/" + safeFileName + ".zip";
        uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        String zipFile = new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append(safeFileName)
                .append(".zip")
                .toString();

        // 上传到obs
        resultUrl = stsService.sendObject2Oss(sendObjName, zipFile);
    }

    /**
     * 将下载记录信息更新到数据库
     *
     * @param downloadRecord
     */
    private void updateRecordToDataBase(DataDownloadRecord downloadRecord) {
        downloadRecord.setUrl(resultUrl);
        downloadRecord.setState(DataDownloadStateEnum.FINISTHE);
        downloadRecord.setEndTime(new Date());
        downloadRecord.setPictureCount(pictureCount);
        downloadRecord.setVideoCount(videoCount);
        downloadRecord.setVoiceCount(voiceCount);
        downloadRecord.set_3dModelCount(osgbCount);
        downloadRecord.setAttachSize(zipFileSize);
        if (downloadRecord.isBatchOpr()) {
            logger.info("随手拍下载 更新下载记录库表 " + downloadRecord.toString());
            dataDownloadRecordService.update(downloadRecord);
        }
    }

    /**
     * 刷新redis
     */
    private void refreshRedisRecord() {
        if (downloadRecord != null && StringUtils.isNotBlank(downloadRecord.getId())) {
            logger.info("随手拍下载 刷新下载记录redis " + downloadRecord.getId());
            if (redisTemplate.hasKey(downloadRecord.getId())) {
                redisTemplate.delete(downloadRecord.getId());
            }
            redisTemplate.opsForValue().set(downloadRecord.getId(), downloadRecord, 2, TimeUnit.DAYS);
        }
    }


    /**
     * 构建更新下载记录并更新任务名称和图斑数量等字段内容
     *
     * @param tbIds          图斑id集合
     * @param userId         用户id
     * @param orgIdOrGroupId 组织机构id(单位云盘)或者工作组id(工作组云盘)
     */
    private DataDownloadRecord buildDataDownloadRecordForGeometry(String tbIds, Long userId, String orgIdOrGroupId) {
        DataDownloadRecord dataDownloadRecord = dataDownloadRecordService.buildDataDownloadRecordBaseInfo(TAKE_HAND_TASK_ID, tbIds, userId);

        if (StringUtils.isNotBlank(tbIds)) {
            List<String> ids = Arrays.asList(tbIds.split(","));
            int count = appBasicRepository.queryCountByIds(ids);
            dataDownloadRecord.setTbIds(tbIds);
            dataDownloadRecord.setTbCount(count);
        } else {
            Integer tbCount = 0;
            List<String> idList = null;
            if (StringUtils.isBlank(orgIdOrGroupId)) {
                tbCount = appBasicRepository.queryCountByUserId(userId.toString());
                idList = appBasicRepository.queryTbidsByUserId(userId.toString());
            } else {
                tbCount = appBasicRepository.queryCountByUserId(orgIdOrGroupId);
                idList = appBasicRepository.queryTbidsByUserId(orgIdOrGroupId);
            }

            if (idList != null && idList.size() > 0) {
                for (String s : idList) {
                    tbIds = tbIds + "," + s;
                }
                if (tbIds.startsWith(",")) {
                    tbIds = tbIds.substring(1);
                }
            }
            dataDownloadRecord.setTbIds(tbIds);
            dataDownloadRecord.setTbCount(tbCount);
        }
        dataDownloadRecord.setName(TAKE_HAND);
        return dataDownloadRecord;
    }

    /**
     * 下载图斑图形数据
     *
     * @param taskId
     * @param tbIds
     * @param userId
     * @param dataType       数据类型 kml 或shape
     * @param isBatch        是否是批量
     * @param orgIdOrGroupId 用户或组织机构id，工作组id
     * @return
     */
    public DataDownloadRecord downloadGeometry(String taskId, String tbIds, Long userId, String dataType, boolean isBatch, String orgIdOrGroupId) {
        checkParameters(taskId, userId, dataType);

        DataDownloadRecord record = buildDataDownloadRecordForGeometry(tbIds, userId, orgIdOrGroupId);
        record.setBatchOpr(isBatch);

        if (redisTemplate.hasKey(record.getId())) {
            redisTemplate.delete(record.getId());
        }
        redisTemplate.opsForValue().set(record.getId(), JSONObject.toJSONString(record).toString(), 2, TimeUnit.DAYS);


        DownloadParameter attachParameter = new DownloadParameter();
        attachParameter.setTaskId(StringUtils.isNotBlank(taskId) ? taskId : "");
        attachParameter.setTbIds(StringUtils.isNotBlank(record.getTbIds()) ? record.getTbIds() : "");
        attachParameter.setTbNames("");
        attachParameter.setOrgIdOrGroupId(StringUtils.isNoneBlank(orgIdOrGroupId) ? orgIdOrGroupId : "");
        attachParameter.setUserId(userId);
        attachParameter.setBizType("ssp");
        attachParameter.setRecordId(StringUtils.isNoneBlank(record.getId()) ? record.getId() : "");
        // 类型为空
        attachParameter.setDownloadType(0);
        attachParameter.setDataType(StringUtils.isNoneBlank(dataType) ? dataType : "");

        String parameterString = com.alibaba.fastjson.JSONObject.toJSONString(attachParameter);

        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(record.getId());
        taskRecord.setParam(parameterString);
        taskRecord.setTasktype(JobConstants.JOB_TYPE_DATA_DOWNLOAD);
        taskRecord.setStarttime(new Date());
        taskRecord.setState(1);
        taskRecord.setUserid(userId);
        taskRecordService.save(taskRecord);

        //downloadGeometryProducerService.sendDataDownloadMessageToMq("ssp", dataType, parameterString);
        return record;
    }

    private void checkParameters(String taskId, Long userId, String dataType) {
        GutilAssert.state(StringUtils.isNotBlank(taskId), "taskId must not be null or empty.");
        GutilAssert.state(userId > -1, "userId can not be negative number.");
        GutilAssert.state(StringUtils.isNotBlank(dataType), "dataType must not be null or empty.");
    }
}
