package com.geoway.landteam.landcloud.service.customtask.pub.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;

import com.geoway.landteam.customtask.servface.pub.DataDownloadDailyTaskService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskRecordService;
import com.geoway.landteam.landcloud.service.customtask.thread.MDownloadAttachThread;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.jms.JMSException;
import javax.jms.MapMessage;
import java.util.concurrent.*;

/**
 * @author zkn
 */
@Service
public class MDataDownloadConsumerServiceImpl implements IConsumerStrategyService {

    private final GiLoger logger = GwLoger.getLoger(MDataDownloadConsumerServiceImpl.class);

    private final String DATA_DOWNLOAD_CODE = "DataDownloadCode";

    @Autowired
    RedisTemplate redisTemplate;

    @Autowired
    DataDownloadDailyTaskService dataDownloadDailyTaskService;

    @Autowired
    MDataDownloadTakeHandService MDataDownloadTakeHandService;

    @Autowired
    DataDownloadRecordService dataDownloadRecordService;

    @Autowired
    MTaskRecordService taskRecordService;

    ExecutorService threadPool = Executors.newFixedThreadPool(10);

    @Override
    public String getCode() {
        return DATA_DOWNLOAD_CODE;
    }

    @Override
    public void execute(MapMessage mapMessage) {
        try {
            String taskId = mapMessage.getString("taskId");
            String parameter = mapMessage.getString("parameter");
             JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(parameter));
            if (jsonObject != null) {
                Object bean =  JSONObject.toJavaObject(jsonObject, DownloadParameter.class);
                if (bean != null) {
                    DownloadParameter downlaodParamter = (DownloadParameter) bean;
                    if (downlaodParamter != null) {
                        DataDownloadRecord record = null;
                        Object value = redisTemplate.opsForValue().get(downlaodParamter.getRecordId());
                        if (value != null) {
                         /*   record = (DataDownloadRecord)  JSONObject.toJavaObject(JSONObject.parseObject(JSONObject.toJSONString(value)), DataDownloadRecord.class);*/
                            record =  JSONObject.toJavaObject(JSONObject.parseObject(value.toString()),DataDownloadRecord.class);
                        }
                        //DataDownloadRecord record = (DataDownloadRecord) redisTemplate.opsForValue().get(downlaodParamter.getRecordId());

                        TaskRecord taskRecord = taskRecordService.findOne(downlaodParamter.getRecordId());
                        if (taskRecord != null) {
                            taskRecord.setState(1);
                            taskRecordService.save(taskRecord);
                        }
                        MDownloadAttachThread thread = new MDownloadAttachThread(taskId, downlaodParamter, record,
                                MDataDownloadTakeHandService, dataDownloadDailyTaskService,
                                taskRecordService);

                        Future<?> future = threadPool.submit(thread);
                        String failReason = null;
                        try {
                            // 等待计算结果，最长等待timeout秒，timeout秒后中止任务
                            Object o = future.get(60, TimeUnit.MINUTES);
                        } catch (InterruptedException e) {
                            failReason = "主线程在等待返回结果时被中断！";
                            taskRecord.setState(4);
                            taskRecord.setRemark(failReason);
                            taskRecordService.save(taskRecord);
                        } catch (ExecutionException e) {
                            failReason = "主线程等待返回结果，但任务本身抛出异常！";
                            taskRecord.setState(4);
                            taskRecord.setRemark(failReason);
                            taskRecordService.save(taskRecord);
                        } catch (TimeoutException e) {
                            failReason = "主线程等待计算结果超时，因此中断任务线程！";
                            taskRecord.setState(4);
                            taskRecord.setRemark(failReason);
                            taskRecordService.save(taskRecord);
                        }
                    }
                }
            }

        } catch (JMSException e) {
            logger.error(e.getMessage());
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

}
