package com.geoway.landteam.landcloud.service.customtask.pub.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;

import com.geoway.landteam.customtask.servface.pub.DataDownloadZjdService;

import com.geoway.landteam.landcloud.service.customtask.task.MTaskRecordService;
import com.geoway.landteam.landcloud.service.customtask.thread.MDownloadZjdThread;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.jms.JMSException;
import javax.jms.MapMessage;
import java.util.concurrent.*;

/**
 * @Author: zkn
 * @Date: 2020/6/24
 * @Description: 下载宅基地数据消费者服务
 */
@Service
public class MDataDownloadZjdConsumerServiceImpl implements IConsumerStrategyService {
    private final String DOWNLOAD_GEOMETRY_CODE = "DownloadZjdDataCode";
    @Autowired
    DataDownloadZjdService dataDownloadZjdService;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    MTaskRecordService taskRecordService;

    ExecutorService threadPool = Executors.newFixedThreadPool(10);

    private final GiLoger logger = GwLoger.getLoger(MDataDownloadZjdConsumerServiceImpl.class);

    @Override
    public String getCode() {
        return DOWNLOAD_GEOMETRY_CODE;
    }

    @Override
    public void execute(MapMessage mapMessage) {
        try {
            String taskId = mapMessage.getString("taskId");
            String tbIds = mapMessage.getString("tbIds");
            Long userId = mapMessage.getLong("userId");
            String recordId = mapMessage.getString("recordId");
            Integer downloadType = mapMessage.getInt("downloadType");

            TaskRecord taskRecord = taskRecordService.findOne(recordId);
            if (taskRecord != null) {
                taskRecord.setState(1);
                taskRecordService.save(taskRecord);
            }
            //DataDownloadRecord record = (DataDownloadRecord) redisTemplate.opsForValue().get(recordId);
            DataDownloadRecord record = null;
            Object value = redisTemplate.opsForValue().get(recordId);
            if (value != null) {
              /*  record = (DataDownloadRecord)  JSONObject.toJavaObject( JSONObject.parseObject(JSONObject.toJSONString(value)), DataDownloadRecord.class);*/
                record =  JSONObject.toJavaObject(JSONObject.parseObject(value.toString()),DataDownloadRecord.class);
                if (record != null) {
                    MDownloadZjdThread thread = new MDownloadZjdThread(dataDownloadZjdService, taskId, tbIds, userId,
                            record, downloadType, taskRecordService);

                    Future<?> future = threadPool.submit(thread);
                    String failReason = null;
                    try {
                        // 等待计算结果，最长等待timeout秒，timeout秒后中止任务
                        Object o = future.get(60, TimeUnit.MINUTES);
                    } catch (InterruptedException e) {
                        failReason = "主线程在等待返回结果时被中断！";
                        taskRecord.setState(4);
                        taskRecord.setRemark(failReason);
                        taskRecordService.save(taskRecord);
                    } catch (ExecutionException e) {
                        failReason = "主线程等待返回结果，但任务本身抛出异常！";
                        taskRecord.setState(4);
                        taskRecord.setRemark(failReason);
                        taskRecordService.save(taskRecord);
                    } catch (TimeoutException e) {
                        failReason = "主线程等待计算结果超时，因此中断任务线程！";
                        taskRecord.setState(4);
                        taskRecord.setRemark(failReason);
                        taskRecordService.save(taskRecord);
                    }
                }
            }
        } catch (JMSException e) {
            logger.error(e.getMessage());
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
    }
}
