package com.geoway.landteam.landcloud.service.customtask.pub.impl;

import com.geoway.landteam.customtask.service.pub.DownloadGeometryDailyTaskBaseService;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.util.ExcelUtil;
import com.geoway.landteam.landcloud.common.util.geometry.ShapeUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFields;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.springframework.stereotype.Service;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: zkn
 * @Date: 2020/6/28 10:41
 * @Description: 下载日常任务Excel格式数据服务实现
 */
@Service
public class MDownloadExcelDailyTaskServiceImpl extends MDownloadGeometryDailyTaskBaseService {
    private final GiLoger logger = GwLoger.getLoger(MDownloadExcelDailyTaskServiceImpl.class);

    private Map<String, String> constHeaderMap;

    @Override
    void exportAction(List<Map> sourceData, String tempSavePath, List<TbtskFields> exportFields) throws Exception {
        if (sourceData != null) {
            logger.info(getDescription() + " 导出数据---图斑总个数：" + sourceData.size());
            String targetFileName = getExportFileName(sourceData, tempSavePath);
            List<String> attrKeys = super.getPropertyKeys(exportFields);
            List<Map<String, Object>> data = new ArrayList<>();
            Map<String, Object> propertyMap = null;

            for (Map map : sourceData) {
                if (dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
                    return;
                }
                propertyMap = super.getPropertyMap(map, exportFields);
                if (propertyMap != null) {
                    if (propertyMap != null) {
                        propertyMap.remove("shape");
                    }
                    data.add(propertyMap);
                }
            }
            try {
                if (data != null && data.size() > 0) {
                    File file = new File(targetFileName);
                    File parentFile = file.getParentFile();
                    if (parentFile != null && (!parentFile.exists())) {
                        parentFile.mkdirs();
                    }

                    Map<String, String> columnsAndHeaders = columnNameToHeaderMap(exportFields);// "序号,用户名,所属行政区,所属单位,联系方式,是否启用,注册时间";
                    if (columnsAndHeaders != null) {
                        for (String key : columnsAndHeaders.keySet()) {
                            if (key.equalsIgnoreCase("shape")) {
                                columnsAndHeaders.remove(key);
                                break;
                            }
                        }
                    }
                    String sheetName = "图斑列表";
                    String filePath = ExcelUtil.CreateExcelXlsx(tempSavePath, file.getName(), sheetName, columnsAndHeaders, data);
                }
            } catch (Exception e) {
                logger.info(getDescription() + " 导出属性数据到excel文件异常 ");
                logger.error(e);
                throw e;
            } finally {
                if (attrKeys != null) {
                    attrKeys = null;
                }
                if (propertyMap != null) {
                    propertyMap = null;
                }
                if (data != null) {
                    data = null;
                }
            }
        } else {
            logger.info(getDescription() + " 导出数据---图斑总个数：0");
        }
    }

    private Map<String, String> columnNameToHeaderMap(List<TbtskFields> exportFields) {
        Map<String, String> result = new HashMap<>();
        if (exportFields != null && exportFields.size() > 0) {
            result.put("taskId", "任务id");
            result.put("taskCode", "任务类型");
            result.put("taskName", "任务名称");
            for (TbtskFields exportField : exportFields) {
                if (StringUtils.isBlank(exportField.getfFieldtype())) {
                    continue;
                }
                if ("taskId".equalsIgnoreCase(exportField.getfFieldname())
                        || "taskCode".equalsIgnoreCase(exportField.getfFieldname())
                        || "taskName".equalsIgnoreCase(exportField.getfFieldname())
                        || "f_shape".equalsIgnoreCase(exportField.getfFieldname())) {
                    continue;
                }
                result.put(exportField.getfFieldname().replace("f_", "").trim(), exportField.getfAlias());
            }
        }
        return result;
    }

    String getHeader(List<TbtskFields> sourceFields) {
        List<String> headers = new ArrayList<>();
        headers.add("任务编号");
        headers.add("任务代码");
        headers.add("任务名称");
        if (sourceFields != null) {

            for (TbtskFields sourceField : sourceFields) {
                headers.add(sourceField.getfAlias());
            }
        }
        return StringUtils.join(headers, ",");
    }


    @Override
    protected String getDataType() {
        return "excel";
    }

    @Override
    protected String getFileExtension() {
        return ".xlsx";
    }

    @Override
    protected  String getDescription() {
        return "日常任务下载【Excel】";
    }

    @Override
    boolean isQueryGeoFields() {
        return false;
    }
}
