package com.geoway.landteam.landcloud.service.customtask.pub.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.service.pub.DownloadGeometryService;

import com.geoway.landteam.customtask.service.task.thread.DownloadGeometryThread;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.jms.JMSException;
import javax.jms.MapMessage;
import java.util.concurrent.*;

/**
 * @Author: zkn
 * @Date: 2020/3/27 11:32
 * @Description: 下载Geometry数据消费者服务
 */
@Service
public class MDownloadGeometryConsumerServiceImpl implements IConsumerStrategyService {
    @Autowired
    MDownloadExcelDailyTaskServiceImpl downloadExcelDailyTaskService;

    private final String DOWNLOAD_GEOMETRY_CODE = "DownloadGeometryCode";
    @Autowired
    MMDownloadGeometryTakeHandKmlServiceImpl downloadGeometryTakeHandKmlService;
    @Autowired
    MMDownloadGeometryTakeHandShapeServiceImpl downloadGeometryTakeHandShapeService;
    @Autowired
    MDownloadGeometryDailyTaskKmlServiceImpl downloadGeometryDailyTaskKmlService;
    @Autowired
    MDownloadGeometryDailyTaskShapeServiceImpl downloadGeometryDailyTaskShapeService;
    @Autowired
    TaskRecordService taskRecordService;

    ExecutorService threadPool = Executors.newFixedThreadPool(10);

    private final GiLoger logger = GwLoger.getLoger(MDownloadGeometryConsumerServiceImpl.class);

    private DownloadGeometryService downloadGeometryService;

    @Override
    public String getCode() {
        return DOWNLOAD_GEOMETRY_CODE;
    }

    @Override
    public void execute(MapMessage mapMessage) {
        try {
            String taskId = mapMessage.getString("taskId");
            String dataType = mapMessage.getString("dataType");
            String parameter = mapMessage.getString("parameter");

            if ("SSP".equalsIgnoreCase(taskId)) {
                if ("KML".equalsIgnoreCase(dataType)) {
                    downloadGeometryService = downloadGeometryTakeHandKmlService;
                } else if ("SHP".equalsIgnoreCase(dataType)) {
                    downloadGeometryService = downloadGeometryTakeHandShapeService;
                } else if ("EXCEL".equalsIgnoreCase(dataType)) {

                }
            } else {
                if ("KML".equalsIgnoreCase(dataType)) {
                    downloadGeometryService = downloadGeometryDailyTaskKmlService;
                } else if ("SHP".equalsIgnoreCase(dataType)) {
                    downloadGeometryService = downloadGeometryDailyTaskShapeService;
                } else if ("EXCEL".equalsIgnoreCase(dataType)) {
                    downloadGeometryService = downloadExcelDailyTaskService;
                }
            }

            if (StringUtils.isNotBlank(parameter)) {
                JSONObject jsonObject = JSONObject.parseObject(parameter);
                Object bean = JSONObject.toJavaObject(jsonObject, DownloadParameter.class);
                if (bean != null && bean instanceof DownloadParameter) {
                    DownloadParameter downloadParam = (DownloadParameter) bean;
                    if (downloadParam != null) {
                        TaskRecord taskRecord = taskRecordService.findOne(downloadParam.getRecordId());
                        if (taskRecord != null) {
                            taskRecord.setState(1);
                            taskRecordService.save(taskRecord);
                        }
                        if (downloadGeometryService != null) {

                            DownloadGeometryThread thread = new DownloadGeometryThread(downloadGeometryService, downloadParam, taskRecordService);

                            Future<?> future = threadPool.submit(thread);
                            String failReason = null;
                            try {
                                // 等待计算结果，最长等待timeout秒，timeout秒后中止任务
                                Object o = future.get(60, TimeUnit.MINUTES);
                            } catch (InterruptedException e) {
                                failReason = "主线程在等待返回结果时被中断！";
                                taskRecord.setState(2);
                                taskRecord.setRemark(failReason);
                                taskRecordService.save(taskRecord);
                            } catch (ExecutionException e) {
                                failReason = "主线程等待返回结果，但任务本身抛出异常！";
                                taskRecord.setState(2);
                                taskRecord.setRemark(failReason);
                                taskRecordService.save(taskRecord);
                            } catch (TimeoutException e) {
                                failReason = "主线程等待计算结果超时，因此中断任务线程！";
                                taskRecord.setState(2);
                                taskRecord.setRemark(failReason);
                                taskRecordService.save(taskRecord);
                            }
                        }

                    }
                }
            }

        } catch (JMSException e) {
            logger.error(e.getMessage());
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
    }
}
