package com.geoway.landteam.landcloud.service.customtask.pub.impl;


import com.geoway.landteam.customtask.enm.DownloadTypeEnum;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskFieldsService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.pub.DataDownloadFieldService;

import com.geoway.landteam.customtask.service.pub.DownloadGeometryDailyTaskBaseService;
import com.geoway.landteam.customtask.service.pub.DownloadGeometryService;

import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;

import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;

import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFields;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueFieldsService;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueSourceService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import com.gw.base.util.GutilAssert;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;

import java.io.File;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;


/**
 * @Author: zkn
 * @Date: 2020/3/27 18:41
 * @Description: 日常任务下载Geometry数据服务类
 */
public abstract class MDownloadGeometryDailyTaskBaseService extends DownloadGeometryService {

    private static final List SystemFiledList = Arrays.asList("f_id", "f_ismycreate", "f_lon", "f_lat", "f_shape");

    private final GiLoger logger = GwLoger.getLoger(DownloadGeometryDailyTaskBaseService.class);
    private static final String TASK_CODE_DAILY_TASK = "日常任务";
   /* @Value("#{imeSettings['project.uploadDir']}")*/
    @Value("${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    TbtskFieldsService tbtskFieldsService;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    UserNameService userNameService;
    @Autowired
    LandUserService landUserService;
    @Autowired
    JcClueSourceService jcClueSourceService;
    @Autowired
    JcClueFieldsService jcClueFieldsService;
    String geoKey = "f_shape";
    String taskId = "";
    String taskCode = "";
    String taskName = "";
    String prjNum = "";

    List<Map> getSourceData(TbtskObjectinfo tbtskObjectinfo, List<String> queryFieldNames) {
        if (dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
            return null;
        }
        String whereClause = "";
        String tableName = "";
        if (downloadParameter.getDownloadType() != null) {
            if (downloadParameter.getDownloadType() == 0) {
                // 下发给我的
                whereClause = " r.f_dataid = d.f_id and r.f_assignto = '" + downloadParameter.getUserId() + "'";
                if (StringUtils.isNotBlank(downloadParameter.getTbIds())) {
                    whereClause += "and d.f_id in ( '" + downloadParameter.getTbIds().replace(",", "','") + "' )";
                }
                tableName = " tbtsk_assign_record r," + tbtskObjectinfo.getfTablename() + " d ";
            } else if (downloadParameter.getDownloadType() == 1) {
                // 下发给我的,我创建的、我管理的
//                whereClause = " d.f_userid = '" + userId + "'";
//                if (StringUtils.isNotBlank(tbIds)) {
//                    whereClause += "and d.f_id in ( '" + tbIds.replace(",", "','") + "' )";
//                }
                TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(downloadParameter.getTaskId());
                String xzqdm = "";
                if (tskTaskBiz.getIsPublic() == 1) {
                    whereClause += " d.f_userid = '" + downloadParameter.getUserId() + "' ";
                } else {
                    List<String> areas = landUserService.queryUserAreas(downloadParameter.getUserId());
                    if (areas != null && areas.size() > 0) {
                        xzqdm = areas.get(0);
                    }
                }

                if (StringUtils.isBlank(xzqdm)) {
                    whereClause += "1=2";
                } else if ("1".equalsIgnoreCase(xzqdm)) {

                } else if (xzqdm.endsWith("0000")) {
                    whereClause += " d.f_xzqdm like '" + xzqdm.substring(0, 2) + "%' ";
                } else if (xzqdm.endsWith("00")) {
                    whereClause += " d.f_xzqdm like '" + xzqdm.substring(0, 4) + "%' ";
                } else {
                    whereClause += " d.f_xzqdm = '" + xzqdm + "' ";
                }

                tableName = tbtskObjectinfo.getfTablename() + " d ";
            } else {
                // 其他，比如批量下载和单个下载
                whereClause = "";
                if (StringUtils.isNotBlank(downloadParameter.getTbIds())) {
                    whereClause += "d.f_id in ( '" + downloadParameter.getTbIds().replace(",", "','") + "' )";
                }
                tableName = tbtskObjectinfo.getfTablename() + " d ";
            }
        }
        List<Map> result = new ArrayList<>();
        List<Map> maps = dataBizService.queryAllData(tableName, queryFieldNames, whereClause);
        result.addAll(maps);
        List<String> parentIdList = new ArrayList<>();
        for (Map map : maps) {
            if(map.containsKey("f_issplitted") && map.get("f_issplitted") != null && "1".equals(map.get("f_issplitted").toString())) {
                parentIdList.add(map.get("f_id").toString());
            }
        }
        if(parentIdList.size() > 0) {
//            String join = String.join(",", parentIdList);
            String childTableName = tbtskObjectinfo.getSplitTableName();
//            List<Map> childMaps = dataBizService.queryAllData(childTableName + " d", queryFieldNames, " f_splitedid in ("+join+")");
            String join = String.join(",", parentIdList);
            List<Map> childMaps = dataBizService.queryAllData(childTableName + " d ", queryFieldNames, " d.f_splitedid in ( '" + join.replace(",", "','") + "' )");
            result.addAll(childMaps);
        }
        return result;
//        return dataBizService.queryAllData(tableName, queryFieldNames, whereClause);
    }


    public void addApproveInfo(TbtskObjectinfo tbtskObjectinfo,List<Map> sourceData,TskTaskBiz tskTaskBiz) {
        try {
            if(sourceData==null||sourceData.isEmpty())
            {
                return;
            }
            String shListSql =  String.format("    with \n" +
                    "    t1 as (select f_id from  %s  where f_id in ('%s')),\n" +
                    "    t2 as (SELECT f_tbid,MAX (f_approve_time ) AS f_approve_time,COUNT(f_tbid) as num FROM ( SELECT * FROM tbtsk_approve_record  where f_taskid = '%s' and f_stepindex = 0 and f_tbid in (select f_id from t1)) s1  GROUP BY f_tbid),\n" +
                    "    t3 as (SELECT f_tbid,MAX (f_approve_time ) AS f_approve_time,COUNT(f_tbid) as num FROM ( SELECT * FROM tbtsk_approve_record  where f_taskid = '%s' and f_stepindex = 1 and f_tbid in (select f_id from t1)) s1  GROUP BY f_tbid),\n" +
                    "    t4 as (SELECT s1.*,t2.num,u.f_rname  FROM tbtsk_approve_record AS s1 INNER JOIN t2 ON t2.f_tbid = s1.f_tbid AND t2.f_approve_time = s1.f_approve_time left join tbsys_user u on u.f_userid  = s1.f_approve_userid ),\n" +
                    "    t5 as (SELECT s1.*,t3.num,u.f_rname  FROM tbtsk_approve_record AS s1 INNER JOIN t3 ON t3.f_tbid = s1.f_tbid AND t3.f_approve_time = s1.f_approve_time left join tbsys_user u on u.f_userid  = s1.f_approve_userid )\n" +
                    "    select \n" +
                    "    t1.f_id,t4.f_stepname as xj_stepname,t4.f_option as xj_option,t4.f_remark as xj_remark,t4.f_approve_time as xj_approve_time,t4.num as xj_num,t4.f_rname as xj_rname,\n" +
                    "    t5.f_stepname as sj_stepname,t5.f_option as sj_option,t5.f_remark as sj_remark,t5.f_approve_time as sj_approve_time,t5.num as sj_num,t5.f_rname as sj_rname\n" +
                    "    from t1 left join t4 on t1.f_id = t4.f_tbid left join t5 on t1.f_id = t5.f_tbid",
                    tbtskObjectinfo.getfTablename(),GetDataIds(sourceData).replace(",","','"),tskTaskBiz.getId(),tskTaskBiz.getId());
            List<Map<String, Object>> shdata = jdbcTemplate.queryForList(shListSql);

            String rjListSql =  String.format(" with \n" +
                    "    t1 as (select f_id from  %s  where f_id in ('%s')),\n" +
                    "    t2 as (SELECT f_tbid,MAX (f_reject_time ) AS f_reject_time,COUNT(f_tbid) as num FROM ( SELECT * FROM tbtsk_reject_record  where f_taskid = '%s' and f_stepname = '区县审核' and f_tbid in (select f_id from t1)) s1  GROUP BY f_tbid),\n" +
                    "    t3 as (SELECT f_tbid,MAX (f_reject_time ) AS f_reject_time,COUNT(f_tbid) as num FROM ( SELECT * FROM tbtsk_reject_record  where f_taskid = '%s' and f_stepname = '市级审核' and f_tbid in (select f_id from t1)) s1  GROUP BY f_tbid),\n" +
                    "    t4 as (SELECT s1.*,t2.num,u.f_rname  FROM tbtsk_reject_record AS s1 INNER JOIN t2 ON t2.f_tbid = s1.f_tbid AND t2.f_reject_time = s1.f_reject_time left join tbsys_user u on u.f_userid = s1.f_userid ),\n" +
                    "    t5 as (SELECT s1.*,t3.num,u.f_rname  FROM tbtsk_reject_record AS s1 INNER JOIN t3 ON t3.f_tbid = s1.f_tbid AND t3.f_reject_time = s1.f_reject_time left join tbsys_user u on u.f_userid = s1.f_userid )\n" +
                    "    select * from (select \n" +
                    "    t1.f_id,t4.f_stepname as xj_stepname,0 as xj_option,t4.f_remark as xj_remark,t4.f_reject_time as xj_approve_time,t4.num as xj_num,t4.f_rname as xj_rname,\n" +
                    "    t5.f_stepname as sj_stepname,0 as sj_option,t5.f_remark as sj_remark,t5.f_reject_time as sj_approve_time,t5.num as sj_num,t5.f_rname as sj_rname\n" +
                    "    from t1 left join t4 on t1.f_id = t4.f_tbid left join t5 on t1.f_id = t5.f_tbid) t where sj_num >0 or xj_num >0",tbtskObjectinfo.getfTablename(),GetDataIds(sourceData).replace(",","','"),tskTaskBiz.getId(),tskTaskBiz.getId());
            List<Map<String, Object>> rjdata = jdbcTemplate.queryForList(rjListSql);
            Map<String, List<Map<String, Object>>> shdataMap=null;
            Map<String, List<Map<String, Object>>> rjdataMap=null;
            if(!shdata.isEmpty())
            {
                shdataMap = shdata.stream().collect(Collectors.groupingBy(t->t.get("f_id").toString()));
            }
            if(!rjdata.isEmpty())
            {
                rjdataMap = rjdata.stream().collect(Collectors.groupingBy(t->t.get("f_id").toString()));
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            for (Map map : sourceData) {
                map.put("sj_remark", "");
                map.put("sj_time", "");
                map.put("sj_option", "");
                map.put("sjnum", "");
                map.put("sj_user", "");

                map.put("xj_remark", "");
                map.put("xj_time", "");
                map.put("xj_option", "");
                map.put("xjnum", "");
                map.put("xj_user", "");
                //map.put("hasPhoto", "无");
                if (shdataMap!=null&&!shdataMap.isEmpty()) {
                    try {
                        String tbid = map.get("f_id").toString();
                        String approveTimeSj = "";
                        String approveTimeXj = "";
                        if(shdataMap.containsKey(tbid))
                        {
                            Map<String,Object>s =  shdataMap.get(tbid).get(0);
                            approveTimeSj = s.get("sj_approve_time") != null ? s.get("sj_approve_time").toString() : "";
                            approveTimeXj = s.get("xj_approve_time") != null ? s.get("xj_approve_time").toString() : "";
                            map.put("sj_remark", s.get("sj_remark") != null ? s.get("sj_remark") : "");
                            map.put("sj_time", s.get("sj_approve_time") != null ? s.get("sj_approve_time") : "");
                            map.put("sj_option", s.get("sj_option") != null ? s.get("sj_option") : "");
                            map.put("sjnum", s.get("sj_num") != null ? s.get("sj_num") : "");
                            map.put("sj_user",s.get("sj_rname")!=null?s.get("sj_rname"):"");

                            map.put("xj_remark", s.get("xj_remark") != null ? s.get("xj_remark") : "");
                            map.put("xj_time", s.get("xj_approve_time") != null ? s.get("xj_approve_time") : "");
                            map.put("xj_option", s.get("xj_option") != null ? s.get("xj_option") : "");
                            map.put("xjnum", s.get("xj_num") != null ? s.get("xj_num") : "");
                            map.put("xj_user",s.get("xj_rname")!=null?s.get("xj_rname"):"");

                        }
                        if(rjdataMap!=null&& rjdataMap.containsKey(tbid)) {
                            Map<String, Object> s = rjdataMap.get(tbid).get(0);

                            int xjNum = (s.get("xj_num") != null && StringUtils.isNotBlank(s.get("xj_num").toString()))? Integer.parseInt(s.get("xj_num").toString()) : 0;
                            int sjNum = (s.get("sj_num") != null &&StringUtils.isNotBlank(s.get("sj_num").toString()))? Integer.parseInt(s.get("sj_num").toString()) : 0;

                            int xjNum2 = (map.get("xjnum") != null && StringUtils.isNotBlank(map.get("xjnum").toString()))? Integer.parseInt(map.get("xjnum").toString()) : 0;
                            int sjNum2 = (map.get("sjnum") != null && StringUtils.isNotBlank(map.get("sjnum").toString()))? Integer.parseInt(map.get("sjnum").toString()) : 0;
                            map.put("xjnum",xjNum + xjNum2);
                            map.put("sjnum",sjNum + sjNum2);

                            String rejectTimeSj = s.get("sj_approve_time") != null ? s.get("sj_approve_time").toString() : "";
                            String rejectTimeXj = s.get("xj_approve_time") != null ? s.get("xj_approve_time").toString() : "";
                            if (StringUtils.isNotBlank(rejectTimeXj))
                            {
                                if(StringUtils.isBlank(approveTimeXj))
                                {
                                    map.put("xj_remark", s.get("xj_remark") != null ? s.get("xj_remark") : "");
                                    map.put("xj_time", s.get("xj_approve_time") != null ? s.get("xj_approve_time") : "");
                                    map.put("xj_option", 0);
                                    map.put("xjnum", s.get("xjnum") != null ? s.get("xjnum") : "");
                                    map.put("xj_user",s.get("xj_rname")!=null?s.get("xj_rname"):"");
                                }
                                else
                                {
                                    Long reject = df.parse(rejectTimeXj).getTime();
                                    Long approve = df.parse(approveTimeXj).getTime();
                                    if(reject>approve)
                                    {
                                        map.put("xj_remark", s.get("xj_remark") != null ? s.get("xj_remark") : "");
                                        map.put("xj_time", s.get("xj_approve_time") != null ? s.get("xj_approve_time") : "");
                                        map.put("xj_option", 0);
                                        map.put("xjnum", s.get("xjnum") != null ? s.get("xjnum") : "");
                                        map.put("xj_user",s.get("xj_rname")!=null?s.get("xj_rname"):"");
                                    }
                                }
                            }
                            if (StringUtils.isNotBlank(rejectTimeSj))
                            {
                                if(StringUtils.isBlank(approveTimeSj))
                                {
                                    map.put("sj_remark", s.get("sj_remark") != null ? s.get("sj_remark") : "");
                                    map.put("sj_time", s.get("sj_approve_time") != null ? s.get("sj_approve_time") : "");
                                    map.put("sj_option", 0);
                                    map.put("sjnum", s.get("sjnum") != null ? s.get("sjnum") : "");
                                    map.put("sj_user",s.get("sj_rname")!=null?s.get("sj_rname"):"");
                                }
                                else
                                {
                                    Long reject = df.parse(rejectTimeSj).getTime();
                                    Long approve = df.parse(approveTimeSj).getTime();
                                    if(reject>approve)
                                    {
                                        map.put("sj_remark", s.get("sj_remark") != null ? s.get("sj_remark") : "");
                                        map.put("sj_time", s.get("sj_approve_time") != null ? s.get("sj_approve_time") : "");
                                        map.put("sj_option", 0);
                                        map.put("sjnum", s.get("sjnum") != null ? s.get("sjnum") : "");
                                        map.put("sj_user",s.get("sj_rname")!=null?s.get("sj_rname"):"");
                                    }
                                }
                            }
                        }


                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String GetDataIds(List<Map> sourceData)
    {
        if(sourceData==null||sourceData.isEmpty())
        {
            return null;
        }
        String ids="";
        for (Map map : sourceData) {
            ids=ids+map.get("f_id")+",";
        }
        ids=ids.substring(0,ids.length()-1);
        return  ids;
    }

    public  List<TbtskFields> addApproveFields(List<TbtskFields> sourceFields) {
        List<TbtskFields> results = new ArrayList<>();
        List<String> approveFields = Arrays.asList("sj_remark", "sj_time", "sj_option", "sjnum", "sj_user", "xj_remark", "xj_time", "xj_option", "xjnum", "xj_user");
        Map<String,Object> approveFieldMap = new HashMap<>();
        approveFieldMap.put("sj_remark","市级审核意见");
        approveFieldMap.put("sj_time","市级审核时间");
        approveFieldMap.put("sj_option","审核状态");
        approveFieldMap.put("sjnum","次数");
        approveFieldMap.put("sj_user","审核员");
        approveFieldMap.put("xj_remark","审核意见");
        approveFieldMap.put("xj_time","审核时间");
        approveFieldMap.put("xj_option","审核状态");
        approveFieldMap.put("xjnum","次数");
        approveFieldMap.put("xj_user","审核员");
        boolean isExistsApproveField = false;
        if (sourceFields != null && sourceFields.size() > 0) {
            for (TbtskFields field : sourceFields) {
                if (approveFields.contains(field.getfFieldname())) {
                    isExistsApproveField = true;
                }
                results.add(field);
            }
        }

        if (!isExistsApproveField) {
            for(String s : approveFields){
                TbtskFields   newfiled = new TbtskFields();
                newfiled.setfId(UUID.randomUUID().toString());
                newfiled.setfFieldname(s);
                newfiled.setfAlias(approveFieldMap.get(s).toString());
                newfiled.setfFieldtype("varchar");
                newfiled.setfLength(64);
                newfiled.setfPrecision(0);
                newfiled.setfNullable(0);
                results.add(newfiled);
            }
        }
        return results;
    }


    /**
     * 初始化参数
     *
     * @param taskId
     * @param taskCode
     * @param taskName
     * @param prjNum
     */
    public void initParameter(String taskId, String taskCode, String taskName, String prjNum) {
        GutilAssert.notNull(taskId, "taskId can not be null");
        GutilAssert.notNull(taskCode, "taskCode can not be null");
        GutilAssert.notNull(taskName, "taskName can not be null");
        GutilAssert.notNull(downloadRecord, "downloadRecord can not be null");
        logger.info("日常任务下载 初始化下载参数 taskId:" + taskId + "  taskCode:" + taskCode + "   taskName:" + taskName + "   prjNmu:" + prjNum);
        logger.info("日常任务下载 初始化下载参数 downloadRecord:" + downloadRecord.toString());
        this.taskId = taskId;
        this.taskCode = taskCode;
        this.taskName = taskName;
        this.prjNum = prjNum;

        resultUrl = "";
    }


    @Override
    public void doDownload() throws Exception {
        logger.info(getDescription() + " 图斑数据下载开始处理...");
        TskTaskBiz tskTaskBiz = null;
        TbtskObjectinfo tbtskObjectinfo = null;
        List<TbtskFields> sourceFields = null;
        // 需要导出的字段
        List<TbtskFields> exportFields = new ArrayList<>();
        List<String> queryFieldNames = new ArrayList<String>();

        try {
            if (dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
                return;
            }
            logger.info(getDescription() + " 开始查询任务f_shape字段数据");
            tskTaskBiz = tskTaskBizService.findByTaskId(downloadParameter.getTaskId());
            if (tskTaskBiz != null && StringUtils.isNotBlank(tskTaskBiz.getTableId())) {
                tbtskObjectinfo = tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
            }
            if (tbtskObjectinfo != null && StringUtils.isNotBlank(tbtskObjectinfo.getfTablename())) {
                sourceFields = tbtskFieldsService.getAllFieldsByTables(tbtskObjectinfo.getfTablename());
            }
            if (sourceFields != null && sourceFields.size() > 0) {
                for (TbtskFields field : sourceFields) {
                    if ("f_shape1".equalsIgnoreCase(field.getfFieldname())
                            || "f_shape_b".equalsIgnoreCase(field.getfFieldname())
                            || "f_shape_g".equalsIgnoreCase(field.getfFieldname())) {
                        continue;
                    }
                    if (field.getfFieldname().equalsIgnoreCase("f_shape")) {
                        if (isQueryGeoFields()) {
                            queryFieldNames.add("d." + field.getfFieldname());
                        }
                    } else {
                        if(!field.getfFieldname().equals("f_grqm")){
                            queryFieldNames.add("d." + field.getfFieldname());
                        }
                    }
                }
                exportFields = DataDownloadFieldService.getExportFields(sourceFields);
                //过滤个人签名字段
                exportFields = exportFields.stream().filter(r->!r.getfFieldname().equals("f_grqm")).collect(Collectors.toList());
            }
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
            // 临时数据存放文件夹
            String tempFolderPath = new StringBuilder().append(uploadDir).append(File.separator).append(UuidUtil.get16UUID()).toString();
            FileUtil.creatDirectoryIfNotExist(tempFolderPath);
            String safeFileName = "";
            List<Map> sourceData = getSourceData(tbtskObjectinfo, queryFieldNames);
            if (sourceData != null) {
                if (sourceData.size() == 1) {
                    if (sourceData.get(0).get("f_tbmc")!=null && StringUtils.isNotBlank(sourceData.get(0).get("f_tbmc").toString())) {
                        safeFileName = new StringBuilder().append(tskTaskBiz.getName()).append("(").append(sourceData.get(0).get("f_tbmc").toString()).append(UuidUtil.get16UUID()).append("）").toString();
                    } else {
                        safeFileName = new StringBuilder().append(tskTaskBiz.getName()).append("(").append(UuidUtil.get16UUID()).append("）").toString();
                    }
                } else {
                    safeFileName = new StringBuilder().append(tskTaskBiz.getName()).append("(").append(sourceData.size()).append("个)").append(UuidUtil.get16UUID()).toString();
                }

                String fileNameNoSuffix = new StringBuilder().append(uploadDir).append(File.separator).append(safeFileName).toString();
                initParameter(tskTaskBiz.getId(), TASK_CODE_DAILY_TASK, tskTaskBiz.getName(), "");
                downloadRecord.setName(tskTaskBiz.getName() + "(下载" + getDataType() + ")");
                exportAction(sourceData, tempFolderPath, exportFields);
                afterExport(tempFolderPath, safeFileName, fileNameNoSuffix);
            }
        } catch (Exception e) {
            handleException(e);
        }
    }


    List<String> getPropertyKeys(List<TbtskFields> exportFields) {
        List<String> propertyKeys = new ArrayList<>();
        if (exportFields != null && exportFields.size() > 0) {
            for (TbtskFields field : exportFields) {
                if (StringUtils.isNotBlank(field.getfFieldname())) {
                    propertyKeys.add(field.getfFieldname().replace("f_", "").trim());
                }
            }
        }
        return propertyKeys;
    }

    List<Map<String, String>> getPropertyKeysWithFieldType(List<TbtskFields> exportFields) {
        List<Map<String, String>> propertyKeysMapList = new ArrayList<>();
        if (exportFields != null && exportFields.size() > 0) {
            for (TbtskFields field : exportFields) {
                if (StringUtils.isNotBlank(field.getfFieldname())) {
//                    propertyKeys.add(field.getfFieldname().replace("f_", "").trim());
                    Map<String, String> map = new HashMap<>();
                    map.put("fieldname", field.getfFieldname().replace("f_", "").trim());
                    map.put("fieldtype", field.getfFieldtype());
                    propertyKeysMapList.add(map);
                }
            }
        }
        return propertyKeysMapList;
    }


    List<String> getCluePropertyKeys(List<JcClueFields> exportFields) {
        List<String> propertyKeys = new ArrayList<>();
        if (exportFields != null && exportFields.size() > 0) {
            for (JcClueFields field : exportFields) {
                if (StringUtils.isNotBlank(field.getfFieldname())) {
                    propertyKeys.add(field.getfFieldname().replace("f_", "").trim());
                }
            }
        }
        return propertyKeys;
    }


    Map<String, Object> getPropertyMap(Map map, List<TbtskFields> exportFields) {
        Map<String, Object> resultMap = new HashMap<>();
        if (map == null) {
            return resultMap;
        }

        String userName = "";
        String createtime = "";
        resultMap.put("taskId", taskId);
        resultMap.put("taskCode", taskCode);
        resultMap.put("taskName", taskName);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp ts = null;
        DecimalFormat decimalFormat = new DecimalFormat("#.#######");

        String columnNmae = "";
        String tempValue = "";
        if (exportFields != null && exportFields.size() > 0) {
            for (TbtskFields field : exportFields) {
                if (StringUtils.isBlank(field.getfFieldtype())) {
                    continue;
                }
                if ("taskId".equalsIgnoreCase(field.getfFieldname())
                        || "taskCode".equalsIgnoreCase(field.getfFieldname())
                        || "taskName".equalsIgnoreCase(field.getfFieldname())
                        || "f_shape".equalsIgnoreCase(field.getfFieldname())) {
                    continue;
                }
                if("sj_remark".equalsIgnoreCase(field.getfFieldname())
                        || "sj_time".equalsIgnoreCase(field.getfFieldname())
                        || "sj_option".equalsIgnoreCase(field.getfFieldname())
                        || "sjnum".equalsIgnoreCase(field.getfFieldname())
                        || "sj_user".equalsIgnoreCase(field.getfFieldname())
                        || "xj_remark".equalsIgnoreCase(field.getfFieldname())
                        || "xj_time".equalsIgnoreCase(field.getfFieldname())
                        || "xj_option".equalsIgnoreCase(field.getfFieldname())
                        || "xjnum".equalsIgnoreCase(field.getfFieldname())
                        || "xj_user".equalsIgnoreCase(field.getfFieldname())){
                    columnNmae = field.getfFieldname();
                }else{
                    columnNmae = "f_" + field.getfFieldname();
                }
                if ("f_userid".equalsIgnoreCase(columnNmae)) {
                    if (map.containsKey("f_userid") && map.get("f_userid") != null) {
                        // 将用户id转换成用户真实姓名
                        userName = userNameService.getUserRealNameByUserId(map.get("f_userid").toString());
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), userName);
                    }
                } else if ("f_createtime".equalsIgnoreCase(columnNmae) || "f_committime".equalsIgnoreCase(columnNmae)) {
                    try {
                        if (map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                            ts = new Timestamp(Long.valueOf(map.get(columnNmae).toString()));
                            createtime = format.format(ts);
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), createtime);
                        }
                    } catch (Exception e) {
                        if (map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), map.get(columnNmae).toString());
                        }
                    }
                } else if ("f_lon".equalsIgnoreCase(columnNmae) || "f_lat".equalsIgnoreCase(columnNmae)) {
                    try {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), decimalFormat.format(Double.parseDouble(map.get(columnNmae).toString())));
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_sfydjzl".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        if ("1".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "有");
                        } else if ("2".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "无");
                        } else {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), tempValue);
                        }
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_bz".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    // 翻译标注
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        String translatedValue = "";
                        switch (tempValue) {
                            case "1":
                                translatedValue = "已登记，影像无房";
                                break;
                            case "2":
                                translatedValue = "已登记，登记附图需矢量化";
                                break;
                            case "3":
                                translatedValue = "已登记，登记附图有矢量图形";
                                break;
                            case "4":
                                translatedValue = "已登记，登记附图需矢量化，现已扩建";
                                break;
                            case "5":
                                translatedValue = "已登记，登记附图有矢量图形，现已扩建";
                                break;
                            case "6":
                                translatedValue = "已登记，登记附图需矢量化，现状无房屋";
                                break;
                            case "7":
                                translatedValue = "已登记，登记附图有矢量图形，现状无房屋";
                                break;
                            case "8":
                                translatedValue = "已登记，现状图形与登记面积一致";
                                break;
                            case "9":
                                translatedValue = "已登记，现状图形与登记面积不一致";
                                break;
                            case "10":
                                translatedValue = "未登记，现状图形";
                                break;
                            case "11":
                                translatedValue = "其他";
                                break;
                            default:
                                translatedValue = tempValue;
                                break;
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_tdyt".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    // 翻译土地用途
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        String translatedValue = "";
                        switch (tempValue) {
                            case "1":
                                translatedValue = "农村宅基地";
                                break;
                            case "2":
                                translatedValue = "公共设施农用地";
                                break;
                            case "3":
                                translatedValue = "医卫慈善用地";
                                break;
                            case "4":
                                translatedValue = "科教用地";
                                break;
                            case "5":
                                translatedValue = "其他";
                                break;
                            default:
                                translatedValue = tempValue;
                                break;
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_qlrlx".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    // 翻译权利人类型
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        String translatedValue = "";
                        switch (tempValue) {
                            case "1":
                                translatedValue = "个人";
                                break;
                            case "2":
                                translatedValue = "单位";
                                break;
                            default:
                                translatedValue = tempValue;
                                break;
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_ismycreate".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        if ("1".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "是");
                        } else if ("0".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "否");
                        } else {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), tempValue);
                        }
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_qlrqm".equalsIgnoreCase(columnNmae)
                        || "f_dcrqm".equalsIgnoreCase(columnNmae)
                        || "f_sign".equalsIgnoreCase(columnNmae)
                        || "f_requestid".equalsIgnoreCase(columnNmae)) {
                    try {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), "");
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else {
                    if (map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), map.get(columnNmae));
                    } else {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), "");
                    }
                }
            }
        }
        return resultMap;
    }



//    Map<String, Object> getCluePropertyMap(Map map, List<JcClueFields> exportFields) {
//        Map<String, Object> resultMap = new HashMap<>();
//        if (map == null) {
//            return resultMap;
//        }
//
//        String userName = "";
//        String createtime = "";
//        resultMap.put("taskId", taskId);
//        resultMap.put("taskCode", taskCode);
//        resultMap.put("taskName", taskName);
//        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//        Timestamp ts = null;
//        DecimalFormat decimalFormat = new DecimalFormat("#.#######");
//
//        String columnNmae = "";
//        String tempValue = "";
//        if (exportFields != null && exportFields.size() > 0) {
//            for (JcClueFields field : exportFields) {
//                if (StringUtils.isBlank(field.getfFieldtype())) {
//                    continue;
//                }
//                if ("taskId".equalsIgnoreCase(field.getfFieldname())
//                        || "taskCode".equalsIgnoreCase(field.getfFieldname())
//                        || "taskName".equalsIgnoreCase(field.getfFieldname())
//                        || "f_shape".equalsIgnoreCase(field.getfFieldname())) {
//                    continue;
//                }
//                columnNmae = "f_" + field.getfFieldname();
//
//                if ("f_userid".equalsIgnoreCase(columnNmae)) {
//                    if (map.containsKey("f_userid") && map.get("f_userid") != null) {
//                        // 将用户id转换成用户真实姓名
//                        userName = userNameService.getUserRealNameByUserId(map.get("f_userid").toString());
//                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), userName);
//                    }
//                } else if ("f_createtime".equalsIgnoreCase(columnNmae)
//                        || "f_committime".equalsIgnoreCase(columnNmae)) {
//                    try {
//                        if (map.containsKey(columnNmae) && map.get(columnNmae) != null) {
//                            ts = new Timestamp(Long.valueOf(map.get(columnNmae).toString()));
//                            createtime = format.format(ts);
//                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), createtime);
//                        }
//                    } catch (Exception e) {
//                        if (map.containsKey(columnNmae) && map.get(columnNmae) != null) {
//                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), map.get(columnNmae).toString());
//                        }
//                    }
//                } else if ("f_lon".equalsIgnoreCase(columnNmae)
//                        || "f_lat".equalsIgnoreCase(columnNmae)) {
//                    try {
//                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), decimalFormat.format(Double.parseDouble(map.get(columnNmae).toString())));
//                    } catch (Exception e) {
//                        logger.error(e.getMessage());
//                    }
//                } else if ("f_sfydjzl".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
//                    try {
//                        tempValue = map.get(columnNmae).toString().trim();
//                        if ("1".equalsIgnoreCase(tempValue)) {
//                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "有");
//                        } else if ("2".equalsIgnoreCase(tempValue)) {
//                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "无");
//                        } else {
//                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), tempValue);
//                        }
//                    } catch (Exception e) {
//                        logger.error(e.getMessage());
//                    }
//                } else if ("f_bz".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
//                    // 翻译标注
//                    try {
//                        tempValue = map.get(columnNmae).toString().trim();
//                        String translatedValue = "";
//                        switch (tempValue) {
//                            case "1":
//                                translatedValue = "已登记，影像无房";
//                                break;
//                            case "2":
//                                translatedValue = "已登记，登记附图需矢量化";
//                                break;
//                            case "3":
//                                translatedValue = "已登记，登记附图有矢量图形";
//                                break;
//                            case "4":
//                                translatedValue = "已登记，登记附图需矢量化，现已扩建";
//                                break;
//                            case "5":
//                                translatedValue = "已登记，登记附图有矢量图形，现已扩建";
//                                break;
//                            case "6":
//                                translatedValue = "已登记，登记附图需矢量化，现状无房屋";
//                                break;
//                            case "7":
//                                translatedValue = "已登记，登记附图有矢量图形，现状无房屋";
//                                break;
//                            case "8":
//                                translatedValue = "已登记，现状图形与登记面积一致";
//                                break;
//                            case "9":
//                                translatedValue = "已登记，现状图形与登记面积不一致";
//                                break;
//                            case "10":
//                                translatedValue = "未登记，现状图形";
//                                break;
//                            case "11":
//                                translatedValue = "其他";
//                                break;
//                            default:
//                                translatedValue = tempValue;
//                                break;
//                        }
//                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
//                    } catch (Exception e) {
//                        logger.error(e.getMessage());
//                    }
//                } else if ("f_tdyt".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
//                    // 翻译土地用途
//                    try {
//                        tempValue = map.get(columnNmae).toString().trim();
//                        String translatedValue = "";
//                        switch (tempValue) {
//                            case "1":
//                                translatedValue = "农村宅基地";
//                                break;
//                            case "2":
//                                translatedValue = "公共设施农用地";
//                                break;
//                            case "3":
//                                translatedValue = "医卫慈善用地";
//                                break;
//                            case "4":
//                                translatedValue = "科教用地";
//                                break;
//                            case "5":
//                                translatedValue = "其他";
//                                break;
//                            default:
//                                translatedValue = tempValue;
//                                break;
//                        }
//                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
//                    } catch (Exception e) {
//                        logger.error(e.getMessage());
//                    }
//                } else if ("f_qlrlx".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
//                    // 翻译权利人类型
//                    try {
//                        tempValue = map.get(columnNmae).toString().trim();
//                        String translatedValue = "";
//                        switch (tempValue) {
//                            case "1":
//                                translatedValue = "个人";
//                                break;
//                            case "2":
//                                translatedValue = "单位";
//                                break;
//                            default:
//                                translatedValue = tempValue;
//                                break;
//                        }
//                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
//                    } catch (Exception e) {
//                        logger.error(e.getMessage());
//                    }
//                } else if ("f_ismycreate".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
//                    try {
//                        tempValue = map.get(columnNmae).toString().trim();
//                        if ("1".equalsIgnoreCase(tempValue)) {
//                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "是");
//                        } else if ("0".equalsIgnoreCase(tempValue)) {
//                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "否");
//                        } else {
//                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), tempValue);
//                        }
//                    } catch (Exception e) {
//                        logger.error(e.getMessage());
//                    }
//                } else if ("f_qlrqm".equalsIgnoreCase(columnNmae)
//                        || "f_dcrqm".equalsIgnoreCase(columnNmae)
//                        || "f_sign".equalsIgnoreCase(columnNmae)
//                        || "f_requestid".equalsIgnoreCase(columnNmae)) {
//                    try {
//                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), "");
//                    } catch (Exception e) {
//                        logger.error(e.getMessage());
//                    }
//                } else {
//                    if (map.containsKey(columnNmae) && map.get(columnNmae) != null) {
//                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), map.get(columnNmae));
//                    } else {
//                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), "");
//                    }
//                }
//            }
//        }
//        return resultMap;
//    }

    /**
     * 获取导出目标文件的名称
     *
     * @param sourceData
     * @param folderPath
     * @return
     */
    String getExportFileName(List<Map> sourceData, String folderPath) {
        if (sourceData == null || sourceData.size() == 0 || StringUtils.isBlank(folderPath)) {
            return "";
        }
        FileUtil.creatDirectoryIfNotExist(folderPath);

        String fileName = "";
        if (sourceData.size() == 1) {
            Map map = sourceData.get(0);
            if (map != null) {
                if (map.containsKey("f_tbmc") && map.get("f_tbmc")!=null && StringUtils.isNotBlank(map.get("f_tbmc").toString())) {
                    fileName = map.get("f_tbmc").toString();
                } else if (map.containsKey("f_tbbh") && map.get("f_tbmc")!=null && StringUtils.isNotBlank(map.get("f_tbbh").toString())) {
                    fileName = map.get("f_tbbh").toString();
                } else if (map.containsKey("f_id") && StringUtils.isNotBlank(map.get("f_id").toString())) {
                    fileName = map.get("f_id").toString();
                }
            }
        } else {
            fileName = sourceData.size() + "个";
        }

        String targetFileName = new StringBuilder()
                .append(folderPath)
                .append(File.separator)
                .append(taskName)
                .append("(")
                .append(fileName)
                .append(")")
                .append(getFileExtension())
                .toString();
        File file = new File(targetFileName);
        if (!file.exists()) {
//            try {
//                file.createNewFile();
//            } catch (IOException e) {
//                e.printStackTrace();
//            }
        }
        return targetFileName;
    }

    @Override
    protected String getObsFolderPath() {
        return "dailyTask/download" + "/" + getDataType();
    }

    abstract void exportAction(List<Map> sourceData, String tempSavePath, List<TbtskFields> exportFields) throws Exception;

    String getName(Map map) {
        if (map == null) {
            return "";
        }
        String result = "";
        if (map.containsKey("f_tbmc") &&map.get("f_tbmc")!=null&& StringUtils.isNotBlank(map.get("f_tbmc").toString())) {
            result = map.get("f_tbmc").toString();
        } else if (map.containsKey("f_tbbh")&&map.get("f_tbbh")!=null && StringUtils.isNotBlank(map.get("f_tbbh").toString())) {
            result = map.get("f_tbbh").toString();
        } else if (map.containsKey("f_id") &&map.get("f_id")!=null&& StringUtils.isNotBlank(map.get("f_id").toString())) {
            result = map.get("f_id").toString();
        }
        return result;
    }



    public static List<JcClueFields> getExportClueFields(List<JcClueFields> sourceFields) {
        List<JcClueFields> results = new ArrayList<>();
        boolean isExistsTaskId = false;
        boolean isExistsTaskCode = false;
        boolean isExistsTaskName = false;
        JcClueFields newfiled = null;
        if (sourceFields != null && sourceFields.size() > 0) {
            for (JcClueFields field : sourceFields) {
                boolean canExport = false;
                boolean isSystemField = isSystemField(field.getfFieldname());
                if (isSystemField) {
                    canExport = true;
                } else {
                    // 字段是否导出 逻辑运算 所有内业字段及所有外业字段
                    boolean isOuterField = field.getfFieldInnerOuterSys() == 1
                            || field.getfFieldInnerOuterSys() == 2
                            || field.getfFieldInnerOuterSys() == 3
                            || field.getfFieldInnerOuterSys() == 6;
                    canExport = isOuterField == true;
                }
                if (canExport) {
                    if ("taskid".equalsIgnoreCase(field.getfFieldname())) {
                        isExistsTaskId = true;
                    }
                    if ("taskCode".equalsIgnoreCase(field.getfFieldname())) {
                        isExistsTaskCode = true;
                    }
                    if ("taskName".equalsIgnoreCase(field.getfFieldname())) {
                        isExistsTaskName = true;
                    }
                    newfiled = new JcClueFields();
                    BeanUtil.copyProperties(field, newfiled, false);

                    if ("f_sign".equalsIgnoreCase(field.getfFieldname())
                            || "f_qlrqm".equalsIgnoreCase(field.getfFieldname())
                            || "f_dcrqm".equalsIgnoreCase(field.getfFieldname())) {
                        newfiled.setfFieldtype("blob");
                    }

                    // 去掉字段的前缀"f_"
                    if (com.geoway.landteam.landcloud.common.util.base.StringUtils.isNotBlank(newfiled.getfFieldname()) && newfiled.getfFieldname().startsWith("f_")) {
                        newfiled.setfFieldname(newfiled.getfFieldname().replace("f_", "").trim());
                    }

                    results.add(newfiled);
                }

            }
        }
        if (!isExistsTaskId) {
            newfiled = new JcClueFields();
            newfiled.setfId(UUID.randomUUID().toString());
            newfiled.setfFieldname("taskId");
            newfiled.setfAlias("线索id");
            newfiled.setfFieldtype("varchar");
            newfiled.setfLength(36);
            newfiled.setfPrecision(0);
            newfiled.setfNullable(0);
            results.add(newfiled);
        }
        if (!isExistsTaskCode) {
            newfiled = new JcClueFields();
            newfiled.setfId(UUID.randomUUID().toString());
            newfiled.setfFieldname("taskCode");
            newfiled.setfAlias("线索类型");
            newfiled.setfFieldtype("varchar");
            newfiled.setfLength(255);
            newfiled.setfPrecision(0);
            newfiled.setfNullable(0);
            results.add(newfiled);
        }
        if (!isExistsTaskName) {
            newfiled = new JcClueFields();
            newfiled.setfId(UUID.randomUUID().toString());
            newfiled.setfFieldname("taskName");
            newfiled.setfAlias("线索名称");
            newfiled.setfFieldtype("varchar");
            newfiled.setfLength(255);
            newfiled.setfPrecision(0);
            newfiled.setfNullable(0);
            results.add(newfiled);
        }
        return results;
    }


    /**
     * 是否是需要导出的系统字段
     *
     * @param fieldName
     * @return
     */
    private static boolean isSystemField(String fieldName) {
        boolean isNeedExport = false;
        if (com.geoway.landteam.landcloud.common.util.base.StringUtils.isNotBlank(fieldName) && SystemFiledList.contains(fieldName.toLowerCase())) {
            isNeedExport = true;
        }
        return isNeedExport;
    }


    abstract boolean isQueryGeoFields();
}
