package com.geoway.landteam.landcloud.service.customtask.pub.impl;


import com.geoway.landteam.customtask.task.entity.TbtskFields;

import com.geoway.landteam.landcloud.common.util.geometry.KmlUtil;
import com.geoway.landteam.landcloud.common.util.geometry.ShapeUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFields;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Author: zkn
 * @Date: 2020/3/27 14:40
 * @Description: 下载日常任务kml格式数据服务实现
 */
@Service
public class MDownloadGeometryDailyTaskKmlServiceImpl extends MDownloadGeometryDailyTaskBaseService {
    private final GiLoger logger = GwLoger.getLoger(MDownloadGeometryDailyTaskKmlServiceImpl.class);

    /**
     * 导出geometry
     *
     * @throws Exception
     */
    @Override
    void exportAction(List<Map> sourceData, String tempSavePath, List<TbtskFields> exportFields) throws Exception {
        if (sourceData != null) {
            logger.info(getDescription() + " 导出数据---图斑总个数：" + sourceData.size());
            int index = 0;
            List<String> attrKeys = getPropertyKeys(exportFields);
            List<Map<String, Object>> geometryList = new ArrayList<>();
            String targetFileName = getExportFileName(sourceData, tempSavePath);
            for (Map map : sourceData) {
                if (dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
                    return;
                }
                index++;

                if (map.containsKey("f_shape") && map.get("f_shape") != null && StringUtils.isNotBlank(map.get("f_shape").toString())) {
                    Geometry geometry = null;
                    logger.info(getDescription() + " 正在构建" + index + "个图斑的geometry数据及属性信息 图斑id：" + map.get("f_id").toString());
                    try {
                        geometry = WKTUtil.wktToGeom(map.get("f_shape").toString().replace("SRID=4490;",""));
                    } catch (ParseException e) {
                        logger.info("日常任务下载 第" + index + "个图斑的的shape转换成Geometry出现异常 图斑id：" + map.get("f_id").toString());
                        logger.error(e);
                    }
                    if (geometry != null) {
                        Map<String, Object> propertyMap = super.getPropertyMap(map, exportFields);
                        if (propertyMap != null && propertyMap.containsKey("shape")) {
                            propertyMap.remove("shape");
                        }

                        if (propertyMap != null) {
                            propertyMap.put(geoKey, geometry);
                            geometryList.add(propertyMap);
                        }
                    } else {
                        String name = getName(map);
                        errorInfo.add("图斑 [" + name + "] 的图形数据为空，跳过下载该图斑的图形数据及属性信息\r\n");
                        logger.info(getDescription() + " 第" + index + "个图斑的geometry转换成Geometry为空 图斑id：" + map.get("f_id").toString());
                    }
                } else {
                    String name = getName(map);
                    errorInfo.add("图斑 [" + name + "] 的图形数据为空，跳过下载该图斑的图形数据及属性信息\r\n");
                    logger.info(getDescription() + " 第" + index + "个图斑的f_shape为空 图斑id：" + map.get("f_id").toString());
                }
            }
            try {
                if (attrKeys != null) {
                    for (String key : attrKeys) {
                        if ("shape".equalsIgnoreCase(key)) {
                            attrKeys.remove(key);
                            break;
                        }
                    }
                }
                logger.info(getDescription() + " 导出数据---开始生成KML文件");
                KmlUtil.write2Wml(targetFileName, geoKey, attrKeys, geometryList);
            } catch (Exception e) {
                logger.info(getDescription() + " 导出geometry到kml文件异常 ");
                logger.error(e);
                throw e;
            } finally {
                if (attrKeys != null) {
                    attrKeys = null;
                }
                if (geometryList != null) {
                    geometryList = null;
                }
            }
        } else {
            logger.info(getDescription() + " 导出数据---导出数据 图斑总个数：0");
        }
    }

    @Override
    protected String getDataType() {
        return "kml";
    }

    @Override
    protected String getFileExtension() {
        return ".kml";
    }

    @Override
    protected String getDescription() {
        return "日常任务下载【KML】";
    }

    @Override
    boolean isQueryGeoFields() {
        return true;
    }
}
