package com.geoway.landteam.landcloud.service.customtask.pub.impl;


import com.geoway.landteam.customtask.enm.DownloadTypeEnum;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.task.entity.TbtskFields;

import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.util.ExcelUtil;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.geometry.ShapeUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKBUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFields;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportRecord;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueFieldsService;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRecordService;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueSourceService;
import com.geoway.landteam.patrolclue.service.pub.impl.DataDownloadFieldService;
import com.geoway.landteam.patrolclue.service.util.UuidUtil;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.io.WKBReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author: zkn
 * @Date: 2020/3/27 11:26
 * @Description: 下载日常任务shape格式数据服务实现
 */
@Service
public class MDownloadGeometryDailyTaskShapeServiceImpl extends MDownloadGeometryDailyTaskBaseService {
    private final GiLoger logger = GwLoger.getLoger(MDownloadGeometryDailyTaskShapeServiceImpl.class);


    @Autowired
    DataBizMapper dataBizMapper;
    @Autowired
    JcClueImportRecordService jcClueImportRecordService;
    private static final String TASK_CODE_DAILY_TASK = "日常任务";


    @Override
    public void doDownload() throws Exception {
        if(DownloadTypeEnum.线索.getCode().equals(downloadParameter.getType())) {
            dealClueDownload(downloadParameter);
        } else {
            logger.info(getDescription() + " 图斑数据下载开始处理...");
            TskTaskBiz tskTaskBiz = null;
            TbtskObjectinfo tbtskObjectinfo = null;
            List<TbtskFields> sourceFields = null;
            // 需要导出的字段
            List<TbtskFields> exportFields = new ArrayList<>();
            List<String> queryFieldNames = new ArrayList<String>();

            try {
                if (dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
                    return;
                }
                logger.info(getDescription() + " 开始查询任务f_shape字段数据");
                tskTaskBiz = tskTaskBizService.findByTaskId(downloadParameter.getTaskId());
                if (tskTaskBiz != null && StringUtils.isNotBlank(tskTaskBiz.getTableId())) {
                    tbtskObjectinfo = tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
                }
                if (tbtskObjectinfo != null && StringUtils.isNotBlank(tbtskObjectinfo.getfTablename())) {
                    sourceFields = tbtskFieldsService.getAllFieldsByTables(tbtskObjectinfo.getfTablename());
                    //如果字段数量过多则只导出f_id
                    if(sourceFields.size()>120 && sourceFields.stream().map(r->r.getfFieldname()).collect(Collectors.toList()).contains("f_id")){
                        sourceFields = sourceFields.stream().filter(r->(r.getfFieldname().equals("f_id") || r.getfFieldname().equals("f_shape") || r.getfFieldname().equals("f_issplitted") || r.getfFieldname().equals("f_dkbh"))).collect(Collectors.toList());
                    }
                }
                if (sourceFields != null && sourceFields.size() > 0) {
                    for (TbtskFields field : sourceFields) {
                        if ("f_shape1".equalsIgnoreCase(field.getfFieldname())
                                || "f_shape_b".equalsIgnoreCase(field.getfFieldname())
                                || "f_shape_g".equalsIgnoreCase(field.getfFieldname())) {
                            continue;
                        }
                        if (field.getfFieldname().equalsIgnoreCase("f_shape")) {
                            if (isQueryGeoFields()) {
                                queryFieldNames.add("d." + field.getfFieldname());
                            }
                        } else {
                            queryFieldNames.add("d." + field.getfFieldname());
                        }
                    }
                    exportFields = com.geoway.landteam.customtask.service.pub.DataDownloadFieldService.getExportFields(sourceFields);
                }
                uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
                // 临时数据存放文件夹
                String tempFolderPath = new StringBuilder().append(uploadDir).append(File.separator).append(com.geoway.landteam.customtask.service.util.UuidUtil.get16UUID()).toString();
                FileUtil.creatDirectoryIfNotExist(tempFolderPath);
                String safeFileName = "";
                List<Map> sourceData = getSourceData(tbtskObjectinfo, queryFieldNames);
                if (sourceData != null) {
                    if (sourceData.size() == 1) {
                        if (sourceData.get(0).get("f_tbmc")!=null && StringUtils.isNotBlank(sourceData.get(0).get("f_tbmc").toString())) {
                            safeFileName = new StringBuilder().append(tskTaskBiz.getName()).append("(").append(sourceData.get(0).get("f_tbmc").toString()).append(com.geoway.landteam.customtask.service.util.UuidUtil.get16UUID()).append("）").toString();
                        } else {
                            safeFileName = new StringBuilder().append(tskTaskBiz.getName()).append("(").append(com.geoway.landteam.customtask.service.util.UuidUtil.get16UUID()).append("）").toString();
                        }
                    } else {
                        safeFileName = new StringBuilder().append(tskTaskBiz.getName()).append("(").append(sourceData.size()).append("个)").append(com.geoway.landteam.customtask.service.util.UuidUtil.get16UUID()).toString();
                    }
                    //增加审核相关字段
                    exportFields = addApproveFields(exportFields);
                    //增加审核记录
                    addApproveInfo(tbtskObjectinfo,sourceData,tskTaskBiz);
                    //导出数据
                    String fileNameNoSuffix = new StringBuilder().append(uploadDir).append(File.separator).append(safeFileName).toString();
                    initParameter(tskTaskBiz.getId(), TASK_CODE_DAILY_TASK, tskTaskBiz.getName(), "");
                    downloadRecord.setName(tskTaskBiz.getName() + "(下载" + getDataType() + ")");
                    exportAction(sourceData, tempFolderPath, exportFields);
                    afterExport(tempFolderPath, safeFileName, fileNameNoSuffix);
                }
            } catch (Exception e) {
                handleException(e);
            }
        }

    }

    protected void dealClueDownload(DownloadParameter downloadParameter) throws Exception {
        try {
            downloadRecord.setType(DownloadTypeEnum.线索.getCode());
            logger.info(getDescription() + " 图斑数据下载开始处理...");
            List<JcClueFields> sourceFields = null;
            // 需要导出的字段
            List<JcClueFields> exportFields = new ArrayList<>();
            List<String> queryFieldNames = new ArrayList<String>();
            if (dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
                return;
            }
            logger.info(getDescription() + " 开始查询任务f_shape字段数据");
            JcClueSource jcClueSource = null;
            sourceFields = null;
            JcClueImportRecord jcClueImportRecord = null;

            jcClueImportRecord = jcClueImportRecordService.selectByPrimaryKey(downloadParameter.getTaskId());
            if (jcClueImportRecord != null && com.geoway.landteam.landcloud.common.util.base.StringUtils.isNotBlank(jcClueImportRecord.getfSourceid())) {
                jcClueSource = jcClueSourceService.findOne(jcClueImportRecord.getfSourceid());
            }
            if (jcClueSource != null && com.geoway.landteam.landcloud.common.util.base.StringUtils.isNotBlank(jcClueSource.getfTablename())) {
                sourceFields = jcClueFieldsService.findByTableId(jcClueSource.getfId());
            }

            if (sourceFields != null && sourceFields.size() > 0) {
                for (JcClueFields field : sourceFields) {
                    if ("f_shape1".equalsIgnoreCase(field.getfFieldname())
                            || "f_shape_b".equalsIgnoreCase(field.getfFieldname())
                            || "f_shape_g".equalsIgnoreCase(field.getfFieldname())) {
                        continue;
                    }
                    if (field.getfFieldname().equalsIgnoreCase("f_shape")) {
                        if (isQueryGeoFields()) {
                            queryFieldNames.add("d." + field.getfFieldname());
                        }
                    } else {
                        queryFieldNames.add("d." + field.getfFieldname());
                    }
                }
                exportFields = DataDownloadFieldService.getExportFields(sourceFields);
            }
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
            // 临时数据存放文件夹
            String tempFolderPath = new StringBuilder().append(uploadDir).append(File.separator).append(UuidUtil.get16UUID()).toString();
            FileUtil.creatDirectoryIfNotExist(tempFolderPath);
            String safeFileName = "";
            List<Map> sourceData = getSourceData(jcClueSource, queryFieldNames);
            if (sourceData != null) {
                if (sourceData.size() == 1) {
                    if (sourceData.get(0).get("f_tbmc") != null && com.geoway.landteam.landcloud.common.util.base.StringUtils.isNotBlank(sourceData.get(0).get("f_tbmc").toString())) {
                        safeFileName = new StringBuilder().append(jcClueImportRecord.getfName()).append("(").append(sourceData.get(0).get("f_tbmc").toString()).append(UuidUtil.get16UUID()).append("）").toString();
                    } else {
                        safeFileName = new StringBuilder().append(jcClueImportRecord.getfName()).append("(").append(UuidUtil.get16UUID()).append("）").toString();
                    }
                } else {
                    safeFileName = new StringBuilder().append(jcClueImportRecord.getfName()).append("(").append(sourceData.size()).append("个)").append(UuidUtil.get16UUID()).toString();
                }

                String fileNameNoSuffix = new StringBuilder().append(uploadDir).append(File.separator).append(safeFileName).toString();
                initParameter(jcClueImportRecord.getfId(), "线索批次", jcClueImportRecord.getfName(), "");
                downloadRecord.setName(jcClueImportRecord.getfName() + "(下载" + getDataType() + ")");
                exportClueAction(sourceData, tempFolderPath, exportFields);
                afterExport(tempFolderPath, safeFileName, fileNameNoSuffix);
            }
        } catch (Exception e) {
            handleException(e);
        }
    }

    List<Map> getSourceData(JcClueSource jcClueSource, List<String> queryFieldNames) {
        if (dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
            return null;
        }
        String whereClause = "";
        String tableName = "";
        if (com.geoway.landteam.landcloud.common.util.base.StringUtils.isNotBlank(downloadParameter.getTbIds())) {
            whereClause += "d.f_id in ( '" + downloadParameter.getTbIds().replace(",", "','") + "' )";
        }
        tableName = jcClueSource.getfTablename() + " d ";

        return this.queryAllData(tableName, queryFieldNames, whereClause);
    }

    /**
     * 根据表名称查询所有字段
     *
     * @param tableName 表名称
     * @return
     */
    public List<Map> queryAllData(String tableName, List<String> fieldNameList, String where) {
        List<Map> list = dataBizMapper.queryAllData(tableName, fieldNameList, where);
        return list;
    }

    @Override
    void exportAction(List<Map> sourceData, String tempSavePath, List<TbtskFields> exportFields) throws Exception {
        if (sourceData != null) {
            logger.info(getDescription() + " 导出数据---图斑总个数：" + sourceData.size());
            int index = 0;
            String targetFileName = getExportFileName(sourceData, tempSavePath);
//            List<String> attrKeys = getPropertyKeys(exportFields);
            List<Map<String, String>> propertyKeysMapList = getPropertyKeysWithFieldType(exportFields);
            List<Map<String, String>> propertyKeysParams = new ArrayList<>();
            List<Map<String, Object>> geometryList = new ArrayList<>();
            Map<String, Object> propertyMap = null;
            String geometryType = "";
            Geometry geometry = null;
            String name = "";
            for (Map map : sourceData) {
                if (dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
                    return;
                }
                index++;
                if (map.containsKey("f_shape") && map.get("f_shape") != null && StringUtils.isNotBlank("f_shape")) {
                    geometry = null;
                    logger.info(getDescription() + " 正在构建" + index + "个图斑的geometry数据及属性信息 图斑id：" + map.get("f_id").toString());

                    try {
                        Geometry geometry1 = WKBUtil.wkbToGeom(map.get("f_shape").toString());
                        geometry = WKTUtil.wktToGeom(geometry1.toText().replace("SRID=4490;",""));
                    } catch (ParseException e) {
                        logger.info(getDescription() + " 第" + index + "个图斑的的geometry转换成Geometry出现异常 图斑id：" + map.get("f_id").toString());
                        logger.error(e);
                    }
                    if (geometry != null) {
                        if (index == 1 || StringUtils.isBlank(geometryType)) {
                            geometryType = geometry.getGeometryType();
                        }
                        propertyMap = super.getPropertyMap(map, exportFields);

                        if (propertyMap != null && propertyMap.containsKey("shape")) {
                            propertyMap.remove("shape");
                        }

                        if (propertyMap != null) {
                            propertyMap.put(geoKey, geometry);
                            geometryList.add(propertyMap);
                        }
                    } else {
                        name = getName(map);
                        errorInfo.add("图斑 [" + name + "] 的图形数据为空，跳过下载该图斑的图形数据及属性信息\r\n");
                        logger.info(getDescription() + " 第" + index + "个图斑的的geometry转换成Geometry为空 图斑id：" + map.get("f_id").toString());
                    }
                } else {
                    name = getName(map);
                    errorInfo.add("图斑 [" + name + "] 的图形数据为空，跳过下载该图斑的图形数据及属性信息\r\n");
                    logger.info(getDescription() + " 第" + index + "个图斑的f_shape为空 图斑id：" + map.get("f_id").toString());
                }
            }
            try {
//                if (attrKeys != null) {
//                    for (String key : attrKeys) {
//                        if ("shape".equalsIgnoreCase(key)) {
//                            attrKeys.remove(key);
//                            break;
//                        }
//                    }
//                }
                if(propertyKeysMapList != null && propertyKeysMapList.size() > 0) {
                    for (Map<String, String> map : propertyKeysMapList) {
                        if(map.get("fieldname").contains("shape")) {
//                            propertyKeysMapList.remove(map);
                        } else {
                            propertyKeysParams.add(map);
                        }
                    }
                }

                ShapeUtil.write2ShapeWithFieldType(targetFileName, "GB2312", geometryType, geoKey, propertyKeysParams, geometryList);
            } catch (Exception e) {
                logger.info(getDescription() + " 导出geometry到shape文件异常 ");
                logger.error(e);
                throw e;
            } finally {
//                if (attrKeys != null) {
//                    attrKeys = null;
//                }
                if (propertyKeysMapList != null) {
                    propertyKeysMapList = null;
                }
                if (propertyKeysParams != null) {
                    propertyKeysParams = null;
                }
                if (propertyMap != null) {
                    propertyMap = null;
                }
                if (geometryList != null) {
                    geometryList = null;
                }
            }
        } else {
            logger.info(getDescription() + " 导出数据---图斑总个数：0");
        }
    }



    void exportClueAction(List<Map> sourceData, String tempSavePath, List<JcClueFields> exportFields) throws Exception {
        if (sourceData != null) {
            logger.info(getDescription() + " 导出数据---图斑总个数：" + sourceData.size());
            int index = 0;
            String targetFileName = getExportFileName(sourceData, tempSavePath);
            List<String> attrKeys = getCluePropertyKeys(exportFields);
            List<Map<String, Object>> geometryList = new ArrayList<>();
            Map<String, Object> propertyMap = null;
            String geometryType = "";
            Geometry geometry = null;
            String name = "";
            for (Map map : sourceData) {
                if (dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
                    return;
                }
                index++;
                if (map.containsKey("f_shape") && map.get("f_shape") != null && StringUtils.isNotBlank("f_shape")) {
                    geometry = null;
                    logger.info(getDescription() + " 正在构建" + index + "个图斑的geometry数据及属性信息 图斑id：" + map.get("f_id").toString());

                    try {
                        geometry = WKTUtil.wktToGeom(map.get("f_shape").toString().replace("SRID=4490;",""));
                    } catch (ParseException e) {
                        logger.info(getDescription() + " 第" + index + "个图斑的的geometry转换成Geometry出现异常 图斑id：" + map.get("f_id").toString());
                        logger.error(e);
                    }
                    if (geometry != null) {
                        if (index == 1 || StringUtils.isBlank(geometryType)) {
                            geometryType = geometry.getGeometryType();
                        }
                        propertyMap = getCluePropertyMap(map, exportFields);

                        if (propertyMap != null && propertyMap.containsKey("shape")) {
                            propertyMap.remove("shape");
                        }

                        if (propertyMap != null) {
                            propertyMap.put(geoKey, geometry);
                            geometryList.add(propertyMap);
                        }
                    } else {
                        name = getName(map);
                        errorInfo.add("图斑 [" + name + "] 的图形数据为空，跳过下载该图斑的图形数据及属性信息\r\n");
                        logger.info(getDescription() + " 第" + index + "个图斑的的geometry转换成Geometry为空 图斑id：" + map.get("f_id").toString());
                    }
                } else {
                    name = getName(map);
                    errorInfo.add("图斑 [" + name + "] 的图形数据为空，跳过下载该图斑的图形数据及属性信息\r\n");
                    logger.info(getDescription() + " 第" + index + "个图斑的f_shape为空 图斑id：" + map.get("f_id").toString());
                }
            }
            try {
                if (attrKeys != null) {
                    for (String key : attrKeys) {
                        if ("shape".equalsIgnoreCase(key)) {
                            attrKeys.remove(key);
                            break;
                        }
                    }
                }
                ShapeUtil.write2Shape(targetFileName, "GB2312", geometryType, geoKey, attrKeys, geometryList);
            } catch (Exception e) {
                logger.info(getDescription() + " 导出geometry到shape文件异常 ");
                logger.error(e);
                throw e;
            } finally {
                if (attrKeys != null) {
                    attrKeys = null;
                }
                if (propertyMap != null) {
                    propertyMap = null;
                }
                if (geometryList != null) {
                    geometryList = null;
                }
            }
        } else {
            logger.info(getDescription() + " 导出数据---图斑总个数：0");
        }
    }




    private Map<String, String> columnNameToHeaderMap(List<JcClueFields> exportFields) {
        Map<String, String> result = new HashMap<>();
        if (exportFields != null && exportFields.size() > 0) {
            result.put("taskId", "任务id");
            result.put("taskCode", "任务类型");
            result.put("taskName", "任务名称");
            for (JcClueFields exportField : exportFields) {
                if (StringUtils.isBlank(exportField.getfFieldtype())) {
                    continue;
                }
                if ("taskId".equalsIgnoreCase(exportField.getfFieldname())
                        || "taskCode".equalsIgnoreCase(exportField.getfFieldname())
                        || "taskName".equalsIgnoreCase(exportField.getfFieldname())
                        || "f_shape".equalsIgnoreCase(exportField.getfFieldname())) {
                    continue;
                }
                result.put(exportField.getfFieldname().replace("f_", "").trim(), exportField.getfAlias());
            }
        }
        return result;
    }


    @Override
    protected String getDataType() {
        return "shape";
    }

    @Override
    protected String getFileExtension() {
        return ".shp";
    }

    @Override
    protected String getDescription() {
        return "日常任务下载【SHAPE】";
    }

    @Override
    boolean isQueryGeoFields() {
        return true;
    }



    Map<String, Object> getCluePropertyMap(Map map, List<JcClueFields> exportFields) {
        Map<String, Object> resultMap = new HashMap<>();
        if (map == null) {
            return resultMap;
        }

        String userName = "";
        String createtime = "";
        resultMap.put("taskId", taskId);
        resultMap.put("taskCode", taskCode);
        resultMap.put("taskName", taskName);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp ts = null;
        DecimalFormat decimalFormat = new DecimalFormat("#.#######");

        String columnNmae = "";
        String tempValue = "";
        if (exportFields != null && exportFields.size() > 0) {
            for (JcClueFields field : exportFields) {
                if (StringUtils.isBlank(field.getfFieldtype())) {
                    continue;
                }
                if ("taskId".equalsIgnoreCase(field.getfFieldname())
                        || "taskCode".equalsIgnoreCase(field.getfFieldname())
                        || "taskName".equalsIgnoreCase(field.getfFieldname())
                        || "f_shape".equalsIgnoreCase(field.getfFieldname())) {
                    continue;
                }
                columnNmae = "f_" + field.getfFieldname();

                if ("f_userid".equalsIgnoreCase(columnNmae)) {
                    if (map.containsKey("f_userid") && map.get("f_userid") != null) {
                        // 将用户id转换成用户真实姓名
                        userName = userNameService.getUserRealNameByUserId(map.get("f_userid").toString());
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), userName);
                    }
                } else if ("f_createtime".equalsIgnoreCase(columnNmae)
                        || "f_committime".equalsIgnoreCase(columnNmae)) {
                    try {
                        if (map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                            ts = new Timestamp(Long.valueOf(map.get(columnNmae).toString()));
                            createtime = format.format(ts);
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), createtime);
                        }
                    } catch (Exception e) {
                        if (map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), map.get(columnNmae).toString());
                        }
                    }
                } else if ("f_lon".equalsIgnoreCase(columnNmae)
                        || "f_lat".equalsIgnoreCase(columnNmae)) {
                    try {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), decimalFormat.format(Double.parseDouble(map.get(columnNmae).toString())));
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_sfydjzl".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        if ("1".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "有");
                        } else if ("2".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "无");
                        } else {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), tempValue);
                        }
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_bz".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    // 翻译标注
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        String translatedValue = "";
                        switch (tempValue) {
                            case "1":
                                translatedValue = "已登记，影像无房";
                                break;
                            case "2":
                                translatedValue = "已登记，登记附图需矢量化";
                                break;
                            case "3":
                                translatedValue = "已登记，登记附图有矢量图形";
                                break;
                            case "4":
                                translatedValue = "已登记，登记附图需矢量化，现已扩建";
                                break;
                            case "5":
                                translatedValue = "已登记，登记附图有矢量图形，现已扩建";
                                break;
                            case "6":
                                translatedValue = "已登记，登记附图需矢量化，现状无房屋";
                                break;
                            case "7":
                                translatedValue = "已登记，登记附图有矢量图形，现状无房屋";
                                break;
                            case "8":
                                translatedValue = "已登记，现状图形与登记面积一致";
                                break;
                            case "9":
                                translatedValue = "已登记，现状图形与登记面积不一致";
                                break;
                            case "10":
                                translatedValue = "未登记，现状图形";
                                break;
                            case "11":
                                translatedValue = "其他";
                                break;
                            default:
                                translatedValue = tempValue;
                                break;
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_tdyt".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    // 翻译土地用途
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        String translatedValue = "";
                        switch (tempValue) {
                            case "1":
                                translatedValue = "农村宅基地";
                                break;
                            case "2":
                                translatedValue = "公共设施农用地";
                                break;
                            case "3":
                                translatedValue = "医卫慈善用地";
                                break;
                            case "4":
                                translatedValue = "科教用地";
                                break;
                            case "5":
                                translatedValue = "其他";
                                break;
                            default:
                                translatedValue = tempValue;
                                break;
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_qlrlx".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    // 翻译权利人类型
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        String translatedValue = "";
                        switch (tempValue) {
                            case "1":
                                translatedValue = "个人";
                                break;
                            case "2":
                                translatedValue = "单位";
                                break;
                            default:
                                translatedValue = tempValue;
                                break;
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_ismycreate".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        if ("1".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "是");
                        } else if ("0".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "否");
                        } else {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), tempValue);
                        }
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_qlrqm".equalsIgnoreCase(columnNmae)
                        || "f_dcrqm".equalsIgnoreCase(columnNmae)
                        || "f_sign".equalsIgnoreCase(columnNmae)
                        || "f_requestid".equalsIgnoreCase(columnNmae)) {
                    try {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), "");
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else {
                    if (map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), map.get(columnNmae));
                    } else {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), "");
                    }
                }
            }
        }
        return resultMap;
    }

    List<String> getCluePropertyKeys(List<JcClueFields> exportFields) {
        List<String> propertyKeys = new ArrayList<>();
        if (exportFields != null && exportFields.size() > 0) {
            for (JcClueFields field : exportFields) {
                if (StringUtils.isNotBlank(field.getfFieldname())) {
                    propertyKeys.add(field.getfFieldname().replace("f_", "").trim());
                }
            }
        }
        return propertyKeys;
    }
}
