package com.geoway.landteam.landcloud.service.customtask.pub.impl;



import java.io.File;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.geoway.landteam.customtask.servface.mq.DataDownloadProducerService;
import com.geoway.landteam.customtask.servface.mq.DownloadGeometryProducerService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.gw.base.util.GutilAssert;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import com.geoway.landteam.customtask.service.pub.DownloadGeometryService;
import com.geoway.landteam.customtask.service.util.FileUtil1;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.core.repository.base.AppBasicRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.servface.base.AppBasicService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;

/**
 * @Author: zkn
 * @Date: 2020/3/27 21:11
 * @Description: 随手拍下载Geometry数据服务类
 */
public abstract class MDownloadGeometryTakeHandBaseService extends DownloadGeometryService {
    private static final String TAKE_HAND_TASK_ID = "ssp";
    private static final String TAKE_HAND = "随手拍";
    @Value("${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    AppBasicService appBasicService;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    DataDownloadProducerService dataDownloadProducerService;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    AppBasicRepository appBasicRepository;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    UserNameService userNameService;
    @Autowired
    DownloadGeometryProducerService downloadGeometryProducerService;
    String geoKey = "f_shape";
    String taskId = "";
    String taskCode = "";
    String taskName = "";
    String prjNum = "";
    private final GiLoger logger = GwLoger.getLoger(MDownloadGeometryTakeHandBaseService.class);
    /**
     * 初始化参数
     *
     * @param taskId
     * @param taskCode
     * @param taskName
     * @param prjNum
     */
    private void initParameter(String taskId, String taskCode, String taskName, String prjNum) {
        GutilAssert.notNull(taskId, "taskId can not be null");
        GutilAssert.notNull(taskCode, "taskCode can not be null");
        GutilAssert.notNull(taskName, "taskName can not be null");
        GutilAssert.notNull(downloadRecord, "downloadRecord can not be null");
        logger.info("日常任务下载 初始化下载参数 taskId:" + taskId + "  taskCode:" + taskCode + "   taskName:" + taskName + "   prjNmu:" + prjNum);
        logger.info("日常任务下载 初始化下载参数 downloadRecord:" + downloadRecord.toString());
        this.taskId = taskId;
        this.taskCode = taskCode;
        this.taskName = taskName;
        this.prjNum = prjNum;
        resultUrl = "";
    }

    @Override
    public void doDownload() throws Exception {
        logger.info(this.getDescription() + " 图斑数据下载开始处理...");
        try {
            if (dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
                return;
            }
            List<String> ids = Arrays.asList(downloadParameter.getTbIds().split(","));
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
            // 临时存放数据的路径，
            String tempFolderPath = new StringBuilder()
                    .append(uploadDir)
                    .append(File.separator)
                    .append(UuidUtil.get16UUID())
                    .toString();
            FileUtil1.creatDirectoryIfNotExist(tempFolderPath);
            String safeFileName = "";
            if (ids.size() > 1) {
                safeFileName = "随手拍(" + ids.size() + "个)" + UuidUtil.get16UUID();
            } else if (ids.size() == 1) {
                AppBasic detailById = appBasicService.getDetailById(ids.get(0));
                if (detailById != null) {
                    if (StringUtils.isNotBlank(detailById.getHeading())) {
                        safeFileName = "随手拍(" + detailById.getHeading() + ")" + UuidUtil.get16UUID();
                    } else if (StringUtils.isNotBlank(detailById.getName())) {
                        safeFileName = "随手拍(" + detailById.getName() + ")" + UuidUtil.get16UUID();
                    } else {
                        safeFileName = "随手拍(" + UuidUtil.get16UUID() + ")" + UuidUtil.get16UUID();
                    }
                } else {
                    safeFileName = "随手拍(" + UuidUtil.get16UUID() + ")" + UuidUtil.get16UUID();
                }
            } else {
                safeFileName = "随手拍(" + UuidUtil.get16UUID() + ")" + UuidUtil.get16UUID();
            }

            String fullFileNameNoSuffix = new StringBuilder()
                    .append(uploadDir)
                    .append(File.separator)
                    .append(safeFileName)
                    .toString();

            initParameter(TAKE_HAND_TASK_ID, TAKE_HAND, TAKE_HAND, "");
            downloadRecord.setName(TAKE_HAND + "(下载" + getDataType() + ")");
            exportGeometry(ids, downloadParameter.getUserId(), tempFolderPath);
            afterExport(tempFolderPath, safeFileName, fullFileNameNoSuffix);
        } catch (Exception e) {
            handleException(e);
        }
    }


    /**
     * 获取导出目标文件的名称
     *
     * @param fileName
     * @param folderPath
     * @return
     */
    String getExportFileName(String fileName, String folderPath) {
        FileUtil1.creatDirectoryIfNotExist(folderPath);
        String targetFileName = new StringBuilder()
                .append(folderPath)
                .append(File.separator)
                .append(taskName)
                .append("(")
                .append(fileName)
                .append(")")
                .append(getFileExtension())
                .toString();
        File file = new File(targetFileName);
        if (!file.exists()) {
//            try {
//                file.createNewFile();
//            } catch (IOException e) {
//                e.printStackTrace();
//            }
        }
        return targetFileName;
    }

    @Override
    public String getObsFolderPath() {
        return "ssp/download" + "/" + getDataType();
    }

    abstract void exportGeometry(List<String> idList, Long userId, String tempSavePath) throws Exception;


    List<String> getPropertyKeys() {
        List<String> propertyKeys = getBasicPropertyKeys();
        // 外业字段
        propertyKeys.add("type");
        propertyKeys.add("desc");
        return propertyKeys;
    }

    /**
     * 基本属性key值
     *
     * @return
     */
    List<String> getBasicPropertyKeys() {
        List<String> propertyKeys = new ArrayList<>();
        propertyKeys.add("taskId");
        propertyKeys.add("taskCode");
        propertyKeys.add("taskName");
        propertyKeys.add("prjNum");
        propertyKeys.add("tbId");
        propertyKeys.add("tbName");
        propertyKeys.add("tbmj");
        propertyKeys.add("lon");
        propertyKeys.add("lat");
        propertyKeys.add("regionCode");
        propertyKeys.add("requestId");
        propertyKeys.add("createtime");
        propertyKeys.add("userName");
        return propertyKeys;
    }

    Map<String, Object> getPropertyMap(AppBasic appbasic) {
        Map<String, Object> resultMap = new HashMap<>();
        if (appbasic == null) {
            return null;
        }
        String tbId = "";
        String tbName = "";
        Double lon = 0D;
        Double lat = 0D;
        Double tbmj = 0D;
        String regionCode = "";
        String requestId = "";
        String userName = "";
        String createtime = "";

        taskId = appbasic.getId();
        tbId = appbasic.getId();
        tbName = StringUtils.isNotBlank(appbasic.getName()) ? appbasic.getName() : null;
        String heading = StringUtils.isNotBlank(appbasic.getHeading()) ? appbasic.getHeading() :
                (StringUtils.isNotBlank(appbasic.getName()) ? appbasic.getName() : "");
        lon = appbasic.getLon() != null ? appbasic.getLon() : 0D;
        lat = appbasic.getLat() != null ? appbasic.getLat() : 0D;
        tbmj = appbasic.getMj() != null ? appbasic.getMj() : 0D;
        regionCode = appbasic.getCounty() != null ? appbasic.getCounty() : "";
        requestId = appbasic.getRequestId() != null ? appbasic.getRequestId() : "";
        createtime = appbasic.getCreatetime() != null ? appbasic.getCreatetime() : "";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); //设置格式
        try {
            Timestamp ts = new Timestamp(Long.valueOf(createtime));
            createtime = format.format(ts);
        } catch (Exception e) {
            e.printStackTrace();
            createtime = appbasic.getCreatetime();
        }
        // 将用户名转换成用户真实姓名
        userName = userNameService.getUserRealNameByUserName(appbasic.getUsername());

        resultMap.put("taskId", taskId);
        resultMap.put("taskCode", taskCode);
        resultMap.put("taskName", taskName);
        resultMap.put("prjNum", prjNum);
        resultMap.put("tbId", tbId);
        resultMap.put("tbName", tbName);
        resultMap.put("tbmj", tbmj);
        resultMap.put("lon", lon);
        resultMap.put("lat", lat);
        resultMap.put("regionCode", regionCode);
        resultMap.put("requestId", requestId);
        resultMap.put("createtime", createtime);
        resultMap.put("userName", userName);
        // 外业字段
        resultMap.put("type", StringUtils.isNotBlank(appbasic.getType()) ? appbasic.getType() : "");
        resultMap.put("desc", StringUtils.isNotBlank(appbasic.getDesc()) ? appbasic.getDesc() : "");

        return resultMap;
    }

    protected String getName(AppBasic appbasic) {
        if (appbasic == null) {
            return "";
        }
        String name = "";
        if (StringUtils.isNotBlank(appbasic.getHeading())) {
            name = appbasic.getHeading();
        } else if (StringUtils.isNotBlank(appbasic.getName())) {
            name = appbasic.getName();
        } else {
            name = appbasic.getId();
        }
        return name;
    }
}
