package com.geoway.landteam.landcloud.service.customtask.pub.impl;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.enm.DownloadTypeEnum;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.geometry.ShapeUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.service.pub.impl.SysConfigServiceImpl;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFields;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportRecord;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRecordService;
import com.geoway.landteam.patrolclue.service.pub.impl.DataDownloadFieldService;
import com.geoway.landteam.patrolclue.service.util.UuidUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 奉节需求
 * @Description: 下载日常任务shape-txt格式数据服务实现
 */
@Service
public class MDownloadTxtDailyTaskServiceImpl extends MDownloadGeometryDailyTaskBaseService {
    private final GiLoger logger = GwLoger.getLoger(MDownloadTxtDailyTaskServiceImpl.class);


    @Autowired
    DataBizMapper dataBizMapper;

    @Value("${transmit.url:}")
    String transmitUrl;
    @Value("${transmit.txtdown.appkey:}")
    String transmitAppkey;
    @Value("${transmit.txtdown.module:}")
    String transmitModule;

    @Value("${transmit.enable:false}")
    boolean transmitEnable;
    @Autowired
    SysConfigServiceImpl sysConfigService;

    private static final String TASK_CODE_DAILY_TASK = "日常任务";

    private static final String CONFIG = "txt-down-config";



    @Override
    public void doDownload() throws Exception {

        logger.info(getDescription() + " 图斑数据下载开始处理...");
        TskTaskBiz tskTaskBiz = null;
        TbtskObjectinfo tbtskObjectinfo = null;
        List<TbtskFields> fields = null;
        // 需要导出的字段
        List<TbtskFields> exportFields = new ArrayList<>();
        List<String> queryFieldNames = new ArrayList<String>();

        try {
            if (dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
                return;
            }
            logger.info(getDescription() + " 开始查询任务f_shape字段数据");
            tskTaskBiz = tskTaskBizService.findByTaskId(downloadParameter.getTaskId());
            if (tskTaskBiz != null && StringUtils.isNotBlank(tskTaskBiz.getTableId())) {
                tbtskObjectinfo = tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
            }
            if (tbtskObjectinfo != null && StringUtils.isNotBlank(tbtskObjectinfo.getfTablename())) {
                fields = tbtskFieldsService.getAllFieldsByTables(tbtskObjectinfo.getfTablename());
            }
            List<TbtskFields> sourceFields = new ArrayList<>();
            SysConfig config = sysConfigService.findOne(CONFIG);
            if(config!=null)
            {
                JSONObject jsonObject = JSONObject.parseObject(config.getValue());
                JSONArray arr = jsonObject.getJSONArray("fields");
                for(int i=0;i<arr.size();i++)
                {
                    String field = arr.getString(i);
                    TbtskFields tf =  fields.stream().filter(t->t.getfFieldname().equals(field)).findFirst().orElse(null);
                    if(tf!=null)
                    {
                        sourceFields.add(tf);
                    }
                }
            }

            if (sourceFields != null && sourceFields.size() > 0) {
                for (TbtskFields field : sourceFields) {
                    if ("f_shape1".equalsIgnoreCase(field.getfFieldname())
                            || "f_shape_b".equalsIgnoreCase(field.getfFieldname())
                            || "f_shape_g".equalsIgnoreCase(field.getfFieldname())) {
                        continue;
                    }
                    if (field.getfFieldname().equalsIgnoreCase("f_shape")) {
                        if (isQueryGeoFields()) {
                            queryFieldNames.add("d." + field.getfFieldname());
                        }
                    } else {
                        queryFieldNames.add("d." + field.getfFieldname());
                    }
                }
                exportFields = com.geoway.landteam.customtask.service.pub.DataDownloadFieldService.getExportFields(sourceFields);
            }

            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
            // 临时数据存放文件夹
            String tempFolderPath = new StringBuilder().append(uploadDir).append(File.separator).append(com.geoway.landteam.customtask.service.util.UuidUtil.get16UUID()).toString();
            FileUtil.creatDirectoryIfNotExist(tempFolderPath);
            String safeFileName = UUID.randomUUID().toString();
            List<Map> sourceData = getSourceData(tbtskObjectinfo, queryFieldNames);
            if (sourceData != null) {
                /*
                if (sourceData.size() == 1) {
                    if (sourceData.get(0).get("f_tbmc")!=null && StringUtils.isNotBlank(sourceData.get(0).get("f_tbmc").toString())) {
                        safeFileName = new StringBuilder().append(tskTaskBiz.getName()).append("(").append(sourceData.get(0).get("f_tbmc").toString()).append(com.geoway.landteam.customtask.service.util.UuidUtil.get16UUID()).append("）").toString();
                    } else {
                        safeFileName = new StringBuilder().append(tskTaskBiz.getName()).append("(").append(com.geoway.landteam.customtask.service.util.UuidUtil.get16UUID()).append("）").toString();
                    }
                } else {
                    safeFileName = new StringBuilder().append(tskTaskBiz.getName()).append("(").append(sourceData.size()).append("个)").append(com.geoway.landteam.customtask.service.util.UuidUtil.get16UUID()).toString();
                }
                //增加审核相关字段
                exportFields = addApproveFields(exportFields);
                //增加审核记录
                addApproveInfo(tbtskObjectinfo,sourceData,tskTaskBiz);
                */
                //导出数据
                String fileNameNoSuffix = new StringBuilder().append(uploadDir).append(File.separator).append(safeFileName).toString();
                initParameter(tskTaskBiz.getId(), TASK_CODE_DAILY_TASK, tskTaskBiz.getName(), "");
                downloadRecord.setName(tskTaskBiz.getName() + "(下载" + getDataType() + ")");
                exportAction(sourceData, tempFolderPath, exportFields);
                afterExport(tempFolderPath, safeFileName, fileNameNoSuffix);
            }
        } catch (Exception e) {
            handleException(e);
        }


    }

    @Override
    public void afterExport(String tempFolderPath, String safeFileName, String fileNameNoSuffix) {
        generateLog(tempFolderPath);
        generateConfig(tempFolderPath);
        Zip4jUtils.zip(tempFolderPath, fileNameNoSuffix + ".zip", false, "");
        JSONObject httpResult = HttpUtil.sendRrquestByFile( transmitAppkey, transmitModule, new File(fileNameNoSuffix +".zip"), transmitUrl+"/monitor/trans/transData.action");
        if(httpResult==null||!"200".equals(httpResult.getString("code")))
        {
            downloadRecord.setState(DataDownloadStateEnum.FAILED);
            downloadRecord.setEndTime(new Date());
            downloadRecord.setErrorMsg("发送shp包到内网失败");
            dataDownloadRecordService.update(downloadRecord);
        }

        FileUtils.deleteQuietly(new File(tempFolderPath));
        // 删除zip文件
        FileUtils.deleteQuietly(new File(fileNameNoSuffix + ".zip"));
    }


    @Override
    void exportAction(List<Map> sourceData, String tempSavePath, List<TbtskFields> exportFields) throws Exception {
        if (sourceData != null) {
            logger.info(getDescription() + " 导出数据---图斑总个数：" + sourceData.size());
            int index = 0;
            String targetFileName = getExportFileName(sourceData, tempSavePath);
//            List<String> attrKeys = getPropertyKeys(exportFields);
            List<Map<String, String>> propertyKeysMapList = getPropertyKeysWithFieldType(exportFields);
            List<Map<String, String>> propertyKeysParams = new ArrayList<>();
            List<Map<String, Object>> geometryList = new ArrayList<>();
            Map<String, Object> propertyMap = null;
            String geometryType = "";
            Geometry geometry = null;
            String name = "";
            for (Map map : sourceData) {
                if (dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
                    return;
                }
                index++;
                if (map.containsKey("f_shape") && map.get("f_shape") != null && StringUtils.isNotBlank("f_shape")) {
                    geometry = null;
                    logger.info(getDescription() + " 正在构建" + index + "个图斑的geometry数据及属性信息 图斑id：" + map.get("f_id").toString());

                    try {
                        geometry = WKTUtil.wktToGeom(map.get("f_shape").toString().replace("SRID=4490;",""));
                    } catch (ParseException e) {
                        logger.info(getDescription() + " 第" + index + "个图斑的的geometry转换成Geometry出现异常 图斑id：" + map.get("f_id").toString());
                        logger.error(e);
                    }
                    if (geometry != null) {
                        if (index == 1 || StringUtils.isBlank(geometryType)) {
                            geometryType = geometry.getGeometryType();
                        }
                        propertyMap = super.getPropertyMap(map, exportFields);

                        if (propertyMap != null && propertyMap.containsKey("shape")) {
                            propertyMap.remove("shape");
                        }

                        if (propertyMap != null) {
                            propertyMap.put(geoKey, geometry);
                            geometryList.add(propertyMap);
                        }
                    } else {
                        name = getName(map);
                        errorInfo.add("图斑 [" + name + "] 的图形数据为空，跳过下载该图斑的图形数据及属性信息\r\n");
                        logger.info(getDescription() + " 第" + index + "个图斑的的geometry转换成Geometry为空 图斑id：" + map.get("f_id").toString());
                    }
                } else {
                    name = getName(map);
                    errorInfo.add("图斑 [" + name + "] 的图形数据为空，跳过下载该图斑的图形数据及属性信息\r\n");
                    logger.info(getDescription() + " 第" + index + "个图斑的f_shape为空 图斑id：" + map.get("f_id").toString());
                }
            }
            try {
//                if (attrKeys != null) {
//                    for (String key : attrKeys) {
//                        if ("shape".equalsIgnoreCase(key)) {
//                            attrKeys.remove(key);
//                            break;
//                        }
//                    }
//                }
                if(propertyKeysMapList != null && propertyKeysMapList.size() > 0) {
                    for (Map<String, String> map : propertyKeysMapList) {
                        if(map.get("fieldname").contains("shape")) {
//                            propertyKeysMapList.remove(map);
                        } else {
                            propertyKeysParams.add(map);
                        }
                    }
                }

                ShapeUtil.write2ShapeWithFieldType(targetFileName, "GB2312", geometryType, geoKey, propertyKeysParams, geometryList);
            } catch (Exception e) {
                logger.info(getDescription() + " 导出geometry到shape文件异常 ");
                logger.error(e);
                throw e;
            } finally {
//                if (attrKeys != null) {
//                    attrKeys = null;
//                }
                if (propertyKeysMapList != null) {
                    propertyKeysMapList = null;
                }
                if (propertyKeysParams != null) {
                    propertyKeysParams = null;
                }
                if (propertyMap != null) {
                    propertyMap = null;
                }
                if (geometryList != null) {
                    geometryList = null;
                }
            }
        } else {
            logger.info(getDescription() + " 导出数据---图斑总个数：0");
        }
    }


    void generateConfig(String folderPath) {

        if (com.geoway.landteam.landcloud.common.util.base.StringUtils.isNotBlank(folderPath)) {
            FileUtil.creatDirectoryIfNotExist(folderPath);

            String fileName = new StringBuilder()
                    .append(folderPath)
                    .append(File.separator)
                    .append("config.json")
                    .toString();
            try {
                File file = new File(fileName);
                if (!file.exists()) {
                    file.createNewFile();
                }
                Writer writer = null;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id",downloadRecord.getId());
                try {

                    writer = new FileWriter(file, true); // true表示追加
                    writer.write(jsonObject.toJSONString());
                } catch (IOException e) {
                    e.printStackTrace();
                } finally {
                    try {
                        writer.close();
                    } catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }





    @Override
    protected String getDataType() {
        return "txt";
    }

    @Override
    protected String getFileExtension() {
        return ".shp";
    }

    @Override
    protected String getDescription() {
        return "日常任务下载【TXT】";
    }

    @Override
    boolean isQueryGeoFields() {
        return true;
    }




    List<String> getCluePropertyKeys(List<JcClueFields> exportFields) {
        List<String> propertyKeys = new ArrayList<>();
        if (exportFields != null && exportFields.size() > 0) {
            for (JcClueFields field : exportFields) {
                if (StringUtils.isNotBlank(field.getfFieldname())) {
                    propertyKeys.add(field.getfFieldname().replace("f_", "").trim());
                }
            }
        }
        return propertyKeys;
    }
}
