package com.geoway.landteam.landcloud.service.customtask.pub.impl;

import com.geoway.landteam.landcloud.common.util.geometry.KmlUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Author: zkn
 * @Date: 2020/3/27 14:40
 * @Description: 下载随手拍kml格式数据服务实现
 */
@Service
public class MMDownloadGeometryTakeHandKmlServiceImpl extends MDownloadGeometryTakeHandBaseService {
    private final GiLoger logger = GwLoger.getLoger(MMDownloadGeometryTakeHandKmlServiceImpl.class);

    /**
     * 导出geometry
     *
     * @param idList
     * @param userId
     * @param tempSavePath
     * @throws Exception
     */
    @Override
    void exportGeometry(List<String> idList, Long userId, String tempSavePath) throws Exception {
        if (idList != null && idList.size() > 0) {
            logger.info(getDescription() + " 导出数据---图斑总个数：" + idList.size());
            int index = 0;
            String targetFileName = "";
            List<String> attrKeys = getPropertyKeys();
            List<Map<String, Object>> geometryList = new ArrayList<>();
            Map<String, Object> propertyMap = null;
            AppBasic appbasic = null;
            String name = "";
            Geometry geometry = null;
            for (String id : idList) {
                if (dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
                    return;
                }
                index++;
                logger.info(getDescription() + " 正在查询第" + index + "个图斑的geometry数据 图斑id：" + id);
                appbasic = appBasicService.getDetailById(id, userId.toString());
                if (index == 1) {
                    name = "";
                    if (idList.size() == 1) {
                        name = getName(appbasic);
                    } else {
                        name = idList.size() + "个";
                    }
                    targetFileName = getExportFileName(name, tempSavePath);
                }

                if (appbasic.getShape() != null) {
                    geometry = null;
                    logger.info(getDescription() + " 正在构建" + index + "个图斑的geometry数据及属性数据 图斑id：" + id);
                    try {
                        geometry = WKTUtil.wktToGeom(appbasic.getShape());
                    } catch (ParseException e) {
                        logger.info("随手拍下载 第" + index + "个图斑的的shape转换成Geometry出现异常 图斑id：" + id);
                        logger.error(e);
                    }

                    if (geometry != null) {
                        propertyMap = getPropertyMap(appbasic);
                        if (propertyMap != null) {
                            propertyMap.put(geoKey, geometry);
                            geometryList.add(propertyMap);
                        }
                    } else {
                        name = getName(appbasic);
                        errorInfo.add("图斑 [" + name + "] 的图形数据为空，跳过下载该图斑的图形数据及属性信息\r\n");
                        logger.info(getDescription() + " 第" + index + "个图斑的的geometry转换成Geometry为空 图斑id：" + id);
                    }
                } else {
                    name = getName(appbasic);
                    errorInfo.add("图斑 [" + name + "] 的图形数据为空，跳过下载该图斑的图形数据及属性信息\r\n");
                    logger.info(getDescription() + " 第" + index + "个图斑的f_shape为空 图斑id：" + id);
                }
            }
            try {
                KmlUtil.write2Wml(targetFileName, geoKey, attrKeys, geometryList);
            } catch (Exception e) {
                logger.info(getDescription() + " 导出geometry到kml文件异常");
                logger.error(e);
                throw e;
            } finally {
                if (attrKeys != null) {
                    attrKeys = null;
                }
                if (propertyMap != null) {
                    propertyMap = null;
                }
                if (appbasic != null) {
                    appbasic = null;
                }
                if (geometry != null) {
                    geometry = null;
                }
                if (geometryList != null) {
                    geometryList = null;
                }
            }
        }
    }

    @Override
    protected String getDataType() {
        return "kml";
    }

    @Override
    protected String getFileExtension() {
        return ".kml";
    }

    @Override
    protected String getDescription() {
        return "随手拍下载【KML】";
    }
}
