package com.geoway.landteam.landcloud.service.customtask.resultshare.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.service.resultshare.config.AnalysisConfig;
import com.geoway.landteam.customtask.resultshare.enm.AnalysisTaskStateEnum;
import com.geoway.landteam.customtask.resultshare.pub.dto.AnalysisParam;
import com.geoway.landteam.customtask.resultshare.pub.dto.AnalysisTaskDto;
import com.geoway.landteam.customtask.util.ObjectReference;
import com.geoway.landteam.landcloud.common.util.HttpConnectionUtil;
import com.geoway.landteam.landcloud.common.util.RequestUtil;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MAnalysisTaskService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class MAnalysisTaskServiceImpl implements MAnalysisTaskService {
    private final GiLoger logger = GwLoger.getLoger(MAnalysisTaskServiceImpl.class);
    @Autowired
    AnalysisConfig analysisConfig;


    @Override
    public String createAnalysisTask(AnalysisParam params, ObjectReference ref) {
        try{
            String result = RequestUtil.sendPost(analysisConfig.getTaskCreate(), JSONObject.toJSONString(params));
            JSONObject json = JSONObject.parseObject(result);
            if(json!=null)
            {
                if(json.getString("code").equalsIgnoreCase("200"))
                {
                    return json.getString("data");
                }
                else
                {
                    ref.setTag(json.getString("message"));
                    return "";
                }
            }
            return "";
        }
        catch (Exception ex)
        {
            logger.error("创建叠加分析任务失败",ex);
            ref.setTag("创建叠加分析任务失败");
            return "";
        }
    }

    @Override
    public Boolean startAnalysisTask(String id, ObjectReference ref)  {
        try {
            List<NameValuePair> formparams = new ArrayList<NameValuePair>();
            formparams.add(new BasicNameValuePair("id", id));
            JSONObject json = RequestUtil.sendHttpRequest(null, analysisConfig.getTaskStart(), null, formparams, true);
            if (json != null) {
                if (json.getString("code").equalsIgnoreCase("200")) {
                    return true;
                } else {
                    ref.setTag(json.getString("message"));
                    return false;
                }
            }
            return false;
        }
        catch (Exception ex)
        {
            logger.error("启动叠加分析任务"+id+"失败",ex);
            ref.setTag("启动叠加分析任务"+id+"失败");
            return false;
        }

    }

    @Override
    public AnalysisTaskDto getAnalysisTaskState(String id) {
        try {
            String result = HttpConnectionUtil.httpget(analysisConfig.getTaskGet() + "?id=" + id);
            JSONObject json = JSONObject.parseObject(result);
            if (json != null) {
                if (json.getString("code").equalsIgnoreCase("200")) {
                    String data = json.getString("data");
                    JSONObject jsonObject = JSONObject.parseObject(data);
                    AnalysisTaskDto dto = new AnalysisTaskDto();
                    dto.setId(jsonObject.getString("id"));
                    dto.setProgress(jsonObject.getInteger("progress"));
                    Integer suc = (jsonObject.getInteger("success"));
                    dto.setName(jsonObject.getString("name"));
                    Integer state = jsonObject.getInteger("state");
                    switch (state) {
                        case 1:
                            dto.setState(AnalysisTaskStateEnum.create);
                            break;
                        case 2:
                            dto.setState(AnalysisTaskStateEnum.runing);
                            break;
                        case 3:
                            if (suc.equals(1)) {
                                dto.setState(AnalysisTaskStateEnum.success);
                            } else {
                                dto.setState(AnalysisTaskStateEnum.error);
                            }
                            break;
                    }
                    return dto;
                } else {
                    return null;
                }
            }
            return null;
        }
        catch (Exception ex)
        {
            logger.error("获取分析任务:"+id+"进度失败",ex);
            return null;
        }
    }

    @Override
    public Boolean deleteAnalysisTask(String id) {
        try{
            List<NameValuePair> formparams = new ArrayList<NameValuePair>();
            formparams.add(new BasicNameValuePair("id", id));
            JSONObject json = RequestUtil.sendHttpRequest(null,analysisConfig.getTaskDelete(),null,formparams,true);
            if(json!=null)
            {
                if(json.getString("code").equalsIgnoreCase("200"))
                {
                    return true;
                }
                else
                {
                    logger.error(json.getString("message"));
                    return false;
                }
            }
            return false;
        }
        catch (Exception ex)
        {
            logger.error("删除分析任务:"+id+"失败",ex);
            return false;
        }
    }
}
