package com.geoway.landteam.landcloud.service.customtask.resultshare.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.service.resultshare.atlas.ATLAS_WF_Intersect;
import com.geoway.landteam.customtask.service.resultshare.config.AtlasConfig;
import com.geoway.landteam.customtask.resultshare.enm.AnalysisTaskStateEnum;
import com.geoway.landteam.customtask.resultshare.pub.dto.ATLAS_HTTP_Output_Obj;
import com.geoway.landteam.customtask.resultshare.pub.dto.AnalysisTaskDto;
import com.geoway.landteam.customtask.resultshare.pub.dto.Atlas_Analysis_Param;
import com.geoway.landteam.customtask.util.ObjectReference;
import com.geoway.landteam.landcloud.common.util.HttpConnectionUtil;
import com.geoway.landteam.landcloud.common.util.RequestUtil;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.model.cffx.enm.CffxStateEnum;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MAtlasTaskService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.sql.DataSource;
import java.awt.*;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;


@Service
@Transactional
public class MAtlasTaskServiceImpl implements MAtlasTaskService {

    private final GiLoger logger = GwLoger.getLoger(MAtlasTaskServiceImpl.class);
    @Autowired
    private AtlasConfig atlasConfig;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Autowired
    SysConfigRepository sysConfigRepository;

    private String intersectWorkFlow;




    @Override
    public String createAnalysisTask(Atlas_Analysis_Param params, ObjectReference ref)
    {
       if(ref==null)
       {
           ref = new ObjectReference();
       }
        try {
            //String atlasid = executeAtlasTaskIntersect(params,ref);
            String atlasid = executeAtlasTaskIntersectNew(params,ref);

            return atlasid;
        }
        catch (Exception ex)
        {
            ref.setTag("创建atlas任务失败,"+ex.getMessage());
            logger.error("创建atlas任务失败",ex);
            return "";
        }
    }

    @Override
    public Boolean startAnalysisTask(String atlasid, ObjectReference ref) {
        return true;
        /*
        try
        {

        String result = this.excuteCmd(atlasConfig.getTaskStart(), atlasid);
        JSONObject resultO = JSONObject.parseObject(result);

        String msg = resultO.getString("msg");
        Boolean flag = resultO.getBoolean("flag");
        if(!flag)
        {
            ref.setTag("启动atlas任务:"+atlasid+"失败,"+msg);
            logger.error("启动atlas任务:"+atlasid+"失败,"+msg);
        }
        return flag;
        }
        catch (Exception ex)
        {
            logger.error("启动atlas任务:" + atlasid + "失败",ex);
            return false;
        }
        */
    }

    @Override
    public AnalysisTaskDto getAnalysisTaskState(String atlasid)
    {
        String result = getAtlasTaskStatus(atlasid);
        JSONObject resultO = JSONObject.parseObject(result);
        String state = resultO.getString("State");
        Boolean flag = resultO.getBoolean("IsSucceed");
        Double progress = resultO.getDouble("Progress");
        AnalysisTaskDto dto = new AnalysisTaskDto();
        dto.setId(atlasid);
        if(progress!=null) {
            dto.setProgress(progress.intValue());
        }
        else
        {
            dto.setProgress(0);
        }
        if(StringUtils.isNotBlank(state))
        {
            state=state.toLowerCase();
        }
        switch (state)
        {
            case "running":
                dto.setState(AnalysisTaskStateEnum.runing);
                break;
            case "finished":
                if(flag) {
                    dto.setState(AnalysisTaskStateEnum.success);
                }
                else
                {
                    dto.setState(AnalysisTaskStateEnum.error);
                }
                break;
            default:
                dto.setState(AnalysisTaskStateEnum.create);
                break;
        }

        return dto;
    }


    private String executeAtlasTaskIntersectNew(Atlas_Analysis_Param params,ObjectReference ref) throws Exception {
        SysConfig systemConfig= sysConfigRepository.queryByKey("shareConfig");
        if(systemConfig==null)
        {
            throw  new Exception("成果服用配置shareConfig:为空");
        }
        JSONObject confg = JSONObject.parseObject(systemConfig.getValue());
        String intersectUrl = confg.getString("serviceUrl");
        String  atlasUrl = confg.getString("atlasUrl");
        String db = getDBAtlas();
        //输入条件验证
        checkIntersectParams(params);
        //创建Requst对象

        if(StringUtils.isBlank(intersectWorkFlow))
        {
            intersectWorkFlow = getTemplateNew();
        }
        String curParam = intersectWorkFlow;
        Map<String,String> mapParam = new HashMap<>();
        mapParam.put("{left}",db+"/"+params.getLayerLeft().getFeatureSet());
        mapParam.put("{leftPkField}","aid");
        mapParam.put("{leftShapeField}","f_shape");
        mapParam.put("{leftWhere}",StringUtils.isNotBlank(params.getLayerLeft().getSql())?params.getLayerLeft().getSql(): "1=1");
        mapParam.put("{right}",db+"/"+params.getLayerRight().getFeatureSet());
        mapParam.put("{rightPkField}","aid");
        mapParam.put("{rightShapeField}","f_shape");
        mapParam.put("{rightWhere}",StringUtils.isNotBlank(params.getLayerRight().getSql())?params.getLayerLeft().getSql(): "1=1");
        mapParam.put("{result}",params.getOutputFeatureSet());
        mapParam.put("{resultdb}",db+"/"+params.getOutputFeatureSet());
        for(Map.Entry<String,String>kv:mapParam.entrySet())
        {
            curParam = curParam.replace(kv.getKey(), kv.getValue());
        }
        logger.info("atlas service url:" + intersectUrl + " param:" + curParam);
        String result = HttpUtil.createPost(intersectUrl).body(curParam).execute().body();
        logger.info("atlas service url:" + intersectUrl + " http result: " + result);
        if (StringUtils.isBlank(result)) {
           return null;
        }
        else {
            JSONObject resultJson = JSONObject.parseObject(result);
            if (resultJson.containsKey("code") && resultJson.getString("code").equals("200")) {
                String taskId = resultJson.getJSONObject("data").getString("taskId");
                if (StringUtils.isNotBlank(taskId)) {
                   return taskId;
                } else {
                    return null;
                }
            } else {
                return null;
            }
        }

    }

    private String executeAtlasTaskIntersect(Atlas_Analysis_Param params,ObjectReference ref) throws Exception {
        String atlasid = null;
        String createurl = atlasConfig.getTaskCreate();
        String HdfsAddress = atlasConfig.getHdfsBaseAddress();
        String resultDb = getDB();
        //输入条件验证
        checkIntersectParams(params);
        //创建Requst对象

        if(StringUtils.isBlank(intersectWorkFlow))
        {
            intersectWorkFlow = getTemplate();
        }
        ATLAS_WF_Intersect aw = new ATLAS_WF_Intersect(intersectWorkFlow,params, HdfsAddress, resultDb,resultDb);
        aw.init();
        JSONObject taskJson = aw.getWorkFlowParam();
        if(taskJson==null)
        {
            logger.error("初始化ATALS任务失败");
            return null;
        }

        String postStr = taskJson.toJSONString();
        postStr = "taskdata=[" + postStr + "]";

        //创建Atlas任务
        String result = RequestUtil.sendPost(createurl,postStr);
        //解析结果
        ATLAS_HTTP_Output_Obj resultObj = JSON.parseObject(result, ATLAS_HTTP_Output_Obj.class);
        if (resultObj == null) {
            ref.setTag("创建ATALS任务失败");
            logger.error("创建ATALS任务失败");
           return null;
        }
        if (resultObj.isFlag() && resultObj.getMsg().equals("succeed")) {
            //创建任务成功
            String taskId = resultObj.getTaskid();
            atlasid = taskId;
            logger.info("创建ATALS任务成功, atlasid=" + atlasid);
        } else {
            ref.setTag("创建ATALS任务失败,"+resultObj.getMsg());
            logger.error("创建ATALS任务失败，atlasid=" + atlasid+","+resultObj.getMsg());
            return null;
        }
        return atlasid;
    }


    private void checkIntersectParams(Atlas_Analysis_Param params) {
        String errorStr = "输入的ATLAS任务参数有误！";
        if (params != null) {
            if (StringUtils.isNotBlank(params.getOutputFeatureSet())) {
                if (params.getLayerLeft()!=null&&StringUtils.isNotBlank(params.getLayerLeft().getFeatureSet())) {
                    if (params.getLayerRight()!=null&&StringUtils.isNotBlank(params.getLayerRight().getFeatureSet())) {
                        return;
                    } else {
                        errorStr += "比对图层1的图层名为空！";
                    }

                } else {
                    errorStr += "输入的比对图层树小于2！";
                }
            } else {
                errorStr += "输出图层名为空！";
            }


        } else {
            errorStr += "参数为空！";
        }

        throw new RuntimeException(errorStr);
    }

    private  String getTemplate() {
        try {
            InputStream is = FileUtil.class.getClassLoader().getResourceAsStream("static/overlay_template.json");
            BufferedReader reader = new BufferedReader(
                    new InputStreamReader(is,
                            StandardCharsets.UTF_8));
            String s = "";
            String result="";
            while ((s = reader.readLine()) != null) {
                result+=s;
            }
            return result;
        }
        catch (Exception ex)
        {
            logger.error("读取叠加工作流失败",ex);
            return null;
        }

    }
    private  String getTemplateNew() {
        try {
            InputStream is = FileUtil.class.getClassLoader().getResourceAsStream("static/intersect.json");
            BufferedReader reader = new BufferedReader(
                    new InputStreamReader(is,
                            StandardCharsets.UTF_8));
            String s = "";
            String result="";
            while ((s = reader.readLine()) != null) {
                result+=s;
            }
            return result;
        }
        catch (Exception ex)
        {
            logger.error("读取叠加工作流失败",ex);
            return null;
        }

    }
    private String getAtlasTaskStatus( String id) {
        try {
            SysConfig systemConfig= sysConfigRepository.queryByKey("shareConfig");
            if(systemConfig==null)
            {
                return "";
            }
            JSONObject confg = JSONObject.parseObject(systemConfig.getValue());

            String  atlasUrl = confg.getString("atlasUrl")+"/atlas/task/get";
            return HttpConnectionUtil.httpget(atlasUrl+ "?id=" + id + "&thin=1");
            //return HttpConnectionUtil.httpget(atlasConfig.getTaskGet() + "?id=" + id + "&thin=1");
        }
        catch (Exception ex)
        {
            logger.error("",ex);
            return "";
        }
    }

    
    
    @Override
    public Boolean deleteAtlasTask(String id) {
        try {
            String result = this.excuteCmd(atlasConfig.getTaskDelete(), id);
            JSONObject resultO = JSONObject.parseObject(result);

            String msg = resultO.getString("msg");
            Boolean flag = resultO.getBoolean("flag");
            if (!flag) {
                logger.error("删除atlas任务:" + id + "失败," + msg);
            }
            return flag;
        }
        catch (Exception ex)
        {
            logger.error("删除atlas任务:" + id + "失败",ex);
            return false;
        }
    }

    @Override
    public Boolean stopAtlasTask(String id) {
        try{
            String result = this.excuteCmd(atlasConfig.getTaskStop(), id);
            JSONObject resultO = JSONObject.parseObject(result);

            String msg = resultO.getString("msg");
            Boolean flag = resultO.getBoolean("flag");
            if(!flag)
            {
                logger.error("停止atlas任务:"+id+"失败,"+msg);
            }
            return flag;
        }
        catch (Exception ex)
        {
            logger.error("停止atlas任务:" + id + "失败",ex);
            return false;
        }
    }

    @Override
    public boolean isTaskError(String atlasid) {
        int errorCount = 0;
        JSONObject resultO = null;
        for (int i = 0; i < 3; i++) {
            String result = getAtlasTaskStatus(atlasid);
            resultO = JSONObject.parseObject(result);

            String state = resultO.getString("flag");
            Boolean flag = resultO.getBoolean("IsSucceed");
            Double progress = resultO.getDouble("Progress");

            if (("finished".equalsIgnoreCase(state) && flag == false) && progress < 100) {
                errorCount++;
            }
        }

        if (errorCount == 3) {
            logger.error("atlas任务执行异常，atlasid=" + atlasid + ",result:" + resultO.toJSONString());
            return true;
        }

        return false;
    }

    private String excuteCmd(String url, String id) {
        try{
        return HttpConnectionUtil.httpget(url + "?id=" + id);
        }
        catch (Exception ex)
        {
            logger.error("",ex);
            return "";
        }
    }
    private String getDBAtlas() {
        DataSource dataSource = jdbcTemplate.getDataSource();
        com.alibaba.druid.pool.DruidDataSource druidDataSource = (com.alibaba.druid.pool.DruidDataSource) dataSource;
        String url = druidDataSource.getUrl();
        String username = druidDataSource.getUsername();
        String password = druidDataSource.getPassword();
        String[] urls = StringUtils.split(url, "?");
        url = urls[0];// StringUtils.replace(urls[0], "jdbc:", "");
        String pre = url.substring(0, url.indexOf("/"));
        url = url.substring(url.indexOf("/") + 2);
        String result = pre + "//" + username + "/" + password + "@" + url;
        return result;//.replace("49.4.81.80","192.168.1.233");
    }
    private String getDB()
    {
        DataSource dataSource  = jdbcTemplate.getDataSource();
        com.alibaba.druid.pool.DruidDataSource druidDataSource = (com.alibaba.druid.pool.DruidDataSource )dataSource;
        String url =druidDataSource.getUrl();
        String username = druidDataSource.getUsername();
        String password = druidDataSource.getPassword();
        String [] urls = StringUtils.split(url,"?");
        url = StringUtils.replace(urls[0],"jdbc:","");
        String pre = url.substring(0,url.indexOf("/"));
        url = url.substring(url.indexOf("/")+2);
        String result = pre+"//"+ username+"/"+password+"@"+url;
        return result;//.replace("49.4.81.80","192.168.1.233");
    }
}
