package com.geoway.landteam.landcloud.service.customtask.resultshare.impl;


import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.dao.resultshare.ResultShareTbShareDao;
import com.geoway.landteam.customtask.dao.task.TbtskFieldsDao;
import com.geoway.landteam.customtask.dao.resultshare.ResultShareTbIdDao;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.resultshare.pub.entity.*;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.service.resultshare.config.AtlasConfig;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.resultshare.enm.AnalysisTaskStateEnum;
import com.geoway.landteam.customtask.resultshare.enm.TranslateTypeEnum;
import com.geoway.landteam.customtask.resultshare.pub.dto.*;
import com.geoway.landteam.customtask.util.ObjectReference;
import com.geoway.landteam.landcloud.common.oss.OSSTypeConstants;
import com.geoway.landteam.landcloud.common.oss.OssConfig;
import com.geoway.landteam.landcloud.common.oss.OssOperator;
import com.geoway.landteam.landcloud.common.util.geometry.SRWKTTemplate;
import com.geoway.landteam.landcloud.core.dao.pub.AppMediaDao;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.*;
import com.geoway.landteam.landcloud.servface.pub.MAppMediaService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskFieldsService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskFlowService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskObjectinfoService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.geoway.landteam.landcloud.service.util.TableUtil;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import com.gw.base.util.GutilStr;
import com.mchange.v2.beans.BeansUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Service;

import javax.sql.DataSource;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;


/**
 * @author ZhenKaining
 * @date 2021年04月25日 18:17
 */
@Service
public class MResultShareAtlasServiceImpl implements MResultShareAtlasService {
    private final GiLoger logger = GwLoger.getLoger(MResultShareAtlasServiceImpl.class);
    @Autowired
    MResultShareTaskService resultShareTaskService;

    @Autowired
    MResultShareTaskDetailService resultShareTaskDetailService;

    @Autowired
    MResultShareTemplateService resultShareTemplateService;

    @Autowired
    ResultShareTbIdDao resultShareTbIdDao;

    @Autowired
    ResultShareTbShareDao resultShareTbShareDao;

    @Autowired
    MAtlasTaskService atlasTaskService;

    @Autowired
    MAnalysisTaskService analysisTaskService;

    @Autowired
    MTskTaskBizService bizService;

    @Autowired
    MTbtskObjectinfoService objectinfoService;

    @Autowired
    MTbtskFieldsService fieldsService;

    @Autowired
    TbtskFieldsDao tbtskFieldsDao;

    @Autowired
    MAppMediaService mediaService;

    @Autowired
    AppMediaDao appMediaDao;

    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;

    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    @Autowired
    AtlasConfig atlasConfig;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    DataBizService dataBizService;

    String shapeField="f_shape";

    String primaryField="f_id";

    @Override
    public ResultShareResultDto shareTb(String id,ObjectReference ref)
    {
        if(ref==null)
        {
            ref = new ObjectReference();
        }
        if(StringUtils.isBlank(id))
        {
            ref.setTag("未设置参数");
            return null;
        }

        ResultShareTbId resultShareTbId = resultShareTbIdDao.gwSearchByPK(id);
        if(resultShareTbId==null)
        {
            ref.setTag("未找到分析任务");
            return null;
        }
        TskTaskBiz taskBiz = bizService.findByTaskId(resultShareTbId.getTaskId());
        if(taskBiz==null)
        {
            ref.setTag("未找到图斑所在任务:"+resultShareTbId.getTaskId());
            return null;
        }

        ResultShareTemplate template = resultShareTemplateService.selectByPrimaryKey(resultShareTbId.getTemplateId());
        if (template == null) {
            ref.setTag("未找到图斑成果分享方案");
            return null;
        }
        if (StringUtils.isBlank(template.getParam())) {
            ref.setTag("图斑成果分享方案参数为空");
            return null;
        }

        ResultShareTbShareDto param = null;
        ResultShareTbShare resultShareTbShare = null;
        String tbWkt="";
        if(StringUtils.isBlank(resultShareTbId.getAnalysisId()))
        {
            resultShareTbShare = resultShareTbShareDao.gwSearchByPK(resultShareTbId.getId());
            param = JSONObject.parseObject(resultShareTbShare.getParam(),ResultShareTbShareDto.class);
            tbWkt = param.getTbWkt();
            if(StringUtils.isBlank(tbWkt)) {
                TbtskObjectinfo objectinfo = objectinfoService.getObjectByTableId(taskBiz.getTableId());
                if (objectinfo == null) {
                    ref.setTag("任务:" + param.getTaskId() + "表对象不存在");
                    return null;
                }
                String sql="select st_astext("+shapeField+") as shapeField  from "+ objectinfo.getfTablename()+" where "+primaryField+"= '"+param.getTbid()+"'";
                List<Map<String,Object>>mapList = jdbcTemplate.queryForList(sql);
                if(mapList==null|| mapList.isEmpty())
                {
                    ref.setTag("图斑:"+param.getTbid()+"不存在");
                    return null;
                }
                tbWkt = mapList.get(0).get("shapeField").toString();
            }
            if(param.getBuffer()!=null)
            {
                String newWkt = buffer(tbWkt,param.getBuffer());
                if(StringUtils.isBlank(newWkt))
                {
                    ref.setTag("图斑范围缓冲失败");
                    return null;
                }
                tbWkt = newWkt;
            }
        }
        else
        {
            param = new ResultShareTbShareDto();
            param.setTemplateId(resultShareTbId.getTemplateId());
            param.setTbid(resultShareTbId.getTbid());
            param.setTaskId(resultShareTbId.getTaskId());
            if(StringUtils.isBlank(tbWkt)) {
                TbtskObjectinfo objectinfo = objectinfoService.getObjectByTableId(taskBiz.getTableId());
                if (objectinfo == null) {
                    ref.setTag("任务:" + param.getTaskId() + "表对象不存在");
                    return null;
                }
                String sql="select st_astext("+shapeField+") as shapeField  from "+ objectinfo.getfTablename()+" where "+primaryField+"= '"+param.getTbid()+"'";
                List<Map<String,Object>>mapList = jdbcTemplate.queryForList(sql);
                if(mapList==null|| mapList.isEmpty())
                {
                    ref.setTag("图斑:"+param.getTbid()+"不存在");
                    return null;
                }
                tbWkt = mapList.get(0).get("shapeField").toString();
            }

        }



        List<ResultShareResultDetailDto> resultDtos = new ArrayList<>();
        ResultShareResultDto result = new ResultShareResultDto();
        result.setTargetTbId(resultShareTbId.getTbid());
        result.setTargetTaskId(taskBiz.getId());
        result.setTargetTaskName(taskBiz.getName());
        result.setShared(true);
        result.setHasResult(false);
        ResultShareTemplateParamDto templateParamDto = JSONObject.parseObject(template.getParam(), ResultShareTemplateParamDto.class);
        List<String>targetGalleryIds = new ArrayList<>();
        targetGalleryIds.add(resultShareTbId.getTbid());
        List<AppMedia> targetAppMedias = appMediaDao.queryByGalleryids(targetGalleryIds);


        for (ResultShareTaskDto sourceTask : templateParamDto.getSourceTaskList()) {
            TskTaskBiz sourceTaskBiz = bizService.findByTaskId(sourceTask.getSourceTaskId());
            ResultShareResultDetailDto resultDto = new ResultShareResultDetailDto();
            if(sourceTaskBiz==null)
            {
                resultDto.setErrMsg("源任务不存在");
                resultDtos.add(resultDto);
                continue;
            }
            resultDto.setTargetTaskId(taskBiz.getId());
            resultDto.setTargetTaskName(taskBiz.getName());
            resultDto.setSourceTaskId(sourceTaskBiz.getId());
            resultDto.setSourceTaskName(sourceTaskBiz.getName());
            resultDto.setTargetTbId(resultShareTbId.getTbid());
            resultDto.setSourceBizType(sourceTask.getBizType());
            resultDto.setTemplateId(template.getId());
            resultDto.setTemplateName(template.getName());
            resultDto.setAutoAttach(templateParamDto.getAutoAttach());
            resultDto.setTranslateType(templateParamDto.getTranslateType());
            resultDto.setHasResult(false);
            TbtskObjectinfo sourceObjectInfo = objectinfoService.getObjectByTableId(sourceTaskBiz.getTableId());
            if (sourceObjectInfo == null) {
                resultDto.setErrMsg("源任务:"+sourceTaskBiz.getId()+"表对象不存在");
                resultDtos.add(resultDto);
                continue;
            }

            String fields=primaryField;
            List<TbtskFields> sourceFields = new ArrayList<>();
            List<ResultShareFieldMappingDto> fieldMap= sourceTask.getFieldMappingList();

            if(fieldMap!=null&&!fieldMap.isEmpty())
            {
                List<String> fieldSqls = new ArrayList<>();
                for (ResultShareFieldMappingDto field : fieldMap) {
                    if(StringUtils.isBlank(field.getSourceFieldId())||StringUtils.isBlank(field.getTargetFieldId()))
                    {
                        continue;
                    }

                    TbtskFields sourceField = tbtskFieldsDao.gwSearchByPK(field.getSourceFieldId());
                    if (sourceField == null) {
                        resultDto.setErrMsg("源任务字段:" + field.getSourceFieldId() + "不存在");
                        resultDtos.add(resultDto);
                        continue;
                    }

                    if(sourceField.getfFieldname().equals(primaryField))
                    {
                        continue;
                    }
                    sourceFields.add(sourceField);
                    fieldSqls.add(sourceField.getfFieldname());



                    /*
                    TbtskFields sourceField = tbtskFieldsDao.gwSearchByPK(field.getSourceFieldId());
                    TbtskFields targetField = tbtskFieldsDao.gwSearchByPK(field.getTargetFieldId());

                    if (sourceField == null) {
                        resultDto.setErrMsg("源任务字段:" + field.getSourceFieldId() + "不存在");
                        resultDtos.add(resultDto);
                        continue;
                    }

                    if (targetField == null) {
                        resultDto.setErrMsg("目标任务字段:" + field.getTargetFieldId() + "不存在");
                        resultDtos.add(resultDto);
                        continue;
                    }
                    if(sourceField.getfFieldname().equals(primaryField)||targetField.getfFieldname().equals(primaryField))
                    {
                        continue;
                    }
                    mapField.put(targetField.getfFieldname(), targetField.getfAlias());
                    fieldSqls.add(sourceField.getfFieldname() + " as " + targetField.getfFieldname());

                    */
                }
                fields += fieldSqls.isEmpty() ? "" : "," + String.join(",", fieldSqls);

            }

            String sql=String.format("select srid from geometry_columns gc  where f_table_name = '%s' and f_geometry_column ='%s'",sourceObjectInfo.getfTablename(),shapeField);
            List<Map<String,Object>>srids = jdbcTemplate.queryForList(sql);
            String srid = srids.get(0).get("srid").toString();
            List<String> wheres = new ArrayList<>();

            if (templateParamDto.getRate1() != null) {
                double v = templateParamDto.getRate1() / 100;

                wheres.add("leftsparkrate >= " + v);
            }
            if (templateParamDto.getRate2() != null) {
                double v = templateParamDto.getRate2() / 100;
                wheres.add("rightsparkrate >= " + v);
            }
            String filter = "";
            if (!wheres.isEmpty()) {
                filter = "where " + String.join(" and ", wheres);
            }
            sql="select %s,f_area2/f_area as leftsparkrate,f_area2/f_area1 as rightsparkrate from (select %s,\n" +
                    "util_computearea(%s) as f_area,\n" +
                    "util_computearea(st_geomfromtext(?,%s)) as f_area1,  \n" +
                    "util_computearea(st_intersection(%s,st_geomfromtext(?,%s))) as f_area2\n" +
                    "from %s  \n" +
                    "where st_intersects(%s,st_geomfromtext(?,%s)) = 'true' )\n" +
                    "t";
            if(StringUtils.isNotBlank(filter))
            {
                sql=" select * from ("+sql+") s "+filter;
            }
            sql=String.format(sql,fields,fields,shapeField,srid,shapeField,srid,sourceObjectInfo.getfTablename(),shapeField,srid);
            Object[]args = new Object[3];
            args[0] = tbWkt;
            args[1] = tbWkt;
            args[2] = tbWkt;


            jdbcTemplate.query(sql, new RowCallbackHandler() {
                @Override
                public void processRow(ResultSet resultSet) throws SQLException {

                    LinkedHashMap<String, Object> map = new LinkedHashMap<>();
                    if (sourceFields!=null&&!sourceFields.isEmpty()) {
                        for (TbtskFields f:sourceFields) {
                            String v = resultSet.getString(f.getfFieldname());
                            map.put(f.getfFieldname(), v);
                        }
                    }
                    result.setHasResult(true);
                    ResultShareResultDetailDto dto = new ResultShareResultDetailDto();
                    try {
                        BeansUtils.overwriteAccessibleProperties(resultDto, dto);
                    } catch (Exception ex)
                    {
                        logger.error("",ex);
                    }
                    dto.setSourceTbId(resultSet.getString(primaryField));

                    if (templateParamDto.getTranslateType().equals(TranslateTypeEnum.attribute.getCode().shortValue()) || templateParamDto.getTranslateType().equals(TranslateTypeEnum.both.getCode().shortValue())) {
                        dto.setAttributes(map);
                        dto.setFields(sourceFields);
                    }
                    if (templateParamDto.getTranslateType().equals(TranslateTypeEnum.media.getCode().shortValue()) || templateParamDto.getTranslateType().equals(TranslateTypeEnum.both.getCode().shortValue())) {

                        List<String> galleryIds = Arrays.asList(dto.getSourceTbId());
                        List<AppMedia> appMediaList = mediaService.queryByGalleryids(galleryIds);
                        List<AppMediaCopyDto> appMediaCopyDtos = new ArrayList<>();
                        if (appMediaList != null) {
                            for (AppMedia appMedia : appMediaList) {
                                AppMediaCopyDto appMediaCopyDto = new AppMediaCopyDto();
                                if(templateParamDto.getAutoAttach())
                                {
                                    try {
                                        Boolean hasCopy=false;
                                        if (targetAppMedias!=null&&targetAppMedias.stream().filter(t->StringUtils.isNotBlank(t.getCopyid())&&t.getCopyid().equals(appMedia.getId())).findFirst().isPresent()) {
                                            hasCopy=true;
                                        }
                                        if(!hasCopy)
                                        {
                                            String sourceUrl = appMedia.getServerpath();
                                            /*
                                            String ext = StringUtils.substring(appMedia.getServerpath(), appMedia.getServerpath().lastIndexOf("."));
                                            String newId =UUID.randomUUID().toString();
                                            sourceUrl = getShortPath(sourceUrl);
                                            String newUrl = defaultOssOperatorService.copyObject(sourceUrl, "media/" +newId + ext);
                                            */
                                            AppMedia newAppMedia = new AppMedia();
                                            BeansUtils.overwriteAccessibleProperties(appMedia, newAppMedia);
                                            newAppMedia.setId(UUID.randomUUID().toString());
                                            newAppMedia.setGalleryid(dto.getTargetTbId());
                                            //newAppMedia.setBizid(task.getTaskId());
                                            Integer group=1;
                                            if(templateParamDto.getGroupCode()!=null)
                                            {
                                                group=templateParamDto.getGroupCode();
                                            }
                                            newAppMedia.setGroupCode(group);
                                            newAppMedia.setServerpath(sourceUrl);
                                            newAppMedia.setCopyid(appMedia.getId());
                                            mediaService.saveOne(newAppMedia);
                                        }


                                        BeansUtils.overwriteAccessibleProperties(appMedia, appMediaCopyDto);
                                        String temporarySignedUrl = temporarySignedUrlService.getTemporarySignedUrl("", appMediaCopyDto.getServerpath(), null);
                                        appMediaCopyDto.setServerpath(temporarySignedUrl);
                                        appMediaCopyDto.setHasCopy(true);
                                    } catch (Exception ex) {
                                        logger.error("", ex);
                                    }
                                }
                                else
                                {
                                    try {
                                        BeansUtils.overwriteAccessibleProperties(appMedia, appMediaCopyDto);
                                        String temporarySignedUrl = temporarySignedUrlService.getTemporarySignedUrl("", appMediaCopyDto.getServerpath(), null);
                                        appMediaCopyDto.setServerpath(temporarySignedUrl);
                                    } catch (Exception ex) {
                                        logger.error("", ex);
                                    }
                                    if (targetAppMedias!=null&&targetAppMedias.stream().filter(t->StringUtils.isNotBlank(t.getCopyid())&&t.getCopyid().equals(appMedia.getId())).findFirst().isPresent()) {
                                        appMediaCopyDto.setHasCopy(true);
                                    }
                                }

                                appMediaCopyDtos.add(appMediaCopyDto);
                            }

                        }
                        dto.setAppMediaList(appMediaCopyDtos);
                        result.setHasResult(true);
                    }
                    dto.setHasResult(true);
                    resultDtos.add(dto);
                }
            },args);


        }
        result.setDetail(resultDtos);

        resultShareTbId.setAnalysisId("");
        resultShareTbIdDao.gwUpdateByPK(resultShareTbId);
        resultDtos.forEach(t->{t.setId(resultShareTbId.getId());t.setAnalysisId(resultShareTbId.getId());});
        if(resultShareTbShare==null)
        {
            resultShareTbShare = new ResultShareTbShare();
            resultShareTbShare.setId(resultShareTbId.getId());
            resultShareTbShare.setParam(JSONObject.toJSONString(param));
            resultShareTbShare.setResult(JSONObject.toJSONString(result));
            resultShareTbShareDao.gwAccess(resultShareTbShare);
        }
        else
        {
            resultShareTbShare.setResult(JSONObject.toJSONString(result));
            resultShareTbShareDao.gwUpdateByPK(resultShareTbShare);
        }

        return result;
    }

    @Override
    public ResultShareResultDto shareTb(ResultShareTbShareDto param,ObjectReference ref)
    {
        if(ref==null)
        {
            ref = new ObjectReference();
        }
        if(param==null)
        {
            ref.setTag("未设置参数");
            return null;
        }
        if(StringUtils.isBlank(param.getTaskId()))
        {
            ref.setTag("未设置任务id");
            return null;
        }
        if(StringUtils.isBlank(param.getTbid()))
        {
            ref.setTag("未设置图斑id");
            return null;
        }
        if(StringUtils.isBlank(param.getTemplateId()))
        {
            ref.setTag("未设置方案id");
            return null;
        }
        TskTaskBiz taskBiz = bizService.findByTaskId(param.getTaskId());
        if(taskBiz==null)
        {
            ref.setTag("任务:"+param.getTaskId()+"不存在");
            return null;
        }
        String tbWkt = param.getTbWkt();
        if(StringUtils.isBlank(param.getTbWkt())) {
            TbtskObjectinfo objectinfo = objectinfoService.getObjectByTableId(taskBiz.getTableId());
            if (objectinfo == null) {
                ref.setTag("任务:" + param.getTaskId() + "表对象不存在");
                return null;
            }
            String sql="select st_astext("+shapeField+") as shapeField  from "+ objectinfo.getfTablename()+" where "+primaryField+"= '"+param.getTbid()+"'";
            List<Map<String,Object>>mapList = jdbcTemplate.queryForList(sql);
            if(mapList==null|| mapList.isEmpty())
            {
                ref.setTag("图斑:"+param.getTbid()+"不存在");
                return null;
            }
            tbWkt = mapList.get(0).get("shapeField").toString();
        }
        if(param.getBuffer()!=null)
        {
             String newWkt = buffer(tbWkt,param.getBuffer());
             if(StringUtils.isBlank(newWkt))
             {
                 ref.setTag("图斑范围缓冲失败");
                 return null;
             }
             tbWkt = newWkt;
        }


        ResultShareTemplate template = resultShareTemplateService.selectByPrimaryKey(param.getTemplateId());
        if (template == null) {
            ref.setTag("未找到图斑成果分享方案");
            return null;
        }
        if (StringUtils.isBlank(template.getParam())) {
            ref.setTag("图斑成果分享方案参数为空");
            return null;
        }
        List<ResultShareResultDetailDto> resultDtos = new ArrayList<>();
        ResultShareResultDto result = new ResultShareResultDto();
        result.setTargetTbId(param.getTbid());
        result.setTargetTaskId(param.getTaskId());
        result.setTargetTaskName(taskBiz.getName());
        result.setShared(true);
        result.setHasResult(false);
        ResultShareTemplateParamDto templateParamDto = JSONObject.parseObject(template.getParam(), ResultShareTemplateParamDto.class);
        List<String>targetGalleryIds = new ArrayList<>();
        targetGalleryIds.add(param.getTbid());
        List<AppMedia> targetAppMedias = appMediaDao.queryByGalleryids(targetGalleryIds);


        for (ResultShareTaskDto sourceTask : templateParamDto.getSourceTaskList()) {
            TskTaskBiz sourceTaskBiz = bizService.findByTaskId(sourceTask.getSourceTaskId());
            ResultShareResultDetailDto resultDto = new ResultShareResultDetailDto();
            if(sourceTaskBiz==null)
            {
                resultDto.setErrMsg("源任务不存在");
                resultDtos.add(resultDto);
                continue;
            }
            resultDto.setTargetTaskId(taskBiz.getId());
            resultDto.setTargetTaskName(taskBiz.getName());
            resultDto.setSourceTaskId(sourceTaskBiz.getId());
            resultDto.setSourceTaskName(sourceTaskBiz.getName());
            resultDto.setTargetTbId(param.getTbid());
            resultDto.setSourceBizType(sourceTask.getBizType());
            resultDto.setTemplateId(template.getId());
            resultDto.setTemplateName(template.getName());
            resultDto.setAutoAttach(templateParamDto.getAutoAttach());
            resultDto.setTranslateType(templateParamDto.getTranslateType());
            resultDto.setHasResult(false);
            TbtskObjectinfo sourceObjectInfo = objectinfoService.getObjectByTableId(sourceTaskBiz.getTableId());
            if (sourceObjectInfo == null) {
                resultDto.setErrMsg("源任务:"+sourceTaskBiz.getId()+"表对象不存在");
                resultDtos.add(resultDto);
                continue;
            }

            String fields=primaryField;
            List<TbtskFields> sourceFields = new ArrayList<>();
            List<ResultShareFieldMappingDto> fieldMap= sourceTask.getFieldMappingList();

            if(fieldMap!=null&&!fieldMap.isEmpty())
            {
                List<String> fieldSqls = new ArrayList<>();
                for (ResultShareFieldMappingDto field : fieldMap) {
                    if(StringUtils.isBlank(field.getSourceFieldId())||StringUtils.isBlank(field.getTargetFieldId()))
                    {
                        continue;
                    }

                    TbtskFields sourceField = tbtskFieldsDao.gwSearchByPK(field.getSourceFieldId());
                    if (sourceField == null) {
                        resultDto.setErrMsg("源任务字段:" + field.getSourceFieldId() + "不存在");
                        resultDtos.add(resultDto);
                        continue;
                    }

                    if(sourceField.getfFieldname().equals(primaryField))
                    {
                        continue;
                    }
                    sourceFields.add(sourceField);
                    fieldSqls.add(sourceField.getfFieldname());



                    /*
                    TbtskFields sourceField = tbtskFieldsDao.gwSearchByPK(field.getSourceFieldId());
                    TbtskFields targetField = tbtskFieldsDao.gwSearchByPK(field.getTargetFieldId());

                    if (sourceField == null) {
                        resultDto.setErrMsg("源任务字段:" + field.getSourceFieldId() + "不存在");
                        resultDtos.add(resultDto);
                        continue;
                    }

                    if (targetField == null) {
                        resultDto.setErrMsg("目标任务字段:" + field.getTargetFieldId() + "不存在");
                        resultDtos.add(resultDto);
                        continue;
                    }
                    if(sourceField.getfFieldname().equals(primaryField)||targetField.getfFieldname().equals(primaryField))
                    {
                        continue;
                    }
                    mapField.put(targetField.getfFieldname(), targetField.getfAlias());
                    fieldSqls.add(sourceField.getfFieldname() + " as " + targetField.getfFieldname());

                    */
                }
                fields += fieldSqls.isEmpty() ? "" : "," + String.join(",", fieldSqls);

            }

            String sql=String.format("select srid from geometry_columns gc  where f_table_name = '%s' and f_geometry_column ='%s'",sourceObjectInfo.getfTablename(),shapeField);
            List<Map<String,Object>>srids = jdbcTemplate.queryForList(sql);
            String srid = srids.get(0).get("srid").toString();
            List<String> wheres = new ArrayList<>();

            if (templateParamDto.getRate1() != null) {
                double v = templateParamDto.getRate1() / 100;

                wheres.add("leftsparkrate >= " + v);
            }
            if (templateParamDto.getRate2() != null) {
                double v = templateParamDto.getRate2() / 100;
                wheres.add("rightsparkrate >= " + v);
            }
            String filter = "";
            if (!wheres.isEmpty()) {
                filter = "where " + String.join(" and ", wheres);
            }
            sql="select %s,f_area2/f_area as leftsparkrate,f_area2/f_area1 as rightsparkrate from (select %s,\n" +
                    "util_computearea(%s) as f_area,\n" +
                    "util_computearea(st_geomfromtext(?,%s)) as f_area1,  \n" +
                    "util_computearea(st_intersection(%s,st_geomfromtext(?,%s))) as f_area2\n" +
                    "from %s  \n" +
                    "where st_intersects(%s,st_geomfromtext(?,%s)) = 'true' )\n" +
                    "t";
            if(StringUtils.isNotBlank(filter))
            {
                sql=" select * from ("+sql+") s "+filter;
            }
            sql=String.format(sql,fields,fields,shapeField,srid,shapeField,srid,sourceObjectInfo.getfTablename(),shapeField,srid);
            Object[]args = new Object[3];
            args[0] = tbWkt;
            args[1] = tbWkt;
            args[2] = tbWkt;


            jdbcTemplate.query(sql, new RowCallbackHandler() {
                @Override
                public void processRow(ResultSet resultSet) throws SQLException {

                    LinkedHashMap<String, Object> map = new LinkedHashMap<>();
                    if (sourceFields!=null&&!sourceFields.isEmpty()) {
                        for (TbtskFields f:sourceFields) {
                            String v = resultSet.getString(f.getfFieldname());
                            map.put(f.getfFieldname(), v);
                        }
                    }
                    result.setHasResult(true);
                    ResultShareResultDetailDto dto = new ResultShareResultDetailDto();
                    try {
                        BeansUtils.overwriteAccessibleProperties(resultDto, dto);
                    } catch (Exception ex)
                    {
                        logger.error("",ex);
                    }
                    dto.setSourceTbId(resultSet.getString(primaryField));

                    if (templateParamDto.getTranslateType().equals(TranslateTypeEnum.attribute.getCode().shortValue()) || templateParamDto.getTranslateType().equals(TranslateTypeEnum.both.getCode().shortValue())) {
                        dto.setAttributes(map);
                        dto.setFields(sourceFields);
                    }
                    if (templateParamDto.getTranslateType().equals(TranslateTypeEnum.media.getCode().shortValue()) || templateParamDto.getTranslateType().equals(TranslateTypeEnum.both.getCode().shortValue())) {

                        List<String> galleryIds = Arrays.asList(dto.getSourceTbId());
                        List<AppMedia> appMediaList = mediaService.queryByGalleryids(galleryIds);
                        List<AppMediaCopyDto> appMediaCopyDtos = new ArrayList<>();
                        if (appMediaList != null) {
                            for (AppMedia appMedia : appMediaList) {
                                AppMediaCopyDto appMediaCopyDto = new AppMediaCopyDto();
                                if(templateParamDto.getAutoAttach())
                                {
                                    try {
                                        Boolean hasCopy=false;
                                        if (targetAppMedias!=null&&targetAppMedias.stream().filter(t->StringUtils.isNotBlank(t.getCopyid())&&t.getCopyid().equals(appMedia.getId())).findFirst().isPresent()) {
                                            hasCopy=true;
                                        }
                                        if(!hasCopy) {
                                            String sourceUrl = appMedia.getServerpath();
                                            /*
                                            String ext = StringUtils.substring(appMedia.getServerpath(), appMedia.getServerpath().lastIndexOf("."));
                                            String newId = UUID.randomUUID().toString();
                                            sourceUrl = getShortPath(sourceUrl);
                                            String newUrl = defaultOssOperatorService.copyObject(sourceUrl, "media/" + newId + ext);
                                            */
                                            AppMedia newAppMedia = new AppMedia();
                                            BeansUtils.overwriteAccessibleProperties(appMedia, newAppMedia);
                                            newAppMedia.setId(UUID.randomUUID().toString());
                                            newAppMedia.setGalleryid(dto.getTargetTbId());
                                            //newAppMedia.setBizid(task.getTaskId());
                                            Integer group = 1;
                                            if (templateParamDto.getGroupCode() != null) {
                                                group = templateParamDto.getGroupCode();
                                            }
                                            newAppMedia.setGroupCode(group);
                                            newAppMedia.setServerpath(sourceUrl);
                                            newAppMedia.setCopyid(appMedia.getId());
                                            mediaService.saveOne(newAppMedia);
                                        }

                                        BeansUtils.overwriteAccessibleProperties(appMedia, appMediaCopyDto);
                                        String temporarySignedUrl = temporarySignedUrlService.getTemporarySignedUrl("", appMediaCopyDto.getServerpath(), null);
                                        appMediaCopyDto.setServerpath(temporarySignedUrl);
                                        appMediaCopyDto.setHasCopy(true);
                                    } catch (Exception ex) {
                                        logger.error("", ex);
                                    }
                                }
                                else
                                {
                                    try {
                                        BeansUtils.overwriteAccessibleProperties(appMedia, appMediaCopyDto);
                                        String temporarySignedUrl = temporarySignedUrlService.getTemporarySignedUrl("", appMediaCopyDto.getServerpath(), null);
                                        appMediaCopyDto.setServerpath(temporarySignedUrl);
                                    } catch (Exception ex) {
                                        logger.error("", ex);
                                    }
                                    if (targetAppMedias!=null&&targetAppMedias.stream().filter(t->StringUtils.isNotBlank(t.getCopyid())&&t.getCopyid().equals(appMedia.getId())).findFirst().isPresent()) {
                                        appMediaCopyDto.setHasCopy(true);
                                    }
                                }

                                appMediaCopyDtos.add(appMediaCopyDto);
                            }

                        }
                        dto.setAppMediaList(appMediaCopyDtos);
                        result.setHasResult(true);
                    }
                    dto.setHasResult(true);
                    resultDtos.add(dto);
                }
            },args);


        }
        result.setDetail(resultDtos);
        ResultShareTbId resultShareTbId = new ResultShareTbId();
        resultShareTbId.setId(UUID.randomUUID().toString());
        resultShareTbId.setTaskId(param.getTaskId());
        resultShareTbId.setTbid(param.getTbid());
        resultShareTbId.setTemplateId(template.getId());
        resultShareTbId.setCreateTime(new Date());
        resultShareTbIdDao.gwAccess(resultShareTbId);

        resultDtos.forEach(t->{t.setId(resultShareTbId.getId());t.setAnalysisId(resultShareTbId.getId());});

        ResultShareTbShare resultShareTbShare = new ResultShareTbShare();
        resultShareTbShare.setId(resultShareTbId.getId());
        resultShareTbShare.setParam(JSONObject.toJSONString(param));
        resultShareTbShare.setResult(JSONObject.toJSONString(result));
        resultShareTbShareDao.gwAccess(resultShareTbShare);



        return result;
    }


    @Override
    public ResultShareTask shareTbs(ResultShareTbsShareDto param,Long userid, ObjectReference ref)
    {
        if(ref==null)
        {
            ref = new ObjectReference();
        }
        if(param==null)
        {
            ref.setTag("未设置参数");
            return null;
        }
        if(StringUtils.isBlank(param.getTaskId()))
        {
            ref.setTag("未设置任务id");
            return null;
        }

        if(StringUtils.isBlank(param.getTemplateId()))
        {
            ref.setTag("未设置方案id");
            return null;
        }
        TaskQueryParameter queryParameter = param.getQueryParameter();
        if(queryParameter==null&&(param.getTbids()==null||param.getTbids().isEmpty()))
        {
            ref.setTag("未设置图斑id");
            return null;
        }

        TskTaskBiz taskBiz = bizService.findByTaskId(param.getTaskId());
        if(taskBiz==null)
        {
            ref.setTag("任务:"+param.getTaskId()+"不存在");
            return null;
        }
        ResultShareTemplate template = resultShareTemplateService.selectByPrimaryKey(param.getTemplateId());
        if (template == null) {
            ref.setTag("未找到图斑成果分享方案");
            return null;
        }
        if (StringUtils.isBlank(template.getParam())) {
            ref.setTag("图斑成果分享方案参数为空");
            return null;
        }
        ResultShareTemplateParamDto templateParamDto = JSONObject.parseObject(template.getParam(),ResultShareTemplateParamDto.class);

        ResultShareTask resultShareTask = new ResultShareTask();
        resultShareTask.setId(UUID.randomUUID().toString());
        resultShareTask.setName(taskBiz.getName()+"_成果分享");
        resultShareTask.setTaskId(taskBiz.getId());
        resultShareTask.setStatus(AnalysisTaskStateEnum.create.getCode().shortValue());
        resultShareTask.setCreateTime(new Date());
        resultShareTask.setTemplateId(template.getId());
        resultShareTask.setAutoAttach(0);
        resultShareTask.setDelete(Short.valueOf("0"));
        if(templateParamDto.getAutoAttach()!=null&&templateParamDto.getAutoAttach())
        {
            resultShareTask.setAutoAttach(1);
        }
        resultShareTask.setUserId(String.valueOf(userid));
        if(param.getTbids()!=null&&!param.getTbids().isEmpty())
        {
            List<ResultShareTbId>tbids = new ArrayList<>();
            for (String id:param.getTbids()) {
                ResultShareTbId tbid = new ResultShareTbId();
                tbid.setId(UUID.randomUUID().toString());
                tbid.setTbid(id);
                tbid.setAnalysisId(resultShareTask.getId());
                tbid.setTaskId(resultShareTask.getTaskId());
                tbid.setTemplateId(resultShareTask.getTemplateId());
                tbids.add(tbid);
            }
            resultShareTbIdDao.batchInsert(tbids);
        }
        else {
            try {
                queryParameter.setTaskId(resultShareTask.getTaskId());
                queryParameter.setUserId(userid);
                Pair<String, String> queryParamPair = bizService.parseQueryParameter(queryParameter);
                String tableName = queryParamPair.getLeft();
                String where = queryParamPair.getRight();
                if(StringUtils.isNotBlank(where))
                {
                    where = " where "+ where;
                }
                String sql=String.format("insert into tb_result_share_tbid(f_id,f_tbid,f_analysisId,f_taskId,f_templateId,f_createtime) select CAST(uuid_generate_v4() as varchar(50)) as f_id, %s as f_tbid,'%s' as f_analysisId,'%s' as f_taskId,'%s' as f_templateId,now() from %s %s",primaryField,resultShareTask.getId(),resultShareTask.getTaskId(),resultShareTask.getTemplateId(),tableName,where);
                jdbcTemplate.execute(sql);
            }
            catch (Exception ex)
            {
                logger.error("批量写入tb_result_share_tbid表失败",ex);
                ref.setTag("创建分析任务图斑表记录失败");
                return null;
            }
        }

        resultShareTaskService.insert(resultShareTask);
        return resultShareTask;
    }

    @Override
    public List<ResultShareTaskInfoDto>getTaskInfo(String taskId,Long userId)
    {
        return resultShareTaskService.selecteTaskInfo(taskId,String.valueOf(userId));
    }

    @Override
    public Map startTask(String id) {


        Map retVal = new HashMap();
        retVal.put("result", false);
        retVal.put("data", "");
        retVal.put("error", StringUtils.EMPTY);

        ResultShareTask translateTask = resultShareTaskService.select(id);
        if (translateTask == null) {
            retVal.put("error", "成果共享任务:" + id + "不存在");
            return retVal;
        }
        Integer count = resultShareTbIdDao.countByAnalysisId(translateTask.getId());
        if(count==0)
        {
            if(translateTask.getAutoAttach()!=null&&translateTask.getAutoAttach().equals(1)){
                resultShareTaskService.startTask(id, AnalysisTaskStateEnum.relation.getCode().shortValue(),"无图斑数据待执行成果分享");
            }
            else {
                resultShareTaskService.startTask(id, AnalysisTaskStateEnum.success.getCode().shortValue(),"无图斑数据待执行成果分享");
            }
            //说明入库图斑全部重复了
            retVal.put("result", true);
            retVal.put("data", "");
            retVal.put("error", "无图斑数据待执行成果分享");
            return retVal;
        }


        TskTaskBiz taskBiz =  bizService.getTskTaskBizById(translateTask.getTaskId());
        if (taskBiz == null) {
            retVal.put("error", "成果共享目标任务:" + translateTask.getTaskId() + "不存在");
            resultShareTaskService.startTask(id, AnalysisTaskStateEnum.error.getCode().shortValue(),"成果共享目标任务:" + translateTask.getTaskId() + "不存在");
            return retVal;
        }
        TbtskObjectinfo objectinfo = objectinfoService.getObjectByTableId(taskBiz.getTableId());
        if (objectinfo == null) {
            retVal.put("error", "成果共享目标任务表对象:" + taskBiz.getTableId() + "不存在");
            resultShareTaskService.startTask(id, AnalysisTaskStateEnum.error.getCode().shortValue(),"成果共享目标任务表对象:" + taskBiz.getTableId() + "不存在");
            return retVal;
        }
        resultShareTaskDetailService.deleteByAnalysisId(id);
        ResultShareTemplate template = resultShareTemplateService.selectByPrimaryKey(translateTask.getTemplateId());
        if (template == null) {
            retVal.put("error", "成果共享任务:" + id + "方案:" + translateTask.getTemplateId() + " 不存在");
            resultShareTaskService.startTask(id, AnalysisTaskStateEnum.error.getCode().shortValue(),"成果共享任务:" + id + "方案:" + translateTask.getTemplateId() + " 不存在");
            return retVal;
        }
        if (StringUtils.isBlank(template.getParam())) {
            retVal.put("error", "成果共享任务:" + id + "方案:" + translateTask.getTemplateId() + " 参数为空");
            resultShareTaskService.startTask(id, AnalysisTaskStateEnum.error.getCode().shortValue(),"方案:" + translateTask.getTemplateId() + " 参数为空");
            return retVal;
        }

        ResultShareTemplateParamDto templateParamDto = JSONObject.parseObject(template.getParam(), ResultShareTemplateParamDto.class);
        for (ResultShareTaskDto sourceTask : templateParamDto.getSourceTaskList()) {
            ResultShareTaskDetail detail = new ResultShareTaskDetail();
            detail.setId(UUID.randomUUID().toString());
            detail.setName("叠加_" + sourceTask.getSourceTaskName());
            detail.setAnalysisId(translateTask.getId());
            detail.setTaskId(sourceTask.getSourceTaskId());
            detail.setStatus(AnalysisTaskStateEnum.create.getCode().shortValue());
            detail.setResultname("trans_"+detail.getId().replace("-",""));
            detail.setCreateTime(new Date());
            detail.setStartTime(new Date());
            ObjectReference ref = new ObjectReference();
            String atlasId =  createTask(taskBiz,objectinfo,detail,sourceTask,ref);
            detail.setAtlasId(atlasId);
            if(StringUtils.isBlank(atlasId)) {
                detail.setStatus(AnalysisTaskStateEnum.error.getCode().shortValue());
                detail.setMsg(ref.getTag());
            }
            else
            {
                if(startTask(atlasId,ref))
                {
                    detail.setStatus(AnalysisTaskStateEnum.runing.getCode().shortValue());
                }
                else
                {
                    detail.setStatus(AnalysisTaskStateEnum.error.getCode().shortValue());
                    detail.setMsg(ref.getTag());
                }
            }
            resultShareTaskDetailService.insert(detail);
            if(detail.getStatus().equals(AnalysisTaskStateEnum.error.getCode().shortValue()))
            {
                TableUtil.dropTable(detail.getTempLeft(),jdbcTemplate);
            }
        }
        resultShareTaskService.startTask(id, AnalysisTaskStateEnum.runing.getCode().shortValue(),"");
        retVal.put("result", true);
        retVal.put("data", "");
        retVal.put("error", StringUtils.EMPTY);
        return retVal;
    }

    @Override
    public AnalysisTaskDto getAnalysisTaskState(String atlasId)
    {
        if(atlasConfig.getUseAtlas())
        {
            return   atlasTaskService.getAnalysisTaskState(atlasId);
        }
        else
        {
            return  analysisTaskService.getAnalysisTaskState(atlasId);
        }
    }
    @Override
    public Boolean attach(ResultShareTask task, ResultShareTemplateParamDto templateParamDto, ResultShareTaskDetail detail, ObjectReference ref)
    {
        if(templateParamDto==null)
        {
            logger.error("成果共享方案对象为空");
            return false;
        }
        TskTaskBiz targetTaskBiz = bizService.getTskTaskBizById(task.getTaskId());
        if(targetTaskBiz==null)
        {
            logger.error("任务:"+task.getTaskId()+"不存在");
            return false;
        }
        TbtskObjectinfo objectinfo = bizService.getTableByTableId(targetTaskBiz.getTableId());
        if(objectinfo==null)
        {
            logger.error("任务:"+task.getTaskId()+"表对象不存在");
            return false;
        }
        List<TbtskFields>targetFields = fieldsService.getAllFieldsByTableID(targetTaskBiz.getTableId());
        Optional<TbtskFields> opTarget = targetFields.stream().filter(t->t.getfFieldname().equals(primaryField)).findFirst();
        if(!opTarget.isPresent())
        {
            ref.setTag("成果共享目标任务:"+task.getTaskId()+"未设置主键字段");
            return false;
        }
        TskTaskBiz sourceTaskBiz = bizService.getTskTaskBizById(detail.getTaskId());
        if(sourceTaskBiz==null)
        {
            logger.error("任务:"+detail.getTaskId()+"不存在");
            return false;
        }
        List<TbtskFields>sourceFields = fieldsService.getAllFieldsByTableID(sourceTaskBiz.getTableId());
        Optional<TbtskFields> opSource = sourceFields.stream().filter(t->t.getfFieldname().equals(primaryField)).findFirst();
        if(!opSource.isPresent())
        {
            ref.setTag("成果共享源任务:"+detail.getTaskId()+"未设置主键字段");
            return false;
        }
        if(!TableUtil.hasField(objectinfo.getfTablename(),"f_updatetime",jdbcTemplate))
        {
            TableUtil.addField(objectinfo.getfTablename(),"f_updatetime",jdbcTemplate);
        }
        List<String> wheres=new ArrayList<>();
        if(templateParamDto.getRate1()!=null)
        {
            double v = templateParamDto.getRate1() / 100;

            wheres.add("leftsparkrate >= " + v);
        }
        if(templateParamDto.getRate2()!=null)
        {
            double v = templateParamDto.getRate2() / 100;
            wheres.add("rightsparkrate >= " + v);
        }
        String filter="";
        if(!wheres.isEmpty())
        {
            filter ="where " + String.join(" and ",wheres);
        }
        if(templateParamDto.getTranslateType().equals(TranslateTypeEnum.media.getCode().shortValue())||templateParamDto.getTranslateType().equals(TranslateTypeEnum.both.getCode().shortValue()))
        {
            String sql=String.format("select distinct %s,%s from %s  %s",opTarget.get().getfFieldname()+"_1",opSource.get().getfFieldname()+"_2",detail.getResultname(),filter);
            List<Map<String,Object>>maps = jdbcTemplate.queryForList(sql);
            if(maps!=null&&!maps.isEmpty())
            {
                List<AppMedia>insertAppMedia = new ArrayList<>();
                Set<String>updateTbids = new HashSet<>();
                for (Map map:maps) {
                  String targetId = map.get(opTarget.get().getfFieldname()+"_1").toString();
                  String sourceId = map.get(opSource.get().getfFieldname()+"_2").toString();
                  List<String>galleryIds = Arrays.asList(sourceId);
                  List<AppMedia>appMediaList = mediaService.queryByGalleryids(galleryIds);

                  if(appMediaList!=null)
                  {
                      List<String>targetGalleryIds = new ArrayList<>();
                      targetGalleryIds.add(targetId);
                      List<AppMedia>targetMedias = appMediaDao.queryByGalleryids(targetGalleryIds);
                      for (AppMedia appMedia:appMediaList) {

                          if(targetMedias!=null&& targetMedias.stream().filter(t->StringUtils.isNotBlank(t.getCopyid())&& t.getCopyid().equals(appMedia.getId())).findFirst().isPresent())
                          {
                              continue;
                          }
                          if(StringUtils.isNotBlank(appMedia.getServerpath()))
                          {
                              try {
                                  String sourceUrl = appMedia.getServerpath();
                                  String newId =UUID.randomUUID().toString();
                                  /*
                                  sourceUrl = getShortPath(sourceUrl);
                                  String ext = StringUtils.substring(appMedia.getServerpath(), appMedia.getServerpath().lastIndexOf("."));

                                  String newUrl = defaultOssOperatorService.copyObject(sourceUrl, "media/" +newId + ext);
                                  */
                                  if(StringUtils.isNotBlank(sourceUrl))
                                  {
                                      updateTbids.add(targetId);
                                      AppMedia newAppMedia = new AppMedia();
                                      BeansUtils.overwriteAccessibleProperties(appMedia, newAppMedia);
                                      newAppMedia.setId(newId);
                                      newAppMedia.setGalleryid(targetId);
                                      //newAppMedia.setBizid(task.getTaskId());
                                      Integer group=1;
                                      if(templateParamDto.getGroupCode()!=null)
                                      {
                                          group=templateParamDto.getGroupCode();
                                      }
                                      newAppMedia.setGroupCode(group);
                                      newAppMedia.setServerpath(sourceUrl);
                                      newAppMedia.setCopyid(appMedia.getId());
                                      insertAppMedia.add(newAppMedia);
                                      if(insertAppMedia.size()==100)
                                      {
                                          mediaService.save(insertAppMedia);
                                          insertAppMedia.clear();
                                      }
                                      if(updateTbids.size()==100)
                                      {
                                          Map<String,Object>up = new HashMap<>();
                                          up.put("f_updatetime",String.valueOf(System.currentTimeMillis()));
                                          String  where = "f_id in ('"+StringUtils.join(updateTbids,"','")+"')";
                                          dataBizService.updateData(objectinfo.getfTablename(),up,where);
                                          updateTbids.clear();
                                      }
                                  }
                              }
                              catch (Exception ex)
                              {
                                  logger.error("成果共享 多媒体数据:"+appMedia.getId()+"共享失败",ex);
                              }
                          }

                      }
                  }
                }
                if(!insertAppMedia.isEmpty())
                {
                    mediaService.save(insertAppMedia);
                    insertAppMedia.clear();
                }
                if(!updateTbids.isEmpty())
                {
                    Map<String,Object>up = new HashMap<>();
                    up.put("f_updatetime",String.valueOf(System.currentTimeMillis()));
                    String  where = "f_id in ('"+StringUtils.join(updateTbids,"','")+"')";
                    dataBizService.updateData(objectinfo.getfTablename(),up,where);
                    updateTbids.clear();
                }
            }

        }

        return true;
    }


    @Override
    public  Boolean attach(ResultShareAttachDto attach,ObjectReference ref)
    {

        if(ref==null)
        {
            ref = new ObjectReference();
        }
        try {
            if (attach == null) {
                ref.setTag("待挂接数据为空");
                return false;
            }
            if (StringUtils.isBlank(attach.getTargetTbid())) {
                ref.setTag("待挂接目标数据为空");
                return false;
            }
            if (StringUtils.isBlank(attach.getSourceMediaId())) {
                ref.setTag("待挂接多媒体数据为空");
                return false;
            }
            if (StringUtils.isBlank(attach.getTemplateId())) {
                ref.setTag("挂接方案为空");
                return false;
            }
            ResultShareTemplate template = resultShareTemplateService.selectByPrimaryKey(attach.getTemplateId());
            if (template == null) {
                ref.setTag("成果分享方案不存在");
                return false;
            }
            if (StringUtils.isBlank(template.getParam())) {
                ref.setTag("成果分享方案参数为空");
                return false;
            }

            TskTaskBiz targetTaskBiz = bizService.getTskTaskBizById(template.getTargetTaskId());
            if(targetTaskBiz==null)
            {
                logger.error("任务:"+template.getTargetTaskId()+"不存在");
                return false;
            }
            TbtskObjectinfo objectinfo = bizService.getTableByTableId(targetTaskBiz.getTableId());
            if(objectinfo==null)
            {
                logger.error("任务:"+template.getTargetTaskId()+"表对象不存在");
                return false;
            }

            String [] sourceMediaIds = attach.getSourceMediaId().split(",");
            List<AppMedia>sourceMedias = appMediaDao.queryByIds(Arrays.stream(sourceMediaIds).collect(Collectors.toList()));
            //AppMedia sourceMedia = appMediaDao.gwSearchByPK(attach.getSourceMediaId());
            if(sourceMedias==null||sourceMedias.isEmpty())
            {
                ref.setTag("源多媒体记录不存在");
                return false;
            }
            List<String>tbids = new ArrayList<>();
            tbids.add(attach.getTargetTbid());
            List<AppMedia>targetMedias = appMediaDao.queryByGalleryids(tbids);
            ResultShareTemplateParamDto param = JSONObject.parseObject(template.getParam(), ResultShareTemplateParamDto.class);
            boolean updateTb=false;
            for (AppMedia sourceMedia:sourceMedias) {
                if(targetMedias!=null&& targetMedias.stream().filter(t->StringUtils.isNotBlank(t.getCopyid())&&t.getCopyid().equals(sourceMedia.getId())).findFirst().isPresent())
                {
                    continue;
                }
                String sourceUrl = sourceMedia.getServerpath();
                /*
                sourceUrl = getShortPath(sourceUrl);
                String ext = StringUtils.substring(sourceMedia.getServerpath(), sourceMedia.getServerpath().lastIndexOf("."));
                String newId = UUID.randomUUID().toString();
                String newUrl = defaultOssOperatorService.copyObject(sourceUrl, "media/" + newId + ext);
                */
                AppMedia newAppMedia = new AppMedia();
                BeansUtils.overwriteAccessibleProperties(sourceMedia, newAppMedia);
                newAppMedia.setId(UUID.randomUUID().toString());
                newAppMedia.setGalleryid(attach.getTargetTbid());
                //newAppMedia.setBizid(task.getTaskId());
                Integer group=1;
                if(param.getGroupCode()!=null)
                {
                    group=param.getGroupCode();
                }
                newAppMedia.setGroupCode(group);
                newAppMedia.setServerpath(sourceUrl);
                newAppMedia.setCopyid(sourceMedia.getId());
                mediaService.saveOne(newAppMedia);
                updateTb=true;
            }
            if(updateTb)
            {
                if(!TableUtil.hasField(objectinfo.getfTablename(),"f_updatetime",jdbcTemplate))
                {
                    TableUtil.addField(objectinfo.getfTablename(),"f_updatetime",jdbcTemplate);
                }
                Map<String,Object>up = new HashMap<>();
                up.put("f_updatetime",String.valueOf(System.currentTimeMillis()));
                dataBizService.updateData(objectinfo.getfTablename(),up,"f_id ='"+attach.getTargetTbid()+"'");

            }

            return true;
        }
        catch (Exception ex)
        {
            ref.setTag("成果挂接失败");
            logger.error("成果挂接失败",ex);
            return false;
        }

    }

    @Override
    public Boolean attach(ResultShareAttachAttDto attach,ObjectReference ref)
    {
        if(ref==null)
        {
            ref = new ObjectReference();
        }
        try {
            if (attach == null) {
                ref.setTag("待挂接数据为空");
                return false;
            }
            if (StringUtils.isBlank(attach.getTargetTbid())) {
                ref.setTag("待挂接目标图斑为空");
                return false;
            }
            if (StringUtils.isBlank(attach.getTargetTaskId())) {
                ref.setTag("待挂接目标任务为空");
                return false;
            }
            if (StringUtils.isBlank(attach.getSourceTbid())) {
                ref.setTag("待挂接源图斑为空");
                return false;
            }
            if (StringUtils.isBlank(attach.getSourceTaskId())) {
                ref.setTag("待挂接源任务为空");
                return false;
            }
            if (StringUtils.isBlank(attach.getTemplateId())) {
                ref.setTag("挂接方案为空");
                return false;
            }
            ResultShareTemplate template = resultShareTemplateService.selectByPrimaryKey(attach.getTemplateId());
            if (template == null) {
                ref.setTag("成果分享方案不存在");
                return false;
            }
            if (StringUtils.isBlank(template.getParam())) {
                ref.setTag("成果分享方案参数为空");
                return false;
            }
            ResultShareTemplateParamDto param = JSONObject.parseObject(template.getParam(), ResultShareTemplateParamDto.class);
            List<ResultShareTaskDto> sourceTaskList = param.getSourceTaskList();
            if (sourceTaskList == null) {
                ref.setTag("成果分享方案任务列表为空");
                return false;
            }
            Optional<ResultShareTaskDto> opt = sourceTaskList.stream().filter(t -> t.getSourceTaskId().equals(attach.getSourceTaskId())).findFirst();
            if (!opt.isPresent())
            {
                ref.setTag("成果分享方案任务列表未包含源任务");
                return false;
            }
            List<ResultShareFieldMappingDto> fieldMappingDtos= opt.get().getFieldMappingList();
            if(fieldMappingDtos==null||fieldMappingDtos.isEmpty())
            {
                ref.setTag("成果分享方案源任务"+attach.getSourceTaskId()+"字段映射为空");
                return false;
            }
            fieldMappingDtos = fieldMappingDtos.stream().filter(t->StringUtils.isNotBlank(t.getSourceFieldId())&&StringUtils.isNotBlank(t.getTargetFieldId())).collect(Collectors.toList());
            if(fieldMappingDtos==null||fieldMappingDtos.isEmpty())
            {
                ref.setTag("成果分享方案源任务"+attach.getSourceTaskId()+"字段映射为空");
                return false;
            }
            TskTaskBiz sourceTask = bizService.findByTaskId(attach.getSourceTaskId());
            if(sourceTask==null)
            {
                ref.setTag("源任务:"+attach.getSourceTaskId()+"不存在");
                return false;
            }
            TskTaskBiz targetTask = bizService.findByTaskId(attach.getTargetTaskId());
            if(targetTask==null)
            {
                ref.setTag("目标任务:"+attach.getTargetTaskId()+"不存在");
                return false;
            }
            TbtskObjectinfo sourceObj = objectinfoService.getObjectByTableId(sourceTask.getTableId());
            if(sourceObj==null)
            {
                ref.setTag("目标任务:"+attach.getTargetTaskId()+"不存在");
                return false;
            }
            TbtskObjectinfo targetObj = objectinfoService.getObjectByTableId(targetTask.getTableId());
            if(targetObj==null)
            {
                ref.setTag("目标任务:"+attach.getTargetTaskId()+"不存在");
                return false;
            }

            List<TbtskFields>sourceFields = fieldsService.getAllFieldsByTableID(sourceTask.getTableId());
            List<TbtskFields>targetFields = fieldsService.getAllFieldsByTableID(targetTask.getTableId());
            List<String>selectFields =new ArrayList<>();
            List<String>updateFields =new ArrayList<>();
            for (ResultShareFieldMappingDto field:fieldMappingDtos)
            {
                Optional<TbtskFields>optSf= sourceFields.stream().filter(t->t.getfId().equals(field.getSourceFieldId())).findFirst();
                Optional<TbtskFields>optTf= targetFields.stream().filter(t->t.getfId().equals(field.getTargetFieldId())).findFirst();
                if(optSf.isPresent()&&optTf.isPresent())
                {
                    selectFields.add(optSf.get().getfFieldname()+" as "+optTf.get().getfFieldname());
                    updateFields.add(optTf.get().getfFieldname());
                }
            }
            if(selectFields.isEmpty())
            {
                ref.setTag("字段映射匹配集合为空");
                return false;
            }
            String sql=String.format("select %s from %s where %s = '%s'",String.join(",",selectFields),sourceObj.getfTablename(),primaryField,attach.getSourceTbid());
            List<Map<String,Object>> maps =  jdbcTemplate.queryForList(sql);
            if(maps==null||maps.isEmpty())
            {
                ref.setTag("为能找到源图斑属性信息");
                return false;
            }

            if(!TableUtil.hasField(targetObj.getfTablename(),"f_updatetime",jdbcTemplate))
            {
                TableUtil.addField(targetObj.getfTablename(),"f_updatetime",jdbcTemplate);
            }
            List<String>updateSets =new ArrayList<>();
            updateSets.add("f_updatetime = '"+String.valueOf(System.currentTimeMillis())+"'");
            Map<String,Object>map = maps.get(0);
            for(String ups:updateFields)
            {
                Object obj= map.get(ups);
                String value = obj==null?"":obj.toString();
                updateSets.add(ups+"='"+value+"'");
            }
            String update=String.format("update %s set %s where %s = '%s'",targetObj.getfTablename(),String.join(",",updateSets),primaryField,attach.getTargetTbid());
            jdbcTemplate.execute(update);
            return true;
        }
        catch (Exception ex)
        {
            ref.setTag("成果挂接失败");
            logger.error("成果挂接失败",ex);
            return false;
        }

    }

    @Override
    public ResultShareResultDto getTranslateResult(String tbid, String taskId, ObjectReference ref)
    {
        if(ref==null)
        {
            ref = new ObjectReference();
        }

        try {
            TskTaskBiz targetTask = bizService.getTskTaskBizById(taskId);
            if(targetTask==null)
            {
                ref.setTag("当前任务:"+taskId+"不存在");
                return null;
            }
            String targetTaskName = targetTask.getName();
            ResultShareResultDto result = new ResultShareResultDto();
            result.setTargetTbId(tbid);
            result.setTargetTaskId(taskId);
            result.setTargetTaskName(targetTaskName);
            result.setShared(true);
            result.setHasResult(false);
            List<ResultShareResultDetailDto> resultDtos = new ArrayList<>();
            List<ResultShareTbId> tempTranslateTbIds = resultShareTbIdDao.selectByTbidAndTaskId(tbid, taskId);
            if (tempTranslateTbIds == null||tempTranslateTbIds.isEmpty()) {
                result.setShared(false);
                ref.setTag("未找到图斑成果分享记录");
                return null;
            }
            Map<String,List<ResultShareTbId>>mapTranslateIds = tempTranslateTbIds.stream().collect(Collectors.groupingBy(ResultShareTbId::getTemplateId));
            List<ResultShareTbId>translateTbIds = new ArrayList<>();
            for (Map.Entry<String,List<ResultShareTbId>>kv:mapTranslateIds.entrySet())
            {
                if(kv.getValue().size()==1)
                {
                    translateTbIds.addAll(kv.getValue());
                }
                else
                {
                    List<ResultShareTbId>vaules = kv.getValue() ;
                    vaules.sort(new Comparator<ResultShareTbId>() {
                        @Override
                        public int compare(ResultShareTbId o1, ResultShareTbId o2) {
                            if(o1.getCreateTime()==null&&o2.getCreateTime()==null)
                            {
                                return 1;
                            }
                            else if(o1.getCreateTime()!=null&&o2.getCreateTime()!=null)
                            {
                                return o1.getCreateTime().after(o2.getCreateTime())?-1:1;
                            }
                            else if(o1.getCreateTime()==null)
                            {
                                return 1;
                            }
                            else if(o2.getCreateTime()==null)
                            {
                                return -1;
                            }
                            return 1;
                        }
                    });
                    translateTbIds.add(vaules.get(0));
                }
            }
            translateTbIds.sort(new Comparator<ResultShareTbId>() {
                @Override
                public int compare(ResultShareTbId o1, ResultShareTbId o2) {
                    if(o1.getCreateTime()==null&&o2.getCreateTime()==null)
                    {
                        return 1;
                    }
                    else if(o1.getCreateTime()!=null&&o2.getCreateTime()!=null)
                    {
                        return o1.getCreateTime().after(o2.getCreateTime())?-1:1;
                    }
                    else if(o1.getCreateTime()==null)
                    {
                        return 1;
                    }
                    else if(o2.getCreateTime()==null)
                    {
                        return -1;
                    }
                    return 1;

                }
            });
            StringBuilder sb = new StringBuilder();
            for (ResultShareTbId translateTbId:translateTbIds) {
                if (StringUtils.isBlank(translateTbId.getAnalysisId())) {
                    //说明是单图斑分享
                    ResultShareTbShare tbShare = resultShareTbShareDao.gwSearchByPK(translateTbId.getId());
                    if (tbShare == null) {
                        sb.append("未找到图斑分享记录"+translateTbId.getId()+"成果分享结果,方案:"+ translateTbId.getTemplateId()+";");
                        continue;
                    }
                    ResultShareResultDto resultDto = JSONObject.parseObject(tbShare.getResult(), ResultShareResultDto.class);
                    if (resultDto != null) {
                        if(resultDto.getHasResult()) {
                            result.setHasResult(resultDto.getHasResult());
                        }
                        List<String> galleryids = new ArrayList<>();
                        galleryids.add(tbid);
                        List<AppMedia> targetAppMedias = appMediaDao.queryByGalleryids(galleryids);

                        if (resultDto.getDetail() != null && !resultDto.getDetail().isEmpty()) {

                            List<ResultShareResultDetailDto> detail = resultDto.getDetail();

                            for (ResultShareResultDetailDto dd : detail) {
                                if (dd.getAppMediaList() != null && !dd.getAppMediaList().isEmpty()) {
                                    List<String>gids = new ArrayList<>();
                                    gids.add(dd.getSourceTbId());
                                    List<AppMedia> sourceMedias = appMediaDao.queryByGalleryids(gids);
                                    List<AppMediaCopyDto> mediaNew = new ArrayList<>();
                                    for (AppMedia mm : sourceMedias) {
                                        AppMediaCopyDto appMediaCopyDto = new AppMediaCopyDto();
                                        BeansUtils.overwriteAccessibleProperties(mm,appMediaCopyDto);
                                        appMediaCopyDto.setHasCopy(false);
                                        String url = mm.getServerpath();
                                        String temporarySignedUrl = temporarySignedUrlService.getTemporarySignedUrl("",url, null);
                                        appMediaCopyDto.setServerpath(temporarySignedUrl);
                                        if (targetAppMedias != null && targetAppMedias.stream().filter(t -> StringUtils.isNotBlank(t.getCopyid())&&t.getCopyid().equals(mm.getId())).findFirst().isPresent()) {
                                            appMediaCopyDto.setHasCopy(true);
                                        }
                                        mediaNew.add(appMediaCopyDto);
                                    }
                                    dd.setAppMediaList(mediaNew);
                                }
                            }
                            detail.forEach(t->{t.setId(translateTbId.getId());t.setAnalysisId(translateTbId.getId());});
                            resultDtos.addAll(detail);
                        }
                    }
                }
                else{
                ResultShareTask translateTask = resultShareTaskService.select(translateTbId.getAnalysisId());

                List<ResultShareTaskDetail> detailList = resultShareTaskDetailService.selectByAnalysisId(translateTask.getId());
                if (detailList == null || detailList.isEmpty()) {
                    sb.append("未找到图斑成果分享子任务,任务ID:"+translateTbId.getAnalysisId()+",方案:"+ translateTbId.getTemplateId()+";");
                    continue;
                }
                detailList = detailList.stream().filter(t -> t.getStatus().equals(AnalysisTaskStateEnum.success.getCode().shortValue())|| t.getStatus().equals(AnalysisTaskStateEnum.relation.getCode().shortValue())).collect(Collectors.toList());
                if (detailList == null || detailList.isEmpty()) {
                    sb.append("未找到图斑成果分享已完成子任务,任务ID:"+translateTbId.getAnalysisId()+",方案:"+ translateTbId.getTemplateId()+";");
                    continue;
                }
                ResultShareTemplate template = resultShareTemplateService.selectByPrimaryKey(translateTask.getTemplateId());
                if (template == null) {
                    sb.append("未找到图斑成果分享方案,任务ID:"+translateTbId.getAnalysisId()+",方案:"+ translateTbId.getTemplateId()+";");
                    continue;
                }
                if (StringUtils.isBlank(template.getParam())) {
                    sb.append("图斑成果分享方案参数为空,任务ID:"+translateTbId.getAnalysisId()+",方案:"+ translateTbId.getTemplateId()+";");
                    continue;
                }
                ResultShareTemplateParamDto paramDto = JSONObject.parseObject(template.getParam(), ResultShareTemplateParamDto.class);
                if (paramDto.getSourceTaskList() == null || paramDto.getSourceTaskList().isEmpty()) {
                    sb.append("图斑成果分享源任务列表为空,任务ID:"+translateTbId.getAnalysisId()+",方案:"+ translateTbId.getTemplateId()+";");
                    continue;
                }
                TskTaskBiz targetTaskBiz = bizService.getTskTaskBizById(taskId);
                List<TbtskFields> targetFields = fieldsService.getAllFieldsByTableID(targetTaskBiz.getTableId());
                Optional<TbtskFields> opTarget = targetFields.stream().filter(t -> t.getfFieldname().equals(primaryField)).findFirst();
                if (!opTarget.isPresent()) {
                    sb.append("成果共享目标任务:" + taskId + "未设置主键字段"+",方案:"+ translateTbId.getTemplateId()+";");
                    continue;
                }

                List<String> wheres = new ArrayList<>();
                wheres.add(opTarget.get().getfFieldname() + "_1 = '" + tbid + "'");
                if (paramDto.getRate1() != null) {
                    double v = paramDto.getRate1() / 100;

                    wheres.add("leftsparkrate >= " + v);
                }
                if (paramDto.getRate2() != null) {
                    double v = paramDto.getRate2() / 100;
                    wheres.add("rightsparkrate >= " + v);
                }
                String filter = "";
                if (!wheres.isEmpty()) {
                    filter = "where " + String.join(" and ", wheres);
                }
                boolean hasResult = false;

                for (ResultShareTaskDto taskDto : paramDto.getSourceTaskList()) {
                    Optional<ResultShareTaskDetail> opDetail = detailList.stream().filter(t -> t.getTaskId().equals(taskDto.getSourceTaskId())).findFirst();
                    if (!opDetail.isPresent()) {
                        sb.append("成果共享源任务:" + taskDto.getSourceTaskId() + "未完成分析"+",方案:"+ translateTbId.getTemplateId()+";");
                        continue;
                    }
                    TskTaskBiz sourceTaskBiz = bizService.getTskTaskBizById(taskDto.getSourceTaskId());
                    List<TbtskFields> sourceFields = fieldsService.getAllFieldsByTableID(sourceTaskBiz.getTableId());
                    Optional<TbtskFields> opSource = sourceFields.stream().filter(t -> t.getfFieldname().equals(primaryField)).findFirst();
                    if (!opSource.isPresent()) {
                        sb.append("成果共享源任务:" + taskDto.getSourceTaskId() + "未设置主键字段"+",方案:"+ translateTbId.getTemplateId()+";");
                        continue;
                    }
                    if (paramDto.getTranslateType().equals(TranslateTypeEnum.media.getCode().shortValue()) || paramDto.getTranslateType().equals(TranslateTypeEnum.both.getCode().shortValue())) {

                        List<String> targetGalleryIds = new ArrayList<>();
                        targetGalleryIds.add(tbid);
                        List<AppMedia> targetAppMedias = appMediaDao.queryByGalleryids(targetGalleryIds);


                        String sourceTbidField = opSource.get().getfFieldname() + "_2";
                        String sql = String.format("select distinct %s from %s  %s", sourceTbidField, opDetail.get().getResultname(), filter);
                        List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
                        if (maps != null && !maps.isEmpty()) {
                            for (Map map : maps) {
                                String sourceId = map.get(sourceTbidField).toString();
                                List<String> galleryIds = Arrays.asList(sourceId);
                                List<AppMedia> appMediaList = mediaService.queryByGalleryids(galleryIds);
                                List<AppMediaCopyDto> appMediaCopyDtos = new ArrayList<>();
                                if (appMediaList != null) {
                                    for (AppMedia appMedia : appMediaList) {
                                        AppMediaCopyDto appMediaCopyDto = new AppMediaCopyDto();
                                        BeansUtils.overwriteAccessibleProperties(appMedia, appMediaCopyDto);
                                        String temporarySignedUrl = temporarySignedUrlService.getTemporarySignedUrl("", appMediaCopyDto.getServerpath(), null);
                                        appMediaCopyDto.setServerpath(temporarySignedUrl);
                                        if (targetAppMedias != null && targetAppMedias.stream().filter(t -> StringUtils.isNotBlank(t.getCopyid()) && t.getCopyid().equals(appMedia.getId())).findFirst().isPresent()) {
                                            appMediaCopyDto.setHasCopy(true);
                                        }
                                        appMediaCopyDtos.add(appMediaCopyDto);
                                    }
                                }
                                ResultShareResultDetailDto resultDto = new ResultShareResultDetailDto();
                                resultDto.setTemplateId(template.getId());
                                resultDto.setTemplateName(template.getName());
                                resultDto.setTargetTbId(tbid);
                                resultDto.setSourceTbId(sourceId);
                                resultDto.setTargetTaskId(taskId);
                                resultDto.setSourceTaskId(opDetail.get().getTaskId());
                                resultDto.setTargetTaskName(targetTaskName);
                                resultDto.setSourceBizType(taskDto.getBizType());
                                resultDto.setTranslateType(paramDto.getTranslateType());
                                resultDto.setHasResult(true);
                                resultDto.setAutoAttach(paramDto.getAutoAttach());
                                resultDto.setId(translateTbId.getId());
                                resultDto.setAnalysisId(translateTbId.getAnalysisId());
                                TskTaskBiz sourceTask = bizService.getTskTaskBizById(taskDto.getSourceTaskId());
                                String sourceTaskName = sourceTask != null ? sourceTask.getName() : taskDto.getSourceTaskName();
                                resultDto.setSourceTaskName(sourceTaskName);
                                resultDto.setAppMediaList(appMediaCopyDtos);
                                resultDtos.add(resultDto);
                                hasResult = true;
                            }
                        }
                    }
                    if (paramDto.getTranslateType().equals(TranslateTypeEnum.attribute.getCode().shortValue()) || paramDto.getTranslateType().equals(TranslateTypeEnum.both.getCode().shortValue())) {

                        List<ResultShareFieldMappingDto> fieldMap = taskDto.getFieldMappingList();
                        if (fieldMap == null || fieldMap.isEmpty()) {
                            continue;
                        }
                        List<TbtskFields>selectFields = new ArrayList<>();
                        List<String> fieldSqls = new ArrayList<>();
                        for (ResultShareFieldMappingDto field : fieldMap) {
                            if (StringUtils.isBlank(field.getSourceFieldId()) || StringUtils.isBlank(field.getTargetFieldId())) {
                                continue;
                            }
                           Optional<TbtskFields>op  = sourceFields.stream().filter(t->t.getfId().equals(field.getSourceFieldId())).findFirst();
                            TbtskFields sourceField = op.isPresent()?op.get():null;
                            if (sourceField == null) {
                                logger.error("成果共享源任务字段:" + field.getSourceFieldId() + "不存在"+",方案:"+ translateTbId.getTemplateId()+";");
                                continue;
                            }

                            selectFields.add(sourceField);
                            fieldSqls.add(sourceField.getfFieldname() + "_2" + " as " + sourceField.getfFieldname());
                        }
                        String field = fieldSqls.isEmpty() ? "" : "," + String.join(",", fieldSqls);
                        String sql = String.format("select %s %s from %s  %s", opSource.get().getfFieldname() + "_2", field, opDetail.get().getResultname(), filter);
                        List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
                        if (maps != null & !maps.isEmpty()) {
                            hasResult = true;
                            String sourceTbid = maps.get(0).get(opSource.get().getfFieldname() + "_2").toString();
                            Optional<ResultShareResultDetailDto> opResultDto = resultDtos.stream().filter(t -> t.getSourceTbId().equals(sourceTbid) && t.getSourceTaskId().equals(taskDto.getSourceTaskId())).findFirst();
                            if (opResultDto.isPresent()) {
                                opResultDto.get().setAttributes(maps.get(0));
                                opResultDto.get().setFields(selectFields);
                                opResultDto.get().setTemplateId(template.getId());
                                opResultDto.get().setTemplateName(template.getName());
                            } else {
                                ResultShareResultDetailDto resultDto = new ResultShareResultDetailDto();
                                resultDto.setTargetTbId(tbid);
                                resultDto.setSourceTbId(sourceTbid);
                                resultDto.setTargetTaskId(taskId);
                                resultDto.setSourceTaskId(opDetail.get().getTaskId());
                                resultDto.setTargetTaskName(targetTaskName);
                                resultDto.setSourceBizType(taskDto.getBizType());
                                TskTaskBiz sourceTask = bizService.getTskTaskBizById(taskDto.getSourceTaskId());
                                String sourceTaskName = sourceTask != null ? sourceTask.getName() : taskDto.getSourceTaskName();
                                resultDto.setSourceTaskName(sourceTaskName);
                                //resultDto.setAppMediaList(appMediaCopyDtos);
                                resultDto.setAttributes(maps.get(0));
                                resultDto.setFields(selectFields);
                                resultDto.setTemplateId(template.getId());
                                resultDto.setTemplateName(template.getName());
                                resultDto.setTranslateType(paramDto.getTranslateType());
                                resultDto.setHasResult(true);
                                resultDto.setAutoAttach(paramDto.getAutoAttach());
                                resultDto.setId(translateTbId.getId());
                                resultDto.setAnalysisId(translateTbId.getAnalysisId());
                                resultDtos.add(resultDto);
                            }
                        }

                    }
                }

                if (!result.getHasResult()) {
                    result.setHasResult(hasResult);
                }
            }
            }
            result.setDetail(resultDtos);
            ref.setTag(sb.toString());
            result.setMsg(ref.getTag());
            return result;
        }
        catch (Exception ex)
        {
            logger.error("",ex);
            ref.setTag("获取复用结果异常");
            return null;
        }
    }

    private String createTask(TskTaskBiz targetTaskBiz, TbtskObjectinfo tergetObjectinfo, ResultShareTaskDetail detail, ResultShareTaskDto sourceTask, ObjectReference ref) {
        TskTaskBiz sourceTaskBiz = bizService.getTskTaskBizById(detail.getTaskId());
        if(sourceTaskBiz==null)
        {
            ref.setTag("成果共享源任务:"+detail.getTaskId()+"不存在");
            return "";
        }

        TbtskObjectinfo sourceObjectinfo = objectinfoService.getObjectByTableId(sourceTaskBiz.getTableId());
        if(sourceObjectinfo==null)
        {
            ref.setTag("成果共享源任务对象表:"+sourceTaskBiz.getTableId()+"不存在");
            return "";
        }

        List<TbtskFields>targetFields = fieldsService.getAllFieldsByTableID(targetTaskBiz.getTableId());
        Optional<TbtskFields> opTarget = targetFields.stream().filter(t->t.getfFieldname().equals(primaryField)).findFirst();
        if(!opTarget.isPresent())
        {
            ref.setTag("成果共享目标任务:"+detail.getTaskId()+"未设置主键字段");
            return "";
        }

        List<TbtskFields>sourceFields  = fieldsService.getAllFieldsByTableID(sourceTaskBiz.getTableId());
        Optional<TbtskFields> opSource = sourceFields.stream().filter(t->t.getfFieldname().equals(primaryField)).findFirst();
        if(!opSource.isPresent())
        {
            ref.setTag("成果共享源任务:"+sourceTaskBiz.getId()+"未设置主键字段");
            return "";
        }


        String filterIdSql = String.format("select f_tbid from tb_result_share_tbid where f_analysisid ='%s'",detail.getAnalysisId());
        filterIdSql = (opTarget.get().getfFieldname()+" in ("+filterIdSql+")");

        if(atlasConfig.getUseAtlas()) {

            if(!TableUtil.hasField(tergetObjectinfo.getfTablename(),"aid",jdbcTemplate))
            {
                TableUtil.createSequence(tergetObjectinfo.getfTablename(),"aid",tergetObjectinfo.getfTablename()+"_seq",jdbcTemplate);
            }
            if(!TableUtil.hasField(sourceObjectinfo.getfTablename(),"aid",jdbcTemplate))
            {
                TableUtil.createSequence(sourceObjectinfo.getfTablename(),"aid",sourceObjectinfo.getfTablename()+"_seq",jdbcTemplate);
            }
            String tempTable =tergetObjectinfo.getfTablename();
            if(StringUtils.isNotBlank(filterIdSql))
            {
                tempTable = "temp_share_"+UUID.randomUUID().toString().replace("-","");
                String tempSql = "create table "+tempTable+" as select * from "+tergetObjectinfo.getfTablename() + " where "+filterIdSql+";select updategeometrysrid('"+tempTable+"','f_shape',4490)";
                jdbcTemplate.execute(tempSql);
                filterIdSql="";
                detail.setTempLeft(tempTable);
            }

            ATLAS_Front_Layer leftLayer = new ATLAS_Front_Layer();
            leftLayer.setLayerName(targetTaskBiz.getName());
            leftLayer.setFeatureSet(tempTable);
            leftLayer.setSql(filterIdSql);
            leftLayer.setSourceType("dbrange");
            leftLayer.setDbType("ywk");

            ATLAS_Front_Layer rightLayer = new ATLAS_Front_Layer();
            rightLayer.setLayerName(sourceTaskBiz.getName());
            rightLayer.setFeatureSet(sourceObjectinfo.getfTablename());
            rightLayer.setSql("");
            rightLayer.setSourceType("dbrange");
            rightLayer.setDbType("ywk");

            Date creatTime = new Date();
            DateFormat df = new SimpleDateFormat("YYYY-MM-DD HH:mm:ss");
            String createTimeStr = df.format(creatTime);
            Atlas_Analysis_Param atlasParam = new Atlas_Analysis_Param();
            atlasParam.setOutputFeatureSet(detail.getResultname());
            atlasParam.setLayerLeft(leftLayer);
            atlasParam.setLayerRight(rightLayer);
            atlasParam.setName(leftLayer.getLayerName() + "-" + rightLayer.getLayerName());
            atlasParam.setTime(createTimeStr);
            atlasParam.setOperator("叠加");
            String atlasId = atlasTaskService.createAnalysisTask(atlasParam, ref);
            return atlasId;
        }
        else
        {
            List<String>leftFields=null;
            List<String>rightFields = null;
            List<ResultShareFieldMappingDto> fieldMap = sourceTask.getFieldMappingList();
            if(fieldMap!=null&&!fieldMap.isEmpty())
            {
                leftFields = new ArrayList<>();
                rightFields = new ArrayList<>();
                for (ResultShareFieldMappingDto field:fieldMap) {
                   Optional<TbtskFields>opt = targetFields.stream().filter(t->t.getfId().equals(field.getTargetFieldId())).findFirst();
                   Optional<TbtskFields>ops = sourceFields.stream().filter(t->t.getfId().equals(field.getSourceFieldId())).findFirst();
                  if(opt.isPresent()&&ops.isPresent())
                  {
                      leftFields.add(opt.get().getfFieldname());
                      rightFields.add(ops.get().getfFieldname());
                  }
                }
            }
            AnalysisParam atlasParam = new AnalysisParam();
            atlasParam.setLeftLayer(tergetObjectinfo.getfTablename());
            atlasParam.setLeftWhere(filterIdSql);
            atlasParam.setLeftFields(leftFields.toArray(new String[0]));
            atlasParam.setLeftLayerPrimaryField(opTarget.get().getfFieldname());
            atlasParam.setLeftLayerShapeField(shapeField);
            atlasParam.setRightLayer(sourceObjectinfo.getfTablename());
            atlasParam.setRightWhere(null);
            atlasParam.setRightFields(rightFields.toArray(new String[0]));
            atlasParam.setRightLayerPrimaryField(opSource.get().getfFieldname());
            atlasParam.setRightLayerShapeField(shapeField);
            atlasParam.setResultName(detail.getResultname());
            atlasParam.setName(targetTaskBiz.getName() +"-"+ sourceTaskBiz.getName());
            atlasParam.setOperatorType(1);
            atlasParam.setDataBaseInfo(getDB());
            String atlasId =  analysisTaskService.createAnalysisTask(atlasParam,ref);
            return atlasId;

        }

    }

    private Boolean startTask(String atlasId,ObjectReference ref)
    {
        if(atlasConfig.getUseAtlas())
        {
           return   atlasTaskService.startAnalysisTask(atlasId,ref);
        }
        else
        {
            return  analysisTaskService.startAnalysisTask(atlasId,ref);
        }
    }

    private String getDB()
    {
        DataSource dataSource  = jdbcTemplate.getDataSource();
        com.alibaba.druid.pool.DruidDataSource druidDataSource = (com.alibaba.druid.pool.DruidDataSource )dataSource;
        String url =druidDataSource.getUrl();
        String username = druidDataSource.getUsername();
        String password = druidDataSource.getPassword();
        String [] urls = StringUtils.split(url,"?");
        url = StringUtils.replace(urls[0],"jdbc:","");
        String pre = url.substring(0,url.indexOf("/"));
        url = url.substring(url.indexOf("/")+2);
        String result = pre+"//"+ username+"/"+password+"@"+url;
        return result;//.replace("49.4.81.80","192.168.1.233");
    }

    private String getShortPath(String objectname)
    {
        if (objectname.toLowerCase().startsWith("http")) {
            try {
                URL myurl = new URL(objectname);
                objectname = myurl.getFile();
                if (objectname.startsWith("/")) {
                    objectname = objectname.substring(1, objectname.length());
                }
            } catch (MalformedURLException var15) {
                var15.printStackTrace();
            }
            OssConfig ossConfig= defaultOssOperatorService.getDefaultOssConfig();
            String ossType = ossConfig.getType();
            if(ossType.equalsIgnoreCase(OSSTypeConstants.AWS)) {
                objectname = objectname.substring(objectname.indexOf("/"), objectname.length());
                if (objectname.startsWith("/")) {
                    objectname = objectname.substring(1, objectname.length());
                }
            }
        }
        return objectname;

    }

    private String buffer (String wkt,Double buffer)
    {
        try {
            Geometry geo = parseGeometry(wkt, 4490);
            double lon = geo.getCentroid().getX();
            int projNo = (int) ((lon - 1.5) / 3) + 1;
            CoordinateReferenceSystem destCRS = findDestProjectCRSByLon(projNo);
            MathTransform transform = CRS.findMathTransform(DefaultGeographicCRS.WGS84, destCRS, true);
            Geometry newGeo = JTS.transform(geo, transform);
            newGeo = newGeo.buffer(buffer);
            transform = CRS.findMathTransform(destCRS, DefaultGeographicCRS.WGS84, true);
            newGeo = JTS.transform(newGeo, transform);
            return newGeo.toText();
        }
        catch (Exception ex)
        {
            logger.error("buffer error",ex);
            return null;
        }
    }
    private CoordinateReferenceSystem findDestProjectCRSByLon(int projNo) {
        if (projNo > 60) {
            return null;
        }
        CoordinateReferenceSystem destCRS = null;

        String wkt = SRWKTTemplate.findCGS2000GaussPrjSRWKTWithPrjNo(projNo);
        try {
            destCRS = CRS.parseWKT(wkt);
        } catch (FactoryException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        return destCRS;
    }
    private Geometry parseGeometry(String wkt, Integer srid) throws ParseException {

        if (GutilStr.isEmpty(wkt)) {
            throw new IllegalArgumentException("参数wkt不能为空！");
        }
        WKTReader reader = new WKTReader();
        Geometry geo = reader.read(wkt);
        geo.setSRID(srid);

        return geo;
    }
}
