package com.geoway.landteam.landcloud.service.customtask.resultshare.impl;


import com.geoway.landteam.customtask.dao.resultshare.ResultShareTaskDao;
import com.geoway.landteam.customtask.resultshare.pub.dto.ResultShareTaskInfoDto;
import com.geoway.landteam.customtask.service.resultshare.config.AtlasConfig;
import com.geoway.landteam.customtask.resultshare.pub.entity.ResultShareTask;
import com.geoway.landteam.customtask.resultshare.pub.entity.ResultShareTaskDetail;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MAnalysisTaskService;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MAtlasTaskService;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MResultShareTaskDetailService;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MResultShareTaskService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import com.mchange.v2.beans.BeansUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class MResultShareTaskServiceImpl implements MResultShareTaskService {
    private final GiLoger logger = GwLoger.getLoger(MResultShareTaskServiceImpl.class);
    @Resource
    private ResultShareTaskDao resultShareTaskDao;

    @Resource
    private MResultShareTaskDetailService resultShareTaskDetailService;

    @Resource
    private JdbcTemplate jdbcTemplate;

    @Autowired
    MAtlasTaskService atlasTaskService;

    @Autowired
    MAnalysisTaskService analysisTaskService;

    @Autowired
    AtlasConfig atlasConfig;

    @Override
    public void delete(String id) {
         resultShareTaskDao.gwDeleteByPK(id);
    }

    @Override
    public int setDelete(String id) {
        return resultShareTaskDao.setDelete(id);
    }

    @Override
    public void insert(ResultShareTask task) {
         resultShareTaskDao.gwAccess(task);
    }


    @Override
    public ResultShareTask select(String id) {
        return resultShareTaskDao.gwSearchByPK(id);
    }

    @Override
    public List<ResultShareTask> select(String taskId,String userId) {
        return resultShareTaskDao.selectByTaskIdAndUser(taskId,userId);
    }

    @Override
    public List<ResultShareTaskInfoDto> selecteTaskInfo(String taskId, String userId) {
        List<ResultShareTaskInfoDto>dtos=new ArrayList<>();
        List<ResultShareTask> tasks = resultShareTaskDao.selectByTaskIdAndUser(taskId, userId);
        if (tasks != null)
        {
            for (ResultShareTask task:tasks) {
                ResultShareTaskInfoDto dto = new ResultShareTaskInfoDto();
                try {
                    BeansUtils.overwriteAccessibleProperties(task, dto);
                }
                catch (Exception ex)
                {
                    logger.error("",ex);
                }
                dto.setDetailList(resultShareTaskDetailService.selectByAnalysisId(task.getId()));
                dtos.add(dto);

            }

        }
        return dtos;
    }


    @Override
    public boolean updateStatus(String id, Short status) {
        return resultShareTaskDao.updateStatus(id,status)>0;
    }

    @Override
    public boolean startTask(String id, Short status,String msg)
    {
        return resultShareTaskDao.startTask(id,status,msg)>0;
    }

    @Override
    public boolean finishTask(String id, Short status,String msg) {
        return resultShareTaskDao.finishTask(id,status,msg)>0;
    }

    @Override
    public List<ResultShareTask> getDelete() {
        return resultShareTaskDao.getDelete();
    }

    @Override
    public List<ResultShareTask> getRunning() {
        return resultShareTaskDao.getRunning();
    }

    @Override
    public List<ResultShareTask> getCreate() {
        return resultShareTaskDao.getCreate();
    }

    @Override
    public List<ResultShareTask> getAutoAttach()
    {
        return resultShareTaskDao.getAutoAttach();
    }

    @Override
    public List<ResultShareTask> getDeleteByShard(int total, int index) {
        return resultShareTaskDao.getDeleteByShard(total, index);
    }

    @Override
    public List<ResultShareTask> getRunningByShard(int total, int index) {
        return resultShareTaskDao.getRunningByShard(total, index);
    }

    @Override
    public List<ResultShareTask> getCreateByShard(int total, int index) {
        return resultShareTaskDao.getCreateByShard(total, index);
    }
    @Override
    public List<ResultShareTask> getAutoAttachByShard(int total, int index) {
        return resultShareTaskDao.getAutoAttachByShard(total, index);
    }
    @Override
    public Boolean  deleteWholeTask(ResultShareTask task)
    {
        List<ResultShareTaskDetail>detailList = resultShareTaskDetailService.selectByAnalysisId(task.getId());
        if(detailList!=null)
        {
            for (ResultShareTaskDetail detail:detailList) {
                String resultTable = detail.getResultname();
                String sql="drop table IF EXISTS "+resultTable;
                jdbcTemplate.execute(sql);
                if(StringUtils.isNotBlank(detail.getAtlasId())) {
                    try {
                        if (atlasConfig.getUseAtlas()) {
                            atlasTaskService.deleteAtlasTask(detail.getAtlasId());
                        } else {
                            analysisTaskService.deleteAnalysisTask(detail.getAtlasId());
                        }
                    }
                    catch (Exception ex)
                    {
                        logger.error("",ex);
                    }
                }
            }
            resultShareTaskDetailService.deleteByAnalysisId(task.getId());
        }
        resultShareTaskDao.gwDeleteByPK(task.getId());
        return true;
    }
}
