package com.geoway.landteam.landcloud.service.customtask.resultshare.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.dao.resultshare.ResultShareTemplateDao;
import com.geoway.landteam.customtask.resultshare.pub.dto.ResultShareFieldMappingDto;
import com.geoway.landteam.customtask.resultshare.pub.dto.ResultShareTaskDto;
import com.geoway.landteam.customtask.resultshare.pub.dto.ResultShareTemplateParamDto;
import com.geoway.landteam.customtask.resultshare.pub.entity.ResultShareTemplate;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MResultShareTemplateService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import com.gw.base.data.GwValidateException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;


@Service
public class MResultShareTemplateServiceImpl implements MResultShareTemplateService {
    private final GiLoger logger = GwLoger.getLoger(MResultShareTemplateServiceImpl.class);
    @Resource
    private ResultShareTemplateDao templateDao;


    @Override
    public void deleteByPrimaryKey(String id) {
         templateDao.gwDeleteByPK(id);
    }

    @Override
    public ResultShareTemplate selectByPrimaryKey(String id) {
        return templateDao.gwSearchByPK(id);
    }

    @Override
    public String saveOne(ResultShareTemplateParamDto dto, long userId) throws Exception {
        String checkResult = checkDto(dto);
        if (StringUtils.isNotBlank(checkResult)) {
            throw new GwValidateException(checkResult);
        }
        ResultShareTemplate template = new ResultShareTemplate();
        template.setName(dto.getName());
        template.setId(UUID.randomUUID().toString());
        template.setCreateTime(new Date());
        template.setCreateUserId(String.valueOf(userId));
        template.setTargetTaskId(dto.getTargetTaskId());
        template.setParam(JSONObject.toJSONString(dto));
        templateDao.gwAccess(template);
        return template.getId();
    }

    private String checkDto(ResultShareTemplateParamDto template) {
        StringBuilder sb = new StringBuilder();

        if (template.getTranslateType() == null) {
            sb.append(" 转换内容不能为空。 ");
        }
        else if (template.getTranslateType() < 1 || template.getTranslateType() > 3) {
            sb.append(" 转换内容不正确。 ");
        }
        if(template.getRate1()==null&&template.getRate2()==null)
        {
            sb.append(" 转换面积占比不正确。 ");
        }
        else
        {
            if(template.getRate1()!=null&&(template.getRate1()<=0||template.getRate1()>=100))
            {
                sb.append(" 转换面积占比不正确。 ");
            }
            if(template.getRate2()!=null&&(template.getRate2()<=0||template.getRate2()>=100))
            {
                sb.append(" 转换面积占比不正确。 ");
            }
        }
        if (StringUtils.isEmpty(template.getTargetTaskId())) {
            sb.append(" 目标任务编号不能为空。 ");
        }
        if (StringUtils.isEmpty(template.getName())) {
            sb.append(" 分享成果名称不能为空。 ");
        }
        if(template.getSourceTaskList()==null||template.getSourceTaskList().isEmpty())
        {
            sb.append(" 分享成果源任务为空。 ");
        }
        /*
        List<ResultShareTaskDto> taskDtos = template.getSourceTaskList();
        for (ResultShareTaskDto taskDto:taskDtos) {
            if(taskDto.getFieldMappingList()!=null&&!taskDto.getFieldMappingList().isEmpty())
            {
                List<ResultShareFieldMappingDto> fields = taskDto.getFieldMappingList();
                for (ResultShareFieldMappingDto fieldMap:fields) {
                    if(StringUtils)
                }
            }
        }
        */
        return sb.toString();
    }

    @Override
    public Map isTemplateNameExist(String templateName) {
        Map resultMap = new HashMap();
        resultMap.put("result", false);
        resultMap.put("isExist", false);
        resultMap.put("error", "");
        try {
            if (templateDao.countByName(templateName) > 0) {
                resultMap.put("isExist", true);
            } else {
                resultMap.put("isExist", false);
            }
            resultMap.put("result", true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            resultMap.put("result", false);
            resultMap.put("error", e.getMessage());
        }
        return resultMap;
    }

    @Override
    public List<ResultShareTemplate> selectByTaskid(String taskid)
    {
        return templateDao.selectByTaskid(taskid);
    }

}
