package com.geoway.landteam.landcloud.service.customtask.task;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.crypto.symmetric.SM4;
import cn.hutool.db.DaoTemplate;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionDJQ;
import com.geoway.landteam.landcloud.model.giht.entity.TbGjhtAssign;
import com.geoway.landteam.landcloud.repository.gjht.TbGjhtAssignRepository;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilAssert;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class GjhtAssignService {

    private final GiLoger logger = GwLoger.getLoger(GjhtAssignService.class);

    @Autowired
    TbGjhtAssignRepository tbGjhtAssignRepository;

    //公钥
    @Value("${hbfzx.keyPublic}")
    protected String keyPublic;

    //私钥
    @Value("${hbfzx.keyPrivate}")
    protected String keyPrivate;

    //证书Base64密文
    @Value("${hbfzx.certCode}")
    protected String certCode;

    //国土调查云提供服务地址
    @Value("${hbfzx.gtUrl}")
    protected String gtUrl;

    //  河北分中心服务地址
    @Value("${hbfzx.url}")
    private String url;

    @Value("${gjgty.obs}")
    private String gjObs;

    public String getGjObs() {
        return gjObs;
    }

    public boolean save(TbGjhtAssign tbGjhtAssign){
        boolean flag = false;
        if(ObjectUtils.isNotEmpty(tbGjhtAssign)){
            TbGjhtAssign gjhtAssign = tbGjhtAssignRepository.save(tbGjhtAssign);
            if(StringUtils.isNotBlank(gjhtAssign.getId())){
                flag = true;
            } else {
                flag = false;
            }
        }
        return flag;
    }


    public JSONObject saveData( String xLcSecret,String xLcToken,JSONObject parameter){
//        boolean flag = false;
        JSONObject returnJsonObject = new JSONObject();
        if(StringUtils.isBlank(keyPublic) || StringUtils.isBlank(keyPrivate)
                || StringUtils.isBlank(gtUrl) || StringUtils.isBlank(url)){
            System.out.println("没有公钥或没有私钥或没有服务地址配置信息！");
            logger.info("没有公钥或没有私钥或没有服务地址配置信息！");
            returnJsonObject.put("code","500");
            returnJsonObject.put("data","");
            returnJsonObject.put("message","失败");
            returnJsonObject.put("traceid","xxx");
            return returnJsonObject;
        }
        //创建 SM2
        SM2 sm2 = new SM2(keyPrivate, keyPublic);
        // 怎样获取 {base64} 这样的数据 ？？？？？？？？？？？？？？？
        String secretData = "base64";
        String data = getDecrypt(sm2,secretData,xLcSecret);
        // 获取解密后的请求参数数据
       JSONObject jsonObject = JSONObject.parseObject(data);

       // 创建实体对象
        TbGjhtAssign tbGjhtAssign = new TbGjhtAssign();

        // 业务数据代码
        String code = parameter.getString("code");
        GutilAssert.state(com.geoway.landteam.landcloud.common.util.base.StringUtils.isNoneBlank(code), "code 不能为空!");
        tbGjhtAssign.setCode(code);

        // 区域代码（6位）
        String regioncode = parameter.getString("regioncode");
        GutilAssert.state(com.geoway.landteam.landcloud.common.util.base.StringUtils.isNoneBlank(regioncode), "regioncode 不能为空!");
        tbGjhtAssign.setXzqdm(regioncode);

        // 生成数据包程序版本，统一由该接口下发
        Integer version = parameter.getInteger("version");
        GutilAssert.state(version != null, "parameter参数中version 不能为空!");
        tbGjhtAssign.setStatus(version);

//        tbGjhtAssign.set

//            数据包大小(字节)
        Integer size = parameter.getInteger("size");
        GutilAssert.state(size != null, "parameter参数中size 不能为空!");
        tbGjhtAssign.setZip_len(size);

//            图斑数量
        Integer count = parameter.getInteger("count");
        GutilAssert.state(count != null, "parameter参数中count 不能为空!");
        tbGjhtAssign.setNum(count);

//            外业附件个数
        Integer attachment_count = parameter.getInteger("attachment_count");
        GutilAssert.state(attachment_count != null, "parameter参数中attachment_count 不能为空!");
        tbGjhtAssign.setClgs(attachment_count);

//           数据包扩展名，默认:db
        String extension = parameter.getString("extension");
        GutilAssert.state(com.geoway.landteam.landcloud.common.util.base.StringUtils.isNoneBlank(extension), "extension 不能为空!");
        tbGjhtAssign.setZip_res(extension);

//           数据包密码
        String password = parameter.getString("password");
        GutilAssert.state(com.geoway.landteam.landcloud.common.util.base.StringUtils.isNoneBlank(password), "password 不能为空!");
        tbGjhtAssign.setZip_pwd(password);

//        文件的哈希值是对文件内容采用国密SM3计算哈希值
        String hash = parameter.getString("hash");
        GutilAssert.state(com.geoway.landteam.landcloud.common.util.base.StringUtils.isNoneBlank(hash), "hash 不能为空!");
        tbGjhtAssign.setMd5(hash);

//          时间戳（ 使用毫秒级 ）
        Long timestamp = parameter.getLong("timestamp");
        GutilAssert.state(timestamp != null, "parameter参数中timestamp 不能为空!");
        Date timestampDate = new Date(timestamp);
        tbGjhtAssign.setXfsj(timestampDate);

//          数据包的下载地址
        String url = parameter.getString("url");
        GutilAssert.state(com.geoway.landteam.landcloud.common.util.base.StringUtils.isNoneBlank(url), "url 不能为空!");
        tbGjhtAssign.setUrl(url);

//          签章信息，用于数据包的验签
        String sign = parameter.getString("sign");
        GutilAssert.state(com.geoway.landteam.landcloud.common.util.base.StringUtils.isNoneBlank(sign), "sign 不能为空!");
        tbGjhtAssign.setSmc(sign);

        StringBuilder dataBuilder = new StringBuilder();

        if(ObjectUtils.isNotEmpty(tbGjhtAssign)){
            TbGjhtAssign gjhtAssign = tbGjhtAssignRepository.save(tbGjhtAssign);
            if(StringUtils.isNotBlank(gjhtAssign.getId())){
                returnJsonObject.put("code","200");
                returnJsonObject.put("data",153);
                returnJsonObject.put("message","成功");
                returnJsonObject.put("traceid","xxx");
            } else {
                returnJsonObject.put("code","500");
                returnJsonObject.put("data","");
                returnJsonObject.put("message","失败");
                returnJsonObject.put("traceid","xxx");
            }
        }

        //使用R|S裸格式，不使用ASN1(R|S)格式
        sm2.usePlainEncoding();
        //产生SM4随机密钥
        byte[] sm4Key = SecureUtil.generateKey("SM4").getEncoded();
        // 获取 平台身份认证Token
        String token = getToken(sm2);
        // 获取 数据加密秘钥密文
        String secret = getSecret(sm2,sm4Key);
        Map<String,String> headerMap = new HashMap<>();
        headerMap.put("x-lc-secret",secret);
        headerMap.put("x-lc-token", token);

        String returnJsonObjectData = returnJsonObject.toString();
        returnJsonObjectData = returnJsonObjectData.substring(1,returnJsonObjectData.length()-1);
//        {"traceid":"xxx","code":"200","data":153,"message":"成功"}
//        去掉前后的{}得到 "traceid":"xxx","code":"200","data":153,"message":"成功"
        String dataEncrypt = getEncrypt(returnJsonObjectData, sm4Key);

//        《附录5 分中心业务数据协同标准》文档中 调用-数据推送
//        告诉国土调查云接收数据情况
        HttpResponse httpResponse = HttpUtil.createPost(gtUrl+"/DataExchange/receiveDataPackage").addHeaders(headerMap).body("{"+dataEncrypt+"}").execute();

        return returnJsonObject;
    }

    // 国土调查云与分中心 接口注册
    public JSONObject register(String regioncode, String serviceurl, String contacts, String phone) throws Exception {
        JSONObject dataJson = new JSONObject();

        //数据判断，传递数据都不能为空
        if(StringUtils.isBlank(regioncode) || StringUtils.isBlank(serviceurl)
                || StringUtils.isBlank(contacts) || StringUtils.isBlank(phone)){
            System.out.println("数据信息不完整！");
            logger.info("数据信息不完整！");
            return null;
        }

        if(StringUtils.isBlank(keyPublic) || StringUtils.isBlank(keyPrivate)
                || StringUtils.isBlank(gtUrl) || StringUtils.isBlank(url)){
            System.out.println("没有公钥或没有私钥或没有服务地址配置信息！");
            logger.info("没有公钥或没有私钥或没有服务地址配置信息！");
            return null;
        }

        serviceurl =  url + serviceurl;

        //创建 SM2
        SM2 sm2 = new SM2(keyPrivate, keyPublic);
        //使用R|S裸格式，不使用ASN1(R|S)格式
        sm2.usePlainEncoding();
        //产生SM4随机密钥
        byte[] sm4Key = SecureUtil.generateKey("SM4").getEncoded();

        // 获取 平台身份认证Token
        String token = getToken(sm2);
        if(StringUtils.isBlank(token)){
            return null;
        }
        // 获取 数据加密秘钥密文
        String secret = getSecret(sm2,sm4Key);
        if(StringUtils.isBlank(secret)){
            return null;
        }
        // 数据示例是 "key1":"value1","key2":"value2"
//        StringBuilder dataBuilder = new StringBuilder();
//        dataBuilder.append("\"regioncode\"").append(":").append("\""+regioncode+"\"").append(",")
//                .append("\"serviceurl\"").append(":").append("\""+serviceurl+"\"").append(",")
//                .append("\"contacts\"").append(":").append("\""+contacts+"\"").append(",")
//                .append("\"phone\"").append(":").append("\""+phone+"\"");
//        System.out.println("dataBuilder = " + dataBuilder.toString());

//        String dataEncrypt1 = getEncrypt(dataBuilder.toString(), sm4Key);

        // 数据示例是json {"key1":"value1","key2":"value2"}
        dataJson.put("regioncode",regioncode);
        dataJson.put("serviceurl",serviceurl);
        dataJson.put("contacts",contacts);
        dataJson.put("phone",phone);

        System.out.println(" dataJson = " + dataJson.toString());

        String dataEncrypt2 = getEncrypt(dataJson.toJSONString(), sm4Key);

        Map<String,String> headerMap = new HashMap<>();
        headerMap.put("x-lc-secret",secret);
        headerMap.put("x-lc-token", token);

//        String result =  HttpUtil.createPost(gtUrl+"/DataExchange/RegistService").addHeaders(headerMap).body("{"+dataEncrypt1+"}").execute().body();
//        《附录5 分中心业务数据协同标准》文档中 调用-接口注册
//        HttpResponse httpResponse = HttpUtil.createPost(gtUrl+"/DataExchange/RegistService").contentType("application/json").addHeaders(headerMap).body(dataEncrypt1).execute();

//        if(ObjectUtils.isEmpty(httpResponse)){
//            return null;
//        }
//        String result = httpResponse.body();
//        System.out.println(" result : " + result);

//        httpResponse = HttpUtil.createPost(gtUrl+"/DataExchange/RegistService").addHeaders(headerMap).body("{"+dataEncrypt1+"}").execute();
//        System.out.println(" result : " + result);

        HttpResponse httpResponse = HttpUtil.createPost(gtUrl+"/DataExchange/RegistService").contentType("application/json").addHeaders(headerMap).body(dataEncrypt2).execute();

        if(ObjectUtils.isEmpty(httpResponse)){
            return null;
        }
        String result = httpResponse.body();
        System.out.println(" result : " + result);

        String xLcSecret = httpResponse.header("x-lc-secret");
        System.out.println(" xLcSecret : " + xLcSecret);

        // 返回数据无法解析
        if(StringUtils.isBlank(result) || (result.indexOf("\"code\": 200")==-1 || result.indexOf("\"code\":200")==-1)){
            return null;
        }
        // 返回调用的数据结果
        JSONObject resultJsonObject = JSONObject.parseObject(result);
        String rssultSecretData = "";

        if(ObjectUtils.isNotEmpty(resultJsonObject)){
            if(ObjectUtils.isNotEmpty(resultJsonObject.get("code")) && resultJsonObject.get("code").toString().equals("200")){
                if(ObjectUtils.isNotEmpty(resultJsonObject.get("data"))){
                    rssultSecretData = resultJsonObject.get("data").toString();
                }
            }
        }

        if(StringUtils.isNotBlank(xLcSecret) && StringUtils.isNotBlank(rssultSecretData)){
            //获取 数据解密。
            String data = getDecrypt(sm2,rssultSecretData,xLcSecret);
            if(StringUtils.isNotBlank(xLcSecret)){
                resultJsonObject.put("data","{"+data+"}");
            }
        }
        return resultJsonObject;
    }

    //   国土调查云与分中心 数据订阅/更新
    public JSONObject registerData(String registerCode, String[] includeXzqdms, String[]  excludeXzqdms) throws Exception {
        JSONObject dataJson = new JSONObject();

        //数据判断，传递数据都不能为空
        if(StringUtils.isBlank(registerCode)){
            System.out.println("数据信息不完整！");
            logger.info("数据信息不完整！");
            return null;
        }

        if(StringUtils.isBlank(keyPublic) || StringUtils.isBlank(keyPrivate)
                || StringUtils.isBlank(gtUrl)){
            System.out.println("没有公钥或没有私钥或没有服务地址配置信息！");
            logger.info("没有公钥或没有私钥或没有服务地址配置信息！");
            return null;
        }

        //创建 SM2
        SM2 sm2 = new SM2(keyPrivate, keyPublic);
        //使用R|S裸格式，不使用ASN1(R|S)格式
        sm2.usePlainEncoding();
        //产生SM4随机密钥
        byte[] sm4Key = SecureUtil.generateKey("SM4").getEncoded();

        // 获取 平台身份认证Token
        String token = getToken(sm2);
        if(StringUtils.isBlank(token)){
            return null;
        }
        // 获取 数据加密秘钥密文
        String secret = getSecret(sm2,sm4Key);
        if(StringUtils.isBlank(secret)){
            return null;
        }
        // 数据示例是 "key1":"value1","key2":"value2"
        StringBuilder dataBuilder = new StringBuilder();
        dataBuilder.append("\"code\"").append(":").append("\""+registerCode+"\"");

        // 数据示例是json {"key1":"value1","key2":"value2"}
        dataJson.put("code",registerCode);

        if(ObjectUtils.isNotEmpty(includeXzqdms) && includeXzqdms.length>0){
//            String inXzqdms = String.join(",", includeXzqdms);
            // 行政区划编号数组转换成字符串方法
            String inXzqdms = getXzqdmsData(includeXzqdms);
            dataBuilder.append(",").append("\"include_xzqdms\"").append(":").append("[").append(inXzqdms).append("]");

            dataJson.put("include_xzqdms",inXzqdms);
        }
        if(ObjectUtils.isNotEmpty(excludeXzqdms) && excludeXzqdms.length>0){
//            String exXzqdms = String.join(",", excludeXzqdms);
            // 行政区划编号数组转换成字符串方法
            String exXzqdms = getXzqdmsData(excludeXzqdms);
            dataBuilder.append(",").append("\"include_xzqdms\"").append(":").append("[").append(exXzqdms).append("]");

            dataJson.put("include_xzqdms",exXzqdms);
        }

        String dataEncrypt1 = getEncrypt(dataBuilder.toString(), sm4Key);
        String dataEncrypt2 = getEncrypt(dataJson.toJSONString(), sm4Key);

        Map<String,String> headerMap = new HashMap<>();
        headerMap.put("x-lc-secret",secret);
        headerMap.put("x-lc-token", token);

//        String result =  HttpUtil.createPost(gtUrl+"/DataExchange/RegistDataCode").addHeaders(headerMap).body("{"+dataEncrypt1+"}").execute().body();
//        《附录5 分中心业务数据协同标准》文档中 调用-数据订阅/更新
        HttpResponse httpResponse = HttpUtil.createPost(gtUrl+"/DataExchange/RegistDataCode").addHeaders(headerMap).body("{"+dataEncrypt1+"}").execute();

        if(ObjectUtils.isEmpty(httpResponse)){
            return null;
        }

        String result = httpResponse.body();
        String xLcSecret = httpResponse.header("x-lc-secret");
        // 返回调用的数据结果
        JSONObject resultJsonObject = JSONObject.parseObject(result);
        String rssultSecretData = "";

        if(ObjectUtils.isNotEmpty(resultJsonObject)){
            if(ObjectUtils.isNotEmpty(resultJsonObject.get("code")) && resultJsonObject.get("code").toString().equals("200")){
                if(ObjectUtils.isNotEmpty(resultJsonObject.get("data"))){
                    rssultSecretData = resultJsonObject.get("data").toString();
                }
            }
        }

        if(StringUtils.isNotBlank(xLcSecret) && StringUtils.isNotBlank(rssultSecretData)){
            //获取 数据解密。
            String data = getDecrypt(sm2,rssultSecretData,xLcSecret);
            if(StringUtils.isNotBlank(xLcSecret)){
                resultJsonObject.put("data",data);
            }
        }
        return resultJsonObject;
    }

    // 获取 平台身份认证Token
    public String getToken(SM2 sm2){
        String token = "";
        if(ObjectUtils.isEmpty(sm2) || StringUtils.isBlank(certCode) || StringUtils.isBlank(keyPublic) || StringUtils.isBlank(keyPrivate)){
            // token 生成失败
            logger.info("token 生成失败！");
            return "";
        }

        long timestamp = System.currentTimeMillis();
        //拼接待签名数据
        String needSignData = certCode + timestamp;
        byte[] needSignDataByte = needSignData.getBytes(StandardCharsets.UTF_8);
        //签名
        byte[] signData = sm2.sign(needSignDataByte);
//        String signDataHex = HexUtil.encodeHexStr(signData);
//        System.out.println("sign Hex:" + signDataHex);
        String signDataBase64 = Base64.encode(signData);
        System.out.println("sign Base64:" + signDataBase64);
        //生成token
        token = certCode + "." + timestamp + "." + signDataBase64;
        System.out.println("token:" + token);
        return token;
    }

    //获取 数据加密秘钥密文
    public String getSecret(SM2 sm2, byte[] sm4Key) {
        String secret = "";
        if(ObjectUtils.isEmpty(sm2) || ObjectUtils.isEmpty(sm4Key) || StringUtils.isBlank(keyPublic)){
            return  "";
        }

        //SM2公钥加密SM4密钥 默认就是C1C3C2
        byte[] sm2EncryptDataByte = sm2.encrypt(sm4Key, KeyType.PublicKey);
//        System.out.println("SM2 encrypt Hex:" + HexUtil.encodeHexStr(sm2EncryptDataByte));
        System.out.println("SM2 encrypt Base64:" + Base64.encode(sm2EncryptDataByte));
        secret = Base64.encode(sm2EncryptDataByte);
        return secret;
    }

    //获取 数据加密
    public String getEncrypt(String data,byte[] sm4Key) {
        String encryptData = ""; // 加密数据
        if(StringUtils.isBlank(data) || ObjectUtils.isEmpty(sm4Key)){
            return "";
        }
        // 创建SM4
        SM4 sm4 = new SM4(sm4Key);
        // 数据转换成字节数组
        byte[] dataByte = data.getBytes(StandardCharsets.UTF_8);
        //SM4数据加密
        byte[] sm4EncryptDataByte = sm4.encrypt(dataByte);
//        System.out.println("SM4 encrypt Hex:" + HexUtil.encodeHexStr(sm4EncryptDataByte));
        System.out.println("SM4 encrypt Base64:" + Base64.encode(sm4EncryptDataByte));
        encryptData = Base64.encode(sm4EncryptDataByte);
        return encryptData;
    }

    // 获取 数据解密。base64Data是返回的加密数据，base64Secret为x-lc-secret加密秘钥密文数据
    public String getDecrypt(SM2 sm2, String base64Data,String base64Secret){
        String data = "";
        if(ObjectUtils.isEmpty(sm2) || StringUtils.isBlank(base64Data) || StringUtils.isBlank(base64Secret)){
            return "";
        }
        //SM2 解密SM4密钥
        byte[] sm2EncryptDataByte = Base64.decode(base64Secret);
        byte[] sm4KeyByte = sm2.decrypt(sm2EncryptDataByte, KeyType.PrivateKey);

        //SM4解密内容
        byte[] encryptDataByte = Base64.decode(base64Data);
        SM4 sm4Me = new SM4(sm4KeyByte);
        byte[] sm4DataByteMe = sm4Me.decrypt(encryptDataByte);

        // 解密数据不为空
        if(ObjectUtils.isNotEmpty(sm4DataByteMe)){
            data = new String(sm4DataByteMe, StandardCharsets.UTF_8);
        }
        return data;
    }

    // 行政区划编号数组转换成字符串方法
    private String getXzqdmsData(String[] xzqdms){
        if(ObjectUtils.isEmpty(xzqdms)){
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < xzqdms.length; i++) {
            builder.append("\"").append(xzqdms[i]).append("\",");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    //获取公钥
    public String getKeyPublic(){
        if(StringUtils.isNotBlank(keyPublic)){
            return keyPublic;
        }
        return "";
    }
    //获取私钥
    public String getKeyPrivate(){
        if(StringUtils.isNotBlank(keyPrivate)){
            return keyPrivate;
        }
        return "";

    }
    //获取国土调查云提供服务地址
    public String getGtUrl(){
        if(StringUtils.isNotBlank(gtUrl)){
            return gtUrl;
        }
        return "";
    }
    //获取河北分中心服务地址
    public String getUrl(){
        if(StringUtils.isNotBlank(url)){
            return url;
        }
        return "";
    }
    //获取证书Base64密文
    public  String getCertCode(){
        if(StringUtils.isNotBlank(certCode)){
            return certCode;
        }
        return "";
    }

}
