package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionDJQ;
import com.geoway.landteam.landcloud.core.repository.base.RegionDJQRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class MCommonService {

    @Autowired
    StringRedisTemplate redisTemplate;

    @Autowired
    MTskTaskBizService mTskTaskBizService;

    @Autowired
    RegionVillageRepository regionVillageRepository;

    @Autowired
    RegionDJQRepository regionDJQRepository;

    public String GeneratoeSeq(String prefix,int numLength){
        String upperCode ="";
        Long size=redisTemplate.opsForList().size(prefix);//查找 prefix 的key值的数据长度
        if(size>0){//有数据
            List leve =redisTemplate.opsForList().range(prefix,0,-1);//获取该key下面的所有值(-1 所有的值，；1下一个值
            upperCode=leve.get(leve.size()-1).toString();//返回最后一个值
        }
        String returnCode="";
        int Suffix;  //后缀数字
        if (StringUtils.isNotBlank(upperCode)){ //有数据
            String sequence =upperCode.substring(prefix.length());//截取前缀开始的后面的数字
            Suffix=Integer.parseInt(sequence);
            Suffix++;//最后的序号加一
        }else{
            Suffix=1;//没有数据
        }

        returnCode=prefix+String.format("%0"+numLength+"d",Suffix);//后缀不够numLength长，前面补充0
        redisTemplate.opsForList().rightPush(prefix,returnCode);//存入Redis
        System.out.println(returnCode+"%%%");
        return  returnCode;
    }

    public JSONObject generatorSeqByBizId(String bizId, String type, Double x, Double y) throws Exception {
        JSONObject json = new JSONObject();
        String gen = null;
        String villageCode = null;
        String name = null;

        TskTaskBiz biz = mTskTaskBizService.findByTaskId(bizId);
        if (biz.getGranularity()!=null && 5 == biz.getGranularity()) {
            String wkt = String.format("POINT (%s %s)", x, y);
            List<RegionDJQ> villages = regionDJQRepository.queryContains(WKTUtil.wktToGeom(wkt));

            if (villages!=null && villages.size()>0) {
                villageCode = villages.get(0).getCode();
                name = villages.get(0).getName();
                gen = mTskTaskBizService.generatorSeqByXzqdm(bizId, type, villageCode, biz.getTableId(), null);
            }
        }

        json.put("xzqdm", villageCode);
        json.put("xzqmc", name);
        json.put("tbbh", gen);
        return json;
    }


}
