package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.ApproveRecordDTO;
import com.geoway.landteam.customtask.pub.dto.FlowStep;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeUserNew;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.*;
import com.geoway.landteam.customtask.task.enm.FlowTypeEnum;
import com.geoway.landteam.customtask.task.enm.RejectTypeEnum;
import com.geoway.landteam.customtask.task.enm.UserRoleEnum;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.customtask.util.FlowFilterUtil;
import com.geoway.landteam.landcloud.common.util.bean.MapUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ReviewStageEnum;
import com.geoway.landteam.landcloud.core.model.base.enm.TbStatusEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.constants.BizIdConstants;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.constants.NumberConst;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionTownRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.core.EnumeratorDomainService;
import com.geoway.landteam.landcloud.core.service.pub.impl.*;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.util.message.MixPushServer;
import com.geoway.landteam.landcloud.servface.customtask.task.*;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
/*import com.gw.base.data.GwValidateException;*/
import com.gw.base.data.GwValidateException;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;


import org.apache.commons.collections4.MapUtils;
import org.apache.commons.jexl3.*;
import org.apache.commons.lang3.ArrayUtils;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.javatuples.Triplet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;
import java.util.stream.Collectors;

import static com.geoway.landteam.landcloud.core.model.base.enm.TbStatusEnum.*;


/**
 * 配置任务审核服务
 */

@Service
public class MConfigTaskReviewService {
    private static final GiLoger log = GwLoger.getLoger();
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    SystemConfigCacheService systemConfigCacheService;
    @Autowired
    TbtskFlowDefRepository tbtskFlowDefRepository;
    /* @Autowired
     MTbtskTaskBizFlowService tbtskTaskBizFlowService;
     @Autowired
     TbtskTaskBizFlowMapper tbtskTaskBizFlowMapper;
     @Autowired
     TbtskRejectDefMapper tbtskRejectDefMapper;*/
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TbtskApproveRecordRepository tbtskApproveRecordRepository;
    @Autowired
    TbtskSubmitReportRecordRepository tbtskSubmitReportRecordRepository;
    @Autowired
    MDataBizService mDataBizService;
    @Autowired
    LandUser2AreaRepository landUser2AreaRepository;
    @Autowired
    TbtskRejectRecordRepository tbtskRejectRecordRepository;
    @Autowired
    RegionTownRepository regionTownRepository;
    /* @Autowired
     MTbtskFlowService MTbtskFlowService;*/
    @Autowired
    MTaskNoticeService mTaskNoticeService;
    @Autowired
    UserBiz2Repository userBiz2Repository;
    @Autowired
    MTbtskRejectDefService mTbtskRejectDefService;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    MTaskRecordService mTaskRecordService;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    TbtskGroupRepository tbtskGroupRepository;
    @Autowired
    MTbtskUserReviewAreaService mTbtskUserReviewAreaService;
    @Autowired
    MTbtskUserUploadAreaService tbtskUserUploadAreaService;
    @Autowired
    MTbtskUserAuditAreaService tbtskUserAuditAreaService;
    @Autowired
    MTbtskSuperUserAuditAreaService tbtskSuperUserAuditAreaService;
    @Autowired
    MTbtskRevokeRecordService tbtskRevokeRecordService;
    @Autowired
    UserNameService userNameService;
    @Autowired
    MTbtskUserManageAreaService tbtskUserManageAreaService;
    @Autowired
    LandUserService landUserService;

    @Autowired
    MTaskNoticeNewService mTaskNoticeNewService;

    @Autowired
    EnumeratorDomainService enumeratorDomainService;

    @Autowired
    EnumeratorValueServiceImpl enumeratorValueService;


    /**
     * 作业员提报
     *
     * @param taskId 业务id
     * @param tbIds  图斑/房屋编号，多个图斑/房屋编号之间以英文逗号隔开
     * @param type   类型，TB/FW
     * @param userId
     * @return
     */
    public String operatorSubmit(String taskId, String tbIds, String type, Long userId) {
        String result = "提报成功";
        GutilAssert.state(StringUtils.isNoneBlank(taskId), "taskId 参数不能为空.");
        GutilAssert.state(StringUtils.isNoneBlank(tbIds), "tbIds 参数不能为空.");


        boolean isBatch = tbIds.contains(",");
        if (isBatch) {
            JSONObject params = new JSONObject();
            params.put("filterType", "checkFilter");
            params.put("userId", userId);
            params.put("tbIds", tbIds);
//                params.put("type", type);
            addTaskRecord(params, userId, JobConstants.JOB_TYPE_CONFIG_TASK_SUBMIT_BATCH, taskId);
        } else {
            result = operatorSubmit(taskId, tbIds, userId);
        }

        return result;
    }

    public static void getZjggFieldNameCollection(List<String> fieldNameList) {
        fieldNameList.add("f_zzzb");
        fieldNameList.add("f_xzgdmj");
        fieldNameList.add("f_qtnydmj");
        fieldNameList.add("f_zgmj");
        fieldNameList.add("f_zgfa");
    }

    private String operatorSubmit(String taskId, String tbId, Long userId) {
        String result = "";
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        if (null == tskTaskBiz) {
            result = "提报失败，业务不存在或已被删除";
            return result;
        }
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            result = "提报失败，业务数据表不存在或已被删除";
            return result;
        }
        List<String> fieldNameList = getAuditFieldNameCollection();
        // 必有字段集合
        List<TbtskFields> requiredFields = queryRequiredFields(tbtskObjectinfo.getfId());
        if (requiredFields != null && requiredFields.size() > 0) {
            requiredFields.forEach(a -> fieldNameList.add(a.getfFieldname()));
        }

        List<String> conditionNotNullRelatedFieldNames = queryConditionNotNullRelatedFieldNames(tbtskObjectinfo.getfTablename());
        if (!GutilCollection.isEmpty(conditionNotNullRelatedFieldNames)) {
            fieldNameList.addAll(conditionNotNullRelatedFieldNames);
        }

        Map data = mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", "'" + tbId + "'");
        if (null == data) {
            result = "提报失败，图斑不存在";
            return result;
        }

        Integer status = MapUtils.getInteger(data, "f_status");
        String xzqdm = MapUtils.getString(data, "f_xzqdmsys");
        Integer rejectCount = MapUtils.getInteger(data, "f_reject_count", 0);
        if (status != null) {
            if ((status >= TbStatusEnum.SUBMIT.getCode()
                    && status < TbStatusEnum.WAITING_VERIFY.getCode())
                    || status == TbStatusEnum.INIT.getCode()) {
                Triplet checkResult = checkDataBeforeSubmit(data, tbtskObjectinfo, taskId);
                if ((Boolean) checkResult.getValue0()) {
                    ReviewStageEnum reviewStage = getFirstStageOfFlow(taskId);
                    // 更新为提报状态并将打回状态设置为未打回
                    String updateSql = "f_status= " + TbStatusEnum.WAITING_VERIFY.getCode() + " ,f_reject_status= 0 ,f_review_stage=" + reviewStage.getCode();
                    int row = mDataBizService.updateBySql(tbtskObjectinfo.getfTablename(), updateSql, "f_id ='" + tbId + "'");
                    if (row == 1) {
                        // 保存提报记录表
                        saveConfigTaskSubmitReportRecord(taskId, tbId, xzqdm, rejectCount, userId);

                        //TODO 查找图斑的下发人员，发送app消息
                        //sendSubmitMessageApp(taskId,tskTaskBiz.getName(), tbId, userId, "");
                        result = "提报成功";
                    } else {
                        result = "提报失败";
                    }
                } else {
                    String error = (String) checkResult.getValue2();
                    if (StringUtils.isNotBlank(error)) {
                        result = "提报失败:" + error;
                    } else {
                        result = "提报失败";
                    }
                }
            } else {
                result = "提报失败，图斑已提报，不能重复提报";
            }
        } else {
            // 更新为提报状态并将打回状态设置为未打回
            ReviewStageEnum reviewStage = getFirstStageOfFlow(taskId);
            String updateSql = "f_status= " + TbStatusEnum.WAITING_VERIFY.getCode() + " ,f_reject_status= 0 ,f_review_stage=" + reviewStage.getCode();
            int row = mDataBizService.updateBySql(tbtskObjectinfo.getfTablename(), updateSql, "f_id ='" + tbId + "'");
            if (row == 1) {
                // 保存提报记录表
                saveConfigTaskSubmitReportRecord(taskId, tbId, xzqdm, rejectCount, userId);

                //TODO 查找图斑的下发人员，发送app消息
                //sendSubmitMessageApp(taskId,tskTaskBiz.getName(), tbId, userId, "");
                result = "提报成功";
            } else {
                result = "提报失败";
            }
        }

        return result;
    }


    private Triplet<Boolean, String, String> checkConditionNotNullFields(Map map, String tableName) {
//        Triplet<Boolean, String, String>
        HashMap<Integer, Object> remap = new HashMap<>();

        List<String> errorList = new ArrayList<>();

        List<TbtskGroup> tbtskGroupList = queryConditionRequiredFields(tableName);
        if (!GutilCollection.isEmpty(tbtskGroupList)) {
            try {
                JSONObject connJsonObj = null;
                JSONArray refJsonArray = null;
                JSONArray effectsJsonArray = null;
                JSONObject refSingleJsonObj = null;
                JSONObject effectSingleJsonObj = null;
                JSONObject correctCheckJsonObj = null;

                JexlBuilder jexlB = new JexlBuilder();
                JexlContext jc = new MapContext();

                for (TbtskGroup tbtskGroup : tbtskGroupList) {
                    connJsonObj = JSONObject.parseObject(tbtskGroup.getConnection());
                    if (null != connJsonObj) {
                        refJsonArray = JSONArray.parseArray(JSONArray.toJSONString(connJsonObj.get("ref")));
                        if (null != refJsonArray) {
                            for (Object obj : refJsonArray) {
                                refSingleJsonObj = JSONObject.parseObject(JSONArray.toJSONString(obj));
                                if (null != refSingleJsonObj) {
                                    effectsJsonArray = JSONArray.parseArray(JSONArray.toJSONString(refSingleJsonObj.get("effects")));
                                    if (null != effectsJsonArray) {
                                        for (Object effectObj : effectsJsonArray) {
                                            effectSingleJsonObj = JSONObject.parseObject(JSONArray.toJSONString(effectObj));
                                            if (null != effectSingleJsonObj) {
                                                if (effectSingleJsonObj.getIntValue("required") == NumberConst.ONE) {

                                                    HashMap<String, Object> valueMap = new HashMap<>();
                                                    String[] fields = refSingleJsonObj.getString("fields").split(",");
                                                    for (int i = 0; i < fields.length; i++) {
                                                        valueMap.put(fields[i], map.get(fields[i]));
                                                    }

                                                    Object o = evaluateExpression(jexlB, jc, refSingleJsonObj.getString("condition"), valueMap);
                                                    if ((boolean) o) {
                                                        if (map.get(effectSingleJsonObj.get("targetFiled").toString()) != null
                                                                && StringUtils.isNotBlank(map.get(effectSingleJsonObj.get("targetFiled").toString()).toString())) {
                                                        } else {
                                                            String errorMsg = " 值不符合要求";
                                                            correctCheckJsonObj = JSONObject.parseObject(refSingleJsonObj.getString("correctCheck"));
                                                            if (null != correctCheckJsonObj && correctCheckJsonObj.containsKey("errorMessage")) {
                                                                if (StringUtils.isNotBlank(correctCheckJsonObj.getString("errorMessage")) && !"null".equalsIgnoreCase(correctCheckJsonObj.getString("errorMessage"))) {
                                                                    errorMsg = correctCheckJsonObj.getString("errorMessage");
                                                                }
                                                            }
                                                            errorList.add(tbtskGroup.getfAlias() + errorMsg);
                                                            //return new Triplet<>(false, map.get("f_id").toString(), tbtskGroup.getfAlias() + errorMsg);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

            } catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error(e.getMessage());
                }
                errorList.add("不符合条件必填要求" + e.getMessage());
                //return new Triplet<>(false, map.get("f_id").toString(), "不符合条件必填要求" + e.getMessage());
            }
        }

        if (!GutilCollection.isEmpty(errorList)) {
            return new Triplet<>(false, map.get("f_id").toString(), StringUtils.join(errorList, ","));

        } else {
            return new Triplet<>(true, map.get("f_id").toString(), "");

        }
    }

    private Object evaluateExpression(JexlBuilder jexlB, JexlContext jexlContext, String jexlExp, HashMap<String, Object> map) {
        JexlEngine jexl = jexlB.create();
        JexlExpression e = jexl.createExpression(jexlExp);

        for (String key : map.keySet()) {
            jexlContext.set(key, map.get(key));
        }

        return e.evaluate(jexlContext);
    }

    /**
     * 查询必填字段
     * 必填字段包括：
     * 1、配置中明确要求的不能为空的内业和外业字段。
     * 2、可编辑的内业字段(可能被编辑，有没有填写的可能)。
     * 3、条件必填的字段
     * 4、条件可编辑内业字段
     *
     * @param tableId
     * @return
     */
    private List<TbtskFields> queryRequiredFields(String tableId) {
        List<TbtskFields> notNullFieldList = tbtskFieldsRepository.queryNotNullFieldsByTableId(tableId);
        return notNullFieldList;
    }

    private List<TbtskGroup> queryConditionRequiredFields(String tableName) {
        return tbtskGroupRepository.queryConditionNotNullFields(tableName);
    }

    /**
     * 查询条件必填字段名
     *
     * @param tableName
     * @return
     */
    private List<String> queryConditionNotNullRelatedFieldNames(String tableName) {
        //List<String> result = new ArrayList<>();
        HashSet<String> result = new HashSet<>();
        List<TbtskGroup> tbtskGroupList = queryConditionRequiredFields(tableName);
        if (!GutilCollection.isEmpty(tbtskGroupList)) {
            JSONObject connJsonObj = null;
            JSONArray refJsonArray = null;
            JSONArray effectsJsonArray = null;
            JSONObject refSingleJsonObj = null;
            JSONObject effectSingleJsonObj = null;
            try {
                for (TbtskGroup tbtskGroup : tbtskGroupList) {
                    connJsonObj = JSONObject.parseObject(tbtskGroup.getConnection());
                    if (null != connJsonObj) {
                        refJsonArray = JSONArray.parseArray(JSONArray.toJSONString(connJsonObj.get("ref")));
                        if (null != refJsonArray) {
                            for (Object obj : refJsonArray) {
                                refSingleJsonObj = JSONObject.parseObject(JSONArray.toJSONString(obj));
                                if (null != refSingleJsonObj) {
                                    effectsJsonArray = JSONArray.parseArray(JSONArray.toJSONString(refSingleJsonObj.get("effects")));
                                    if (null != effectsJsonArray) {
                                        for (Object effectObj : effectsJsonArray) {
                                            effectSingleJsonObj = JSONObject.parseObject(JSONArray.toJSONString(effectObj));
                                            if (null != effectSingleJsonObj) {
                                                if (effectSingleJsonObj.getIntValue("required") == NumberConst.ONE) {
                                                    result.add(effectSingleJsonObj.getString("targetFiled"));
                                                    if (!result.contains(result.add(refSingleJsonObj.getString("fields")))) {
                                                        result.add(refSingleJsonObj.getString("fields"));
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

            } catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error(e.getMessage());
                }
            }
        }

        return result.stream().collect(Collectors.toList());
    }

    /**
     * 获取流程的第一个审核阶段
     *
     * @param taskId 任务id
     * @return
     */
    private ReviewStageEnum getFirstStageOfFlow(String taskId) {
        List<TbtskFlowDef> flowDefList = tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, FlowTypeEnum.AUDIT.getCode());
        if (!GutilCollection.isEmpty(flowDefList)) {
            TbtskFlowDef flowDef = flowDefList.get(0);
            if (StringUtils.isNotBlank(flowDef.getSteps())) {
                JSONArray jsonArray = JSONArray.parseArray(flowDef.getSteps());
                if (jsonArray != null && !jsonArray.isEmpty()) {
                    Object firstStepObj = jsonArray.get(0);
                    if (firstStepObj != null) {
                        JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(firstStepObj));
                        if (jsonObject != null && jsonObject.containsKey("name") && StringUtils.isNotBlank(jsonObject.get("name").toString())) {
                            switch (jsonObject.get("name").toString()) {
                                case "村级审核":
                                    return ReviewStageEnum.VILLAGE_VERIFY;
                                case "乡镇审核":
                                    return ReviewStageEnum.TOWN_VERIFY;
                                case "区县审核":
                                    return ReviewStageEnum.COUNTY_VERIFY;
                                case "市级审核":
                                    return ReviewStageEnum.CITY_VERIFY;
                                case "省级审核":
                                    return ReviewStageEnum.PROVINCE_VERIFY;
                                case "国家审核":
                                    return ReviewStageEnum.COUNTRY_VERIFY;
                                default:
                                    return ReviewStageEnum.VILLAGE_VERIFY;
                            }
                        }
                    }
                }
            }
        }

        return ReviewStageEnum.VILLAGE_VERIFY;
    }

    private void saveConfigTaskSubmitReportRecord(String taskId, String id, String xzqdm, Integer rejectCount, Long userId) {
        TbtskSubmitReportRecord submitReportRecord = TbtskSubmitReportRecord.builder()
                .taskid(taskId)
                .dataid(id)
                .submitTime(new Date())
                .submitUserid(userId)
                .xzqdm(xzqdm)
                .rejectCount(rejectCount)
                .build();

        tbtskSubmitReportRecordRepository.save(submitReportRecord);
    }

    public static List<String> getAuditFieldNameCollection() {
        List<String> fieldNameList = new ArrayList<>();
        fieldNameList.add("f_id");
        fieldNameList.add("f_status");
        fieldNameList.add("f_xzqdmsys");
        fieldNameList.add("f_reject_status");
        fieldNameList.add("f_review_stage");
        fieldNameList.add("f_reject_count");
        return fieldNameList;
    }

    /**
     * 提报之前检查数据是否符合提报要求，比如必填字段是否已填，是否已提交附件
     *
     * @param data
     * @return
     */
    public Triplet checkDataBeforeSubmit(Map data, TbtskObjectinfo tbtskObjectinfo, String taskId) {
        List<String> errorList = new ArrayList<>();
        if (data.get("f_id") == null || StringUtils.isBlank(data.get("f_id").toString())) {
            errorList.add("数据不能为空且id不能为空");
            return new Triplet<>(false, "", "数据不能为空且id不能为空");
        }
        if (StringUtils.isBlank(data.get("f_xzqdmsys").toString())) {
            errorList.add("政区代码 不能为空");
        }

        List<AppMedia> appMedias = appMediaRepository.queryByGid(data.get("f_id").toString());
        //获取四川天府配置不需要校验附件可以提报任务
        SysConfig sysConfig = sysConfigService.findOne("scgtyCheckAttr");
        if (sysConfig != null) {
            if (!sysConfig.getValue().contains(taskId)) {
                if (appMedias.size() <= 0) {
                    errorList.add("缺失附件");
                }
            }
        } else {
            if (appMedias.size() <= 0) {
                errorList.add("缺失附件");
            }
        }


        // 必有字段集合校验
        List<TbtskFields> requiredFields = queryRequiredFields(tbtskObjectinfo.getfId());
        if (requiredFields != null && requiredFields.size() > 0) {
            for (TbtskFields tbtskFields : requiredFields) {

                if (!data.containsKey(tbtskFields.getfFieldname())) {
                    errorList.add(tbtskFields.getfAlias() + "不能为空");
                } else {
                    if (data.get(tbtskFields.getfFieldname()) == null || StringUtils.isBlank(data.get(tbtskFields.getfFieldname()).toString())) {
                        errorList.add(tbtskFields.getfAlias() + "不能为空");
                    }
                }
            }
        }

        // 检查条件必填字段
        Triplet<Boolean, String, String> tempResult = checkConditionNotNullFields(data, tbtskObjectinfo.getfTablename());
        if (!tempResult.getValue0()) {
            errorList.add(tempResult.getValue2());
        }

        if (!GutilCollection.isEmpty(errorList)) {
            return new Triplet<Boolean, String, String>(false, data.get("f_id").toString(), StringUtils.join(errorList, ","));
        } else {
            return new Triplet<Boolean, String, String>(true, data.get("f_id").toString(), "");
        }
    }

    /**
     * 添加定时任务记录
     *
     * @param params
     * @param userId
     * @param taskType
     * @param bizId
     */
    public void addTaskRecord(JSONObject params, Long userId, Integer taskType, String bizId) {
        TaskRecord record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString(params));
        record.setTasktype(taskType);
        record.setStarttime(new Date());
        record.setState(1);
        record.setUserid(userId);
        record.setBizId(bizId);
        mTaskRecordService.save(record);
    }

    /**
     * 查询获取对应图斑的审核记录
     */
    public List<ApproveRecordDTO> findApproveRecord(String taskId, String tbId, String type, Long UserId, Integer userRole) {
        GutilAssert.state(StringUtils.isNoneBlank(taskId), "taskId 参数不能为空.");

        List<ApproveRecordDTO> resultList = new ArrayList<>();
        UserRoleEnum roleEnum = getUserRoleWithPriority(taskId, UserId, userRole);
        switch (roleEnum.getCode()) {
            case 3: {
                // 如果用户仅是作业员，则仅返回打回记录
                resultList = getRejectRecords(taskId, tbId);
                break;
            }
            case 0:
            case 1:
            case 2:
            case 4:
            default:
                resultList = getApproveRecordsAndRejectRecords(taskId, tbId);
                break;
        }

        if (!GutilCollection.isEmpty(resultList)) {
            Collections.sort(resultList, new Comparator<ApproveRecordDTO>() {
                @Override
                public int compare(ApproveRecordDTO o1, ApproveRecordDTO o2) {
                    int flag = o2.getApproveTime().compareTo(o1.getApproveTime());
                    return flag;
                }
            });
        }
        return resultList;
    }

    /**
     * 获取用户身份
     *
     * @param taskId       业务编号
     * @param userId       用户id
     * @param priorityRole 优先的用户身份
     * @return 对于拥有多个角色的用户，优先返回其多个角色中包含 priorityRole参数的角色，
     * 如果priorityRole未指定或者用户拥有的角色中不包含priorityRole，则返回其角色集合中权限最大的角色
     */
    private UserRoleEnum getUserRoleWithPriority(String taskId, Long userId, Integer priorityRole) {

        Integer tempRole = Integer.MAX_VALUE;
        List<UserBiz2> userBiz2List = userBiz2Repository.findByUserIdAndBizId(userId, taskId);
        if (!GutilCollection.isEmpty(userBiz2List)) {
            boolean existPriorityRole = false;
            if (priorityRole != null) {
                existPriorityRole = userBiz2List.stream().filter(role -> role.getRole().equals(priorityRole)).findAny().isPresent();
            }
            if (existPriorityRole) {
                tempRole = priorityRole;
            } else {
                // 对于既是作业员，又是管理员的任务，则取其权限大的，取管理员身份;同理如果又是创建者，则取创建者身份
                for (UserBiz2 userBiz2 : userBiz2List) {
                    if (userBiz2.getRole().intValue() == 4) {
                        // 复核员
                        if (tempRole.intValue() == 3) {
                            tempRole = 4;
                        }
                    } else {
                        if (userBiz2.getRole() < tempRole) {
                            tempRole = userBiz2.getRole();
                        }
                    }
                }
            }
        }

        if (tempRole.intValue() != Integer.MAX_VALUE) {
            return UserRoleEnum.getEnum(tempRole);
        } else {
            return UserRoleEnum.UNDEFINED;
        }
    }


    /**
     * 获取打回记录
     *
     * @param taskId
     * @param tbId
     * @return
     */
    private List<ApproveRecordDTO> getRejectRecords(String taskId, String tbId) {
        List<ApproveRecordDTO> resultList = new ArrayList<>();
        List<TbtskRejectRecord> rejectRecords = tbtskRejectRecordRepository.findByTaskIdAndTbId(taskId, tbId);
        if (!GutilCollection.isEmpty(rejectRecords)) {
            for (TbtskRejectRecord rejectRecord : rejectRecords) {
                if (rejectRecord.getTargetStage().equals(ReviewStageEnum.OPERATOR_VERIFY.getCode())) {
                    ApproveRecordDTO approveRecord = convertRejectRecord2ApproveRecordDTO(rejectRecord);
                    resultList.add(approveRecord);
                }
            }
        }

        return resultList;
    }

    /**
     * 所有的审核记录和打回记录及撤回的记录
     *
     * @param taskId
     * @param tbId
     * @return
     */
    private List<ApproveRecordDTO> getApproveRecordsAndRejectRecords(String taskId, String tbId) {
        // 如果用户是审核员或者复核员，则返回所有的审核记录和打回记录及撤回的记录
        List<ApproveRecordDTO> resultList = new ArrayList<>();

        List<TbtskApproveRecord> approveRecords = tbtskApproveRecordRepository.findApproveRecordOrderByTime(taskId, tbId);
        if (!GutilCollection.isEmpty(approveRecords)) {
            for (TbtskApproveRecord tbtskApproveRecord : approveRecords) {
                ApproveRecordDTO approveRecord = convertApproveRecord2ApproveRecordDTO(tbtskApproveRecord);
                resultList.add(approveRecord);
            }
        }

        List<TbtskRejectRecord> rejectRecords = tbtskRejectRecordRepository.findByTaskIdAndTbId(taskId, tbId);
        if (!GutilCollection.isEmpty(rejectRecords)) {
            for (TbtskRejectRecord rejectRecord : rejectRecords) {
                ApproveRecordDTO approveRecord = convertRejectRecord2ApproveRecordDTO(rejectRecord);
                resultList.add(approveRecord);
            }
        }

        List<TbtskRevokeRecord> revokeRecords = tbtskRevokeRecordService.selectByTaskIdAndTbId(taskId, tbId);
        if (!GutilCollection.isEmpty(revokeRecords)) {
            for (TbtskRevokeRecord revokeRecord : revokeRecords) {
                ApproveRecordDTO approveRecord = convertRevokeRecord2ApproveRecordDTO(revokeRecord);
                resultList.add(approveRecord);
            }
        }
        return resultList;
    }

    private ApproveRecordDTO convertApproveRecord2ApproveRecordDTO(TbtskApproveRecord approveRecord) {
        ApproveRecordDTO dto = new ApproveRecordDTO();
        dto.setStatus(approveRecord.getStatus());
        dto.setOption(approveRecord.getOption());
        dto.setApproveUserId(approveRecord.getApproveUserId());
        dto.setApproveUser(approveRecord.getApproveUser());
        dto.setApproveTime(approveRecord.getApproveTime());
        dto.setDescription(approveRecord.getDescription());
        dto.setId(approveRecord.getId());
        dto.setRemark(approveRecord.getRemark());
        dto.setTaskid(approveRecord.getTaskid());
        dto.setTbid(approveRecord.getTbid());
        dto.setStepname(approveRecord.getStepname());
        dto.setStepindex(approveRecord.getStepindex());
        dto.setNextstep(approveRecord.getNextstep());
        dto.setType(1);
        dto.setWflx(approveRecord.getWflx());
        return dto;
    }

    private ApproveRecordDTO convertRevokeRecord2ApproveRecordDTO(TbtskRevokeRecord revokeRecord) {
        ApproveRecordDTO dto = new ApproveRecordDTO();
        dto.setStatus(1);
        dto.setOption(1);
        dto.setApproveUserId(revokeRecord.getUserId());
        dto.setApproveUser(revokeRecord.getUserName());
        dto.setApproveTime(revokeRecord.getRevokeTime());
        dto.setDescription("");
        dto.setId(revokeRecord.getId());
        dto.setRemark(revokeRecord.getRemark());
        dto.setTaskid(revokeRecord.getTaskId());
        dto.setTbid(revokeRecord.getTbId());
        dto.setStepname(revokeRecord.getStepName());
        dto.setStepindex(0);
        dto.setNextstep(1);
        dto.setType(3);
        return dto;
    }

    private ApproveRecordDTO convertRejectRecord2ApproveRecordDTO(TbtskRejectRecord rejectRecord) {
        ApproveRecordDTO dto = new ApproveRecordDTO();
        dto.setStatus(1);
        dto.setOption(2);
        dto.setApproveUserId(rejectRecord.getUserId());
        dto.setApproveUser(rejectRecord.getUserName());
        dto.setApproveTime(rejectRecord.getRejectTime());
        dto.setDescription(rejectRecord.getDescription());
        dto.setId(rejectRecord.getId());
        dto.setRemark(rejectRecord.getRemark());
        dto.setTaskid(rejectRecord.getTaskid());
        dto.setTbid(rejectRecord.getTbid());
        dto.setStepname(rejectRecord.getStepName());
        dto.setStepindex(0);
        dto.setNextstep(1);
        dto.setType(2);
        return dto;
    }

    /**
     * 根据userid获取用户角色
     *
     * @param taskId
     * @param userId
     * @return 返回用户角色信息
     */
    public List<Integer> getUserRole(String taskId, Long userId) {
        GutilAssert.state(StringUtils.isNoneBlank(taskId), "taskId 参数不能为空.");
        List<Integer> result = new ArrayList<>();
        // 配置任务
        List<UserBiz2> userBiz2List = userBiz2Repository.findByUserId(userId);
        if (!GutilCollection.isEmpty(userBiz2List)) {
            for (UserBiz2 userBiz2 : userBiz2List) {
                if (StringUtils.isNotBlank(userBiz2.getBizId()) && userBiz2.getBizId().equalsIgnoreCase(taskId)) {
                    if (userBiz2.getRole() != null) {
                        result.add(userBiz2.getRole());
                    }
                }
            }
        }
        return result;
    }

    public Map checkAuditPermission(String taskId, String tbId, Long userId) {
        Map resultMap = new HashMap();
        resultMap.put("hasPermission", false);
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        if (null == tskTaskBiz) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "业务不存在或已被删除");
            return resultMap;
        }
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "业务数据表不存在或已被删除");
            return resultMap;
        }
        List<String> fieldNameList = getAuditFieldNameCollection();

        Map data = mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", "'" + tbId + "'");
        if (null == data) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "图斑不存在");
            return resultMap;
        }
        Integer status = MapUtils.getInteger(data, "f_status", null);
        String xzqdm = MapUtils.getString(data, "f_xzqdmsys", "");
        Integer reviewStage = MapUtils.getInteger(data, "f_review_stage", null);
        Integer rejectCount = MapUtils.getInteger(data, "f_reject_count", 0);
        Integer rejectStatus = MapUtils.getInteger(data, "f_reject_status", null);

        if (status == null || status < WAITING_VERIFY.getCode()) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "未提报，不能审核");
            return resultMap;
        }
        if (reviewStage != null && reviewStage.equals(ReviewStageEnum.OVER_VERIFY)) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "审核已结束，不能审核");
            return resultMap;
        }
        FlowStep currentStep = getStepByReviewStageAndStatus(taskId, ReviewStageEnum.getEnum(reviewStage), TbStatusEnum.getEnum(status));

        String statusFilter = currentStep.getPre_status();
        String[] statusArray = null;
        if (StringUtils.isNotBlank(statusFilter)) {
            statusArray = statusFilter.split(",");
        }
        if (statusArray != null) {
            // 图斑状态未达到预设状态时，不能审核
            if (!ArrayUtils.contains(statusArray, status.toString())) {
                return resultMap;
            }
        }

        String stageFilter = currentStep.getPre_stages();
        String[] stagesArray = null;
        if (StringUtils.isNotBlank(stageFilter)) {
            stagesArray = stageFilter.split(",");
        }
        if (stagesArray != null) {
            if (!ArrayUtils.contains(stagesArray, reviewStage.toString())) {
                return resultMap;
            }
        }
        String filter = currentStep.getFilter();
        xzqdm = processRegionCode(xzqdm, currentStep.getName());
        List<String> userRegions = landUser2AreaRepository.queryAreas(userId);
        String userSql = FlowFilterUtil.filterUserSql(filter, userRegions.get(0), xzqdm, taskId);
        List<Map<String, Object>> userList = jdbcTemplate.query(userSql, new RowMapper<Map<String, Object>>() {
            @Override
            public Map<String, Object> mapRow(ResultSet resultSet, int i) throws SQLException {
                Map<String, Object> temp = new HashMap<>();
                temp.put("userid", resultSet.getObject("f_userid"));
                temp.put("username", resultSet.getObject("f_username"));
                return temp;
            }
        });
        if (userList != null && userList.size() > 0) {
            for (int k = 0; k < userList.size(); k++) {
                Long temUserId = Long.parseLong(userList.get(k).get("userid").toString());
                if (temUserId.equals(userId)) {
                    resultMap.put("hasPermission", true);
                    resultMap.put("stepIndex", currentStep.getIndex());
                    resultMap.put("stepName", currentStep.getName());
                    FlowStep preStep = getPreviousFlowStep(taskId, currentStep);
                    resultMap.put("preStepName", preStep.getName());

                    TbtskRejectDef rejectDef = mTbtskRejectDefService.selectByTaskId(taskId);
                    if (rejectDef != null) {
                        resultMap.put("canReject", rejectDef.getRejectType() != 0);
                        resultMap.put("rejectType", rejectDef.getRejectType());
                    } else {
                        resultMap.put("canReject", false);
                    }
                    return resultMap;
                }
            }
        }
//        Map permissionMap = queryPermissionByFilter(taskId, tbId, userId, xzqdm, status, reviewStage, rejectCount, rejectStatus);
//        if (permissionMap != null) {
//            for (Object key : permissionMap.keySet()) {
//                resultMap.put(key.toString(), permissionMap.get(key));
//            }
//        }
        return resultMap;
    }

    private FlowStep getPreviousFlowStep(String taskId, FlowStep currentStep) {
        if (StringUtils.isBlank(taskId)) {
            return null;
        }
        List<FlowStep> flowSteps = findFlowSteps(taskId, FlowTypeEnum.AUDIT);
        if (GutilCollection.isEmpty(flowSteps)) {
            return null;
        }
        return getPreviousFlowStep(flowSteps, currentStep);
    }

    private FlowStep getPreviousFlowStep(List<FlowStep> flowSteps, FlowStep currentStep) {
        if (GutilCollection.isEmpty(flowSteps)) {
            return null;
        }
        for (int i = 0; i < flowSteps.size(); i++) {
            if (flowSteps.get(i).getName().equalsIgnoreCase(currentStep.getName())) {
                if (i == 0) {
                    // TODO  这里待检查zkn
                    FlowStep step = new FlowStep();
                    step.setContainReview(currentStep.getContainReview());
                    step.setIndex(-1);
                    step.setIs_end(false);
                    step.setIs_start(false);
                    step.setName("作业员核实");
                    return step;
                } else {
                    return flowSteps.get(i - 1);
                }
            }
        }
        return null;
    }


    private Map queryPermissionByFilter(String taskId, String tbId, Long userId, String dataRegionCode, Integer status, Integer reviewStage, Integer rejectCount, Integer rejectStatus) {
        Map resultMap = new HashMap();
        resultMap.put("hasPermission", false);
        if (rejectStatus == null || rejectStatus.equals(NumberConst.ZERO)) {
            // 当前没有处于被打回状态
            List<FlowStep> flowSteps = findFlowSteps(taskId, FlowTypeEnum.AUDIT);
            if (flowSteps == null || flowSteps.size() == 0) {
                return resultMap;
            }
            if (StringUtils.isBlank(dataRegionCode) || status == null || reviewStage == null) {
                return resultMap;
            }
            resultMap = validateFlowStage(taskId, tbId, userId, dataRegionCode, status, reviewStage, rejectCount, resultMap, flowSteps);
        } else if (rejectStatus.equals(NumberConst.ONE)) {
            // 当前处于被打回状态
            TbtskRejectRecord rejectRecord = tbtskRejectRecordRepository.findTopOneByTbIdOrderByRejectTime(taskId, tbId);
            if (rejectRecord != null) {
                if (rejectRecord.getTargetStage().equals(ReviewStageEnum.OPERATOR_VERIFY.getCode())) {
                    // 如果是作业员，则不符合，作业员只有提报的权限
                    return resultMap;
                } else {
                    if (reviewStage.equals(rejectRecord.getTargetStage())) {
                        List<FlowStep> flowSteps = getAuditFlowSteps(taskId);
                        if (flowSteps == null || flowSteps.size() == 0) {
                            return resultMap;
                        }
                        //仅仅考虑一个用户有一个区域情形，如果多个会有bug,需要完善。
                        List<String> userRegions = landUser2AreaRepository.queryAreas(userId);
                        ReviewStageEnum reviewStageEnum = getFirstStageOfFlow(taskId);

                        boolean hasReview = containsReviewStep(flowSteps);
                        boolean isFirstStage = false;
                        for (int j = 0; j < flowSteps.size(); j++) {
                            FlowStep flowStep = flowSteps.get(j);
                            if (!hasReview) {
                                isFirstStage = reviewStage.equals(reviewStageEnum.getCode());
                            } else {
                                isFirstStage = reviewStage.equals(reviewStageEnum.getCode()) && (status.equals(WAITING_VERIFY));
                            }
                            if (isFirstStage || reviewStage.toString().equals(flowStep.getPost_stage())) {
                                if (isFirstStage) {
                                    flowStep = flowSteps.get(0);
                                } else {
                                    if (j < flowSteps.size() - 1) {
                                        flowStep = flowSteps.get(j + 1);
                                    }
                                }

                                String statusFilter = flowStep.getPre_status();
                                String[] statusArray = null;
                                if (StringUtils.isNotBlank(statusFilter)) {
                                    statusArray = statusFilter.split(",");
                                }
                                if (statusArray != null) {
                                    // 图斑状态未达到预设状态时，不能审核
                                    if (!ArrayUtils.contains(statusArray, status.toString())) {
                                        return resultMap;
                                    }
                                }

                                String stageFilter = flowStep.getPre_stages();
                                String[] stagesArray = null;
                                if (StringUtils.isNotBlank(stageFilter)) {
                                    stagesArray = stageFilter.split(",");
                                }
                                if (stagesArray != null) {
                                    if (!ArrayUtils.contains(stagesArray, reviewStage.toString())) {
                                        return resultMap;
                                    }
                                }
                                String filter = flowStep.getFilter();
                                dataRegionCode = processRegionCode(dataRegionCode, flowStep.getName());
                                String userSql = FlowFilterUtil.filterUserSql(filter, userRegions.get(0), dataRegionCode, taskId);
                                List<Map<String, Object>> userList = jdbcTemplate.query(userSql, new RowMapper<Map<String, Object>>() {
                                    @Override
                                    public Map<String, Object> mapRow(ResultSet resultSet, int i) throws SQLException {
                                        Map<String, Object> temp = new HashMap<>();
                                        temp.put("userid", resultSet.getObject("f_userid"));
                                        temp.put("username", resultSet.getObject("f_username"));
                                        return temp;
                                    }
                                });
                                if (userList != null && userList.size() > 0) {
                                    for (int k = 0; k < userList.size(); k++) {
                                        Long temUserId = Long.parseLong(userList.get(k).get("userid").toString());
                                        if (temUserId.equals(userId)) {
                                            resultMap.put("hasPermission", true);
                                            resultMap.put("stepIndex", flowStep.getIndex());
                                            resultMap.put("stepName", flowStep.getName());
                                            if (j > 0) {
                                                FlowStep preStep = flowSteps.get(j - 1);
                                                resultMap.put("preStepName", preStep.getName());
                                            } else {
                                                if (!hasReview) {
                                                    resultMap.put("preStepName", "作业员核实");
                                                } else {
                                                    resultMap.put("preStepName", flowSteps.get(j).getName());
                                                }
                                            }

                                            TbtskRejectDef rejectDef = mTbtskRejectDefService.selectByTaskId(taskId);
                                            if (rejectDef != null) {
                                                resultMap.put("canReject", rejectDef.getRejectType() != 0);
                                                resultMap.put("rejectType", rejectDef.getRejectType());
                                            } else {
                                                resultMap.put("canReject", false);
                                            }
                                            return resultMap;
                                        }
                                    }
                                }

                                break;
                            }
                        }

                    }
                }
            }
        }
        return resultMap;
    }

    private ReviewStageEnum getPreviousStage(String taskId, String tbId, ReviewStageEnum currentStage) {
        if (StringUtils.isBlank(taskId) || StringUtils.isBlank(tbId)) {
            return null;
        }
        List<FlowStep> flowSteps = findFlowSteps(taskId, FlowTypeEnum.AUDIT);
        if (GutilCollection.isEmpty(flowSteps)) {
            return null;
        }
        return getPreviousStage(flowSteps, tbId, currentStage);
    }

    private ReviewStageEnum getPreviousStage(List<FlowStep> flowSteps, String tbId, ReviewStageEnum currentStage) {
        if (GutilCollection.isEmpty(flowSteps) || StringUtils.isBlank(tbId)) {
            return null;
        }
        for (int i = 0; i < flowSteps.size(); i++) {
            if (flowSteps.get(i).getName().equalsIgnoreCase(currentStage.getName())) {
                if (i == 0) {
                    return ReviewStageEnum.OPERATOR_VERIFY;
                } else {
                    return getStageByStep(flowSteps.get(i - 1));
                }
            }
        }
        return null;
    }

    private ReviewStageEnum getNextStage(String taskId, ReviewStageEnum currentStage) {
        if (StringUtils.isBlank(taskId)) {
            return null;
        }
        List<FlowStep> flowSteps = findFlowSteps(taskId, FlowTypeEnum.AUDIT);
        if (GutilCollection.isEmpty(flowSteps)) {
            return null;
        }
        return getNextStage(flowSteps, currentStage);
    }

    private ReviewStageEnum getNextStage(List<FlowStep> flowSteps, ReviewStageEnum currentStage) {
        if (GutilCollection.isEmpty(flowSteps)) {
            return null;
        }
        for (int i = 0; i < flowSteps.size(); i++) {
            if (flowSteps.get(i).getName().equalsIgnoreCase(currentStage.getName())) {
                if (i == flowSteps.size() - 1) {
                    return ReviewStageEnum.OVER_VERIFY;
                } else {
                    return getStageByStep(flowSteps.get(i));
                }
            }
        }
        return null;
    }

    private ReviewStageEnum getStageByStep(FlowStep step) {
        String[] stagesArray = null;
        if (StringUtils.isNotBlank(step.getPre_stages())) {
            stagesArray = step.getPre_stages().split(",");
        }
        if (stagesArray != null) {
            if (stagesArray.length == 2) {
                return ReviewStageEnum.getEnum(Integer.parseInt(stagesArray[1]));
            } else if (stagesArray.length == 1) {
                return ReviewStageEnum.getEnum(Integer.parseInt(stagesArray[0]));
            }
        }
        return null;
    }

    private FlowStep getStepByReviewStageAndStatus(String taskId, Integer currentStage, Integer status) {
        if (StringUtils.isBlank(taskId)) {
            return null;
        }
        List<FlowStep> flowSteps = findFlowSteps(taskId, FlowTypeEnum.AUDIT);
        if (GutilCollection.isEmpty(flowSteps)) {
            return null;
        }
        return getStepByReviewStageAndStatus(flowSteps, ReviewStageEnum.getEnum(currentStage), TbStatusEnum.getEnum(status));
    }

    private FlowStep getStepByReviewStageAndStatus(String taskId, ReviewStageEnum currentStage, TbStatusEnum status) {
        if (StringUtils.isBlank(taskId)) {
            return null;
        }
        List<FlowStep> flowSteps = findFlowSteps(taskId, FlowTypeEnum.AUDIT);
        if (GutilCollection.isEmpty(flowSteps)) {
            return null;
        }
        return getStepByReviewStageAndStatus(flowSteps, currentStage, status);
    }

    private FlowStep getStepByReviewStageAndStatus(List<FlowStep> flowSteps, ReviewStageEnum currentStage, TbStatusEnum status) {
        String stepName = "";
        switch (currentStage.getCode()) {
            case 90: {
                if (status.equals(WAITING_VERIFY)) {

                } else if (status.equals(VERIFY_NOT_PASS)) {

                } else if (status.equals(WAITING_REVIEW)) {

                } else if (status.equals(REVIEW_NOT_PASS)) {

                } else {
                    stepName = "作业员核实";
                }
                break;
            }
            case 91: {
                if (status.equals(WAITING_VERIFY) || status.equals(VERIFY_NOT_PASS)) {
                    stepName = "村级审核";
                } else if (status.equals(WAITING_REVIEW) || status.equals(REVIEW_NOT_PASS)) {
                    stepName = "村级复核";
                } else {

                }
                break;
            }
            case 92: {
                if (status.equals(WAITING_VERIFY) || status.equals(VERIFY_NOT_PASS)) {
                    stepName = "乡镇审核";
                } else if (status.equals(WAITING_REVIEW) || status.equals(REVIEW_NOT_PASS)) {
                    stepName = "乡镇复核";
                } else {

                }
                break;
            }
            case 93: {
                if (status.equals(WAITING_VERIFY) || status.equals(VERIFY_NOT_PASS)) {
                    stepName = "区县审核";
                } else if (status.equals(WAITING_REVIEW) || status.equals(REVIEW_NOT_PASS)) {
                    stepName = "区县复核";
                } else {

                }
                break;
            }
            case 95: {
                if (status.equals(WAITING_VERIFY) || status.equals(VERIFY_NOT_PASS)) {
                    stepName = "市级审核";
                } else if (status.equals(WAITING_REVIEW) || status.equals(REVIEW_NOT_PASS)) {
                    stepName = "市级复核";
                } else {

                }
                break;
            }
            case 97: {
                if (status.equals(WAITING_VERIFY) || status.equals(VERIFY_NOT_PASS)) {
                    stepName = "省级审核";
                } else if (status.equals(WAITING_REVIEW) || status.equals(REVIEW_NOT_PASS)) {
                    stepName = "省级复核";
                } else {

                }
                break;
            }
            case 101: {
                if (status.equals(WAITING_VERIFY) || status.equals(VERIFY_NOT_PASS)) {
                    stepName = "国家审核";
                } else if (status.equals(WAITING_REVIEW) || status.equals(REVIEW_NOT_PASS)) {
                    stepName = "国家复核";
                } else {

                }
                break;
            }
            default: {
                break;
            }
        }

        if (!GutilCollection.isEmpty(flowSteps) && StringUtils.isNotBlank(stepName)) {
            for (FlowStep flowStep : flowSteps) {
                if (flowStep.getName().equalsIgnoreCase(stepName)) {
                    return flowStep;
                }
            }
        }
        return null;
    }

    public Map validateFlowStage(String taskId, String tbId, Long userId, String dataRegionCode, Integer status, Integer stage, Integer rejectCount, Map resultMap, List<FlowStep> flowSteps) {
        //仅仅考虑一个用户有一个区域情形，如果多个会有bug,需要完善。
        List<String> userRegions = landUser2AreaRepository.queryAreas(userId);
        TbtskApproveRecord latestRecord = tbtskApproveRecordRepository.queryNotRevokedTopOne(taskId, tbId, rejectCount);
        Integer step = null;

        if (latestRecord != null) {
            SysConfig sysConfig = sysConfigService.findOne(BizIdConstants.SCGTY_BIZ_ID);
            String ynbgdcBizId = systemConfigCacheService.querySysConfig(BizIdConstants.YN_BGDC_BIZ_ID, "");

            if (sysConfig.getValue().equalsIgnoreCase(taskId)) {
                step = latestRecord.getNextstep();
            } else {
                // 审核意见为通过时，判断下一步
                if (latestRecord.getOption().equals(1)) {
                    step = latestRecord.getNextstep();
                } else if (latestRecord.getOption().equals(2)) {
                    // 审核意见为不同通过时，判断当前一步，有可能还增加审核记录
                    step = latestRecord.getStepindex();
                } else if (latestRecord.getOption().equals(3) && latestRecord.getTaskid().equalsIgnoreCase(ynbgdcBizId)) {
                    // 审核意见为不确定时，效果同 通过，判断下一步
                    if (latestRecord.getTaskid().equalsIgnoreCase(ynbgdcBizId)) {
                        step = latestRecord.getNextstep();
                    }
                }

            }
        } else {
            step = 0;
        }

        for (int j = 0; j < flowSteps.size(); j++) {
            FlowStep flowStep = flowSteps.get(j);
            if (step.equals(flowStep.getIndex())) {
                String statusFilter = flowStep.getPre_status();
                String[] statusArray = null;
                if (StringUtils.isNotBlank(statusFilter)) {
                    statusArray = statusFilter.split(",");
                }
                if (statusArray != null) {
                    // 图斑状态未达到预设状态时，不能审核
                    if (!ArrayUtils.contains(statusArray, status.toString())) {
                        return resultMap;
                    }
                }

                String stageFilter = flowStep.getPre_stages();
                String[] stagesArray = null;
                if (StringUtils.isNotBlank(stageFilter)) {
                    stagesArray = stageFilter.split(",");
                }
                if (stagesArray != null) {
                    if (!ArrayUtils.contains(stagesArray, stage.toString())) {
                        return resultMap;
                    }
                }
                String filter = flowStep.getFilter();
                dataRegionCode = processRegionCode(dataRegionCode, flowStep.getName());
                String userSql = FlowFilterUtil.filterUserSql(filter, userRegions.get(0), dataRegionCode, taskId);
                List<Map<String, Object>> userList = jdbcTemplate.query(userSql, new RowMapper<Map<String, Object>>() {
                    @Override
                    public Map<String, Object> mapRow(ResultSet resultSet, int i) throws SQLException {
                        Map<String, Object> temp = new HashMap<>();
                        temp.put("userid", resultSet.getObject("f_userid"));
                        temp.put("username", resultSet.getObject("f_username"));
                        return temp;
                    }
                });
                if (userList != null && userList.size() > 0) {
                    for (int k = 0; k < userList.size(); k++) {
                        Long temUserId = Long.parseLong(userList.get(k).get("userid").toString());
                        if (temUserId.equals(userId)) {
                            resultMap.put("hasPermission", true);
                            resultMap.put("stepIndex", flowStep.getIndex());
                            resultMap.put("stepName", flowStep.getName());
                            if (j > 0) {
                                FlowStep preStep = flowSteps.get(j - 1);
                                resultMap.put("preStepName", preStep.getName());
                            } else {
                                resultMap.put("preStepName", "作业员核实");
                            }

                            TbtskRejectDef rejectDef = mTbtskRejectDefService.selectByTaskId(taskId);
                            if (rejectDef != null) {
                                resultMap.put("canReject", rejectDef.getRejectType() != 0);
                                resultMap.put("rejectType", rejectDef.getRejectType());
                            } else {
                                resultMap.put("canReject", false);
                            }
                            return resultMap;
                        }
                    }
                }
            }
        }
        return null;
    }

    public String processRegionCode(String dataRegionCode, String name) {
        String result = "";
        if (StringUtils.isNotBlank(dataRegionCode)) {
            result = dataRegionCode;
            switch (name) {
                case "村级审核":
                case "村级复核":
                    result = dataRegionCode;
                    break;
                case "乡镇审核":
                case "乡镇复核":
                    result = dataRegionCode.substring(0, 9);
                    break;
                case "区县审核":
                case "区县复核":
                    result = dataRegionCode.substring(0, 6);
                    break;
                case "市级审核":
                case "市级复核":
                    result = dataRegionCode.substring(0, 4) + "00";
                    break;
                case "省级审核":
                case "省级复核":
                    result = dataRegionCode.substring(0, 2) + "0000";
                    break;
                case "国家审核":
                case "国家复核":
                    result = "1";
                    break;
                default:
                    break;
            }
        }
        return result;
    }

    /**
     * 提交审核记录
     */
    public TbtskApproveRecord submitApproveRecord(TbtskApproveRecord approveRecord, String type, Long userId) throws Exception {
        TbtskApproveRecord result = null;
        if (approveRecord == null) {
            return null;
        }

        if (StringUtils.isBlank(approveRecord.getTaskid())) {
            throw new RuntimeException("taskId不能为空");
        }

        //获取四川举报线索任务Id
        SysConfig sysConfig = sysConfigService.findOne(BizIdConstants.SCGTY_BIZ_ID);
        String ynbgdcBizId = systemConfigCacheService.querySysConfig(BizIdConstants.YN_BGDC_BIZ_ID, "");
        if (sysConfig.getValue().equalsIgnoreCase(approveRecord.getTaskid())) { //四川举报系统
            TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(approveRecord.getTaskid()).orElse(null);
            if (null == tskTaskBiz) {
                throw new RuntimeException("业务不存在或已被删除");
            }
            TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
            if (null == tbtskObjectinfo) {
                throw new RuntimeException("业务数据表不存在或已被删除");
            }
            List<String> fieldNameList = getAuditFieldNameCollection();

            Map data = mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList,
                    "f_id", "'" + approveRecord.getTbid() + "'");
            if (null == data) {
                throw new RuntimeException("图斑不存在");
            }
            Integer status = MapUtils.getInteger(data, "f_status", null);
            Integer reviewStage = MapUtils.getInteger(data, "f_review_stage", null);
            Integer rejectCount = MapUtils.getInteger(data, "f_reject_count", 0);
            approveRecord.setRejectCount(rejectCount != null ? rejectCount : 0);
            result = tbtskApproveRecordRepository.save(approveRecord);
            // 更新图斑/房屋状态
            List<TbtskApproveRecord> recordList = tbtskApproveRecordRepository.findApproveRecordOrderByTime(
                    approveRecord.getTaskid(), approveRecord.getTbid());
            if (!GutilCollection.isEmpty(recordList)) {

                Integer index = recordList.get(0).getStepindex();
                List<FlowStep> flowSteps = getAuditFlowSteps(approveRecord.getTaskid());

                if (!GutilCollection.isEmpty(flowSteps)) {
                    boolean hashReview = flowSteps.stream().filter(flowStep -> StringUtils.isNotBlank(flowStep.getName())
                            && flowStep.getName().contains("复核")).count() > 0;
                    for (int i = 0; i < flowSteps.size(); i++) {
                        FlowStep flowStep = flowSteps.get(i);
                        if (index.equals(flowStep.getIndex())) {
                            String stage = flowStep.getPost_stage();
                            if (hashReview) {
                                if (approveRecord.getStepindex() % 2 == 0) {
                                    // 审核
                                    if (approveRecord.getOption().equals(1)) {
                                        status = WAITING_REVIEW.getCode();
                                        // 更新阶段
                                        reviewStage = Integer.valueOf(stage);
                                    } else {
                                        status = VERIFY_NOT_PASS.getCode();
                                    }
                                } else {
                                    // 复核
                                    if (approveRecord.getOption().equals(1)) {
                                        if (StringUtils.isNotBlank(stage)) {
                                            // 流转到下一级
                                            status = WAITING_VERIFY.getCode();
                                            // 更新阶段
                                            reviewStage = Integer.valueOf(stage);
                                        }
                                    } else {
                                        status = REVIEW_NOT_PASS.getCode();
                                    }
                                }
                            } else {
                                // 审核
                                if (approveRecord.getNextstep() == flowSteps.size()) { //审核最后一步将审核状态变更为已审核
                                    status = VERIFY_NOT_PASS.getCode();
                                } else {
                                    status = WAITING_REVIEW.getCode();
                                }
                                // 更新阶段
                                reviewStage = Integer.valueOf(stage);
                            }

                            HashMap<String, Object> map = new HashMap<>();
                            map.put("f_status", status);
                            map.put("f_review_stage", reviewStage);
                            map.put("f_reject_status", 0);
                            map.put("f_updatetime", System.currentTimeMillis());
                            int row = mDataBizService.updateData(tbtskObjectinfo.getfTablename(), map, "f_id='" + approveRecord.getTbid() + "'");
                            break;
                        }
                    }
                }
            }

        } else {
            TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(approveRecord.getTaskid()).orElse(null);
            if (null == tskTaskBiz) {
                throw new RuntimeException("业务不存在或已被删除");
            }
            TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
            if (null == tbtskObjectinfo) {
                throw new RuntimeException("业务数据表不存在或已被删除");
            }
            List<String> fieldNameList = getAuditFieldNameCollection();

            Map data = mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList,
                    "f_id", "'" + approveRecord.getTbid() + "'");
            if (null == data) {
                throw new RuntimeException("图斑不存在");
            }

            Integer status = MapUtils.getInteger(data, "f_status", null);
            Integer reviewStage = MapUtils.getInteger(data, "f_review_stage", null);
            Integer rejectCount = MapUtils.getInteger(data, "f_reject_count", 0);

            approveRecord.setRejectCount(rejectCount != null ? rejectCount : 0);
            result = tbtskApproveRecordRepository.save(approveRecord);
            // 更新图斑/房屋状态
            List<TbtskApproveRecord> recordList = tbtskApproveRecordRepository.findApproveRecordOrderByTime(
                    approveRecord.getTaskid(), approveRecord.getTbid());
            if (!GutilCollection.isEmpty(recordList)) {

                Integer index = recordList.get(0).getStepindex();
                List<FlowStep> flowSteps = getAuditFlowSteps(approveRecord.getTaskid());

                if (!GutilCollection.isEmpty(flowSteps)) {
                    boolean hashReview = containsReviewStep(flowSteps);
                    for (int i = 0; i < flowSteps.size(); i++) {
                        FlowStep flowStep = flowSteps.get(i);
                        if (index.equals(flowStep.getIndex())) {
                            String stage = flowStep.getPost_stage();
                            String postStatus = flowStep.getPost_status();
                            if (hashReview) {
                                if (approveRecord.getStepindex() % 2 == 0) {
                                    // 审核
                                    if (approveRecord.getOption().equals(1)) {
                                        status = WAITING_REVIEW.getCode();
                                        // 更新阶段
                                        reviewStage = Integer.valueOf(stage);
                                    } else if (approveRecord.getOption().equals(3) && approveRecord.getTaskid().equalsIgnoreCase(ynbgdcBizId)) {
                                        status = WAITING_REVIEW.getCode();
                                        // 更新阶段
                                        reviewStage = Integer.valueOf(stage);
                                    } else {
                                        status = VERIFY_NOT_PASS.getCode();
                                    }
                                } else {
                                    // 复核
                                    if (approveRecord.getOption().equals(1)) {
                                        if (StringUtils.isNotBlank(stage)) {
                                            status = WAITING_VERIFY.getCode();
                                            // 更新阶段
                                            reviewStage = Integer.valueOf(stage);
                                        }
                                    } else if (approveRecord.getOption().equals(3) && approveRecord.getTaskid().equalsIgnoreCase(ynbgdcBizId)) {
                                        if (StringUtils.isNotBlank(stage)) {
                                            status = WAITING_VERIFY.getCode();
                                            // 更新阶段
                                            reviewStage = Integer.valueOf(stage);
                                        }
                                    } else {
                                        status = REVIEW_NOT_PASS.getCode();
                                    }
                                }
                            } else {
                                // 审核
                                if (approveRecord.getOption().equals(1)) {
                                    status = WAITING_VERIFY.getCode();
                                    // 更新阶段
                                    reviewStage = Integer.valueOf(stage);
                                } else if (approveRecord.getOption().equals(3) && approveRecord.getTaskid().equalsIgnoreCase(ynbgdcBizId)) {
                                    status = WAITING_VERIFY.getCode();
                                    // 更新阶段
                                    reviewStage = Integer.valueOf(stage);
                                } else {
                                    status = VERIFY_NOT_PASS.getCode();
                                }
                            }

                            HashMap<String, Object> map = new HashMap<>();
                            map.put("f_status", status);
                            map.put("f_review_stage", reviewStage);
                            map.put("f_reject_status", 0);
                            map.put("f_updatetime", System.currentTimeMillis());
                            int row = mDataBizService.updateData(tbtskObjectinfo.getfTablename(), map, "f_id='" + approveRecord.getTbid() + "'");
                            break;
                        }
                    }
                }
            }
        }
        return result;
    }

    public String rejectBatchByFilter(Integer type, String taskId, Long userId, String remark, String description,
                                      String userName, String stepName, String xzqdm, String fwbh, Integer jslx, String xfzt, String tjzt,
                                      Date startTime, Date endTime, String tbzt, String xmhj, String shfh, String sfdh, String ywzp) throws Exception {
        String result = "打回成功";

        //将参数添加到任务记录中进行后台处理
        JSONObject params = new JSONObject();
        params.put("filterType", "conditionFilter");
        params.put("xzqdm", xzqdm);
        params.put("fwbh", fwbh);
        params.put("jslx", jslx);
        params.put("xfzt", xfzt);
        params.put("tjzt", tjzt);
        params.put("tbzt", tbzt);
        params.put("xmhj", xmhj);
        params.put("shfh", shfh);
        params.put("sfdh", sfdh);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("userId", userId);
        params.put("ywzp", ywzp);
        params.put("taskId", taskId);
        params.put("type", type);
        params.put("description", description);
        params.put("remark", remark);
        params.put("userName", userName);
        params.put("stepName", stepName);
        params.put("result", result);
        addTaskRecord(params, userId, JobConstants.JOB_TYPE_CONFIG_TASK_REJECT_BATCH, taskId);
        return result;
    }

    /**
     * 批量审核/复核
     *
     * @param taskId      任务id
     * @param tbId        图斑列表，多个图斑id之间用英文逗号隔开
     * @param option      审核意见 1：通过；2不通过
     * @param description 审核描述
     * @param remark      备注
     * @param userId      审核用户id
     * @param approveUser 审核用户名
     * @param type        类型 0：审核；1：复核
     * @return
     */
    public String submitApproveRecordBatch(String taskId, String tbId, Integer option, String description, String remark, Long userId, String approveUser, Integer type) {

        String result = "批量审核/复核成功";
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        if (tskTaskBiz.getIsApprove() == null || tskTaskBiz.getIsApprove() == 0) {
            return "该任务没有审核复核流程";
        }
        //将参数添加到任务记录中进行后台处理
        JSONObject params = new JSONObject();
        params.put("filterType", "checkFilter");
        params.put("tbIds", tbId);
        params.put("taskId", taskId);
        params.put("option", option);
        params.put("description", description);
        params.put("remark", remark);
        params.put("approveUser", approveUser);
        params.put("type", type);
        params.put("userId", userId);
        addTaskRecord(params, userId, JobConstants.JOB_TYPE_CONFIG_TASK_AUDIT_BATCH, taskId);
        return result;
    }

    /**
     * @param taskId      业务id
     * @param option      1：通过；2：不通过
     * @param description 描述
     * @param remark      备注
     * @param userId      审核人id
     * @param approveUser 审核人员名称
     * @param type        0：审核；1:复核
     * @param xzqdm       政区代码
     * @param fwbh        房屋编号
     * @param jslx        建设类型
     * @param xfzt        下发状态
     * @param tjzt        提交状态
     * @param startTime   起始提交时间
     * @param endTime     结束提交时间
     * @param tbzt        提报状态
     * @param xmhj        项目环节
     * @param shfh        审核复核
     * @param sfdh        是否打回
     * @param ywzp        有无照片
     * @return
     * @throws Exception
     */
    public String submitApproveRecordBatchByFilter(String taskId, Integer option, String description, String remark, Long userId,
                                                   String approveUser, Integer type, String xzqdm, String fwbh, Integer jslx,
                                                   String xfzt, String tjzt, Date startTime, Date endTime, String tbzt, String xmhj,
                                                   String shfh, String sfdh, String ywzp) throws Exception {
        String result = "批量审核/复核成功";

        //将参数添加到任务记录中进行后台处理
        JSONObject params = new JSONObject();
        params.put("filterType", "conditionFilter");
        params.put("xzqdm", xzqdm);
        params.put("fwbh", fwbh);
        params.put("jslx", jslx);
        params.put("xfzt", xfzt);
        params.put("tjzt", tjzt);
        params.put("tbzt", tbzt);
        params.put("xmhj", xmhj);
        params.put("shfh", shfh);
        params.put("sfdh", sfdh);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("userId", userId);
        params.put("ywzp", ywzp);
        params.put("taskId", taskId);
        params.put("option", option);
        params.put("description", description);
        params.put("remark", remark);
        params.put("approveUser", approveUser);
        params.put("type", type);
        addTaskRecord(params, userId, JobConstants.JOB_TYPE_CONFIG_TASK_AUDIT_BATCH, taskId);

        return result;
    }

    public Map canRevoke(String taskId, String tbId, Long userId) {
        Map resultMap = new HashMap();
        resultMap.put("hasPermission", false);
        resultMap.put("currentStage", "");
        resultMap.put("currentStatus", "");
        resultMap.put("stepIndex", "");
        resultMap.put("stepName", "");
        List<String> fieldNameList = getAuditFieldNameCollection();
        Map data = null;
        try {
            if (StringUtils.isBlank(taskId)) {
                throw new RuntimeException("taskId");
            }
            TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
            if (null == tskTaskBiz) {
                throw new GwValidateException();
            }
            if (tskTaskBiz.getCanRevoke() != null && tskTaskBiz.getCanRevoke().equals(0)) {
                resultMap.put("hasPermission", false);
                resultMap.put("error", "该任务不支持撤回操作");
                return resultMap;
            }
            data = queryData(taskId, tbId, fieldNameList);
        } catch (Exception e) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", e.getMessage());
            return resultMap;
        }
        if (null == data) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "图斑不存在");
            return resultMap;
        }

        Integer status = MapUtils.getInteger(data, "f_status", null);
        String xzqdm = MapUtils.getString(data, "f_xzqdmsys", "");
        Integer rejectCount = MapUtils.getInteger(data, "f_reject_count", 0);
        Integer rejectStatus = MapUtils.getInteger(data, "f_reject_status", null);
        Integer reviewStage = MapUtils.getInteger(data, "f_review_stage", null);

        if (status == null || status < WAITING_VERIFY.getCode()) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "图斑未被审核或复核，不允许撤回");
            return resultMap;
        }
        if (rejectStatus != null && rejectStatus.equals(NumberConst.ONE)) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "被打回的图斑不允许撤回");
            return resultMap;
        }
        List<FlowStep> flowSteps = getAuditFlowSteps(taskId);
        if (flowSteps == null || flowSteps.size() == 0) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "任务未查询到流程步骤，不允许撤回");
            return resultMap;
        }
        TbtskApproveRecord latestRecord = tbtskApproveRecordRepository.queryLatestApproveRecord(taskId, tbId, rejectCount);
        if (latestRecord == null) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "图斑没有审核或复核记录，不允许撤回");
            return resultMap;
        }
        if (latestRecord.getIsRevoked() != null && latestRecord.getIsRevoked().equals(NumberConst.ONE)) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "审核或复核记录已被撤回，不允许重复撤回");
            return resultMap;
        }
        if (latestRecord.getOption().equals(NumberConst.TWO)) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "保存疑义的审核记录，不允许撤回");
            return resultMap;
        }
        ReviewStageEnum firstStage = getFirstStageOfFlow(taskId);

        if (status.equals(WAITING_VERIFY.getCode())
                || status.equals(WAITING_REVIEW.getCode())
                || (status.equals(WAITING_VERIFY.getCode()) && reviewStage != null && !reviewStage.equals(firstStage.getCode()))) {
            // 判断状态是否为10或25，且状态10时不是在审核和复核的第一个阶段（作业员提报后不支持撤回）
        } else {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "图斑当前状态，不允许撤回");
            return resultMap;
        }

        // 判断当前用户是否有权限撤回
        Integer step = latestRecord.getStepindex();
        for (int i = 0; i < flowSteps.size(); i++) {
            FlowStep flowStep = flowSteps.get(i);
            if (step.equals(flowStep.getIndex())) {
                resultMap.put("stepIndex", flowStep.getIndex());
                resultMap.put("stepName", flowStep.getName());
                String filter = flowStep.getFilter();
                String dataRegionCode = processRegionCode(xzqdm, flowStep.getName());
                String userSql = FlowFilterUtil.filterUserSql(filter, "", dataRegionCode, taskId);
                List<Map<String, Object>> userList = jdbcTemplate.query(userSql, new RowMapper<Map<String, Object>>() {
                    @Override
                    public Map<String, Object> mapRow(ResultSet resultSet, int i) throws SQLException {
                        Map<String, Object> temp = new HashMap<>();
                        temp.put("userid", resultSet.getObject("f_userid"));
                        temp.put("username", resultSet.getObject("f_username"));
                        return temp;
                    }
                });
                if (userList != null && userList.size() > 0) {
                    for (int k = 0; k < userList.size(); k++) {
                        Long temUserId = Long.parseLong(userList.get(k).get("userid").toString());
                        if (temUserId.equals(userId)) {
                            resultMap.put("hasPermission", true);
                            return resultMap;
                        }
                    }
                }
            }
        }

        resultMap.put("hasPermission", false);
        resultMap.put("error", "无撤回权限，无法撤回");
        return resultMap;
    }

    private Map queryData(String taskId, String tbId, List<String> fieldNameList) throws Exception {
        if (StringUtils.isBlank(taskId)) {
            throw new RuntimeException("taskId");
        }
        if (StringUtils.isBlank(tbId)) {
            throw new RuntimeException("tbId");
        }
        if (GutilCollection.isEmpty(fieldNameList)) {
            throw new RuntimeException("fieldNameList");
        }
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        if (null == tskTaskBiz) {
            throw new RuntimeException();
        }
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            throw new RuntimeException();
        }
        Map data = mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", "'" + tbId + "'");
        return data;
    }

    /**
     * 打回
     *
     * @param taskId         任务id
     * @param tbId           图斑id
     * @param userId         用户id
     * @param remark         打回备注
     * @param description    打回描述
     * @param userName       打回人员名称
     * @param stepName       当前所处的节点名称
     * @param result
     * @param targetStepName
     * @return 打回结果，成功或失败
     * @throws Exception
     */
    public String reject(String taskId, String tbId, Long userId, String remark, String description,
                         String userName, String stepName, String result, String targetStepName) throws Exception {
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        if (null == tskTaskBiz) {
            throw new RuntimeException("业务不存在或已被删除");
        }
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            throw new RuntimeException("业务数据表不存在或已被删除");
        }
        List<String> fieldNameList = getAuditFieldNameCollection();
        fieldNameList.add("f_submit_userid");

        Map data = mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList,
                "f_id", "'" + tbId + "'");
        if (data != null) {
            Integer status = MapUtils.getInteger(data, "f_status", null);
            Integer reviewStage = MapUtils.getInteger(data, "f_review_stage", null);
            Integer rejectCount = MapUtils.getInteger(data, "f_reject_count", 0);
            String submitUserId = MapUtils.getString(data, "f_submit_userid", "");
            String xzqdmsys = MapUtils.getString(data, "f_xzqdmsys", "");
            if (status != null) {
                if (status < WAITING_VERIFY.getCode()) {
                    result = "打回失败，图斑尚未提交，不能打回";
                } else {
                    int newRejectCount = rejectCount != null ? rejectCount : 0;
                    TbtskRejectDef rejectDef = mTbtskRejectDefService.selectByTaskId(taskId);
                    if (rejectDef != null && rejectDef.getRejectType() != null) {
                        if (rejectDef.getRejectType().equals(RejectTypeEnum.DO_NOTHING.getCode())) {
                            result = "打回失败，此任务不支持打回";
                        } else {
                            Pair<ReviewStageEnum, TbStatusEnum> targetStageAndStatus = null;
                            SysConfig sysConfig = sysConfigService.findOne(BizIdConstants.SCGTY_BIZ_ID);
                            if (sysConfig.getValue().equalsIgnoreCase(taskId)) {
                                targetStageAndStatus = Pair.of(ReviewStageEnum.COUNTY_VERIFY, WAITING_VERIFY);
                            } else {
                                targetStageAndStatus = getRejectTargetStageAndStatus(taskId, rejectDef.getRejectType(), stepName, targetStepName);
                            }

                            HashMap<String, Object> updateMap = new HashMap<>();
                            updateMap.put("f_reject_status", NumberConst.ONE);
                            updateMap.put("f_reject_count", newRejectCount + NumberConst.ONE);
                            updateMap.put("f_review_stage", targetStageAndStatus.getLeft().getCode());
                            updateMap.put("f_status", targetStageAndStatus.getRight().getCode());
                            updateMap.put("f_updatetime", System.currentTimeMillis());
                            int row = mDataBizService.updateData(tbtskObjectinfo.getfTablename(), updateMap, "f_id='" + tbId + "'");
                            if (row == 1) {
                                //保存打回记录
                                TbtskRejectRecord rejectRecord = saveRejectRecord(taskId, userId, remark, description, userName, stepName, tbId, reviewStage, targetStageAndStatus.getLeft().getCode());
                                if (submitUserId != null && targetStageAndStatus.getLeft().getCode() == ReviewStageEnum.OPERATOR_VERIFY.getCode()) {
                                    String receiverUserId = submitUserId;
                                    // 给app发消息
                                    // sendMessageToApp(userId, receiverUserId, tbId, rejectRecord);
                                    JSONArray id2RejectIdArray = new JSONArray();
                                    id2RejectIdArray.add(rejectRecord.getTbid() + ":" + rejectRecord.getId());
                                    sendRejectMessageToAPPByPlatform(Arrays.asList(tbId.split(",")), userId, Arrays.asList(receiverUserId.split(",")),
                                            description, remark, id2RejectIdArray, tbtskObjectinfo, taskId,
                                            tskTaskBiz, xzqdmsys);
                                }
                                result = "打回成功";
                            } else {
                                result = "打回失败";
                            }
                        }
                    } else {
                        result = "打回失败，此任务不未配置打回类型，请联系管理员";
                    }

                }
            }
        }
        return result;
    }

    private TbtskRejectRecord saveRejectRecord(String taskId, Long userId, String remark, String description,
                                               String userName, String stepName, String id, Integer sourceStage, Integer targetStage) {
        TbtskRejectRecord rejectRecord = new TbtskRejectRecord();
        rejectRecord.setTaskid(taskId);
        rejectRecord.setTbid(id);
        rejectRecord.setUserId(userId);
        rejectRecord.setRejectTime(new Date());
        rejectRecord.setRemark(remark);
        rejectRecord.setDescription(description);
        rejectRecord.setUserName(userName);
        rejectRecord.setSourceStage(sourceStage);
        rejectRecord.setTargetStage(targetStage);
        rejectRecord.setStepName(stepName);
        return tbtskRejectRecordRepository.save(rejectRecord);
    }

    /**
     * 平台任务打回发送消息给app
     *
     * @param ids
     * @param userId
     * @param submitUserIds
     * @param description
     * @param remark
     * @param id2RejectIdArray
     * @param tableInfo
     * @param taskId
     */
    public void sendRejectMessageToAPPByPlatform(List<String> ids, Long userId, List<String> submitUserIds, String
            description, String remark, JSONArray id2RejectIdArray, TbtskObjectinfo tableInfo, String
                                                         taskId, TskTaskBiz tskTaskBiz, String xzqdmsys) {
        String content = String.format("【任务图斑打回通知】。任务名称：" + tableInfo.getfTablealias() + "；打回了%s个图斑", ids.size());
        if (StringUtils.isNotBlank(description)) {
            content += "  原因：" + description + "";
        }
        if (StringUtils.isNotBlank(remark)) {
            content += "  备注：" + remark;
        }
        // 任务通知
        TaskNotice taskNotice = new TaskNotice();
        taskNotice.setData(StringUtils.join(ids.toArray(), ','));
        taskNotice.setContent(content);
        taskNotice.setId(UUID.randomUUID().toString());
        taskNotice.setState(1);
        taskNotice.setSendUser(null);
        taskNotice.setTitle("任务图斑打回通知");
        taskNotice.setSendTime(new Date());
        taskNotice.setType(2); // 任务函
        taskNotice.setAction(11); // app自动接收消息
        taskNotice.setRegion("");
        taskNotice.setRegion1("");
        taskNotice.setMsgtype("0");
        taskNotice.setBizId(taskId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", ids.size());
        if (id2RejectIdArray != null) {
            jsonObject.put("rejectIds", id2RejectIdArray);
        }
        taskNotice.setAddition(jsonObject.toString());
        //保存任务通知
        taskNotice = mTaskNoticeService.save(taskNotice);
        List<String> alias = new ArrayList<String>();
        // 下发通知到个人
        for (int i = 0; i < submitUserIds.size(); i++) {
            String userid = submitUserIds.get(i);
           /* TaskNoticeUser taskNoticeUser = new TaskNoticeUser();
            taskNoticeUser.setId(UUID.randomUUID().toString());
            taskNoticeUser.setData(StringUtils.join(ids.toArray(), ','));
            taskNoticeUser.setState(0);
            taskNoticeUser.setCreatetime(new Date());
            taskNoticeUser.setNoticeId(taskNotice.getId());
            taskNoticeUser.setUserId(userid);
            taskNoticeService.save(taskNoticeUser);*/
            TaskNoticeUserNew taskNoticeUserNew = new TaskNoticeUserNew();
            taskNoticeUserNew.setId(UUID.randomUUID().toString());
            taskNoticeUserNew.setSenduser(userId.toString());
            taskNoticeUserNew.setTitle("任务图斑打回通知");
            taskNoticeUserNew.setContent(content);
            taskNoticeUserNew.setAction(11);//打回使用10
            taskNoticeUserNew.setTaskmode(tskTaskBiz.getMode());
            taskNoticeUserNew.setBizid(taskId);
            taskNoticeUserNew.setCount(id2RejectIdArray.size());
            taskNoticeUserNew.setReceiveuser(userid);
            taskNoticeUserNew.setData(StringUtils.join(ids.toArray(), ','));
            taskNoticeUserNew.setXzqdmsys(converXzqdmsysByGr(tskTaskBiz, xzqdmsys));
            taskNoticeUserNew.setSenddate(new Date());
            mTaskNoticeNewService.addTaskNoticeUserNew(taskNoticeUserNew);
            alias.add(userid);
        }
        Map<String, Object> message = new HashMap<String, Object>();
        message.put("type", 3); // 2表明是任务消息
        message.put("bizid", taskId);
        try {
            // 推送消息
            MixPushServer.sendNotifyToAlias(alias, taskNotice.getTitle(), taskNotice.getContent(), JSON.toJSONString(message));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String converXzqdmsysByGr(TskTaskBiz task, String xzqdmsys) {
        String xzqdm = "";
        if (task.getGranularity() != null && task.getGranularity() == 3) {
            xzqdm = xzqdmsys.substring(0, 6);
        } else if (task.getGranularity() != null && task.getGranularity() == 4) {
            xzqdm = xzqdmsys.substring(0, 9);
        } else if (task.getGranularity() != null && task.getGranularity() == 5) {
            xzqdm = xzqdmsys.substring(0, 12);
        } else {
            xzqdm = xzqdmsys.substring(0, 6);
        }
        return xzqdm;
    }

    /**
     * 获取打回的目标阶段和目标状态
     *
     * @param taskId
     * @param rejectType      打回类型
     * @param currentStepName
     * @return 打回的阶段, 打回的图斑状态
     */
    private Pair<ReviewStageEnum, TbStatusEnum> getRejectTargetStageAndStatus(String taskId, Integer rejectType, String currentStepName, String targetStepName) {
        ReviewStageEnum targetStage = null;
        TbStatusEnum targetStatus = null;
        if (rejectType.equals(RejectTypeEnum.TO_OPERATOR.getCode())) {
            targetStage = ReviewStageEnum.OPERATOR_VERIFY;
            targetStatus = SUBMIT;
        } else if (rejectType.equals(RejectTypeEnum.TO_PREVIOUS_STAGE.getCode())) {
            String preStep = getRejectPreStep(taskId, currentStepName);
            if ("作业员提报阶段".equals(preStep)) {
                targetStage = ReviewStageEnum.OPERATOR_VERIFY;
                targetStatus = SUBMIT;
            } else {
                JSONObject preStepJsonObj = JSONObject.parseObject(preStep);
                if (preStepJsonObj != null) {
                    String preTwoStep = getRejectPreStep(taskId, preStepJsonObj.get("name").toString());
                    if ("作业员提报阶段".equals(preTwoStep)) {
                        ReviewStageEnum reviewStageEnum = getFirstStageOfFlow(taskId);
                        targetStage = reviewStageEnum;
                        targetStatus = WAITING_VERIFY;
                    } else {
                        JSONObject preTwoStepJsonObj = JSONObject.parseObject(preTwoStep);
                        if (preTwoStepJsonObj.containsKey("post_stage") && StringUtils.isNotBlank(preTwoStepJsonObj.get("post_stage").toString())) {
                            targetStage = ReviewStageEnum.getEnum(Integer.parseInt(preTwoStepJsonObj.get("post_stage").toString()));
                        }
                        if (preTwoStepJsonObj.containsKey("post_status") && StringUtils.isNotBlank(preTwoStepJsonObj.get("post_status").toString())) {
                            targetStatus = TbStatusEnum.getEnum(Integer.parseInt(preTwoStepJsonObj.get("post_status").toString()));
                        }
                    }

                }
            }
        } else if (rejectType.equals(RejectTypeEnum.TO_CUSTOM_STAGE.getCode())) {
            if (StringUtils.isNotBlank(targetStepName)) {
                switch (targetStepName) {
                    case "村级审核":
                        targetStage = ReviewStageEnum.VILLAGE_VERIFY;
                        targetStatus = WAITING_VERIFY;
                        break;
                    case "村级复核":
                        targetStage = ReviewStageEnum.VILLAGE_VERIFY;
                        targetStatus = WAITING_REVIEW;
                        break;
                    case "乡镇审核":
                        targetStage = ReviewStageEnum.TOWN_VERIFY;
                        targetStatus = WAITING_VERIFY;
                        break;
                    case "乡镇复核":
                        targetStage = ReviewStageEnum.TOWN_VERIFY;
                        targetStatus = WAITING_REVIEW;
                        break;
                    case "区县审核":
                        targetStage = ReviewStageEnum.COUNTY_VERIFY;
                        targetStatus = WAITING_VERIFY;
                        break;
                    case "区县复核":
                        targetStage = ReviewStageEnum.COUNTY_VERIFY;
                        targetStatus = WAITING_REVIEW;
                        break;
                    case "市级审核":
                        targetStage = ReviewStageEnum.CITY_VERIFY;
                        targetStatus = WAITING_VERIFY;
                        break;
                    case "市级复核":
                        targetStage = ReviewStageEnum.CITY_VERIFY;
                        targetStatus = WAITING_REVIEW;
                        break;
                    case "省级审核":
                        targetStage = ReviewStageEnum.PROVINCE_VERIFY;
                        targetStatus = WAITING_VERIFY;
                        break;
                    case "省级复核":
                        targetStage = ReviewStageEnum.PROVINCE_VERIFY;
                        targetStatus = WAITING_REVIEW;
                        break;
                    case "国家审核":
                        targetStage = ReviewStageEnum.COUNTRY_VERIFY;
                        targetStatus = WAITING_VERIFY;
                        break;
                    case "国家复核":
                        targetStage = ReviewStageEnum.COUNTRY_VERIFY;
                        targetStatus = WAITING_REVIEW;
                        break;
                    case "作业员":
                        targetStage = ReviewStageEnum.OPERATOR_VERIFY;
                        targetStatus = SUBMIT;
                        break;
                    default:
                        targetStage = ReviewStageEnum.OPERATOR_VERIFY;
                        targetStatus = SUBMIT;
                }
            }
        }
        return Pair.of(targetStage, targetStatus);
    }

    private String getRejectPreStep(String taskId, String stepName) {
        String result = "作业员提报阶段";
        List<TbtskFlowDef> flowDefs = tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, FlowTypeEnum.AUDIT.getCode());
        if (!GutilCollection.isEmpty(flowDefs)) {
            TbtskFlowDef flowDef = flowDefs.get(0);
            if (flowDef.getSteps() != null) {
                JSONArray stepsJsonArray = JSONArray.parseArray(flowDef.getSteps());
                if (stepsJsonArray != null) {
                    JSONObject jsonObj = null;
                    for (int i = 0; i < stepsJsonArray.size(); i++) {
                        jsonObj = JSONObject.parseObject(stepsJsonArray.get(i).toString());
                        if (jsonObj != null) {
                            if (jsonObj.containsKey("name") && StringUtils.isNotBlank(jsonObj.get("name").toString())
                                    && jsonObj.get("name").toString().equals(stepName)) {
                                if (i == 0) {
                                    result = "作业员提报阶段";
                                } else {
                                    result = stepsJsonArray.get(i - 1).toString();
                                }
                                break;
                            }
                        }
                        jsonObj = null;
                    }
                }
            }
        }
        return result;
    }

    /**
     * 撤回
     *
     * @param taskId
     * @param tbId
     * @param auditType
     * @param remark
     * @param stepName
     * @param userId
     * @return
     */
    @Transactional
    public Pair<Boolean, String> revoke(String taskId, String tbId, Integer auditType, String remark, String stepName, Long userId) {

        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        if (null == tskTaskBiz) {
            return Pair.of(false, "业务不存在或已被删除");
        }
        TbtskObjectinfo objectInfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == objectInfo) {
            return Pair.of(false, "业务数据表不存在或已被删除");
        }
        List<String> fieldNameList = getAuditFieldNameCollection();
        Map data = mDataBizService.selectFieldByID(objectInfo.getfTablename(), fieldNameList, "f_id", "'" + tbId + "'");
        if (null == data) {
            return Pair.of(false, "图斑不存在");
        }

        List<FlowStep> flowSteps = getAuditFlowSteps(taskId);
        if (GutilCollection.isEmpty(flowSteps)) {
            return Pair.of(false, "审核流程节点不存在");
        }

        Integer status = MapUtils.getInteger(data, "f_status", null);
        Integer reviewStage = MapUtils.getInteger(data, "f_review_stage", null);
        Integer rejectCount = MapUtils.getInteger(data, "f_reject_count", 0);

        boolean hasReview = containsReviewStep(flowSteps);

        TbtskApproveRecord record = tbtskApproveRecordRepository.queryLatestApproveRecord(taskId, tbId, rejectCount);
        if (record != null
                && record.getApproveUserId().equals(userId)
                && (record.getIsRevoked() == null || record.getIsRevoked().equals(NumberConst.ZERO))) {
            // 更新审核记录
            String revokeRecordId = UUID.randomUUID().toString();
            record.setRevokeRecordId(revokeRecordId);
            // 已通过的审核记录撤回时，需要将对应的审核记录改为撤回状态(把f_is_revoked赋值成1)
            record.setIsRevoked(NumberConst.ONE);
            tbtskApproveRecordRepository.save(record);

            // 保存撤回记录
            TbtskRevokeRecord tbtskRevokeRecord = TbtskRevokeRecord
                    .builder()
                    .id(revokeRecordId)
                    .taskId(taskId)
                    .tbId(tbId)
                    .revokeTime(new Date())
                    .approveRecordId(record.getId())
                    .remark(remark)
                    .stepName(stepName)
                    .userId(userId)
                    .userName(userNameService.getUserNameByUserId(userId.toString()))
                    .build();
            tbtskRevokeRecordService.insert(tbtskRevokeRecord);

            // 更新图斑的状态和阶段信息
            updateTbStatusAndReviewStage(taskId, tbId, objectInfo, flowSteps, status, reviewStage, hasReview, record);
            return Pair.of(true, "撤回成功");
        }
        return Pair.of(false, "撤回失败");
    }

    private void updateTbStatusAndReviewStage(String taskId, String tbId, TbtskObjectinfo objectInfo, List<FlowStep> flowSteps, Integer status, Integer reviewStage, boolean hasReview, TbtskApproveRecord record) {
        for (int i = 0; i < flowSteps.size(); i++) {
            if (record.getStepindex().equals(flowSteps.get(i).getIndex())) {
                Integer newStatus = null;
                Integer newReviewStage = null;

                if (status.equals(WAITING_VERIFY.getCode())) {
                    //回退到上一阶段，如果存在复核阶段，状态值为25，反之为10
                    if (i < 1) {
                        newReviewStage = getFirstStageOfFlow(taskId).getCode();
                    } else {
                        FlowStep preStep = flowSteps.get(i - 1);
                        newReviewStage = Integer.valueOf(preStep.getPost_stage());
                    }
                    if (hasReview) {
                        newStatus = WAITING_REVIEW.getCode();
                    } else {
                        newStatus = WAITING_VERIFY.getCode();
                    }
                } else if (status.equals(WAITING_REVIEW.getCode())) {
                    // 由审核提交而来,继续为本阶段，状态值为10
                    newReviewStage = reviewStage;
                    newStatus = WAITING_VERIFY.getCode();
                }

                HashMap<String, Object> updateMap = new HashMap<>();
                if (newStatus != null && !newStatus.equals(status)) {
                    updateMap.put("f_status", newStatus);
                }
                if (newReviewStage != null && !newReviewStage.equals(reviewStage)) {
                    updateMap.put("f_review_stage", newReviewStage);
                }
                if (MapUtil.isNotEmpty(updateMap)) {
                    int row = mDataBizService.updateDataById(objectInfo.getfTablename(), tbId, updateMap);
                }
                break;
            }
        }
    }


    /**
     * 判断是否包含复核节点
     *
     * @param flowSteps
     * @return
     */
    private boolean containsReviewStep(List<FlowStep> flowSteps) {
        boolean result = false;
        if (!GutilCollection.isEmpty(flowSteps)) {
            result = flowSteps.stream().filter(step -> StringUtils.isNotBlank(step.getName())
                    && step.getName().contains("复核")).count() > 0;
        }
        return result;
    }

    /**
     * 查询业务流程的审核步骤信息
     */
    public List<FlowStep> getAuditFlowSteps(String taskId) {
        return findFlowSteps(taskId, FlowTypeEnum.AUDIT);
    }

    /**
     * 查询业务流程对应步骤信息
     */
    public List<FlowStep> findFlowSteps(String taskId, FlowTypeEnum flowType) {
        if (StringUtils.isBlank(taskId)) {
            return null;
        }
        List<TbtskFlowDef> flows = tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, flowType.getCode());
        if (flows == null || flows.size() == 0) {
            return null;
        }
        List<FlowStep> steps = new Gson().fromJson(flows.get(0).getSteps(), new TypeToken<List<FlowStep>>() {
        }.getType());
        return steps;
    }

    public String rejectFinish(String taskId, String tbId, String remark, String stepName, Long userId, String
            userName, String description) throws Exception {
        String result = "";
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        if (null == tskTaskBiz) {
            throw new GwValidateException("业务不存在或已被删除");
        }
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            throw new GwValidateException("业务数据表不存在或已被删除");
        }
        List<String> fieldNameList = getAuditFieldNameCollection();
        fieldNameList.add("f_submit_userid");
        if (fieldNameList.contains("f_isfinish")) {
            fieldNameList.add("f_isfinish");
        }

        Map data = mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList,
                "f_id", "'" + tbId + "'");
        if (data != null) {
            Integer status = MapUtils.getInteger(data, "f_status", null);
            Integer reviewStage = MapUtils.getInteger(data, "f_review_stage", null);
            Integer rejectCount = MapUtils.getInteger(data, "f_reject_count", 0);
            String submitUserId = MapUtils.getString(data, "f_submit_userid", "");
            String xzqdmsys = MapUtils.getString(data, "f_xzqdmsys", "");

            if (status != null) {
                if (status < WAITING_VERIFY.getCode()) {
                    result = "驳回失败，图斑尚未提交，不能驳回";
                } else {
                    int newRejectCount = rejectCount != null ? rejectCount : 0;
                    TbtskRejectDef rejectDef = mTbtskRejectDefService.selectByTaskId(taskId);
                    if (rejectDef != null && rejectDef.getRejectType() != null) {
                        if (rejectDef.getRejectType().equals(RejectTypeEnum.DO_NOTHING.getCode())) {
                            result = "驳回失败，此任务不支持驳回";
                        } else {

                            HashMap<String, Object> updateMap = new HashMap<>();
                            updateMap.put("f_reject_status", 1);
                            updateMap.put("f_reject_count", newRejectCount + 1);
                            updateMap.put("f_review_stage", ReviewStageEnum.OPERATOR_VERIFY.getCode());
                            updateMap.put("f_status", WAITING_VERIFY.getCode());
                            updateMap.put("f_isfinish", NumberConst.ONE);
                            updateMap.put("f_updatetime", System.currentTimeMillis());
                            int row = mDataBizService.updateData(tbtskObjectinfo.getfTablename(), updateMap, "f_id='" + tbId + "'");
                            if (row == 1) {
                                //保存打回记录
                                TbtskRejectRecord rejectRecord = saveRejectRecord(taskId, userId, remark,
                                        "县级驳回，办结。" + description,
                                        userName, stepName, tbId, reviewStage, ReviewStageEnum.OPERATOR_VERIFY.getCode());
                                if (submitUserId != null) {
                                    String receiverUserId = submitUserId;
                                    JSONArray id2RejectIdArray = new JSONArray();
                                    id2RejectIdArray.add(rejectRecord.getTbid() + ":" + rejectRecord.getId());
                                    sendRejectMessageToAPPByPlatform(Arrays.asList(tbId.split(",")), userId, Arrays.asList(receiverUserId.split(",")),
                                            "县级驳回，办结。" + description, remark, id2RejectIdArray, tbtskObjectinfo, taskId,
                                            tskTaskBiz, xzqdmsys);
                                }
                                result = "退回成功";
                            } else {
                                result = "驳回失败";
                            }
                        }
                    } else {
                        result = "驳回失败，此任务不未配置打回类型，请联系管理员";
                    }

                }
            }
        }
        return result;
    }

    /**
     * 四川耕地业务 查询是否否回退至公众的权限
     *
     * @param taskId
     * @param tbId
     * @param userId
     * @return
     */
    public Map checkRejectFinishPermission(String taskId, String tbId, Long userId) {
        Map resultMap = new HashMap();
        resultMap.put("hasPermission", false);
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        if (null == tskTaskBiz) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "业务不存在或已被删除");
            return resultMap;
        }
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "业务数据表不存在或已被删除");
            return resultMap;
        }
        List<String> fieldNameList = getAuditFieldNameCollection();
        if (fieldNameList.contains("f_isfinish")) {
            fieldNameList.add("f_isfinish");
        }

        Map data = mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", "'" + tbId + "'");
        if (null == data) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "图斑不存在");
            return resultMap;
        }
        Integer status = MapUtils.getInteger(data, "f_status", null);
        String xzqdm = MapUtils.getString(data, "f_xzqdmsys", "");
        Integer reviewStage = MapUtils.getInteger(data, "f_review_stage", null);
        Integer rejectCount = MapUtils.getInteger(data, "f_reject_count", 0);
        Integer rejectStatus = MapUtils.getInteger(data, "f_reject_status", null);

        Integer finish = MapUtils.getInteger(data, "f_isfinish", NumberConst.ZERO);
        if (status == null || status < WAITING_VERIFY.getCode()) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "未提报，不能审核");
            return resultMap;
        }

        if (finish.equals(NumberConst.ONE)) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "已经回退，不能重复回退");
            return resultMap;
        }


        List<Integer> userRoleList = getUserRole(taskId, userId);
        if (GutilCollection.isEmpty(userRoleList)) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "非审核人员，不能回退");
            return resultMap;
        }
        if (userRoleList.stream().filter(role -> role.equals(UserRoleEnum.AUDITOR.getCode())).count() <= 0) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "非审核人员，不能回退");
            return resultMap;
        }

        List<TbtskUserAuditArea> auditAreas = tbtskUserAuditAreaService.listAuditAreas(taskId, String.valueOf(userId), (short) NumberConst.THREE);

        if (GutilCollection.isEmpty(auditAreas)) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "非区县审核人员，不能回退");
            return resultMap;
        }

        Map permissionMap = queryPermissionByFilter(taskId, tbId, userId, xzqdm, status, reviewStage, rejectCount, rejectStatus);
        if (permissionMap != null) {
            for (Object key : permissionMap.keySet()) {
                resultMap.put(key.toString(), permissionMap.get(key));
            }
        }
        return resultMap;
    }

    public Map<String, Short> getBizAreaAndLevel(String taskId, Long userId, Integer role) {
        Map<String, Short> map = new HashMap<>();
        if (role == UserRoleEnum.CREATOR.getCode()) {
            List<String> areaLists = landUserService.queryUserAreas(userId);
            if (!GutilCollection.isEmpty(areaLists)) {
                for (String area : areaLists) {
                    if (area.equals("1")) {
                        map.put(area, (short) 0);
                    } else if (area.endsWith("0000")) {
                        map.put(area, (short) 1);
                    } else if (area.endsWith("00")) {
                        map.put(area, (short) 2);
                    } else {
                        map.put(area, (short) 3);
                    }
                }
            }
        } else if (role == UserRoleEnum.MANAGER.getCode()) {
            List<TbtskUserManageArea> list = tbtskUserManageAreaService.listManageAreas(taskId, userId.toString());
            map = list.stream().collect(Collectors.toMap(TbtskUserManageArea::getRegioncode, TbtskUserManageArea::getLevel));
        } else if (role == UserRoleEnum.AUDITOR.getCode()) {
            List<TbtskUserAuditArea> list = tbtskUserAuditAreaService.listAuditAreas(taskId, userId.toString());
            map = list.stream().collect(Collectors.toMap(TbtskUserAuditArea::getRegionCode, TbtskUserAuditArea::getLevel));
        } else if (role == UserRoleEnum.SUPERAUDITOR.getCode()) {
            List<TbtskSuperUserAuditArea> list = tbtskSuperUserAuditAreaService.listAuditAreas(taskId, userId.toString());
            map = list.stream().collect(Collectors.toMap(TbtskSuperUserAuditArea::getRegionCode, TbtskSuperUserAuditArea::getLevel));
        }else if (role == UserRoleEnum.REVIEWER.getCode()) {
            List<TbtskUserReviewArea> list = mTbtskUserReviewAreaService.listReviewAreas(taskId, userId.toString());
            map = list.stream().collect(Collectors.toMap(TbtskUserReviewArea::getRegionCode, TbtskUserReviewArea::getLevel));
        } else if (role == UserRoleEnum.UPLOADER.getCode()) {
            List<TbtskUserUploadArea> list = tbtskUserUploadAreaService.listManageAreas(taskId, userId.toString());
            map = list.stream().collect(Collectors.toMap(TbtskUserUploadArea::getRegioncode, TbtskUserUploadArea::getLevel));
        } else if (role == UserRoleEnum.OPERATOR.getCode()) {
            List<String> areaLists = landUser2AreaRepository.queryAreas(userId);
            if (!GutilCollection.isEmpty(areaLists)) {
                for (String area : areaLists) {
                    if (area.equals("1")) {
                        map.put(area, (short) 0);
                    } else if (area.endsWith("0000")) {
                        map.put(area, (short) 1);
                    } else if (area.endsWith("00")) {
                        map.put(area, (short) 2);
                    } else {
                        map.put(area, (short) 3);
                    }
                }
            }
        } else {

        }
        return map;
    }

    public HashMap<Integer, Map<String, Short>> queryUserRoleAndRegionCodeOfTaskSC(String taskId, Long userId) {
        HashMap<Integer, Map<String, Short>> result = new HashMap<>();
        // 配置任务
        List<UserBiz2> userBiz2List = userBiz2Repository.findByUserId(userId);
        if (!GutilCollection.isEmpty(userBiz2List)) {
            for (UserBiz2 userBiz2 : userBiz2List) {
                if (StringUtils.isNotBlank(userBiz2.getBizId()) && userBiz2.getBizId().equalsIgnoreCase(taskId)) {
                    if (userBiz2.getRole() != null) {
                        Map<String, Short> map = getBizAreaAndLevel(taskId, userId, userBiz2.getRole());
                        if (MapUtil.isNotEmpty(map)) {
                            if (result.containsKey(userBiz2.getRole().intValue())) {
                                Map<String, Short> oldList = result.get(userBiz2.getRole().intValue());
                                if (MapUtil.isNotEmpty(oldList)) {
                                    oldList.putAll(map);
                                    result.put(userBiz2.getRole().intValue(), oldList);
                                } else {
                                    result.put(userBiz2.getRole().intValue(), map);
                                }
                            } else {
                                result.put(userBiz2.getRole().intValue(), map);
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    public TbStatusEnum queryTbStatus(String taskId, String tbId, Long userId) {
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        if (null == tskTaskBiz) {
            return TbStatusEnum.INIT;
        }
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            return TbStatusEnum.INIT;
        }
        List<String> fieldNameList = getAuditFieldNameCollection();

        Map data = mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", "'" + tbId + "'");
        if (null == data) {
            return TbStatusEnum.INIT;
        }
        Integer status = MapUtils.getInteger(data, "f_status", null);
        if (status != null) {
            return TbStatusEnum.getEnum(status);
        }
        return TbStatusEnum.INIT;
    }
}
