package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.gw.base.util.GutilAssert;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Service
@Transactional
public class MDataBizService {

    @Autowired
    DataBizMapper dataBizMapper;

    @Autowired
    MTbtskFieldsService mTbtskFieldsService;

    @Autowired
    MTbtskObjectinfoService mTbtskObjectinfoService;

    /**
     * 根据自定义sql语句查询数据
     *
     * @param sql sql语句
     * @return
     */
    public List<Map> queryDataBySql(String sql) {
        List<Map> maps = dataBizMapper.queryDataBySql(sql);
        return maps;
    }

    public void excuteSql(String sql) {
        dataBizMapper.excuteSql(sql);
    }

    /**
     * 根据表名称查询所有字段
     *
     * @param tableName 表名称
     * @return
     */
    public List<Map> queryAllData(String tableName, List<String> fieldNameList, String where) {
        List<Map> list = dataBizMapper.queryAllData(tableName, fieldNameList, where);
        return list;
    }

    /**
     * 查询数据
     *
     * @param tableid        表id
     * @param fieldGroupType
     * @param pageSize
     * @param page
     * @param where
     * @return
     */
    public List<Map> queryPageData(String tableid, String fieldGroupType, int pageSize, int page, String where) {
        List<String> fieldNameList = mTbtskFieldsService.getTbtskFieldsNameListBySysCodeAndGroupCode("web", tableid, fieldGroupType);
        if (!fieldNameList.contains("f_id")) {
            fieldNameList.add("f_id");
        }
        TbtskObjectinfo tbtskObjectinfo = mTbtskObjectinfoService.getObjectbyID(tableid);
        List<Map> maps = dataBizMapper.queryPageData(tbtskObjectinfo.getfTablename(), fieldNameList, pageSize, (page - 1) * pageSize, where);
        return maps;
    }

    public List<Map> queryPageData(String tableName, List<String> fieldNameList, int pageSize, int page, String where) {
        List<Map> maps = dataBizMapper.queryPageData(tableName, fieldNameList, pageSize, (page - 1) * pageSize, where);
        return maps;
    }

    public List<Map> queryPageData(String tableName, String tableid, String fieldGroupType, int pageSize, int page, String where) {
        List<String> fieldNameList = mTbtskFieldsService.getTbtskFieldsNameListBySysCodeAndGroupCode("web", tableid, fieldGroupType);
        List<String> fiedls = new ArrayList<>();
        for (String f : fieldNameList) {
            fiedls.add("d." + f);
        }
        fiedls.add("f_taskid");
        List<Map> maps = dataBizMapper.queryPageData(tableName, fiedls, pageSize, (page - 1) * pageSize, where);
        return maps;
    }

    /**
     * 根据ID查询数据对象
     *
     * @param tableName        表名称
     * @param primaryFieldName 表主键字段名称
     * @param id               主键值
     * @return
     */
    public Map selectByID(String tableName, String primaryFieldName, String id) {
        return dataBizMapper.selectByID(tableName, primaryFieldName, id);
    }

    /**
     * 根据ID查询数据对象
     *
     * @param tableName        表名称
     * @param fieldList        字段列表
     * @param primaryFieldName 表主键字段名称
     * @param id               主键值
     * @return
     */
    public Map selectFieldByID(String tableName, List<String> fieldList, String primaryFieldName, String id) {
        return dataBizMapper.selectFieldByID(tableName, fieldList, primaryFieldName, id);
    }

    public List<Map> selectFieldByIds(String tableName, List<String> fieldsNameList, String primaryKey, List<String> ids) {
        return dataBizMapper.selectFieldByIds(tableName, fieldsNameList, primaryKey, ids);
    }

    /**
     * 查询数据总数量
     *
     * @param tableName 表名称
     * @param where     条件
     * @return 数量
     */
    public int getCount(String tableName, String where) {
        int count = dataBizMapper.getCount(tableName, where);
        return count;
    }

    /**
     * 查询某任务下发给某人的记录数量 对多次下发进行去重
     *
     * @param tableName
     * @param where
     * @return
     */
    public int getAssignCountDistinctDataId(String tableName, String where) {
        int count = dataBizMapper.getAssignCountDistinctDataId(tableName, where);
        return count;
    }

    /**
     * 插入数据
     *
     * @param tableName 表名称
     * @param map       数据Map对象
     * @return
     */
    public int insertData(String tableName, Map<String, Object> map, String geofield) {

        int insert = 0;
        insert = dataBizMapper.insert(tableName, map, geofield);

        return insert;
    }

    /**
     * 插入数据
     *
     * @param tableName 表名称
     * @param map       数据Map对象
     *                  对TimeStamp类型数据不进行''判断
     * @return
     */
    public int insertDataByTimeStamp(String tableName, Map<String, Object> map, String geofield) {

        int insert = 0;
        insert = dataBizMapper.insertDataByTimeStamp(tableName, map, geofield);

        return insert;
    }

    /**
     * 批量插入数据
     *
     * @param tableName
     * @param datalist
     * @param geoField
     * @return
     */
    public int insertDatasBatch(String tableName, List<Map<String, Object>> datalist, String geoField) {
        return dataBizMapper.insertBatch(tableName, datalist, geoField);
    }

    public int insertDatasBatchByTimeStamp(String tableName, List<Map<String, Object>> datalist, String geoField) {
        return dataBizMapper.insertBatchByTimeStamp(tableName, datalist, geoField);
    }

    /**
     * 更新数据
     *
     * @param tableName 表名称
     * @param id        Id
     * @param map       更新值的Map对象
     * @return
     */
    public int updateDataById(String tableName, String id, Map<String, Object> map) {
        return updateData(tableName, map, "f_id='" + id + "'");
    }

    /**
     * 更新数据
     *
     * @param tableName 表名称
     * @param map       更新值的Map对象
     * @param where     条件
     * @return
     */
    public int updateData(String tableName, Map<String, Object> map, String where) {
        int insert = dataBizMapper.update(tableName, map, where);
        return insert;
    }

    public int updateDataNew(String tableName, Map<String, Object> map, String where) {
        int insert = dataBizMapper.updateNew(tableName, map, where);
        return insert;
    }

    /**
     * 删除数据
     *
     * @param tableName    表名称
     * @param primaryField 表主键字段名称
     * @param id           主键值
     * @return
     */
    public int delete(String tableName, String primaryField, String id) {
        int delete = dataBizMapper.delete(tableName, primaryField, id);
        return delete;
    }

    /**
     * 根据条件删除数据
     *
     * @param tableName 表名称
     * @param where     删除条件
     * @return
     */
    public int deleteByCond(String tableName, String where) {
        int i = dataBizMapper.deleteByCond(tableName, where);
        return i;
    }

    /**
     * 根据sql执行更新
     *
     * @param tableName 表名称
     * @param sql       更新的语句
     * @param where     更新条件
     * @return
     */
    public int updateBySql(String tableName, String sql, String where) {
        return dataBizMapper.updateBySql(tableName, sql, where);
    }

    public boolean isExistTableName(String tableName) {
        GutilAssert.hasLength(tableName,"tableName 不能为空");
        if(tableName.contains(".")){
            String[] split = tableName.split("\\.");
            tableName = split[1];
        }
        String sql = "select count(*) as c from pg_class where relname = '" + tableName + "'";
        return ((Long) dataBizMapper.queryDataBySql(sql).get(0).get("c")) > 0;
    }

    /**
     * 动态拼接sql  修改图斑详情
     * 李密浩
     *
     * @param tableName  任务的表名称
     * @param jsonObject 需要修改的字段
     * @param tbId       需要修改的图斑
     * @return
     */
    public String updateTbInfoSQL(String tableName, JSONObject jsonObject, String tbId, List<TbtskFields> tbtskFields) {
        Set<String> keys = jsonObject.keySet();
        String sql = "update " + tableName + " set ";
        int i = 0;
        for (String s : keys) {
            i++;
            String fieldType = getFieldType(s, tbtskFields);
            if(StringUtils.isNotBlank(fieldType)){
                //拼接更新sql
                if (jsonObject.get(s) == null) {
                    sql += s + "=" + jsonObject.get(s);
                } else {
                    if ("4".equalsIgnoreCase(fieldType) || "5".equalsIgnoreCase(fieldType)) { //时间格式需要特殊处理
                        String datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.get(s));  // 获取年月日时分秒
                        sql += s + "='" + datetime + "'";
                    } else {
                        sql += s + "='" + jsonObject.get(s) + "'";
                    }
                }
            }
            //判断是否最后一个更新
            if (i < keys.size()) {
                sql += ",";
            }
        }
        sql += " where f_id='" + tbId + "'";
        return sql;
    }

    /**
     * 对传值为“null”的数据进行判断
     * @param tableName
     * @param jsonObject
     * @param tbId
     * @param tbtskFields
     * @return
     */
    public String updateTbInfoSQLNew(String tableName, JSONObject jsonObject, String tbId, List<TbtskFields> tbtskFields) {
        Set<String> keys = jsonObject.keySet();
        String sql = "update " + tableName + " set ";
        int i = 0;
        for (String s : keys) {
            i++;
            String fieldType = getFieldType(s, tbtskFields);
            //拼接更新sql
            if (jsonObject.get(s) == null) {
                sql += s + "=" + jsonObject.get(s);
            } else if(jsonObject.get(s).toString().equals("null")){
                sql += s + "=" + null;
            }else {
                if ("4".equalsIgnoreCase(fieldType) || "5".equalsIgnoreCase(fieldType)) { //时间格式需要特殊处理
                    String datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.get(s));  // 获取年月日时分秒
                    sql += s + "='" + datetime + "'";
                } else {
                    sql += s + "='" + jsonObject.get(s) + "'";
                }
            }
            //判断是否最后一个更新
            if (i < keys.size()) {
                sql += ",";
            }
        }
        sql += " where f_id='" + tbId + "'";
        return sql;
    }

    //获取字段类型
    public String getFieldType(String fieldName, List<TbtskFields> tbtskFields) {
        String fieldType = "";
        for (TbtskFields tbtskField : tbtskFields) {
            if (fieldName.equalsIgnoreCase(tbtskField.getfFieldname())) {
                fieldType = tbtskField.getfFieldtype();
            }
        }
        return fieldType;
    }

}
