package com.geoway.landteam.landcloud.service.customtask.task;

import cn.org.landcloud.security.Util;
import cn.org.landcloud.security.sm2.SM2SignVO;
import cn.org.landcloud.security.sm2.SM2SignVerUtils;
import cn.org.landcloud.security.sm3.SM3Utils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.FlowStep;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.repository.task.TbtskFlowDefRepository;
import com.geoway.landteam.customtask.repository.task.TbtskSubmitReportRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTaskClassRepository;
import com.geoway.landteam.customtask.repository.task.TskAssignRecordRepository;
import com.geoway.landteam.customtask.servface.review.TbtskFlowService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TbtskTaskBizFlowService;
import com.geoway.landteam.customtask.servface.task.TbtskTaskClassService;
import com.geoway.landteam.customtask.task.constants.FieldGroupTypeConstant;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.customtask.util.DateUtils;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUserDetail;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserDetailRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.model.cffx.dto.CffxConfig;
import com.geoway.landteam.landcloud.model.cffx.dto.CffxDetailConfig;
import com.geoway.landteam.landcloud.model.cffx.dto.CffxDetailInfo;
import com.geoway.landteam.landcloud.model.oauth.AuthUserInfo;
import com.geoway.landteam.landcloud.servface.cffx.MCffxTaskService;
import com.geoway.landteam.landcloud.servface.customtask.task.MITaskRecieveService;
import com.geoway.landteam.landcloud.servface.xzjsydmj.MXzjsydmjService;
import com.geoway.landteam.landcloud.service.networkTransmission.outer.OuterTaskTransmitDataService;
import com.geoway.landteam.landcloud.service.pub.TbsysBhmanagerService;
import com.geoway.landteam.landcloud.service.util.TbbhUtils;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolConfigMapper;
import com.gw.base.data.GwValidateException;
import org.apache.commons.io.FileUtils;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.WKTReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.*;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Date;
import java.util.stream.Collectors;

/**
 * @author cuiwenjing
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class MMyWorkService {
    @Value("${project.uploadDir}")
    protected String uploadDir;

 /*   @Autowired
    ThreadPoolTaskExecutor threadPoolTaskExecutor;*/

    @Autowired
    TbtskFlowService tbtskFlowService;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    TbtskSubmitReportRepository tbtskSubmitReportRepository;
    @Autowired
    TbtskTaskClassRepository tbtskTaskClassRepository;
    @Autowired
    OuterTaskTransmitDataService outerTaskTransmitDataService;

    @Autowired
    RegionService regionService;
    @Autowired
    TbsysBhmanagerService tbsysBhmanagerService;

    @Autowired
    TaskRecordService taskRecordService;

  /*  @Autowired
    CloudQueryService cloudQueryService;*/

    @Autowired
    LandUserDetailRepository userDetailRepository;

    @Autowired
    LandUser2AreaRepository landUser2AreaDao;

    @Autowired
    MDataBizService mDataBizService;

    @Autowired
    TskAssignRecordRepository tskAssignRecordRepository;

    @Autowired
    MTaskNoticeService mTaskNoticeService;

    @Autowired
    DefaultOssOperatorService ossOperatorService;

    @Autowired
    MTskTaskBizService mTskTaskBizService;

    @Autowired
    SysConfigService sysConfigService;

    @Autowired
    SysConfigRepository sysConfigRepository;

    @Autowired
    MITaskRecieveService taskRecieveService;
    @Autowired
    MTbtskObjectinfoService mTbtskObjectinfoService;

    @Autowired
    MCffxTaskService mCffxTaskService;

    @Autowired
    MXzjsydmjService mXzjsydmjService;

    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    PatrolConfigMapper patrolConfigMapper;
    @Autowired
    TbtskTaskClassService tbtskTaskClassService;
    @Autowired
    TbbhUtils tbbhUtils;

    /*@Transactional(rollbackFor = Exception.class)*/
    public JSONArray upload(HttpServletRequest request, Long userId, String bizId, Integer level) throws Exception {
        JSONArray jsonResult = new JSONArray();

        MultipartFile fileOfDB = ((MultipartHttpServletRequest) request).getFile("file");
        File tempUploadFile = buildTempUploadFile(userId.toString());
        FileUtils.copyInputStreamToFile(fileOfDB.getInputStream(), tempUploadFile);

        LandUserDetail user = userDetailRepository.findById(userId).orElse(null);
        String xzqdm = "";
        List<String> areas = landUser2AreaDao.queryAreas(userId);
        if(areas!=null && areas.size()>0){
            xzqdm =  areas.get(0);
        }

        String orgId = "";
        if(request.getSession().getAttribute("user-organization")!=null){
            orgId = request.getSession().getAttribute("user-organization").toString();
        }

        // 获取DB文件数据库连接
        SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
        ResultSet rs = null;

        String sql = "";
        String sqlPrj = "";

        // 附件信息
        sql = "select * from media";
        rs = statement.executeQuery(sql);
        List<AppMedia> listMedia = new ArrayList<>();
        while(rs.next()){
            AppMedia appMedia = getAppMedia(rs);
            appMedia.setUsername(user.getName());
            appMedia.setBizId(bizId);
            listMedia.add(appMedia);
        }
        appMediaRepository.saveAll(listMedia);



        // 关闭连接并删除缓存文件
        connPool.closeAll(connection,statement,rs);
        tempUploadFile.delete();

        return jsonResult;
    }

    public static double format7(double value) {
        double result = toFixed(BigDecimal.valueOf(value), 7).doubleValue();
        return result;
    }

    public static String format7Str(double value) {
        return toFixed(BigDecimal.valueOf(value), 7).toPlainString();
    }

    public static double format2(double value) {
        return toFixed(BigDecimal.valueOf(value), 2).doubleValue();
    }

    public static String format2Str(double value) {
        return toFixed(BigDecimal.valueOf(value), 2).toPlainString();
    }

    public static int format0(double value) {
        return toFixed(BigDecimal.valueOf(value), 0).intValue();
    }

    public static String format0Str(double value) {
        return toFixed(BigDecimal.valueOf(value), 0).toPlainString();
    }

    /**
     * 保留小数
     * @param bigDecimal
     * @param scale
     * @return
     */
    public static BigDecimal toFixed(BigDecimal bigDecimal, int scale){
        String plainStr = bigDecimal.toPlainString();
        if(plainStr.indexOf(".") != -1){
            String xiaoshu = plainStr.substring(plainStr.indexOf(".") + 1);
            if(xiaoshu.length() > scale){
                bigDecimal = bigDecimal.setScale(scale, BigDecimal.ROUND_HALF_UP);
                return delEndZero(bigDecimal);
            }else {
                return delEndZero(bigDecimal);
            }
        }else {
            return bigDecimal;
        }

    }

    private static BigDecimal delEndZero(BigDecimal bigDecimal) {
        while (bigDecimal.toPlainString().contains(".") && bigDecimal.toPlainString().endsWith("0")){
            String str = bigDecimal.toPlainString().substring(0, bigDecimal.toPlainString().length()-1);
            bigDecimal = new BigDecimal(str);
        }
        return bigDecimal;
    }


    public boolean verifyJym(ResultSet rs ) throws SQLException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer buffer = new StringBuffer();
        buffer.append(rs.getString("f_sm3")).append(",");
        buffer.append((sdf.format(new Date(rs.getLong("f_time"))))).append(",");
        buffer.append((format7Str(rs.getDouble("f_lon")))).append(",");
        buffer.append((format7Str(rs.getDouble("f_lat")))).append(",");
        buffer.append(format0Str(rs.getDouble("f_psfyj"))).append(",");
        buffer.append(format0Str(rs.getDouble("f_azimuth"))).append(",");
        buffer.append(format0Str(rs.getDouble("f_roll"))).append(",");
        buffer.append(rs.getString("f_psry")).append(",");
        buffer.append(rs.getString("f_zsdm"));
        String hash = SM3Utils.sm3(buffer.toString());
        SM2SignVO verify = SM2SignVerUtils.VerifySignSM2(Util.hexStringToBytes("04D964FD6AE472FC3367C09935DEBFC9A613F6F084ED8CA5B4C2EBF0E9F9FA5146E1631B842FED8FD55B488674C37B5FE695A49EE5A52BBEEA0868C2E816E5C47C"),
                hash.getBytes(StandardCharsets.UTF_8), Util.hexToByte(Util.SM2SignHardToSoft(rs.getString("f_jym"))));
        if(verify != null){
            return verify.isVerify();
        }else {
            return false;
        }
    }

   /* @Transactional(rollbackFor = Exception.class)*/
    public JSONArray upload1(MultipartFile[] files, AuthUserInfo authUserInfo, String bizId, String orgId) throws Exception {

        JSONArray jsonResult = new JSONArray();
        TskTaskBiz task = mTskTaskBizService.findByTaskId(bizId);
        TbtskTaskClass tbtskTaskClass = null;
        if(task.getClassId() != null && org.apache.commons.lang3.StringUtils.isNotBlank(task.getClassId().toString())){
            tbtskTaskClass = tbtskTaskClassRepository.queryByFId(task.getClassId());
        }
       /* TbtskObjectinfo tableByTableId = mTskTaskBizService.getTableByTableId(task.getTableId());*/

        if (files.length < 1) {
            return jsonResult;
        }
        //重复判断配置
        CffxConfig cffxConfig = mCffxTaskService.getConfig();
        CffxDetailConfig detailConfig = null;
        if(cffxConfig.isAppUploadCffx())
        {
            detailConfig = mCffxTaskService.getDetailConfig(cffxConfig,bizId);
        }
        boolean validGeoTopo=false;
        boolean disableMultiPolygon=false;
        String pkField="f_id";


        SysConfig config = sysConfigRepository.queryByKey("validGeoConfig");
        if(config!=null)
        {
            JSONObject jsonConfig =  JSONObject.parseObject(config.getValue());
            if(jsonConfig.containsKey("validTask"))
            {
                JSONArray jsonArray = jsonConfig.getJSONArray("validTask");
                Optional<JSONObject> op =  jsonArray.stream().filter(t->bizId.equals(((JSONObject)t).getString("taskId"))).findFirst();
                if(op.isPresent())
                {
                    JSONObject  jsonObject = op.get();
                    validGeoTopo = jsonObject.getBoolean("validGeoTopo");
                    disableMultiPolygon = jsonObject.getBoolean("disableMultiPolygon");
                    pkField = jsonObject.getString("pkField");
                }
            }
        }

        boolean xzjsydmj=mXzjsydmjService.needXzjsydmj(bizId);

        List<String>xzjsydmjSql = new ArrayList<>();
        MultipartFile fileOfDB = files[0];

        File tempUploadFile = buildTempUploadFile(authUserInfo.getUserId().toString());
        FileUtils.copyInputStreamToFile(fileOfDB.getInputStream(), tempUploadFile);

        //LandUserDetail user = userDetailRepository.findById(authUserInfo.getUserId()).orElse(null);
        // 获取DB文件数据库连接
        SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
        JSONArray taskIds = new JSONArray();

        // 支持同时上传多张表
        String tableInfoSql = "select * from table_info";
        ResultSet  rs = statement.executeQuery(tableInfoSql);
        List<Map<String,Object>> tableInfoResult = new ArrayList<>();
        while (rs.next()) {
            Map<String,Object>  map = new HashMap<>();
            map.put("f_tablename",rs.getString("f_tablename"));
            map.put("f_tableid",rs.getString("f_tableid"));
            map.put("f_allownedit",rs.getString("f_allownedit"));
            tableInfoResult.add(map);
        }
        List<Map<String, Object>> datas = new ArrayList<>();
        for(Map<String,Object> tableInfoMap : tableInfoResult){
            String tableName = tableInfoMap.get("f_tablename").toString();
            String f_tableid = tableInfoMap.get("f_tableid").toString();
            TbtskObjectinfo objectinfo = mTskTaskBizService.getTableByTableId(f_tableid);
            // 是否允许修改边界
            String allowEdit = tableInfoMap.get("f_allownedit").toString();
            String sqlField = "select * from task_fields where f_tablename='" + tableName + "'";
            ResultSet rsField = statement.executeQuery(sqlField);
            // 可编辑字段
            Set<String> editkeys = new HashSet<>();
            Set<String> keys = new HashSet<>();

            while (rsField.next()) {
                String key = rsField.getString("f_fieldname");
                keys.add(key);
            }

            List<TbtskFields> tbtskFieldsByTaskId = mTskTaskBizService.findTbtskFieldsByTableName(objectinfo.getfTablename()).stream().filter(r->!r.getfFieldname().equals("f_submittime")).collect(Collectors.toList());
            //获取需要自增编号字段
            List<String> autovalField = new ArrayList<>();
            Map<String,Object> autovalMap = new HashMap<>();
            Map<String,Object> timeMap = new HashMap<>();
            // 内业可编辑及外业字段 覆盖
            for (TbtskFields tbtskFields : tbtskFieldsByTaskId) {
                Integer isIOS = tbtskFields.getfFieldInnerOuterSys();
                Integer isedit = tbtskFields.getfIsWebEdit();
                // 只有内业 中的 可编辑
                //boolean innerEdit = new Integer(1).equals(isedit) && (FieldGroupTypeConstant.INNER_FIELD == isIOS.intValue());
                // 2 3 6
                boolean outer = ((isIOS.intValue() & FieldGroupTypeConstant.OUTER_FIELD) == FieldGroupTypeConstant.OUTER_FIELD);
               // if (innerEdit || outer) {
                if ( outer) {
                    editkeys.add(tbtskFields.getfFieldname());
                }
                //获取编码字段及其配置规则{name:'编码',id:'11'}
                if(tbtskFields.getfFieldtype().equals("11") && org.apache.commons.lang3.StringUtils.isNotBlank(tbtskFields.getAutoVal())){
                    autovalField.add(tbtskFields.getfFieldname());
                    autovalMap.put(tbtskFields.getfFieldname(),tbtskFields.getAutoVal());
                }
                //获取时间字段
                if(tbtskFields.getfFieldtype().equals("4") || tbtskFields.getfFieldtype().equals("5")){
                    timeMap.put(tbtskFields.getfFieldname(),tbtskFields.getfFieldtype());
                }
            }
            //查询任务所在业务是否配置了编码规则
            TbtskTaskClass parentTbtskTaskClass = tbtskTaskClassService.getParentTbtskTaskClass(task.getClassId());
            //处理母图斑数据
            if (StringUtils.isNotBlank(tableName)) {
               String  tableNamesql = "select * from " + tableName;
                ResultSet resultSet = statement.executeQuery(tableNamesql);
                String id = null;
                //如果是领取模式任务则提交后所有该作业区下作业员都能收到
                List<String> addList = new ArrayList<>();
                List<String> updateList = new ArrayList<>();
                while (resultSet.next()) {
                    //返回数据
                    JSONObject resultObject = new JSONObject();
                    Map<String, Object> map = new HashMap<>();
                    int isMyCreat = resultSet.getInt("f_ismycreate");

                    String f_id = resultSet.getString("f_id");
                    resultObject.put("f_id",f_id);
                    Map mapdata = mDataBizService.selectByID(objectinfo.getfTablename(), "f_id", "'" + f_id + "'");
                    if (mapdata == null) {
                        if(task.getMode().equals(2)){
                            //领取模式任务自动打包下发给其他作业员
                            addList.add(f_id);
                        }
                        map.put("f_lat", resultSet.getDouble("f_lat"));
                        map.put("f_lon", resultSet.getDouble("f_lon"));
                        for (String key : keys) {
                            if (StringUtils.isNotBlank(resultSet.getString(key))) {
                                String kvalue = resultSet.getString(key);
                                map.put(key, kvalue);
                                if(timeMap.containsKey(key) ){
                                    if(StringUtils.isNotBlank(kvalue))
                                    {
                                        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                        try {
                                            long t= Long.parseLong(kvalue);
                                            Calendar calendar =  Calendar.getInstance();
                                            calendar.setTimeInMillis(t);
                                            String tt=  dateFormat.format(calendar.getTime());
                                            map.put(key, tt);
                                        }
                                        catch (Exception ex)
                                        {
                                            try {
                                                Date date = dateFormat.parse(kvalue);
                                                map.put(key, kvalue);
                                            } catch (ParseException e) {
                                                Timestamp ts = new Timestamp(Long.valueOf(kvalue));
                                                map.put(key, ts);
                                            }
                                        }


                                    }
                                    else
                                    {
                                        map.put(key,null);
                                    }
                                }
                            }
                        }
                        String shape="";
                        if (!StringUtils.isBlank(resultSet.getString("f_shape"))) {
                            shape =resultSet.getString("f_shape");
                            map.put("f_shape", "SRID=4490;"+shape);
                        }
                        if (!StringUtils.isBlank(resultSet.getString("f_shape1"))) {
                            map.put("f_shape1", "SRID=4490;"+resultSet.getString("f_shape1"));
                        }
                        if (!StringUtils.isBlank(resultSet.getString("f_shape_b"))) {
                            map.put("f_shape_b","SRID=4490;"+ resultSet.getString("f_shape_b"));
                        }
                        if (!StringUtils.isBlank(resultSet.getString("f_shape_g"))) {
                            map.put("f_shape_g", "SRID=4490;"+resultSet.getString("f_shape_g"));
                        }
                        map.put("f_status", "4");
                        //巡查管理任务默认已提报
                        if(tbtskTaskClass != null && "XCYW".equals(tbtskTaskClass.getAppkey())){
                            map.put("f_status", "10");
                            map.put("f_review_stage", "90");
                        }
                        map.put("f_id", resultSet.getString("f_id"));
                        map.put("f_createtime", resultSet.getString("f_createtime"));
                        map.put("f_committime", System.currentTimeMillis());
                        map.put("f_updatetime", System.currentTimeMillis());
                        map.put("f_upload_userid", authUserInfo.getUserRname());
                        map.put("f_userid", authUserInfo.getUserId().toString());
                        map.put("f_submit_userid", authUserInfo.getUserId().toString());
                        map.put("f_ismycreate", resultSet.getString("f_ismycreate"));
                        map.put("f_submittime",System.currentTimeMillis());

                        String pkFieldValue = f_id;
                        if(resultSet.findColumn(pkField)>-1)
                        {
                            pkFieldValue = resultSet.getString(pkField);
                        }

                        //重复判断
                        cffx(map,detailConfig,task,null);
                        //拓扑检测
                        if(validGeoTopo|| disableMultiPolygon)
                        {
                           valid(f_id,pkFieldValue,map,validGeoTopo,disableMultiPolygon);
                        }

                        // app端新增图斑
                        String xzq = resultSet.getString("f_xzqdm");
                        if (StringUtils.isNotBlank(xzq)) {
                            String xzqname = regionService.getNameByCode(xzq);
                            if (xzqname != null) {
                                map.put("f_xzqmc1", xzqname);
                            }
                        }
                        //处理新增的市、县、镇、村
                        List<String> fields = tbtskFieldsByTaskId.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
                        if(fields.contains("f_xzqdmcity") && org.apache.commons.lang3.StringUtils.isNotBlank((String)map.get("f_xzqdmsys"))){
                            map.put("f_xzqdmcity", map.get("f_xzqdmsys").toString().substring(0,4)+"00");
                            map.put("f_xzqdmcounty", map.get("f_xzqdmsys").toString().substring(0,6));
                            map.put("f_xzqdmtown", map.get("f_xzqdmsys").toString().substring(0,9));
                        }
                        //查看是否配置了自动编码
                        if(StringUtils.isNotBlank(parentTbtskTaskClass.getParam())){
                            String tbbh = tbbhUtils.getTaskTbbh(bizId, map.get("f_xzqdmsys").toString());
                            map.put("f_tbbh",tbbh);
                            JSONObject object = new JSONObject();
                            object.put("f_tbbh",tbbh);
                            resultObject.put("data",object);
                        }
                        //处理自增编号字段
                        if(autovalField.size() > 0){
                            JSONObject jsonObject = new JSONObject();
                            for(String s : autovalField){
                                Pair<String, String> paramKey = tbsysBhmanagerService.getParamKey(autovalMap.get(s).toString(),map);
                                String bhNextValue = tbsysBhmanagerService.getBhNextValue(objectinfo.getfTablename(), s, paramKey.getLeft(), Integer.valueOf(paramKey.getRight()));
                                map.put(s,bhNextValue);
                                jsonObject.put(s,bhNextValue);
                            }
                            resultObject.put("data",jsonObject);
                        }
                        //新建住房任务定制 自动提报
                        JSONObject object = JSONObject.parseObject(task.getConfigArgs());
                        if(object.get("isxjzf")!=null && object.get("isxjzf").toString().equals("1")){
                            map.put("f_status",10);
                            map.put("f_reject_status",null);
                            FlowStep flow = tbtskFlowService.findFlow(bizId, 1, 0);
                            if(flow!=null) {
                                String pre_stages = flow.getPre_stages();
                                String[] split = pre_stages.split(",");
                                map.put("f_review_stage", split[1]);
                            }
                        }
                        mDataBizService.insertDataByTimeStamp(objectinfo.getfTablename(), map, "f_shape");
                        if(xzjsydmj&&StringUtils.isNotBlank(shape))
                        {
                            xzjsydmjSql.add(String.format("insert into xzjsydmj(f_id,f_shape,f_split,f_taskid) values('%s','%s','0','%s')",f_id,shape,bizId));
                        }
                        datas.add(map);
                        // 新增下发记录
                        TskAssignRecord tar = new TskAssignRecord();
                        tar.setTaskId(bizId);
                        tar.setDataId(resultSet.getString("f_id"));
                        tar.setCreateTime(DateUtils.getSysTime());
                        tar.setAssignto(authUserInfo.getUserId().toString());
                        tar.setOptUserId(authUserInfo.getUserId().toString());
                        tar.setSourceId(orgId);
                        tar.setStatus("1");
                        tar.setSourceType("org");
                        tskAssignRecordRepository.save(tar);

                        taskIds.add(resultSet.getString("f_id"));
                    } else {
                        if(task.getMode().equals("2")){
                            updateList.add(f_id);
                        }
                        id = resultSet.getString("f_id");
                        // 只更新内业可编辑字段、外业
                        for (String key : editkeys) {
//                                if (StringUtils.isNotBlank(resultSet.getString(key))) {
//                                    map.put(key, resultSet.getString(key));
//                                }

                            // 现在调整为，不管数据是否为空，只要提交了这个数据，就更新
                            String kvalue= resultSet.getString(key);
                            map.put(key,kvalue);
                            if(timeMap.containsKey(key) ){
                                if(StringUtils.isNotBlank(kvalue))
                                {
                                    DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                    try {
                                        long t= Long.parseLong(kvalue);
                                        Calendar calendar =  Calendar.getInstance();
                                        calendar.setTimeInMillis(t);
                                        String tt=  dateFormat.format(calendar.getTime());
                                        map.put(key, tt);
                                    }
                                    catch (Exception ex)
                                    {
                                        try {
                                            Date date = dateFormat.parse(kvalue);
                                            map.put(key, kvalue);
                                        } catch (ParseException e) {
                                            Timestamp ts = new Timestamp(Long.valueOf(kvalue));
                                            map.put(key, ts);
                                        }
                                    }


                                }
                                else
                                {
                                    map.put(key,null);
                                }

                            }
                        }
                        //
                        if ("1".equals(allowEdit)) {
                            map.put("f_lat", resultSet.getDouble("f_lat"));
                            map.put("f_lon", resultSet.getDouble("f_lon"));
                            map.put("f_lat_b", resultSet.getDouble("f_lat_b"));
                            map.put("f_lon_b", resultSet.getDouble("f_lon_b"));
                            map.put("f_lat_g", resultSet.getDouble("f_lat_g"));
                            map.put("f_lon_g", resultSet.getDouble("f_lon_g"));

                            String shape ="";
                            if (!StringUtils.isBlank(resultSet.getString("f_shape"))) {
                                shape = resultSet.getString("f_shape");
                                map.put("f_shape", "SRID=4490;"+shape);

                            }
                            if (!StringUtils.isBlank(resultSet.getString("f_shape1"))) {
                                map.put("f_shape1","SRID=4490;"+ resultSet.getString("f_shape1"));
                            }
                            if (!StringUtils.isBlank(resultSet.getString("f_shape_b"))) {
                                map.put("f_shape_b","SRID=4490;"+ resultSet.getString("f_shape_b"));
                            }
                            if (!StringUtils.isBlank(resultSet.getString("f_shape_g"))) {
                                map.put("f_shape_g", "SRID=4490;"+resultSet.getString("f_shape_g"));
                            }
                            if(xzjsydmj&&StringUtils.isNotBlank(shape))
                            {
                                xzjsydmjSql.add(String.format("insert into xzjsydmj(f_id,f_shape,f_split,f_taskid) values('%s','%s','0','%s')",f_id,shape,bizId));
                            }
                        }
                        map.put("f_status", "4");

                        // 系统字段
                        map.put("f_upload_userid", authUserInfo.getUserRname());
                        map.put("f_submit_userid", authUserInfo.getUserId().toString());
                        map.put("f_committime", System.currentTimeMillis());
                        map.put("f_updatetime", System.currentTimeMillis());
                        //处理新增的市、县、镇、村
                        List<String> fields = tbtskFieldsByTaskId.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
                        if(fields.contains("f_xzqdmcity") && org.apache.commons.lang3.StringUtils.isNotBlank((String)map.get("f_xzqdmsys"))){
                            map.put("f_xzqdmcity", map.get("f_xzqdmsys").toString().substring(0,4)+"00");
                            map.put("f_xzqdmcounty", map.get("f_xzqdmsys").toString().substring(0,6));
                            map.put("f_xzqdmtown", map.get("f_xzqdmsys").toString().substring(0,9));
                        }
                        TskAssignRecord sr = null;
                        List<TskAssignRecord> srList = tskAssignRecordRepository.findByTaskIdAndAssigntoAndDataIdList(bizId, authUserInfo.getUserId().toString(), id);
                        if (srList != null && srList.size() > 0) {
                            sr = srList.get(0);
                        }
                        if (sr != null) {
                            sr.setStatus("1");
                            tskAssignRecordRepository.save(sr);
                        } else {
                            TskAssignRecord tar = new TskAssignRecord();
                            tar.setStatus("1");
                            tar.setSourceType("org");
                            tar.setTaskId(bizId);
                            tar.setDataId(id);
                            tar.setCreateTime(DateUtils.getSysTime());
                            tar.setAssignto(authUserInfo.getUserId().toString());
                            tar.setOptUserId(authUserInfo.getUserId().toString());
                            tar.setSourceId(orgId);
                            tskAssignRecordRepository.save(tar);

                            taskIds.add(id);
                        }

                        if (StringUtils.isNotBlank(id)) {

                            List<String> field1s = new ArrayList<>();
                            field1s.add("f_id");
                            field1s.add("f_status");
                            Map currObj = mDataBizService.selectFieldByID(objectinfo.getfTablename(), field1s, "f_id", "'" + id + "'");
                            if (currObj.get("f_status") != null) {
                                if (Integer.parseInt(currObj.get("f_status").toString()) < 10) {//已提交的图斑数据不可以再次变更信息
                                    if ("1".equals(allowEdit)) {
                                        String pkFieldValue = id;
                                        if(mapdata.containsKey(pkField))
                                        {
                                            pkFieldValue = mapdata.get(pkField)==null?"":mapdata.get(pkField).toString();
                                        }

                                        //重复判断
                                        cffx(map,detailConfig,task,null);
                                        //拓扑监测
                                        if(validGeoTopo|| disableMultiPolygon)
                                        {
                                            valid(id,pkFieldValue,map,validGeoTopo,disableMultiPolygon);
                                        }
                                    }
                                    //新建住房任务定制 自动提报
                                    JSONObject object = JSONObject.parseObject(task.getConfigArgs());
                                    if(object.get("isxjzf")!=null && object.get("isxjzf").toString().equals("1")){
                                        map.put("f_status",10);
                                        map.put("f_reject_status",null);
                                        FlowStep flow = tbtskFlowService.findFlow(bizId, 1, 0);
                                        if(flow!=null) {
                                            String pre_stages = flow.getPre_stages();
                                            String[] split = pre_stages.split(",");
                                            map.put("f_review_stage", split[1]);
                                        }
                                    }
                                    mDataBizService.updateData(objectinfo.getfTablename(), map, " f_id = '" + id + "'");
                                    map.put("f_id",id);
                                    datas.add(map);
                                }
                            }
                        }
                    }
                    jsonResult.add(resultObject);
                }
                //如果是领取模式任务则自动执行
                createTaskRecord(task,addList,updateList,authUserInfo.getUserId());
            }
            //判断任务是否存在子图斑
            if(org.apache.commons.lang3.StringUtils.isNotBlank(objectinfo.getSplitTableName() )){
                handlyChildData(objectinfo.getSplitTableName(), statement,editkeys,keys, authUserInfo, allowEdit,xzjsydmj,xzjsydmjSql,bizId, timeMap);
            }
        }
        // 附件信息
       String mediasql = "select * from media";
        rs = statement.executeQuery(mediasql);
        List<AppMedia> listMedia = new ArrayList<>();
        while(rs.next()){
            AppMedia appMedia = getAppMedia(rs);
            appMedia.setUsername(authUserInfo.getUsername());
            appMedia.setBizId(bizId);
            listMedia.add(appMedia);
        }

        if (task != null) {
            if ("2".equals(task.getType()) && 2 == task.getMode()) {
                JSONArray groups = new JSONArray();
                groups.add(authUserInfo.getUserId());

                taskRecieveService.recieveTask(authUserInfo.getUserId(), task.getId(), taskIds, groups);
            }
        }
        if(task.getSource().equals("内网任务")){
            outerTaskTransmitDataService.doWork(datas, bizId, listMedia,authUserInfo.getUserId());
        }
        appMediaRepository.saveAll(listMedia);
        // 关闭连接并删除缓存文件
        connPool.closeAll(connection,statement,rs);
        tempUploadFile.delete();
        if(xzjsydmj&&!xzjsydmjSql.isEmpty()) {
            List<String>fields = new ArrayList<>();
            fields.addAll(Arrays.stream(org.apache.commons.lang3.StringUtils.split("f_id,f_shape,f_split,f_taskid", ",")).collect(Collectors.toList()));
            mXzjsydmjService.xzjsydmj(xzjsydmjSql, "xzjsydmj",bizId,fields,"f_shape");
        }
        return jsonResult;
    }

    void createTaskRecord(TskTaskBiz task,List<String> addList,List<String> updateList,Long userId){
        if(task.getMode().equals(2)){
            if(!addList.isEmpty()){
                JSONObject additionJson = new JSONObject();
                additionJson.put("count", addList.size());
                additionJson.put("addOrUpdate", "ADD");
                additionJson.put("taskMode", task.getMode());
                additionJson.put("curMode", "receive");

                String recordId = UUID.randomUUID().toString();
                TaskDataDbParameter parameter = new TaskDataDbParameter();
                parameter.setRecordId(recordId);
                parameter.setTaskId(task.getId());
                parameter.setGroups(new JSONArray());
                parameter.setOrgs(new JSONArray());
                parameter.setAddition(additionJson);
                parameter.setDate(String.valueOf(System.currentTimeMillis()));
                //parameter.setIds(add);
                parameter.setMode(task.getMode().toString());

                List<TaskRecordTemp> tempList = new ArrayList<>();
                for (int i = 0; i < addList.size(); i++) {
                    TaskRecordTemp temp = new TaskRecordTemp();
                    temp.setId(UUID.randomUUID().toString());
                    temp.setRecordid(recordId);
                    temp.setDataid(addList.get(i));
                    tempList.add(temp);
                }

                taskRecordService.saveTaskRecordTemp(tempList);

                TaskRecord record2 = new TaskRecord();
                record2.setId(recordId);
                record2.setParam(JSONObject.toJSONString(parameter));
                record2.setTasktype(JobConstants.JOB_TYPE_DATA_PACKAGE);
                record2.setStarttime(new Date());
                record2.setState(1);
                record2.setUserid(userId);
                taskRecordService.save(record2);
            }
            if(!updateList.isEmpty()){
                String recordId1 = UUID.randomUUID().toString();
                JSONObject additionJson1 = new JSONObject();
                additionJson1.put("count", updateList.size());
                additionJson1.put("addOrUpdate", "UPDATE");
                additionJson1.put("taskMode", task.getMode());
                additionJson1.put("curMode", "receive");

                TaskDataDbParameter parameter1 = new TaskDataDbParameter();
                parameter1.setRecordId(recordId1);
                parameter1.setTaskId(task.getId());
                //parameter1.setTbIds(JSONArray.parseArray(JSONObject.toJSONString(update)));
                parameter1.setGroups(new JSONArray());
                parameter1.setOrgs(new JSONArray());
                parameter1.setAddition(additionJson1);
                parameter1.setDate(String.valueOf(System.currentTimeMillis()));
                //parameter1.setIds(update);
                parameter1.setMode(task.getMode().toString());

                List<TaskRecordTemp> tempList = new ArrayList<>();
                for (int i = 0; i < updateList.size(); i++) {
                    TaskRecordTemp temp = new TaskRecordTemp();
                    temp.setId(UUID.randomUUID().toString());
                    temp.setRecordid(recordId1);
                    temp.setDataid(updateList.get(i));
                    tempList.add(temp);
                }

                taskRecordService.saveTaskRecordTemp(tempList);

                TaskRecord record1 = new TaskRecord();
                record1.setId(recordId1);
                record1.setParam(JSONObject.toJSONString(parameter1));
                record1.setTasktype(JobConstants.JOB_TYPE_DATA_PACKAGE);
                record1.setStarttime(new Date());
                record1.setState(1);
                record1.setUserid(userId);
                taskRecordService.save(record1);
            }
        }
    }

   /* @Transactional(rollbackFor = Exception.class)*/
    public JSONArray upload2(MultipartFile[] files, AuthUserInfo authUserInfo, String bizId, String orgId) throws Exception {

        Long userId = authUserInfo.getUserId();
        JSONArray jsonResult = new JSONArray();
        TskTaskBiz task = mTskTaskBizService.findByTaskId(bizId);
        TbtskObjectinfo tableByTableId = mTskTaskBizService.getTableByTableId(task.getTableId());
        if (files.length < 1) {
            return jsonResult;
        }
        MultipartFile fileOfDB = files[0];
        File tempUploadFile = buildTempUploadFile(userId.toString());
        FileUtils.copyInputStreamToFile(fileOfDB.getInputStream(), tempUploadFile);
        //LandUserDetail user = userDetailRepository.findById(userId).orElse(null);
        // 获取DB文件数据库连接
        SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
        ResultSet rs = null;
        String sql = "";
        JSONArray taskIds = new JSONArray();
        // 支持同时上传多张表
        sql = "select * from table_info";
        rs = statement.executeQuery(sql);
        List<Map<String, Object>> datas = new ArrayList<>();
        while (rs.next()) {
            String tableName = rs.getString("f_tablename");
            // 是否允许修改边界
            String allowEdit = rs.getString("f_allownedit");

            String sqlField = "select * from task_fields where f_tablename='" + tableName + "'";
            ResultSet rsField = statement.executeQuery(sqlField);
            // 可编辑字段
            Set<String> editkeys = new HashSet<>();
            Set<String> keys = new HashSet<>();

            while (rsField.next()) {
                String key = rsField.getString("f_fieldname");
                keys.add(key);
            }
            List<TbtskFields> tbtskFieldsByTaskId = mTskTaskBizService.findTbtskFieldsByTableName(tableName);
            //获取需要自增编号字段
            List<String> autovalField = new ArrayList<>();
            Map<String,Object> autovalMap = new HashMap<>();
            Map<String,Object> timeMap = new HashMap<>();
            // 内业可编辑及外业字段 覆盖
            for (TbtskFields tbtskFields : tbtskFieldsByTaskId) {
                Integer isIOS = tbtskFields.getfFieldInnerOuterSys();
                Integer isedit = tbtskFields.getfIsWebEdit();
                // 只有内业 中的 可编辑
                boolean innerEdit = new Integer(1).equals(isedit) && (FieldGroupTypeConstant.INNER_FIELD == isIOS.intValue());
                // 2 3 6
                boolean outer = ((isIOS.intValue() & FieldGroupTypeConstant.OUTER_FIELD) == FieldGroupTypeConstant.OUTER_FIELD);
                if (innerEdit || outer) {
                    editkeys.add(tbtskFields.getfFieldname());
                }
                //获取编码字段及其配置规则{name:'编码',id:'11'}
                if(tbtskFields.getfFieldtype().equals("11") && org.apache.commons.lang3.StringUtils.isNotBlank(tbtskFields.getAutoVal())){
                    autovalField.add(tbtskFields.getfFieldname());
                    autovalMap.put(tbtskFields.getfFieldname(),tbtskFields.getAutoVal());
                }
                //获取时间字段
                if(tbtskFields.getfFieldtype().equals("4") || tbtskFields.getfFieldtype().equals("5")){
                    timeMap.put(tbtskFields.getfFieldname(),tbtskFields.getfFieldtype());
                }
            }
            //处理母图斑数据
            if (StringUtils.isNotBlank(tableName)) {
                sql = "select * from " + tableName;
                ResultSet resultSet = statement.executeQuery(sql);
                String id = null;
                while (resultSet.next()) {
                    //返回数据
                    JSONObject resultObject = new JSONObject();
                    Map<String, Object> map = new HashMap<>();
                    int isMyCreat = resultSet.getInt("f_ismycreate");

                    String f_id = resultSet.getString("f_id");
                    resultObject.put("f_id",f_id);
                    Map mapdata = mDataBizService.selectByID(tableName, "f_id", "'" + f_id + "'");
                    if (mapdata == null) {
                        map.put("f_lat", resultSet.getDouble("f_lat"));
                        map.put("f_lon", resultSet.getDouble("f_lon"));
                        for (String key : keys) {
                            if (StringUtils.isNotBlank(resultSet.getString(key))) {
                                map.put(key, resultSet.getString(key));
                                if(timeMap.containsKey(key) ){
                                    if(StringUtils.isNotBlank(resultSet.getString(key))){
                                        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                        try {
                                            Date date = dateFormat.parse(resultSet.getString(key));
                                            Timestamp timestamp = new Timestamp(date.getTime());
                                            map.put(key, timestamp);
                                        } catch (ParseException e) {
                                            Timestamp ts = new Timestamp(Long.valueOf(resultSet.getString(key)));
                                            map.put(key, ts);
                                        }
                                    }else{
                                        map.put(key, null);
                                    }
                                }
                            }
                        }
                        if (!StringUtils.isBlank(resultSet.getString("f_shape"))) {
                            map.put("f_shape", "SRID=4490;"+resultSet.getString("f_shape"));
                        }
                        if (!StringUtils.isBlank(resultSet.getString("f_shape1"))) {
                            map.put("f_shape1", "SRID=4490;"+resultSet.getString("f_shape1"));
                        }
                        if (!StringUtils.isBlank(resultSet.getString("f_shape_b"))) {
                            map.put("f_shape_b","SRID=4490;"+ resultSet.getString("f_shape_b"));
                        }
                        if (!StringUtils.isBlank(resultSet.getString("f_shape_g"))) {
                            map.put("f_shape_g", "SRID=4490;"+resultSet.getString("f_shape_g"));
                        }
                        map.put("f_status", "10");
                        map.put("f_review_stage", "90");
                        map.put("f_id", resultSet.getString("f_id"));
                        map.put("f_createtime", resultSet.getString("f_createtime"));
                        map.put("f_committime", System.currentTimeMillis());
                        map.put("f_updatetime", System.currentTimeMillis());
                        map.put("f_upload_userid", authUserInfo.getUserRname());
                        map.put("f_userid", userId.toString());
                        map.put("f_submit_userid", userId.toString());
                        map.put("f_ismycreate", resultSet.getString("f_ismycreate"));
                        // app端新增图斑
                        String xzq = resultSet.getString("f_xzqdm");
                        if (StringUtils.isNotBlank(xzq)) {
                            String xzqname = regionService.getNameByCode(xzq);
                            if (xzqname != null) {
                                map.put("f_xzqmc1", xzqname);
                            }
                        }
                        //处理自增编号字段
                        if(autovalField.size() > 0){
                            JSONObject jsonObject = new JSONObject();
                            for(String s : autovalField){
                                Pair<String, String> paramKey = tbsysBhmanagerService.getParamKey(autovalMap.get(s).toString(),map);
                                String bhNextValue = tbsysBhmanagerService.getBhNextValue(tableByTableId.getfTablename(), s, paramKey.getLeft(), Integer.valueOf(paramKey.getRight()));
                                map.put(s,bhNextValue);
                                jsonObject.put(s,bhNextValue);
                            }
                            resultObject.put("data",jsonObject);
                        }
                        mDataBizService.insertDataByTimeStamp(tableByTableId.getfTablename(), map, "f_shape");
                        datas.add(map);
                        taskIds.add(resultSet.getString("f_id"));
                    } else {
                        id = resultSet.getString("f_id");
                        // 只更新内业可编辑字段、外业
                        for (String key : editkeys) {
//                                if (StringUtils.isNotBlank(resultSet.getString(key))) {
//                                    map.put(key, resultSet.getString(key));
//                                }

                            // 现在调整为，不管数据是否为空，只要提交了这个数据，就更新
                            map.put(key, resultSet.getString(key));
                            if(timeMap.containsKey(key) ){
                                if(StringUtils.isNotBlank(resultSet.getString(key))){
                                    DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                    try {
                                        Date date = dateFormat.parse(resultSet.getString(key));
                                        Timestamp timestamp = new Timestamp(date.getTime());
                                        map.put(key, timestamp);
                                    } catch (ParseException e) {
                                        Timestamp ts = new Timestamp(Long.valueOf(resultSet.getString(key)));
                                        map.put(key, ts);
                                    }
                                }else{
                                    map.put(key, null);
                                }
                            }
                        }
                        //
                        if ("1".equals(allowEdit)) {
                            map.put("f_lat", resultSet.getDouble("f_lat"));
                            map.put("f_lon", resultSet.getDouble("f_lon"));
                            map.put("f_lat_b", resultSet.getDouble("f_lat_b"));
                            map.put("f_lon_b", resultSet.getDouble("f_lon_b"));
                            map.put("f_lat_g", resultSet.getDouble("f_lat_g"));
                            map.put("f_lon_g", resultSet.getDouble("f_lon_g"));

                            if (!StringUtils.isBlank(resultSet.getString("f_shape"))) {
                                map.put("f_shape", "SRID=4490;"+resultSet.getString("f_shape"));

                            }
                            if (!StringUtils.isBlank(resultSet.getString("f_shape1"))) {
                                map.put("f_shape1","SRID=4490;"+ resultSet.getString("f_shape1"));
                            }
                            if (!StringUtils.isBlank(resultSet.getString("f_shape_b"))) {
                                map.put("f_shape_b","SRID=4490;"+ resultSet.getString("f_shape_b"));
                            }
                            if (!StringUtils.isBlank(resultSet.getString("f_shape_g"))) {
                                map.put("f_shape_g", "SRID=4490;"+resultSet.getString("f_shape_g"));
                            }
                        }
                        map.put("f_status", "10");
                        // 系统字段
                        map.put("f_upload_userid", authUserInfo.getUserRname());
                        map.put("f_submit_userid", userId.toString());
                        map.put("f_committime", System.currentTimeMillis());
                        map.put("f_updatetime", System.currentTimeMillis());

                        TskAssignRecord sr = null;
                        List<TskAssignRecord> srList = tskAssignRecordRepository .findByTaskIdAndAssigntoAndDataIdList(bizId, userId.toString(), id);
                        if (srList != null && srList.size() > 0) {
                            sr = srList.get(0);
                        }
                        if (sr != null) {
                            sr.setStatus("1");
                            tskAssignRecordRepository.save(sr);
                        } else {
                            TskAssignRecord tar = new TskAssignRecord();
                            tar.setStatus("1");
                            tar.setSourceType("org");
                            tar.setTaskId(bizId);
                            tar.setDataId(id);
                            tar.setCreateTime(DateUtils.getSysTime());
                            tar.setAssignto(userId.toString());
                            tar.setOptUserId(userId.toString());
                            tar.setSourceId(orgId);
                            tskAssignRecordRepository.save(tar);

                            taskIds.add(id);
                        }

                        if (StringUtils.isNotBlank(id)) {

                            List<String> fields = new ArrayList<>();
                            fields.add("f_id");
                            fields.add("f_status");
                            Map currObj = mDataBizService.selectFieldByID(tableByTableId.getfTablename(), fields, "f_id", "'" + id +
                                    "'");
                            if (currObj.get("f_status") != null) {
                                if (Integer.parseInt(currObj.get("f_status").toString()) < 10) {//已提交的图斑数据不可以再次变更信息
                                    mDataBizService.updateData(tableByTableId.getfTablename(), map, " f_id = '" + id + "'");
                                    map.put("f_id",id);
                                    datas.add(map);
                                }
                            }
                        }
                    }
                    jsonResult.add(resultObject);
                }
            }
            //判断任务是否存在子图斑
            if(org.apache.commons.lang3.StringUtils.isNotBlank(tableByTableId.getSplitTableName() )){
                handlyChildData(tableByTableId.getSplitTableName(), statement,editkeys,keys, authUserInfo, allowEdit,false,
                        null,bizId,timeMap);
            }
        }
        // 附件信息
        sql = "select * from media";
        rs = statement.executeQuery(sql);
        List<AppMedia> listMedia = new ArrayList<>();
        while(rs.next()){
            AppMedia appMedia = getAppMedia(rs);
            appMedia.setUsername(authUserInfo.getUsername());
            appMedia.setBizId(bizId);
            listMedia.add(appMedia);
        }

        if (task != null) {
            if ("2".equals(task.getType()) && 2 == task.getMode()) {
                JSONArray groups = new JSONArray();
                groups.add(userId);

                taskRecieveService.recieveTask(userId, task.getId(), taskIds, groups);
            }
        }
        if(task.getSource().equals("内网任务")){
            outerTaskTransmitDataService.doWork(datas, bizId, listMedia,userId);
        }
        appMediaRepository.saveAll(listMedia);
        // 关闭连接并删除缓存文件
        connPool.closeAll(connection,statement,rs);
        tempUploadFile.delete();

        return jsonResult;
    }

    //处理子图斑数据
    public void handlyChildData(String tableName,Statement statement,Set<String> editkeys,Set<String> keys,AuthUserInfo user,String allowEdit,Boolean xzjsydmj,List<String>xzjsydmjSql,String taskId,Map<String,Object> timeMap) throws
            SQLException {
        String childtableName = tableName;
        if(childtableName.contains(".")){
            String[] split = childtableName.split("\\.");
            childtableName = split[1];
        }
        if(existTable(statement,childtableName)) {
           String sql1 = "select * from " + childtableName;
            ResultSet resultSet = statement.executeQuery(sql1);
            String id = null;
            while (resultSet.next()) {
                Map<String, Object> map = new HashMap<>();
                String f_id = resultSet.getString("f_id");
                Map mapdata = mDataBizService.selectByID(tableName, "f_id", "'" + f_id + "'");
                if (mapdata == null) {
                    map.put("f_lat", resultSet.getDouble("f_lat"));
                    map.put("f_lon", resultSet.getDouble("f_lon"));
                    for (String key : keys) {
                        if (StringUtils.isNotBlank(resultSet.getString(key))) {
                            map.put(key, resultSet.getString(key));
                            if(timeMap.containsKey(key) ){
                                if(StringUtils.isNotBlank(resultSet.getString(key))){
                                    DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                    try {
                                        Date date = dateFormat.parse(resultSet.getString(key));
                                        Timestamp timestamp = new Timestamp(date.getTime());
                                        map.put(key, timestamp);
                                    } catch (ParseException e) {
                                        e.printStackTrace();
                                        Timestamp ts = new Timestamp(Long.valueOf(resultSet.getString(key)));
                                        map.put(key, ts);
                                    }
                                }else{
                                    map.put(key, null);
                                }
                            }
                        }
                    }
                    String shape="";
                    if (!StringUtils.isBlank(resultSet.getString("f_shape"))) {
                        shape=resultSet.getString("f_shape");
                        map.put("f_shape", "SRID=4490;" + shape);
                    }
                    if (!StringUtils.isBlank(resultSet.getString("f_shape1"))) {
                        map.put("f_shape1", "SRID=4490;" + resultSet.getString("f_shape1"));
                    }
                    if (!StringUtils.isBlank(resultSet.getString("f_shape_b"))) {
                        map.put("f_shape_b", "SRID=4490;" + resultSet.getString("f_shape_b"));
                    }
                    if (!StringUtils.isBlank(resultSet.getString("f_shape_g"))) {
                        map.put("f_shape_g", "SRID=4490;" + resultSet.getString("f_shape_g"));
                    }
                    map.put("f_status", "4");
                    map.put("f_id", resultSet.getString("f_id"));
                    map.put("f_createtime", resultSet.getString("f_createtime"));
                    map.put("f_committime", System.currentTimeMillis());
                    map.put("f_upload_userid", user.getUserRname());
                    map.put("f_userid", user.getUserId().toString());
                    map.put("f_submit_userid", user.getUserId().toString());
                    map.put("f_ismycreate", resultSet.getString("f_ismycreate"));
                    //处理新增的市、县、镇、村
                    if(keys.contains("f_xzqdmcity") && org.apache.commons.lang3.StringUtils.isNotBlank((String)map.get("f_xzqdmsys"))){
                        map.put("f_xzqdmcity", map.get("f_xzqdmsys").toString().substring(0,4)+"00");
                        map.put("f_xzqdmcounty", map.get("f_xzqdmsys").toString().substring(0,6));
                        map.put("f_xzqdmtown", map.get("f_xzqdmsys").toString().substring(0,9));
                    }
                    // app端新增图斑
                    String xzq = resultSet.getString("f_xzqdm");
                    if (StringUtils.isNotBlank(xzq)) {
                        String xzqname = regionService.getNameByCode(xzq);
                        if (xzqname != null) {
                            map.put("f_xzqmc1", xzqname);
                        }
                    }
                    mDataBizService.insertData(tableName, map, "f_shape");

                    if(xzjsydmj&&StringUtils.isNotBlank(shape))
                    {
                        xzjsydmjSql.add(String.format("insert into xzjsydmj(f_id,f_shape,f_split,f_taskid) values('%s','%s','1','%s')",f_id,shape,taskId));
                    }
                } else {
                    id = resultSet.getString("f_id");
                    // 只更新内业可编辑字段、外业
                    for (String key : editkeys) {
                        map.put(key, resultSet.getString(key));
                        if(timeMap.containsKey(key) ){
                            if(StringUtils.isNotBlank(resultSet.getString(key))){
                                DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                try {
                                    Date date = dateFormat.parse(resultSet.getString(key));
                                    Timestamp timestamp = new Timestamp(date.getTime());
                                    map.put(key, timestamp);
                                } catch (ParseException e) {
                                    e.printStackTrace();
                                    Timestamp ts = new Timestamp(Long.valueOf(resultSet.getString(key)));
                                    map.put(key, ts);
                                }
                            }else{
                                map.put(key, null);
                            }
                        }
                    }
                    //
                    if ("1".equals(allowEdit)) {
                        map.put("f_lat", resultSet.getDouble("f_lat"));
                        map.put("f_lon", resultSet.getDouble("f_lon"));
                        map.put("f_lat_b", resultSet.getDouble("f_lat_b"));
                        map.put("f_lon_b", resultSet.getDouble("f_lon_b"));
                        map.put("f_lat_g", resultSet.getDouble("f_lat_g"));
                        map.put("f_lon_g", resultSet.getDouble("f_lon_g"));
                        String shape="";
                        if (!StringUtils.isBlank(resultSet.getString("f_shape"))) {
                            shape=resultSet.getString("f_shape");
                            map.put("f_shape", "SRID=4490;" + shape);
                        }
                        if (!StringUtils.isBlank(resultSet.getString("f_shape1"))) {
                            map.put("f_shape1", "SRID=4490;" + resultSet.getString("f_shape1"));
                        }
                        if (!StringUtils.isBlank(resultSet.getString("f_shape_b"))) {
                            map.put("f_shape_b", "SRID=4490;" + resultSet.getString("f_shape_b"));
                        }
                        if (!StringUtils.isBlank(resultSet.getString("f_shape_g"))) {
                            map.put("f_shape_g", "SRID=4490;" + resultSet.getString("f_shape_g"));
                        }
                        if(xzjsydmj&&StringUtils.isNotBlank(shape))
                        {
                            xzjsydmjSql.add(String.format("insert into xzjsydmj(f_id,f_shape,f_split,f_taskid) values('%s','%s','1','%s')",f_id,shape,taskId));
                        }
                    }
                    map.put("f_status", "4");
                    // 系统字段
                    map.put("f_upload_userid", user.getUserRname());
                    map.put("f_submit_userid", user.getUserId().toString());
                    map.put("f_committime", System.currentTimeMillis());
                    map.put("f_updatetime", System.currentTimeMillis());
                    //处理新增的市、县、镇、村
                    if(keys.contains("f_xzqdmcity") && org.apache.commons.lang3.StringUtils.isNotBlank((String)map.get("f_xzqdmsys"))){
                        map.put("f_xzqdmcity", map.get("f_xzqdmsys").toString().substring(0,4)+"00");
                        map.put("f_xzqdmcounty", map.get("f_xzqdmsys").toString().substring(0,6));
                        map.put("f_xzqdmtown", map.get("f_xzqdmsys").toString().substring(0,9));
                    }
                    if (StringUtils.isNotBlank(id)) {
                        List<String> fields = new ArrayList<>();
                        fields.add("f_id");
                        fields.add("f_status");
                        Map currObj = mDataBizService.selectFieldByID(tableName, fields, "f_id", "'" + id + "'");
                        if (currObj.get("f_status") != null) {
                            if (Integer.parseInt(currObj.get("f_status").toString()) < 10) {//已提交的图斑数据不可以再次变更信息
                                mDataBizService.updateData(tableName, map, " f_id = '" + id + "'");
                            }
                        }
                    }
                }
            }
        }
    }




    private void cffx(Map<String,Object>map,CffxDetailConfig detailConfig,TskTaskBiz task,String splitTableName) throws Exception {
        if(detailConfig!=null)
        {
            CffxDetailInfo detailInfo = mCffxTaskService.cffx(map,detailConfig,task,splitTableName);
            if(detailInfo!=null)
            {
                throw new Exception(detailInfo.getMsg());
            }
        }
    }

    private void valid(String f_id,String pkFieldValue,Map map,boolean validGeoTopo,boolean disableMultiPolygon) throws Exception {
        WKTReader wktReader = new WKTReader();
        String shape = map.get("f_shape")==null?null:map.get("f_shape").toString();

        if(StringUtils.isNotBlank(pkFieldValue))
        {
            f_id = pkFieldValue;
        }
        if(shape.toLowerCase().startsWith("srid=4490;"))
        {
            shape = org.apache.commons.lang3.StringUtils.split(shape,";")[1];
        }
        Geometry geo = wktReader.read(shape);
        if(validGeoTopo) {
            if (!geo.isValid()) {
                throw new Exception("图斑:" + f_id + "存在图形拓扑错误");
            }
        }
        if(disableMultiPolygon)
        {
            boolean isMultiLine=false;
            boolean isMultiPolygon=false;
            boolean dataType=false;
            if (geo.getGeometryType().equals("Point")) {
                dataType = true;
            }
            if (geo.getGeometryType().equals("LineString") ) {
                dataType = true;
            }
            else if (geo.getGeometryType().equals("MultiLineString")) {
                dataType = true;
                isMultiLine=true;
            }
            if (geo.getGeometryType().equals("Polygon")) {
                dataType = true;
            }
            else if (geo.getGeometryType().equals("MultiPolygon")) {
                dataType = true;
                isMultiPolygon=true;
            }
            if(!dataType)
            {
                throw new Exception("图斑:" + f_id + "数据类型错误");
            }
            if(isMultiLine)
            {
                MultiLineString multiLineString = (MultiLineString)geo;
                if(multiLineString.getNumGeometries()>1)
                {
                    throw new Exception("图斑:" + f_id + "数据类型错误,不支持多部件");

                }
            }
            else if(isMultiPolygon)
            {
                MultiPolygon multiPolygon = (MultiPolygon)geo;
                if(multiPolygon.getNumGeometries()>1)
                {
                    throw new Exception("图斑:" + f_id + "数据类型错误,不支持多部件");
                }
            }
        }
    }


    private Boolean existTable(Statement statement,String tableName){
        try{
            // 执行查询
            String sql = "SELECT name FROM sqlite_master WHERE type='table' AND name='" + tableName + "'";
            ResultSet rs = statement.executeQuery(sql);

            // 检查结果集是否为空
            if (rs.next()) {
                return true;
            } else {
                return false;
            }
        }
        catch (Exception ex){
            System.out.println(ex.getMessage());
            return false;
        }
    }























    private AppMedia getAppMedia(ResultSet rs) throws SQLException {
        DecimalFormat format = new DecimalFormat("######0.00");
        AppMedia appMedia = new AppMedia();
        appMedia.setId(rs.getString("f_id"));
        appMedia.setGalleryid(rs.getString("f_galleryid"));
        appMedia.setType(rs.getObject("f_type") == null ? null : Integer.parseInt(rs.getString("f_type")));
        String time = rs.getString("f_time");
        if (StringUtils.isNotBlank(time)) {
            Long timeLong = null;
            try {
                timeLong = Long.valueOf(time);
            } catch (NumberFormatException e) {
                try {
                    Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(time);
                    timeLong = date.getTime();
                } catch (ParseException parseException) {

                }
            }
            if (timeLong != null) {
                appMedia.setTime(String.valueOf(timeLong));
            }
        }
        appMedia.setLon(rs.getObject("f_lon") == null ? null : Double.parseDouble(rs.getString("f_lon")));
        appMedia.setLat(rs.getObject("f_lat") == null ? null : Double.parseDouble(rs.getString("f_lat")));

        String azimuth = rs.getString("f_azimuth");
        appMedia.setAzimuth(StringUtils.isNotBlank(azimuth) ? format.format(Double.parseDouble(azimuth)) : null);
        appMedia.setPitch(rs.getString("f_pitch"));
        appMedia.setShape(rs.getString("f_shape"));
        if(org.apache.commons.lang3.StringUtils.isNotBlank(appMedia.getShape())){
           // 根据shape字段查询面积
            Geometry geo = null;
            try {
                geo = WKTUtil.wktToGeom(appMedia.getShape());
                Geometry pt = geo.getCentroid();
                int proNum = getColNum(((Point) pt).getX());
                String areasql = "select st_area(ST_Transform(ST_GeomFromText('" + WKTUtil.geomToWkt(geo) + "',4490)," + proNum + "))/666.6666667 as area";
                Map<String, Object> areaMap = jdbcTemplate.queryForMap(areasql);
                String area = areaMap.get("area").toString();
                DecimalFormat df = new DecimalFormat("#.00");
                appMedia.setArea(Double.parseDouble(df.format(area)));
            } catch (org.locationtech.jts.io.ParseException e) {
                e.printStackTrace();
            }
        }
        appMedia.setVideorecord(rs.getString("f_videorecord"));
        appMedia.setServerpath(rs.getString("f_serverpath"));
        appMedia.setMediatimelength(rs.getObject("f_mediatimelength") == null ? null : Integer.parseInt(rs.getString("f_mediatimelength")));
        appMedia.setMediasize(rs.getObject("f_mediasize") == null ? null : Double.parseDouble(rs.getString("f_mediasize")));
        //appMedia.setFileId(rs.getString("f_fileid"));
        //appMedia.setDownloadUrl(rs.getString("f_downloadurl"));
        appMedia.setMark(rs.getObject("f_mark") == null ? null : Integer.parseInt(rs.getString("f_mark")));
        appMedia.setTypetype(rs.getObject("f_typetype") == null ? null : Integer.parseInt(rs.getString("f_typetype")));
        appMedia.setDeviceSource(0);

        if(checkColumn(rs,"f_jym")){
            appMedia.setJym(rs.getObject("f_jym") == null ? null : rs.getString("f_jym"));
        }
        if(checkColumn(rs,"f_sm3")){
            appMedia.setSm3(rs.getObject("f_sm3") == null ? null : rs.getString("f_sm3"));
        }
        if(checkColumn(rs,"f_roll")){
            appMedia.setRoll(rs.getObject("f_roll") == null ? null : rs.getInt("f_roll"));
        }
        if(checkColumn(rs,"f_dimheight")){
            appMedia.setDimHeight(rs.getObject("f_dimheight") == null ? null : rs.getInt("f_dimheight"));
        }
        if(checkColumn(rs,"f_dimwidth")){
            appMedia.setDimWidth(rs.getObject("f_dimwidth") == null ? null : rs.getInt("f_dimwidth"));
        }
        if(checkColumn(rs,"f_35mmfocal")){
            appMedia.setF35mmfocal(rs.getObject("f_35mmfocal") == null ? null : rs.getInt("f_35mmfocal"));
        }
        if(checkColumn(rs,"f_psfyj")){
            appMedia.setPsfyj(rs.getObject("f_psfyj") == null ? null : rs.getString("f_psfyj"));
        }
        if(checkColumn(rs,"f_zsdm")){
            appMedia.setZsdm(rs.getObject("f_zsdm") == null ? null : rs.getString("f_zsdm"));
        }
        if(checkColumn(rs,"f_am")){
            appMedia.setAm(rs.getObject("f_am") == null ? null :Double.parseDouble(rs.getString("f_am")));
        }
        if(checkColumn(rs,"f_an")){
            appMedia.setAn(rs.getObject("f_an") == null ? null : Double.parseDouble(rs.getString("f_an")));
        }
        if(checkColumn(rs,"f_jdgd")){
            appMedia.setJdgd(rs.getObject("f_jdgd") == null ? null : Double.parseDouble(rs.getString("f_jdgd")));
        }
        if(checkColumn(rs,"f_focal")){
            appMedia.setFocal(rs.getObject("f_focal") == null ? null : Double.parseDouble(rs.getString("f_focal")));
        }
        if(checkColumn(rs,"f_psgd")){
            appMedia.setPsgd(rs.getObject("f_psgd") == null ? null : Double.parseDouble(rs.getString("f_psgd")));
        }
        if(checkColumn(rs,"f_jym")){
            if(!verifyJym(rs)){
                throw new GwValidateException("附件校验码验证不通过");
            }
        }
        return appMedia;
    }



    private boolean checkColumn(ResultSet rs, String column)
    {
        try
        {
            rs.findColumn(column);
            return true;
        } catch (SQLException sqlex){
            sqlex.printStackTrace();
        }
        return false;
    }

    private int getColNum(Double xLine) {
        int proNum = 2362;
        if (xLine >= 75.5 && xLine < 78.5) {
            proNum = 2353;
        } else if (xLine >= 78.5 && xLine < 81.5) {
            proNum = 2354;
        } else if (xLine >= 81.5 && xLine < 84.5) {
            proNum = 2355;
        } else if (xLine >= 84.5 && xLine < 87.5) {
            proNum = 2356;
        } else if (xLine >= 87.5 && xLine < 90.5) {
            proNum = 2357;
        } else if (xLine >= 90.5 && xLine < 93.5) {
            proNum = 2358;
        } else if (xLine >= 93.5 && xLine < 96.5) {
            proNum = 2359;
        } else if (xLine >= 96.5 && xLine < 99.5) {
            proNum = 2360;
        } else if (xLine >= 99.5 && xLine < 112.5) {
            proNum = 2361;
        } else if (xLine >= 112.5 && xLine < 115.5) {
            proNum = 2362;
        } else if (xLine > 115.5 && xLine < 118.5) {
            proNum = 2363;
        } else if (xLine > 118.5 && xLine < 121.5) {
            proNum = 2364;
        } else if (xLine > 121.5 && xLine < 124.5) {
            proNum = 2365;
        } else if (xLine > 124.5 && xLine < 127.5) {
            proNum = 2366;
        } else if (xLine > 127.5 && xLine < 130.5) {
            proNum = 2367;
        } else if (xLine > 130.5 && xLine < 133.5) {
            proNum = 2368;
        } else if (xLine > 133.5 && xLine < 136.5) {
            proNum = 2369;
        }
        return proNum;
    }

    private File buildTempUploadFile(String userid){
        uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("task-%s-%s-%s.db", userid,sdf.format(new Date()), UUID.randomUUID().toString());
        return new File(uploadDir, fileName);
    }

    /*
     * 将时间戳转换为时间
     */
    private Date stampToDate(String s){
        long lt = new Long(s);
        Date date = new Date(lt);
        return date;
    }

    public Boolean saveZjdTsk(JSONObject zjdTsk, Long userId, String bizId, String tbId){

        TskTaskBiz tskTaskBiz = mTskTaskBizService.findByTaskId(bizId);
        TbtskObjectinfo tableInfo = mTbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        List<TbtskFields> fieldsList = mTskTaskBizService.getFieldsByTableId(tableInfo.getfId());
        List<String> editkeys = new ArrayList<>();
        for (TbtskFields f : fieldsList) {
            Boolean innserWebEdit = new Integer(1).equals(f.getfIsWebEdit()) && f.getfFieldInnerOuterSys().intValue() == FieldGroupTypeConstant.INNER_FIELD;
            Boolean isOuter = (f.getfFieldInnerOuterSys().intValue() & FieldGroupTypeConstant.OUTER_FIELD) == FieldGroupTypeConstant.OUTER_FIELD;
            if(innserWebEdit || isOuter){
                editkeys.add(f.getfFieldname());
            }
        }

        Map<String,Object> map = new HashMap<>();
        for (String key : editkeys) {
            if (zjdTsk.containsKey(key)) {
                if("f_sfzhm".equals(key) && zjdTsk.getString(key).contains("*")){
                    continue;
                }
                if("f_qlrsjh".equals(key) && zjdTsk.getString(key).contains("*")){
                    continue;
                }
                map.put(key, zjdTsk.getString(key));
            }
        }
        if("zjd".equals(tableInfo.getfRemark()) && map.containsKey("f_zdlx")){
            List<String> fields = new ArrayList<>();
            fields.add("f_zdlx");
            fields.add("f_id");
            fields.add("f_xzqdm");
            fields.add("f_dzwdwdm");
            List<Map> maps = mDataBizService.queryAllData(tableInfo.getfTablename(), fields, " f_id = '" + tbId + "'");
            if(!maps.isEmpty()){
                Map data = maps.get(0);
                String oldZdlx = (String)data.get("f_zdlx");
                String nexZdlx = (String)map.get("f_zdlx");
                String xzqdm = (String)data.get("f_xzqdm");
                String f_dzwdwdm = (String)data.get("f_dzwdwdm");

                if(!oldZdlx.equals(nexZdlx)){
                    String tbbh = "";
                    try {
                        tbbh = mTskTaskBizService.generatorSeqByXzqdm(bizId, nexZdlx, xzqdm, tableInfo.getfId(), tableInfo);
                        map.put("f_tbbh", tbbh);
                        // 宗地代码+定着物
                        map.put("f_bdcdydm", tbbh + f_dzwdwdm);
                        map.put("f_zdsxh", tbbh.substring(14));
                    } catch (Exception e) {
                        throw new RuntimeException("生成宗地代码发生错误");
                    }
                }
            }
        }
        if (!map.isEmpty() && StringUtils.isNotBlank(tbId)) {
            mDataBizService.updateData(tableInfo.getfTablename(), map, " f_id = '" + tbId + "'");
        }
        return true;
    }



   public JSONObject  checkSplitData( Long userId,String bizId,String tbId,String childTbIds){
       JSONObject jsonObject = new JSONObject();
       jsonObject.put("isChange",false);
       TskTaskBiz task = mTskTaskBizService.findByTaskId(bizId);
       TbtskObjectinfo objectinfo = mTskTaskBizService.getTableByTableId(task.getTableId());
       List<TbtskFields> fieldsList = mTskTaskBizService.getFieldsByTableId(task.getTableId());
       List<String> fields = new ArrayList<>();
       for (TbtskFields f : fieldsList) {
           fields.add(f.getfFieldname());
       }
       Map currObj = mDataBizService.selectFieldByID(objectinfo.getfTablename(), fields, "f_id", "'" + tbId + "'");
       if (null == currObj) {
           throw new RuntimeException("图斑不存在");
       }
       jsonObject.put("parentData",currObj);
       if(org.apache.commons.lang3.StringUtils.isNotBlank(objectinfo.getSplitTableName())){
           List<Map> childMap = mDataBizService.queryAllData( objectinfo.getSplitTableName(), fields, "f_splitedid = '" + tbId + "' ORDER BY to_number(COALESCE(NULLIF(split_part(f_tbbh,'_',2),''),'0'),'00')");
           jsonObject.put("childData",childMap);
          if(childMap.size() > 0){
              if(org.apache.commons.lang3.StringUtils.isNotBlank(childTbIds)){
                  String[] split = childTbIds.split(",");
                  if(split.length == childMap.size()){
                      for(Map map1 : childMap){
                          String f_id = org.apache.commons.collections.MapUtils.getString(map1, "f_id", "");
                          if(!childTbIds.contains(f_id)){
                              jsonObject.put("isChange",true);
                          }
                      }
                  }else{
                      jsonObject.put("isChange",true);
                  }
              }else{
                  jsonObject.put("isChange",true);
              }
          }else{
              if(org.apache.commons.lang3.StringUtils.isNotBlank(childTbIds)){
                  jsonObject.put("isChange",true);
              }
          }
       }
       return jsonObject;
    }


   /* @Transactional(rollbackFor = Exception.class)*/
    public JSONArray uploadShy(MultipartFile[] files, Long userId, String bizId) throws Exception {
        JSONArray jsonResult = new JSONArray();

        if (files.length < 1) {
            return jsonResult;
        }
        MultipartFile fileOfDB = files[0];

        File tempUploadFile = buildTempUploadFile(userId.toString());
        FileUtils.copyInputStreamToFile(fileOfDB.getInputStream(), tempUploadFile);
        LandUserDetail user = userDetailRepository.findById(userId).orElse(null);

        // 获取DB文件数据库连接
        SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
        ResultSet rs = null;

        String sql = "";
        // 支持同时上传多张表
        sql = "select * from table_info";
        rs = statement.executeQuery(sql);

        List<String> tableNames=new ArrayList<>();
        while (rs.next()) {
            String tableName = rs.getString("f_tablename");
            tableNames.add(tableName);
        }

        //查询参数
        sql="select f_shifields as shiwy,f_shengfields as shengwy from tb_shi_audit where f_taskid='"+bizId+"'";
        List<Map<String,Object>> shfields=jdbcTemplate.queryForList(sql);

        List<String> cjFields=new ArrayList<>();
        if(shfields.size()>0){
            if(shfields.get(0).get("shiwy")!=null){
                String lsField=shfields.get(0).get("shiwy").toString();
                List<String> fds1=Arrays.asList(lsField.split(","));
                cjFields.addAll(fds1);
            }

            if(shfields.get(0).get("shengwy")!=null){
                String lsField=shfields.get(0).get("shengwy").toString();
                List<String> fds1=Arrays.asList(lsField.split(","));
                cjFields.addAll(fds1);
            }
        }


        for(int i=0;i<tableNames.size();i++){
            String tableName=tableNames.get(i);

            if (org.apache.commons.lang3.StringUtils.isNotBlank(tableName)) {
                sql = "select * from " + tableName;
                ResultSet resultSet = statement.executeQuery(sql);

                while (resultSet.next()) {
                    Map<String, Object> map = new HashMap<>();
                    String id = resultSet.getString("f_id");
                    Map currObj = mDataBizService.selectFieldByID(tableName, Arrays.asList("f_id,f_status,f_review_stage"), "f_id","'" + id + "'");
                    // 只更新内业可编辑字段、外业
                    Integer index=0;
                    for (String key : cjFields) {
                        // 现在调整为，不管数据是否为空，只要提交了这个数据，就更新
                        if(isExistColumn(resultSet,key)){
                            map.put(key, resultSet.getString(key));
                            index++;
                        }
                    }
                    if(index>0){
                        mDataBizService.updateData(tableName, map, " f_id = '" + id + "'");
                    }
                    //增加提交记录
                    if(currObj != null){
                        Integer f_status = Integer.valueOf(currObj.get("f_status").toString());
                        Integer f_review_stage = currObj.get("f_review_stage")!=null?Integer.valueOf(currObj.get("f_review_stage").toString()):null;
                        TbtskSubmitRecord tbtskSubmitRecord = new TbtskSubmitRecord();
                        tbtskSubmitRecord.setDataid(id);
                        tbtskSubmitRecord.setDataStatus(f_status);
                        tbtskSubmitRecord.setDataReviewStage(f_review_stage);
                        tbtskSubmitRecord.setTaskid(bizId);
                        tbtskSubmitRecord.setSubmitUserid(userId);
                        tbtskSubmitRecord.setSubmitTime(new Date());
                        if(f_status >= 10 && f_review_stage !=null && f_review_stage >= 90 && f_review_stage < 95){
                            tbtskSubmitRecord.setStepName("区县审核");
                        }else if(f_status >= 10 && f_review_stage !=null && f_review_stage >= 95 && f_review_stage <97){
                            tbtskSubmitRecord.setStepName("市级审核");
                        }else if(f_status >= 10 && f_review_stage !=null && f_review_stage >= 97 && f_review_stage<101){
                            tbtskSubmitRecord.setStepName("省级审核");
                        }else{
                            tbtskSubmitRecord.setStepName(null);
                        }
                        tbtskSubmitReportRepository.save(tbtskSubmitRecord);
                    }
                }
            }
        }
        // 附件信息
        sql = "select * from media";
        rs = statement.executeQuery(sql);
        List<AppMedia> listMedia = new ArrayList<>();
        while(rs.next()){
            AppMedia appMedia = getAppMedia(rs);
            appMedia.setUsername(user.getName());
            listMedia.add(appMedia);
        }
        appMediaRepository.saveAll(listMedia);

        // 关闭连接并删除缓存文件
        connPool.closeAll(connection,statement,rs);
        tempUploadFile.delete();
        return jsonResult;
    }

    public JSONObject checkDatRetake(String bizId,String tbId){
        JSONObject jsonObject = new JSONObject();
        List<TbtskSubmitRecord> tbtskSubmitRecords = tbtskSubmitReportRepository.queryByTaskidAndDataid(bizId, tbId);
        jsonObject.put("tbtskSubmitRecords",tbtskSubmitRecords);
        jsonObject.put("countyRetake",false);
        jsonObject.put("cityRetake",false);
        jsonObject.put("provinceRetake",false);
        jsonObject.put("currentStatusRetake",false);
        if(tbtskSubmitRecords.size() > 0){
            TskTaskBiz tskTaskBiz = mTskTaskBizService.findByTaskId(bizId);
            TbtskObjectinfo tableInfo = mTbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
            //获取当前数据
            Map currObj = mDataBizService.selectFieldByID(tableInfo.getfTablename(), Arrays.asList("f_id,f_status," +
                    "f_review_stage"), "f_id","'" +tbId + "'");
            for(TbtskSubmitRecord  tbtskSubmitRecord:tbtskSubmitRecords){
                if("区县审核".equals(tbtskSubmitRecord.getStepName())){
                    jsonObject.put("countyRetake",true);
                }else if("市级审核".equals(tbtskSubmitRecord.getStepName())){
                    jsonObject.put("cityRetake",true);
                }else if("省级审核".equals(tbtskSubmitRecord.getStepName())){
                    jsonObject.put("provinceRetake",true);
                }
                if(currObj != null){
                    Integer f_status = Integer.valueOf(currObj.get("f_status").toString());
                    Integer f_review_stage = currObj.get("f_review_stage")!=null?Integer.valueOf(currObj.get("f_review_stage").toString()):null;
                    if(f_review_stage!=null && tbtskSubmitRecord.getDataStatus() == f_status && tbtskSubmitRecord.getDataReviewStage() == f_review_stage){
                        jsonObject.put("currentStatusRetake",true);
                    }
                }
            }
        }
        return jsonObject;
    }


    /**
     * 判断查询结果集中是否存在某列
     * @param rs 查询结果集
     * @param columnName 列名
     * @return true 存在; false 不存咋
     */
    private boolean isExistColumn(ResultSet rs, String columnName) {
        try {
            if (rs.findColumn(columnName) > 0 ) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }

}
