package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.NoticeRepository;
import com.geoway.landteam.customtask.repository.task.TaskNoticeRepository;
import com.geoway.landteam.customtask.repository.task.TaskNoticeUserRepository;
import com.geoway.landteam.customtask.repository.task.TskRightAreaRepository;
import com.geoway.landteam.customtask.task.entity.Notice;
import com.geoway.landteam.customtask.task.entity.TaskNotice;
import com.geoway.landteam.customtask.task.entity.TaskNoticeUser;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.pub.dto.NoticeDTO;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.gw.base.util.GutilStr;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class MNoticeService {

    @Autowired
    TaskNoticeUserRepository taskNoticeUserDao;

    @Autowired
    NoticeRepository noticeRepository;

    @Autowired
    TaskNoticeRepository taskNoticeRepository;

    @Autowired
    TskRightAreaRepository tskRightAreaRepository;

    @Autowired
    RedisTemplate redisTemplate;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    DefaultOssOperatorService ossOperatorService;

    public Page<Notice> queryByFilter(String filterParam, String sortParam, int start, int limit) {
        Page<Notice> results = noticeRepository.findAll(new QuerySpecification<Notice>(filterParam),
                PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));
        return results;
    }

    public void saveNotice(String id, int target, String content, String title, int act, Long userId) {
        Notice notice = new Notice();
        if (!GutilStr.isBlank(id)) {
            notice = noticeRepository.findById(id).orElse(null);
        } else {
            notice.setCreateDate(new Date());
            notice.setType(1);
        }
        notice.setTitle(title);
        notice.setContent(content);
        notice.setTargetType(target);
        notice.setSendUserId(userId);
        if (act == 1) {
            notice.setState(1);
        } else if (act == 2) {
            notice.setState(2);
            notice.setSendDate(new Date());
        }
        noticeRepository.save(notice);
    }


    public void processReplyNotice(String userid, String replyIds) {
        String[] arrs = replyIds.split(",");

        for (int i = 0; i < arrs.length; i++) {
            String replyId = arrs[i];
            List<TaskNoticeUser> noticeList = taskNoticeUserDao.queryNotice(userid, replyId);
            if (noticeList != null && noticeList.size() > 0) {
                TaskNoticeUser taskNoticeUser = noticeList.get(0);
                taskNoticeUser.setState(1);
                taskNoticeUserDao.save(taskNoticeUser);
            } else {
                // 系统消息，系统消息已读消息存储在redis中
                Boolean sysmsg = redisTemplate.opsForSet().isMember(replyId, userid);
                if (sysmsg) {
                    // 存在replyId的key
                    Set members = redisTemplate.opsForSet().members(replyId);
                    redisTemplate.opsForSet().add(replyId, userid);
                } else {
                    redisTemplate.opsForSet().add(replyId, userid);
                }
            }
        }
    }

    public List<NoticeDTO> queryPendingTaskNotice(Long userId) {
        List<NoticeDTO> listNotice = new ArrayList<NoticeDTO>();

        String filterParam = "Q_userId_S_EQ=" + userId;
        filterParam += ";(Q_state_N_EQ=0;QOR_state_N_EQ=null)";
        String sortParam = "";//"SORT_sendTime_DESC";

        List<TaskNoticeUser> noticeUsers = queryTaskNoticeUserByFilter(filterParam, sortParam, 0, 100).getContent();

        for (TaskNoticeUser noticeUser : noticeUsers) {
            TaskNotice one = taskNoticeRepository.findById(noticeUser.getNoticeId()).orElse(null);
            if (one == null) {
                continue;
            }
            NoticeDTO noticeDTO = new NoticeDTO();
            noticeDTO.setId(one.getId());
            noticeDTO.setAction(one.getAction());
            noticeDTO.setContent(one.getContent());
            noticeDTO.setData(one.getData());
            noticeDTO.setRegion(one.getRegion());
            noticeDTO.setSendTime(one.getSendTime());
            noticeDTO.setState(one.getState());
            noticeDTO.setTitle(one.getTitle());
            noticeDTO.setType(one.getType());
            noticeDTO.setSendUser(one.getSendUser());
            noticeDTO.setBizId(one.getBizId());

            String data = noticeUser.getData();

            if (GutilStr.isNotBlank(data)) {
                try {
                    JSONObject object = JSONObject.parseObject(data);
                    String oriType = object.getString("oriType");
                    String oriId = object.getString("oriId");
                    noticeDTO.setOriType(oriType);
                    noticeDTO.setOriId(oriId);
                    noticeDTO.setUserData(data);
                } catch (Exception ex) {
                    // 非json格式，忽略
                }
            }

            listNotice.add(noticeDTO);
        }

        return listNotice;
    }

    public Page<TaskNoticeUser> queryTaskNoticeUserByFilter(String filterParam, String sortParam, int start, int limit) {
        Page<TaskNoticeUser> results = taskNoticeUserDao.findAll(
                new QuerySpecification<TaskNoticeUser>(filterParam),
                 PageRequest.of(start, limit, QueryParamUtil
                        .parseSortParams(sortParam)));

        return results;
    }

    public Map queryPendingTaskNoticeResult(String filterParam, String sortParam, int start, int limit) {
        List<NoticeDTO> listNotice = new ArrayList<NoticeDTO>();

        Page<TaskNoticeUser> result = queryTaskNoticeUserByFilter(filterParam, sortParam, start, limit);

        long total = result.getTotalElements();
        List<TaskNoticeUser> noticeUsers = result.getContent();
        for (TaskNoticeUser noticeUser : noticeUsers) {
            TaskNotice one = taskNoticeRepository.findById(noticeUser.getNoticeId()).orElse(null);
            if (one == null) {
                continue;
            }
            NoticeDTO noticeDTO = new NoticeDTO();
            noticeDTO.setId(one.getId());
            noticeDTO.setAction(one.getAction());
            noticeDTO.setContent(one.getContent());
            noticeDTO.setData(one.getData());
            noticeDTO.setRegion(one.getRegion());
            noticeDTO.setSendTime(one.getSendTime());
            noticeDTO.setState(one.getState());
            noticeDTO.setTitle(one.getTitle());
            noticeDTO.setType(one.getType());
            noticeDTO.setSendUser(one.getSendUser());
            noticeDTO.setBizId(one.getBizId());

            String data = noticeUser.getData();

            if (GutilStr.isNotBlank(data)) {
                try {
                    JSONObject object = JSONObject.parseObject(data);
                    String oriType = object.getString("oriType");
                    String oriId = object.getString("oriId");
                    noticeDTO.setOriType(oriType);
                    noticeDTO.setOriId(oriId);
                    noticeDTO.setUserData(data);
                } catch (Exception ex) {
                    // 非json格式，忽略
                }
            }

            listNotice.add(noticeDTO);
        }
        Map map = new HashMap();
        map.put("total", total);
        map.put("list", listNotice);
        return map;
    }

    public List<NoticeDTO> findTaskNoticesBySendTimeAndBizId(String userId, String bizId, Date time) {
        List<TaskNotice> list = taskNoticeRepository.queryBySendTimeAndBizId(userId, bizId, time);
        List<String> xzqdms = tskRightAreaRepository.findXzqdmByTaskIdAndUserId(bizId, userId);
        if (xzqdms != null && xzqdms.size() > 0) {
            /*List<TaskNotice> list2 = taskNoticeRepository.queryBySendTimeAndBizIdAndXzqdms(
                    StringUtils.join(xzqdms, ","), bizId, time);*/
            List<TaskNotice> list2 = taskNoticeRepository.queryBySendTimeAndBizIdAndXzqdms2(xzqdms, bizId, time);
            list.addAll(list2);
        }

        // 再加上更新时间之后tb_tasknotice_user中的数据
//        List<String> noticeIDList = taskNoticeUserDao.queryTaskNoticeID(userId, time, 1);
        List<TaskNotice> taskNotices = taskNoticeRepository.queryTaskNoticeByUserIdAndBiz2(userId, time, 1, bizId);
//        for (TaskNotice notice : taskNotices) {
//            if (notice.getBizId().equals(bizId))
//                list.add(notice);
//        }
        list.addAll(taskNotices);

        // 对消息按时间进行排序
        Collections.sort(list, new Comparator<TaskNotice>() {
            @Override
            public int compare(TaskNotice arg0, TaskNotice arg1) {
                return arg0.getSendTime().compareTo(arg1.getSendTime());
            }
        });

        List<NoticeDTO> rlist = new ArrayList<>();
        Set<String> set = new HashSet<>();
        Set<String> obsPath = new HashSet<>();

        int i = 0;
        for (TaskNotice notice : list) {
            if (set.contains(notice.getId())) {
                continue;
            } else {
                set.add(notice.getId());
            }
            if (obsPath.contains(notice.getData())) {
                continue;
            } else {
                obsPath.add(notice.getData());
            }
            if (notice.getSendTime().equals(time)) {
                continue;
            }
            rlist.add(getNoticeDTO(notice, userId));
            if (i++ == 0
                    //&& ("14").equals(notice.getAction())
                    && ("15").equals(notice.getAction())) {
                break;
            }
        }

        return rlist;
    }

    public NoticeDTO findLastedTaskNotice(String userId) {
        List<TaskNotice> list = taskNoticeRepository.queryLastedTaskNoticeByUserId(userId);
        if (list != null && list.size() > 0) {
            return getNoticeDTO(list.get(0), userId);
        }
        return null;
    }

    private NoticeDTO getNoticeDTO(TaskNotice one, String userId) {
        NoticeDTO noticeDTO = new NoticeDTO();
        noticeDTO.setId(one.getId());
        noticeDTO.setAction(one.getAction());
        noticeDTO.setContent(one.getContent());
        noticeDTO.setData(one.getData());
        noticeDTO.setRegion(one.getRegion());
        noticeDTO.setSendTime(one.getSendTime());
        noticeDTO.setState(one.getState());
        noticeDTO.setTitle(one.getTitle());
        noticeDTO.setType(one.getType());
        noticeDTO.setSendUser(one.getSendUser());
        noticeDTO.setBizId(one.getBizId());
        noticeDTO.setAddition(one.getAddition());
        List<TaskNoticeUser> list = taskNoticeUserDao.queryNotice(userId, one.getId());
        if (list != null && list.size() > 0) {
            String data = list.get(0).getData();

            if (GutilStr.isNotBlank(data)) {
                try {
                    JSONObject object = JSONObject.parseObject(data);
                    String oriType = object.getString("oriType");
                    String oriId = object.getString("oriId");
                    noticeDTO.setOriType(oriType);
                    noticeDTO.setOriId(oriId);
                    noticeDTO.setUserData(data);
                } catch (Exception ex) {
                    // 非json格式，忽略
                }
            }
        }
        return noticeDTO;
    }

    public Map<String,Object> getHomeSysMessage(String text,Date startTime,Date endTime,String sort,int page,int rows){
        Map map=new HashMap();
        StringBuffer countsql=new StringBuffer("select count(1) from tb_notice n where 1=1");
        StringBuffer sql=new StringBuffer("select n.f_id,n.f_title,n.f_content,n.f_createdate from tb_notice n where 1=1 ");
        if(text!=null && !text.equals("")){
            sql.append(" and n.f_content like '%"+text+"%' ");
            countsql.append(" and n.f_content like '%"+text+"%' ");
        }
        List<Notice> notices=new ArrayList<>();
        if(startTime!=null && endTime!=null){
            Calendar endtime=Calendar.getInstance();
            endtime.setTime(endTime);
            endtime.set(Calendar.HOUR,23);
            endtime.set(Calendar.MINUTE,59);
            endtime.set(Calendar.SECOND,59);
            sql.append(" and n.f_createdate between '"+startTime +"' and '"+ endtime.getTime()+"' ");
            countsql.append(" and n.f_createdate between '"+startTime +"' and '"+ endtime.getTime()+"' ");
        }
        sql.append(" and f_noticetype=1 ");
        countsql.append(" and f_noticetype=1");
        if("DESC".equals(sort)){
            sql.append(" order by n.f_createdate desc ");
        }else if("ASC".equals(sort)){
            sql.append(" order by n.f_createdate asc ");
        }
        int current=(page-1)*rows;
        sql.append(" limit "+rows +" offset "+ current );
        List<Map<String, Object>> noticeMap = jdbcTemplate.queryForList(sql.toString());
        for (Map<String, Object> temp : noticeMap) {
            Notice notice=new Notice();
            notice.setId(temp.get("f_id").toString());
            notice.setCreateDate((Date) temp.get("f_createdate"));
            notice.setContent(temp.get("f_content").toString());
            notice.setTitle(temp.get("f_title").toString());
            notices.add(notice);
        }
        Integer count=jdbcTemplate.queryForObject(countsql.toString(),Integer.class);
        map.put("notices",notices);
        map.put("count",count);
        return map;
    }

    /*public void createNotice(HttpServletRequest request, Long userId) throws IOException {
        MultipartFile multipartFile = null;
        boolean isMultipart = ServletFileUpload.isMultipartContent(request);
        if (isMultipart){
            MultipartHttpServletRequest multipartRequest = WebUtils.getNativeRequest(request, MultipartHttpServletRequest.class);
            Map<String, MultipartFile> map=multipartRequest.getFileMap();
            Set<String> strings = map.keySet();
            for (String string : strings) {
                MultipartFile m=map.get(string);
                if(!m.isEmpty()) {
                    String name = m.getOriginalFilename();
                    String suffix = name.substring(name.lastIndexOf("."));
                    String path = String.format("headImg/%d/%d%s", userId, System.currentTimeMillis(), suffix);
                    //返回的地址不能显示
                    ossOperatorService.sendObject2Oss(path, m.getInputStream());
                }
            }
        }
    }*/
}
