package com.geoway.landteam.landcloud.service.customtask.task;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.*;
import java.util.stream.Collectors;

import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;

 import cn.hutool.core.exceptions.ExceptionUtil;
import com.gw.base.data.GwValidateException;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeUserNew;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskAssignRecordRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.repository.task.UserBiz2Repository;
import com.geoway.landteam.customtask.service.util.LogUtils;
import com.geoway.landteam.customtask.service.util.TaskDBUtils;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskAssignRecord;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.task.entity.UserBiz2;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.constants.BizIdConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.base.RegionTownRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.WorkGroupMemberRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.user.impl.UserManageServiceImpl;
import com.geoway.landteam.landcloud.core.service.util.message.MixPushServer;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;

@Service
/*@Transactional(rollbackFor = Exception.class)*/
public class MTaskAssignJobService {

    private final GiLoger logger = GwLoger.getLoger(MTaskAssignJobService.class);
    @Autowired
    WorkGroupMemberRepository workGroupMemberRepository;

    @Autowired
    TskTaskBizService MTskTaskBizService;

    @Autowired
    MTaskNoticeService mTaskNoticeService;

    @Autowired
    DefaultOssOperatorService ossOperatorService;

    @Autowired
    UserBiz2Repository userBiz2Repository;

    @Autowired
    MDataBizService mDataBizService;

    @Autowired
    RedisTemplate redisTemplate;

    String uploadDir;

    @Autowired
    MTaskRecordService mTaskRecordService;


    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;


    @Autowired
    MTbtskFlowService mTbtskFlowService;


    @Autowired
    TskTaskBizRepository tskTaskBizRepository;

    @Autowired
    LandUser2AreaRepository userAreaDao;
    @Autowired
    RegionTownRepository regionTownRepository;
    @Autowired
    RegionVillageRepository regionVillageRepository;
    @Autowired
    MTaskNoticeNewService mTaskNoticeNewService;
   /* @Autowired
    private DefaultOssOperatorService defaultOssOperatorService;*/

    @Autowired
    UserManageServiceImpl userManageService;

    @Autowired
    SysConfigService sysConfigService;

    @Autowired
    TskAssignRecordRepository tskAssignRecordRepository;

    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;

    /*    @Transactional(rollbackFor = Exception.class)*/
    public void AssignData(TaskDataDbParameter parameter) throws Exception {
        String recordId = parameter.getRecordId();
        TaskRecord one = mTaskRecordService.findOne(recordId);

        //获取四川举报线索任务Id
        SysConfig sysConfig = sysConfigService.findOne(BizIdConstants.SCGTY_BIZ_ID);
        // 1.更新图斑状态
        TbtskObjectinfo table = MTskTaskBizService.findTableByTaskId(parameter.getTaskId());
        if (table == null) {
            return;
        }
        if(sysConfig!=null && sysConfig.getValue().equalsIgnoreCase(parameter.getTaskId())) {
            // 四川线索任务，对于已经提报的也要回退到已分发状态
            // 将recordid关联的数据至为已下发状态
            String sql = "update " + table.getfTablename() + " a\n" +
                    "set f_status=2 ,f_reject_status =1 \n" +
                    "where f_status=1 and exists (select null from tbsys_task_record_temp b where b.f_dataid=a.f_id and  b.f_recordid = '" + recordId + "')";
            mDataBizService.excuteSql(sql);
        } else{
            // 将recordid关联的数据至为已下发状态
            String sql = "update " + table.getfTablename() + " a\n" +
                    "set f_status=2\n" +
                    "where f_status=1 and exists (select null from tbsys_task_record_temp b where b.f_dataid=a.f_id and  b.f_recordid = '" + recordId + "')";
            mDataBizService.excuteSql(sql);
        }
        // 2.作业区挂接
        JSONArray users = new JSONArray();
        if (parameter.getOrgs() != null) {
            users.addAll(parameter.getOrgs());
        }
        if(parameter.getGroups()!=null) {
            users.addAll(parameter.getGroups());
        }
        assignTaskArea(users, parameter.getTaskId(), recordId, table);

        // 3.生成DB
        createTaskDb(parameter);

        // 成功后删除tbsys_task_record_temp表中的临时数据
        //dataBizService.excuteSql("delete from tbsys_task_record_temp where f_recordid='"+recordId+"'");

        one.setEndtime(new Date());
        one.setState(3);
        mTaskRecordService.save(one);
    }
    public void assignDataByCondition( JSONObject paramsObject) throws Exception {
        TaskQueryParameter queryParameter = JSONObject.parseObject(paramsObject.getString("taskQueryParameter"),
                TaskQueryParameter.class);
        List<Map>  data = mTbtskFlowService.getConfigTaskDataListNew(queryParameter);
        // 1.更新图斑状态
        TbtskObjectinfo table = MTskTaskBizService.findTableByTaskId(queryParameter.getTaskId());
        if (table == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        //获取四川举报线索任务Id
        SysConfig sysConfig = sysConfigService.findOne(BizIdConstants.SCGTY_BIZ_ID);
        if(!sysConfig.getValue().equalsIgnoreCase(queryParameter.getTaskId())) {
            data.forEach(a -> sb.append("'"+a.get("f_id")+"',"));
            // 将recordid关联的数据至为已下发状态
            String sql = "update " + table.getfTablename() + " a set f_status=2 " +
                    "where f_status=1 and  f_id in ("+sb.toString().substring(0, sb.length()-1)+")" ;
            mDataBizService.excuteSql(sql);
        }else{
            // 将recordid关联的数据至为已下发状态
            String sql = "update " + table.getfTablename() + " a set f_status=2 , f_reject_status = 1" +
                    "where f_status=1 and f_id in ("+sb.toString().substring(0, sb.length()-1)+")" ;
            mDataBizService.excuteSql(sql);
        }
        // 2.作业区挂接
        JSONArray users = new JSONArray();
        if (paramsObject.getString("orgs") != null) {
            users.addAll(paramsObject.getJSONArray("orgs"));
        }
        if(paramsObject.getString("groups")!=null) {
            users.addAll(paramsObject.getJSONArray("groups"));
        }
        assignTaskAreaByCond(users, queryParameter.getTaskId(), data, table);

        // 3.生成DB
        createTaskDbByCond(paramsObject, data );
    }

    public void assignTaskArea(JSONArray users, String taskId,String recordId, TbtskObjectinfo table) {
        // 查找recordid 关联的数据，取出这些数据关联到的政区
        String sql = "SELECT DISTINCT \n" +
                "\tA.f_xzqdm,A.f_xzqdmsys \n" +
                "FROM\n" +
                "\t"+table.getfTablename()+" A \n" +
                "WHERE\n" +
                "\tEXISTS (\n" +
                "SELECT NULL \n" +
                "FROM\n" +
                "\ttbsys_task_record_temp b \n" +
                "WHERE\n" +
                "\tb.f_dataid = A.f_id \n" +
                "\tAND b.f_recordid = '"+recordId+"')";

        List<Map> maps = mDataBizService.queryDataBySql(sql);
        List<String> xzqdms = new ArrayList<>();
        TskTaskBiz task = MTskTaskBizService.getTskTaskBizById(taskId);
        for (Map m : maps) {
            /*xzqdms.add(String.valueOf(m.get("f_xzqdm")));*/
            String xzqdmsys = (String) m.get("f_xzqdmsys");
            if(task.getGranularity()!=null  && task.getGranularity() == 3){ //任务粒度 为县
                xzqdms.add(xzqdmsys.substring(0, 6));
            }else if(task.getGranularity()!=null  && task.getGranularity() == 4){ //镇
                xzqdmsys = xzqdmsys.substring(0, 9);
               /* RegionTown regionTown = regionTownRepository.findOne(xzqdmsys);
                if(regionTown == null){
                    xzqdms.add(String.valueOf(m.get("f_xzqdm")));
                }else{
                    xzqdms.add(xzqdmsys);
                }*/
                xzqdms.add(xzqdmsys);
            }else if(task.getGranularity()!=null  && task.getGranularity() == 5){//村
               /* RegionVillage village = regionVillageRepository.findOne(xzqdmsys);
                if(village == null ){
                    xzqdms.add(String.valueOf(m.get("f_xzqdm")));
                }else{
                    xzqdms.add(xzqdmsys);
                }*/
                xzqdms.add(xzqdmsys);
            }else{
                xzqdms.add(String.valueOf(m.get("f_xzqdm")));
            }
        }
        xzqdms = xzqdms.stream().distinct().collect(Collectors.toList());//去重
        for (int i = 0; i < users.size(); i++) {
            JSONArray array = new JSONArray();
            if(users.get(i) instanceof Integer){
                array.add(users.get(i));
            } else {
                JSONObject jsonObject = users.getJSONObject(i);
                array = jsonObject.getJSONArray("userids");
            }

            if (array != null) {
                for (int j = 0; j < array.size(); j++) {
                    String userid = array.getString(j);
                    MTskTaskBizService.saveRightAreasNew(xzqdms, taskId, userid);
                    //新版本消息通知
                    for (String xzqdm : xzqdms) {
                   /*  userManageService.saveNoticeTopicAndNoticeSub(xzqdm,userid,taskId,3);*/
                    }
                }
            }
        }
    }

    /**
     * 按条件下发
     * @param users
     * @param taskId
     * @param maps
     * @param table
     */
    public void assignTaskAreaByCond(JSONArray users, String taskId,List<Map>  maps, TbtskObjectinfo table) {
        List<String> xzqdms = new ArrayList<>();
        TskTaskBiz task = MTskTaskBizService.getTskTaskBizById(taskId);
        for (Map m : maps) {
            /*xzqdms.add(String.valueOf(m.get("f_xzqdm")));*/
            String xzqdmsys = (String) m.get("f_xzqdmsys");
            if(task.getGranularity()!=null  && task.getGranularity() == 3){ //任务粒度 为县
                xzqdms.add(xzqdmsys.substring(0, 6));
            }else if(task.getGranularity()!=null  && task.getGranularity() == 4){ //镇
                xzqdmsys = xzqdmsys.substring(0, 9);
                /*RegionTown regionTown = regionTownRepository.findOne(xzqdmsys);
                if(regionTown == null){
                    xzqdms.add(String.valueOf(m.get("f_xzqdm")));
                }else{
                    xzqdms.add(xzqdmsys);
                }*/
                xzqdms.add(xzqdmsys);
            }else if(task.getGranularity()!=null  && task.getGranularity() == 5){//村
               /* RegionVillage village = regionVillageRepository.findOne(xzqdmsys);
                if(village == null ){
                    xzqdms.add(String.valueOf(m.get("f_xzqdm")));
                }else{
                    xzqdms.add(xzqdmsys);
                }*/
                xzqdms.add(xzqdmsys);
            }else{
                xzqdms.add(String.valueOf(m.get("f_xzqdm")));
            }
        }
        xzqdms = xzqdms.stream().distinct().collect(Collectors.toList());//去重
        for (int i = 0; i < users.size(); i++) {
            JSONArray array = new JSONArray();
            if(users.get(i) instanceof Integer){
                array.add(users.get(i));
            }
            else {
                JSONObject jsonObject = users.getJSONObject(i);
                array = jsonObject.getJSONArray("userids");
            }

            if (array != null) {
                for (int j = 0; j < array.size(); j++) {
                    String userid = array.getString(j);
                    MTskTaskBizService.saveRightAreasNew(xzqdms, taskId, userid);
                    //新版本消息通知
                    for (String xzqdm : xzqdms) {
                   /*  userManageService.saveNoticeTopicAndNoticeSub(xzqdm,userid,taskId,3);*/
                    }
                }
            }
        }
    }

    /**
     * 按勾选数据创建
     * @param parameter
     * @throws Exception
     */
    private void createTaskDb(TaskDataDbParameter parameter) throws Exception {
        if (parameter == null) {
            return;
        }

        List<String> ids = mTaskRecordService.getDataIdListByRecordId(parameter.getRecordId());

        JSONArray orgs = parameter.getOrgs();
        JSONArray groups = parameter.getGroups();
        Long userId = parameter.getUserId();
        String taskId = parameter.getTaskId();
        String mode = parameter.getMode();

        //生成下发记录
        MTskTaskBizService.createRecord(ids, groups, orgs, userId, taskId);

        TskTaskBiz task = MTskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo table = MTskTaskBizService.findTableByTaskId(taskId);

            // 查找
            String sql = "SELECT a.*\n" +
                    "FROM\n" +
                    "\t"+table.getfTablename()+" A \n" +
                    "WHERE\n" +
                    "\tEXISTS (\n" +
                    "SELECT NULL \n" +
                    "FROM\n" +
                    "\ttbsys_task_record_temp b \n" +
                    "WHERE\n" +
                    "\tb.f_dataid = A.f_id \n" +
                    "\tAND b.f_recordid = '"+parameter.getRecordId()+"')";
        List<Map> list = mDataBizService.queryDataBySql(sql);

        /* List<Map> list = tskTaskBizService.findMapByTaskIdAndDate(table, date);*/
        Connection conn = null;
        Statement statement = null;
        SqlliteConnTool tool = null;
        try {
            //将数据根据f_xzqdmsys划分为多个集合
            Map<String, Object> resultMap = new HashMap<String, Object>();
            Set setTmp = new HashSet();
            for(Map map:list){
                setTmp.add(converXzqdmsysByGr(task, map.get("f_xzqdmsys").toString()));
            }
            Iterator it = setTmp.iterator();
            while(it.hasNext()) {
                String oneSetTmpStr = (String) it.next();
                List<Map> oneSetTmpList = new ArrayList<>();
                for (Map tmp : list) {
                    if (oneSetTmpStr.equalsIgnoreCase(converXzqdmsysByGr(task,tmp.get("f_xzqdmsys").toString()))) {
                        oneSetTmpList.add(tmp);
                    }
                }
                // 01.先根据 taskids 生成数据db
                String fileName = UUID.randomUUID().toString() + ".db";
                uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
                String filePath = uploadDir + File.separator + fileName;
                tool = new SqlliteConnTool(filePath);
                conn = tool.getConnection();
                statement = conn.createStatement();

                // 生产表信息和字段信息
                TaskDBUtils.createInfo(MTskTaskBizService, table, task, statement, "sendApp");
                // 生成图斑表
                TaskDBUtils.createTable(MTskTaskBizService, table, task,statement);

                // 导入图斑数据
                Set<String> set = insertData(oneSetTmpList, statement, table, mode);

                // 关闭连接
                tool.closeAll(conn, statement, null);

                // 上传db包到oss上
                Long date = System.currentTimeMillis();
                String key = String.format("taskManagerDB/%s/%s.db", userId, date.toString());
                String dbUrl = ossOperatorService.sendObject2Oss(key, new File(filePath));

                // 02.根据 userids 和 workgroupids 生成消息记录
                String fileUrl = dbUrl;

                // 任务通知
//            TaskNotice taskNotice = new TaskNotice();
//            taskNotice.setData(fileUrl);
//            taskNotice.setContent(String.format("【任务图斑指派】。任务名称：%s；指派%s个图斑", task.getName(), list.size()));
//            taskNotice.setId(UUID.randomUUID().toString());
//            taskNotice.setState(1);
//            taskNotice.setBizId(taskId);
//            taskNotice.setSendUser(userId);
//            taskNotice.setTitle("指派任务通知");
//            taskNotice.setSendTime(new Date());
//            taskNotice.setAddition(JSONObject.toJSONString(parameter.getAddition()));
//            // 每日任务
//            taskNotice.setType(3);
//            // 2 指派任务
//            taskNotice.setAction(2);
//            taskNotice = taskNoticeService.save(taskNotice);
//
//            List<String> alias = new ArrayList<String>();
//
//            Set<String> userIds = new HashSet<>();
//
//            List<TaskNoticeUser> taskNoticeUserList = new ArrayList<>();
//            // 下发给单位
//            for (int i = 0; i < orgs.size(); i++) {
//                JSONObject jsonObject = orgs.getJSONObject(i);
//                String orgid = jsonObject.getString("orgid");
//                JSONArray array = jsonObject.getJSONArray("userids");
//                for (int j = 0; j < array.size(); j++) {
//                    String userid = array.getString(j);
//                    userIds.add(userid);
//                    // 发送推送消息到个人
//                    TaskNoticeUser taskNoticeUser = new TaskNoticeUser();
//                    taskNoticeUser.setId(UUID.randomUUID().toString());
//                    JSONObject data = new JSONObject();
//                    data.put("oriType", "1");
//                    data.put("oriId", orgid);
//                    data.put("tableId", table.getfId());
//                    data.put("tableName", table.getfTablename());
//                    data.put("taskBizId", taskId);
//                    data.put("taskBizName", task.getName());
//
//                    taskNoticeUser.setData(data.toJSONString());
//                    taskNoticeUser.setState(0);
//                    taskNoticeUser.setCreatetime(new Date());
//                    taskNoticeUser.setNoticeId(taskNotice.getId());
//                    taskNoticeUser.setUserId(userid);
//                    //taskNoticeService.save(taskNoticeUser);
//                    taskNoticeUserList.add(taskNoticeUser);
//
//                    alias.add(userid);
//                }
//            }
//
//            // 下发给工作组
//            for (int i = 0; i < groups.size(); i++) {
//                JSONObject jsonObject = groups.getJSONObject(i);
//                String groupid = jsonObject.getString("groupid");
//                JSONArray array = jsonObject.getJSONArray("userids");
//                for (int j = 0; j < array.size(); j++) {
//                    String userid = array.getString(j);
//                    userIds.add(userid);
//                    // 发送推送消息到个人
//                    TaskNoticeUser taskNoticeUser = new TaskNoticeUser();
//                    taskNoticeUser.setId(UUID.randomUUID().toString());
//                    JSONObject data = new JSONObject();
//                    data.put("oriType", "2");
//                    data.put("oriId", groupid);
//                    data.put("tableId", table.getfId());
//                    data.put("tableName", table.getfTablename());
//                    data.put("taskBizId", taskId);
//                    data.put("taskBizName", task.getName());
//
//                    taskNoticeUser.setData(data.toJSONString());
//                    taskNoticeUser.setState(0);
//                    taskNoticeUser.setCreatetime(new Date());
//                    taskNoticeUser.setNoticeId(taskNotice.getId());
//                    taskNoticeUser.setUserId(userid);
//                    //taskNoticeService.save(taskNoticeUser);
//                    taskNoticeUserList.add(taskNoticeUser);
//
//                    alias.add(userid);
//                }
//            }
//
//            taskNoticeService.saveTaskNoticeUserList(taskNoticeUserList);

                List<String> userIds = new ArrayList<>();
                List<TaskNoticeUserNew> taskNoticeUserNewList = new ArrayList<>();

                JSONArray array = new JSONArray();
                // 单位用户
                if(orgs != null){
                    for (int i = 0; i < orgs.size(); i++) {
                        JSONObject jsonObject = orgs.getJSONObject(i);
                        array.addAll(jsonObject.getJSONArray("userids"));
                    }
                }
                // 工作组用户
                if(groups != null){
                    for (int i = 0; i < groups.size(); i++) {
                        JSONObject jsonObject = groups.getJSONObject(i);
                        array.addAll(jsonObject.getJSONArray("userids"));
                    }
                }

                String title = "指派任务通知";
                String content = String.format("【任务图斑指派】。任务名称：%s；指派%s个图斑", task.getName(), oneSetTmpList.size());
                for (int j = 0; j < array.size(); j++) {
                    String userid = array.getString(j);
                    if (!userIds.contains(userid)) {
                        userIds.add(userid);
                    }
                    TaskNoticeUserNew taskNoticeUserNew = new TaskNoticeUserNew();
                   // taskNoticeUserNew.setId(UUID.randomUUID().toString());
                    taskNoticeUserNew.setSenduser(userId.toString());
                    taskNoticeUserNew.setTitle(title);
                    taskNoticeUserNew.setContent(content);
                    taskNoticeUserNew.setAction(1);
                    taskNoticeUserNew.setTaskmode(task.getMode());
                    taskNoticeUserNew.setBizid(taskId);
                    taskNoticeUserNew.setCount(oneSetTmpList.size());
                    taskNoticeUserNew.setReceiveuser(userid);
                    taskNoticeUserNew.setData(fileUrl);
                    taskNoticeUserNew.setXzqdmsys(oneSetTmpStr);
                    taskNoticeUserNew.setSenddate(new Date());
                    taskNoticeUserNewList.add(taskNoticeUserNew);
                }
                mTaskNoticeNewService.addTaskNoticeUserNewList(taskNoticeUserNewList);

                Map<String, Object> message = new HashMap<String, Object>();
                message.put("type", 3);

                // 推送消息
                try {
                    if(userIds.size() > 0){
                        MixPushServer.sendNotifyToAlias(userIds, title, content, JSON.toJSONString(message));
                    }
                }
                catch (Exception e){

                }

                // 授权
                for (String uid : userIds) {
                    // 3表示作业员
                    List<UserBiz2> ub2List = userBiz2Repository.findByUserIdAndBizIdAndRole(Long.parseLong(uid),  taskId, 3);
                    if (ub2List == null || (ub2List != null && ub2List.size() == 0)) {
                        MTskTaskBizService.saveUserBiz(Long.parseLong(uid), taskId, 3);
                    }
                }
            }
        } catch (Exception e) {
            tool.closeAll(conn, statement, null);
            throw new GwValidateException(e.getMessage());
        }

    }

    private String  converXzqdmsysByGr(TskTaskBiz task,String xzqdmsys){
           String xzqdm = "";
              if(task.getGranularity()!=null  && task.getGranularity() == 3){
                  xzqdm = xzqdmsys.substring(0, 6);
              }else if(task.getGranularity()!=null  && task.getGranularity() == 4){
                  xzqdm = xzqdmsys.substring(0, 9);
              }else if(task.getGranularity()!=null  && task.getGranularity() == 5){
                  xzqdm = xzqdmsys.substring(0, 12);
              }else{
                  xzqdm = xzqdmsys.substring(0, 6);
              }
     return xzqdm;
    }

    /**
     * 按条件创建
     * @param paramsObject
     * @param data
     * @throws Exception
     */
    private void createTaskDbByCond(JSONObject paramsObject,List<Map>  data ) throws Exception {
        if (paramsObject == null) {
            return;
        }
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(paramsObject.getString("taskId")).orElse(null);
        List<String> ids = new ArrayList<>();
         data.forEach(a -> ids.add(a.get("f_id").toString()));
        JSONArray orgs = paramsObject.getJSONArray("orgs");
        JSONArray groups = paramsObject.getJSONArray("groups");
        Long userId = paramsObject.getLongValue("userId");
        String taskId = paramsObject.getString("taskId");
        String mode = String.valueOf(tskTaskBiz.getMode());
        //生成下发记录
        MTskTaskBizService.createRecord(ids, groups, orgs, userId, taskId);

        TskTaskBiz task = MTskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo table = MTskTaskBizService.findTableByTaskId(taskId);
        /* List<Map> list = tskTaskBizService.findMapByTaskIdAndDate(table, date);*/
        Connection conn = null;
        Statement statement = null;
        SqlliteConnTool tool = null;
        try {
            //将数据根据f_xzqdmsys划分为多个集合
            Map<String, Object> resultMap = new HashMap<String, Object>();
            Set setTmp = new HashSet();
            for(Map map:data){
                setTmp.add(converXzqdmsysByGr(task, map.get("f_xzqdmsys").toString()));
            }
            Iterator it = setTmp.iterator();
            uploadDir = (String)ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
            while(it.hasNext()) {
                String oneSetTmpStr = (String) it.next();
                List<Map> oneSetTmpList = new ArrayList<>();
                for (Map tmp : data) {
                    if (oneSetTmpStr.equalsIgnoreCase(converXzqdmsysByGr(task,tmp.get("f_xzqdmsys").toString()))) {
                        oneSetTmpList.add(tmp);
                    }
                }
                // resultMap.put(oneSetTmpStr,oneSetTmpList);
                // 01.先根据 taskids 生成数据db
                String fileName = UUID.randomUUID().toString() + ".db";
                String filePath = uploadDir + File.separator + fileName;
                tool = new SqlliteConnTool(filePath);
                conn = tool.getConnection();
                statement = conn.createStatement();
                // 生产表信息和字段信息
                TaskDBUtils.createInfo(MTskTaskBizService, table, task, statement, "sendApp");
                // 生成图斑表
                TaskDBUtils.createTable(MTskTaskBizService, table,task, statement);

                // 导入图斑数据
                Set<String> set = insertData(oneSetTmpList, statement, table, mode);

                // 关闭连接
                tool.closeAll(conn, statement, null);

                // 上传db包到oss上
                Long date = System.currentTimeMillis();
                String key = String.format("taskManagerDB/%s/%s.db", userId, date.toString());
                String dbUrl = ossOperatorService.sendObject2Oss(key, new File(filePath));
                // 02.根据 userids 和 workgroupids 生成消息记录
                String fileUrl = dbUrl;
                List<String> userIds = new ArrayList<>();
                List<TaskNoticeUserNew> taskNoticeUserNewList = new ArrayList<>();

                JSONArray array = new JSONArray();
                // 单位用户
                for (int i = 0; i < orgs.size(); i++) {
                    JSONObject jsonObject = orgs.getJSONObject(i);
                    array.addAll(jsonObject.getJSONArray("userids"));
                }
                // 工作组用户
                for (int i = 0; i < groups.size(); i++) {
                    JSONObject jsonObject = groups.getJSONObject(i);
                    array.addAll(jsonObject.getJSONArray("userids"));
                }

                String title = "指派任务通知";
                String content = String.format("【任务图斑指派】。任务名称：%s；指派%s个图斑", task.getName(), oneSetTmpList.size());
                for (int j = 0; j < array.size(); j++) {
                    String userid = array.getString(j);
                    if (!userIds.contains(userid)) {
                        userIds.add(userid);
                    }
                    TaskNoticeUserNew taskNoticeUserNew = new TaskNoticeUserNew();
                    //taskNoticeUserNew.setId(UUID.randomUUID().toString());
                    taskNoticeUserNew.setSenduser(userId.toString());
                    taskNoticeUserNew.setTitle(title);
                    taskNoticeUserNew.setContent(content);
                    taskNoticeUserNew.setAction(1);
                    taskNoticeUserNew.setTaskmode(task.getMode());
                    taskNoticeUserNew.setBizid(taskId);
                    taskNoticeUserNew.setCount(oneSetTmpList.size());
                    taskNoticeUserNew.setReceiveuser(userid);
                    taskNoticeUserNew.setData(fileUrl);
                    taskNoticeUserNew.setXzqdmsys(oneSetTmpStr);
                    taskNoticeUserNew.setSenddate(new Date());
                    taskNoticeUserNewList.add(taskNoticeUserNew);
                }
                mTaskNoticeNewService.addTaskNoticeUserNewList(taskNoticeUserNewList);

                Map<String, Object> message = new HashMap<String, Object>();
                message.put("type", 3);
                // 推送消息
                try {
                    if(userIds.size() > 0 ){
                        MixPushServer.sendNotifyToAlias(userIds, title, content, JSON.toJSONString(message));
                    }
                }
                catch (Exception e){

                }
                // 授权
                for (String uid : userIds) {
                    // 3表示作业员
                    List<UserBiz2> ub2List = userBiz2Repository.findByUserIdAndBizIdAndRole(Long.parseLong(uid),  taskId, 3);
                    if (ub2List == null || (ub2List != null && ub2List.size() == 0)) {
                        MTskTaskBizService.saveUserBiz(Long.parseLong(uid), taskId, 3);
                    }
                }
            }

        } catch (Exception e) {
            tool.closeAll(conn, statement, null);
            throw new GwValidateException(e.getMessage());
        }

    }

    public Set<String> insertData(List<Map> list, Statement statement, TbtskObjectinfo table, String mode) throws
            SQLException {
        Set<String> resultSet = insertData2(list, statement, table, mode,"parent");

        List<TbtskObjectinfo> tableList = MTskTaskBizService.getObjectInfoListByParentId(table.getfId());
        if (!tableList.isEmpty()) {
            // 子表每次100个一查
            int count = 100;
            for (TbtskObjectinfo tbtskObject : tableList) {
                if (StringUtils.isBlank(tbtskObject.getRelfield())) {
                    continue;
                }

                JSONObject jsonObject = JSONObject.parseObject(tbtskObject.getRelfield());
                String parentFieldName = jsonObject.getString("parentFieldName");
                String childFieldName = jsonObject.getString("fieldName");

                List<String> relList = list.stream().map(t -> t.get(parentFieldName).toString()).collect(Collectors.toList());

                int endIndex = 0;
                for (int i = 0; i < (int) Math.ceil(list.size() * 1.00 / count); i++) {
                    if (list.size() < count) {
                        endIndex = list.size();
                    } else if (endIndex >= relList.size() - 1) {
                        endIndex = relList.size();
                    } else {
                        endIndex = (i + 1) * count;
                    }
                    List<String> strings = relList.subList(i * count, endIndex);

                    String sql = "select * from " + tbtskObject.getfTablename() + " where " + childFieldName + " in('" + StringUtils.join(strings.toArray(), "','") + "')";
                    List<Map> tempList = mDataBizService.queryDataBySql(sql);
                    Set<String> tempResult = insertData2(tempList, statement, tbtskObject, mode,"parent");
                }
            }
        }
        //图斑分隔子表
        if(org.apache.commons.lang3.StringUtils.isNotBlank(table.getSplitTableName())){
            List<String> idList = list.stream().map(t -> t.get("f_id").toString()).collect(Collectors.toList());
            String splitedsql = "select * from " + table.getSplitTableName() + " where  f_splitedid in('" + StringUtils.join(idList .toArray(), "','") +"')";
            List<Map> splitedList = mDataBizService.queryDataBySql(splitedsql);
            insertData2(splitedList, statement, table, mode, "child");
        }
        return resultSet;
    }

    private Set<String> insertData2(List<Map> list, Statement statement, TbtskObjectinfo table, String mode,String tableType) throws
            SQLException {
        Set<String> set = new HashSet<>();
        List<Integer> outList = new ArrayList<>();
        outList.add(1);
        outList.add(2);
        outList.add(3);
        outList.add(6);
        outList.add(4);
        outList.add(5);
        List<TbtskFields> fieldsNotOutFields = MTskTaskBizService.getFieldsNotOutFields(table.getfId(), outList);
        String tableName = table.getfTablename();
        if("child".equals(tableType)){
            tableName = table.getSplitTableName();
        }
        if(tableName.contains(".")) {
            String[] split = tableName.split("\\.");
            tableName = split[1];
        }
        for (Map m : list) {

            String xzqdm = (String) m.get("f_xzqdm");
            set.add(xzqdm);

            StringBuffer sb = new StringBuffer("insert into ");
            sb.append(tableName).append("(");

            StringBuffer values = new StringBuffer(" values(");
            for (int i = 0; i < fieldsNotOutFields.size(); i++) {
                String key = fieldsNotOutFields.get(i).getfFieldname();
                sb.append(key).append(",");

                if ("f_status".equalsIgnoreCase(key)) {
                    // 下发时，将f_status设置为2
                    values.append("'2',");
                } else {
                    if (m.get(key) == null || "null".equalsIgnoreCase(m.get(key).toString())) {
                        if ("1".equals(mode) && "f_ismy".equals(key)) {
                            values.append("'1',");
                        } else {
                            values.append("'',");
                        }
                    } else {
                        if ("2".equals(mode) && "f_ismy".equals(key)) {
                            values.append("'1',");
                        }else if(key.contains("f_shape") ){
                            String shape = m.get(key).toString().substring(m.get(key).toString().lastIndexOf(";")+1);
                            values.append("'").append(shape).append("',");
                        }  else {
                            values.append("'").append(m.get(key)).append("',");
                        }
                    }
                }
            }
            sb.deleteCharAt(sb.length() - 1).append(") ");
            values.deleteCharAt(values.length() - 1).append(");");
            sb.append(values);

            statement.executeUpdate(sb.toString());
        }
        return set;
    }



    @Transactional
    public void pasteAssign(TaskRecord record) {
        try{
            //记录日志
            JSONObject jsonObject = LogUtils.saveSysLog("配置任务撤销下发记录", "JobRunTask-rateJobConfigTaskPasteAssign","配置任务撤销下发记录", record.getId());
            logger.info("rateJobConfigTaskPasteAssign--- 开始:"+ jsonObject.toJSONString());
            //解析参数，执行下发撤销
            JSONObject paramsObject = JSONObject.parseObject(record.getParam());
            //获取下发记录
            TskAssignRecord tskAssignRecord = tskAssignRecordRepository.findById(paramsObject.getString("id")).orElse(null);
            if (tskAssignRecord != null) {
                TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(paramsObject.getString("taskId")).orElse(null);
                TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.findById(tskTaskBiz.getTableId()).orElse(null);
                //查询具体任务数据
                String sql = "select tb.f_id,tb.f_status,tb.f_xzqdmsys from " +tbtskObjectinfo.getfTablename() +" tb  " +
                        "where tb.f_id = '" +tskAssignRecord.getDataId()+"'";
                List<Map>  dataList = mDataBizService.queryDataBySql(sql);
                String xzqdmsys ="";
                if(dataList.size() > 0){
                    for(Map map:dataList){
                        xzqdmsys = map.get("f_xzqdmsys").toString();
                    }
                }

                //将下发记录状态变更为2，表示该记录已撤销
               /* tskAssignRecord.setStatus("2");
                tskAssignRecord.setUpdateTime(DateUtils.getSysTime());
                tskAssignRecord.setPasteUserId(paramsObject.getString("userId"));
                tskAssignRecordRepository.save(tskAssignRecord);*/
                List<TskAssignRecord>  list =  tskAssignRecordRepository.findOrderByCreateTime(paramsObject.getString("taskId"),tskAssignRecord.getDataId());
                if(list == null || list.size() == 0){
                  //该数据没有下发记录则将其改为未下发下发状态
                    String sql1 = "update " + tbtskObjectinfo.getfTablename() + " a set f_status=1 " +
                            "where a.f_status=2 and  a.f_id = '" +tskAssignRecord.getDataId()+"'";
                    mDataBizService.excuteSql(sql1);
                }
                String title = "撤销任务下发记录通知";
                //【撤销下发记录通知】。任务名称：农村乱占耕地问题清查整治；撤销了1个图斑下发记录和%s个房屋下发记录
                String content = String.format("【撤销任务下发记录通知】。任务名称：%s；撤销了1个任务数据下发记录", tskTaskBiz.getName());

                TaskNoticeUserNew taskNoticeUserNew = new TaskNoticeUserNew();
                taskNoticeUserNew.setId(UUID.randomUUID().toString());
                taskNoticeUserNew.setSenduser(paramsObject.getString("userId"));
                taskNoticeUserNew.setTitle(title);
                taskNoticeUserNew.setContent(content);
                taskNoticeUserNew.setAction(5);
                taskNoticeUserNew.setTaskmode(tskTaskBiz.getMode());
                taskNoticeUserNew.setBizid(tskTaskBiz.getId());
                taskNoticeUserNew.setCount(1);
                taskNoticeUserNew.setReceiveuser(tskAssignRecord.getAssignto());
                taskNoticeUserNew.setData(tskAssignRecord.getDataId());
                taskNoticeUserNew.setXzqdmsys(converXzqdmsysByGr(tskTaskBiz,xzqdmsys));
                taskNoticeUserNew.setSenddate(new Date());
                mTaskNoticeNewService.addTaskNoticeUserNew(taskNoticeUserNew);

                Map<String, Object> message = new HashMap<String, Object>();
                message.put("type", 3);
                List<String> userIds = new ArrayList<>();
                userIds.add(tskAssignRecord.getAssignto());
                // 推送消息
                try {
                    if (userIds.size() > 0) {
                        MixPushServer.sendNotifyToAlias(userIds, title, content, JSON.toJSONString(message));
                    }
                } catch (Exception e) {

                }
            }
            record.setResult("撤销成功");
            record.setEndtime(new Date());
            record.setState(3);
            mTaskRecordService.save(record);
        }catch (Exception e){
            record.setEndtime(new Date());
            record.setState(4);
            record.setResult(ExceptionUtil.stacktraceToString(e));
            mTaskRecordService.save(record);
        }finally {
            try {
                //记录日志
                JSONObject jsonObject = LogUtils.saveSysLog("配置任务撤销下发记录", "JobRunTask-rateJobConfigTaskPasteAssign","配置任务撤销下发记录", record.getId());
                logger.info("rateJobConfigTaskPasteAssign--- 结束:"+ jsonObject.toJSONString());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

}
