package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeNew;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeUserNew;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;

import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.TaskDBUtils;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionTownRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.service.util.message.MixPushServer;
import com.alibaba.fastjson.JSON;

import com.gw.base.data.GwValidateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.*;

@Service
/*@Transactional(rollbackFor = Exception.class)*/
public class MTaskCreateDBJobService {
    @Autowired
    DefaultOssOperatorService stsService;
    @Autowired
    MTaskNoticeService mTaskNoticeService;
    @Autowired
    TskTaskBizService mTskTaskBizService;
    @Autowired
    LandUser2AreaRepository landUser2AreaRepository;
    @Autowired
    RegionVillageRepository regionVillageRepository;

    @Autowired
    RegionTownRepository regionTownRepository;

    @Autowired
    RegionVersionRepository regionVersionRepository;

    @Autowired
    RegionRepository regionRepository;
    @Autowired
    MTaskRecordService mTaskRecordService;
    @Autowired
    MDataBizService MDataBizService;

    @Autowired
    MTaskNoticeNewService mTaskNoticeNewService;

    @Autowired
    JdbcTemplate jdbcTemplate;

    //    @Value("#{imeSettings['project.uploadDir']}")
    @Value("${project.uploadDir}")
    String uploadDir;

    TskTaskBiz task = null;
    Long userId = -1L;

    public void repairData() throws Exception {
        RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
        List<TskTaskBiz> tskTaskBizs = mTskTaskBizService.findTskTaskBizs();
        for (TskTaskBiz one : tskTaskBizs) {
            task = one;
            userId = 15788L;
            String addOrUpdate = "ADD";
            TbtskObjectinfo table = mTskTaskBizService.findTableByTaskId(one.getId());
            // 查找
            String sql1 = "SELECT * FROM " + table.getfTablename();
            List<Map> list = MDataBizService.queryDataBySql(sql1);

            Map<String, List<Map>> dbList = new HashMap<>();
            Map<String, String> xzq = new HashMap<>();
            for (Map m : list) {
                String xzqmc = (String) m.get("f_xzqmc1");
                if ("zjd".equals(table.getfRemark())) {
                    // xzqmc = (String) m.get("f_zdwz");
                    String xzqdm = (String) m.get("f_xzqdm");
                    if (one.getGranularity() != null && one.getGranularity() == 5) {
                        RegionVillage village = regionVillageRepository.getByCodeAndVersion(xzqdm, defaultVersion != null ? defaultVersion.getVersion() : "2018");
                        Region region = regionRepository.findByCodeAndVersion(village.getXzqhdm(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                        xzqmc = region.getName() + village.getName();
                    }
                }
                // 新增
                if ("ADD".equalsIgnoreCase(addOrUpdate)) {
                    String xzqdmsys = (String) m.get("f_xzqdmsys");
                    if (one.getGranularity() != null && one.getGranularity() == 3) { //任务粒度 为县
                        xzqdmsys = xzqdmsys.substring(0, 6);
                    } else if (one.getGranularity() != null && one.getGranularity() == 4) { //镇
                        xzqdmsys = xzqdmsys.substring(0, 9);
                    } else if (one.getGranularity() != null && one.getGranularity() == 5) {//村
                        xzqdmsys = (String) m.get("f_xzqdmsys");
                    } else {
                        xzqdmsys = (String) m.get("f_xzqdm");
                    }
                    String key = xzqmc + "新增";
                    // 不存在key 则返回新的list
                    dbList.computeIfAbsent(key, k -> new ArrayList<Map>()).add(m);
                    xzq.putIfAbsent(key, xzqdmsys);
                }
            }
            List<String> userIds = mTskTaskBizService.findUserIdsByBizId(one.getId());
            List<Long> userList = new ArrayList<>();
            for (String u : userIds) {
                userList.add(Long.parseLong(u));
            }
            for (String k : dbList.keySet()) {
                List<String> uIds = new ArrayList<>();
                if (!userList.isEmpty()) {
                    List<Long> tempIds = landUser2AreaRepository.queryUserIdByAreas(userList, k);
                    for (Long i : tempIds) {
                        uIds.add(i.toString());
                    }
                }
                try {
                    List<TaskNoticeNew> list1 = mTaskNoticeNewService.findTaskNoticeUserNewBybizIdAndTopic(one.getId(),
                            "tsk|" + one.getId() + "|" + xzq.get(k));
                    if (list1.size() < 1) {
                        sendMessage(uIds, table, dbList.get(k), k, xzq.get(k), addOrUpdate, "2");
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }
    }


    public void creatDB(TaskRecord record) throws Exception {
        RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
        TaskDataDbParameter taskDataDbParameter = JSONObject.parseObject(record.getParam(), TaskDataDbParameter.class);
        userId = record.getUserid();

        String taskId = taskDataDbParameter.getTaskId();
        String date = taskDataDbParameter.getDate();
        String mode = taskDataDbParameter.getMode();

        JSONObject addition = taskDataDbParameter.getAddition();
        String addOrUpdate = addition.getString("addOrUpdate");

        task = mTskTaskBizService.getTskTaskBizById(taskId);

        TbtskObjectinfo table = mTskTaskBizService.findTableByTaskId(taskId);

        // 查找
        String sql = "SELECT a.*\n" +
                "FROM\n" +
                "\t" + table.getfTablename() + " A \n" +
                "WHERE\n" +
                "\tEXISTS (\n" +
                "SELECT NULL \n" +
                "FROM\n" +
                "\ttbsys_task_record_temp b \n" +
                "WHERE\n" +
                "\tb.f_dataid = A.f_id \n" +
                "\tAND b.f_recordid = '" + record.getId() + "')";

        //List<Map> list = tskTaskBizService.findMapByTaskIdAndDate(table, date);
        List<Map> list = MDataBizService.queryDataBySql(sql);

        Map<String, List<Map>> dbList = new HashMap<>();
        Map<String, String> xzq = new HashMap<>();
        for (Map m : list) {
            String xzqmc = (String) m.get("f_xzqmc1");
            // 新增
            if ("ADD".equalsIgnoreCase(addOrUpdate)) {
                String xzqdmsys = (String) m.get("f_xzqdmsys");
                if (task.getGranularity() != null && task.getGranularity() == 3) { //任务粒度 为县
                    xzqdmsys = xzqdmsys.substring(0, 6);
                } else if (task.getGranularity() != null && task.getGranularity() == 4) { //镇
                    xzqdmsys = xzqdmsys.substring(0, 9);
                } else if (task.getGranularity() != null && task.getGranularity() == 5) {//村
                    xzqdmsys = (String) m.get("f_xzqdmsys");
                } else {
                    xzqdmsys = (String) m.get("f_xzqdm");
                }

                dbList.computeIfAbsent(xzqdmsys, k -> new ArrayList<Map>()).add(m);
                xzq.putIfAbsent(xzqdmsys, xzqmc + "新增");

            } else if ("UPDATE".equalsIgnoreCase(addOrUpdate)) {
                String xzqdmsys = (String) m.get("f_xzqdmsys");
                if (task.getGranularity() != null && task.getGranularity() == 3) { //任务粒度 为县
                    xzqdmsys = xzqdmsys.substring(0, 6);
                } else if (task.getGranularity() != null && task.getGranularity() == 4) { //镇
                    xzqdmsys = xzqdmsys.substring(0, 9);
                } else if (task.getGranularity() != null && task.getGranularity() == 5) {//村
                    xzqdmsys = (String) m.get("f_xzqdmsys");
                } else {
                    xzqdmsys = (String) m.get("f_xzqdm");
                }

                dbList.computeIfAbsent(xzqdmsys, k -> new ArrayList<Map>()).add(m);
                xzq.putIfAbsent(xzqdmsys, xzqmc + "更新");
            }
        }

        List<String> userIds = mTskTaskBizService.findUserIdsByBizId(task.getId());
        List<Long> userList = new ArrayList<>();
        for (String u : userIds) {
            userList.add(Long.parseLong(u));
        }
        for (String k : dbList.keySet()) {
            List<String> uIds = new ArrayList<>();
            if (!userList.isEmpty()) {
                List<Long> tempIds = landUser2AreaRepository.queryUserIdByAreas(userList, k);
                for (Long i : tempIds) {
                    uIds.add(i.toString());
                }
            }
            try {
                sendMessage(uIds, table, dbList.get(k), xzq.get(k), k, addOrUpdate, mode);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        // 成功后删除tbsys_task_record_temp表中的临时数据
        MDataBizService.excuteSql("delete from tbsys_task_record_temp where f_recordid='" + record.getId() + "'");
    }

    private void sendMessage(List<String> userIds, TbtskObjectinfo table, List<Map> list, String xzqmc, String xzqdm, String addOrUpdate, String mode) throws Exception {

        if (list == null || list.isEmpty()) return;
        Connection conn = null;
        Statement statement = null;
        SqlliteConnTool tool = null;
        try {
            // 01.先根据 taskids 生成数据db
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
            String fileName = UUID.randomUUID().toString() + ".db";
            String filePath = uploadDir + File.separator + fileName;
            tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();

            // 生产表信息和字段信息
            TaskDBUtils.createInfo(mTskTaskBizService, table, task, statement, "sendApp");

            // 生成图斑表
            TaskDBUtils.createTable(mTskTaskBizService, table,task, statement);

            // 导入图斑数据
            conn.setAutoCommit(false);
            insertData(list, statement, table, mode);
            conn.commit();

            // 关闭连接
            tool.closeAll(conn, statement, null);

            // 上传db包到oss上
            Long date = System.currentTimeMillis();
            String key = String.format("taskManagerDB/%s/%s.db", userId, date.toString());
            File file = new File(filePath);
            String dbUrl = stsService.sendObject2Oss(key, file);

            // 02.根据 userids 和 workgroupids 生成消息记录
            String fileUrl = dbUrl;

            // 任务通知
//            TaskNotice taskNotice = new TaskNotice();
//            taskNotice.setData(fileUrl);
//            taskNotice.setContent(String.format("【任务图斑领取】。任务名称：%s；任务区域：%s；共%s个图斑", task.getName(), xzqmc, list.size()));
//            taskNotice.setId(UUID.randomUUID().toString());
//            taskNotice.setState(1);
//            taskNotice.setBizId(task.getId());
//            taskNotice.setSendUser(this.userId);
//            taskNotice.setTitle("任务图斑领取");
//            taskNotice.setSendTime(new Date());
//            taskNotice.setType(3);// 每日任务
//            taskNotice.setAction(2);// 2 指派任务
//            taskNotice.setRegion(xzqdm);
//            JSONObject additionJson = new JSONObject();
//            additionJson.put("count", list.size());
//            additionJson.put("addOrUpdate",addOrUpdate);
//            taskNotice.setAddition(additionJson.toJSONString());
//            taskNotice = taskNoticeService.save(taskNotice);
//
//            // 发送消息给用户
//            List<TaskNoticeUser> taskNoticeUserList = new ArrayList<>();
//            for (String uid : userIds) {
//                // 发送推送消息到个人
//                TaskNoticeUser taskNoticeUser = new TaskNoticeUser();
//                taskNoticeUser.setId(UUID.randomUUID().toString());
//                JSONObject data = new JSONObject();
//                data.put("sendUserId", userId);
//                data.put("tableId", table.getfId());
//                data.put("tableName", table.getfTablename());
//                data.put("taskBizId", task.getId());
//                data.put("taskBizName", task.getName());
//                data.put("xzqmc", xzqmc);
//                data.put("xzqdm", xzqdm);
//
//                taskNoticeUser.setData(data.toJSONString());
//                taskNoticeUser.setState(0);
//                taskNoticeUser.setCreatetime(new Date());
//                taskNoticeUser.setNoticeId(taskNotice.getId());
//                taskNoticeUser.setUserId(uid);
//                //taskNoticeService.save(taskNoticeUser);
//                taskNoticeUserList.add(taskNoticeUser);
//            }
//            taskNoticeService.saveTaskNoticeUserList(taskNoticeUserList);


            Map<String, Object> message = new HashMap<String, Object>();
            message.put("type", 3);

            // 任务消息
            if ("1".equalsIgnoreCase(mode)) {
                // 下发模式，对下发记录中的用户发送点对点的更新图斑消息

                // 先确定，每个图斑都给哪些人发过消息，再组织消息,即1个人对应多少个图斑，发送一条消息
                // 因针对每个人打包影响效率，这里只需要判断，这批图斑中都给谁下发过，那就整体将整个db一起
                // 发送给app，app端只对本地存在的图斑进行更新处理
                Map<String, Integer> listMap = new HashMap<>();
                for (Map m : list) {
                    String dataId = m.get("f_id").toString();
                    String sql = "SELECT DISTINCT\n" +
                            "\t( A.f_assignto ) \n" +
                            "FROM\n" +
                            "\ttbtsk_assign_record A \n" +
                            "WHERE\n" +
                            "\tEXISTS (\n" +
                            "SELECT NULL \n" +
                            "FROM\n" +
                            "\ttbsys_task_record_temp b \n" +
                            "WHERE\n" +
                            "\tb.f_dataid = A.f_dataid \n" +
                            "\tAND b.f_dataid = '" + dataId + "')";

                    List<Map<String, Object>> userMaps = jdbcTemplate.queryForList(sql);
                    for (int i = 0; i < userMaps.size(); i++) {
                        String userId = userMaps.get(i).get("f_assignto").toString();
                        if (listMap.containsKey(userId)) {
                            Integer count = listMap.get(userId);
                            listMap.put(userId, count + 1);
                        } else {
                            listMap.put(userId, 1);
                        }
                    }
                }

                // 发送点对点消息
                List<TaskNoticeUserNew> taskNoticeUserNewList = new ArrayList<>();
                String title = "任务图斑更新";
                String content = "";
                for (Map.Entry<String, Integer> entry : listMap.entrySet()) {
                    String userId = entry.getKey();
                    Integer count = entry.getValue();

                    content = String.format("【任务图斑更新】。任务名称：%s；任务区域：%s；共%s个图斑", task.getName(), xzqmc, count);
                    TaskNoticeUserNew taskNoticeUserNew = new TaskNoticeUserNew();
                    taskNoticeUserNew.setId(UUID.randomUUID().toString());
                    taskNoticeUserNew.setSenduser(userId.toString());
                    taskNoticeUserNew.setTitle(title);
                    taskNoticeUserNew.setContent(content);
                    taskNoticeUserNew.setAction(4);
                    taskNoticeUserNew.setTaskmode(task.getMode());
                    taskNoticeUserNew.setBizid(task.getId());
                    taskNoticeUserNew.setCount(list.size());
                    taskNoticeUserNew.setReceiveuser(userId);
                    taskNoticeUserNew.setData(fileUrl);
                    taskNoticeUserNew.setXzqdmsys(xzqdm);
                    taskNoticeUserNew.setSenddate(new Date());

                    taskNoticeUserNewList.add(taskNoticeUserNew);
                }

                mTaskNoticeNewService.addTaskNoticeUserNewList(taskNoticeUserNewList);
            } else {
                // 领取模式，增加区域广播消息
                TaskNoticeNew taskNoticeNew = new TaskNoticeNew();
                taskNoticeNew.setId(UUID.randomUUID().toString());
                String content = "";
                String title = "";
                if ("UPDATE".equalsIgnoreCase(addOrUpdate)) {
                    taskNoticeNew.setAction(4);
                    title = "任务图斑更新";
                    content = String.format("【任务图斑更新】。任务名称：%s；任务区域：%s；共%s个图斑", task.getName(), xzqmc, list.size());
                } else if ("ADD".equalsIgnoreCase(addOrUpdate)) {
                    taskNoticeNew.setAction(3);
                    title = "任务图斑领取";
                    content = String.format("【任务图斑领取】。任务名称：%s；任务区域：%s；共%s个图斑", task.getName(), xzqmc, list.size());
                }
                taskNoticeNew.setBizid(task.getId());
                taskNoticeNew.setTitle(title);
                taskNoticeNew.setContent(content);
                taskNoticeNew.setTaskmode(Integer.valueOf(mode));
                /*   taskNoticeNew.setTopic("tsk|"+task.getId()+"|");*/
                taskNoticeNew.setTopic("tsk|" + task.getId() + "|" + xzqdm);
                taskNoticeNew.setData(fileUrl);
                taskNoticeNew.setCount(list.size());
                taskNoticeNew.setSenduser(userId.toString());
                taskNoticeNew.setSenddate(new Date());
                mTaskNoticeNewService.addTaskNoticeNew(taskNoticeNew);
                if (userIds.size() > 0) {
                    try {
                        // 推送消息
                        MixPushServer.sendNotifyToAlias(userIds, title, content, JSON.toJSONString(message));
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

            }
            // 上传成功后删除文件
            if (file.exists()) {
                try {
                    file.delete();
                } catch (Exception e) {

                }
            }
        } catch (Exception e) {
            // 关闭连接
            tool.closeAll(conn, statement, null);
            throw new GwValidateException(e.getMessage());
        }
    }

    private void insertData(List<Map> list, Statement statement, TbtskObjectinfo table, String mode) throws SQLException {

        List<Integer> outList = new ArrayList<>();
        outList.add(1);
        outList.add(3);
        outList.add(4);
        outList.add(5);
        List<TbtskFields> fieldsNotOutFields = mTskTaskBizService.getFieldsNotOutFields(table.getfId(), outList);

        int count = 0;
        for (Map m : list) {
            StringBuffer sb = new StringBuffer("insert into ");
            sb.append(table.getfTablename()).append("(");

            StringBuffer values = new StringBuffer(" values(");

            for (int i = 0; i < fieldsNotOutFields.size(); i++) {
                String key = fieldsNotOutFields.get(i).getfFieldname();
                sb.append(key).append(",");

                if ("f_status".equalsIgnoreCase(key)) {
                    // 下发时，将f_status设置为2
                    values.append("'2',");
                } else {
                    if (m.get(key) == null || "null".equalsIgnoreCase(m.get(key).toString())) {
                        if ("1".equals(mode) && "f_ismy".equals(key)) {
                            values.append("'1',");
                        } else {
                            values.append("'',");
                        }
                    } else {
                        if ("2".equals(mode) && "f_ismy".equals(key)) {
                            values.append("'0',");
                        } else {
                            values.append("'").append(m.get(key)).append("',");
                        }
                    }
                }
            }

            sb.deleteCharAt(sb.length() - 1).append(") ");
            values.deleteCharAt(values.length() - 1).append(");");
            sb.append(values);

            //statement.executeUpdate(sb.toString());

            statement.addBatch(sb.toString());
            count++;

            // 每50条提交一次
            if (count == 50) {
                statement.executeBatch();
                count = 0;
            }
        }

        // 最后一次提交
        if (count > 0) {
            statement.executeBatch();
            count = 0;
        }
    }

}
