package com.geoway.landteam.landcloud.service.customtask.task;

import com.geoway.landteam.customtask.task.constants.FieldGroupTypeConstant;
import com.geoway.landteam.customtask.task.entity.TbtskFieldGroupView;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.gw.base.util.GutilStr;
import com.meizu.push.sdk.utils.StringUtils;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.sql.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import static java.sql.Types.NULL;

@Service
@Transactional
public class MTaskDataService {

    @Autowired
    MTbtskObjectinfoService mTbtskObjectinfoService;

    @Autowired
    MTbtskFieldsService mTbtskFieldsService;

    @Autowired
    MDataBizService mDataBizService;

    String sysCode = "web";

    /**
     * 创建db文件
     * @param tableid
     * @param tempPath
     * @return
     */
    public String createDB(String tableid,String tempPath,String filter){
        // 01.先根据 taskids 生成数据db
        String fileName = UUID.randomUUID().toString() + ".db";
        String filePath = tempPath+ File.separator+ fileName;
        SqlliteConnTool tool = new SqlliteConnTool(filePath);
        Connection connection = tool.getConnection();

        try{
            // 取出表对象
            TbtskObjectinfo tbtskObjectinfo = mTbtskObjectinfoService.getObjectbyID(tableid);
            if (tbtskObjectinfo == null){
                return null;
            }

            // 字段
            List<TbtskFieldGroupView> fieldsList = mTbtskFieldsService.getTbtskViewFields("web",tableid, FieldGroupTypeConstant.AppXfTbBase);
            if(fieldsList==null || fieldsList.size()<1){
                return null;
            }

            // 创建db
            createDB(connection, tbtskObjectinfo.getfTablename(),fieldsList);

            // 导入数据
            insertData(connection,tbtskObjectinfo,filter);
        }
        catch (Exception ex){
            tool.closeAll(connection,null,null);
            return null;
        }
        tool.closeAll(connection,null,null);

        return filePath;
    }

    /**
     * 导入db数据
     */
    public void importDB(String filePath,String tableid){
        // 取出表对象
        TbtskObjectinfo tbtskObjectinfo = mTbtskObjectinfoService.getObjectbyID(tableid);
        if (tbtskObjectinfo == null){
            return;
        }

        SqlliteConnTool tool = new SqlliteConnTool(filePath);
        Connection connection = tool.getConnection();
        Statement statement = null;
        try{
            statement = connection.createStatement();

            // 导入数据
            addDataFromDB2PG(statement,tbtskObjectinfo);

            tool.closeAll(connection,statement,null);
        }
        catch (Exception ex){
            tool.closeAll(connection,null,null);
        }
    }

    private void createDB(Connection connection, String tablename,List<TbtskFieldGroupView> fieldsList) throws SQLException {
        if (connection == null || connection.isClosed() || tablename == null){
            return;
        }
        connection.setAutoCommit(false);

        // 构建sql
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE \""+tablename+"\"(");
        String primaryKeyName = "";

        for (TbtskFieldGroupView field : fieldsList) {
            String type = field.getfFieldtype();
            Integer length = field.getfLength();
            String fieldName = field.getfFieldname();
            Integer isprimary = field.getfIsprimary();
            Integer nullable = field.getfNullable();
            Integer percision = field.getfPrecision();
            if (isprimary != null && isprimary == 1) {
                primaryKeyName = fieldName;
            }

            switch (type) {
                case "varchar":
                    builder.append("\"" + fieldName + "\" varchar(" + length + "),");
                    break;
                case "double":
                    builder.append("\"" + fieldName + "\" double,");
                    break;
                case "number":
                    builder.append("\"" + fieldName + "\" int(4),");
                    break;
                case "float":
                    builder.append("\"" + fieldName + "\" float(" + length + "," + percision + "),");
                    break;
                case "text":
                    builder.append("\"" + fieldName + "\" text,");
                    break;
                case "timestamp":
                    builder.append("\"" + fieldName + "\" datetime,");
                    break;
                case "geometry":
                    builder.append("\"" + fieldName + "\" blob,");
                    break;
                default:
                    break;
            }
        }
        builder.append("primary key (\"" + primaryKeyName + "\" asc)");
        builder.append(")");
        String sql = builder.toString();
        PreparedStatement pre = connection.prepareStatement(sql);
        pre.execute();
        connection.commit();
        pre.close();
    }

    private void insertData(Connection connection,TbtskObjectinfo tbtskObjectinfo,String filter) throws SQLException {
        List<String> fieldNameList = mTbtskFieldsService.getTbtskFieldsNameListBySysCodeAndGroupCode(sysCode,tbtskObjectinfo.getfId(), FieldGroupTypeConstant.AppXfTbBase);
        List<TbtskFieldGroupView> fieldsList = mTbtskFieldsService.getTbtskViewFields(sysCode,tbtskObjectinfo.getfId(), FieldGroupTypeConstant.AppXfTbBase);

        // 构造sql
        String sql = "insert into BASIC_TB (" + GutilStr.join(fieldNameList, ",") + ")";
        sql += " values(" + GutilStr.removeEnd(GutilStr.repeat("?,", fieldNameList.size()), ",") + ")";

        // 根据条件取出数据
        List<Map> tableDatas = mDataBizService.queryAllData(tbtskObjectinfo.getfTablename(),fieldNameList,filter);

        PreparedStatement pre = connection.prepareStatement(sql);
        WKBWriter wr = new WKBWriter();
        WKTReader wktReader = new WKTReader();

        for (Map tableItem : tableDatas) {
            for (int i = 0; i < fieldsList.size(); i++) {
                String type = fieldsList.get(i).getfFieldtype();
                String fieldName = fieldsList.get(i).getfFieldname();

                Object fieldValue = tableItem.get(fieldName);
                if (fieldValue == null) {
                    pre.setNull(i + 1, NULL);
                } else {
                    switch (type) {
                        case "varchar":
                            pre.setString(i + 1, String.valueOf(fieldValue));
                            break;
                        case "double":
                            pre.setDouble(i + 1, Double.valueOf(fieldValue.toString()));
                            break;
                        case "number":
                            pre.setInt(i + 1, Integer.valueOf(fieldValue.toString()));
                            break;
                        case "float":
                            pre.setFloat(i + 1, Float.valueOf(fieldValue.toString()));
                            break;
                        case "text":
                            pre.setString(i + 1, String.valueOf(fieldValue));
                            break;
                        case "timestamp":
                            pre.setTimestamp(i + 1, Timestamp.valueOf(fieldValue.toString()));
                            break;
                        case "geometry":
                            try {
                                Geometry geo = wktReader.read(fieldValue.toString());
                                pre.setBytes(i + 1, wr.write(geo));
                            } catch (Exception e) {
                                pre.setBytes(i + 1, null);
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
            pre.addBatch();
        }
        pre.executeBatch();
        pre.clearBatch();
        connection.commit();
        pre.close();
    }

    private void addDataFromDB2PG(Statement statement,TbtskObjectinfo table) throws Exception {
        List<TbtskFieldGroupView> fields = mTbtskFieldsService.getTbtskViewFields(sysCode,table.getfId(), FieldGroupTypeConstant.AppXfTbUpload);
        if(fields == null || fields.size()<1){
            return;
        }
        String tableName = table.getfTablename();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ");
        for (int i = 0; i < fields.size() - 1; i++) {
            stringBuilder.append(fields.get(i).getfFieldname());
            stringBuilder.append(",");
        }
        stringBuilder.append(fields.get(fields.size() - 1).getfFieldname());
        stringBuilder.append(" from ");
        stringBuilder.append(table.getfTablename());
        String sql = stringBuilder.toString();
        ResultSet rs = statement.executeQuery(sql);

        while (rs.next()) {
            int ismycreate = rs.getInt("f_ismycreate");
            String fid = rs.getString("f_id");
            HashMap<String, Object> map = new HashMap<>();
            if (ismycreate == 1) {
                //插入数据
                List<TbtskFields> allFields = mTbtskFieldsService.getAllFieldsByTableID(table.getfId());
                for (TbtskFields field : allFields) {
                    String defaultvalue = field.getfDefaultvalue();
                    if (GutilStr.isNotBlank(defaultvalue)) {
                        map.put(field.getfFieldname(), defaultvalue);
                    }
                }
                for (TbtskFieldGroupView field : fields) {
                    String fieldName = field.getfFieldname();
                    String fieldType = field.getfFieldtype();
                    addDatatoMap(map, rs, fieldType, fieldName);
                }
//                map.put("f_xzqdm", regionCode);
//                map.put("f_rwzt", RwztConstant.AppUpload);
                mDataBizService.insertData(tableName, map, "shape");
            } else {
                //更新数据
                for (TbtskFieldGroupView field : fields) {
                    String fieldName = field.getfFieldname();
                    String fieldType = field.getfFieldtype();
                    if ("geometry".equals(fieldType) || "f_id".equals(fieldName)){
                        continue;
                    }
                    addDatatoMap(map, rs, fieldType, fieldName);
                }
//                map.put("f_xzqdm", regionCode);
//                map.put("f_rwzt", RwztConstant.AppUpload);
                mDataBizService.updateData(tableName, map, "f_id='" + fid + "'");
            }
        }
    }

    void addDatatoMap(Map map, ResultSet rs, String fieldType, String fieldName) throws SQLException, ParseException {
        WKBReader wr = new WKBReader();
        switch (fieldType) {
            case "varchar":
            case "text":
                String value1 = rs.getString(fieldName);
                if (value1 == null || "null".equals(value1.toLowerCase()) || "".equals(value1)) {
                    map.put(fieldName, NULL);
                } else {
                    map.put(fieldName, value1);
                }
                break;
            case "double":
                Double value2 = rs.getDouble(fieldName);
                if( StringUtils.isBlank(String.valueOf(value2)) ) {
                    map.put(fieldName, NULL);
                } else {
                    map.put(fieldName, value2);
                }
                break;
            case "number":
                Integer value3 = rs.getInt(fieldName);
                	 if( StringUtils.isBlank(String.valueOf(value3)) ) {
                    map.put(fieldName, NULL);
                } else {
                    map.put(fieldName, value3);
                }
                break;
            case "float":
                Float value4 = rs.getFloat(fieldName);
                	 if( StringUtils.isBlank(String.valueOf(value4)) ) {
                    map.put(fieldName, NULL);
                } else {
                    map.put(fieldName, value4);
                }
                break;
            case "timestamp":
                map.put(fieldName, rs.getTimestamp(fieldName));
                Timestamp value5 = rs.getTimestamp(fieldName);
                if (value5 == null) {
                    map.put(fieldName, NULL);
                } else {
                    map.put(fieldName, value5);
                }
                break;
            case "geometry":
                byte[] byteShape = rs.getBytes(fieldName);
                if (byteShape == null || byteShape.length < 1) {
                    break;
                }
                if (byteShape != null) {
                    Geometry shape = wr.read(byteShape);
                    map.put(fieldName, shape.toString());
                }
                break;
            default:
                break;
        }
    }
}
