package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeNew;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeUserNew;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.TaskNoticeSubscribeRepository;
import com.geoway.landteam.customtask.repository.task.UserBiz2Repository;

import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.TaskDBUtils;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.task.entity.UserBiz2;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.service.util.message.MixPushServer;
import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class MTaskFieldUpdateService {
    @Autowired
    DefaultOssOperatorService stsService;
    @Autowired
    MTaskNoticeService mTaskNoticeService;
    @Autowired
    MTskTaskBizService mTskTaskBizService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    LandUser2AreaRepository landUser2AreaRepository;
    @Autowired
    RegionVillageRepository regionVillageRepository;
    @Autowired
    RegionRepository regionRepository;
    @Autowired
    MTaskRecordService mTaskRecordService;
    @Autowired
    MDataBizService mDataBizService;

    @Autowired
    MTaskNoticeNewService mTaskNoticeNewService;

    @Autowired
    TaskNoticeSubscribeRepository taskNoticeSubscribeRepository;

    @Autowired
    UserBiz2Repository userBiz2Repository;

    @Autowired
    JdbcTemplate jdbcTemplate;
    @Value("${project.uploadDir}")
    String uploadDir;

    TskTaskBiz task = null;
    Long userId = -1L;

    public void fieldUpdate(TaskRecord record) throws Exception {
        //解析参数
        JSONObject paramsObject = JSONObject.parseObject(record.getParam());
        userId = record.getUserid();
        String taskId = paramsObject.getString("taskId");
        String mode = paramsObject.getString("mode");
        String type = paramsObject.getString("type");
        task = mTskTaskBizService.getTskTaskBizById(taskId);
        TbtskObjectinfo table = mTskTaskBizService.findTableByTaskId(taskId);
        // 查找
        String sql = "SELECT a.* FROM\n" +"\t"+table.getfTablename()+" A " ;
        List<Map> list = mDataBizService.queryDataBySql(sql);
       // List<String> userIds = tskTaskBizService.findUserIdsByBizId(task.getId());
        List<UserBiz2> userBiz2s = userBiz2Repository.findByBizId(task.getId());
        if(userBiz2s.size()>0){
            List<Long> userIds  = userBiz2s.stream().map(UserBiz2::getUserId).collect(Collectors.toList());
            List<String> strUserIds = userIds.stream().map(x -> x + "").collect(Collectors.toList());
            sendMessage(strUserIds, table, list,mode,type);
        }

    }

    private void sendMessage(List<String> userIds, TbtskObjectinfo table, List<Map> list,String mode,String type) throws
            Exception {
        if(list == null|| list.isEmpty())return;
        Connection conn = null;
        Statement statement = null;
        SqlliteConnTool tool = null;
        try {
            // 01.先根据 taskids 生成数据db
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
            String fileName = UUID.randomUUID().toString() + ".db";
            String filePath = uploadDir+ File.separator+ fileName;
            tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();

            // 生产表信息和字段信息
            TaskDBUtils.createInfo(tskTaskBizService, table, task, statement,"sendApp");

            // 生成图斑表
            TaskDBUtils.createTable(tskTaskBizService, table,task, statement);

            // 导入图斑数据
            conn.setAutoCommit(false);
            insertData(list, statement, table,mode);
            conn.commit();

            // 关闭连接
            tool.closeAll(conn, statement,null);

            // 上传db包到oss上
            Long date = System.currentTimeMillis();
            String key = String.format("taskManagerDB/%s/%s.db", userId, date.toString());
            File file = new File(filePath);
            String dbUrl = stsService.sendObject2Oss(key, file);
            // 02.根据 userids 和 workgroupids 生成消息记录
            String fileUrl = dbUrl;
            Map<String, Object> message = new HashMap<String, Object>();
            message.put("type", 3);

            // 任务消息
            if("1".equalsIgnoreCase(mode)){
                // 下发模式，对下发记录中的用户发送点对点的更新消息
                Map<String,Integer> listMap = new HashMap<>();
                for (Map m : list) {
                    String dataId = m.get("f_id").toString();
                    String sql = "SELECT DISTINCT\n" +
                            "\t( A.f_assignto ) \n" +
                            "FROM\n" +
                            "\ttbtsk_assign_record A \n" +
                            "WHERE\n" +
                            "\tEXISTS (\n" +
                            "SELECT NULL \n" +
                            "FROM\n" +
                            "\ttbsys_task_record_temp b \n" +
                            "WHERE\n" +
                            "\tb.f_dataid = A.f_dataid \n" +
                            "\tAND b.f_dataid = '"+dataId+"')";

                    List<Map<String, Object>> userMaps = jdbcTemplate.queryForList(sql);
                    for (int i=0;i<userMaps.size();i++){
                        String userId = userMaps.get(i).get("f_assignto").toString();
                       if(listMap.containsKey(userId)){
                           Integer count = listMap.get(userId);
                           listMap.put(userId,count+1);
                       }
                       else{
                           listMap.put(userId,1);
                       }
                    }
                }
                // 发送点对点消息
                List<TaskNoticeUserNew> taskNoticeUserNewList = new ArrayList<>();
                String title = "任务数据字段更新";
                String content = "";
                for (Map.Entry<String,Integer> entry : listMap.entrySet()){
                    String userId = entry.getKey();
                    Integer count = entry.getValue();
                    content = String.format("【任务数据字段更新】。任务名称：%s；", task.getName());
                    TaskNoticeUserNew taskNoticeUserNew = new TaskNoticeUserNew();
                    taskNoticeUserNew.setId(UUID.randomUUID().toString());
                    taskNoticeUserNew.setSenduser(userId.toString());
                    taskNoticeUserNew.setTitle(title);
                    taskNoticeUserNew.setContent(content);
                    taskNoticeUserNew.setAction(7);
                    taskNoticeUserNew.setTaskmode(task.getMode());
                    taskNoticeUserNew.setBizid(task.getId());
                    taskNoticeUserNew.setCount(list.size());
                    taskNoticeUserNew.setReceiveuser(userId);
                    taskNoticeUserNew.setData(fileUrl);
                    taskNoticeUserNew.setSenddate(new Date());
                    taskNoticeUserNewList.add(taskNoticeUserNew);
                }
                mTaskNoticeNewService.addTaskNoticeUserNewList(taskNoticeUserNewList);
            }
            else{
                // 领取模式，增加区域广播消息
                TaskNoticeNew taskNoticeNew = new TaskNoticeNew();
                taskNoticeNew.setId(UUID.randomUUID().toString());
                String content =""; String  title="";
                if(type.equalsIgnoreCase("fieldUpdate")){
                     content = String.format("【任务数据字段更新】。任务名称：%s", task.getName());
                     title = "任务数据字段更新";
                     taskNoticeNew.setAction(7);
                }else if("showChange".equalsIgnoreCase(type)){
                    content = String.format("【任务App端显示变更】。任务名称：%s", task.getName());
                    title = "任务App端显示变更";
                    taskNoticeNew.setAction(8);
                }
                    taskNoticeNew.setBizid(task.getId());
                    taskNoticeNew.setTitle(title);
                    taskNoticeNew.setContent(content);
                    taskNoticeNew.setTaskmode(Integer.valueOf(mode));
                    taskNoticeNew.setTopic("tsk|"+task.getId());
                    taskNoticeNew.setData(fileUrl);
                    taskNoticeNew.setCount(list.size());
                    taskNoticeNew.setSenduser(userId.toString());
                    taskNoticeNew.setSenddate(new Date());
                mTaskNoticeNewService.addTaskNoticeNew(taskNoticeNew);
                // 推送消息
                MixPushServer.sendNotifyToAlias(userIds,title,content, JSON.toJSONString(message));
            }
            // 上传成功后删除文件
            if(file.exists()){
                try {
                    file.delete();
                }
                catch (Exception e){

                }
            }
        } catch (Exception e) {
            // 关闭连接
            tool.closeAll(conn, statement,null);
            throw new Exception(e.getMessage());
        }
    }

    private void insertData(List<Map> list, Statement statement, TbtskObjectinfo table,String mode) throws SQLException {

        List<Integer> outList = new ArrayList<>();
        outList.add(1);
        outList.add(3);
        outList.add(4);
        outList.add(5);
        List<TbtskFields> fieldsNotOutFields = mTskTaskBizService.getFieldsNotOutFields(table.getfId(), outList);

        int count = 0;
        for (Map m : list) {
            StringBuffer sb = new StringBuffer("insert into ");
            sb.append(table.getfTablename()).append("(");

            StringBuffer values = new StringBuffer(" values(");

            for (int i=0;i<fieldsNotOutFields.size();i++) {
                String key = fieldsNotOutFields.get(i).getfFieldname();
                sb.append(key).append(",");

                if("f_status".equalsIgnoreCase(key)){
                    // 下发时，将f_status设置为2
                    values.append("'2',");
                }
                else {
                    if (m.get(key) == null || "null".equalsIgnoreCase(m.get(key).toString())) {
                        if ("1".equals(mode) && "f_ismy".equals(key)) {
                            values.append("'1',");
                        } else {
                            values.append("'',");
                        }
                    } else {
                        if ("2".equals(mode) && "f_ismy".equals(key)) {
                            values.append("'0',");
                        } else {
                            values.append("'").append(m.get(key)).append("',");
                        }
                    }
                }
            }

            sb.deleteCharAt(sb.length()-1).append(") ");
            values.deleteCharAt(values.length()-1).append(");");
            sb.append(values);

            //statement.executeUpdate(sb.toString());

            statement.addBatch(sb.toString());
            count++;

            // 每50条提交一次
            if(count==50){
                statement.executeBatch();
                count = 0;
            }
        }

        // 最后一次提交
        if(count>0){
            statement.executeBatch();
            count = 0;
        }
    }

}
