package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.ImageCaptureDef;
import com.geoway.landteam.customtask.pub.entity.ImageCaptureJob;
import com.geoway.landteam.customtask.repository.pub.ImageCaptureDefRepository;
import com.geoway.landteam.customtask.repository.pub.ImageCaptureJobRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTaskImageCaptureService;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueSourceDao;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.gw.base.json.GwJSON;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import net.bytebuddy.agent.builder.AgentBuilder;
import okhttp3.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.validation.constraints.NotNull;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @Author Waves
 * @Date 2023/7/10
 * @Description
 **/

@Service
public class MTaskImageCaptureServiceImpl implements MTaskImageCaptureService {

    GiLoger loger = GwLoger.getLoger(MTaskImageCaptureServiceImpl.class);

    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    ImageCaptureJobRepository imageCaptureJobRepository;
    @Autowired
    ImageCaptureDefRepository captureDefRepository;
    @Autowired
    JcClueSourceDao sourceDao;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;

    private static final String NAME_PREFIX = "zhjcjg";

    //数据库默认截图服务配置，
    private static final String DEFAULT_CONFIG = "capture.default";

    @Override
    public boolean startImageCapture(String tablename,String ids ) {
        return startImageCapture(tablename,ids,new ImageCaptureDef());
    }

    @Override
    public boolean startImageCapture(String tablename,String ids, ImageCaptureDef param){

        //queryData
        tablename = tablename.trim().replace(" as tb","").trim();
        ids = ids.replaceAll(",","','");
        String sql ="";
        if(StringUtils.isNotBlank(ids)){
            sql = String.format("select f_id,f_shape from %s where f_id in('%s')",tablename, ids) ;
        }else {
            sql = String.format("select f_id,f_shape from %s",tablename) ;
        }

        List<Map> spots = dataBizService.queryDataBySql(sql);
        //dataToJson
        List<JSONObject> wkts =  spots.stream()
                .map(this::parseCaptureJson)
                .filter(e -> !e.isEmpty())
                .collect(Collectors.toList());
        if(wkts.isEmpty()) throw new RuntimeException("未查询到有效数据");
        String wktStrs = new JSONArray(wkts).toString();

        //initParam
        String jobName = Optional.ofNullable(param.getNamePrefix()).orElse(NAME_PREFIX) + System.currentTimeMillis();

        ImageCaptureJob job = new ImageCaptureJob();
        job.setId(UUID.randomUUID().toString());
        job.setJobName(jobName);
        job.setParams(wktStrs);
        job.setStartTime(new Date());
        job.setStatus(0);
        job.setDefId(Optional.of(param.getId()).orElse("0"));
        job.setTableName(tablename);
        job.setSplit(tablename.endsWith("_child"));
        imageCaptureJobRepository.save(job);
        return false;
    }

    @Override
    public ImageCaptureDef getCaptureDef(@NotNull ImageCaptureJob job){
        ImageCaptureDef result = Optional.ofNullable(job)
                .map(ImageCaptureJob::getDefId)
                .map(captureDefRepository::findById)
                .map(e -> e.<RuntimeException>orElseThrow(RuntimeException::new))
                .orElseThrow(RuntimeException::new);
        return result;
    }
    @Override
    public String getBizid(@NotNull ImageCaptureJob job) {
        Integer type = getBizType(job);
        String tablename = job.getTableName();
        String bizid = getBizid(type,tablename);
        return bizid;
    }

    @Override
    public Integer getBizType(@NotNull ImageCaptureJob job){
        Integer type =  Optional.ofNullable(job)
                .map(ImageCaptureJob::getDefId)
                .map(captureDefRepository::findById)
                .map(e -> e.<RuntimeException>orElseThrow(RuntimeException::new))
                .map(ImageCaptureDef::getObjectType)
                .orElseThrow(() -> new RuntimeException("未找到正确的配置"));
        return type;
    }
    /**
     * 根据业务类型和表名获取
     * @param type
     * @param tablename
     * @return
     */
    private String getBizid(Integer type,String tablename){
        if(type == 0){//任务类型，根据表名获取taskid
            return Optional.ofNullable(tablename)
                    .map(tbtskObjectinfoRepository::getObjectbyName)
                    .filter(l -> !l.isEmpty())
                    .map(e -> e.get(0))
                    .map(TbtskObjectinfo::getfId)
                    .map(tskTaskBizRepository::findByTableId)
                    .map(TskTaskBiz::getId)
                    .orElseThrow(RuntimeException::new);
        }else if(type == 1){//线索类型，根据表名获取sourceid
            return Optional.ofNullable(tablename)
                    .map(sourceDao::findByName)
                    .map(JcClueSource::getfId)
                    .orElseThrow(RuntimeException::new);
        }else{
            throw new RuntimeException("不支持的业务类型");
        }
    }

    private JSONObject parseCaptureJson(Map data){
        JSONObject result = new JSONObject();
        if(data.containsKey("f_id") && data.containsKey("f_shape") && data.get("f_id") != null  && data.get("f_shape") != null){
            result.put("id",data.get("f_id").toString());
            String ewkt = data.get("f_shape").toString();
            String wkt ="";
            if(StringUtils.isNotBlank(ewkt)){
                wkt= ewkt.replaceAll("^SRID=\\d{1,4};","");
            }
            result.put("shape",wkt);
        }
        return result;
    }
}

