package com.geoway.landteam.landcloud.service.customtask.task;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.dao.resultshare.ResultShareTbIdDao;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.pub.entity.TbgstDataLog;
import com.geoway.landteam.customtask.repository.pub.TbgstDataLogRepository;
import com.geoway.landteam.customtask.repository.task.UserBiz2Repository;
import com.geoway.landteam.customtask.resultshare.pub.entity.ResultShareTask;
import com.geoway.landteam.customtask.servface.multitask.TbtskDataLogService;
import com.geoway.landteam.customtask.servface.taskTranslate.TaskTranslateAtlasService;
import com.geoway.landteam.customtask.servface.taskTranslate.TbTaskTranslateTaskService;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.dto.TskUploadLogDTO;
import com.geoway.landteam.customtask.task.entity.TbtskDataLog;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.resultshare.enm.AnalysisTaskStateEnum;
import com.geoway.landteam.customtask.resultshare.pub.entity.ResultShareTbId;
import com.geoway.landteam.customtask.util.ExcelUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MResultShareAtlasService;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MResultShareTaskService;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class MTaskImportTaskDataService {

    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    MTskTaskBizService mTskTaskBizService;
    @Autowired
    MTaskRecordService mTaskRecordService;

    @Autowired
    MTbtskDataLogService mTbtskDataLogService;

    @Autowired
    MDataBizService mDataBizService;


    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    @Autowired
    DefaultOssOperatorService ossOperatorService;

    @Autowired
    UserBiz2Repository userBiz2Repository;

    @Autowired
    TbgstDataLogRepository tbgstDataLogRepository;

    @Autowired
    MResultShareAtlasService resultShareAtlasService;

    @Autowired
    MResultShareTaskService resultShareTaskService;

    @Autowired
    ResultShareTbIdDao resultShareTbIdDao;

    @Autowired
    TaskTranslateAtlasService taskTranslateAtlasService;

    @Autowired
    TbTaskTranslateTaskService tbTaskTranslateTaskService;

    @Autowired
    TbtskDataLogService tbtskDataLogService;
    @Autowired
    RedisTemplate redisTemplate;

    @Value("${project.uploadDir}")
    String uploadDir;

    private final GiLoger logger = GwLoger.getLoger(MTaskImportTaskDataService.class);

  /*  @Transactional(rollbackFor = Exception.class)*/
    public void dataImport(TaskRecord record){
        HttpURLConnection httpURLConnection = null;
        DateFormat df = new SimpleDateFormat("YYYY-MM-DD HH:mm:ss");
        Map<String, TskUploadLogDTO> dataUploadLog = new HashMap();
        TskTaskBiz task = new TskTaskBiz();
        Long userId =null;
        try {
            //解析参数，执行数据加载
            JSONObject paramsObject = JSONObject.parseObject(record.getParam());
            String uploadurl = temporarySignedUrlService.getTemporarySignedUrl("", paramsObject.getString("unzipFileDir"), null);
            // 统一资源
            URL url = new URL(uploadurl);
            // 连接类的父类，抽象类
            URLConnection urlConnection = url.openConnection();
            // http的连接类
             httpURLConnection = (HttpURLConnection) urlConnection;
            //设置超时
            httpURLConnection.setConnectTimeout(1000 * 60*10);
            //设置请求方式，默认是GET
            httpURLConnection.setRequestMethod("GET");
            // 设置字符编码
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            // 打开到此 URL引用的资源的通信链接（如果尚未建立这样的连接）。
            httpURLConnection.connect();
            // 文件大小
            int fileLength = httpURLConnection.getContentLength();
            // 控制台打印文件大小
          /*  logger.info(String.format("%s", "您要下载的文件大小为:", fileLength / (1024 *1024) + "MB"));*/
            // 建立链接从请求中获取数据
            URLConnection con = url.openConnection();
            File zipFile = null;
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
            File dir = new File(uploadDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            zipFile = File.createTempFile("tmp", ".gty", dir);
            FileUtils.copyInputStreamToFile(httpURLConnection.getInputStream(), zipFile);
            String zipName = zipFile.getAbsolutePath();
            String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            Zip4jUtils.unzip(zipName, unzipFileDir, "gtdcy2019");

            String taskId = paramsObject.getString("taskId");
             task = mTskTaskBizService.findByTaskId(taskId);
             userId = paramsObject.getLongValue("userId");
            //加载数据
            Map<String, List<String>> tempIds = mTskTaskBizService.importTaskData(unzipFileDir, taskId, userId,  paramsObject.getString("updateType"), dataUploadLog);
            Map<String, List<String>> ids = new HashMap<>();
            ids.computeIfAbsent("ADD", k -> new ArrayList<>()).addAll(tempIds.getOrDefault("ADD", new ArrayList<>()));
            ids.computeIfAbsent("UPDATE", k -> new ArrayList<>()).addAll(tempIds.getOrDefault("UPDATE", new ArrayList<>()));
            //生成日志
            createLog( userId, dataUploadLog, task.getName(),task.getId());
           /*if (!dataUploadLog.isEmpty()) {
               String name = landUserRepository.queryUserById(userId).getRname();
                    List<Map<String, Object>> data = new ArrayList<>();
                    // 日志记录
                    for (Map.Entry<String, TskUploadLogDTO> entry : dataUploadLog.entrySet()) {
                        Map map = entry.getValue().toMap();
                        map.put("uploadUser", name);
                        map.put("uploadDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                        data.add(map);
                    }
            String tempDir = System.getProperty("java.io.tmpdir");
            String fileName = task.getName() + "-数据导入日志-" + System.currentTimeMillis() + ".xls";
            String fileName1 = task.getName() + "-数据导入日志-" + new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date()) + ".xls";

            String col = TskUploadLogDTO.getExcelCol() + ",uploadUser,uploadDate";
            String colName = TskUploadLogDTO.getExcelColName() + ",上传人,上传时间";
            String filePath = ExcelUtil.CreateExcel(data, tempDir, fileName, col, colName, "日志导出");
            String sendObjName = "taskManagerUploadLog/" + fileName1;
            String downloadPath = ossOperatorService.sendObject2Oss(sendObjName, filePath);

            TbtskDataLog tbtskDataLog = new TbtskDataLog();
            tbtskDataLog.setCreateTime(new Date());
            tbtskDataLog.setLogUrl(downloadPath);
            tbtskDataLog.setName(fileName1);
            tbtskDataLog.setTaskId(taskId);
            tbtskDataLog.setUserId(userId);
            tbtskDataLogService.saveDataLog(tbtskDataLog);
        }*/
        List<String> add = ids.get("ADD");
        List<String> update = ids.get("UPDATE");

        if (task != null && task.getMode() != null) {
            if ("1".equals(task.getType()) || 2 == task.getMode()) {

                if (add.size() > 0) {
                    JSONObject additionJson = new JSONObject();
                    additionJson.put("count", add.size());
                    additionJson.put("addOrUpdate", "ADD");
                    additionJson.put("taskMode", task.getMode());
                    additionJson.put("curMode", "receive");

                    String recordId = UUID.randomUUID().toString();
                    TaskDataDbParameter parameter = new TaskDataDbParameter();
                    parameter.setRecordId(recordId);
                    parameter.setTaskId(task.getId());
                    parameter.setGroups(new JSONArray());
                    parameter.setOrgs(new JSONArray());
                    parameter.setAddition(additionJson);
                    parameter.setDate(String.valueOf(System.currentTimeMillis()));
                    //parameter.setIds(add);
                    parameter.setMode(task.getMode().toString());

                    List<TaskRecordTemp> tempList = new ArrayList<>();
                    for (int i = 0; i < add.size(); i++) {
                        TaskRecordTemp temp = new TaskRecordTemp();
                        temp.setId(UUID.randomUUID().toString());
                        temp.setRecordid(recordId);
                        temp.setDataid(add.get(i));
                        tempList.add(temp);
                    }

                    mTaskRecordService.saveTaskRecordTemp(tempList);

                    TaskRecord record2 = new TaskRecord();
                    record2.setId(recordId);
                    record2.setParam(JSONObject.toJSONString(parameter));
                    record2.setTasktype(JobConstants.JOB_TYPE_DATA_PACKAGE);
                    record2.setStarttime(new Date());
                    record2.setState(1);
                    record2.setUserid(userId);
                    mTaskRecordService.save(record2);
                }


                // 更新的
                if (update.size() > 0) {
                    String recordId1 = UUID.randomUUID().toString();
                    JSONObject additionJson1 = new JSONObject();
                    additionJson1.put("count", update.size());
                    additionJson1.put("addOrUpdate", "UPDATE");
                    additionJson1.put("taskMode", task.getMode());
                    additionJson1.put("curMode", "receive");

                    TaskDataDbParameter parameter1 = new TaskDataDbParameter();
                    parameter1.setRecordId(recordId1);
                    parameter1.setTaskId(task.getId());
                    //parameter1.setTbIds(JSONArray.parseArray(JSONObject.toJSONString(update)));
                    parameter1.setGroups(new JSONArray());
                    parameter1.setOrgs(new JSONArray());
                    parameter1.setAddition(additionJson1);
                    parameter1.setDate(String.valueOf(System.currentTimeMillis()));
                    //parameter1.setIds(update);
                    parameter1.setMode(task.getMode().toString());

                    List<TaskRecordTemp> tempList = new ArrayList<>();
                    for (int i = 0; i < update.size(); i++) {
                        TaskRecordTemp temp = new TaskRecordTemp();
                        temp.setId(UUID.randomUUID().toString());
                        temp.setRecordid(recordId1);
                        temp.setDataid(update.get(i));
                        tempList.add(temp);
                    }

                    mTaskRecordService.saveTaskRecordTemp(tempList);

                    TaskRecord record1 = new TaskRecord();
                    record1.setId(recordId1);
                    record1.setParam(JSONObject.toJSONString(parameter1));
                    record1.setTasktype(JobConstants.JOB_TYPE_DATA_PACKAGE);
                    record1.setStarttime(new Date());
                    record1.setState(1);
                    record1.setUserid(userId);
                    mTaskRecordService.save(record1);
                }
            }
        }
            record.setEndtime(new Date());
            record.setState(3); //成功
            mTaskRecordService.save(record);
            if (paramsObject.containsKey("translateId") && StringUtils.isNotBlank(paramsObject.getString("translateId"))) {
                    String translateId = paramsObject.getString("translateId");
                    ResultShareTask resultShareTask = resultShareTaskService.select(translateId);
                    if (add != null && !add.isEmpty()) {
                        int batchCount = 100;
                        int page = add.size() / batchCount + 1;
                        for (int i = 0; i < page; i++) {
                            int startIndex = i * batchCount;
                            int endIndex = (i + 1) * batchCount;
                            if (startIndex >= add.size()) {
                                break;
                            }
                            if (endIndex >= add.size()) {
                                endIndex = add.size();
                            }
                            List<String> subs = add.subList(startIndex, endIndex);
                            List<ResultShareTbId> tbids = new ArrayList<>();
                            for (String id : subs) {
                                ResultShareTbId tbid = new ResultShareTbId();
                                tbid.setId(UUID.randomUUID().toString());
                                tbid.setTbid(id);
                                tbid.setAnalysisId(translateId);
                                tbid.setTaskId(taskId);
                                tbid.setTemplateId(resultShareTask.getTemplateId());
                                tbids.add(tbid);
                            }
                            resultShareTbIdDao.batchInsert(tbids);
                        }
                    }
                    if (update != null && !update.isEmpty()) {
                        int batchCount = 100;
                        int page = update.size() / batchCount + 1;
                        for (int i = 0; i < page; i++) {
                            int startIndex = i * batchCount;
                            int endIndex = (i + 1) * batchCount;
                            if (startIndex >= update.size()) {
                                break;
                            }
                            if (endIndex >= update.size()) {
                                endIndex = update.size();
                            }
                            List<String> subs = update.subList(startIndex, endIndex);
                            List<ResultShareTbId> tbids = new ArrayList<>();
                            for (String id : subs) {
                                ResultShareTbId tbid = new ResultShareTbId();
                                tbid.setId(UUID.randomUUID().toString());
                                tbid.setTbid(id);
                                tbid.setAnalysisId(translateId);
                                tbid.setTaskId(taskId);
                                tbid.setTemplateId(resultShareTask.getTemplateId());
                                tbids.add(tbid);
                            }
                            resultShareTbIdDao.batchInsert(tbids);
                        }
                    }
                   resultShareTaskService.updateStatus(translateId, AnalysisTaskStateEnum.create.getCode().shortValue());
                    /*
                    Map result = taskTranslateAtlasService.startTask(translateId);
                    if (MapUtils.getBoolean(result, "result")) {
                        // 启动任务成功
                        tbTaskTranslateTaskService.startTask(translateId, AnalysisTaskStateEnum.runing.getCode().shortValue());

                    } else {
                        tbTaskTranslateTaskService.startTask(translateId, AnalysisTaskStateEnum.error.getCode().shortValue());
                    }

                     */
                }
            else if (paramsObject.containsKey("atlasId") && StringUtils.isNotBlank(paramsObject.getString("atlasId"))) {
                String atlasId = paramsObject.getString("atlasId");
                if (add != null && !add.isEmpty()) {
                    int batchCount = 100;
                    int page = add.size() / batchCount + 1;
                    for (int i = 0; i < page; i++) {
                        int startIndex = i * batchCount;
                        int endIndex = (i + 1) * batchCount;
                        if (startIndex >= add.size()) {
                            break;
                        }
                        if (endIndex >= add.size()) {
                            endIndex = add.size();
                        }
                        List<String> subs = add.subList(startIndex, endIndex);
                        List<Map<String, Object>> maps = new ArrayList<>();
                        for (String id : subs) {
                            Map<String, Object> map = new HashMap<>();
                            map.put("f_atlasid", atlasId);
                            map.put("f_tbid", id);
                            maps.add(map);
                        }
                        mDataBizService.insertDatasBatch("tb_task_translate_tbid", maps, null);

                    }
                }
                if (update != null && !update.isEmpty()) {
                    int batchCount = 100;
                    int page = update.size() / batchCount + 1;
                    for (int i = 0; i < page; i++) {
                        int startIndex = i * batchCount;
                        int endIndex = (i + 1) * batchCount;
                        if (startIndex >= update.size()) {
                            break;
                        }
                        if (endIndex >= update.size()) {
                            endIndex = update.size();
                        }
                        List<String> subs = update.subList(startIndex, endIndex);
                        List<Map<String, Object>> maps = new ArrayList<>();
                        for (String id : subs) {
                            Map<String, Object> map = new HashMap<>();
                            map.put("f_atlasid", atlasId);
                            map.put("f_tbid", id);
                            maps.add(map);
                        }
                        mDataBizService.insertDatasBatch("tb_task_translate_tbid", maps, null);

                    }
                }
                Map result = taskTranslateAtlasService.startTask(atlasId);
                if (MapUtils.getBoolean(result, "result")) {
                    // 启动任务成功
                    tbTaskTranslateTaskService.update(atlasId, 1, new Date());

                } else {
                    tbTaskTranslateTaskService.update(atlasId, -1, new Date());
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            //生成日志
            createLog( userId, dataUploadLog, task.getName(),task.getId());
            record.setEndtime(new Date());
            record.setState(4); //失败
            record.setRemark(ExceptionUtil.stacktraceToString(e));
            mTaskRecordService.save(record);

        }finally {
            if(httpURLConnection != null){
                httpURLConnection.disconnect();
            }
            logger.info("JobRunTask-rateJobDataImportInner 平台任务数据加载执行结束" + record.getId()+"-"+record.getState()+"-"+df
                    .format (new Date()));
        }
    }

    /**
     * 截图服务数据加载处理
     * @param record
     */
    public void gstDataImport(TaskRecord record){
        HttpURLConnection httpURLConnection = null;
        DateFormat df = new SimpleDateFormat("YYYY-MM-DD HH:mm:ss");
        Map<String, TskUploadLogDTO> dataUploadLog = new HashMap();
        TskTaskBiz task = new TskTaskBiz();
        String tbgstDataLogId  = null;
        Long userId =null;
        try {
            //解析参数，执行加载
            JSONObject paramsObject = JSONObject.parseObject(record.getParam());
            String uploadurl = temporarySignedUrlService.getTemporarySignedUrl("", paramsObject.getString("unzipFileDir"), null);
            // 统一资源
            URL url = new URL(uploadurl);
            // 连接类的父类，抽象类
            URLConnection urlConnection = url.openConnection();
            // http的连接类
             httpURLConnection = (HttpURLConnection) urlConnection;
            //设置超时
            httpURLConnection.setConnectTimeout(1000 * 60*30);
            //设置请求方式，默认是GET
            httpURLConnection.setRequestMethod("GET");
            // 设置字符编码
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            // 打开到此 URL引用的资源的通信链接（如果尚未建立这样的连接）。
            httpURLConnection.connect();
            // 建立链接从请求中获取数据
            URLConnection con = url.openConnection();
            File zipFile = null;
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
            File dir = new File(uploadDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            zipFile = File.createTempFile("tmp", ".gty", dir);
            FileUtils.copyInputStreamToFile(httpURLConnection.getInputStream(), zipFile);
            String zipName = zipFile.getAbsolutePath();
            String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            Zip4jUtils.unzip(zipName, unzipFileDir, "gtdcy2019");

            String taskId = paramsObject.getString("taskId");
             task = mTskTaskBizService.findByTaskId(taskId);
             userId = paramsObject.getLongValue("userId");
            tbgstDataLogId = paramsObject.getString("tbgstDataLogId");
            if(!StringUtils.isEmpty(tbgstDataLogId)){
                tbgstDataLogRepository.updateTbgstDataLogByid(tbgstDataLogId);
            }
            //加载数据
            Map<String, List<String>> tempIds = mTskTaskBizService.importTaskGstData(unzipFileDir, taskId, userId,
                    paramsObject.getString("updateType"), dataUploadLog);
           /* Map<String, List<String>> ids = new HashMap<>();
                ids.computeIfAbsent("ADD", k -> new ArrayList<>()).addAll(tempIds.getOrDefault("ADD", new ArrayList<>()));
                ids.computeIfAbsent("UPDATE", k -> new ArrayList<>()).addAll(tempIds.getOrDefault("UPDATE", new ArrayList<>()));*/
                //生成日志
            createGstLog( userId, dataUploadLog, task,tbgstDataLogId,"success");
            record.setEndtime(new Date());
            record.setState(3); //成功
            mTaskRecordService.save(record);
        }catch (Exception e){
            e.printStackTrace();
            //生成日志
            createGstLog( userId, dataUploadLog, task,tbgstDataLogId,"fail");
            record.setEndtime(new Date());
            record.setState(4); //失败
            record.setRemark(ExceptionUtil.stacktraceToString(e));
            mTaskRecordService.save(record);
        }finally {
            if(httpURLConnection != null){
                httpURLConnection.disconnect();
            }
            logger.info("JobRunTask-rateJobDataImport 平台任务数据加载执行结束" + df.format(new Date()));
        }
    }

    public TbtskDataLog  createLog(Long userId,Map<String, TskUploadLogDTO> dataUploadLog,String taskName,String dataId){
        Integer successCount = 0; Integer failCount = 0;Integer skipCount = 0;
        if (!dataUploadLog.isEmpty()) {
            String name = landUserRepository.queryUserById(userId).getName();
            List<Map<String, Object>> data = new ArrayList<>();
            if(dataUploadLog.size() ==1 && dataUploadLog.containsKey("error")){
                Map map = JSONObject.parseObject(JSONObject.toJSONString(dataUploadLog.get("error")), Map.class);
                map.put("uploadUser", name);
                map.put("uploadDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                map.put("error",map.get("errorInfo"));
                map.put("updateType",map.get("uploadType"));
                failCount +=  Integer.valueOf(map.get("failNum").toString());
                data.add(map);
            }else{
                // 日志记录
                for (Map.Entry<String, TskUploadLogDTO> entry : dataUploadLog.entrySet()) {
                    Map map = entry.getValue().toMap();
                    map.put("uploadUser", name);
                    map.put("uploadDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    successCount +=  Integer.valueOf(map.get("success").toString());
                    failCount +=  Integer.valueOf(map.get("fail").toString());
                    skipCount +=  Integer.valueOf(map.get("skip").toString());
                    data.add(map);
                }
            }
            String tempDir = System.getProperty("java.io.tmpdir");
            String fileName = taskName + "-数据导入日志-" + System.currentTimeMillis() + ".xls";
            String fileName1 = taskName + "-数据导入日志-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xls";

            String col = TskUploadLogDTO.getExcelCol() + ",uploadUser,uploadDate";
            String colName = TskUploadLogDTO.getExcelColName() + ",上传人,上传时间";
            String filePath = null;
            try {
                filePath = ExcelUtil.CreateExcel(data, tempDir, fileName, col, colName, "日志导出");
            } catch (Exception e) {
                e.printStackTrace();
            }
            String sendObjName = "taskManagerUploadLog/" + fileName1;
            String downloadPath = ossOperatorService.sendObject2Oss(sendObjName, filePath);

            TbtskDataLog tbtskDataLog = new TbtskDataLog();
            tbtskDataLog.setCreateTime(new Date());
            tbtskDataLog.setLogUrl(downloadPath);
            tbtskDataLog.setName(fileName1);
            tbtskDataLog.setTaskId(dataId);
            tbtskDataLog.setUserId(userId.toString());
            tbtskDataLog.setSuccessCount(successCount.toString());
            tbtskDataLog.setFailCount(failCount.toString());
            tbtskDataLog.setSkipCount(skipCount.toString());
            mTbtskDataLogService.saveDataLog(tbtskDataLog);
            return tbtskDataLog;
        }
        return null;
    }


    public void createImportLog(JcClueSource jcClueSource, TbtskDataLog tbtskDataLog, Long userId) {
        String fileName = jcClueSource.getfName() + "-数据导入日志-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xls";
        tbtskDataLog.setCreateTime(new Date());
        tbtskDataLog.setName(fileName);
        tbtskDataLog.setTaskId(jcClueSource.getfId());
        tbtskDataLog.setUserId(userId.toString());
        tbtskDataLog = tbtskDataLogService.saveDataLog(tbtskDataLog);
        redisTemplate.opsForHash().put(JobConstants.JOB_REDIS_WEB, tbtskDataLog.getId(), 0 + "%");

    }

    public void  createGstLog(Long userId,Map<String, TskUploadLogDTO> dataUploadLog,TskTaskBiz task,String
            tbgstDataLogId,String state){
        if (!dataUploadLog.isEmpty()) {
            String name = landUserRepository.queryUserById(userId).getName();
            List<Map<String, Object>> data = new ArrayList<>();
            if(dataUploadLog.size() ==1 && dataUploadLog.containsKey("error")){
                Map map = JSONObject.parseObject(JSONObject.toJSONString(dataUploadLog.get("error")), Map.class);
                map.put("uploadUser", name);
                map.put("uploadDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                map.put("error",map.get("errorInfo"));
                map.put("updateType",map.get("uploadType"));
                data.add(map);
            }else{
                // 日志记录
                for (Map.Entry<String, TskUploadLogDTO> entry : dataUploadLog.entrySet()) {
                    Map map = entry.getValue().toMap();
                    map.put("uploadUser", name);
                    map.put("uploadDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    data.add(map);
                }
            }
            String tempDir = System.getProperty("java.io.tmpdir");
            String fileName = task.getName() + "-数据导入日志-" + System.currentTimeMillis() + ".xls";
            String fileName1 = task.getName() + "-截图服务数据导入日志-" + new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format
                    (new Date()) + ".xls";

            String col = TskUploadLogDTO.getExcelCol() + ",uploadUser,uploadDate";
            String colName = TskUploadLogDTO.getExcelColName() + ",上传人,上传时间";
            String filePath = null;
            try {
                filePath = ExcelUtil.CreateExcel(data, tempDir, fileName, col, colName, "日志导出");
            } catch (Exception e) {
                e.printStackTrace();
            }
            String sendObjName = "taskManagerUploadLog/" + fileName1;
            String downloadPath = ossOperatorService.sendObject2Oss(sendObjName, filePath);

            TbgstDataLog tbgstDataLog = tbgstDataLogRepository.findById(tbgstDataLogId).get();
                tbgstDataLog.setLogurl(downloadPath);
                tbgstDataLog.setLogName(fileName1);
                tbgstDataLog.setEndTime(new Date());
                tbgstDataLog.setStatus("success".equals(state)?3:4);
                tbgstDataLogRepository.save(tbgstDataLog);
        }else{
            TbgstDataLog tbgstDataLog = tbgstDataLogRepository.findById(tbgstDataLogId).get();
            tbgstDataLog.setEndTime(new Date());
            tbgstDataLog.setStatus("success".equals(state)?3:4);
            tbgstDataLogRepository.save(tbgstDataLog);
        }
    }

}
