package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONArray;
import com.geoway.landteam.customtask.repository.task.UserBiz2Repository;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.task.TaskNoticeNewService;
import com.geoway.landteam.customtask.service.task.thread.TaskSendMsgNewThread;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionTown;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.repository.base.RegionTownRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.service.util.RedisSessionUtils;
import com.gw.base.data.GwValidateException;
import com.gw.base.data.result.GiResult;
import com.gw.base.util.GutilAssert;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Transactional(rollbackFor = Exception.class)
public class MTaskManageService {

    @Autowired
    MTskTaskBizService tskTaskBizService;

    @Autowired
    TskTaskBizService tskTaskBizService1;

    @Autowired
    MDataBizService dataBizService;

    @Autowired
    ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Autowired
    UserBiz2Repository userBiz2Repository;

    @Autowired
    TaskNoticeNewService taskNoticeNewService;

    @Autowired
    RegionVersionRepository regionVersionRepository;

    @Autowired
    RegionTownRepository regionTownRepository;

    @Autowired
    RegionVillageRepository regionVillageRepository;

    @Autowired
    MTbtskObjectinfoService tbtskObjectinfoService;

    public void deleteByTaskId(String taskId,Long userId) throws Exception {
        GutilAssert.hasLength(taskId, "参数错误");
        TskTaskBiz taskBiz = tskTaskBizService.findByTaskId(taskId);
        GutilAssert.notNull(taskBiz, "未查到相应任务");
        GutilAssert.isTrue(!new Integer(1).equals(taskBiz.getIsPublic()), "默认任务不能删除");
        if (StringUtils.isNotBlank(taskBiz.getTableId())) {
            TbtskObjectinfo tableInfo = tbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());

            if (StringUtils.isNotBlank(tableInfo.getfTablename()) && dataBizService.isExistTableName(tableInfo.getfTablename()) && dataBizService.getCount(tableInfo.getfTablename(), " 1=1 ") > 0) {
                throw new GwValidateException("任务中存在数据不允许删除");
            }
            /*  Map<String, List<String>> dataMaps = new HashMap<>();*/
            if (taskBiz.getIsTmpl() == null || taskBiz.getIsTmpl() == 0) {
                List<String> fList = new ArrayList<>();
                fList.add("f_id");
                fList.add("f_xzqdm");
                fList.add("f_xzqdmsys");
                if (StringUtils.isNotBlank(tableInfo.getfTablename()) && dataBizService.isExistTableName(tableInfo.getfTablename())) {
                    List<Map> dataList = dataBizService.queryAllData(tableInfo.getfTablename(), fList, "");
                       /* for (Map m : dataList) {
                            String xzqdm = String.valueOf(m.get("f_xzqdm"));
                            if (dataMaps.containsKey(xzqdm)) {
                                List<String> strings = dataMaps.get(xzqdm);
                                strings.add(String.valueOf(m.get("f_id")));
                                dataMaps.put(xzqdm, strings);
                            } else {
                                List<String> list = new ArrayList<>();
                                list.add(xzqdm);
                            }
                        }*/
                    Map<String, List<String>> dataMaps = converXzqdmsys(dataList, taskBiz);
                    sendDeleteMessageNew(taskBiz, tableInfo, dataMaps, userId, null, 15);
                }
            }
        }
        // 不实际删除只是逻辑删除
        tskTaskBizService.delByTaskId(taskId);
    }
    public void deleteBatchTb(String dataIds, String taskId,Long userId) throws Exception {
        TskTaskBiz taskBiz = tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo tableInfo = tskTaskBizService.getTableByTableId(taskBiz.getTableId());

        StringBuilder builder = new StringBuilder();
        JSONArray array = JSONArray.parseArray(dataIds);
        for (int i = 0; i < array.size(); i++) {
            String string = array.getString(i);
            if (builder.length() > 0) {
                builder.append(",").append("'").append(string).append("'");
            } else {
                builder.append("'").append(string).append("'");
            }
        }
        List<String> fieldsList = new ArrayList<>();
        fieldsList.add("f_id");
        fieldsList.add("f_xzqdm");
        fieldsList.add("f_xzqdmsys");
        List<Map> dataList = dataBizService.queryAllData(tableInfo.getfTablename(), fieldsList, "f_id in (" + builder + ")");
        Map<String, List<String>> dataMaps = converXzqdmsys(dataList, taskBiz);
        sendDeleteMessageNew(taskBiz, tableInfo, dataMaps, userId, dataIds, 14);

        tskTaskBizService.deleteBatchByDataIds(dataIds,taskId);
        Integer count = dataBizService.getCount(tableInfo.getfTablename(), "");
        taskBiz.setTotal(count);
        tskTaskBizService.update(taskBiz);
    }

    public void deleteTb(String dataId,String taskId,Long userId) throws Exception {
        TskTaskBiz taskBiz = tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo tableInfo = tskTaskBizService.getTableByTableId(taskBiz.getTableId());
        JSONArray array = new JSONArray();
        array.add(dataId);

        List<String> fieldsList = new ArrayList<>();
        fieldsList.add("f_id");
        fieldsList.add("f_xzqdm");
        fieldsList.add("f_xzqdmsys");
        List<Map> dataList = dataBizService.queryAllData(tableInfo.getfTablename(), fieldsList, "f_id='" + dataId + "'");
        Map<String, List<String>> dataMaps = converXzqdmsys(dataList, taskBiz);
           /* for (Map m : dataList) {
                String xzqdm = String.valueOf(m.get("f_xzqdm"));
                if (dataMaps.containsKey(xzqdm)) {
                    List<String> strings = dataMaps.get(xzqdm);
                    strings.add(String.valueOf(m.get("f_id")));
                    dataMaps.put(xzqdm, strings);
                } else {
                    List<String> list = new ArrayList<>();
                    list.add(xzqdm);
                }
            }*/

        // 生成删除消息
        sendDeleteMessageNew(taskBiz, tableInfo, dataMaps, userId, dataId, 14);

        tskTaskBizService.deleteByDataId(dataId, taskId);

        Integer count = dataBizService.getCount(tableInfo.getfTablename(), "");
        taskBiz.setTotal(count);
        tskTaskBizService.update(taskBiz);
    }

    private void sendDeleteMessageNew(TskTaskBiz taskBiz, TbtskObjectinfo table, Map<String, List<String>> dataMaps,
                                      Long sendUser, String dataIds, Integer deleteType) throws Exception {

        TaskSendMsgNewThread thread = new TaskSendMsgNewThread(tskTaskBizService1, userBiz2Repository, taskNoticeNewService, taskBiz,
                table, dataMaps, sendUser, dataIds, deleteType);
        threadPoolTaskExecutor.execute(thread);
    }

    private Map<String, List<String>> converXzqdmsys(List<Map> dataList, TskTaskBiz taskBiz) {
        RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
        Map<String, List<String>> dataMaps = new HashMap<>();
        for (Map m : dataList) {
            String xzqdm = String.valueOf(m.get("f_xzqdmsys"));
            if (taskBiz.getGranularity() != null && taskBiz.getGranularity() == 3) { //任务粒度 为县
                xzqdm = xzqdm.substring(0, 6);
            } else if (taskBiz.getGranularity() != null && taskBiz.getGranularity() == 4) { //镇
                xzqdm = xzqdm.substring(0, 9);
                RegionTown regionTown = regionTownRepository.getByCodeAndVersion(xzqdm, defaultVersion != null ? defaultVersion.getVersion() : "2018");
                if (regionTown == null) {
                    xzqdm = xzqdm.substring(0, 6);
                }
            } else if (taskBiz.getGranularity() != null && taskBiz.getGranularity() == 5) {//村
                xzqdm = (String) m.get("f_xzqdmsys");
                RegionVillage village = regionVillageRepository.getByCodeAndVersion(xzqdm, defaultVersion != null ? defaultVersion.getVersion() : "2018");
                if (village == null) {
                    xzqdm = xzqdm.substring(0, 6);
                }
            } else {
                xzqdm = xzqdm.substring(0, 6);
            }
            if (dataMaps.containsKey(xzqdm)) {
                List<String> strings = dataMaps.get(xzqdm);
                strings.add(String.valueOf(m.get("f_id")));
                dataMaps.put(xzqdm, strings);
            } else {
                List<String> list = new ArrayList<>();
                list.add(String.valueOf(m.get("f_id")));
                dataMaps.put(xzqdm, list);
            }
        }

        return dataMaps;
    }

}
