package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TaskNoticeRepository;
import com.geoway.landteam.customtask.repository.task.TaskNoticeUserRepository;
import com.geoway.landteam.customtask.task.entity.TaskNotice;
import com.geoway.landteam.customtask.task.entity.TaskNoticeST;
import com.geoway.landteam.customtask.task.entity.TaskNoticeUser;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.pub.dto.TaskBizDTO;
import com.geoway.landteam.landcloud.core.model.pub.dto.TaskNoticeDTO;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;

import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;


@Service
@Transactional(rollbackFor = Exception.class)
public class MTaskNoticeService {

    @Autowired
    TaskNoticeRepository taskNoticeDao;

    @Autowired
    TaskNoticeUserRepository taskNoticeUserDao;

    @Autowired
    LandUserRepository landtaskNoticeUserDao;

    public Page<TaskNotice> queryByFilter(String filterParam, String sortParam, int start, int limit) {
        Page<TaskNotice> results = taskNoticeDao.findAll(new QuerySpecification<TaskNotice>(filterParam),
                PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));

        return results;
    }

    public List<TaskNoticeUser> findUserNoticeByFilter(String filterParam) {
        List<TaskNoticeUser> userNotices = taskNoticeUserDao.findAll(new QuerySpecification<TaskNoticeUser>(filterParam));
        return userNotices;
    }


    public void deleteTaskNoticeByIds(String ids) {
        String[] id = ids.split(",");
        for (int i = 0; i < id.length; i++) {
            if (!id[i].isEmpty()) {
                taskNoticeDao.deleteById(id[i]);
                taskNoticeUserDao.delUserByNoticeId(id[i]);
            }
        }
    }

    public TaskNotice save(TaskNotice notice) {
        return taskNoticeDao.save(notice);
    }

    public Iterable<TaskNotice> saveList(List<TaskNotice> noticeList) {
        return taskNoticeDao.saveAll(noticeList);
    }

    public TaskNoticeUser save(TaskNoticeUser user) {
        return taskNoticeUserDao.save(user);
    }

    public Iterable<TaskNoticeUser> saveTaskNoticeUserList(List<TaskNoticeUser> userList) {
        return taskNoticeUserDao.saveAll(userList);
    }

    public void addTextNotice(String title, String content, long sendUserId, long receiveUserId) {

        TaskNotice notice = new TaskNotice();
        notice.setTitle(title);
        notice.setSendTime(new Date());
        notice.setSendUser(sendUserId);
        notice.setState(1);
        notice.setType(1);
        notice.setContent(content);

        notice = taskNoticeDao.save(notice);

        TaskNoticeUser noticeUser = new TaskNoticeUser();
        noticeUser.setNoticeId(notice.getId());
        noticeUser.setUserId(String.valueOf(receiveUserId));
        noticeUser.setState(0);
        taskNoticeUserDao.save(noticeUser);
    }

    public TaskNotice addTaskNotice(String title, String content, long sendUserId,
                                    int state, int type, String receiveIds, String xzqdm, int action) {
        Date time = new Date();
        TaskNotice taskNotice = null;

        TaskNotice notice = new TaskNotice();
        notice.setTitle(title);
        notice.setSendTime(time);
        notice.setSendUser(sendUserId);
        notice.setState(state);
        notice.setType(type);
        notice.setRegion(xzqdm);
        notice.setAction(action);

        if (type == 3) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] ids = content.split(",");
            for (int j = 0; j < ids.length; j++) {
                arrayList.add(ids[j]);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("tag", 1);
            jsonObject.put("data", arrayList);

            notice.setContent(jsonObject.toString());
        } else {
            notice.setContent(content);
        }

        taskNotice = taskNoticeDao.save(notice);

        String[] receiveId = receiveIds.split(",");
        String noticeId = taskNotice.getId();
        for (int i = 0; i < receiveId.length; i++) {
            if (!receiveId[i].isEmpty()) {
                long userId = Long.parseLong(receiveId[i]);
                TaskNoticeUser noticeUser = new TaskNoticeUser();
                noticeUser.setNoticeId(noticeId);
                noticeUser.setUserId(String.valueOf(userId));
                noticeUser.setState(0);
                taskNoticeUserDao.save(noticeUser);
            }
        }

        return taskNotice;
    }

    public void updateTaskNotice(String noticeId, String title, String content, int state, String receiveIds) {
        Date time = new Date();
        taskNoticeDao.updateTaskNoticeById(title, content, time, state, noticeId);
        taskNoticeUserDao.delUserByNoticeId(noticeId);
        String[] receiveId = receiveIds.split(",");
        for (int i = 0; i < receiveId.length; i++) {
            if (!receiveId[i].isEmpty()) {
                long userId = Long.parseLong(receiveId[i]);
                TaskNoticeUser noticeUser = new TaskNoticeUser();
                noticeUser.setNoticeId(noticeId);
                noticeUser.setUserId(String.valueOf(userId));
                noticeUser.setState(0);
                taskNoticeUserDao.save(noticeUser);
            }
        }
    }


    //获取统计数据
    public Map getNavStatistics(Long userId, String params) {
        Map<String, Integer> map = new HashMap<String, Integer>();
        if (params != null && !params.isEmpty()) {
            String[] temp = params.split(",");
            for (int i = 0; i < temp.length; i++) {
                List<Integer> type = new ArrayList<Integer>();
                int count = 0;
                if (temp[i].equals("send")) {
                    type.add(1);
                    type.add(4);
                    count = taskNoticeDao.queryCountByStateType(userId, 1, type);
                } else if (temp[i].equals("received")) {
                    count = taskNoticeUserDao.queryCountByUserId(userId);
                } else if (temp[i].equals("draft")) {
                    type.add(1);
                    count = taskNoticeDao.queryCountByStateType(userId, 0, type);
                }
                map.put(temp[i], count);
            }
        }

        return map;
    }

    public void addAssignNotice2User(String layerId, String layerName, List<String> ids,
                                     Long sendUser, Long wyry, String title, String content,
                                     String xzqdm, Integer action) {

        Date now = new Date();
        TaskNotice notice = new TaskNotice();
        notice.setTitle(title);
        notice.setSendTime(now);
        notice.setSendUser(sendUser);
        notice.setState(1);
        notice.setType(1);
        notice.setContent(content);
        notice.setRegion(xzqdm);
        notice.setAction(action);

        if (ids != null && ids.size() > 0) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("time", now.getTime());
            jsonObject.put("layerId", layerId);
            jsonObject.put("layerName", layerName);
            jsonObject.put("arr", ids);
            notice.setData(jsonObject.toString());
        }

        TaskNotice taskNotice = taskNoticeDao.save(notice);

        TaskNoticeUser noticeUser = new TaskNoticeUser();
        noticeUser.setNoticeId(taskNotice.getId());
        noticeUser.setUserId(String.valueOf(wyry));
        noticeUser.setState(0);
        taskNoticeUserDao.save(noticeUser);
    }

    public List<TaskNoticeDTO> getMyTaskNoticeList(Long userId, String oriType) {
        List<TaskNoticeDTO> taskNotices = new ArrayList<>();
        List<TaskNoticeUser> taskNoticeUsers = taskNoticeUserDao.queryByUserIdAndOriType(userId.toString(), "%\"oriType\":\"" + oriType + "\"%");
        if (taskNoticeUsers == null || taskNoticeUsers.isEmpty()) {
            return taskNotices;
        }
        String noticeId;
        TaskNotice taskNotice = null;
        for (TaskNoticeUser taskNoticeUser : taskNoticeUsers) {
            noticeId = taskNoticeUser.getNoticeId();
            if (StringUtils.isNotBlank(noticeId)) {
                taskNotice = taskNoticeDao.findById(noticeId).orElse(null);
            }
            if (taskNotice != null) {
                TaskNoticeDTO taskNoticeDTO = new TaskNoticeDTO();
                BeanUtil.copyProperties(taskNotice, taskNoticeDTO);
                taskNotices.add(taskNoticeDTO);
            }
        }
        return taskNotices;
    }

    public List<TaskNoticeDTO> getTaskNotices(String region, String bizId, String startDate, String endDate) {
        List<TaskNoticeDTO> rlist = new ArrayList<>();
        try {
            List<TaskNotice> list = new ArrayList<>();
            if (StringUtils.isNotBlank(startDate) && StringUtils.isNotBlank(endDate)) {
                Date start = new Date(Long.parseLong(startDate));
                Date end = new Date(Long.parseLong(endDate));

                list = taskNoticeDao.queryByRegionAndBizId(region, bizId, start, end, "1");
            } else {
                list = taskNoticeDao.queryByRegionAndBizId(region, bizId, "1");
            }
            for (TaskNotice tn : list) {
                TaskNoticeDTO tnd = new TaskNoticeDTO();
                BeanUtil.copyProperties(tn, tnd);
                tnd.setRegion(tn.getRegion1());
                rlist.add(tnd);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return rlist;
    }

    public List<TaskNoticeDTO> getTaskNoticesByUserId(String userid, String bizId, String startDate, String endDate) {
        List<TaskNoticeDTO> rlist = new ArrayList<>();
        try {
            List<TaskNoticeUser> list = new ArrayList<>();
            if (StringUtils.isNotBlank(startDate) && !"0".equals(startDate) && StringUtils.isNotBlank(endDate)) {
                Date start = new Date(Long.parseLong(startDate));
                Date end = new Date(Long.parseLong(endDate));

                list = taskNoticeUserDao.queryByUserIdAndBizId(userid, start, end);
            } else {
                list = taskNoticeUserDao.queryByUserIdAndBizId(userid);
            }
            for (TaskNoticeUser tn : list) {
                if (tn.getNotice() == null) continue;
                if (!bizId.equalsIgnoreCase(tn.getNotice().getBizId())) {
                    continue;
                }
                TaskNoticeDTO tnd = new TaskNoticeDTO();
                BeanUtil.copyProperties(tn.getNotice(), tnd);
                tnd.setUserData(tn.getData());
                rlist.add(tnd);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return rlist;
    }

    public List<TaskBizDTO> getTaskNoticeBizs(String region) {
        List<TaskBizDTO> rlist = taskNoticeDao.queryTasksByRegion(region);
        return rlist;
    }

    public List<TaskNoticeDTO> getMyTaskNoticesByUserId(String userid, String bizId, String startDate, String endDate) {
        List<TaskNoticeDTO> rlist = new ArrayList<>();
        try {
            List<TaskNoticeUser> list = new ArrayList<>();
            if (StringUtils.isNotBlank(startDate) && !"0".equals(startDate) && StringUtils.isNotBlank(endDate)) {
                Date start = new Date(Long.parseLong(startDate));
                Date end = new Date(Long.parseLong(endDate));

                list = taskNoticeUserDao.queryMyTaskByUserIdAndBizId(userid, bizId, start, end);
            } else {
                list = taskNoticeUserDao.queryMyTaskByUserIdAndBizId(userid, bizId);
            }
            for (TaskNoticeUser tn : list) {
                TaskNoticeDTO tnd = new TaskNoticeDTO();
                BeanUtil.copyProperties(tn.getNotice(), tnd);
                tnd.setUserData(tn.getData());
                rlist.add(tnd);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return rlist;
    }

    //获取每日任务的db的url路径专用
    public TaskNotice getTaskNoticeByBizId(String bizId) {
        //3表示每日任务，17表示授权操作
        List<TaskNotice> list = taskNoticeDao.findNoticByBizId(bizId, 3, 17);
        TaskNotice notice = null;
        if (list != null && list.size() > 0) {
            notice = list.get(0);
        }
        return notice;
    }

    public List<TaskNotice> getTaskNoticeByBizIdAndXzqdm(String bizId, Set<String> set) {
        //3表示每日任务，17表示授权操作
        List<String> list = new ArrayList<>();
        list.addAll(set);
        List<TaskNotice> notices = taskNoticeDao.findTaskNoticeByBizIdAndXzqdm(bizId, list);
        return notices;
    }

    public void createNoticeForUser(String xzqdm, String bizId, String userid) {
        List<TaskNotice> taskNotices = taskNoticeDao.queryByBeforeNotice(xzqdm, bizId, new Date());

        List<TaskNotice> deltaskNotices = taskNoticeDao.queryTaskDelNotice(bizId, 15);

        taskNotices.addAll(deltaskNotices);

        List<TaskNoticeUser> arrayList = new ArrayList<>();
        for (int i = 0; i < taskNotices.size(); i++) {
            String noticeId = taskNotices.get(i).getId();
            List list = taskNoticeUserDao.queryByNoticeIdAndUserId(noticeId, userid, 1);
            if (list != null && list.size() > 0) continue;

            TaskNoticeUser taskNoticeUser = new TaskNoticeUser();
            taskNoticeUser.setId(UUID.randomUUID().toString());
            taskNoticeUser.setUserId(userid);
            taskNoticeUser.setData(taskNotices.get(i).getData());
            taskNoticeUser.setNoticeId(taskNotices.get(i).getId());
            taskNoticeUser.setState(1);
            taskNoticeUser.setCreatetime(new Date());
            taskNoticeUser.setType(1);
            arrayList.add(taskNoticeUser);
        }
        taskNoticeUserDao.saveAll(arrayList);
    }

    public List<Long> queryByTaskId(String taskId) {
        return taskNoticeUserDao.queryByTaskId(taskId);
    }
}

